/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ServerMetadataCacheTestImpl;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.ServerUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Category(value={NeedsOwnMiniClusterTest.class})
public class IndexAsyncThresholdIT
extends BaseTest {
    private static final Logger logger = LoggerFactory.getLogger(IndexAsyncThresholdIT.class);
    private final String tableName = IndexAsyncThresholdIT.generateUniqueName();
    private final long rows;
    private final long columns;
    private final boolean overThreshold;
    private final Mode mode;

    public IndexAsyncThresholdIT(Long threshold, Long rows, Long columns, Long overThreshold, Long mode) throws Exception {
        this.rows = rows;
        this.columns = columns;
        boolean bl = this.overThreshold = overThreshold == 0L;
        this.mode = mode.equals(0L) ? Mode.NORMAL : (mode.equals(1L) ? Mode.ASYNC : (mode.equals(2L) ? Mode.COVERED : Mode.FUNCTIONAL));
    }

    @Parameterized.Parameters
    public static synchronized Collection<Long[]> primeNumbers() {
        return Arrays.asList({100000L, 5000L, 10L, 0L, 0L}, {Long.MAX_VALUE, 200L, 100L, 1L, 0L}, {0L, 20L, 10L, 1L, 0L}, {1L, 20L, 10L, 1L, 1L}, {1L, 20L, 10L, 0L, 2L}, {1L, 100L, 10L, 0L, 3L});
    }

    @Parameterized.BeforeParam
    public static synchronized void setupMiniCluster(Long threshold, Long rows, Long columns, Long overThreshold, Long mode) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        props.put("phoenix.index.async.threshold", Long.toString(threshold));
        url = IndexAsyncThresholdIT.setUpTestCluster(conf, new ReadOnlyProps(props.entrySet().iterator()));
        driver = IndexAsyncThresholdIT.initAndRegisterTestDriver(url, new ReadOnlyProps(props.entrySet().iterator()));
    }

    @Parameterized.AfterParam
    public static synchronized void tearDownMiniCluster() throws Exception {
        boolean refCountLeaked = IndexAsyncThresholdIT.isAnyStoreRefCountLeaked();
        IndexAsyncThresholdIT.destroyDriver((Driver)((Object)driver));
        try {
            HBaseTestingUtility u = new HBaseTestingUtility();
            u.shutdownMiniCluster();
        }
        catch (Throwable t) {
            logger.error("Exception caught when shutting down mini cluster", t);
        }
        finally {
            ServerMetadataCacheTestImpl.resetCache();
            ServerUtil.ConnectionFactory.shutdown();
        }
        Assert.assertFalse((String)"refCount leaked", (boolean)refCountLeaked);
    }

    @Test
    public void testAsyncIndexCreation() throws Exception {
        try (Connection connection = driver.connect(url, new Properties());){
            Statement stmt = connection.createStatement();
            String indexName = "INDEX" + this.tableName;
            this.createAndPopulateTable(connection, this.tableName, this.rows, this.columns);
            connection.createStatement().execute("UPDATE STATISTICS " + this.tableName);
            connection.commit();
            ResultSet rs = stmt.executeQuery("select count(*) from " + this.tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)this.rows, (long)rs.getInt(1));
            SQLException exception = null;
            try {
                String statement = "create index " + indexName + " ON " + this.tableName;
                if (this.mode == Mode.NORMAL || this.mode == Mode.ASYNC) {
                    statement = statement + " (col2, col5, col6, col7, col8)";
                    if (this.mode == Mode.ASYNC) {
                        statement = statement + "  ASYNC";
                    }
                } else {
                    statement = this.mode == Mode.COVERED ? statement + " (col2) INCLUDE(col5, col6, col7, col8)" : statement + " (UPPER(col2 || col4))";
                }
                stmt.execute(statement);
            }
            catch (Exception e) {
                assert (e instanceof SQLException);
                exception = (SQLException)e;
            }
            connection.commit();
            List indexes = connection.unwrap(PhoenixConnection.class).getTable(this.tableName).getIndexes();
            if (!this.overThreshold) {
                if (this.mode == Mode.ASYNC) {
                    Assert.assertEquals((Object)PIndexState.BUILDING, (Object)((PTable)indexes.get(0)).getIndexState());
                } else {
                    Assert.assertEquals((Object)PIndexState.ACTIVE, (Object)((PTable)indexes.get(0)).getIndexState());
                }
                Assert.assertNull((Object)exception);
            } else {
                Assert.assertEquals((long)0L, (long)indexes.size());
                Assert.assertNotNull((Object)exception);
                Assert.assertEquals((long)exception.getErrorCode(), (long)SQLExceptionCode.ABOVE_INDEX_NON_ASYNC_THRESHOLD.getErrorCode());
            }
        }
    }

    private void createAndPopulateTable(Connection conn, String fullTableName, Long rows, Long columns) throws SQLException {
        Statement stmt = conn.createStatement();
        StringBuilder ddl = new StringBuilder("CREATE TABLE " + fullTableName + " (col1 varchar primary key");
        int i = 2;
        while ((long)i < columns) {
            ddl.append(", col").append(i).append(" varchar");
            ++i;
        }
        ddl.append(")");
        stmt.execute(ddl.toString());
        conn.commit();
        i = 0;
        while ((long)i < rows) {
            StringBuilder dml = new StringBuilder("upsert into " + fullTableName + " values (");
            int j = 1;
            while ((long)j < columns) {
                dml.append("'col").append(j).append("VAL").append(i).append("'");
                if ((long)j < columns - 1L) {
                    dml.append(", ");
                }
                ++j;
            }
            dml.append(")");
            stmt.execute(dml.toString());
            ++i;
        }
        conn.commit();
    }

    static enum Mode {
        NORMAL,
        ASYNC,
        COVERED,
        FUNCTIONAL;

    }
}

