/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Properties;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.end2end.ParallelStatsEnabledIT;
import org.apache.phoenix.end2end.ParallelStatsEnabledTest;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsEnabledTest.class})
public class ImmutableIndexWithStatsIT
extends ParallelStatsEnabledIT {
    @Test
    public void testIndexCreationDeadlockWithStats() throws Exception {
        String tableName = ImmutableIndexWithStatsIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(ImmutableIndexWithStatsIT.getUrl(), props);
        conn.setAutoCommit(false);
        conn.createStatement().execute("CREATE TABLE " + tableName + " (k VARCHAR NOT NULL PRIMARY KEY, v VARCHAR) IMMUTABLE_ROWS=TRUE");
        String query = "SELECT * FROM " + tableName;
        ResultSet rs = conn.createStatement().executeQuery(query);
        Assert.assertFalse((boolean)rs.next());
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES(?,?)");
        for (int i = 0; i < 6; ++i) {
            stmt.setString(1, "kkkkkkkkkk" + i);
            stmt.setString(2, "vvvvvvvvvv" + i);
            stmt.execute();
        }
        conn.commit();
        conn.createStatement().execute("UPDATE STATISTICS " + tableName);
        query = "SELECT COUNT(*) FROM " + tableName;
        ExplainPlan plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
        Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
        Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
        String indexName = "I_" + ImmutableIndexWithStatsIT.generateUniqueName();
        conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + tableName + " (v)");
        query = "SELECT * FROM " + indexName;
        rs = conn.createStatement().executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
    }
}

