/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionStatesCount;
import org.apache.phoenix.end2end.IndexToolIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.hbase.index.IndexRegionObserver;
import org.apache.phoenix.iterate.ScanningResultPostDummyResultCaller;
import org.apache.phoenix.mapreduce.PhoenixJobCounters;
import org.apache.phoenix.mapreduce.index.IndexTool;
import org.apache.phoenix.mapreduce.index.PhoenixIndexToolJobCounters;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.thirdparty.com.google.common.base.Strings;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=Parameterized.class)
public class GlobalIndexCheckerWithRegionMovesIT
extends BaseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalIndexCheckerWithRegionMovesIT.class);
    private final boolean async;
    private String indexDDLOptions;
    private String tableDDLOptions;
    private StringBuilder optionBuilder;
    private StringBuilder indexOptionBuilder;
    private final boolean encoded;
    private static boolean hasTestStarted = false;
    private static int countOfDummyResults = 0;
    private static final Set<String> TABLE_NAMES = new HashSet<String>();

    public GlobalIndexCheckerWithRegionMovesIT(boolean async, boolean encoded) {
        this.async = async;
        this.encoded = encoded;
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("phoenix.max.lookback.age.seconds", Integer.toString(3600));
        props.put("phoenix.use.stats.parallelization", Boolean.toString(false));
        props.put("phoenix.server.page.size.ms", Long.toString(0L));
        props.put("phoenix.tests.minicluster.numregionservers", String.valueOf(2));
        props.put("hbase.client.scanner.max.result.size", String.valueOf(1));
        props.put("phoenix.scanning.result.post.dummy.process", TestScanningResultPostDummyResultCaller.class.getName());
        props.put("phoenix.global.index.row.age.threshold.to.delete.ms", Long.toString(0L));
        GlobalIndexCheckerWithRegionMovesIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    protected static void moveRegionsOfTable(String tableName) throws IOException {
        List regionsOnServer2;
        List regionsOnServer1;
        Admin admin = GlobalIndexCheckerWithRegionMovesIT.getUtility().getAdmin();
        ArrayList servers = new ArrayList(admin.getRegionServers());
        ServerName server1 = (ServerName)servers.get(0);
        ServerName server2 = (ServerName)servers.get(1);
        try {
            regionsOnServer1 = admin.getRegions(server1);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            regionsOnServer2 = admin.getRegions(server2);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        regionsOnServer1.forEach(regionInfo -> {
            if (regionInfo.getTable().equals((Object)TableName.valueOf((String)tableName))) {
                try {
                    for (int i = 0; i < 2; ++i) {
                        RegionStatesCount regionStatesCount = (RegionStatesCount)admin.getClusterMetrics().getTableRegionStatesCount().get(TableName.valueOf((String)tableName));
                        if (regionStatesCount.getRegionsInTransition() == 0 && regionStatesCount.getOpenRegions() == regionStatesCount.getTotalRegions()) {
                            LOGGER.info("Moving region {} to {}", (Object)regionInfo.getRegionNameAsString(), (Object)server2);
                            admin.move(regionInfo.getEncodedNameAsBytes(), server2);
                            break;
                        }
                        LOGGER.info("Table {} has some region(s) in RIT or not online", (Object)tableName);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        regionsOnServer2.forEach(regionInfo -> {
            if (regionInfo.getTable().equals((Object)TableName.valueOf((String)tableName))) {
                try {
                    for (int i = 0; i < 2; ++i) {
                        RegionStatesCount regionStatesCount = (RegionStatesCount)admin.getClusterMetrics().getTableRegionStatesCount().get(TableName.valueOf((String)tableName));
                        if (regionStatesCount.getRegionsInTransition() == 0 && regionStatesCount.getOpenRegions() == regionStatesCount.getTotalRegions()) {
                            admin.move(regionInfo.getEncodedNameAsBytes(), server1);
                            LOGGER.info("Moving region {} to {}", (Object)regionInfo.getRegionNameAsString(), (Object)server1);
                            break;
                        }
                        LOGGER.info("Table {} has some region(s) in RIT or not online", (Object)tableName);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Before
    public void beforeTest() {
        hasTestStarted = true;
        this.optionBuilder = new StringBuilder();
        this.indexOptionBuilder = new StringBuilder();
        if (!this.encoded) {
            this.optionBuilder.append(" COLUMN_ENCODED_BYTES=0");
        } else {
            this.indexOptionBuilder.append(" IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
        }
        this.tableDDLOptions = this.optionBuilder.toString();
        this.indexDDLOptions = this.indexOptionBuilder.toString();
    }

    @Parameterized.Parameters(name="async={0},encoded={1}")
    public static synchronized Collection<Object[]> data() {
        boolean[] values;
        ArrayList list = Lists.newArrayListWithExpectedSize((int)4);
        for (boolean async : values = new boolean[]{true, false}) {
            for (boolean encoded : values) {
                list.add(new Object[]{async, encoded});
            }
        }
        return list;
    }

    @After
    public void unsetFailForTesting() throws Exception {
        countOfDummyResults = 0;
        TABLE_NAMES.clear();
        hasTestStarted = false;
        boolean refCountLeaked = GlobalIndexCheckerWithRegionMovesIT.isAnyStoreRefCountLeaked();
        IndexRegionObserver.setFailPreIndexUpdatesForTesting((boolean)false);
        IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
        IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)false);
        Assert.assertFalse((String)"refCount leaked", (boolean)refCountLeaked);
    }

    public static void assertExplainPlan(Connection conn, String selectSql, String dataTableFullName, String indexTableFullName) throws SQLException {
        ResultSet rs = conn.createStatement().executeQuery("EXPLAIN " + selectSql);
        String actualExplainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
        IndexToolIT.assertExplainPlan(false, actualExplainPlan, dataTableFullName, indexTableFullName);
    }

    public static void assertExplainPlanWithLimit(Connection conn, String selectSql, String dataTableFullName, String indexTableFullName, int limit) throws SQLException {
        ResultSet rs = conn.createStatement().executeQuery("EXPLAIN " + selectSql);
        String actualExplainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
        IndexToolIT.assertExplainPlan(false, actualExplainPlan, dataTableFullName, indexTableFullName);
        String expectedLimitPlan = String.format("SERVER %d ROW LIMIT", limit);
        Assert.assertTrue((String)(actualExplainPlan + "\n expected to contain \n" + expectedLimitPlan), (boolean)actualExplainPlan.contains(expectedLimitPlan));
    }

    private void populateTable(String tableName) throws Exception {
        Connection conn = DriverManager.getConnection(GlobalIndexCheckerWithRegionMovesIT.getUrl());
        conn.createStatement().execute("create table " + tableName + " (id varchar(10) not null primary key, val1 varchar(10), val2 varchar(10), val3 varchar(10))" + this.tableDDLOptions);
        conn.createStatement().execute("upsert into " + tableName + " values ('a', 'ab', 'abc', 'abcd')");
        conn.commit();
        conn.createStatement().execute("upsert into " + tableName + " values ('b', 'bc', 'bcd', 'bcde')");
        conn.commit();
        conn.close();
    }

    @Test
    public void testDelete() throws Exception {
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerWithRegionMovesIT.getUrl());){
            String dataTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
            this.populateTable(dataTableName);
            String dml = "DELETE from " + dataTableName + " WHERE id  = 'a'";
            Assert.assertEquals((long)1L, (long)conn.createStatement().executeUpdate(dml));
            conn.commit();
            String indexTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (val1) include (val2, val3)" + (this.async ? "ASYNC" : "") + this.indexDDLOptions);
            TABLE_NAMES.add(dataTableName);
            TABLE_NAMES.add(indexTableName);
            if (this.async) {
                IndexToolIT.runIndexTool(false, null, dataTableName, indexTableName);
            }
            String query = "SELECT COUNT(*) from " + indexTableName;
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            GlobalIndexCheckerWithRegionMovesIT.verifyTableHealth(conn, dataTableName, indexTableName);
        }
    }

    @Test
    public void testPhoenixRowTimestamp() throws Exception {
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerWithRegionMovesIT.getUrl());){
            String dataTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
            String indexTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
            TABLE_NAMES.add(dataTableName);
            TABLE_NAMES.add(indexTableName);
            Timestamp initial = new Timestamp(EnvironmentEdgeManager.currentTimeMillis() - 1L);
            conn.createStatement().execute("create table " + dataTableName + " (id varchar(10) not null primary key, val1 varchar(10), val2 varchar(10), val3 varchar(10))" + this.tableDDLOptions);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('a', 'ab', 'abc', 'abcd')");
            conn.commit();
            Timestamp before = new Timestamp(EnvironmentEdgeManager.currentTimeMillis());
            Thread.sleep(1L);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('b', 'bc', 'bcd', 'bcde')");
            conn.commit();
            Timestamp after = new Timestamp(EnvironmentEdgeManager.currentTimeMillis() + 1L);
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (val1, PHOENIX_ROW_TIMESTAMP()) include (val2, val3) " + (this.async ? "ASYNC" : "") + this.indexDDLOptions);
            if (this.async) {
                IndexToolIT.runIndexTool(false, null, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.AFTER, new String[0]);
            }
            String timeZoneID = Calendar.getInstance().getTimeZone().getID();
            String query = "SELECT  val1, val2, PHOENIX_ROW_TIMESTAMP() from " + dataTableName + " WHERE val1 = 'bc' AND PHOENIX_ROW_TIMESTAMP() > TO_DATE('" + before.toString() + "','yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "') AND PHOENIX_ROW_TIMESTAMP() < TO_DATE('" + after.toString() + "','yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "')";
            GlobalIndexCheckerWithRegionMovesIT.assertExplainPlan(conn, query, dataTableName, indexTableName);
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"bc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bcd", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.getTimestamp(3).after(before));
            Assert.assertTrue((boolean)rs.getTimestamp(3).before(after));
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("SELECT COUNT(*) from " + indexTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Thread.sleep(1L);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('c', 'bc', 'ccc', 'cccc')");
            conn.commit();
            GlobalIndexCheckerWithRegionMovesIT.assertExplainPlan(conn, query, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"bc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bcd", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.getTimestamp(3).after(before));
            Assert.assertTrue((boolean)rs.getTimestamp(3).before(after));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT  val1, val2, PHOENIX_ROW_TIMESTAMP() from " + dataTableName + " WHERE val1 = 'bc' AND PHOENIX_ROW_TIMESTAMP() > TO_DATE('" + after.toString() + "','yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "')";
            GlobalIndexCheckerWithRegionMovesIT.assertExplainPlan(conn, query, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"bc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ccc", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.getTimestamp(3).after(after));
            Assert.assertFalse((boolean)rs.next());
            String noIndexQuery = "SELECT /*+ NO_INDEX */ val1, val2, PHOENIX_ROW_TIMESTAMP() from " + dataTableName + " WHERE val1 = 'bc' AND PHOENIX_ROW_TIMESTAMP() > TO_DATE('" + after.toString() + "','yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "')";
            rs = conn.createStatement().executeQuery("EXPLAIN " + noIndexQuery);
            String explainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertTrue((boolean)explainPlan.contains("FULL SCAN OVER " + dataTableName));
            rs = conn.createStatement().executeQuery(noIndexQuery);
            Assert.assertTrue((boolean)rs.next());
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"bc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ccc", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.getTimestamp(3).after(after));
            after = rs.getTimestamp(3);
            Assert.assertFalse((boolean)rs.next());
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)true);
            Thread.sleep(1L);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('d', 'de', 'def', 'defg')");
            conn.commit();
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)false);
            query = "SELECT  val1, val2, PHOENIX_ROW_TIMESTAMP()  from " + dataTableName + " WHERE val1 = 'de'";
            GlobalIndexCheckerWithRegionMovesIT.assertExplainPlan(conn, query, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"de", (Object)rs.getString(1));
            Assert.assertEquals((Object)"def", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.getTimestamp(3).after(after));
            Assert.assertFalse((boolean)rs.next());
            indexTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (PHOENIX_ROW_TIMESTAMP()) include (val1, val2, val3) " + (this.async ? "ASYNC" : "") + this.indexDDLOptions);
            if (this.async) {
                IndexToolIT.runIndexTool(false, null, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.AFTER, new String[0]);
            }
            Thread.sleep(1L);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('e', 'ae', 'efg', 'efgh')");
            conn.commit();
            query = "SELECT  val1, val2, PHOENIX_ROW_TIMESTAMP() from " + dataTableName + " WHERE PHOENIX_ROW_TIMESTAMP() > TO_DATE('" + initial.toString() + "','yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "')";
            GlobalIndexCheckerWithRegionMovesIT.assertExplainPlan(conn, query, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"ab", (Object)rs.getString(1));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"bc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bcd", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"bc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ccc", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"de", (Object)rs.getString(1));
            Assert.assertEquals((Object)"def", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"ae", (Object)rs.getString(1));
            Assert.assertEquals((Object)"efg", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            conn.createStatement().execute("DROP INDEX " + indexTableName + " on " + dataTableName);
            indexTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (PHOENIX_ROW_TIMESTAMP())" + (this.async ? "ASYNC" : "") + this.indexDDLOptions);
            if (this.async) {
                IndexToolIT.runIndexTool(false, null, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.AFTER, new String[0]);
            }
            this.assertIndexTableNotSelected(conn, dataTableName, indexTableName, query);
            query = "SELECT /*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ val1, val2, PHOENIX_ROW_TIMESTAMP() from " + dataTableName + " WHERE PHOENIX_ROW_TIMESTAMP() > TO_DATE('" + initial.toString() + "','yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "')";
            GlobalIndexCheckerWithRegionMovesIT.assertExplainPlan(conn, query, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"ab", (Object)rs.getString(1));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"bc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bcd", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ccc", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"de", (Object)rs.getString(1));
            Assert.assertEquals((Object)"def", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"ae", (Object)rs.getString(1));
            Assert.assertEquals((Object)"efg", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testDeleteNonExistingRow() throws Exception {
        if (this.async) {
            return;
        }
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerWithRegionMovesIT.getUrl());){
            String dataTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
            this.populateTable(dataTableName);
            String indexTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (val1) include (val2, val3)" + this.indexDDLOptions);
            TABLE_NAMES.add(dataTableName);
            TABLE_NAMES.add(indexTableName);
            String dml = "DELETE from " + dataTableName + " WHERE id  = 'a'";
            conn.createStatement().executeUpdate(dml);
            conn.commit();
            conn.createStatement().executeUpdate(dml);
            conn.commit();
            IndexToolIT.runIndexTool(false, "", dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.ONLY, new String[0]);
        }
    }

    @Test
    public void testIndexRowWithoutEmptyColumn() throws Exception {
        long scn;
        if (this.async) {
            return;
        }
        String dataTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
        String indexTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
        TABLE_NAMES.add(dataTableName);
        TABLE_NAMES.add(indexTableName);
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerWithRegionMovesIT.getUrl());){
            this.populateTable(dataTableName);
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (val1) include (val2, val3)" + this.indexDDLOptions);
            scn = EnvironmentEdgeManager.currentTimeMillis();
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('a', 'abc','abcc', 'abccd')");
            GlobalIndexCheckerWithRegionMovesIT.commitWithException(conn);
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
            TestUtil.doMajorCompaction(conn, indexTableName);
        }
        Properties props = new Properties();
        props.setProperty("CurrentSCN", Long.toString(scn));
        try (Connection connWithSCN = DriverManager.getConnection(GlobalIndexCheckerWithRegionMovesIT.getUrl(), props);){
            String selectSql = "SELECT * from " + dataTableName + " WHERE val1  = 'ab'";
            GlobalIndexCheckerWithRegionMovesIT.assertExplainPlan(connWithSCN, selectSql, dataTableName, indexTableName);
            ResultSet rs = connWithSCN.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ab", (Object)rs.getString(2));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(3));
            Assert.assertEquals((Object)"abcd", (Object)rs.getString(4));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testLimitWithUnverifiedRows() throws Exception {
        if (this.async) {
            return;
        }
        String dataTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
        this.populateTable(dataTableName);
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerWithRegionMovesIT.getUrl());){
            String indexTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (val1) include (val2, val3)" + this.indexDDLOptions);
            TABLE_NAMES.add(dataTableName);
            TABLE_NAMES.add(indexTableName);
            conn.commit();
            conn.createStatement().execute("UPSERT INTO " + indexTableName + " SELECT * FROM " + indexTableName);
            conn.commit();
            String selectSql = "SELECT * from " + indexTableName + " LIMIT 1";
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"ab", (Object)rs.getString(1));
            Assert.assertEquals((Object)"a", (Object)rs.getString(2));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(3));
            Assert.assertEquals((Object)"abcd", (Object)rs.getString(4));
            Assert.assertFalse((boolean)rs.next());
            selectSql = "SELECT val3 from " + dataTableName + " WHERE val1 = 'bc' LIMIT 1";
            GlobalIndexCheckerWithRegionMovesIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"bcde", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2) values ('c', 'aa','cde')");
            GlobalIndexCheckerWithRegionMovesIT.commitWithException(conn);
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
            selectSql = "SELECT * from " + indexTableName + " LIMIT 1";
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"ab", (Object)rs.getString(1));
            Assert.assertEquals((Object)"a", (Object)rs.getString(2));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(3));
            Assert.assertEquals((Object)"abcd", (Object)rs.getString(4));
            Assert.assertFalse((boolean)rs.next());
            GlobalIndexCheckerWithRegionMovesIT.verifyTableHealth(conn, dataTableName, indexTableName);
        }
    }

    private void assertIndexTableNotSelected(Connection conn, String dataTableName, String indexTableName, String sql) throws Exception {
        try {
            GlobalIndexCheckerWithRegionMovesIT.assertExplainPlan(conn, sql, dataTableName, indexTableName);
            throw new AssertionError((Object)"The index table should not be selected without an index hint");
        }
        catch (AssertionError assertionError) {
            return;
        }
    }

    @Test
    public void testSimulateConcurrentUpdates() throws Exception {
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerWithRegionMovesIT.getUrl());){
            String dataTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
            TABLE_NAMES.add(dataTableName);
            this.populateTable(dataTableName);
            String indexTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (val1) include (val2, val3)" + (this.async ? "ASYNC" : "") + this.indexDDLOptions);
            TABLE_NAMES.add(indexTableName);
            if (this.async) {
                IndexToolIT.runIndexTool(false, null, dataTableName, indexTableName);
            }
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val2) values ('a', 'abcc')");
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1) values ('a', 'aa')");
            conn.commit();
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val3) values ('a', null, null)");
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1) values ('a', 'ab')");
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1) values ('b', 'ab')");
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2) values ('b', 'ab', null)");
            conn.commit();
            ResultSet rs = conn.createStatement().executeQuery("SELECT * from " + indexTableName);
            Assert.assertTrue((boolean)rs.next());
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"ab", (Object)rs.getString(1));
            Assert.assertEquals((Object)"a", (Object)rs.getString(2));
            Assert.assertEquals((Object)"abcc", (Object)rs.getString(3));
            Assert.assertNull((Object)rs.getString(4));
            Assert.assertTrue((boolean)rs.next());
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"ab", (Object)rs.getString(1));
            Assert.assertEquals((Object)"b", (Object)rs.getString(2));
            Assert.assertNull((Object)rs.getString(3));
            Assert.assertEquals((Object)"bcde", (Object)rs.getString(4));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testFailPostIndexDeleteUpdate() throws Exception {
        String dataTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
        this.populateTable(dataTableName);
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerWithRegionMovesIT.getUrl());){
            String indexTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (val1) include (val2, val3)" + (this.async ? "ASYNC" : "") + this.indexDDLOptions);
            TABLE_NAMES.add(dataTableName);
            TABLE_NAMES.add(indexTableName);
            if (this.async) {
                IndexToolIT.runIndexTool(false, null, dataTableName, indexTableName);
            }
            String selectSql = "SELECT id from " + dataTableName + " WHERE val1  = 'ab'";
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)true);
            String dml = "DELETE from " + dataTableName + " WHERE id  = 'a'";
            Assert.assertEquals((long)1L, (long)conn.createStatement().executeUpdate(dml));
            conn.commit();
            dml = "DELETE from " + dataTableName + " WHERE val1  = 'ab'";
            Assert.assertEquals((long)0L, (long)conn.createStatement().executeUpdate(dml));
            String query = "SELECT COUNT(*) from " + indexTableName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            GlobalIndexCheckerWithRegionMovesIT.verifyTableHealth(conn, dataTableName, indexTableName);
        }
    }

    @Test
    public void testPartialRowUpdateForMutable() throws Exception {
        String dataTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
        this.populateTable(dataTableName);
        Connection conn = DriverManager.getConnection(GlobalIndexCheckerWithRegionMovesIT.getUrl());
        String indexTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
        conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (val1) include (val2, val3)" + (this.async ? "ASYNC" : "") + this.indexDDLOptions);
        TABLE_NAMES.add(dataTableName);
        TABLE_NAMES.add(indexTableName);
        if (this.async) {
            IndexToolIT.runIndexTool(false, null, dataTableName, indexTableName);
        }
        conn.createStatement().execute("upsert into " + dataTableName + " (id, val2) values ('a', 'abcc')");
        conn.commit();
        conn.createStatement().execute("upsert into " + dataTableName + " (id, val2) values ('c', 'cde')");
        conn.commit();
        String selectSql = "SELECT * from " + dataTableName + " WHERE val1  = 'ab'";
        GlobalIndexCheckerWithRegionMovesIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
        ResultSet rs = conn.createStatement().executeQuery(selectSql);
        Assert.assertTrue((boolean)rs.next());
        GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(dataTableName);
        GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexTableName);
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((Object)"ab", (Object)rs.getString(2));
        Assert.assertEquals((Object)"abcc", (Object)rs.getString(3));
        Assert.assertEquals((Object)"abcd", (Object)rs.getString(4));
        Assert.assertFalse((boolean)rs.next());
        conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val3) values ('a', 'ab', 'abcdd')");
        conn.commit();
        GlobalIndexCheckerWithRegionMovesIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
        rs = conn.createStatement().executeQuery(selectSql);
        Assert.assertTrue((boolean)rs.next());
        GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(dataTableName);
        GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexTableName);
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((Object)"ab", (Object)rs.getString(2));
        Assert.assertEquals((Object)"abcc", (Object)rs.getString(3));
        Assert.assertEquals((Object)"abcdd", (Object)rs.getString(4));
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }

    @Test
    public void testPartialRowUpdateForImmutable() throws Exception {
        if (this.async || this.encoded) {
            return;
        }
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerWithRegionMovesIT.getUrl());){
            String dataTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
            conn.createStatement().execute("create table " + dataTableName + " (id varchar(10) not null primary key, val1 varchar(10), val2 varchar(10), val3 varchar(10)) IMMUTABLE_ROWS=true, IMMUTABLE_STORAGE_SCHEME=" + PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('a', 'ab', 'abc', 'abcd')");
            conn.commit();
            String indexTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
            TABLE_NAMES.add(dataTableName);
            TABLE_NAMES.add(indexTableName);
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (val1) include (val2, val3)" + this.indexDDLOptions);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2) values ('a', 'ab', 'abcc')");
            conn.commit();
            String selectSql = "SELECT * from " + dataTableName + " WHERE val1  = 'ab'";
            GlobalIndexCheckerWithRegionMovesIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ab", (Object)rs.getString(2));
            Assert.assertEquals((Object)"abcc", (Object)rs.getString(3));
            Assert.assertEquals((Object)"abcd", (Object)rs.getString(4));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testFailPreIndexRowUpdate() throws Exception {
        String dataTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
        this.populateTable(dataTableName);
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerWithRegionMovesIT.getUrl());){
            String indexTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (val1) include (val2, val3)" + (this.async ? "ASYNC" : "") + this.indexDDLOptions);
            TABLE_NAMES.add(dataTableName);
            TABLE_NAMES.add(indexTableName);
            if (this.async) {
                IndexToolIT.runIndexTool(false, null, dataTableName, indexTableName);
            }
            IndexRegionObserver.setFailPreIndexUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val2) values ('a', 'abcc')");
            GlobalIndexCheckerWithRegionMovesIT.commitWithException(conn);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2) values ('c', 'cd','cde')");
            GlobalIndexCheckerWithRegionMovesIT.commitWithException(conn);
            IndexRegionObserver.setFailPreIndexUpdatesForTesting((boolean)false);
            String selectSql = "SELECT val2, val3 from " + dataTableName + " WHERE val1  = 'ab'";
            GlobalIndexCheckerWithRegionMovesIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"abc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"abcd", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            GlobalIndexCheckerWithRegionMovesIT.verifyTableHealth(conn, dataTableName, indexTableName);
        }
    }

    @Test
    public void testFailPostIndexRowUpdate() throws Exception {
        String dataTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
        this.populateTable(dataTableName);
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerWithRegionMovesIT.getUrl());){
            String indexTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (val1) include (val2, val3)" + (this.async ? "ASYNC" : "") + this.indexDDLOptions);
            TABLE_NAMES.add(dataTableName);
            TABLE_NAMES.add(indexTableName);
            if (this.async) {
                IndexToolIT.runIndexTool(false, null, dataTableName, indexTableName);
            }
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val2) values ('a', 'abcc')");
            conn.commit();
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2) values ('c', 'cd','cde')");
            conn.commit();
            IndexTool indexTool = IndexToolIT.runIndexTool(false, "", dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.ONLY, new String[0]);
            Assert.assertEquals((long)3L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixJobCounters.INPUT_RECORDS).getValue());
            Assert.assertEquals((long)3L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.SCANNED_DATA_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.REBUILT_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)3L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_VALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_EXPIRED_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_MISSING_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_MISSING_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_INVALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)2L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_UNVERIFIED_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_OLD_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_UNKNOWN_INDEX_ROW_COUNT).getValue());
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)false);
            String selectSql = "SELECT val2, val3 from " + dataTableName + " WHERE val1  = 'ab' and val2 = 'abcc'";
            GlobalIndexCheckerWithRegionMovesIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"abcc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"abcd", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            GlobalIndexCheckerWithRegionMovesIT.verifyTableHealth(conn, dataTableName, indexTableName);
        }
    }

    @Test
    public void testUnverifiedValuesAreNotVisible() throws Exception {
        if (this.async) {
            return;
        }
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerWithRegionMovesIT.getUrl());){
            String dataTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
            conn.createStatement().execute("create table " + dataTableName + " (id varchar(10) not null primary key, val1 varchar(10), val2 varchar(10), val3 varchar(10))" + this.tableDDLOptions);
            String indexTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (val1) include (val2, val3)" + this.indexDDLOptions);
            TABLE_NAMES.add(dataTableName);
            TABLE_NAMES.add(indexTableName);
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('a', 'ab','abc', 'abcd')");
            GlobalIndexCheckerWithRegionMovesIT.commitWithException(conn);
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2) values ('a', 'ab','abc')");
            conn.commit();
            String selectSql = "SELECT val3 from " + dataTableName + " WHERE val1  = 'ab'";
            GlobalIndexCheckerWithRegionMovesIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals(null, (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            GlobalIndexCheckerWithRegionMovesIT.verifyTableHealth(conn, dataTableName, indexTableName);
        }
    }

    @Test
    public void testUnverifiedRowRepair() throws Exception {
        if (this.async) {
            return;
        }
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerWithRegionMovesIT.getUrl());){
            String dataTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
            conn.createStatement().execute("create table " + dataTableName + " (id varchar(10) not null primary key, a.val1 varchar(10), b.val2 varchar(10), c.val3 varchar(10))" + this.tableDDLOptions);
            String indexTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (val1) include (val2, val3)" + this.indexDDLOptions);
            TABLE_NAMES.add(dataTableName);
            TABLE_NAMES.add(indexTableName);
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val3) values ('a', 'ab','abcde')");
            GlobalIndexCheckerWithRegionMovesIT.commitWithException(conn);
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
            String selectSql = "SELECT * from " + dataTableName + " WHERE val1  = 'ab'";
            GlobalIndexCheckerWithRegionMovesIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertFalse((boolean)rs.next());
            conn.createStatement().execute("upsert into " + dataTableName + " values ('a', 'ab','abc', 'abcd')");
            conn.commit();
            selectSql = "SELECT val3 from " + dataTableName + " WHERE val1  = 'ab'";
            GlobalIndexCheckerWithRegionMovesIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"abcd", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val3) values ('a', 'ab','abcde')");
            GlobalIndexCheckerWithRegionMovesIT.commitWithException(conn);
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
            for (int i = 0; i < 2; ++i) {
                selectSql = "SELECT val3 from " + dataTableName + " WHERE val1  = 'ab'";
                GlobalIndexCheckerWithRegionMovesIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
                rs = conn.createStatement().executeQuery(selectSql);
                Assert.assertTrue((boolean)rs.next());
                GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(dataTableName);
                GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexTableName);
                Assert.assertEquals((Object)"abcd", (Object)rs.getString(1));
                Assert.assertFalse((boolean)rs.next());
            }
            GlobalIndexCheckerWithRegionMovesIT.verifyTableHealth(conn, dataTableName, indexTableName);
        }
    }

    @Test
    public void testOnePhaseOverwiteFollowingTwoPhaseWrite() throws Exception {
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerWithRegionMovesIT.getUrl());){
            String dataTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
            this.populateTable(dataTableName);
            String indexTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
            conn.createStatement().execute("CREATE INDEX " + indexTableName + "1 on " + dataTableName + " (val1) include (val2, val3)" + (this.async ? "ASYNC" : "") + this.indexDDLOptions);
            conn.createStatement().execute("CREATE INDEX " + indexTableName + "2 on " + dataTableName + " (val2) include (val1, val3)" + (this.async ? "ASYNC" : "") + this.indexDDLOptions);
            TABLE_NAMES.add(dataTableName);
            TABLE_NAMES.add(indexTableName + "1");
            TABLE_NAMES.add(indexTableName + "2");
            if (this.async) {
                IndexToolIT.runIndexTool(false, null, dataTableName, indexTableName + "1");
                IndexToolIT.runIndexTool(false, null, dataTableName, indexTableName + "2");
            }
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('c', 'cd', 'cde', 'cdef')");
            conn.commit();
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('c', 'cd', 'cdee', 'cdfg')");
            GlobalIndexCheckerWithRegionMovesIT.commitWithException(conn);
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)false);
            String selectSql = "SELECT val2, val3 from " + dataTableName + " WHERE val1  = 'cd'";
            GlobalIndexCheckerWithRegionMovesIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName + "1");
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexTableName + "1");
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexTableName + "2");
            Assert.assertEquals((Object)"cde", (Object)rs.getString(1));
            Assert.assertEquals((Object)"cdef", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            GlobalIndexCheckerWithRegionMovesIT.verifyTableHealth(conn, dataTableName, indexTableName);
        }
    }

    @Test
    public void testOnePhaseOverwrite() throws Exception {
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerWithRegionMovesIT.getUrl());){
            String dataTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
            String indexTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
            TABLE_NAMES.add(dataTableName);
            TABLE_NAMES.add(indexTableName);
            this.createTableAndIndexes(conn, dataTableName, indexTableName);
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val2, val3) values ('a', 'abcc', 'abccc')");
            GlobalIndexCheckerWithRegionMovesIT.commitWithException(conn);
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)false);
            String selectSql = "SELECT val2 from " + dataTableName + " WHERE val1  = 'ab'";
            GlobalIndexCheckerWithRegionMovesIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName + "1");
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"abc", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            selectSql = "SELECT val3 from " + dataTableName + " WHERE val1  = 'ab'";
            GlobalIndexCheckerWithRegionMovesIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName + "1");
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abcd", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            selectSql = "SELECT val2, val3 from " + dataTableName + " WHERE val2  = 'abcc'";
            GlobalIndexCheckerWithRegionMovesIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName + "2");
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertFalse((boolean)rs.next());
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val2) values ('a', 'abccc')");
            GlobalIndexCheckerWithRegionMovesIT.commitWithException(conn);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val2) values ('a', 'abcccc')");
            GlobalIndexCheckerWithRegionMovesIT.commitWithException(conn);
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)false);
            selectSql = "SELECT val2, val3 from " + dataTableName + " WHERE val1  = 'ab'";
            GlobalIndexCheckerWithRegionMovesIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName + "1");
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"abc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"abcd", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            selectSql = "SELECT val2, val3 from " + dataTableName + " WHERE val2  = 'abccc'";
            GlobalIndexCheckerWithRegionMovesIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName + "2");
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertFalse((boolean)rs.next());
            selectSql = "SELECT val2, val3 from " + dataTableName + " WHERE val2  = 'abcccc'";
            GlobalIndexCheckerWithRegionMovesIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName + "2");
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertFalse((boolean)rs.next());
            GlobalIndexCheckerWithRegionMovesIT.verifyTableHealth(conn, dataTableName, indexTableName);
        }
    }

    private void createTableAndIndexes(Connection conn, String dataTableName, String indexTableName) throws Exception {
        this.createTableAndIndexes(conn, dataTableName, indexTableName, 1);
    }

    private void createTableAndIndexes(Connection conn, String dataTableName, String indexTableName, int indexVersions) throws Exception {
        this.populateTable(dataTableName);
        conn.createStatement().execute("CREATE INDEX " + indexTableName + "1 on " + dataTableName + " (val1) include (val2, val3)" + (this.async ? "ASYNC" : "") + " VERSIONS=" + indexVersions + (String)(Strings.isNullOrEmpty((String)this.indexDDLOptions) ? "" : "," + this.indexDDLOptions));
        conn.createStatement().execute("CREATE INDEX " + indexTableName + "2 on " + dataTableName + " (val2) include (val1, val3)" + (this.async ? "ASYNC" : "") + " VERSIONS=" + indexVersions + (String)(Strings.isNullOrEmpty((String)this.indexDDLOptions) ? "" : "," + this.indexDDLOptions));
        conn.commit();
        if (this.async) {
            IndexToolIT.runIndexTool(false, null, dataTableName, indexTableName + "1");
            IndexToolIT.runIndexTool(false, null, dataTableName, indexTableName + "2");
        }
    }

    @Test
    public void testFailDataTableAndPostIndexRowUpdate() throws Exception {
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerWithRegionMovesIT.getUrl());){
            String dataTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
            String indexName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
            TABLE_NAMES.add(dataTableName);
            TABLE_NAMES.add(indexName);
            this.createTableAndIndexes(conn, dataTableName, indexName);
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val2) values ('a', 'abcc')");
            GlobalIndexCheckerWithRegionMovesIT.commitWithException(conn);
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)false);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val3) values ('a', 'abcdd')");
            conn.commit();
            String selectSql = "SELECT val2, val3 from " + dataTableName + " WHERE val1  = 'ab'";
            GlobalIndexCheckerWithRegionMovesIT.assertExplainPlan(conn, selectSql, dataTableName, indexName + "1");
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexName);
            Assert.assertEquals((Object)"abc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"abcdd", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            selectSql = "SELECT val2, val3 from " + dataTableName + " WHERE val2  = 'abc'";
            GlobalIndexCheckerWithRegionMovesIT.assertExplainPlan(conn, selectSql, dataTableName, indexName + "2");
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"abcdd", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            GlobalIndexCheckerWithRegionMovesIT.verifyTableHealth(conn, dataTableName, indexName);
        }
    }

    @Test
    public void testUnverifiedIndexRowWithFilter() throws Exception {
        if (this.async) {
            return;
        }
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.server.paging.enabled", String.valueOf(false));
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerWithRegionMovesIT.getUrl(), props);){
            ResultSet rs;
            String dataTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
            String indexName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
            TABLE_NAMES.add(dataTableName);
            TABLE_NAMES.add(indexName);
            conn.createStatement().execute("create table " + dataTableName + " (id integer primary key, name varchar, status integer, val varchar)" + this.tableDDLOptions);
            conn.commit();
            conn.createStatement().execute("create index " + indexName + " ON " + dataTableName + "(name) include (status, val)");
            conn.createStatement().execute("upsert into " + dataTableName + " values (1, 'tom', 1, 'blah')");
            conn.createStatement().execute("upsert into " + dataTableName + " values (2, 'jerry', 2, 'jee')");
            conn.commit();
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, status) values (1, 2)");
            GlobalIndexCheckerWithRegionMovesIT.commitWithException(conn);
            String selectSql = "SELECT * from " + dataTableName + " WHERE name = 'tom' AND status = 1";
            GlobalIndexCheckerWithRegionMovesIT.assertExplainPlan(conn, selectSql, dataTableName, indexName);
            try {
                rs = conn.createStatement().executeQuery(selectSql);
                try {
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((long)1L, (long)rs.getInt(1));
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            catch (AssertionError e) {
                TestUtil.dumpTable(conn, TableName.valueOf((String)indexName));
                throw e;
            }
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, status) values (1, 2)");
            GlobalIndexCheckerWithRegionMovesIT.commitWithException(conn);
            selectSql = "SELECT * from " + dataTableName + " WHERE name = 'tom' AND status = 2";
            try {
                rs = conn.createStatement().executeQuery(selectSql);
                try {
                    Assert.assertFalse((boolean)rs.next());
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            catch (AssertionError e) {
                TestUtil.dumpTable(conn, TableName.valueOf((String)indexName));
                throw e;
            }
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, name, status) values (3, 'tom', 1)");
            GlobalIndexCheckerWithRegionMovesIT.commitWithException(conn);
            selectSql = "SELECT count(*) from " + dataTableName + " WHERE name = 'tom' and  id > 1";
            GlobalIndexCheckerWithRegionMovesIT.assertExplainPlan(conn, selectSql, dataTableName, indexName);
            try {
                rs = conn.createStatement().executeQuery(selectSql);
                try {
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((long)0L, (long)rs.getInt(1));
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            catch (AssertionError e) {
                TestUtil.dumpTable(conn, TableName.valueOf((String)indexName));
                throw e;
            }
        }
    }

    @Test
    public void testUnverifiedIndexRowWithSkipScanFilter() throws Exception {
        if (this.async) {
            return;
        }
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerWithRegionMovesIT.getUrl());){
            String expectedExplainPlan;
            String actualExplainPlan;
            String dataTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
            String indexName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
            TABLE_NAMES.add(dataTableName);
            TABLE_NAMES.add(indexName);
            this.populateTable(dataTableName);
            conn.createStatement().execute("CREATE INDEX " + indexName + " on " + dataTableName + " (val1, val2) include (val3)" + this.indexDDLOptions);
            conn.commit();
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1) values ('b', 'bcc')");
            GlobalIndexCheckerWithRegionMovesIT.commitWithException(conn);
            String selectSql = "SELECT id, val1, val3 from " + dataTableName + " WHERE val1 IN ('ab', 'bcc') ";
            try (ResultSet rs = conn.createStatement().executeQuery("EXPLAIN " + selectSql);){
                actualExplainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
                expectedExplainPlan = String.format("SKIP SCAN ON 2 KEYS OVER %s", indexName);
                Assert.assertTrue((boolean)actualExplainPlan.contains(expectedExplainPlan));
            }
            try {
                rs = conn.createStatement().executeQuery(selectSql);
                try {
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((Object)"a", (Object)rs.getString("id"));
                    Assert.assertEquals((Object)"ab", (Object)rs.getString("val1"));
                    Assert.assertEquals((Object)"abcd", (Object)rs.getString("val3"));
                    GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(dataTableName);
                    GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexName);
                    Assert.assertFalse((boolean)rs.next());
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            catch (AssertionError e) {
                TestUtil.dumpTable(conn, TableName.valueOf((String)indexName));
                throw e;
            }
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val3) values ('b', 'bcdf')");
            GlobalIndexCheckerWithRegionMovesIT.commitWithException(conn);
            selectSql = "SELECT id, val3 from " + dataTableName + " WHERE val1 IN ('bc') AND val2 IN ('bcd', 'xcdf') AND val3 = 'bcde' ";
            rs = conn.createStatement().executeQuery("EXPLAIN " + selectSql);
            try {
                actualExplainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
                expectedExplainPlan = String.format("SKIP SCAN ON 2 KEYS OVER %s", indexName);
                String filter = "SERVER FILTER BY";
                Assert.assertTrue((String)String.format("actual=%s", actualExplainPlan), (boolean)actualExplainPlan.contains(expectedExplainPlan));
                Assert.assertTrue((String)String.format("actual=%s", actualExplainPlan), (boolean)actualExplainPlan.contains(filter));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            try {
                rs = conn.createStatement().executeQuery(selectSql);
                try {
                    Assert.assertTrue((boolean)rs.next());
                    GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(dataTableName);
                    GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexName);
                    Assert.assertEquals((Object)"b", (Object)rs.getString("id"));
                    Assert.assertEquals((Object)"bcde", (Object)rs.getString("val3"));
                    Assert.assertFalse((boolean)rs.next());
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            catch (AssertionError e) {
                TestUtil.dumpTable(conn, TableName.valueOf((String)indexName));
                throw e;
            }
        }
    }

    @Test
    public void testUnverifiedIndexRowWithFirstKeyOnlyFilter() throws Exception {
        if (this.async) {
            return;
        }
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerWithRegionMovesIT.getUrl());){
            String dataTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
            String indexName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
            TABLE_NAMES.add(dataTableName);
            TABLE_NAMES.add(indexName);
            this.populateTable(dataTableName);
            conn.createStatement().execute("CREATE INDEX " + indexName + " on " + dataTableName + " (val1, id, val2, val3) " + this.indexDDLOptions);
            conn.commit();
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val3) values ('b', 'bcdf')");
            GlobalIndexCheckerWithRegionMovesIT.commitWithException(conn);
            String selectSql = "SELECT id, val3 from " + dataTableName + " WHERE val1 = 'bc' and val2 = 'bcd' ";
            try (ResultSet rs = conn.createStatement().executeQuery("EXPLAIN " + selectSql);){
                String actualExplainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
                String expectedExplainPlan = String.format("RANGE SCAN OVER %s", indexName);
                String filter = String.format("SERVER FILTER BY %s ONLY AND", this.encoded ? "FIRST KEY" : "EMPTY COLUMN");
                Assert.assertTrue((String)String.format("actual=%s", actualExplainPlan), (boolean)actualExplainPlan.contains(expectedExplainPlan));
                Assert.assertTrue((String)String.format("actual=%s", actualExplainPlan), (boolean)actualExplainPlan.contains(filter));
            }
            try {
                rs = conn.createStatement().executeQuery(selectSql);
                try {
                    Assert.assertTrue((boolean)rs.next());
                    GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(dataTableName);
                    GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexName);
                    Assert.assertEquals((Object)"b", (Object)rs.getString("id"));
                    Assert.assertEquals((Object)"bcde", (Object)rs.getString("val3"));
                    Assert.assertFalse((boolean)rs.next());
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            catch (AssertionError e) {
                TestUtil.dumpTable(conn, TableName.valueOf((String)indexName));
                throw e;
            }
        }
    }

    @Test
    public void testViewIndexRowUpdate() throws Exception {
        if (this.async) {
            return;
        }
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerWithRegionMovesIT.getUrl());){
            String dataTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
            conn.createStatement().execute("create table " + dataTableName + " (oid varchar(10) not null, kp char(3) not null, val1 varchar(10)CONSTRAINT pk PRIMARY KEY (oid, kp)) COLUMN_ENCODED_BYTES=0, MULTI_TENANT=true");
            String viewName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
            conn.createStatement().execute("CREATE VIEW " + viewName + " (id char(10) not null, val2 varchar, val3 varchar, CONSTRAINT pk PRIMARY KEY (id)) AS SELECT * FROM " + dataTableName + " WHERE kp = '0EC'");
            String indexName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
            TABLE_NAMES.add(dataTableName);
            TABLE_NAMES.add("_IDX_" + dataTableName);
            conn.createStatement().execute("CREATE INDEX " + indexName + " on " + viewName + " (val2) include (val3)" + this.indexDDLOptions);
            Properties props = new Properties();
            props.setProperty("TenantId", "o1");
            try (Connection tenantConn = DriverManager.getConnection(GlobalIndexCheckerWithRegionMovesIT.getUrl(), props);){
                String childViewName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
                tenantConn.createStatement().execute("CREATE VIEW " + childViewName + " (zid CHAR(15)) AS SELECT * FROM " + viewName);
                String grandChildViewName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
                tenantConn.createStatement().execute("CREATE VIEW " + grandChildViewName + " (val4 CHAR(15)) AS SELECT * FROM " + childViewName);
                IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)true);
                tenantConn.createStatement().execute("upsert into " + childViewName + " (zid, id, val1, val2, val3) VALUES('z1','1', 'a1','b1','c1')");
                tenantConn.commit();
                IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)false);
                String selectSql = "select val3 from  " + childViewName + " WHERE val2  = 'b1'";
                ResultSet rs = tenantConn.createStatement().executeQuery(selectSql);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"c1", (Object)rs.getString("val3"));
                IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)true);
                tenantConn.createStatement().execute("upsert into " + grandChildViewName + " (zid, id, val2, val3, val4) VALUES('z1', '2', 'b2', 'c2', 'd1')");
                tenantConn.commit();
                IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)false);
                selectSql = "select id, val3 from  " + grandChildViewName + " WHERE val2  = 'b2'";
                rs = tenantConn.createStatement().executeQuery(selectSql);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"2", (Object)rs.getString("id"));
                Assert.assertEquals((Object)"c2", (Object)rs.getString("val3"));
            }
        }
    }

    @Test
    public void testOnDuplicateKeyWithIndex() throws Exception {
        if (this.async || this.encoded) {
            return;
        }
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerWithRegionMovesIT.getUrl());){
            String dataTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
            String indexTableName = GlobalIndexCheckerWithRegionMovesIT.generateUniqueName();
            this.populateTable(dataTableName);
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (val1) include (val2, val3)" + this.indexDDLOptions);
            TABLE_NAMES.add(dataTableName);
            TABLE_NAMES.add(indexTableName);
            conn.commit();
            String upsertSql = "UPSERT INTO " + dataTableName + " VALUES ('a') ON DUPLICATE KEY UPDATE val1 = val1 || val1, val2 = val2 || val2";
            conn.createStatement().execute(upsertSql);
            conn.commit();
            String selectSql = "SELECT * from " + dataTableName + " WHERE val1 = 'abab'";
            GlobalIndexCheckerWithRegionMovesIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"abab", (Object)rs.getString(2));
            Assert.assertEquals((Object)"abcabc", (Object)rs.getString(3));
            Assert.assertEquals((Object)"abcd", (Object)rs.getString(4));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    private static void commitWithException(Connection conn) {
        try {
            conn.commit();
            IndexRegionObserver.setFailPreIndexUpdatesForTesting((boolean)false);
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)false);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void verifyTableHealth(Connection conn, String dataTableName, String indexTableName) throws Exception {
        conn.createStatement().execute("upsert into " + dataTableName + " values ('a', 'ab', 'abc', 'abcd')");
        conn.createStatement().execute("upsert into " + dataTableName + " values ('z', 'za', 'zab', 'zabc')");
        conn.commit();
        String selectSql = "SELECT * from " + dataTableName + " WHERE val1  = 'ab'";
        GlobalIndexCheckerWithRegionMovesIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
        ResultSet rs = conn.createStatement().executeQuery(selectSql);
        Assert.assertTrue((boolean)rs.next());
        GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(dataTableName);
        GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexTableName);
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((Object)"ab", (Object)rs.getString(2));
        Assert.assertEquals((Object)"abc", (Object)rs.getString(3));
        Assert.assertEquals((Object)"abcd", (Object)rs.getString(4));
        Assert.assertFalse((boolean)rs.next());
        selectSql = "SELECT * from " + dataTableName + " WHERE val1  = 'za'";
        GlobalIndexCheckerWithRegionMovesIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
        rs = conn.createStatement().executeQuery(selectSql);
        conn.commit();
        Assert.assertTrue((boolean)rs.next());
        GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(dataTableName);
        GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(indexTableName);
        Assert.assertEquals((Object)"z", (Object)rs.getString(1));
        Assert.assertEquals((Object)"za", (Object)rs.getString(2));
        Assert.assertEquals((Object)"zab", (Object)rs.getString(3));
        Assert.assertEquals((Object)"zabc", (Object)rs.getString(4));
        Assert.assertFalse((boolean)rs.next());
    }

    private static class TestScanningResultPostDummyResultCaller
    extends ScanningResultPostDummyResultCaller {
        private TestScanningResultPostDummyResultCaller() {
        }

        public void postDummyProcess() {
            if (hasTestStarted && countOfDummyResults++ % 4 == 0 && (countOfDummyResults < 17 || countOfDummyResults > 28 && countOfDummyResults < 40)) {
                LOGGER.info("Moving regions of tables {}. current count of dummy results: {}", TABLE_NAMES, (Object)countOfDummyResults);
                TABLE_NAMES.forEach(table -> {
                    try {
                        GlobalIndexCheckerWithRegionMovesIT.moveRegionsOfTable(table);
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to move regions of table: {}", table);
                    }
                });
            }
        }
    }
}

