/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.phoenix.end2end.IndexToolIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.hbase.index.IndexRegionObserver;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.mapreduce.PhoenixJobCounters;
import org.apache.phoenix.mapreduce.index.IndexTool;
import org.apache.phoenix.mapreduce.index.PhoenixIndexToolJobCounters;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.thirdparty.com.google.common.base.Strings;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=Parameterized.class)
public class GlobalIndexCheckerIT
extends BaseTest {
    private final boolean async;
    private String indexDDLOptions;
    private String tableDDLOptions;
    private StringBuilder optionBuilder;
    private StringBuilder indexOptionBuilder;
    private final boolean encoded;

    public GlobalIndexCheckerIT(boolean async, boolean encoded) {
        this.async = async;
        this.encoded = encoded;
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        props.put("phoenix.global.index.row.age.threshold.to.delete.ms", Long.toString(0L));
        GlobalIndexCheckerIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @Before
    public void beforeTest() {
        this.optionBuilder = new StringBuilder();
        this.indexOptionBuilder = new StringBuilder();
        if (!this.encoded) {
            this.optionBuilder.append(" COLUMN_ENCODED_BYTES=0");
        } else {
            this.indexOptionBuilder.append(" IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
        }
        this.tableDDLOptions = this.optionBuilder.toString();
        this.indexDDLOptions = this.indexOptionBuilder.toString();
    }

    @Parameterized.Parameters(name="async={0},encoded={1}")
    public static synchronized Collection<Object[]> data() {
        boolean[] Booleans;
        ArrayList list = Lists.newArrayListWithExpectedSize((int)4);
        for (boolean async : Booleans = new boolean[]{true, false}) {
            for (boolean encoded : Booleans) {
                list.add(new Object[]{async, encoded});
            }
        }
        return list;
    }

    @After
    public void unsetFailForTesting() throws Exception {
        boolean refCountLeaked = GlobalIndexCheckerIT.isAnyStoreRefCountLeaked();
        IndexRegionObserver.setFailPreIndexUpdatesForTesting((boolean)false);
        IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
        IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)false);
        Assert.assertFalse((String)"refCount leaked", (boolean)refCountLeaked);
    }

    public static void assertExplainPlan(Connection conn, String selectSql, String dataTableFullName, String indexTableFullName) throws SQLException {
        ResultSet rs = conn.createStatement().executeQuery("EXPLAIN " + selectSql);
        String actualExplainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
        IndexToolIT.assertExplainPlan(false, actualExplainPlan, dataTableFullName, indexTableFullName);
    }

    public static void assertExplainPlanWithLimit(Connection conn, String selectSql, String dataTableFullName, String indexTableFullName, int limit) throws SQLException {
        ResultSet rs = conn.createStatement().executeQuery("EXPLAIN " + selectSql);
        String actualExplainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
        IndexToolIT.assertExplainPlan(false, actualExplainPlan, dataTableFullName, indexTableFullName);
        String expectedLimitPlan = String.format("SERVER %d ROW LIMIT", limit);
        Assert.assertTrue((String)(actualExplainPlan + "\n expected to contain \n" + expectedLimitPlan), (boolean)actualExplainPlan.contains(expectedLimitPlan));
    }

    private void populateTable(String tableName) throws Exception {
        Connection conn = DriverManager.getConnection(GlobalIndexCheckerIT.getUrl());
        conn.createStatement().execute("create table " + tableName + " (id varchar(10) not null primary key, val1 varchar(10), val2 varchar(10), val3 varchar(10))" + this.tableDDLOptions);
        conn.createStatement().execute("upsert into " + tableName + " values ('a', 'ab', 'abc', 'abcd')");
        conn.commit();
        conn.createStatement().execute("upsert into " + tableName + " values ('b', 'bc', 'bcd', 'bcde')");
        conn.commit();
        conn.close();
    }

    @Test
    public void testDelete() throws Exception {
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerIT.getUrl());){
            String dataTableName = GlobalIndexCheckerIT.generateUniqueName();
            this.populateTable(dataTableName);
            String dml = "DELETE from " + dataTableName + " WHERE id  = 'a'";
            Assert.assertEquals((long)1L, (long)conn.createStatement().executeUpdate(dml));
            conn.commit();
            String indexTableName = GlobalIndexCheckerIT.generateUniqueName();
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (val1) include (val2, val3)" + (this.async ? "ASYNC" : "") + this.indexDDLOptions);
            if (this.async) {
                IndexToolIT.runIndexTool(false, null, dataTableName, indexTableName);
            }
            String query = "SELECT COUNT(*) from " + indexTableName;
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            GlobalIndexCheckerIT.verifyTableHealth(conn, dataTableName, indexTableName);
        }
    }

    @Test
    public void testPhoenixRowTimestamp() throws Exception {
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerIT.getUrl());){
            String dataTableName = GlobalIndexCheckerIT.generateUniqueName();
            String indexTableName = GlobalIndexCheckerIT.generateUniqueName();
            Timestamp initial = new Timestamp(EnvironmentEdgeManager.currentTimeMillis() - 1L);
            conn.createStatement().execute("create table " + dataTableName + " (id varchar(10) not null primary key, val1 varchar(10), val2 varchar(10), val3 varchar(10))" + this.tableDDLOptions);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('a', 'ab', 'abc', 'abcd')");
            conn.commit();
            Timestamp before = new Timestamp(EnvironmentEdgeManager.currentTimeMillis());
            Thread.sleep(1L);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('b', 'bc', 'bcd', 'bcde')");
            conn.commit();
            Timestamp after = new Timestamp(EnvironmentEdgeManager.currentTimeMillis() + 1L);
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (val1, PHOENIX_ROW_TIMESTAMP()) include (val2, val3) " + (this.async ? "ASYNC" : "") + this.indexDDLOptions);
            if (this.async) {
                IndexToolIT.runIndexTool(false, null, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.AFTER, new String[0]);
            }
            String timeZoneID = Calendar.getInstance().getTimeZone().getID();
            String query = "SELECT  val1, val2, PHOENIX_ROW_TIMESTAMP() from " + dataTableName + " WHERE val1 = 'bc' AND PHOENIX_ROW_TIMESTAMP() > TO_DATE('" + before.toString() + "','yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "') AND PHOENIX_ROW_TIMESTAMP() < TO_DATE('" + after.toString() + "','yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "')";
            GlobalIndexCheckerIT.assertExplainPlan(conn, query, dataTableName, indexTableName);
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bcd", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.getTimestamp(3).after(before));
            Assert.assertTrue((boolean)rs.getTimestamp(3).before(after));
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("SELECT COUNT(*) from " + indexTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Thread.sleep(1L);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('c', 'bc', 'ccc', 'cccc')");
            conn.commit();
            GlobalIndexCheckerIT.assertExplainPlan(conn, query, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bcd", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.getTimestamp(3).after(before));
            Assert.assertTrue((boolean)rs.getTimestamp(3).before(after));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT  val1, val2, PHOENIX_ROW_TIMESTAMP() from " + dataTableName + " WHERE val1 = 'bc' AND PHOENIX_ROW_TIMESTAMP() > TO_DATE('" + after.toString() + "','yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "')";
            GlobalIndexCheckerIT.assertExplainPlan(conn, query, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ccc", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.getTimestamp(3).after(after));
            Assert.assertFalse((boolean)rs.next());
            String noIndexQuery = "SELECT /*+ NO_INDEX */ val1, val2, PHOENIX_ROW_TIMESTAMP() from " + dataTableName + " WHERE val1 = 'bc' AND PHOENIX_ROW_TIMESTAMP() > TO_DATE('" + after.toString() + "','yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "')";
            rs = conn.createStatement().executeQuery("EXPLAIN " + noIndexQuery);
            String explainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertTrue((boolean)explainPlan.contains("FULL SCAN OVER " + dataTableName));
            rs = conn.createStatement().executeQuery(noIndexQuery);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ccc", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.getTimestamp(3).after(after));
            after = rs.getTimestamp(3);
            Assert.assertFalse((boolean)rs.next());
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)true);
            Thread.sleep(1L);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('d', 'de', 'def', 'defg')");
            conn.commit();
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)false);
            query = "SELECT  val1, val2, PHOENIX_ROW_TIMESTAMP()  from " + dataTableName + " WHERE val1 = 'de'";
            GlobalIndexCheckerIT.assertExplainPlan(conn, query, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"de", (Object)rs.getString(1));
            Assert.assertEquals((Object)"def", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.getTimestamp(3).after(after));
            Assert.assertFalse((boolean)rs.next());
            indexTableName = GlobalIndexCheckerIT.generateUniqueName();
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (PHOENIX_ROW_TIMESTAMP()) include (val1, val2, val3) " + (this.async ? "ASYNC" : "") + this.indexDDLOptions);
            if (this.async) {
                IndexToolIT.runIndexTool(false, null, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.AFTER, new String[0]);
            }
            Thread.sleep(1L);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('e', 'ae', 'efg', 'efgh')");
            conn.commit();
            query = "SELECT  val1, val2, PHOENIX_ROW_TIMESTAMP() from " + dataTableName + " WHERE PHOENIX_ROW_TIMESTAMP() > TO_DATE('" + initial.toString() + "','yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "')";
            GlobalIndexCheckerIT.assertExplainPlan(conn, query, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"ab", (Object)rs.getString(1));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bcd", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ccc", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"de", (Object)rs.getString(1));
            Assert.assertEquals((Object)"def", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"ae", (Object)rs.getString(1));
            Assert.assertEquals((Object)"efg", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            conn.createStatement().execute("DROP INDEX " + indexTableName + " on " + dataTableName);
            indexTableName = GlobalIndexCheckerIT.generateUniqueName();
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (PHOENIX_ROW_TIMESTAMP())" + (this.async ? "ASYNC" : "") + this.indexDDLOptions);
            if (this.async) {
                IndexToolIT.runIndexTool(false, null, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.AFTER, new String[0]);
            }
            this.assertIndexTableNotSelected(conn, dataTableName, indexTableName, query);
            query = "SELECT /*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ val1, val2, PHOENIX_ROW_TIMESTAMP() from " + dataTableName + " WHERE PHOENIX_ROW_TIMESTAMP() > TO_DATE('" + initial.toString() + "','yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "')";
            GlobalIndexCheckerIT.assertExplainPlan(conn, query, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"ab", (Object)rs.getString(1));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bcd", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ccc", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"de", (Object)rs.getString(1));
            Assert.assertEquals((Object)"def", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"ae", (Object)rs.getString(1));
            Assert.assertEquals((Object)"efg", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testDeleteNonExistingRow() throws Exception {
        if (this.async) {
            return;
        }
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerIT.getUrl());){
            String dataTableName = GlobalIndexCheckerIT.generateUniqueName();
            this.populateTable(dataTableName);
            String indexTableName = GlobalIndexCheckerIT.generateUniqueName();
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (val1) include (val2, val3)" + this.indexDDLOptions);
            String dml = "DELETE from " + dataTableName + " WHERE id  = 'a'";
            conn.createStatement().executeUpdate(dml);
            conn.commit();
            conn.createStatement().executeUpdate(dml);
            conn.commit();
            IndexToolIT.runIndexTool(false, "", dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.ONLY, new String[0]);
        }
    }

    @Test
    public void testIndexRowWithoutEmptyColumn() throws Exception {
        long scn;
        if (this.async) {
            return;
        }
        String dataTableName = GlobalIndexCheckerIT.generateUniqueName();
        String indexTableName = GlobalIndexCheckerIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerIT.getUrl());){
            this.populateTable(dataTableName);
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (val1) include (val2, val3)" + this.indexDDLOptions);
            scn = EnvironmentEdgeManager.currentTimeMillis();
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('a', 'abc','abcc', 'abccd')");
            GlobalIndexCheckerIT.commitWithException(conn);
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
            TestUtil.doMajorCompaction(conn, indexTableName);
        }
        Properties props = new Properties();
        props.setProperty("CurrentSCN", Long.toString(scn));
        try (Connection connWithSCN = DriverManager.getConnection(GlobalIndexCheckerIT.getUrl(), props);){
            String selectSql = "SELECT * from " + dataTableName + " WHERE val1  = 'ab'";
            GlobalIndexCheckerIT.assertExplainPlan(connWithSCN, selectSql, dataTableName, indexTableName);
            ResultSet rs = connWithSCN.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ab", (Object)rs.getString(2));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(3));
            Assert.assertEquals((Object)"abcd", (Object)rs.getString(4));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testLimitWithUnverifiedRows() throws Exception {
        if (this.async) {
            return;
        }
        String dataTableName = GlobalIndexCheckerIT.generateUniqueName();
        this.populateTable(dataTableName);
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerIT.getUrl());){
            String indexTableName = GlobalIndexCheckerIT.generateUniqueName();
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (val1) include (val2, val3)" + this.indexDDLOptions);
            conn.commit();
            conn.createStatement().execute("UPSERT INTO " + indexTableName + " SELECT * FROM " + indexTableName);
            conn.commit();
            String selectSql = "SELECT * from " + indexTableName + " LIMIT 1";
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"ab", (Object)rs.getString(1));
            Assert.assertEquals((Object)"a", (Object)rs.getString(2));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(3));
            Assert.assertEquals((Object)"abcd", (Object)rs.getString(4));
            Assert.assertFalse((boolean)rs.next());
            selectSql = "SELECT val3 from " + dataTableName + " WHERE val1 = 'bc' LIMIT 1";
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bcde", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2) values ('c', 'aa','cde')");
            GlobalIndexCheckerIT.commitWithException(conn);
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
            selectSql = "SELECT * from " + indexTableName + " LIMIT 1";
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"ab", (Object)rs.getString(1));
            Assert.assertEquals((Object)"a", (Object)rs.getString(2));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(3));
            Assert.assertEquals((Object)"abcd", (Object)rs.getString(4));
            Assert.assertFalse((boolean)rs.next());
            GlobalIndexCheckerIT.verifyTableHealth(conn, dataTableName, indexTableName);
        }
    }

    private void assertIndexTableNotSelected(Connection conn, String dataTableName, String indexTableName, String sql) throws Exception {
        try {
            GlobalIndexCheckerIT.assertExplainPlan(conn, sql, dataTableName, indexTableName);
            throw new AssertionError((Object)"The index table should not be selected without an index hint");
        }
        catch (AssertionError assertionError) {
            return;
        }
    }

    @Test
    public void testSimulateConcurrentUpdates() throws Exception {
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerIT.getUrl());){
            String dataTableName = GlobalIndexCheckerIT.generateUniqueName();
            this.populateTable(dataTableName);
            String indexTableName = GlobalIndexCheckerIT.generateUniqueName();
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (val1) include (val2, val3)" + (this.async ? "ASYNC" : "") + this.indexDDLOptions);
            if (this.async) {
                IndexToolIT.runIndexTool(false, null, dataTableName, indexTableName);
            }
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val2) values ('a', 'abcc')");
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1) values ('a', 'aa')");
            conn.commit();
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val3) values ('a', null, null)");
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1) values ('a', 'ab')");
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1) values ('b', 'ab')");
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2) values ('b', 'ab', null)");
            conn.commit();
            ResultSet rs = conn.createStatement().executeQuery("SELECT * from " + indexTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"ab", (Object)rs.getString(1));
            Assert.assertEquals((Object)"a", (Object)rs.getString(2));
            Assert.assertEquals((Object)"abcc", (Object)rs.getString(3));
            Assert.assertEquals(null, (Object)rs.getString(4));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"ab", (Object)rs.getString(1));
            Assert.assertEquals((Object)"b", (Object)rs.getString(2));
            Assert.assertEquals(null, (Object)rs.getString(3));
            Assert.assertEquals((Object)"bcde", (Object)rs.getString(4));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testFailPostIndexDeleteUpdate() throws Exception {
        String dataTableName = GlobalIndexCheckerIT.generateUniqueName();
        this.populateTable(dataTableName);
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerIT.getUrl());){
            String indexTableName = GlobalIndexCheckerIT.generateUniqueName();
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (val1) include (val2, val3)" + (this.async ? "ASYNC" : "") + this.indexDDLOptions);
            if (this.async) {
                IndexToolIT.runIndexTool(false, null, dataTableName, indexTableName);
            }
            String selectSql = "SELECT id from " + dataTableName + " WHERE val1  = 'ab'";
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)true);
            String dml = "DELETE from " + dataTableName + " WHERE id  = 'a'";
            Assert.assertEquals((long)1L, (long)conn.createStatement().executeUpdate(dml));
            conn.commit();
            dml = "DELETE from " + dataTableName + " WHERE val1  = 'ab'";
            Assert.assertEquals((long)0L, (long)conn.createStatement().executeUpdate(dml));
            String query = "SELECT COUNT(*) from " + indexTableName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            GlobalIndexCheckerIT.verifyTableHealth(conn, dataTableName, indexTableName);
        }
    }

    @Test
    public void testPartialRowUpdateForMutable() throws Exception {
        String dataTableName = GlobalIndexCheckerIT.generateUniqueName();
        this.populateTable(dataTableName);
        Connection conn = DriverManager.getConnection(GlobalIndexCheckerIT.getUrl());
        String indexTableName = GlobalIndexCheckerIT.generateUniqueName();
        conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (val1) include (val2, val3)" + (this.async ? "ASYNC" : "") + this.indexDDLOptions);
        if (this.async) {
            IndexToolIT.runIndexTool(false, null, dataTableName, indexTableName);
        }
        conn.createStatement().execute("upsert into " + dataTableName + " (id, val2) values ('a', 'abcc')");
        conn.commit();
        conn.createStatement().execute("upsert into " + dataTableName + " (id, val2) values ('c', 'cde')");
        conn.commit();
        String selectSql = "SELECT * from " + dataTableName + " WHERE val1  = 'ab'";
        GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
        ResultSet rs = conn.createStatement().executeQuery(selectSql);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((Object)"ab", (Object)rs.getString(2));
        Assert.assertEquals((Object)"abcc", (Object)rs.getString(3));
        Assert.assertEquals((Object)"abcd", (Object)rs.getString(4));
        Assert.assertFalse((boolean)rs.next());
        conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val3) values ('a', 'ab', 'abcdd')");
        conn.commit();
        GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
        rs = conn.createStatement().executeQuery(selectSql);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((Object)"ab", (Object)rs.getString(2));
        Assert.assertEquals((Object)"abcc", (Object)rs.getString(3));
        Assert.assertEquals((Object)"abcdd", (Object)rs.getString(4));
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }

    @Test
    public void testPartialRowUpdateForImmutable() throws Exception {
        if (this.async || this.encoded) {
            return;
        }
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerIT.getUrl());){
            String dataTableName = GlobalIndexCheckerIT.generateUniqueName();
            conn.createStatement().execute("create table " + dataTableName + " (id varchar(10) not null primary key, val1 varchar(10), val2 varchar(10), val3 varchar(10)) IMMUTABLE_ROWS=true, IMMUTABLE_STORAGE_SCHEME=" + PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('a', 'ab', 'abc', 'abcd')");
            conn.commit();
            String indexTableName = GlobalIndexCheckerIT.generateUniqueName();
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (val1) include (val2, val3)" + this.indexDDLOptions);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('a', 'ab', 'abcc', null)");
            conn.commit();
            String selectSql = "SELECT * from " + dataTableName + " WHERE val1  = 'ab'";
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            try (ResultSet rs = conn.createStatement().executeQuery(selectSql);){
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"a", (Object)rs.getString(1));
                Assert.assertEquals((Object)"ab", (Object)rs.getString(2));
                Assert.assertEquals((Object)"abcc", (Object)rs.getString(3));
                Assert.assertEquals((Object)"abcd", (Object)rs.getString(4));
                Assert.assertFalse((boolean)rs.next());
            }
            selectSql = "SELECT * from " + dataTableName + " WHERE id  = 'a'";
            rs = conn.createStatement().executeQuery(selectSql);
            try {
                PhoenixResultSet prs = rs.unwrap(PhoenixResultSet.class);
                String explainPlan = QueryUtil.getExplainPlan((ResultIterator)prs.getUnderlyingIterator());
                Assert.assertTrue((boolean)explainPlan.contains(dataTableName));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"a", (Object)rs.getString(1));
                Assert.assertEquals((Object)"ab", (Object)rs.getString(2));
                Assert.assertEquals((Object)"abcc", (Object)rs.getString(3));
                Assert.assertEquals((Object)"abcd", (Object)rs.getString(4));
                Assert.assertFalse((boolean)rs.next());
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    @Test
    public void testFailPreIndexRowUpdate() throws Exception {
        String dataTableName = GlobalIndexCheckerIT.generateUniqueName();
        this.populateTable(dataTableName);
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerIT.getUrl());){
            String indexTableName = GlobalIndexCheckerIT.generateUniqueName();
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (val1) include (val2, val3)" + (this.async ? "ASYNC" : "") + this.indexDDLOptions);
            if (this.async) {
                IndexToolIT.runIndexTool(false, null, dataTableName, indexTableName);
            }
            IndexRegionObserver.setFailPreIndexUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val2) values ('a', 'abcc')");
            GlobalIndexCheckerIT.commitWithException(conn);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2) values ('c', 'cd','cde')");
            GlobalIndexCheckerIT.commitWithException(conn);
            IndexRegionObserver.setFailPreIndexUpdatesForTesting((boolean)false);
            String selectSql = "SELECT val2, val3 from " + dataTableName + " WHERE val1  = 'ab'";
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"abcd", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            GlobalIndexCheckerIT.verifyTableHealth(conn, dataTableName, indexTableName);
        }
    }

    @Test
    public void testFailPostIndexRowUpdate() throws Exception {
        String dataTableName = GlobalIndexCheckerIT.generateUniqueName();
        this.populateTable(dataTableName);
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerIT.getUrl());){
            String indexTableName = GlobalIndexCheckerIT.generateUniqueName();
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (val1) include (val2, val3)" + (this.async ? "ASYNC" : "") + this.indexDDLOptions);
            if (this.async) {
                IndexToolIT.runIndexTool(false, null, dataTableName, indexTableName);
            }
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val2) values ('a', 'abcc')");
            conn.commit();
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2) values ('c', 'cd','cde')");
            conn.commit();
            IndexTool indexTool = IndexToolIT.runIndexTool(false, "", dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.ONLY, new String[0]);
            Assert.assertEquals((long)3L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixJobCounters.INPUT_RECORDS).getValue());
            Assert.assertEquals((long)3L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.SCANNED_DATA_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.REBUILT_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)3L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_VALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_EXPIRED_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_MISSING_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_MISSING_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_INVALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)2L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_UNVERIFIED_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_OLD_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_UNKNOWN_INDEX_ROW_COUNT).getValue());
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)false);
            String selectSql = "SELECT val2, val3 from " + dataTableName + " WHERE val1  = 'ab' and val2 = 'abcc'";
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abcc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"abcd", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            GlobalIndexCheckerIT.verifyTableHealth(conn, dataTableName, indexTableName);
        }
    }

    @Test
    public void testUnverifiedValuesAreNotVisible() throws Exception {
        if (this.async) {
            return;
        }
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerIT.getUrl());){
            String dataTableName = GlobalIndexCheckerIT.generateUniqueName();
            conn.createStatement().execute("create table " + dataTableName + " (id varchar(10) not null primary key, val1 varchar(10), val2 varchar(10), val3 varchar(10))" + this.tableDDLOptions);
            String indexTableName = GlobalIndexCheckerIT.generateUniqueName();
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (val1) include (val2, val3)" + this.indexDDLOptions);
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('a', 'ab','abc', 'abcd')");
            GlobalIndexCheckerIT.commitWithException(conn);
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2) values ('a', 'ab','abc')");
            conn.commit();
            String selectSql = "SELECT val3 from " + dataTableName + " WHERE val1  = 'ab'";
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals(null, (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            GlobalIndexCheckerIT.verifyTableHealth(conn, dataTableName, indexTableName);
        }
    }

    @Test
    public void testUnverifiedRowRepair() throws Exception {
        if (this.async) {
            return;
        }
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerIT.getUrl());){
            String dataTableName = GlobalIndexCheckerIT.generateUniqueName();
            conn.createStatement().execute("create table " + dataTableName + " (id varchar(10) not null primary key, a.val1 varchar(10), b.val2 varchar(10), c.val3 varchar(10))" + this.tableDDLOptions);
            String indexTableName = GlobalIndexCheckerIT.generateUniqueName();
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (val1) include (val2, val3)" + this.indexDDLOptions);
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val3) values ('a', 'ab','abcde')");
            GlobalIndexCheckerIT.commitWithException(conn);
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
            String selectSql = "SELECT * from " + dataTableName + " WHERE val1  = 'ab'";
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertFalse((boolean)rs.next());
            conn.createStatement().execute("upsert into " + dataTableName + " values ('a', 'ab','abc', 'abcd')");
            conn.commit();
            selectSql = "SELECT val3 from " + dataTableName + " WHERE val1  = 'ab'";
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abcd", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val3) values ('a', 'ab','abcde')");
            GlobalIndexCheckerIT.commitWithException(conn);
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
            for (int i = 0; i < 2; ++i) {
                selectSql = "SELECT val3 from " + dataTableName + " WHERE val1  = 'ab'";
                GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
                rs = conn.createStatement().executeQuery(selectSql);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"abcd", (Object)rs.getString(1));
                Assert.assertFalse((boolean)rs.next());
            }
            GlobalIndexCheckerIT.verifyTableHealth(conn, dataTableName, indexTableName);
        }
    }

    @Test
    public void testOnePhaseOverwiteFollowingTwoPhaseWrite() throws Exception {
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerIT.getUrl());){
            String dataTableName = GlobalIndexCheckerIT.generateUniqueName();
            this.populateTable(dataTableName);
            String indexTableName = GlobalIndexCheckerIT.generateUniqueName();
            conn.createStatement().execute("CREATE INDEX " + indexTableName + "1 on " + dataTableName + " (val1) include (val2, val3)" + (this.async ? "ASYNC" : "") + this.indexDDLOptions);
            conn.createStatement().execute("CREATE INDEX " + indexTableName + "2 on " + dataTableName + " (val2) include (val1, val3)" + (this.async ? "ASYNC" : "") + this.indexDDLOptions);
            if (this.async) {
                IndexToolIT.runIndexTool(false, null, dataTableName, indexTableName + "1");
                IndexToolIT.runIndexTool(false, null, dataTableName, indexTableName + "2");
            }
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('c', 'cd', 'cde', 'cdef')");
            conn.commit();
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('c', 'cd', 'cdee', 'cdfg')");
            GlobalIndexCheckerIT.commitWithException(conn);
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)false);
            String selectSql = "SELECT val2, val3 from " + dataTableName + " WHERE val1  = 'cd'";
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName + "1");
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"cde", (Object)rs.getString(1));
            Assert.assertEquals((Object)"cdef", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            GlobalIndexCheckerIT.verifyTableHealth(conn, dataTableName, indexTableName);
        }
    }

    @Test
    public void testOnePhaseOverwrite() throws Exception {
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerIT.getUrl());){
            String dataTableName = GlobalIndexCheckerIT.generateUniqueName();
            String indexTableName = GlobalIndexCheckerIT.generateUniqueName();
            this.createTableAndIndexes(conn, dataTableName, indexTableName);
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val2, val3) values ('a', 'abcc', 'abccc')");
            GlobalIndexCheckerIT.commitWithException(conn);
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)false);
            String selectSql = "SELECT val2 from " + dataTableName + " WHERE val1  = 'ab'";
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName + "1");
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abc", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            selectSql = "SELECT val3 from " + dataTableName + " WHERE val1  = 'ab'";
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName + "1");
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abcd", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            selectSql = "SELECT val2, val3 from " + dataTableName + " WHERE val2  = 'abcc'";
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName + "2");
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertFalse((boolean)rs.next());
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val2) values ('a', 'abccc')");
            GlobalIndexCheckerIT.commitWithException(conn);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val2) values ('a', 'abcccc')");
            GlobalIndexCheckerIT.commitWithException(conn);
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)false);
            selectSql = "SELECT val2, val3 from " + dataTableName + " WHERE val1  = 'ab'";
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName + "1");
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"abcd", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            selectSql = "SELECT val2, val3 from " + dataTableName + " WHERE val2  = 'abccc'";
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName + "2");
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertFalse((boolean)rs.next());
            selectSql = "SELECT val2, val3 from " + dataTableName + " WHERE val2  = 'abcccc'";
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName + "2");
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertFalse((boolean)rs.next());
            GlobalIndexCheckerIT.verifyTableHealth(conn, dataTableName, indexTableName);
        }
    }

    private void createTableAndIndexes(Connection conn, String dataTableName, String indexTableName) throws Exception {
        this.createTableAndIndexes(conn, dataTableName, indexTableName, 1);
    }

    private void createTableAndIndexes(Connection conn, String dataTableName, String indexTableName, int indexVersions) throws Exception {
        this.populateTable(dataTableName);
        conn.createStatement().execute("CREATE INDEX " + indexTableName + "1 on " + dataTableName + " (val1) include (val2, val3)" + (this.async ? "ASYNC" : "") + " VERSIONS=" + indexVersions + (String)(Strings.isNullOrEmpty((String)this.indexDDLOptions) ? "" : "," + this.indexDDLOptions));
        conn.createStatement().execute("CREATE INDEX " + indexTableName + "2 on " + dataTableName + " (val2) include (val1, val3)" + (this.async ? "ASYNC" : "") + " VERSIONS=" + indexVersions + (String)(Strings.isNullOrEmpty((String)this.indexDDLOptions) ? "" : "," + this.indexDDLOptions));
        conn.commit();
        if (this.async) {
            IndexToolIT.runIndexTool(false, null, dataTableName, indexTableName + "1");
            IndexToolIT.runIndexTool(false, null, dataTableName, indexTableName + "2");
        }
    }

    @Test
    public void testFailDataTableAndPostIndexRowUpdate() throws Exception {
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerIT.getUrl());){
            String dataTableName = GlobalIndexCheckerIT.generateUniqueName();
            String indexName = GlobalIndexCheckerIT.generateUniqueName();
            this.createTableAndIndexes(conn, dataTableName, indexName);
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val2) values ('a', 'abcc')");
            GlobalIndexCheckerIT.commitWithException(conn);
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)false);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val3) values ('a', 'abcdd')");
            conn.commit();
            String selectSql = "SELECT val2, val3 from " + dataTableName + " WHERE val1  = 'ab'";
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexName + "1");
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"abcdd", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            selectSql = "SELECT val2, val3 from " + dataTableName + " WHERE val2  = 'abc'";
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexName + "2");
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"abcdd", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            GlobalIndexCheckerIT.verifyTableHealth(conn, dataTableName, indexName);
        }
    }

    @Test
    public void testUnverifiedIndexRowWithFilter() throws Exception {
        if (this.async) {
            return;
        }
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.server.paging.enabled", String.valueOf(false));
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerIT.getUrl(), props);){
            ResultSet rs;
            String dataTableName = GlobalIndexCheckerIT.generateUniqueName();
            String indexName = GlobalIndexCheckerIT.generateUniqueName();
            conn.createStatement().execute("create table " + dataTableName + " (id integer primary key, name varchar, status integer, val varchar)" + this.tableDDLOptions);
            conn.commit();
            conn.createStatement().execute("create index " + indexName + " ON " + dataTableName + "(name) include (status, val)");
            conn.createStatement().execute("upsert into " + dataTableName + " values (1, 'tom', 1, 'blah')");
            conn.createStatement().execute("upsert into " + dataTableName + " values (2, 'jerry', 2, 'jee')");
            conn.commit();
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, status) values (1, 2)");
            GlobalIndexCheckerIT.commitWithException(conn);
            String selectSql = "SELECT * from " + dataTableName + " WHERE name = 'tom' AND status = 1";
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexName);
            try {
                rs = conn.createStatement().executeQuery(selectSql);
                try {
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((long)1L, (long)rs.getInt(1));
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            catch (AssertionError e) {
                TestUtil.dumpTable(conn, TableName.valueOf((String)indexName));
                throw e;
            }
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, status) values (1, 2)");
            GlobalIndexCheckerIT.commitWithException(conn);
            selectSql = "SELECT * from " + dataTableName + " WHERE name = 'tom' AND status = 2";
            try {
                rs = conn.createStatement().executeQuery(selectSql);
                try {
                    Assert.assertFalse((boolean)rs.next());
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            catch (AssertionError e) {
                TestUtil.dumpTable(conn, TableName.valueOf((String)indexName));
                throw e;
            }
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, name, status) values (3, 'tom', 1)");
            GlobalIndexCheckerIT.commitWithException(conn);
            selectSql = "SELECT count(*) from " + dataTableName + " WHERE name = 'tom' and  id > 1";
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexName);
            try {
                rs = conn.createStatement().executeQuery(selectSql);
                try {
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((long)0L, (long)rs.getInt(1));
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            catch (AssertionError e) {
                TestUtil.dumpTable(conn, TableName.valueOf((String)indexName));
                throw e;
            }
        }
    }

    @Test
    public void testUnverifiedIndexRowWithSkipScanFilter() throws Exception {
        if (this.async) {
            return;
        }
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerIT.getUrl());){
            String expectedExplainPlan;
            String actualExplainPlan;
            String dataTableName = GlobalIndexCheckerIT.generateUniqueName();
            String indexName = GlobalIndexCheckerIT.generateUniqueName();
            this.populateTable(dataTableName);
            conn.createStatement().execute("CREATE INDEX " + indexName + " on " + dataTableName + " (val1, val2) include (val3)" + this.indexDDLOptions);
            conn.commit();
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1) values ('b', 'bcc')");
            GlobalIndexCheckerIT.commitWithException(conn);
            String selectSql = "SELECT id, val1, val3 from " + dataTableName + " WHERE val1 IN ('ab', 'bcc') ";
            try (ResultSet rs = conn.createStatement().executeQuery("EXPLAIN " + selectSql);){
                actualExplainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
                expectedExplainPlan = String.format("SKIP SCAN ON 2 KEYS OVER %s", indexName);
                Assert.assertTrue((boolean)actualExplainPlan.contains(expectedExplainPlan));
            }
            try {
                rs = conn.createStatement().executeQuery(selectSql);
                try {
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((Object)"a", (Object)rs.getString("id"));
                    Assert.assertEquals((Object)"ab", (Object)rs.getString("val1"));
                    Assert.assertEquals((Object)"abcd", (Object)rs.getString("val3"));
                    Assert.assertFalse((boolean)rs.next());
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            catch (AssertionError e) {
                TestUtil.dumpTable(conn, TableName.valueOf((String)indexName));
                throw e;
            }
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val3) values ('b', 'bcdf')");
            GlobalIndexCheckerIT.commitWithException(conn);
            selectSql = "SELECT id, val3 from " + dataTableName + " WHERE val1 IN ('bc') AND val2 IN ('bcd', 'xcdf') AND val3 = 'bcde' ";
            rs = conn.createStatement().executeQuery("EXPLAIN " + selectSql);
            try {
                actualExplainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
                expectedExplainPlan = String.format("SKIP SCAN ON 2 KEYS OVER %s", indexName);
                String filter = "SERVER FILTER BY";
                Assert.assertTrue((String)String.format("actual=%s", actualExplainPlan), (boolean)actualExplainPlan.contains(expectedExplainPlan));
                Assert.assertTrue((String)String.format("actual=%s", actualExplainPlan), (boolean)actualExplainPlan.contains(filter));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            try {
                rs = conn.createStatement().executeQuery(selectSql);
                try {
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((Object)"b", (Object)rs.getString("id"));
                    Assert.assertEquals((Object)"bcde", (Object)rs.getString("val3"));
                    Assert.assertFalse((boolean)rs.next());
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            catch (AssertionError e) {
                TestUtil.dumpTable(conn, TableName.valueOf((String)indexName));
                throw e;
            }
        }
    }

    @Test
    public void testUnverifiedIndexRowWithSkipScanFilter2() throws Exception {
        if (this.async) {
            return;
        }
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerIT.getUrl());){
            String actualExplainPlan;
            PhoenixResultSet prs;
            ResultSet rs;
            String dataTableName = GlobalIndexCheckerIT.generateUniqueName();
            String indexName = GlobalIndexCheckerIT.generateUniqueName();
            conn.createStatement().execute("create table " + dataTableName + " (id varchar(10) not null primary key, val1 varchar(10), val2 varchar(10), val3 varchar(10))" + this.tableDDLOptions);
            conn.createStatement().execute("CREATE INDEX " + indexName + " on " + dataTableName + " (val1, val2) include (val3)" + this.indexDDLOptions);
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('a', 'val1', 'val2a', 'val3')");
            conn.createStatement().execute("upsert into " + dataTableName + " values ('b', 'val1', 'val2a', 'val31')");
            conn.createStatement().execute("upsert into " + dataTableName + " values ('c', 'val1', 'val2c', 'val3')");
            conn.createStatement().execute("upsert into " + dataTableName + " values ('d', 'val1', 'val2d', 'val3')");
            conn.createStatement().execute("upsert into " + dataTableName + " values ('e', 'val1', 'val2e', null)");
            conn.createStatement().execute("upsert into " + dataTableName + " values ('f', 'val1', 'val2f', null)");
            conn.createStatement().execute("upsert into " + dataTableName + " values ('g', 'val1', 'val2g', null)");
            conn.commit();
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)false);
            String selectSql = "SELECT id from " + dataTableName + " WHERE val1 = 'val1' AND val2 IN ('val2a', 'val2d') AND val3 = 'val3'";
            ArrayList expectedIDs = Lists.newArrayList((Object[])new String[]{"a", "d"});
            ArrayList actualIDs = Lists.newArrayList();
            try {
                rs = conn.createStatement().executeQuery(selectSql);
                try {
                    prs = rs.unwrap(PhoenixResultSet.class);
                    actualExplainPlan = QueryUtil.getExplainPlan((ResultIterator)prs.getUnderlyingIterator());
                    Assert.assertTrue((boolean)actualExplainPlan.contains(indexName));
                    while (rs.next()) {
                        actualIDs.add(rs.getString("id"));
                    }
                    Assert.assertEquals((Object)expectedIDs, (Object)actualIDs);
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            catch (AssertionError e) {
                TestUtil.dumpTable(conn, TableName.valueOf((String)indexName));
                throw e;
            }
            selectSql = "SELECT id from " + dataTableName + " WHERE val1 = 'val1' AND val2 IN ('val2e', 'val2g') AND val3 is null";
            expectedIDs = Lists.newArrayList((Object[])new String[]{"e", "g"});
            actualIDs = Lists.newArrayList();
            try {
                rs = conn.createStatement().executeQuery(selectSql);
                try {
                    prs = rs.unwrap(PhoenixResultSet.class);
                    actualExplainPlan = QueryUtil.getExplainPlan((ResultIterator)prs.getUnderlyingIterator());
                    Assert.assertTrue((boolean)actualExplainPlan.contains(indexName));
                    while (rs.next()) {
                        actualIDs.add(rs.getString("id"));
                    }
                    Assert.assertEquals((Object)expectedIDs, (Object)actualIDs);
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            catch (AssertionError e) {
                TestUtil.dumpTable(conn, TableName.valueOf((String)indexName));
                throw e;
            }
        }
    }

    @Test
    public void testUnverifiedIndexRowWithFirstKeyOnlyFilter() throws Exception {
        if (this.async) {
            return;
        }
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerIT.getUrl());){
            String dataTableName = GlobalIndexCheckerIT.generateUniqueName();
            String indexName = GlobalIndexCheckerIT.generateUniqueName();
            this.populateTable(dataTableName);
            conn.createStatement().execute("CREATE INDEX " + indexName + " on " + dataTableName + " (val1, id, val2, val3) " + this.indexDDLOptions);
            conn.commit();
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val3) values ('b', 'bcdf')");
            GlobalIndexCheckerIT.commitWithException(conn);
            String selectSql = "SELECT id, val3 from " + dataTableName + " WHERE val1 = 'bc' and val2 = 'bcd' ";
            try (ResultSet rs = conn.createStatement().executeQuery("EXPLAIN " + selectSql);){
                String actualExplainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
                String expectedExplainPlan = String.format("RANGE SCAN OVER %s", indexName);
                String filter = String.format("SERVER FILTER BY %s ONLY AND", this.encoded ? "FIRST KEY" : "EMPTY COLUMN");
                Assert.assertTrue((String)String.format("actual=%s", actualExplainPlan), (boolean)actualExplainPlan.contains(expectedExplainPlan));
                Assert.assertTrue((String)String.format("actual=%s", actualExplainPlan), (boolean)actualExplainPlan.contains(filter));
            }
            try {
                rs = conn.createStatement().executeQuery(selectSql);
                try {
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((Object)"b", (Object)rs.getString("id"));
                    Assert.assertEquals((Object)"bcde", (Object)rs.getString("val3"));
                    Assert.assertFalse((boolean)rs.next());
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            catch (AssertionError e) {
                TestUtil.dumpTable(conn, TableName.valueOf((String)indexName));
                throw e;
            }
        }
    }

    @Test
    public void testIndexRowWithNullIncludedColumnAndFilter() throws Exception {
        if (this.async) {
            return;
        }
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerIT.getUrl());){
            String explainPlan;
            PhoenixResultSet prs;
            String dataTableName = GlobalIndexCheckerIT.generateUniqueName();
            String indexName = GlobalIndexCheckerIT.generateUniqueName();
            this.populateTable(dataTableName);
            conn.createStatement().execute("CREATE INDEX " + indexName + " on " + dataTableName + "  (val1) include (val2, val3)" + this.indexDDLOptions);
            conn.commit();
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val3) values ('a', null)");
            conn.commit();
            String dql = String.format("select id, val2 from %s where val1='ab' and val3='abcd'", dataTableName);
            try (ResultSet rs = conn.createStatement().executeQuery(dql);){
                prs = rs.unwrap(PhoenixResultSet.class);
                explainPlan = QueryUtil.getExplainPlan((ResultIterator)prs.getUnderlyingIterator());
                Assert.assertTrue((boolean)explainPlan.contains(indexName));
                Assert.assertFalse((boolean)rs.next());
            }
            dql = String.format("select id, val2 from %s where val1='ab' and val3 is null", dataTableName);
            rs = conn.createStatement().executeQuery(dql);
            try {
                prs = rs.unwrap(PhoenixResultSet.class);
                explainPlan = QueryUtil.getExplainPlan((ResultIterator)prs.getUnderlyingIterator());
                Assert.assertTrue((boolean)explainPlan.contains(indexName));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"abc", (Object)rs.getString("val2"));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            conn.createStatement().execute("upsert into " + dataTableName + " values ('a', 'ac', null, null)");
            conn.commit();
            dql = String.format("select id, val2 from %s where val1='ac' and val3 is null", dataTableName);
            rs = conn.createStatement().executeQuery(dql);
            try {
                prs = rs.unwrap(PhoenixResultSet.class);
                explainPlan = QueryUtil.getExplainPlan((ResultIterator)prs.getUnderlyingIterator());
                Assert.assertTrue((boolean)explainPlan.contains(indexName));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertNull((Object)rs.getString("val2"));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            TestUtil.dumpTable(conn, TableName.valueOf((String)dataTableName));
            TestUtil.dumpTable(conn, TableName.valueOf((String)indexName));
        }
    }

    @Test
    public void testIndexToolWithNullIncludedColumn() throws Exception {
        if (this.async) {
            return;
        }
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerIT.getUrl());){
            String dataTableName = GlobalIndexCheckerIT.generateUniqueName();
            String indexName = GlobalIndexCheckerIT.generateUniqueName();
            this.populateTable(dataTableName);
            conn.createStatement().execute("CREATE INDEX " + indexName + " on " + dataTableName + "  (val1) include (val2, val3)" + this.indexDDLOptions);
            conn.commit();
            IndexRegionObserver.setIgnoreWritingDeleteColumnsToIndex((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val3) values ('a', null)");
            conn.commit();
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2) values ('c', 'cd', 'cde')");
            conn.commit();
            IndexRegionObserver.setIgnoreWritingDeleteColumnsToIndex((boolean)false);
            IndexTool it = IndexToolIT.runIndexTool(false, null, dataTableName, indexName, null, 0, IndexTool.IndexVerifyType.BEFORE, new String[0]);
            CounterGroup mrJobCounters = IndexToolIT.getMRJobCounters(it);
            IndexToolIT.dumpMRJobCounters(mrJobCounters);
            try {
                Assert.assertEquals((long)(this.encoded ? 0L : 2L), (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_INVALID_INDEX_ROW_COUNT.name()).getValue());
                Assert.assertEquals((long)(this.encoded ? 0L : 2L), (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.REBUILT_INDEX_ROW_COUNT.name()).getValue());
            }
            catch (AssertionError e) {
                TestUtil.dumpTable(conn, TableName.valueOf((String)dataTableName));
                TestUtil.dumpTable(conn, TableName.valueOf((String)indexName));
                throw e;
            }
        }
    }

    @Test
    public void testIndexToolWithMultipleDeleteFamilyMarkers() throws Exception {
        if (this.async) {
            return;
        }
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerIT.getUrl());){
            String dataTableName = GlobalIndexCheckerIT.generateUniqueName();
            String indexName = GlobalIndexCheckerIT.generateUniqueName();
            this.populateTable(dataTableName);
            conn.createStatement().execute("CREATE INDEX " + indexName + " on " + dataTableName + "  (val1) include (val2, val3)" + this.indexDDLOptions);
            conn.commit();
            String delete = String.format("DELETE FROM %s where id = 'a'", dataTableName);
            conn.createStatement().execute(delete);
            conn.commit();
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            String dml = "upsert into " + dataTableName + " (id, val1, val3) values ('a', 'ab', ?)";
            try (PreparedStatement ps = conn.prepareStatement(dml);){
                for (int i = 0; i < 5; ++i) {
                    ps.setString(1, "val3_ " + i);
                    ps.executeUpdate();
                    GlobalIndexCheckerIT.commitWithException(conn);
                    String dql = String.format("select id, val2, val3 from %s where val1='ab'", dataTableName);
                    try (ResultSet rs = conn.createStatement().executeQuery(dql);){
                        PhoenixResultSet prs = rs.unwrap(PhoenixResultSet.class);
                        String explainPlan = QueryUtil.getExplainPlan((ResultIterator)prs.getUnderlyingIterator());
                        Assert.assertTrue((boolean)explainPlan.contains(indexName));
                        Assert.assertFalse((boolean)rs.next());
                        continue;
                    }
                }
            }
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val3) values ('a', 'ab', null)");
            conn.commit();
            IndexTool it = IndexToolIT.runIndexTool(false, null, dataTableName, indexName, null, 0, IndexTool.IndexVerifyType.ONLY, new String[0]);
            CounterGroup mrJobCounters = IndexToolIT.getMRJobCounters(it);
            IndexToolIT.dumpMRJobCounters(mrJobCounters);
            try {
                Assert.assertEquals((long)2L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REBUILD_VALID_INDEX_ROW_COUNT.name()).getValue());
                Assert.assertEquals((long)0L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.REBUILT_INDEX_ROW_COUNT.name()).getValue());
            }
            catch (AssertionError e) {
                TestUtil.dumpTable(conn, TableName.valueOf((String)dataTableName));
                TestUtil.dumpTable(conn, TableName.valueOf((String)indexName));
                throw e;
            }
        }
    }

    @Test
    public void testViewIndexRowUpdate() throws Exception {
        if (this.async) {
            return;
        }
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerIT.getUrl());){
            String dataTableName = GlobalIndexCheckerIT.generateUniqueName();
            conn.createStatement().execute("create table " + dataTableName + " (oid varchar(10) not null, kp char(3) not null, val1 varchar(10)CONSTRAINT pk PRIMARY KEY (oid, kp)) COLUMN_ENCODED_BYTES=0, MULTI_TENANT=true");
            String viewName = GlobalIndexCheckerIT.generateUniqueName();
            conn.createStatement().execute("CREATE VIEW " + viewName + " (id char(10) not null, val2 varchar, val3 varchar, CONSTRAINT pk PRIMARY KEY (id)) AS SELECT * FROM " + dataTableName + " WHERE kp = '0EC'");
            String indexName = GlobalIndexCheckerIT.generateUniqueName();
            conn.createStatement().execute("CREATE INDEX " + indexName + " on " + viewName + " (val2) include (val3)" + this.indexDDLOptions);
            Properties props = new Properties();
            props.setProperty("TenantId", "o1");
            try (Connection tenantConn = DriverManager.getConnection(GlobalIndexCheckerIT.getUrl(), props);){
                String childViewName = GlobalIndexCheckerIT.generateUniqueName();
                tenantConn.createStatement().execute("CREATE VIEW " + childViewName + " (zid CHAR(15)) AS SELECT * FROM " + viewName);
                String grandChildViewName = GlobalIndexCheckerIT.generateUniqueName();
                tenantConn.createStatement().execute("CREATE VIEW " + grandChildViewName + " (val4 CHAR(15)) AS SELECT * FROM " + childViewName);
                IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)true);
                tenantConn.createStatement().execute("upsert into " + childViewName + " (zid, id, val1, val2, val3) VALUES('z1','1', 'a1','b1','c1')");
                tenantConn.commit();
                IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)false);
                String selectSql = "select val3 from  " + childViewName + " WHERE val2  = 'b1'";
                ResultSet rs = tenantConn.createStatement().executeQuery(selectSql);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"c1", (Object)rs.getString("val3"));
                IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)true);
                tenantConn.createStatement().execute("upsert into " + grandChildViewName + " (zid, id, val2, val3, val4) VALUES('z1', '2', 'b2', 'c2', 'd1')");
                tenantConn.commit();
                IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)false);
                selectSql = "select id, val3 from  " + grandChildViewName + " WHERE val2  = 'b2'";
                rs = tenantConn.createStatement().executeQuery(selectSql);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"2", (Object)rs.getString("id"));
                Assert.assertEquals((Object)"c2", (Object)rs.getString("val3"));
            }
        }
    }

    @Test
    public void testOnDuplicateKeyWithIndex() throws Exception {
        if (this.async || this.encoded) {
            return;
        }
        try (Connection conn = DriverManager.getConnection(GlobalIndexCheckerIT.getUrl());){
            String dataTableName = GlobalIndexCheckerIT.generateUniqueName();
            String indexTableName = GlobalIndexCheckerIT.generateUniqueName();
            this.populateTable(dataTableName);
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (val1) include (val2, val3)" + this.indexDDLOptions);
            conn.commit();
            String upsertSql = "UPSERT INTO " + dataTableName + " VALUES ('a') ON DUPLICATE KEY UPDATE val1 = val1 || val1, val2 = val2 || val2";
            conn.createStatement().execute(upsertSql);
            conn.commit();
            String selectSql = "SELECT * from " + dataTableName + " WHERE val1 = 'abab'";
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"abab", (Object)rs.getString(2));
            Assert.assertEquals((Object)"abcabc", (Object)rs.getString(3));
            Assert.assertEquals((Object)"abcd", (Object)rs.getString(4));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    private static void commitWithException(Connection conn) {
        try {
            conn.commit();
            IndexRegionObserver.setFailPreIndexUpdatesForTesting((boolean)false);
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)false);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void verifyTableHealth(Connection conn, String dataTableName, String indexTableName) throws Exception {
        conn.createStatement().execute("upsert into " + dataTableName + " values ('a', 'ab', 'abc', 'abcd')");
        conn.createStatement().execute("upsert into " + dataTableName + " values ('z', 'za', 'zab', 'zabc')");
        conn.commit();
        String selectSql = "SELECT * from " + dataTableName + " WHERE val1  = 'ab'";
        GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
        ResultSet rs = conn.createStatement().executeQuery(selectSql);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((Object)"ab", (Object)rs.getString(2));
        Assert.assertEquals((Object)"abc", (Object)rs.getString(3));
        Assert.assertEquals((Object)"abcd", (Object)rs.getString(4));
        Assert.assertFalse((boolean)rs.next());
        selectSql = "SELECT * from " + dataTableName + " WHERE val1  = 'za'";
        GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
        rs = conn.createStatement().executeQuery(selectSql);
        conn.commit();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"z", (Object)rs.getString(1));
        Assert.assertEquals((Object)"za", (Object)rs.getString(2));
        Assert.assertEquals((Object)"zab", (Object)rs.getString(3));
        Assert.assertEquals((Object)"zabc", (Object)rs.getString(4));
        Assert.assertFalse((boolean)rs.next());
    }
}

