/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class DropMetadataIT
extends ParallelStatsDisabledIT {
    private static final String PRINCIPAL = "dropMetaData";
    private static final byte[] FAMILY_NAME = Bytes.toBytes((String)SchemaUtil.normalizeIdentifier((String)"1"));
    public static final String SCHEMA_NAME = "";

    private Connection getConnection() throws Exception {
        return this.getConnection(PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
    }

    private Connection getConnection(Properties props) throws Exception {
        props.setProperty("phoenix.schema.dropMetaData", Boolean.toString(true));
        props.setProperty("phoenix.jdbc.extra.arguments", SCHEMA_NAME);
        String url = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)PRINCIPAL);
        return DriverManager.getConnection(url, props);
    }

    @Test
    public void testDropIndexTableHasSameNameWithDataTable() {
        String tableName = DropMetadataIT.generateUniqueName();
        String indexName = "IDX_" + tableName;
        try (Connection conn = DriverManager.getConnection(DropMetadataIT.getUrl());){
            String createTable = "CREATE TABLE " + tableName + "  (id varchar not null primary key, col integer)";
            conn.createStatement().execute(createTable);
            String createIndex = "CREATE INDEX " + indexName + " on " + tableName + "(col)";
            conn.createStatement().execute(createIndex);
            String dropIndex = "DROP INDEX " + indexName + " on " + indexName;
            conn.createStatement().execute(dropIndex);
            Assert.fail((String)"should not execute successfully");
        }
        catch (SQLException e) {
            Assert.assertTrue((SQLExceptionCode.PARENT_TABLE_NOT_FOUND.getErrorCode() == e.getErrorCode() ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDropViewKeepsHTable() throws Exception {
        Connection conn = this.getConnection();
        Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();
        String hbaseNativeViewName = DropMetadataIT.generateUniqueName();
        byte[] hbaseNativeBytes = SchemaUtil.getTableNameAsBytes((String)SCHEMA_NAME, (String)hbaseNativeViewName);
        try {
            TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((byte[])hbaseNativeBytes));
            ColumnFamilyDescriptor columnDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY_NAME).setKeepDeletedCells(KeepDeletedCells.TRUE).build();
            builder.setColumnFamily(columnDescriptor);
            admin.createTable(builder.build());
        }
        finally {
            admin.close();
        }
        conn.createStatement().execute("create view " + hbaseNativeViewName + "   (uint_key unsigned_int not null,    ulong_key unsigned_long not null,    string_key varchar not null,\n    \"1\".uint_col unsigned_int,    \"1\".ulong_col unsigned_long    CONSTRAINT pk PRIMARY KEY (uint_key, ulong_key, string_key))\nDATA_BLOCK_ENCODING='" + DataBlockEncoding.NONE + "'");
        conn.createStatement().execute("drop view " + hbaseNativeViewName);
        conn.close();
    }
}

