/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ServerMetadataCacheTestImpl;
import org.apache.phoenix.jdbc.PhoenixTestDriver;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.StringUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public abstract class DropIndexDuringUpsertIT
extends BaseTest {
    private static final int NUM_SLAVES = 4;
    private static String url;
    private static PhoenixTestDriver driver;
    private static HBaseTestingUtility util;
    private static ExecutorService service;
    private static final String SCHEMA_NAME = "S";
    private static final String INDEX_TABLE_NAME = "I";
    private static final String DATA_TABLE_FULL_NAME;
    private static final String INDEX_TABLE_FULL_NAME;

    @Before
    public void doSetup() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        DropIndexDuringUpsertIT.setUpConfigForMiniCluster(conf);
        conf.setInt("hbase.client.retries.number", 2);
        conf.setInt("hbase.client.pause", 5000);
        conf.setInt("hbase.balancer.period", Integer.MAX_VALUE);
        conf.setLong("phoenix.index.failure.handling.rebuild.overlap.time", 0L);
        util = new HBaseTestingUtility(conf);
        util.startMiniCluster(4);
        String clientPort = util.getConfiguration().get("hbase.zookeeper.property.clientPort");
        url = "jdbc:phoenix:localhost:" + clientPort + ";test=true";
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        props.put("phoenix.schema.dropMetaData", Boolean.toString(true));
        driver = DropIndexDuringUpsertIT.initAndRegisterTestDriver(url, new ReadOnlyProps(props.entrySet().iterator()));
    }

    @After
    public void tearDown() throws Exception {
        try {
            service.shutdownNow();
            DropIndexDuringUpsertIT.destroyDriver((Driver)((Object)driver));
        }
        finally {
            ServerMetadataCacheTestImpl.resetCache();
            util.shutdownMiniCluster();
        }
    }

    @Ignore
    @Test(timeout=300000L)
    public void testWriteFailureDropIndex() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = driver.connect(url, props);
        conn.createStatement().execute("CREATE TABLE " + DATA_TABLE_FULL_NAME + " (k VARCHAR NOT NULL PRIMARY KEY, v1 VARCHAR, v2 VARCHAR)");
        String query = "SELECT * FROM " + DATA_TABLE_FULL_NAME;
        ResultSet rs = conn.createStatement().executeQuery(query);
        Assert.assertFalse((boolean)rs.next());
        conn.createStatement().execute("CREATE INDEX I ON " + DATA_TABLE_FULL_NAME + " (v1) INCLUDE (v2)");
        query = "SELECT * FROM " + INDEX_TABLE_FULL_NAME;
        rs = conn.createStatement().executeQuery(query);
        Assert.assertFalse((boolean)rs.next());
        rs = conn.getMetaData().getTables(null, StringUtil.escapeLike((String)SCHEMA_NAME), INDEX_TABLE_NAME, new String[]{PTableType.INDEX.toString()});
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)INDEX_TABLE_NAME, (Object)rs.getString(3));
        Assert.assertEquals((Object)PIndexState.ACTIVE.toString(), (Object)rs.getString("INDEX_STATE"));
        Assert.assertFalse((boolean)rs.next());
        Future<Boolean> future = service.submit(new UpsertTask());
        Thread.sleep(500L);
        conn.createStatement().execute("drop index I on " + DATA_TABLE_FULL_NAME);
        query = "SELECT count(1) FROM " + INDEX_TABLE_FULL_NAME;
        try {
            conn.createStatement().executeQuery(query);
            Assert.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)future.get());
    }

    static {
        service = Executors.newCachedThreadPool();
        DATA_TABLE_FULL_NAME = SchemaUtil.getTableName((String)SCHEMA_NAME, (String)"T");
        INDEX_TABLE_FULL_NAME = SchemaUtil.getTableName((String)SCHEMA_NAME, (String)INDEX_TABLE_NAME);
    }

    private static class UpsertTask
    implements Callable<Boolean> {
        private Connection conn = null;

        public UpsertTask() throws SQLException {
            Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            this.conn = driver.connect(url, props);
        }

        @Override
        public Boolean call() throws Exception {
            PreparedStatement stmt = this.conn.prepareStatement("UPSERT INTO " + DATA_TABLE_FULL_NAME + " VALUES(?,?,?)");
            for (int i = 0; i < 500; ++i) {
                stmt.setString(1, "a");
                stmt.setString(2, "x");
                stmt.setString(3, Integer.toString(i));
                stmt.execute();
                this.conn.commit();
            }
            return true;
        }
    }
}

