/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.expression.SingleCellColumnExpression;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.internal.ArrayComparisonFailure;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelStatsDisabledTest.class})
@RunWith(value=Parameterized.class)
public class DropColumnIT
extends ParallelStatsDisabledIT {
    private static final String PRINCIPAL = "dropColumn";
    public static final String SCHEMA_NAME = "";
    private final String TENANT_ID = "tenant1";
    private String tableDDLOptions;
    private boolean columnEncoded;
    private boolean mutable;

    private Connection getConnection() throws Exception {
        return this.getConnection(PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
    }

    private Connection getConnection(Properties props) throws Exception {
        props.setProperty("phoenix.schema.dropMetaData", Boolean.toString(true));
        props.setProperty("phoenix.jdbc.extra.arguments", SCHEMA_NAME);
        String url = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)PRINCIPAL);
        return DriverManager.getConnection(url, props);
    }

    public DropColumnIT(boolean mutable, boolean columnEncoded) {
        StringBuilder optionBuilder = new StringBuilder();
        if (!columnEncoded) {
            optionBuilder.append("COLUMN_ENCODED_BYTES=0");
        }
        if (!mutable) {
            if (optionBuilder.length() > 0) {
                optionBuilder.append(",");
            }
            optionBuilder.append("IMMUTABLE_ROWS=true");
            if (!columnEncoded) {
                optionBuilder.append(",IMMUTABLE_STORAGE_SCHEME=" + PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN);
            }
        }
        this.mutable = mutable;
        this.columnEncoded = columnEncoded;
        this.tableDDLOptions = optionBuilder.toString();
    }

    @Parameterized.Parameters(name="DropColumnIT_mutable={0}, columnEncoded={1}")
    public static synchronized Collection<Boolean[]> data() {
        return Arrays.asList({false, false}, {false, true}, {true, false}, {true, true});
    }

    @Test
    public void testDropCol() throws Exception {
        String indexTableName = DropColumnIT.generateUniqueName();
        String dataTableName = DropColumnIT.generateUniqueName();
        String localIndexTableName = "LOCAL_" + indexTableName;
        try (Connection conn = this.getConnection();){
            conn.setAutoCommit(false);
            conn.createStatement().execute("CREATE TABLE " + dataTableName + " (k VARCHAR NOT NULL PRIMARY KEY, v1 VARCHAR, v2 VARCHAR, v3 VARCHAR) " + this.tableDDLOptions);
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " ON " + dataTableName + " (v1) INCLUDE (v2, v3)");
            conn.createStatement().execute("CREATE LOCAL INDEX " + localIndexTableName + " ON " + dataTableName + " (v1) INCLUDE (v2, v3)");
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + dataTableName + " VALUES(?,?,?,?)");
            stmt.setString(1, "a");
            stmt.setString(2, "x");
            stmt.setString(3, "1");
            stmt.setString(4, "2");
            stmt.execute();
            conn.commit();
            PTable dataTable = conn.unwrap(PhoenixConnection.class).getTable(new PTableKey(null, dataTableName));
            PColumn dataColumn = dataTable.getColumnForColumnName("V2");
            byte[] dataCq = dataColumn.getColumnQualifierBytes();
            PTable globalIndexTable = conn.unwrap(PhoenixConnection.class).getTable(new PTableKey(null, indexTableName));
            PColumn glovalIndexCol = globalIndexTable.getColumnForColumnName("0:V2");
            byte[] globalIndexCq = glovalIndexCol.getColumnQualifierBytes();
            PTable localIndexTable = conn.unwrap(PhoenixConnection.class).getTable(new PTableKey(null, localIndexTableName));
            PColumn localIndexCol = localIndexTable.getColumnForColumnName("0:V2");
            byte[] localIndexCq = localIndexCol.getColumnQualifierBytes();
            this.verifyColValue(indexTableName, dataTableName, conn, dataTable, dataColumn, dataCq, globalIndexTable, glovalIndexCol, globalIndexCq, localIndexTable, localIndexCol, localIndexCq);
            conn.createStatement().execute("ALTER TABLE " + dataTableName + " DROP COLUMN v2 ");
            conn.createStatement().execute("SELECT * FROM " + dataTableName);
            dataTable = conn.unwrap(PhoenixConnection.class).getTable(new PTableKey(null, dataTableName));
            try {
                dataTable.getColumnForColumnName("V2");
                Assert.fail((String)"Column V2 should have been dropped from data table");
            }
            catch (ColumnNotFoundException columnNotFoundException) {
                // empty catch block
            }
            globalIndexTable = conn.unwrap(PhoenixConnection.class).getTable(new PTableKey(null, indexTableName));
            try {
                globalIndexTable.getColumnForColumnName("V2");
                Assert.fail((String)"Column V2 should have been dropped from global index table");
            }
            catch (ColumnNotFoundException columnNotFoundException) {
                // empty catch block
            }
            localIndexTable = conn.unwrap(PhoenixConnection.class).getTable(new PTableKey(null, indexTableName));
            try {
                localIndexTable.getColumnForColumnName("V2");
                Assert.fail((String)"Column V2 should have been dropped from global index table");
            }
            catch (ColumnNotFoundException columnNotFoundException) {
                // empty catch block
            }
            if (this.mutable || !this.columnEncoded) {
                byte[] key = Bytes.toBytes((String)"a");
                Scan scan = new Scan();
                scan.setRaw(true);
                scan.withStartRow(key);
                scan.withStopRow(key, true);
                Table table = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(dataTableName.getBytes());
                ResultScanner results = table.getScanner(scan);
                Result result = results.next();
                Assert.assertNotNull((Object)result);
                Assert.assertEquals((String)"data table column value should have been deleted", (Object)Cell.Type.DeleteColumn, (Object)((Cell)result.getColumnCells(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, dataCq).get(0)).getType());
                Assert.assertNull((Object)results.next());
                scan = new Scan();
                scan.setRaw(true);
                table = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(indexTableName.getBytes());
                results = table.getScanner(scan);
                result = results.next();
                Assert.assertNotNull((Object)result);
                Assert.assertEquals((String)"data table column value should have been deleted", (Object)Cell.Type.DeleteColumn, (Object)((Cell)result.getColumnCells(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, globalIndexCq).get(0)).getType());
                Assert.assertNull((Object)results.next());
                scan = new Scan();
                scan.setRaw(true);
                scan.addFamily(QueryConstants.DEFAULT_LOCAL_INDEX_COLUMN_FAMILY_BYTES);
                table = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(dataTableName.getBytes());
                results = table.getScanner(scan);
                result = results.next();
                Assert.assertNotNull((Object)result);
                Assert.assertEquals((String)"data table column value should have been deleted", (Object)Cell.Type.DeleteColumn, (Object)((Cell)result.getColumnCells(QueryConstants.DEFAULT_LOCAL_INDEX_COLUMN_FAMILY_BYTES, localIndexCq).get(0)).getType());
                Assert.assertNull((Object)results.next());
            } else {
                this.verifyColValue(indexTableName, dataTableName, conn, dataTable, dataColumn, dataCq, globalIndexTable, glovalIndexCol, globalIndexCq, localIndexTable, localIndexCol, localIndexCq);
            }
        }
    }

    private void verifyColValue(String indexTableName, String dataTableName, Connection conn, PTable dataTable, PColumn dataColumn, byte[] dataCq, PTable globalIndexTable, PColumn glovalIndexCol, byte[] globalIndexCq, PTable localIndexTable, PColumn localIndexCol, byte[] localIndexCq) throws SQLException, IOException, ArrayComparisonFailure {
        byte[] colValue;
        ImmutableBytesPtr ptr;
        SingleCellColumnExpression colExpression;
        Scan scan = new Scan();
        scan.setRaw(true);
        byte[] key = Bytes.toBytes((String)"a");
        scan.withStartRow(key);
        scan.withStopRow(key, true);
        Table table = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(dataTableName.getBytes());
        ResultScanner results = table.getScanner(scan);
        Result result = results.next();
        Assert.assertNotNull((Object)result);
        if (!this.mutable && this.columnEncoded) {
            colExpression = new SingleCellColumnExpression(dataColumn, "V2", dataTable.getEncodingScheme(), dataTable.getImmutableStorageScheme());
            ptr = new ImmutableBytesPtr();
            colExpression.evaluate((Tuple)new ResultTuple(result), (ImmutableBytesWritable)ptr);
            colValue = ptr.copyBytesIfNecessary();
        } else {
            colValue = result.getValue(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, dataCq);
        }
        Assert.assertArrayEquals((String)"wrong column value for v2", (byte[])Bytes.toBytes((String)"1"), (byte[])colValue);
        Assert.assertNull((Object)results.next());
        scan = new Scan();
        scan.setRaw(true);
        table = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(indexTableName.getBytes());
        results = table.getScanner(scan);
        result = results.next();
        Assert.assertNotNull((Object)result);
        if (!this.mutable && this.columnEncoded) {
            colExpression = new SingleCellColumnExpression(glovalIndexCol, "0:V2", globalIndexTable.getEncodingScheme(), globalIndexTable.getImmutableStorageScheme());
            ptr = new ImmutableBytesPtr();
            colExpression.evaluate((Tuple)new ResultTuple(result), (ImmutableBytesWritable)ptr);
            colValue = ptr.copyBytesIfNecessary();
        } else {
            colValue = result.getValue(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, globalIndexCq);
        }
        Assert.assertArrayEquals((String)"wrong column value for v2", (byte[])Bytes.toBytes((String)"1"), (byte[])colValue);
        Assert.assertNull((Object)results.next());
        scan = new Scan();
        scan.setRaw(true);
        scan.addFamily(QueryConstants.DEFAULT_LOCAL_INDEX_COLUMN_FAMILY_BYTES);
        table = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(dataTableName.getBytes());
        results = table.getScanner(scan);
        result = results.next();
        Assert.assertNotNull((Object)result);
        if (!this.mutable && this.columnEncoded) {
            colExpression = new SingleCellColumnExpression(localIndexCol, "0:V2", localIndexTable.getEncodingScheme(), localIndexTable.getImmutableStorageScheme());
            ptr = new ImmutableBytesPtr();
            Assert.assertTrue((boolean)colExpression.evaluate((Tuple)new ResultTuple(result), (ImmutableBytesWritable)ptr));
            colValue = ptr.copyBytesIfNecessary();
        } else {
            colValue = result.getValue(QueryConstants.DEFAULT_LOCAL_INDEX_COLUMN_FAMILY_BYTES, localIndexCq);
        }
        Assert.assertArrayEquals((String)"wrong column value for v2", (byte[])Bytes.toBytes((String)"1"), (byte[])colValue);
        Assert.assertNull((Object)results.next());
    }

    @Test
    public void testDroppingIndexedColDropsIndex() throws Exception {
        String indexTableName = DropColumnIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)SCHEMA_NAME, (String)DropColumnIT.generateUniqueName());
        String localIndexTableName1 = "LOCAL_" + indexTableName + "_1";
        String localIndexTableName2 = "LOCAL_" + indexTableName + "_2";
        try (Connection conn = this.getConnection();){
            byte[] colValue;
            conn.setAutoCommit(false);
            conn.createStatement().execute("CREATE TABLE " + dataTableFullName + " (k VARCHAR NOT NULL PRIMARY KEY, v1 VARCHAR, v2 VARCHAR) " + this.tableDDLOptions);
            conn.createStatement().execute("CREATE INDEX " + indexTableName + " ON " + dataTableFullName + " (v2) INCLUDE (v1)");
            conn.createStatement().execute("CREATE LOCAL INDEX " + localIndexTableName1 + " ON " + dataTableFullName + " (v2) INCLUDE (v1)");
            conn.createStatement().execute("CREATE LOCAL INDEX " + localIndexTableName2 + " ON " + dataTableFullName + " (k) INCLUDE (v1)");
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + dataTableFullName + " VALUES(?,?,?)");
            stmt.setString(1, "a");
            stmt.setString(2, "x");
            stmt.setString(3, "1");
            stmt.execute();
            conn.commit();
            PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
            PTable dataTable = pconn.getTable(new PTableKey(null, dataTableFullName));
            Assert.assertEquals((String)"Unexpected number of indexes ", (long)3L, (long)dataTable.getIndexes().size());
            byte[] indexTablePhysicalName = indexTableName.getBytes();
            byte[] localIndexTablePhysicalName = dataTableFullName.getBytes();
            conn.createStatement().execute("ALTER TABLE " + dataTableFullName + " DROP COLUMN v2 ");
            conn.createStatement().execute("SELECT * FROM " + dataTableFullName);
            try {
                conn.createStatement().execute("SELECT * FROM " + indexTableName);
                Assert.fail((String)"Index should have been dropped");
            }
            catch (org.apache.phoenix.schema.TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
            pconn = conn.unwrap(PhoenixConnection.class);
            dataTable = pconn.getTable(new PTableKey(null, dataTableFullName));
            try {
                pconn.getTable(new PTableKey(null, indexTableName));
                Assert.fail((String)"index should have been dropped");
            }
            catch (org.apache.phoenix.schema.TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
            try {
                pconn.getTable(new PTableKey(null, localIndexTableName1));
                Assert.fail((String)"index should have been dropped");
            }
            catch (org.apache.phoenix.schema.TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
            Assert.assertEquals((String)"Unexpected number of indexes ", (long)1L, (long)dataTable.getIndexes().size());
            try {
                conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin().getDescriptor(TableName.valueOf((String)indexTableName));
                Assert.fail((String)"Index table should have been dropped");
            }
            catch (TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
            conn.unwrap(PhoenixConnection.class).getQueryServices().getTableDescriptor(localIndexTablePhysicalName);
            PTable localIndex2 = conn.unwrap(PhoenixConnection.class).getTable(new PTableKey(null, localIndexTableName2));
            Scan scan = new Scan();
            scan.addFamily(QueryConstants.DEFAULT_LOCAL_INDEX_COLUMN_FAMILY_BYTES);
            Table table = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(localIndexTablePhysicalName);
            ResultScanner results = table.getScanner(scan);
            Result result = results.next();
            Assert.assertNotNull((Object)result);
            String indexColumnName = IndexUtil.getIndexColumnName((String)"0", (String)"V1");
            PColumn localIndexCol = localIndex2.getColumnForColumnName(indexColumnName);
            if (!this.mutable && this.columnEncoded) {
                SingleCellColumnExpression colExpression = new SingleCellColumnExpression(localIndexCol, indexColumnName, localIndex2.getEncodingScheme(), localIndex2.getImmutableStorageScheme());
                ImmutableBytesPtr ptr = new ImmutableBytesPtr();
                colExpression.evaluate((Tuple)new ResultTuple(result), (ImmutableBytesWritable)ptr);
                colValue = ptr.copyBytesIfNecessary();
            } else {
                colValue = result.getValue(QueryConstants.DEFAULT_LOCAL_INDEX_COLUMN_FAMILY_BYTES, localIndexCol.getColumnQualifierBytes());
            }
            Assert.assertNotNull((String)"localIndexTableName2 row is missing", (Object)colValue);
            Assert.assertNull((Object)results.next());
        }
    }

    @Test
    public void testDropViewIndexColumn() throws Exception {
        String table = DropColumnIT.generateUniqueName();
        String view = DropColumnIT.generateUniqueName();
        String index = DropColumnIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(DropColumnIT.getUrl());){
            conn.setAutoCommit(true);
            try (Statement stmt = conn.createStatement();){
                stmt.execute("CREATE TABLE IF NOT EXISTS " + table + " (ID CHAR(10) NOT NULL,KEY_PREFIX CHAR(3) NOT NULL, CONSTRAINT PK PRIMARY KEY (ID,KEY_PREFIX))");
                stmt.execute("CREATE VIEW IF NOT EXISTS " + view + "  (PK1 DATE NOT NULL,PK2 CHAR(15) NOT NULL,NON_PK1 CHAR(15),NON_PK2 CHAR(15) CONSTRAINT PKVIEW PRIMARY KEY (PK1,PK2)) AS SELECT * FROM " + table + " WHERE KEY_PREFIX = '123'");
                stmt.execute("CREATE INDEX " + index + " ON " + view + " (PK2, PK1) INCLUDE (NON_PK1, NON_PK2)");
                stmt.execute("ALTER VIEW " + view + " DROP COLUMN NON_PK1");
            }
        }
    }

    @Test
    public void testDropViewIndexColumnForMultiTenantTable() throws Exception {
        String table = DropColumnIT.generateUniqueName();
        String view = DropColumnIT.generateUniqueName();
        String index = DropColumnIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(DropColumnIT.getUrl());){
            conn.setAutoCommit(true);
            try (Statement stmt = conn.createStatement();){
                stmt.execute("CREATE TABLE IF NOT EXISTS " + table + " (ID CHAR(10) NOT NULL,KEY_PREFIX CHAR(3) NOT NULL, CONSTRAINT PK PRIMARY KEY (ID,KEY_PREFIX)) MULTI_TENANT=TRUE");
                stmt.execute("CREATE VIEW IF NOT EXISTS " + view + "  (PK1 DATE NOT NULL,PK2 CHAR(15) NOT NULL,NON_PK1 CHAR(15),NON_PK2 CHAR(15) CONSTRAINT PKVIEW PRIMARY KEY (PK1,PK2)) AS SELECT * FROM " + table + " WHERE KEY_PREFIX = '123'");
                stmt.execute("CREATE INDEX " + index + " ON " + view + " (PK2, PK1) INCLUDE (NON_PK1, NON_PK2)");
                stmt.execute("ALTER VIEW " + view + " DROP COLUMN NON_PK1");
            }
        }
    }

    @Test
    public void testDropIndexColumn() throws Exception {
        String table = DropColumnIT.generateUniqueName();
        String index = DropColumnIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(DropColumnIT.getUrl());){
            conn.setAutoCommit(true);
            try (Statement stmt = conn.createStatement();){
                stmt.execute("CREATE TABLE IF NOT EXISTS " + table + " (ID CHAR(10) NOT NULL,KEY_PREFIX CHAR(3) NOT NULL, NON_PK1 CHAR(15),NON_PK2 CHAR(15),  CONSTRAINT PK PRIMARY KEY (ID,KEY_PREFIX))");
                stmt.execute("CREATE INDEX " + index + " ON " + table + " (KEY_PREFIX, ID) INCLUDE (NON_PK1, NON_PK2)");
                stmt.execute("ALTER TABLE " + table + " DROP COLUMN NON_PK1");
            }
        }
    }

    @Test
    public void testDropColumnForMultiTenantTable() throws Exception {
        String table = DropColumnIT.generateUniqueName();
        String view = DropColumnIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(DropColumnIT.getUrl());){
            conn.setAutoCommit(true);
            try (Statement stmt = conn.createStatement();){
                stmt.execute("CREATE TABLE IF NOT EXISTS " + table + " (ID CHAR(10) NOT NULL,KEY_PREFIX CHAR(3) NOT NULL, NON_PK3 CHAR(15), CONSTRAINT PK PRIMARY KEY (ID,KEY_PREFIX)) MULTI_TENANT=TRUE");
                stmt.execute("CREATE VIEW IF NOT EXISTS " + view + "  (PK1 DATE NOT NULL,PK2 CHAR(15) NOT NULL,NON_PK1 CHAR(15),NON_PK2 CHAR(15) CONSTRAINT PKVIEW PRIMARY KEY (PK1,PK2)) AS SELECT * FROM " + table + " WHERE KEY_PREFIX = '123'");
                stmt.execute("ALTER VIEW " + view + " DROP COLUMN NON_PK3");
            }
        }
    }

    @Test
    public void testDropColumnForMultiTenantTableWithIndex() throws Exception {
        String table = DropColumnIT.generateUniqueName();
        String view = DropColumnIT.generateUniqueName();
        String index = DropColumnIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(DropColumnIT.getUrl());){
            conn.setAutoCommit(true);
            try (Statement stmt = conn.createStatement();){
                stmt.execute("CREATE TABLE IF NOT EXISTS " + table + " (ID CHAR(10) NOT NULL,KEY_PREFIX CHAR(3) NOT NULL, NON_PK3 CHAR(15), CONSTRAINT PK PRIMARY KEY (ID,KEY_PREFIX)) MULTI_TENANT=TRUE");
                stmt.execute("CREATE VIEW IF NOT EXISTS " + view + "  (PK1 DATE NOT NULL,PK2 CHAR(15) NOT NULL,NON_PK1 CHAR(15),NON_PK2 CHAR(15) CONSTRAINT PKVIEW PRIMARY KEY (PK1,PK2)) AS SELECT * FROM " + table + " WHERE KEY_PREFIX = '123'");
                stmt.execute("CREATE INDEX " + index + " ON " + view + " (PK2, PK1) INCLUDE (NON_PK1, NON_PK2)");
                stmt.execute("ALTER VIEW " + view + " DROP COLUMN NON_PK3");
            }
        }
    }

    @Test
    public void testDropColumnForTableWithIndex() throws Exception {
        String table = DropColumnIT.generateUniqueName();
        String index = DropColumnIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(DropColumnIT.getUrl());){
            conn.setAutoCommit(true);
            try (Statement stmt = conn.createStatement();){
                stmt.execute("CREATE TABLE IF NOT EXISTS " + table + " (ID CHAR(10) NOT NULL,KEY_PREFIX CHAR(3) NOT NULL, NON_PK1 CHAR(15), CONSTRAINT PK PRIMARY KEY (ID,KEY_PREFIX))");
                stmt.execute("CREATE INDEX " + index + " ON " + table + " (KEY_PREFIX, ID) INCLUDE (NON_PK1)");
                stmt.execute("ALTER TABLE " + table + " DROP COLUMN NON_PK1");
            }
        }
    }

    @Test
    public void testDropColumnForTableWithView() throws Exception {
        String table = DropColumnIT.generateUniqueName();
        String view = DropColumnIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(DropColumnIT.getUrl());){
            conn.setAutoCommit(true);
            try (Statement stmt = conn.createStatement();){
                stmt.execute("CREATE TABLE IF NOT EXISTS " + table + " (ID CHAR(10) NOT NULL,KEY_PREFIX CHAR(3) NOT NULL, NON_PK1 CHAR(15), CONSTRAINT PK PRIMARY KEY (ID,KEY_PREFIX))");
                stmt.execute("CREATE VIEW IF NOT EXISTS " + view + "  (PK1 DATE NOT NULL,PK2 CHAR(15) NOT NULL,NON_PK2 CHAR(15),NON_PK3 CHAR(15) CONSTRAINT PKVIEW PRIMARY KEY (PK1,PK2)) AS SELECT * FROM " + table + " WHERE KEY_PREFIX = '123'");
                stmt.execute("ALTER TABLE " + table + " DROP COLUMN NON_PK1");
            }
        }
    }
}

