/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.schema.PTable;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class ChildViewsUseParentViewIndexIT
extends ParallelStatsDisabledIT {
    @Test
    public void testIndexOnParentViewWithTenantSpecificConnection() throws Exception {
        String baseTableName = "BT_" + ChildViewsUseParentViewIndexIT.generateUniqueName();
        String globalViewName = "GV_" + ChildViewsUseParentViewIndexIT.generateUniqueName();
        String globalViewIdxName = "GVI_" + ChildViewsUseParentViewIndexIT.generateUniqueName();
        String tenantViewName1 = "TV1_" + ChildViewsUseParentViewIndexIT.generateUniqueName();
        String tenantViewName2 = "TV2_" + ChildViewsUseParentViewIndexIT.generateUniqueName();
        Properties props = new Properties();
        props.setProperty("TenantId", "00Dxxxxxxxxxxx1");
        try (Connection conn = DriverManager.getConnection(ChildViewsUseParentViewIndexIT.getUrl());
             Connection tenantConn = DriverManager.getConnection(ChildViewsUseParentViewIndexIT.getUrl(), props);){
            this.createBaseTable(baseTableName, conn);
            this.createGlobalView(globalViewName, baseTableName, conn);
            this.createGlobalIndexOnView(globalViewName, globalViewIdxName, conn);
            this.createTenantSpecificView(globalViewName, tenantViewName1, tenantConn);
            this.createTenantSpecificView(tenantViewName1, tenantViewName2, tenantConn);
            int rowCount = 0;
            this.insertRowIntoView(globalViewName, tenantConn, ++rowCount);
            this.insertRowIntoView(globalViewName, tenantConn, ++rowCount);
            this.insertRowIntoView(globalViewName, tenantConn, ++rowCount);
            this.assertQueryIndex(globalViewName, baseTableName, tenantConn, 3);
            this.insertRowIntoView(tenantViewName1, tenantConn, ++rowCount);
            this.insertRowIntoView(tenantViewName2, tenantConn, ++rowCount);
            this.assertQueryIndex(tenantViewName1, baseTableName, tenantConn, 5);
            this.assertQueryIndex(tenantViewName2, baseTableName, tenantConn, 5);
            this.assertQueryIndex(globalViewName, baseTableName, tenantConn, 5);
        }
    }

    @Test
    public void testParentViewIndexWithSpecializedChildViews() throws Exception {
        String baseTableName = ChildViewsUseParentViewIndexIT.generateUniqueName();
        String parentViewName = ChildViewsUseParentViewIndexIT.generateUniqueName();
        String parentViewIdxName = ChildViewsUseParentViewIndexIT.generateUniqueName();
        String childViewName1 = ChildViewsUseParentViewIndexIT.generateUniqueName();
        String childViewName2 = ChildViewsUseParentViewIndexIT.generateUniqueName();
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(ChildViewsUseParentViewIndexIT.getUrl());){
            String baseTableDdl = "CREATE TABLE " + baseTableName + " (A0 CHAR(1) NOT NULL PRIMARY KEY,A1 CHAR(1),A2 CHAR(1),A3 CHAR(1),A4 CHAR(1))";
            conn.createStatement().execute(baseTableDdl);
            String globalViewDdl = "CREATE VIEW " + parentViewName + " AS SELECT * FROM " + baseTableName + " WHERE A1 = 'X'";
            conn.createStatement().execute(globalViewDdl);
            conn.createStatement().execute("CREATE INDEX " + parentViewIdxName + " ON " + parentViewName + "(A4, A2)");
            String childViewDdl = "CREATE VIEW " + childViewName1 + " AS SELECT * FROM " + parentViewName + " WHERE A2 = 'Y'";
            conn.createStatement().execute(childViewDdl);
            PTable childViewPTable = conn.getTableNoCache(childViewName1);
            String grandChildViewDdl1 = "CREATE VIEW " + childViewName2 + " AS SELECT * FROM " + childViewName1 + " WHERE A3 = 'Z'";
            conn.createStatement().execute(grandChildViewDdl1);
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + parentViewName + " (A0, A2, A3, A4) VALUES(?,?,?,?)");
            stmt.setString(1, "1");
            stmt.setString(2, "Y");
            stmt.setString(3, "Z");
            stmt.setString(4, "1");
            stmt.execute();
            conn.commit();
            stmt = conn.prepareStatement("UPSERT INTO " + childViewName1 + " (A0, A3, A4) VALUES(?,?,?)");
            stmt.setString(1, "2");
            stmt.setString(2, "Z");
            stmt.setString(3, "2");
            stmt.execute();
            conn.commit();
            stmt = conn.prepareStatement("UPSERT INTO " + childViewName2 + " (A0, A4) VALUES(?,?)");
            stmt.setString(1, "3");
            stmt.setString(2, "3");
            stmt.execute();
            conn.commit();
            this.assertQueryUsesIndex(baseTableName, parentViewName, (Connection)conn, false);
            this.assertQueryUsesIndex(baseTableName, childViewName1, (Connection)conn, true);
            this.assertQueryUsesBaseTable(baseTableName, childViewName2, (Connection)conn);
        }
    }

    private void assertQueryUsesIndex(String baseTableName, String viewName, Connection conn, boolean isChildView) throws SQLException {
        String sql = "SELECT A0, A1, A2, A4 FROM " + viewName + " WHERE A4 IN ('1', '2', '3') ORDER BY A4, A2";
        ExplainPlan plan = conn.prepareStatement(sql).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
        Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
        Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
        Assert.assertEquals((Object)"SKIP SCAN ON 3 KEYS ", (Object)explainPlanAttributes.getExplainScanType());
        Assert.assertEquals((Object)("_IDX_" + baseTableName), (Object)explainPlanAttributes.getTableName());
        String childViewScanKey = isChildView ? ",'Y'" : "";
        Assert.assertEquals((Object)(" [-32768,'1'" + childViewScanKey + "] - [-32768,'3'" + childViewScanKey + "]"), (Object)explainPlanAttributes.getKeyRanges());
        ResultSet rs = conn.createStatement().executeQuery(sql);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"1", (Object)rs.getString(1));
        Assert.assertEquals((Object)"X", (Object)rs.getString(2));
        Assert.assertEquals((Object)"Y", (Object)rs.getString(3));
        Assert.assertEquals((Object)"1", (Object)rs.getString(4));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"2", (Object)rs.getString(1));
        Assert.assertEquals((Object)"X", (Object)rs.getString(2));
        Assert.assertEquals((Object)"Y", (Object)rs.getString(3));
        Assert.assertEquals((Object)"2", (Object)rs.getString(4));
        Assert.assertFalse((boolean)rs.next());
    }

    private void assertQueryUsesBaseTable(String baseTableName, String viewName, Connection conn) throws SQLException {
        String sql = "SELECT A0, A1, A2, A4 FROM " + viewName + " WHERE A4 IN ('1', '2', '3') ";
        ExplainPlan plan = conn.prepareStatement(sql).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
        Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
        Assert.assertEquals((Object)"SERVER FILTER BY (A4 IN ('1','2','3') AND ((A1 = 'X' AND A2 = 'Y') AND A3 = 'Z'))", (Object)explainPlanAttributes.getServerWhereFilter());
        Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
        Assert.assertEquals((Object)baseTableName, (Object)explainPlanAttributes.getTableName());
        ResultSet rs = conn.createStatement().executeQuery(sql);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"1", (Object)rs.getString(1));
        Assert.assertEquals((Object)"X", (Object)rs.getString(2));
        Assert.assertEquals((Object)"Y", (Object)rs.getString(3));
        Assert.assertEquals((Object)"1", (Object)rs.getString(4));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"2", (Object)rs.getString(1));
        Assert.assertEquals((Object)"X", (Object)rs.getString(2));
        Assert.assertEquals((Object)"Y", (Object)rs.getString(3));
        Assert.assertEquals((Object)"2", (Object)rs.getString(4));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"3", (Object)rs.getString(1));
        Assert.assertEquals((Object)"X", (Object)rs.getString(2));
        Assert.assertEquals((Object)"Y", (Object)rs.getString(3));
        Assert.assertEquals((Object)"3", (Object)rs.getString(4));
        Assert.assertFalse((boolean)rs.next());
    }

    private void createBaseTable(String baseTableName, Connection conn) throws SQLException {
        String baseTableDdl = "CREATE TABLE " + baseTableName + " (OID CHAR(15) NOT NULL,\nKP CHAR(3) NOT NULL\n,CREATED_DATE DATE\n,CREATED_BY CHAR(3)\n,CONSTRAINT PK PRIMARY KEY (oid, kp))\n";
        String ddlOptions = "MULTI_TENANT=true, IMMUTABLE_ROWS=TRUE, VERSIONS=1";
        conn.createStatement().execute(baseTableDdl + ddlOptions);
    }

    private void createGlobalView(String globalViewName, String baseTableName, Connection conn) throws SQLException {
        String globalViewDdl = "CREATE VIEW IF NOT EXISTS " + globalViewName + " (A_DATE DATE NOT NULL,WO_ID CHAR(15) NOT NULL,WA_ID CHAR(15) NOT NULL,C_TYPE VARCHAR NOT NULL,CA_TYPE VARCHAR NOT NULL,V_ID CHAR(15),C_CTX VARCHAR,CONSTRAINT PKVIEW PRIMARY KEY (A_DATE, WO_ID, WA_ID, C_TYPE, CA_TYPE))AS SELECT * FROM " + baseTableName + " WHERE KP = 'xyz'";
        conn.createStatement().execute(globalViewDdl);
    }

    private void createGlobalIndexOnView(String globalViewName, String globalViewIdxName, Connection conn) throws SQLException {
        String globalViewIdxDdl = "CREATE INDEX IF NOT EXISTS " + globalViewIdxName + " ON " + globalViewName + "(WO_ID, A_DATE DESC)";
        conn.createStatement().execute(globalViewIdxDdl);
    }

    private void createTenantSpecificView(String parentViewName, String tenantViewName, Connection conn) throws SQLException {
        String tenantSpecificViewDdl = "CREATE VIEW IF NOT EXISTS " + tenantViewName + " AS SELECT * FROM " + parentViewName;
        conn.createStatement().execute(tenantSpecificViewDdl);
    }

    private void insertRowIntoView(String viewName, Connection conn, int rowCount) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + viewName + " (A_DATE, WO_ID, WA_ID, C_TYPE, CA_TYPE, V_ID) VALUES(?,?,?,?,?,?)");
        stmt.setDate(1, new Date(System.currentTimeMillis()));
        stmt.setString(2, "003xxxxxxxxxxx" + rowCount);
        stmt.setString(3, "701xxxxxxxxxxx" + rowCount);
        stmt.setString(4, "ctype1");
        stmt.setString(5, "catype1");
        stmt.setString(6, "xyzxxxxxxxxxxx" + rowCount);
        stmt.execute();
        conn.commit();
    }

    private void assertQueryIndex(String viewName, String baseTableName, Connection conn, int expectedRows) throws SQLException {
        String sql = "SELECT WO_ID FROM " + viewName + " WHERE WO_ID IN ('003xxxxxxxxxxx1', '003xxxxxxxxxxx2', '003xxxxxxxxxxx3', '003xxxxxxxxxxx4', '003xxxxxxxxxxx5')  AND (A_DATE > TO_DATE('2016-01-01 06:00:00.0'))  ORDER BY WO_ID, A_DATE DESC";
        ExplainPlan plan = conn.prepareStatement(sql).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
        Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
        Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
        Assert.assertEquals((Object)"SKIP SCAN ON 5 RANGES ", (Object)explainPlanAttributes.getExplainScanType());
        Assert.assertEquals((Object)("_IDX_" + baseTableName), (Object)explainPlanAttributes.getTableName());
        Assert.assertEquals((Object)" [-32768,'00Dxxxxxxxxxxx1','003xxxxxxxxxxx1',*] - [-32768,'00Dxxxxxxxxxxx1','003xxxxxxxxxxx5',~'2016-01-01 06:00:00.000']", (Object)explainPlanAttributes.getKeyRanges());
        ResultSet rs = conn.createStatement().executeQuery(sql);
        for (int i = 0; i < expectedRows; ++i) {
            Assert.assertTrue((boolean)rs.next());
        }
        Assert.assertFalse((boolean)rs.next());
    }
}

