/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class BaseLocalIndexIT
extends BaseTest {
    protected boolean isNamespaceMapped;
    protected String schemaName;

    public BaseLocalIndexIT(boolean isNamespaceMapped) {
        this.isNamespaceMapped = isNamespaceMapped;
    }

    @Before
    public void setup() {
        this.schemaName = BaseTest.generateUniqueName();
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap serverProps = Maps.newHashMapWithExpectedSize((int)7);
        serverProps.put("phoenix.schema.isNamespaceMappingEnabled", "true");
        HashMap clientProps = Maps.newHashMapWithExpectedSize((int)1);
        clientProps.put("phoenix.schema.isNamespaceMappingEnabled", "true");
        clientProps.put("phoenix.stats.minUpdateFrequency", "120000");
        clientProps.put("phoenix.max.region.locations.size.explain.plan", "2");
        BaseLocalIndexIT.setUpTestDriver(new ReadOnlyProps(serverProps.entrySet().iterator()), new ReadOnlyProps(clientProps.entrySet().iterator()));
    }

    protected Connection getConnection() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.schema.isNamespaceMappingEnabled", Boolean.toString(this.isNamespaceMapped));
        return DriverManager.getConnection(BaseLocalIndexIT.getUrl(), props);
    }

    protected void createBaseTable(String tableName, Integer saltBuckets, String splits) throws SQLException {
        this.createBaseTable(tableName, saltBuckets, splits, null);
    }

    protected void createBaseTable(String tableName, Integer saltBuckets, String splits, String cf) throws SQLException {
        Connection conn = this.getConnection();
        if (this.isNamespaceMapped) {
            conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + this.schemaName);
        }
        String ddl = "CREATE TABLE " + tableName + " (t_id VARCHAR NOT NULL,\nk1 INTEGER NOT NULL,\nk2 INTEGER NOT NULL,\nk3 INTEGER,\n" + (String)(cf != null ? cf + "." : "") + "v1 VARCHAR,\nCONSTRAINT pk PRIMARY KEY (t_id, k1, k2))\n" + (saltBuckets != null && splits == null ? " salt_buckets=" + saltBuckets : (String)(saltBuckets == null && splits != null ? " split on " + splits : ""));
        conn.createStatement().execute(ddl);
        conn.close();
    }

    @Parameterized.Parameters(name="LocalIndexIT_isNamespaceMapped={0}")
    public static synchronized Collection<Boolean> data() {
        return Arrays.asList(true, false);
    }
}

