/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.end2end.CreateTableIT;
import org.apache.phoenix.end2end.IndexToolIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledWithRegionMovesIT;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.NamedTableNode;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.transaction.PhoenixTransactionProvider;
import org.apache.phoenix.transaction.TransactionFactory;
import org.apache.phoenix.util.DateUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.apache.phoenix.util.TransactionUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class BaseIndexWithRegionMovesIT
extends ParallelStatsDisabledWithRegionMovesIT {
    private static final Random RAND = new Random();
    private final boolean localIndex;
    private final boolean uncovered;
    private final boolean transactional;
    private final TransactionFactory.Provider transactionProvider;
    private final boolean mutable;
    private final boolean columnEncoded;
    private final String tableDDLOptions;

    protected BaseIndexWithRegionMovesIT(boolean localIndex, boolean uncovered, boolean mutable, String transactionProvider, boolean columnEncoded) {
        this.localIndex = localIndex;
        this.uncovered = uncovered;
        this.mutable = mutable;
        this.columnEncoded = columnEncoded;
        StringBuilder optionBuilder = new StringBuilder();
        if (!columnEncoded) {
            if (optionBuilder.length() != 0) {
                optionBuilder.append(",");
            }
            optionBuilder.append("COLUMN_ENCODED_BYTES=0");
        }
        if (!mutable) {
            if (optionBuilder.length() != 0) {
                optionBuilder.append(",");
            }
            optionBuilder.append("IMMUTABLE_ROWS=true");
            if (!columnEncoded) {
                optionBuilder.append(",IMMUTABLE_STORAGE_SCHEME=" + PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN);
            }
        }
        boolean bl = this.transactional = transactionProvider != null;
        if (this.transactional) {
            if (optionBuilder.length() != 0) {
                optionBuilder.append(",");
            }
            optionBuilder.append(" TRANSACTIONAL=true,TRANSACTION_PROVIDER='" + transactionProvider + "'");
            this.transactionProvider = TransactionFactory.Provider.valueOf((String)transactionProvider);
        } else {
            this.transactionProvider = null;
        }
        this.tableDDLOptions = optionBuilder.toString();
    }

    @Before
    public void setUp() throws Exception {
        hasTestStarted = true;
    }

    @After
    public void tearDown() throws Exception {
        countOfDummyResults = 0;
        TABLE_NAMES.clear();
        hasTestStarted = false;
    }

    @Test
    public void testIndexWithNullableFixedWithCols() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = "TBL_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String indexName = "IND_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)"S", (String)indexName);
        try (Connection conn = DriverManager.getConnection(BaseIndexWithRegionMovesIT.getUrl(), props);){
            conn.setAutoCommit(false);
            String ddl = "CREATE TABLE " + fullTableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) " + this.tableDDLOptions;
            Statement stmt = conn.createStatement();
            stmt.execute(ddl);
            BaseTest.populateTestTable(fullTableName);
            ddl = "CREATE " + (this.localIndex ? "LOCAL" : "") + (this.uncovered ? "UNCOVERED" : "") + " INDEX " + indexName + " ON " + fullTableName + " (char_col1 ASC, int_col1 ASC)" + (this.uncovered ? "" : " INCLUDE (long_col1, long_col2)");
            stmt.execute(ddl);
            TABLE_NAMES.add(fullTableName);
            TABLE_NAMES.add(fullIndexName);
            String query = "SELECT d.char_col1, int_col1 from " + fullTableName + " as d";
            ExplainPlan plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            if (!this.uncovered) {
                Assert.assertEquals((Object)(this.columnEncoded ? "SERVER FILTER BY FIRST KEY ONLY" : "SERVER FILTER BY EMPTY COLUMN ONLY"), (Object)explainPlanAttributes.getServerWhereFilter());
            }
            if (this.localIndex) {
                Assert.assertEquals((Object)fullTableName, (Object)explainPlanAttributes.getTableName());
                Assert.assertEquals((Object)" [1]", (Object)explainPlanAttributes.getKeyRanges());
                Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
                Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            } else if (!this.uncovered) {
                Assert.assertEquals((Object)fullIndexName, (Object)explainPlanAttributes.getTableName());
                Assert.assertNull((Object)explainPlanAttributes.getClientSortAlgo());
                Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            }
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
            Assert.assertEquals((Object)"chara", (Object)rs.getString(1));
            Assert.assertEquals((Object)"chara", (Object)rs.getString("char_col1"));
            Assert.assertEquals((long)2L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
            Assert.assertEquals((Object)"chara", (Object)rs.getString(1));
            Assert.assertEquals((long)3L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
            Assert.assertEquals((Object)"chara", (Object)rs.getString(1));
            Assert.assertEquals((long)4L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
            conn.createStatement().execute("DROP INDEX " + indexName + " ON " + fullTableName);
            query = "SELECT char_col1, int_col1 from " + fullTableName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            query = "SELECT char_col1, int_col1 from " + fullIndexName;
            try {
                rs = conn.createStatement().executeQuery(query);
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.TABLE_UNDEFINED.getErrorCode(), (long)e.getErrorCode());
            }
        }
    }

    @Test
    public void testDeleteFromAllPKColumnIndex() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = "TBL_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String indexName = "IND_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)"S", (String)indexName);
        try (Connection conn = DriverManager.getConnection(BaseIndexWithRegionMovesIT.getUrl(), props);){
            conn.setAutoCommit(false);
            String ddl = "CREATE TABLE " + fullTableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) " + this.tableDDLOptions;
            Statement stmt = conn.createStatement();
            stmt.execute(ddl);
            BaseTest.populateTestTable(fullTableName);
            ddl = "CREATE " + (this.localIndex ? "LOCAL" : "") + (this.uncovered ? "UNCOVERED" : "") + " INDEX " + indexName + " ON " + fullTableName + " (long_pk, varchar_pk)" + (this.uncovered ? "" : " INCLUDE (long_col1, long_col2)");
            stmt.execute(ddl);
            TABLE_NAMES.add(fullTableName);
            TABLE_NAMES.add(fullIndexName);
            ResultSet rs = conn.createStatement().executeQuery("SELECT /*+ NO_INDEX */ COUNT(*) FROM " + fullTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + fullIndexName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            String dml = "DELETE from " + fullTableName + " WHERE long_col2 = 4";
            Assert.assertEquals((long)1L, (long)conn.createStatement().executeUpdate(dml));
            this.assertNoClientSideIndexMutations(conn);
            conn.commit();
            String query = "SELECT /*+ NO_INDEX */ long_pk FROM " + fullTableName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
            Assert.assertEquals((long)1L, (long)rs.getLong(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT long_pk FROM " + fullTableName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
            Assert.assertEquals((long)1L, (long)rs.getLong(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT * FROM " + fullIndexName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
            Assert.assertEquals((long)1L, (long)rs.getLong(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
            TABLE_NAMES.clear();
            conn.createStatement().execute("DROP INDEX " + indexName + " ON " + fullTableName);
        }
    }

    private void assertNoClientSideIndexMutations(Connection conn) throws SQLException {
        Iterator iterator = PhoenixRuntime.getUncommittedDataIterator((Connection)conn);
        if (iterator.hasNext()) {
            boolean clientSideUpdate;
            byte[] tableName = (byte[])((Pair)iterator.next()).getFirst();
            PTable table = PhoenixRuntime.getTable((Connection)conn, (String)Bytes.toString((byte[])tableName));
            boolean bl = clientSideUpdate = (!this.localIndex || this.transactional && table.getTransactionProvider().getTransactionProvider().isUnsupported(PhoenixTransactionProvider.Feature.MAINTAIN_LOCAL_INDEX_ON_SERVER)) && (!this.mutable || this.transactional);
            if (!clientSideUpdate) {
                Assert.assertTrue((table.getType() == PTableType.TABLE ? 1 : 0) != 0);
            }
            boolean hasIndexData = iterator.hasNext();
            Assert.assertEquals((Object)clientSideUpdate, (Object)hasIndexData);
        }
    }

    @Test
    public void testCreateIndexAfterUpsertStarted() throws Exception {
        this.testCreateIndexAfterUpsertStarted(this.transactional, SchemaUtil.getTableName((String)"S", (String)BaseIndexWithRegionMovesIT.generateUniqueName()), SchemaUtil.getTableName((String)"S", (String)BaseIndexWithRegionMovesIT.generateUniqueName()));
    }

    private void testCreateIndexAfterUpsertStarted(boolean readOwnWrites, String fullTableName, String fullIndexName) throws Exception {
        block15: {
            Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            try (Connection conn1 = DriverManager.getConnection(BaseIndexWithRegionMovesIT.getUrl(), props);){
                conn1.setAutoCommit(true);
                String ddl = "CREATE TABLE " + fullTableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) " + this.tableDDLOptions;
                Statement stmt1 = conn1.createStatement();
                stmt1.execute(ddl);
                BaseTest.populateTestTable(fullTableName);
                TABLE_NAMES.add(fullTableName);
                ResultSet rs = conn1.createStatement().executeQuery("SELECT COUNT(*) FROM " + fullTableName);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)3L, (long)rs.getInt(1));
                try (Connection conn2 = DriverManager.getConnection(BaseIndexWithRegionMovesIT.getUrl(), props);){
                    String upsert = "UPSERT INTO " + fullTableName + " VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                    PreparedStatement pstmt2 = conn2.prepareStatement(upsert);
                    pstmt2.setString(1, "varchar4");
                    pstmt2.setString(2, "char4");
                    pstmt2.setInt(3, 4);
                    pstmt2.setLong(4, 4L);
                    pstmt2.setBigDecimal(5, new BigDecimal(4.0));
                    Date date = DateUtil.parseDate((String)"2015-01-01 00:00:00");
                    pstmt2.setDate(6, date);
                    pstmt2.setString(7, "varchar_a");
                    pstmt2.setString(8, "chara");
                    pstmt2.setInt(9, 2);
                    pstmt2.setLong(10, 2L);
                    pstmt2.setBigDecimal(11, new BigDecimal(2.0));
                    pstmt2.setDate(12, date);
                    pstmt2.setString(13, "varchar_b");
                    pstmt2.setString(14, "charb");
                    pstmt2.setInt(15, 3);
                    pstmt2.setLong(16, 3L);
                    pstmt2.setBigDecimal(17, new BigDecimal(3.0));
                    pstmt2.setDate(18, date);
                    pstmt2.executeUpdate();
                    if (readOwnWrites) {
                        String query = "SELECT long_pk FROM " + fullTableName + " WHERE long_pk=4";
                        rs = conn2.createStatement().executeQuery(query);
                        Assert.assertTrue((boolean)rs.next());
                        Assert.assertFalse((boolean)rs.next());
                    }
                    String indexName = SchemaUtil.getTableNameFromFullName((String)fullIndexName);
                    ddl = "CREATE " + (this.localIndex ? "LOCAL" : "") + (this.uncovered ? "UNCOVERED" : "") + " INDEX " + indexName + " ON " + fullTableName + " (long_pk, varchar_pk)" + (this.uncovered ? "" : " INCLUDE (long_col1, long_col2)");
                    stmt1.execute(ddl);
                    conn2.commit();
                    stmt1 = conn1.createStatement();
                    rs = stmt1.executeQuery("SELECT COUNT(*) FROM " + fullTableName);
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((long)4L, (long)rs.getInt(1));
                    Assert.assertEquals((Object)fullIndexName, (Object)stmt1.unwrap(PhoenixStatement.class).getQueryPlan().getTableRef().getTable().getName().getString());
                    String query = "SELECT /*+ NO_INDEX */ long_pk FROM " + fullTableName;
                    rs = conn1.createStatement().executeQuery(query);
                    Assert.assertTrue((boolean)rs.next());
                    BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
                    BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
                    Assert.assertEquals((long)1L, (long)rs.getLong(1));
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((long)2L, (long)rs.getLong(1));
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((long)3L, (long)rs.getLong(1));
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((long)4L, (long)rs.getLong(1));
                    Assert.assertFalse((boolean)rs.next());
                }
            }
            catch (Exception e) {
                if (this.transactional) break block15;
                Assert.fail((String)"Should not fail for non-transactional tables");
            }
        }
    }

    @Test
    public void testDeleteFromNonPKColumnIndex() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = "TBL_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String indexName = "IND_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)"S", (String)indexName);
        String ddl = "CREATE TABLE " + fullTableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) " + this.tableDDLOptions;
        try (Connection conn = DriverManager.getConnection(BaseIndexWithRegionMovesIT.getUrl(), props);){
            conn.setAutoCommit(false);
            Statement stmt = conn.createStatement();
            stmt.execute(ddl);
            BaseTest.populateTestTable(fullTableName);
            ddl = "CREATE " + (this.localIndex ? "LOCAL" : "") + (this.uncovered ? "UNCOVERED" : "") + " INDEX " + indexName + " ON " + fullTableName + " (long_col1, long_col2)" + (this.uncovered ? "" : " INCLUDE (decimal_col1, decimal_col2)");
            stmt.execute(ddl);
            TABLE_NAMES.add(fullTableName);
            TABLE_NAMES.add(fullIndexName);
        }
        conn = DriverManager.getConnection(BaseIndexWithRegionMovesIT.getUrl(), props);
        try {
            ResultSet rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + fullTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + fullIndexName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            String dml = "DELETE from " + fullTableName + " WHERE long_col2 = 4";
            Assert.assertEquals((long)1L, (long)conn.createStatement().executeUpdate(dml));
            this.assertNoClientSideIndexMutations(conn);
            conn.commit();
            String query = "SELECT /*+ NO_INDEX */ long_pk FROM " + fullTableName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
            Assert.assertEquals((long)1L, (long)rs.getLong(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT long_pk FROM " + fullTableName + " ORDER BY long_col1";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
            Assert.assertEquals((long)1L, (long)rs.getLong(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
            conn.createStatement().execute("DROP INDEX " + indexName + " ON " + fullTableName);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Test
    public void testGroupByCount() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = "TBL_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String indexName = "IND_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)"S", (String)indexName);
        try (Connection conn = DriverManager.getConnection(BaseIndexWithRegionMovesIT.getUrl(), props);){
            conn.setAutoCommit(false);
            String ddl = "CREATE TABLE " + fullTableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) " + this.tableDDLOptions;
            Statement stmt = conn.createStatement();
            stmt.execute(ddl);
            BaseTest.populateTestTable(fullTableName);
            ddl = "CREATE " + (this.localIndex ? "LOCAL" : "") + (this.uncovered ? "UNCOVERED" : "") + " INDEX " + indexName + " ON " + fullTableName + " (int_col2)";
            stmt.execute(ddl);
            TABLE_NAMES.add(fullTableName);
            TABLE_NAMES.add(fullIndexName);
            ResultSet rs = conn.createStatement().executeQuery("SELECT int_col2, COUNT(*) FROM " + fullTableName + " GROUP BY int_col2");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
        }
    }

    @Test
    public void testSelectDistinctOnTableWithSecondaryImmutableIndex() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = "TBL_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String indexName = "IND_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)"S", (String)indexName);
        try (Connection conn = DriverManager.getConnection(BaseIndexWithRegionMovesIT.getUrl(), props);){
            conn.setAutoCommit(false);
            String ddl = "CREATE TABLE " + fullTableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) " + this.tableDDLOptions;
            Statement stmt = conn.createStatement();
            stmt.execute(ddl);
            BaseTest.populateTestTable(fullTableName);
            ddl = "CREATE " + (this.localIndex ? "LOCAL" : "") + (this.uncovered ? "UNCOVERED" : "") + " INDEX " + indexName + " ON " + fullTableName + " (int_col2)";
            conn.createStatement().execute(ddl);
            TABLE_NAMES.add(fullTableName);
            TABLE_NAMES.add(fullIndexName);
            ResultSet rs = conn.createStatement().executeQuery("SELECT distinct int_col2 FROM " + fullTableName + " where int_col2 > 0");
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
            Assert.assertEquals((long)5L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testInClauseWithIndexOnColumnOfUsignedIntType() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = "TBL_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String indexName = "IND_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)"S", (String)indexName);
        try (Connection conn = DriverManager.getConnection(BaseIndexWithRegionMovesIT.getUrl(), props);){
            conn.setAutoCommit(false);
            String ddl = "CREATE TABLE " + fullTableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) " + this.tableDDLOptions;
            Statement stmt = conn.createStatement();
            stmt.execute(ddl);
            BaseTest.populateTestTable(fullTableName);
            ddl = "CREATE " + (this.localIndex ? "LOCAL" : "") + (this.uncovered ? "UNCOVERED" : "") + " INDEX " + indexName + " ON " + fullTableName + " (int_col1)";
            stmt.execute(ddl);
            TABLE_NAMES.add(fullTableName);
            TABLE_NAMES.add(fullIndexName);
            ResultSet rs = conn.createStatement().executeQuery("SELECT int_col1 FROM " + fullTableName + " where int_col1 IN (1, 2, 3, 4)");
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void createIndexOnTableWithSpecifiedDefaultCF() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = "TBL_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String indexName = "IND_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)"S", (String)indexName);
        try (Connection conn = DriverManager.getConnection(BaseIndexWithRegionMovesIT.getUrl(), props);){
            conn.setAutoCommit(false);
            String ddl = "CREATE TABLE " + fullTableName + " (k VARCHAR NOT NULL PRIMARY KEY, v1 VARCHAR, v2 VARCHAR) DEFAULT_COLUMN_FAMILY='A'" + (String)(!this.tableDDLOptions.isEmpty() ? "," + this.tableDDLOptions : "");
            Statement stmt = conn.createStatement();
            stmt.execute(ddl);
            TABLE_NAMES.add(fullTableName);
            String query = "SELECT * FROM " + fullTableName;
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
            String options = this.localIndex ? "SALT_BUCKETS=10, MULTI_TENANT=true, IMMUTABLE_ROWS=true, DISABLE_WAL=true" : "";
            conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED" : "") + " INDEX " + indexName + " ON " + fullTableName + " (v1)" + (this.uncovered ? " " : "INCLUDE (v2) ") + options);
            query = "SELECT * FROM " + fullIndexName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
            TableName indexTableName = TableName.create((String)"S", (String)indexName);
            TABLE_NAMES.add(fullIndexName);
            NamedTableNode indexNode = NamedTableNode.create(null, (TableName)indexTableName, null);
            ColumnResolver resolver = FromCompiler.getResolver((NamedTableNode)indexNode, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            PTable indexTable = ((TableRef)resolver.getTables().get(0)).getTable();
            Assert.assertNull((Object)indexTable.getDefaultFamilyName());
            Assert.assertFalse((boolean)indexTable.isMultiTenant());
            Assert.assertEquals((Object)this.mutable, (Object)(!indexTable.isImmutableRows() ? 1 : 0));
            if (this.localIndex) {
                Assert.assertEquals((long)10L, (long)indexTable.getBucketNum().intValue());
                Assert.assertTrue((boolean)indexTable.isWALDisabled());
            }
        }
    }

    @Test
    public void testIndexWithNullableDateCol() throws Exception {
        String tableName = "TBL_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String indexName = "IND_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)"S", (String)indexName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(BaseIndexWithRegionMovesIT.getUrl(), props);){
            conn.setAutoCommit(false);
            Date date = new Date(System.currentTimeMillis());
            TestUtil.createMultiCFTestTable(conn, fullTableName, this.tableDDLOptions);
            BaseIndexWithRegionMovesIT.populateMultiCFTestTable(fullTableName, date);
            String ddl = "CREATE " + (this.localIndex ? " LOCAL " : "") + (this.uncovered ? "UNCOVERED" : "") + " INDEX " + indexName + " ON " + fullTableName + " (date_col)";
            conn.createStatement().execute(ddl);
            TABLE_NAMES.add(fullTableName);
            TABLE_NAMES.add(fullIndexName);
            String query = "SELECT" + (String)(this.uncovered ? " /*+ INDEX(" + fullTableName + " " + indexName + ")*/ " : " ") + "int_pk from " + fullTableName;
            ExplainPlan plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)(this.columnEncoded ? "SERVER FILTER BY FIRST KEY ONLY" : "SERVER FILTER BY EMPTY COLUMN ONLY"), (Object)explainPlanAttributes.getServerWhereFilter());
            if (this.localIndex) {
                Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
                Assert.assertEquals((Object)fullTableName, (Object)explainPlanAttributes.getTableName());
                Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
                Assert.assertEquals((Object)" [1]", (Object)explainPlanAttributes.getKeyRanges());
            } else {
                Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
                Assert.assertEquals((Object)fullIndexName, (Object)explainPlanAttributes.getTableName());
                Assert.assertNull((Object)explainPlanAttributes.getClientSortAlgo());
            }
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT date_col from " + fullTableName + " order by date_col";
            plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)(this.columnEncoded ? "SERVER FILTER BY FIRST KEY ONLY" : "SERVER FILTER BY EMPTY COLUMN ONLY"), (Object)explainPlanAttributes.getServerWhereFilter());
            if (this.localIndex) {
                Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
                Assert.assertEquals((Object)fullTableName, (Object)explainPlanAttributes.getTableName());
                Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
                Assert.assertEquals((Object)" [1]", (Object)explainPlanAttributes.getKeyRanges());
            } else {
                Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
                Assert.assertEquals((Object)fullIndexName, (Object)explainPlanAttributes.getTableName());
                Assert.assertNull((Object)explainPlanAttributes.getClientSortAlgo());
            }
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
            Assert.assertEquals((Object)date, (Object)rs.getDate(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)new Date(date.getTime() + 86400000L), (Object)rs.getDate(1));
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
            Assert.assertEquals((Object)new Date(date.getTime() + 172800000L), (Object)rs.getDate(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testSelectAllAndAliasWithIndex() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = "TBL_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String indexName = "IND_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)"S", (String)indexName);
        try (Connection conn = DriverManager.getConnection(BaseIndexWithRegionMovesIT.getUrl(), props);){
            conn.setAutoCommit(false);
            String ddl = "CREATE TABLE " + fullTableName + " (k VARCHAR NOT NULL PRIMARY KEY, v1 VARCHAR, v2 VARCHAR) " + this.tableDDLOptions;
            conn.createStatement().execute(ddl);
            TABLE_NAMES.add(fullTableName);
            TABLE_NAMES.add(fullIndexName);
            String query = "SELECT * FROM " + fullTableName;
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
            ddl = "CREATE " + (this.localIndex ? " LOCAL " : "") + (this.uncovered ? "UNCOVERED" : "") + " INDEX " + indexName + " ON " + fullTableName + " (v2 DESC)" + (this.uncovered ? "" : "INCLUDE (v1)");
            conn.createStatement().execute(ddl);
            query = "SELECT" + (this.uncovered ? " /*+ INDEX(" + fullTableName + " " + indexName + ")*/ * FROM " + fullTableName : " * FROM " + fullIndexName);
            rs = conn.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + fullTableName + " VALUES(?,?,?)");
            stmt.setString(1, "a");
            stmt.setString(2, "x");
            stmt.setString(3, "1");
            stmt.execute();
            stmt.setString(1, "b");
            stmt.setString(2, "y");
            stmt.setString(3, "2");
            stmt.execute();
            conn.commit();
            query = "SELECT" + (String)(this.uncovered ? " /*+ INDEX(" + fullTableName + " " + indexName + ")*/" : "") + " * FROM " + fullTableName;
            ExplainPlan plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            if (this.localIndex) {
                Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
                Assert.assertEquals((Object)fullTableName, (Object)explainPlanAttributes.getTableName());
                Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
                Assert.assertEquals((Object)" [1]", (Object)explainPlanAttributes.getKeyRanges());
            } else {
                Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
                Assert.assertEquals((Object)fullIndexName, (Object)explainPlanAttributes.getTableName());
                Assert.assertNull((Object)explainPlanAttributes.getClientSortAlgo());
            }
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((Object)"y", (Object)rs.getString(2));
            Assert.assertEquals((Object)"2", (Object)rs.getString(3));
            Assert.assertEquals((Object)"b", (Object)rs.getString("k"));
            Assert.assertEquals((Object)"y", (Object)rs.getString("v1"));
            Assert.assertEquals((Object)"2", (Object)rs.getString("v2"));
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"x", (Object)rs.getString(2));
            Assert.assertEquals((Object)"1", (Object)rs.getString(3));
            Assert.assertEquals((Object)"a", (Object)rs.getString("k"));
            Assert.assertEquals((Object)"x", (Object)rs.getString("v1"));
            Assert.assertEquals((Object)"1", (Object)rs.getString("v2"));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT v1 as foo FROM " + fullTableName + " WHERE v2 = '1' ORDER BY foo";
            plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            Assert.assertEquals((Object)"[\"V1\"]", (Object)explainPlanAttributes.getServerSortedBy());
            Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
            if (this.localIndex) {
                Assert.assertEquals((Object)fullTableName, (Object)explainPlanAttributes.getTableName());
            } else {
                Assert.assertEquals((Object)fullIndexName, (Object)explainPlanAttributes.getTableName());
            }
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"x", (Object)rs.getString("foo"));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testSelectCF() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = "TBL_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String indexName = "IND_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)"S", (String)indexName);
        try (Connection conn = DriverManager.getConnection(BaseIndexWithRegionMovesIT.getUrl(), props);){
            conn.setAutoCommit(false);
            String ddl = "CREATE TABLE " + fullTableName + " (k VARCHAR NOT NULL PRIMARY KEY, a.v1 VARCHAR, a.v2 VARCHAR, b.v1 VARCHAR) " + this.tableDDLOptions;
            conn.createStatement().execute(ddl);
            String query = "SELECT * FROM " + fullTableName;
            TABLE_NAMES.add(fullTableName);
            TABLE_NAMES.add(fullIndexName);
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
            ddl = "CREATE " + (this.localIndex ? " LOCAL " : "") + (this.uncovered ? "UNCOVERED" : "") + " INDEX " + indexName + " ON " + fullTableName + " (v2 DESC)" + (this.uncovered ? "" : "INCLUDE (a.v1)");
            conn.createStatement().execute(ddl);
            query = "SELECT * FROM " + fullIndexName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + fullTableName + " VALUES(?,?,?,?)");
            stmt.setString(1, "a");
            stmt.setString(2, "x");
            stmt.setString(3, "1");
            stmt.setString(4, "A");
            stmt.execute();
            stmt.setString(1, "b");
            stmt.setString(2, "y");
            stmt.setString(3, "2");
            stmt.setString(4, "B");
            stmt.execute();
            conn.commit();
            query = "SELECT * FROM " + fullTableName;
            ExplainPlan plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            Assert.assertEquals((Object)fullTableName, (Object)explainPlanAttributes.getTableName());
            query = "SELECT" + (String)(this.uncovered ? " /*+ INDEX(" + fullTableName + " " + indexName + ")*/ " : " ") + "a.* FROM " + fullTableName;
            plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            if (this.localIndex) {
                Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
                Assert.assertEquals((Object)fullTableName, (Object)explainPlanAttributes.getTableName());
                Assert.assertEquals((Object)" [1]", (Object)explainPlanAttributes.getKeyRanges());
                Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
            } else {
                Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
                Assert.assertEquals((Object)fullIndexName, (Object)explainPlanAttributes.getTableName());
            }
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
            Assert.assertEquals((Object)"y", (Object)rs.getString(1));
            Assert.assertEquals((Object)"2", (Object)rs.getString(2));
            Assert.assertEquals((Object)"y", (Object)rs.getString("v1"));
            Assert.assertEquals((Object)"2", (Object)rs.getString("v2"));
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"1", (Object)rs.getString(2));
            Assert.assertEquals((Object)"x", (Object)rs.getString("v1"));
            Assert.assertEquals((Object)"1", (Object)rs.getString("v2"));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testUpsertAfterIndexDrop() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = "TBL_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String indexName = "IND_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)"S", (String)indexName);
        TABLE_NAMES.add(fullTableName);
        TABLE_NAMES.add(fullIndexName);
        try (Connection conn = DriverManager.getConnection(BaseIndexWithRegionMovesIT.getUrl(), props);){
            conn.setAutoCommit(false);
            conn.createStatement().execute("CREATE TABLE " + fullTableName + " (k VARCHAR NOT NULL PRIMARY KEY, v1 VARCHAR, v2 VARCHAR)" + this.tableDDLOptions);
            String query = "SELECT * FROM " + fullTableName;
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
            conn.createStatement().execute("CREATE " + (this.localIndex ? "LOCAL " : "") + (this.uncovered ? "UNCOVERED" : "") + " INDEX " + indexName + " ON " + fullTableName + " (v1, v2)");
            query = "SELECT * FROM " + fullIndexName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + fullTableName + " VALUES(?,?,?)");
            stmt.setString(1, "a");
            stmt.setString(2, "x");
            stmt.setString(3, "1");
            stmt.execute();
            conn.commit();
            query = "SELECT * FROM " + fullIndexName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"1", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            String ddl = "DROP INDEX " + indexName + " ON " + fullTableName;
            conn.createStatement().execute(ddl);
            stmt = conn.prepareStatement("UPSERT INTO " + fullTableName + "(k, v1) VALUES(?,?)");
            if (this.mutable) {
                stmt.setString(1, "a");
                stmt.setString(2, "y");
                stmt.execute();
                conn.commit();
            }
            stmt.setString(1, "b");
            stmt.setString(2, "x");
            stmt.execute();
            conn.commit();
            Table table = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(fullTableName.getBytes());
            ResultScanner resultScanner = table.getScanner(new Scan());
            for (Result result : resultScanner) {
                System.out.println(result);
            }
            resultScanner.close();
            table.close();
            query = "SELECT * FROM " + fullTableName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)(this.mutable ? "y" : "x"), (Object)rs.getString(2));
            Assert.assertEquals((Object)"1", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((Object)"x", (Object)rs.getString(2));
            Assert.assertNull((Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testMultipleUpdatesAcrossRegions() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = "TBL_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String indexName = "IND_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)"S", (String)indexName);
        TABLE_NAMES.add(fullTableName);
        TABLE_NAMES.add(fullIndexName);
        String testTable = fullTableName + "_MULTIPLE_UPDATES";
        try (Connection conn = DriverManager.getConnection(BaseIndexWithRegionMovesIT.getUrl(), props);){
            conn.setAutoCommit(false);
            conn.createStatement().execute("CREATE TABLE " + testTable + " (k VARCHAR NOT NULL PRIMARY KEY, v1 VARCHAR, v2 VARCHAR) " + (!this.tableDDLOptions.isEmpty() ? this.tableDDLOptions : "") + " SPLIT ON ('b')");
            String query = "SELECT * FROM " + testTable;
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
            conn.createStatement().execute("CREATE " + (this.localIndex ? "LOCAL " : "") + (this.uncovered ? "UNCOVERED" : "") + " INDEX " + indexName + " ON " + testTable + " (v1, v2)");
            query = "SELECT * FROM " + fullIndexName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + testTable + " VALUES(?,?,?)");
            stmt.setString(1, "a");
            stmt.setString(2, "x");
            stmt.setString(3, "1");
            stmt.execute();
            stmt.setString(1, "b");
            stmt.setString(2, "y");
            stmt.setString(3, "2");
            stmt.execute();
            stmt.setString(1, "c");
            stmt.setString(2, "z");
            stmt.setString(3, "3");
            stmt.execute();
            conn.commit();
            query = "SELECT /*+ NO_INDEX */ * FROM " + testTable;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"x", (Object)rs.getString(2));
            Assert.assertEquals((Object)"1", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((Object)"y", (Object)rs.getString(2));
            Assert.assertEquals((Object)"2", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertEquals((Object)"z", (Object)rs.getString(2));
            Assert.assertEquals((Object)"3", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT" + (String)(this.uncovered ? " /*+ INDEX(" + testTable + " " + indexName + ")*/ " : " ") + "* FROM " + testTable;
            ExplainPlan plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)(this.columnEncoded ? "SERVER FILTER BY FIRST KEY ONLY" : "SERVER FILTER BY EMPTY COLUMN ONLY"), (Object)explainPlanAttributes.getServerWhereFilter());
            if (this.localIndex) {
                Assert.assertEquals((Object)"PARALLEL 2-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
                Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
                Assert.assertEquals((Object)testTable, (Object)explainPlanAttributes.getTableName());
                Assert.assertEquals((Object)" [1]", (Object)explainPlanAttributes.getKeyRanges());
                Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
            } else {
                Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
                Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
                Assert.assertEquals((Object)fullIndexName, (Object)explainPlanAttributes.getTableName());
                Assert.assertNull((Object)explainPlanAttributes.getClientSortAlgo());
            }
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"x", (Object)rs.getString(2));
            Assert.assertEquals((Object)"1", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((Object)"y", (Object)rs.getString(2));
            Assert.assertEquals((Object)"2", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertEquals((Object)"z", (Object)rs.getString(2));
            Assert.assertEquals((Object)"3", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testIndexWithCaseSensitiveCols() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = "TBL_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String indexName = "IND_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)"S", (String)indexName);
        TABLE_NAMES.add(fullTableName);
        TABLE_NAMES.add(fullIndexName);
        try (Connection conn = DriverManager.getConnection(BaseIndexWithRegionMovesIT.getUrl(), props);){
            conn.setAutoCommit(false);
            conn.createStatement().execute("CREATE TABLE " + fullTableName + " (k VARCHAR NOT NULL PRIMARY KEY, \"V1\" VARCHAR, \"v2\" VARCHAR)" + this.tableDDLOptions);
            String query = "SELECT * FROM " + fullTableName;
            ResultSet rs = conn.createStatement().executeQuery(query);
            long ts = conn.unwrap(PhoenixConnection.class).getTable(new PTableKey(null, fullTableName)).getTimeStamp();
            Assert.assertFalse((boolean)rs.next());
            conn.createStatement().execute("CREATE " + (this.localIndex ? "LOCAL " : "") + (this.uncovered ? "UNCOVERED " : " ") + "INDEX " + indexName + " ON " + fullTableName + "(\"v2\")" + (this.uncovered ? "" : " INCLUDE (\"V1\")"));
            query = "SELECT * FROM " + fullIndexName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + fullTableName + " VALUES(?,?,?)");
            stmt.setString(1, "a");
            stmt.setString(2, "x");
            stmt.setString(3, "1");
            stmt.execute();
            stmt.setString(1, "b");
            stmt.setString(2, "y");
            stmt.setString(3, "2");
            stmt.execute();
            if (!this.transactional) {
                conn.commit();
            }
            query = "SELECT * FROM " + fullTableName + " WHERE \"v2\" = '1'";
            ExplainPlan plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            if (this.localIndex) {
                Assert.assertEquals((Object)fullTableName, (Object)explainPlanAttributes.getTableName());
                Assert.assertEquals((Object)" [1,'1']", (Object)explainPlanAttributes.getKeyRanges());
            } else {
                Assert.assertEquals((Object)fullIndexName, (Object)explainPlanAttributes.getTableName());
                Assert.assertEquals((Object)" ['1']", (Object)explainPlanAttributes.getKeyRanges());
            }
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"x", (Object)rs.getString(2));
            Assert.assertEquals((Object)"1", (Object)rs.getString(3));
            Assert.assertEquals((Object)"a", (Object)rs.getString("k"));
            Assert.assertEquals((Object)"x", (Object)rs.getString("V1"));
            Assert.assertEquals((Object)"1", (Object)rs.getString("v2"));
            Assert.assertFalse((boolean)rs.next());
            if (this.transactional && this.transactionProvider == TransactionFactory.Provider.OMID) {
                BaseIndexWithRegionMovesIT.assertShadowCellsDoNotExist(conn, fullTableName, fullIndexName);
            }
            conn.commit();
            if (this.transactional && this.transactionProvider == TransactionFactory.Provider.OMID) {
                BaseIndexWithRegionMovesIT.assertShadowCellsExist(conn, fullTableName, fullIndexName);
            }
            query = "SELECT \"V1\", \"V1\" as foo1, \"v2\" as foo, \"v2\" as \"Foo1\", \"v2\" FROM " + fullTableName + " ORDER BY foo";
            plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            if (this.localIndex) {
                Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
                Assert.assertEquals((Object)fullTableName, (Object)explainPlanAttributes.getTableName());
                Assert.assertEquals((Object)" [1]", (Object)explainPlanAttributes.getKeyRanges());
                Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
            } else {
                Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
                Assert.assertEquals((Object)fullIndexName, (Object)explainPlanAttributes.getTableName());
                Assert.assertNull((Object)explainPlanAttributes.getClientSortAlgo());
            }
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"x", (Object)rs.getString("V1"));
            Assert.assertEquals((Object)"x", (Object)rs.getString(2));
            Assert.assertEquals((Object)"x", (Object)rs.getString("foo1"));
            Assert.assertEquals((Object)"1", (Object)rs.getString(3));
            Assert.assertEquals((Object)"1", (Object)rs.getString("Foo"));
            Assert.assertEquals((Object)"1", (Object)rs.getString(4));
            Assert.assertEquals((Object)"1", (Object)rs.getString("Foo1"));
            Assert.assertEquals((Object)"1", (Object)rs.getString(5));
            Assert.assertEquals((Object)"1", (Object)rs.getString("v2"));
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
            Assert.assertEquals((Object)"y", (Object)rs.getString(1));
            Assert.assertEquals((Object)"y", (Object)rs.getString("V1"));
            Assert.assertEquals((Object)"y", (Object)rs.getString(2));
            Assert.assertEquals((Object)"y", (Object)rs.getString("foo1"));
            Assert.assertEquals((Object)"2", (Object)rs.getString(3));
            Assert.assertEquals((Object)"2", (Object)rs.getString("Foo"));
            Assert.assertEquals((Object)"2", (Object)rs.getString(4));
            Assert.assertEquals((Object)"2", (Object)rs.getString("Foo1"));
            Assert.assertEquals((Object)"2", (Object)rs.getString(5));
            Assert.assertEquals((Object)"2", (Object)rs.getString("v2"));
            Assert.assertFalse((boolean)rs.next());
            this.assertNoIndexDeletes(conn, ts, fullIndexName);
        }
    }

    private void assertNoIndexDeletes(Connection conn, long minTimestamp, String fullIndexName) throws IOException, SQLException {
        if (!this.mutable) {
            PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
            PTable index = pconn.getTable(new PTableKey(null, fullIndexName));
            byte[] physicalIndexTable = index.getPhysicalName().getBytes();
            try (Table hIndex = pconn.getQueryServices().getTable(physicalIndexTable);){
                Result result;
                Scan scan = new Scan();
                scan.setRaw(true);
                if (this.transactional) {
                    minTimestamp = TransactionUtil.convertToNanoseconds((long)minTimestamp);
                }
                scan.setTimeRange(minTimestamp, Long.MAX_VALUE);
                ResultScanner scanner = hIndex.getScanner(scan);
                while ((result = scanner.next()) != null) {
                    CellScanner cellScanner = result.cellScanner();
                    while (cellScanner.advance()) {
                        Cell current = cellScanner.current();
                        Assert.assertTrue((boolean)CellUtil.isPut((Cell)current));
                    }
                }
            }
        }
    }

    @Test
    public void testInFilterOnIndexedTable() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = "TBL_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String indexName = "IND_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)"S", (String)indexName);
        TABLE_NAMES.add(fullTableName);
        TABLE_NAMES.add(fullIndexName);
        try (Connection conn = DriverManager.getConnection(BaseIndexWithRegionMovesIT.getUrl(), props);){
            conn.setAutoCommit(false);
            String ddl = "CREATE TABLE " + fullTableName + "  (PK1 CHAR(2) NOT NULL PRIMARY KEY, CF1.COL1 BIGINT) " + this.tableDDLOptions;
            conn.createStatement().execute(ddl);
            ddl = "CREATE " + (this.localIndex ? "LOCAL " : "") + (this.uncovered ? "UNCOVERED" : "") + " INDEX " + indexName + " ON " + fullTableName + "(COL1)";
            conn.createStatement().execute(ddl);
            String query = "SELECT COUNT(COL1) FROM " + fullTableName + " WHERE COL1 IN (1,25,50,75,100)";
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
        }
    }

    @Test
    public void testIndexWithDecimalColServerSideUpsert() throws Exception {
        this.testIndexWithDecimalCol(true);
    }

    @Test
    public void testIndexWithDecimalColClientSideUpsert() throws Exception {
        this.testIndexWithDecimalCol(false);
    }

    private void testIndexWithDecimalCol(boolean enableServerSideUpsert) throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = "TBL_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String indexName = "IND_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)"S", (String)indexName);
        props.setProperty("phoenix.client.enable.server.upsert.select", Boolean.toString(enableServerSideUpsert));
        TABLE_NAMES.add(fullTableName);
        TABLE_NAMES.add(fullIndexName);
        try (Connection conn = DriverManager.getConnection(BaseIndexWithRegionMovesIT.getUrl(), props);){
            conn.setAutoCommit(false);
            Date date = new Date(System.currentTimeMillis());
            TestUtil.createMultiCFTestTable(conn, fullTableName, this.tableDDLOptions);
            BaseIndexWithRegionMovesIT.populateMultiCFTestTable(fullTableName, date);
            String ddl = null;
            ddl = "CREATE " + (this.localIndex ? "LOCAL " : "") + (this.uncovered ? "UNCOVERED" : "") + " INDEX " + indexName + " ON " + fullTableName + " (decimal_pk)" + (this.uncovered ? "" : "INCLUDE (decimal_col1, decimal_col2)");
            conn.createStatement().execute(ddl);
            if (this.transactional && this.transactionProvider == TransactionFactory.Provider.OMID) {
                BaseIndexWithRegionMovesIT.assertShadowCellsExist(conn, fullTableName, fullIndexName);
            }
            String query = "SELECT" + (String)(this.uncovered ? " /*+ INDEX(" + fullTableName + " " + indexName + ")*/ " : " ") + "decimal_pk, decimal_col1, decimal_col2 from " + fullTableName;
            ExplainPlan plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            if (this.localIndex) {
                Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
                Assert.assertEquals((Object)fullTableName, (Object)explainPlanAttributes.getTableName());
                Assert.assertEquals((Object)" [1]", (Object)explainPlanAttributes.getKeyRanges());
                Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
            } else {
                Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
                Assert.assertEquals((Object)fullIndexName, (Object)explainPlanAttributes.getTableName());
                Assert.assertNull((Object)explainPlanAttributes.getClientSortAlgo());
            }
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
            Assert.assertEquals((Object)new BigDecimal("1.1"), (Object)rs.getBigDecimal(1));
            Assert.assertEquals((Object)new BigDecimal("2.1"), (Object)rs.getBigDecimal(2));
            Assert.assertEquals((Object)new BigDecimal("3.1"), (Object)rs.getBigDecimal(3));
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
            Assert.assertEquals((Object)new BigDecimal("2.2"), (Object)rs.getBigDecimal(1));
            Assert.assertEquals((Object)new BigDecimal("3.2"), (Object)rs.getBigDecimal(2));
            Assert.assertEquals((Object)new BigDecimal("4.2"), (Object)rs.getBigDecimal(3));
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
            Assert.assertEquals((Object)new BigDecimal("3.3"), (Object)rs.getBigDecimal(1));
            Assert.assertEquals((Object)new BigDecimal("4.3"), (Object)rs.getBigDecimal(2));
            Assert.assertEquals((Object)new BigDecimal("5.3"), (Object)rs.getBigDecimal(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    private static void assertShadowCellsDoNotExist(Connection conn, String fullTableName, String fullIndexName) throws Exception {
        BaseIndexWithRegionMovesIT.assertShadowCells(conn, fullTableName, fullIndexName, false);
    }

    private static void assertShadowCellsExist(Connection conn, String fullTableName, String fullIndexName) throws Exception {
        BaseIndexWithRegionMovesIT.assertShadowCells(conn, fullTableName, fullIndexName, true);
    }

    private static void assertShadowCells(Connection conn, String fullTableName, String fullIndexName, boolean exists) throws Exception {
        Result indexResult;
        PTable ptable = conn.unwrap(PhoenixConnection.class).getTable(new PTableKey(null, fullTableName));
        int nTableKVColumns = ptable.getColumns().size() - ptable.getPKColumns().size();
        Table hTable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(Bytes.toBytes((String)fullTableName));
        ResultScanner tableScanner = hTable.getScanner(new Scan());
        PTable pindex = conn.unwrap(PhoenixConnection.class).getTable(new PTableKey(null, fullIndexName));
        int nIndexKVColumns = pindex.getColumns().size() - pindex.getPKColumns().size();
        Table hIndex = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(Bytes.toBytes((String)fullIndexName));
        ResultScanner indexScanner = hIndex.getScanner(new Scan());
        while ((indexResult = indexScanner.next()) != null) {
            int nColumns = 0;
            CellScanner scanner = indexResult.cellScanner();
            while (scanner.advance()) {
                ++nColumns;
            }
            Assert.assertEquals((Object)exists, (Object)(nColumns > nIndexKVColumns * 2 ? 1 : 0));
            Result tableResult = tableScanner.next();
            Assert.assertNotNull((Object)tableResult);
            nColumns = 0;
            scanner = tableResult.cellScanner();
            while (scanner.advance()) {
                ++nColumns;
            }
            Assert.assertEquals((Object)exists, (Object)(nColumns > nTableKVColumns * 2 ? 1 : 0));
        }
        Assert.assertNull((Object)tableScanner.next());
    }

    @Test
    public void testQueryBackToDataTableWithDescPKColumn() throws Exception {
        this.doTestQueryBackToDataTableWithDescPKColumn(true);
        this.doTestQueryBackToDataTableWithDescPKColumn(false);
    }

    private void doTestQueryBackToDataTableWithDescPKColumn(boolean isSecondPKDesc) throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = "TBL_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String indexName = "IND_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)"S", (String)indexName);
        TABLE_NAMES.add(fullTableName);
        TABLE_NAMES.add(fullIndexName);
        try (Connection conn = DriverManager.getConnection(BaseIndexWithRegionMovesIT.getUrl(), props);){
            conn.setAutoCommit(true);
            Statement stmt = conn.createStatement();
            String ddl = "CREATE TABLE " + fullTableName + "(p1 integer not null, p2 integer not null,  a integer, b integer CONSTRAINT PK PRIMARY KEY ";
            ddl = isSecondPKDesc ? ddl + "(p1, p2 desc))" : ddl + "(p1 desc, p2))";
            stmt.executeUpdate(ddl);
            ddl = "CREATE " + (this.localIndex ? "LOCAL " : "") + (this.uncovered ? "UNCOVERED" : "") + " INDEX " + indexName + " on " + fullTableName + "(a)";
            stmt.executeUpdate(ddl);
            String upsert = "UPSERT INTO " + fullTableName + " VALUES(1,2,3,4)";
            stmt.executeUpdate(upsert);
            String query = "SELECT /*+index(" + fullTableName + " " + fullIndexName + "*/ b from " + fullTableName + " WHERE a = 3";
            ResultSet rs = stmt.executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            rs.close();
            stmt.close();
        }
    }

    @Test
    public void testReturnedTimestamp() throws Exception {
        String tenantId = BaseIndexWithRegionMovesIT.getOrganizationId();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(BaseIndexWithRegionMovesIT.getUrl(), props);){
            String indexName = BaseIndexWithRegionMovesIT.generateUniqueName();
            String tableName = BaseIndexWithRegionMovesIT.initATableValues(BaseIndexWithRegionMovesIT.generateUniqueName(), tenantId, BaseIndexWithRegionMovesIT.getDefaultSplits(tenantId), new Date(System.currentTimeMillis()), null, BaseIndexWithRegionMovesIT.getUrl(), this.tableDDLOptions);
            String ddl = "CREATE " + (this.localIndex ? "LOCAL " : "") + (this.uncovered ? "UNCOVERED" : "") + " INDEX " + indexName + " on " + tableName + "(A_STRING)" + (this.uncovered ? "" : " INCLUDE (B_STRING)");
            conn.createStatement().executeUpdate(ddl);
            TABLE_NAMES.add(tableName);
            TABLE_NAMES.add(indexName);
            String query = "SELECT ENTITY_ID,A_STRING,B_STRING FROM " + tableName + " WHERE organization_id=? and entity_id=?";
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            long currentTime = EnvironmentEdgeManager.currentTimeMillis();
            String entityId = this.mutable ? "00B523122312312" : Integer.toString(Math.abs(RAND.nextInt() % 1000000000));
            PreparedStatement ddlStatement = conn.prepareStatement("UPSERT INTO " + tableName + "(ORGANIZATION_ID, ENTITY_ID,A_STRING) VALUES('" + tenantId + "',?,?)");
            ddlStatement.setString(1, entityId);
            ddlStatement.setString(2, Integer.toString(Math.abs(RAND.nextInt() % 1000000000)));
            ddlStatement.executeUpdate();
            conn.commit();
            statement.setString(2, entityId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(tableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(indexName);
            Assert.assertTrue((rs.unwrap(PhoenixResultSet.class).getCurrentRow().getValue(0).getTimestamp() >= currentTime ? 1 : 0) != 0);
            Assert.assertEquals((Object)rs.getString(1).trim(), (Object)entityId);
            Assert.assertFalse((boolean)rs.next());
            currentTime = EnvironmentEdgeManager.currentTimeMillis();
            entityId = this.mutable ? "00B523122312312" : Integer.toString(Math.abs(RAND.nextInt() % 1000000000));
            ddlStatement = conn.prepareStatement("UPSERT INTO " + tableName + "(ORGANIZATION_ID, ENTITY_ID,B_STRING) VALUES('" + tenantId + "',?,?)");
            ddlStatement.setString(1, entityId);
            ddlStatement.setString(2, Integer.toString(Math.abs(RAND.nextInt() % 1000000000)));
            ddlStatement.executeUpdate();
            conn.commit();
            statement.setString(2, entityId);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(tableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(indexName);
            Assert.assertTrue((rs.unwrap(PhoenixResultSet.class).getCurrentRow().getValue(0).getTimestamp() >= currentTime ? 1 : 0) != 0);
            Assert.assertEquals((Object)rs.getString(1).trim(), (Object)entityId);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testLastDDLTimestampOnIndexes() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = "TBL_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String indexName = "IND_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)"S", (String)indexName);
        TABLE_NAMES.add(fullTableName);
        TABLE_NAMES.add(fullIndexName);
        String ddl = "CREATE TABLE " + fullTableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) " + this.tableDDLOptions;
        long startTs = EnvironmentEdgeManager.currentTimeMillis();
        try (Connection conn = DriverManager.getConnection(BaseIndexWithRegionMovesIT.getUrl(), props);){
            conn.setAutoCommit(true);
            Statement stmt = conn.createStatement();
            stmt.execute(ddl);
            ddl = "CREATE " + (this.localIndex ? "LOCAL" : "") + (this.uncovered ? "UNCOVERED" : "") + " INDEX " + indexName + " ON " + fullTableName + " (long_col1, long_col2)" + (this.uncovered ? "" : " INCLUDE (decimal_col1, decimal_col2)");
            stmt.execute(ddl);
            TestUtil.waitForIndexState(conn, fullIndexName, PIndexState.ACTIVE);
            long activeIndexLastDDLTimestamp = CreateTableIT.verifyLastDDLTimestamp(fullIndexName, startTs, conn);
            Thread.sleep(1L);
            String disableIndexDDL = "ALTER INDEX " + indexName + " ON S." + tableName + " DISABLE";
            stmt.execute(disableIndexDDL);
            TestUtil.waitForIndexState(conn, fullIndexName, PIndexState.DISABLE);
            CreateTableIT.verifyLastDDLTimestamp(fullIndexName, activeIndexLastDDLTimestamp + 1L, conn);
        }
    }

    @Test
    public void testLastDDLTimestampOnAsyncIndexes() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = "TBL_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String indexName = "IND_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)"S", (String)indexName);
        TABLE_NAMES.add(fullTableName);
        TABLE_NAMES.add(fullIndexName);
        String ddl = "CREATE TABLE " + fullTableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) " + this.tableDDLOptions;
        long startTs = EnvironmentEdgeManager.currentTimeMillis();
        try (Connection conn = DriverManager.getConnection(BaseIndexWithRegionMovesIT.getUrl(), props);){
            conn.setAutoCommit(true);
            Statement stmt = conn.createStatement();
            stmt.execute(ddl);
            ddl = "CREATE " + (this.localIndex ? "LOCAL" : "") + (this.uncovered ? "UNCOVERED" : "") + " INDEX " + indexName + " ON " + fullTableName + " (long_col1, long_col2)" + (this.uncovered ? " ASYNC" : " INCLUDE (decimal_col1, decimal_col2) ASYNC");
            stmt.execute(ddl);
            TestUtil.waitForIndexState(conn, fullIndexName, PIndexState.BUILDING);
            long buildingIndexLastDDLTimestamp = CreateTableIT.verifyLastDDLTimestamp(fullIndexName, startTs, conn);
            Thread.sleep(1L);
            IndexToolIT.runIndexTool(false, "S", tableName, indexName);
            TestUtil.waitForIndexState(conn, fullIndexName, PIndexState.ACTIVE);
            long activeIndexLastDDLTimestamp = CreateTableIT.verifyLastDDLTimestamp(fullIndexName, buildingIndexLastDDLTimestamp + 1L, conn);
            Thread.sleep(1L);
            String disableIndexDDL = "ALTER INDEX " + indexName + " ON S." + tableName + " DISABLE";
            stmt.execute(disableIndexDDL);
            TestUtil.waitForIndexState(conn, fullIndexName, PIndexState.DISABLE);
            CreateTableIT.verifyLastDDLTimestamp(fullIndexName, activeIndexLastDDLTimestamp + 1L, conn);
        }
    }

    @Test
    public void testSelectUncoveredWithCoveredFieldSimple() throws Exception {
        Assume.assumeFalse((boolean)this.localIndex);
        Assume.assumeFalse((boolean)this.uncovered);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = "TBL_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String indexName = "IND_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)"S", (String)indexName);
        TABLE_NAMES.add(fullTableName);
        TABLE_NAMES.add(fullIndexName);
        try (Connection conn = DriverManager.getConnection(BaseIndexWithRegionMovesIT.getUrl(), props);){
            conn.setAutoCommit(false);
            String ddl = "CREATE TABLE " + fullTableName + " (v1 integer, k integer primary key, v2 integer, v3 integer, v4 integer) " + this.tableDDLOptions;
            String upsert = "UPSERT INTO " + fullTableName + " values (1, 2, 3, 4, 5)";
            Statement stmt = conn.createStatement();
            stmt.execute(ddl);
            stmt.execute(upsert);
            conn.commit();
            ddl = "CREATE " + (this.uncovered ? "UNCOVERED" : "") + " INDEX " + indexName + " ON " + fullTableName + " (v2) include(v3)";
            conn.createStatement().execute(ddl);
            ResultSet rs = conn.createStatement().executeQuery("SELECT /*+ INDEX(" + fullTableName + " " + indexName + ")*/ * FROM " + fullTableName + " where v2=3 and v3=4");
            Assert.assertTrue((boolean)rs.next());
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
            BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
            Assert.assertEquals((Object)"1", (Object)rs.getString("v1"));
            Assert.assertEquals((Object)"2", (Object)rs.getString("k"));
            Assert.assertEquals((Object)"3", (Object)rs.getString("v2"));
            Assert.assertEquals((Object)"4", (Object)rs.getString("v3"));
            Assert.assertEquals((Object)"5", (Object)rs.getString("v4"));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testSelectUncoveredWithCoveredField() throws Exception {
        Assume.assumeFalse((boolean)this.localIndex);
        Assume.assumeFalse((boolean)this.uncovered);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = "TBL_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String indexName = "IND_" + BaseIndexWithRegionMovesIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)"S", (String)indexName);
        TABLE_NAMES.add(fullTableName);
        TABLE_NAMES.add(fullIndexName);
        try (Connection conn = DriverManager.getConnection(BaseIndexWithRegionMovesIT.getUrl(), props);
             Statement stmt = conn.createStatement();){
            conn.setAutoCommit(false);
            String ddl = "CREATE TABLE " + fullTableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) " + this.tableDDLOptions;
            stmt.execute(ddl);
            BaseTest.populateTestTable(fullTableName);
            conn.commit();
            ddl = "CREATE " + (this.uncovered ? "UNCOVERED" : "") + " INDEX " + indexName + " ON " + fullTableName + " ( int_col1 ASC) INCLUDE (long_col1, long_col2)";
            stmt.execute(ddl);
            for (String columns : Arrays.asList("*", "varchar_pk,char_pk,int_pk,long_pk,decimal_pk,date_pk,a.varchar_col1,a.char_col1,a.int_col1,a.long_col1,a.decimal_col1,a.date1,b.varchar_col2,b.char_col2,b.int_col2,b.long_col2,b.decimal_col2,b.date2", "varchar_pk,char_pk,int_pk,long_pk,decimal_pk,date_pk,varchar_col1,char_col1,int_col1,long_col1,decimal_col1,date1,varchar_col2,char_col2,int_col2,long_col2,decimal_col2,date2")) {
                String query = "SELECT /*+ INDEX(" + fullTableName + " " + indexName + ")*/ " + columns + " from " + fullTableName + " where int_col1=2 and long_col1=2";
                ResultSet rs = stmt.executeQuery("Explain " + query);
                String explainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
                Assert.assertEquals((String)("bad plan with columns:" + columns), (Object)("CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + fullIndexName + " [2]\n    SERVER MERGE [A.VARCHAR_COL1, A.CHAR_COL1, A.DECIMAL_COL1, A.DATE1, B.VARCHAR_COL2, B.CHAR_COL2, B.INT_COL2, B.DECIMAL_COL2, B.DATE2]\n    SERVER FILTER BY A.\"LONG_COL1\" = 2"), (Object)explainPlan);
                rs = stmt.executeQuery(query);
                Assert.assertTrue((boolean)rs.next());
                BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullTableName);
                BaseIndexWithRegionMovesIT.moveRegionsOfTable(fullIndexName);
                Assert.assertEquals((Object)"varchar1", (Object)rs.getString("varchar_pk"));
                Assert.assertEquals((Object)"char1", (Object)rs.getString("char_pk"));
                Assert.assertEquals((Object)"1", (Object)rs.getString("int_pk"));
                Assert.assertEquals((Object)"1", (Object)rs.getString("long_pk"));
                Assert.assertEquals((Object)"1", (Object)rs.getString("decimal_pk"));
                Assert.assertEquals((Object)"2015-01-01 00:00:00.000", (Object)rs.getString("date_pk"));
                Assert.assertEquals((Object)"varchar_a", (Object)rs.getString("varchar_col1"));
                Assert.assertEquals((Object)"chara", (Object)rs.getString("char_col1"));
                Assert.assertEquals((Object)"2", (Object)rs.getString("int_col1"));
                Assert.assertEquals((Object)"2", (Object)rs.getString("long_col1"));
                Assert.assertEquals((Object)"2", (Object)rs.getString("decimal_col1"));
                Assert.assertEquals((Object)"2015-01-01 00:00:00.000", (Object)rs.getString("date1"));
                Assert.assertEquals((Object)"varchar_b", (Object)rs.getString("varchar_col2"));
                Assert.assertEquals((Object)"charb", (Object)rs.getString("char_col2"));
                Assert.assertEquals((Object)"3", (Object)rs.getString("int_col2"));
                Assert.assertEquals((Object)"3", (Object)rs.getString("long_col2"));
                Assert.assertEquals((Object)"3", (Object)rs.getString("decimal_col2"));
                Assert.assertEquals((Object)"2015-01-01 00:00:00.000", (Object)rs.getString("date2"));
                Assert.assertFalse((boolean)rs.next());
            }
        }
    }
}

