/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class AlterIndexIT
extends ParallelStatsDisabledIT {
    @Test
    public void testAlterIndexRebuildNoAsync() throws Exception {
        String indexName = "I_" + AlterIndexIT.generateUniqueName();
        String tableName = "T_" + AlterIndexIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(AlterIndexIT.getUrl());){
            this.createAndPopulateTable(conn, tableName);
            Assert.assertEquals((long)2L, (long)TestUtil.getRowCount(conn, tableName));
            this.createIndex(conn, indexName, tableName, "val1", "val2, val3");
            Assert.assertEquals((long)2L, (long)TestUtil.getRowCount(conn, indexName));
            this.rebuildIndex(conn, indexName, tableName, false);
            Assert.assertEquals((long)2L, (long)TestUtil.getRowCount(conn, indexName));
        }
    }

    private void createAndPopulateTable(Connection conn, String tableName) throws Exception {
        conn.createStatement().execute("create table " + tableName + " (id varchar(10) not null primary key, val1 varchar(10), val2 varchar(10), val3 varchar(10))");
        conn.createStatement().execute("upsert into " + tableName + " values ('a', 'ab', 'abc', 'abcd')");
        conn.commit();
        conn.createStatement().execute("upsert into " + tableName + " values ('b', 'bc', 'bcd', 'bcde')");
        conn.commit();
    }

    private void createIndex(Connection conn, String indexName, String tableName, String columns, String includeColumns) throws SQLException {
        String ddl = "CREATE INDEX " + indexName + " ON " + tableName + " (" + columns + ") INCLUDE (" + includeColumns + ")";
        conn.createStatement().execute(ddl);
    }

    private void rebuildIndex(Connection conn, String indexName, String tableName, boolean async) throws SQLException {
        String format = "ALTER INDEX %s ON %s REBUILD" + (async ? " ASYNC" : "");
        String sql = String.format(format, indexName, tableName);
        conn.createStatement().execute(sql);
        conn.commit();
    }
}

