/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.WALCoprocessor;
import org.apache.hadoop.hbase.coprocessor.WALCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.WALObserver;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.wal.WALCoprocessorHost;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.hbase.index.IndexRegionObserver;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.query.PhoenixTestBuilder;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={NeedsOwnMiniClusterTest.class})
public class WALAnnotationIT
extends BaseTest {
    private final boolean isImmutable;
    private final boolean isMultiTenant;

    @Parameterized.Parameters(name="WALAnnotationIT_isImmutable={0}_isMultiTenant={1}")
    public static synchronized Collection<Object[]> data() {
        return Arrays.asList({true, true}, {true, false}, {false, true}, {false, false});
    }

    public WALAnnotationIT(boolean isImmutable, boolean isMultiTenant) {
        this.isImmutable = isImmutable;
        this.isMultiTenant = isMultiTenant;
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>(2);
        props.put("hbase.coprocessor.wal.classes", AnnotatedWALObserver.class.getName());
        props.put("phoenix.append.metadata.to.wal", "true");
        props.put("phoenix.client.enable.server.upsert.select", "true");
        WALAnnotationIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @Test
    public void testSimpleUpsertAndDelete() throws Exception {
        PhoenixTestBuilder.SchemaBuilder builder = new PhoenixTestBuilder.SchemaBuilder(WALAnnotationIT.getUrl());
        boolean createGlobalIndex = false;
        String externalSchemaId = this.upsertAndDeleteHelper(builder, createGlobalIndex);
        this.assertAnnotation(2, builder.getPhysicalTableName(false), externalSchemaId);
    }

    @Test
    public void testNoAnnotationsIfChangeDetectionDisabled() throws Exception {
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(WALAnnotationIT.getUrl());){
            conn.setAutoCommit(true);
            PhoenixTestBuilder.SchemaBuilder builder = new PhoenixTestBuilder.SchemaBuilder(WALAnnotationIT.getUrl());
            PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = this.getTableOptions();
            tableOptions.setChangeDetectionEnabled(false);
            builder.withTableOptions(tableOptions).build();
            PTable table = conn.getTableNoCache(builder.getEntityTableName());
            Assert.assertFalse((String)"Change detection is enabled when it shouldn't be!", (boolean)table.isChangeDetectionEnabled());
            String upsertSql = "UPSERT INTO " + builder.getEntityTableName() + " VALUES ('a', 'b', '2', 'bc', '3')";
            conn.createStatement().execute(upsertSql);
            List<Map<String, byte[]>> entries = this.getEntriesForTable(TableName.valueOf((String)builder.getPhysicalTableName(false)));
            Assert.assertTrue((String)"WAL annotations should not contain EXTERNAL_SCHEMA_ID", (entries.size() == 0 || !entries.get(0).containsKey(MutationState.MutationMetadataType.EXTERNAL_SCHEMA_ID.toString()) ? 1 : 0) != 0);
            String enableSql = "ALTER TABLE " + builder.getEntityTableName() + " SET CHANGE_DETECTION_ENABLED=TRUE";
            conn.createStatement().execute(enableSql);
            table = conn.getTableNoCache(builder.getEntityTableName());
            Assert.assertTrue((String)"Change detection is disabled when it should be enabled!", (boolean)table.isChangeDetectionEnabled());
            String disableSql = "ALTER TABLE " + builder.getEntityTableName() + " SET CHANGE_DETECTION_ENABLED=FALSE";
            conn.createStatement().execute(disableSql);
            table = conn.getTableNoCache(builder.getEntityTableName());
            Assert.assertFalse((String)"Change detection is enabled when it should be disabled!", (boolean)table.isChangeDetectionEnabled());
            conn.createStatement().execute(upsertSql);
            entries = this.getEntriesForTable(TableName.valueOf((String)builder.getPhysicalTableName(false)));
            Assert.assertTrue((String)"WAL annotations should not contain EXTERNAL_SCHEMA_ID", (entries.size() == 0 || !entries.get(0).containsKey(MutationState.MutationMetadataType.EXTERNAL_SCHEMA_ID.toString()) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCantSetChangeDetectionOnIndex() throws Exception {
        try (Connection conn = DriverManager.getConnection(WALAnnotationIT.getUrl());){
            PhoenixTestBuilder.SchemaBuilder builder = new PhoenixTestBuilder.SchemaBuilder(WALAnnotationIT.getUrl());
            builder.withTableDefaults().build();
            try {
                String badIndexSql = "CREATE INDEX IDX_SHOULD_FAIL ON " + builder.getEntityTableName() + "(COL1) CHANGE_DETECTION_ENABLED=TRUE";
                conn.createStatement().execute(badIndexSql);
                Assert.fail((String)"Didn't throw a SQLException for setting change detection on an index at create time!");
            }
            catch (SQLException se) {
                TestUtil.assertSqlExceptionCode(SQLExceptionCode.CHANGE_DETECTION_SUPPORTED_FOR_TABLES_AND_VIEWS_ONLY, se);
            }
        }
    }

    @Test
    public void testUpsertAndDeleteWithGlobalIndex() throws Exception {
        PhoenixTestBuilder.SchemaBuilder builder = new PhoenixTestBuilder.SchemaBuilder(WALAnnotationIT.getUrl());
        boolean createGlobalIndex = true;
        String externalSchemaId = this.upsertAndDeleteHelper(builder, createGlobalIndex);
        this.assertAnnotation(2, builder.getPhysicalTableName(false), externalSchemaId);
        this.assertAnnotation(0, builder.getPhysicalTableIndexName(false), externalSchemaId);
    }

    private String upsertAndDeleteHelper(PhoenixTestBuilder.SchemaBuilder builder, boolean createGlobalIndex) throws Exception {
        try (PhoenixConnection conn = this.getConnection();){
            PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = this.getTableOptions();
            if (createGlobalIndex) {
                builder.withTableOptions(tableOptions).withTableIndexDefaults().build();
            } else {
                builder.withTableOptions(tableOptions).build();
            }
            String upsertSql = "UPSERT INTO " + builder.getEntityTableName() + " VALUES ('a', 'b', 'c')";
            conn.createStatement().execute(upsertSql);
            conn.commit();
            PTable table = conn.getTableNoCache(builder.getEntityTableName());
            Assert.assertTrue((String)"Change Detection Enabled is false!", (boolean)table.isChangeDetectionEnabled());
            String deleteSql = "DELETE FROM " + builder.getEntityTableName() + " WHERE OID = 'a' AND KP = 'b'";
            conn.createStatement().execute(deleteSql);
            conn.commit();
            String string = table.getExternalSchemaId();
            return string;
        }
    }

    private PhoenixTestBuilder.SchemaBuilder.TableOptions getTableOptions() {
        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
        tableOptions.setImmutable(this.isImmutable);
        tableOptions.setMultiTenant(this.isMultiTenant);
        tableOptions.setChangeDetectionEnabled(true);
        return tableOptions;
    }

    @Test
    public void testUpsertSelectClientSide() throws Exception {
        try (PhoenixConnection conn = this.getConnection();){
            PhoenixTestBuilder.SchemaBuilder baseBuilder = new PhoenixTestBuilder.SchemaBuilder(WALAnnotationIT.getUrl());
            PhoenixTestBuilder.SchemaBuilder targetBuilder = new PhoenixTestBuilder.SchemaBuilder(WALAnnotationIT.getUrl());
            baseBuilder.withTableOptions(this.getTableOptions()).build();
            conn.createStatement().execute("UPSERT INTO " + baseBuilder.getEntityTableName() + " VALUES ('a', 'b', '2', 'bc', '3')");
            conn.commit();
            targetBuilder.withTableOptions(this.getTableOptions()).build();
            String sql = "UPSERT INTO " + targetBuilder.getEntityTableName() + " (OID, KP, COL1, COL2, COL3) SELECT * FROM " + baseBuilder.getEntityTableName();
            conn.createStatement().execute(sql);
            conn.commit();
            int expectedAnnotations = 1;
            this.verifyBaseAndTargetAnnotations(conn, baseBuilder, targetBuilder, expectedAnnotations);
        }
    }

    private void verifyBaseAndTargetAnnotations(PhoenixConnection conn, PhoenixTestBuilder.SchemaBuilder baseBuilder, PhoenixTestBuilder.SchemaBuilder targetBuilder, int expectedAnnotations) throws SQLException, IOException {
        PTable baseTable = conn.getTableNoCache(baseBuilder.getEntityTableName());
        this.assertAnnotation(expectedAnnotations, baseBuilder.getPhysicalTableName(false), baseTable.getExternalSchemaId());
        PTable targetTable = conn.getTableNoCache(targetBuilder.getEntityTableName());
        this.assertAnnotation(expectedAnnotations, targetBuilder.getPhysicalTableName(false), targetTable.getExternalSchemaId());
    }

    @Test
    public void testUpsertSelectServerSide() throws Exception {
        Assume.assumeFalse((boolean)this.isImmutable);
        PhoenixTestBuilder.SchemaBuilder targetBuilder = new PhoenixTestBuilder.SchemaBuilder(WALAnnotationIT.getUrl());
        try (PhoenixConnection conn = this.getConnection();){
            targetBuilder.withTableOptions(this.getTableOptions()).build();
            conn.createStatement().execute("UPSERT INTO " + targetBuilder.getEntityTableName() + " VALUES ('a', 'b', '2', 'bc', '3')");
            conn.commit();
            conn.setAutoCommit(true);
            this.clearAnnotations(TableName.valueOf((String)targetBuilder.getPhysicalTableName(false)));
            String sql = "UPSERT INTO " + targetBuilder.getEntityTableName() + " (OID, KP, COL1, COL2, COL3) SELECT * FROM " + targetBuilder.getEntityTableName();
            conn.createStatement().execute(sql);
            PTable table = conn.getTableNoCache(targetBuilder.getEntityTableName());
            this.assertAnnotation(1, targetBuilder.getPhysicalTableName(false), table.getExternalSchemaId());
        }
    }

    @Test
    public void testGroupedUpsertSelect() throws Exception {
        PhoenixTestBuilder.SchemaBuilder baseBuilder = new PhoenixTestBuilder.SchemaBuilder(WALAnnotationIT.getUrl());
        PhoenixTestBuilder.SchemaBuilder targetBuilder = new PhoenixTestBuilder.SchemaBuilder(WALAnnotationIT.getUrl());
        try (PhoenixConnection conn = this.getConnection();){
            baseBuilder.withTableOptions(this.getTableOptions()).build();
            targetBuilder.withTableOptions(this.getTableOptions()).build();
            conn.createStatement().execute("UPSERT INTO " + baseBuilder.getEntityTableName() + " VALUES ('a', 'b', '2', 'bc', '3')");
            conn.commit();
            String aggSql = "UPSERT INTO " + targetBuilder.getEntityTableName() + " SELECT OID, KP, MAX(COL1), MIN(COL2), MAX(COL3) FROM " + baseBuilder.getEntityTableName() + " GROUP BY OID, KP";
            conn.createStatement().execute(aggSql);
            conn.commit();
            int expectedAnnotations = 1;
            this.verifyBaseAndTargetAnnotations(conn, baseBuilder, targetBuilder, expectedAnnotations);
        }
    }

    @Test
    public void testRangeDeleteServerSide() throws Exception {
        boolean isClientSide = false;
        this.testRangeDeleteHelper(isClientSide);
    }

    private void testRangeDeleteHelper(boolean isClientSide) throws Exception {
        PhoenixTestBuilder.SchemaBuilder builder = new PhoenixTestBuilder.SchemaBuilder(WALAnnotationIT.getUrl());
        builder.withTableOptions(this.getTableOptions()).build();
        try (PhoenixConnection conn = this.getConnection();){
            conn.createStatement().execute("UPSERT INTO " + builder.getEntityTableName() + " VALUES ('a', 'b', '2', 'bc', '3')");
            conn.commit();
            String sql = "DELETE FROM " + builder.getEntityTableName() + " WHERE OID = 'a' AND KP = 'b'";
            if (isClientSide) {
                sql = sql + " LIMIT 1";
            }
            conn.setAutoCommit(!isClientSide);
            conn.createStatement().execute(sql);
            conn.commit();
            PTable table = conn.getTableNoCache(builder.getEntityTableName());
            this.assertAnnotation(2, table.getPhysicalName().getString(), table.getExternalSchemaId());
        }
    }

    @Test
    public void testRangeDeleteClientSide() throws Exception {
        boolean isClientSide = true;
        this.testRangeDeleteHelper(isClientSide);
    }

    @Test
    public void testGlobalViewUpsert() throws Exception {
        PhoenixTestBuilder.SchemaBuilder builder = new PhoenixTestBuilder.SchemaBuilder(WALAnnotationIT.getUrl());
        try (PhoenixConnection conn = this.getConnection();){
            this.createGlobalViewHelper(builder, conn);
            conn.createStatement().execute("UPSERT INTO " + builder.getEntityGlobalViewName() + " VALUES ('a', 'ECZ', '2', 'bc', '3', 'c')");
            conn.commit();
            String deleteSql = "DELETE FROM " + builder.getEntityGlobalViewName() + " WHERE OID = 'a' AND KP = 'ECZ' and ID = 'c'";
            conn.createStatement().execute(deleteSql);
            conn.commit();
            PTable view = conn.getTableNoCache(builder.getEntityGlobalViewName());
            this.assertAnnotation(2, view.getPhysicalName().getString(), view.getExternalSchemaId());
        }
    }

    private void createGlobalViewHelper(PhoenixTestBuilder.SchemaBuilder builder, PhoenixConnection conn) throws Exception {
        builder.withTableOptions(this.getTableOptions()).withGlobalViewOptions(this.getGlobalViewOptions(builder)).build();
        PTable view = conn.getTableNoCache(builder.getEntityGlobalViewName());
        Assert.assertTrue((String)"View does not have change detection enabled!", (boolean)view.isChangeDetectionEnabled());
    }

    private PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions getGlobalViewOptions(PhoenixTestBuilder.SchemaBuilder builder) {
        PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions options = PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions.withDefaults();
        options.setChangeDetectionEnabled(true);
        return options;
    }

    @Test
    public void testTenantViewUpsert() throws Exception {
        Assume.assumeTrue((boolean)this.isMultiTenant);
        boolean createIndex = false;
        this.tenantViewHelper(createIndex);
    }

    private void tenantViewHelper(boolean createIndex) throws Exception {
        String tenant = WALAnnotationIT.generateUniqueName();
        PhoenixTestBuilder.SchemaBuilder builder = new PhoenixTestBuilder.SchemaBuilder(WALAnnotationIT.getUrl());
        try (PhoenixConnection conn = this.getConnection();){
            this.createGlobalViewHelper(builder, conn);
        }
        conn = (PhoenixConnection)this.getTenantConnection(tenant);
        try {
            PhoenixTestBuilder.SchemaBuilder.DataOptions dataOptions = builder.getDataOptions();
            dataOptions.setTenantId(tenant);
            if (createIndex) {
                builder.withTenantViewOptions(this.getTenantViewOptions(builder)).withDataOptions(dataOptions).withTenantViewIndexDefaults().build();
            } else {
                builder.withTenantViewOptions(this.getTenantViewOptions(builder)).withDataOptions(dataOptions).build();
            }
            builder.withTenantViewOptions(this.getTenantViewOptions(builder)).withDataOptions(dataOptions).withTenantViewIndexDefaults().build();
            conn.createStatement().execute("UPSERT INTO " + builder.getEntityTenantViewName() + " VALUES ('ECZ', '2', 'bc', '3', 'c', 'col4', 'col5', 'col6', 'd')");
            conn.commit();
            String deleteSql = "DELETE FROM " + builder.getEntityTenantViewName() + " WHERE KP = 'ECZ' and COL1 = '2' AND ID = 'c' AND ZID = 'd'";
            conn.createStatement().execute(deleteSql);
            conn.commit();
            PTable view = conn.getTableNoCache(builder.getEntityTenantViewName());
            this.assertAnnotation(2, view.getPhysicalName().getString(), view.getExternalSchemaId());
            if (createIndex) {
                this.assertAnnotation(0, MetaDataUtil.getViewIndexPhysicalName((String)builder.getEntityTableName()), view.getExternalSchemaId());
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    private PhoenixTestBuilder.SchemaBuilder.TenantViewOptions getTenantViewOptions(PhoenixTestBuilder.SchemaBuilder builder) {
        PhoenixTestBuilder.SchemaBuilder.TenantViewOptions options = PhoenixTestBuilder.SchemaBuilder.TenantViewOptions.withDefaults();
        options.setChangeDetectionEnabled(true);
        return options;
    }

    @Test
    public void testTenantViewUpsertWithIndex() throws Exception {
        Assume.assumeTrue((boolean)this.isMultiTenant);
        this.tenantViewHelper(true);
    }

    @Test
    public void testOnDuplicateUpsertWithIndex() throws Exception {
        Assume.assumeFalse((boolean)this.isImmutable);
        PhoenixTestBuilder.SchemaBuilder builder = new PhoenixTestBuilder.SchemaBuilder(WALAnnotationIT.getUrl());
        try (PhoenixConnection conn = this.getConnection();){
            PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = this.getTableOptions();
            builder.withTableOptions(tableOptions).withTableIndexDefaults().build();
            PTable table = conn.getTableNoCache(builder.getEntityTableName());
            Assert.assertTrue((String)"Change Detection Enabled is false!", (boolean)table.isChangeDetectionEnabled());
            Long ddlTimestamp = table.getLastDDLTimestamp();
            String upsertSql = "UPSERT INTO " + builder.getEntityTableName() + " VALUES ('a', 'b', 'c', 'd')";
            conn.createStatement().execute(upsertSql);
            conn.commit();
            List<String> columns = builder.getTableOptions().getTableColumns();
            Assert.assertTrue((columns.size() >= 2 ? 1 : 0) != 0);
            String col1 = columns.get(0);
            String col2 = columns.get(1);
            String onDupClause = String.format("%s = %s || %s, %s = null", col1, col1, col1, col2);
            upsertSql = "UPSERT INTO " + builder.getEntityTableName() + " VALUES ('a', 'b', 'c', 'd') ON DUPLICATE KEY UPDATE " + onDupClause;
            conn.createStatement().execute(upsertSql);
            conn.commit();
            this.assertAnnotation(2, builder.getPhysicalTableName(false), table.getExternalSchemaId());
            this.assertAnnotation(0, builder.getPhysicalTableIndexName(false), table.getExternalSchemaId());
        }
    }

    private List<Map<String, byte[]>> getEntriesForTable(TableName tableName) throws IOException {
        AnnotatedWALObserver c = this.getTestCoprocessor(tableName);
        ArrayList entries = c.getWalAnnotationsByTable(tableName);
        return entries != null ? entries : new ArrayList();
    }

    private AnnotatedWALObserver getTestCoprocessor(TableName tableName) throws IOException {
        RegionInfo info = ((HRegion)WALAnnotationIT.getUtility().getHBaseCluster().getRegions(tableName).get(0)).getRegionInfo();
        WAL wal = WALAnnotationIT.getUtility().getHBaseCluster().getRegionServer(0).getWAL(info);
        WALCoprocessorHost host = wal.getCoprocessorHost();
        return (AnnotatedWALObserver)host.findCoprocessor(AnnotatedWALObserver.class.getName());
    }

    private void clearAnnotations(TableName tableName) throws IOException {
        AnnotatedWALObserver observer = this.getTestCoprocessor(tableName);
        observer.clearAnnotations();
    }

    private void assertAnnotation(int numOccurrences, String physicalTableName, String externalSchemaId) throws IOException {
        int foundCount = 0;
        int notFoundCount = 0;
        List<Map<String, byte[]>> entries = this.getEntriesForTable(TableName.valueOf((String)physicalTableName));
        for (Map<String, byte[]> m : entries) {
            byte[] externalSchemaIdBytes = m.get(MutationState.MutationMetadataType.EXTERNAL_SCHEMA_ID.toString());
            Assert.assertNotNull((Object)externalSchemaIdBytes);
            if (Objects.equals(externalSchemaId, Bytes.toString((byte[])externalSchemaIdBytes))) {
                ++foundCount;
                continue;
            }
            ++notFoundCount;
        }
        Assert.assertEquals((long)numOccurrences, (long)foundCount);
        Assert.assertEquals((long)0L, (long)notFoundCount);
    }

    private PhoenixConnection getConnection() throws SQLException {
        Properties props = new Properties();
        props.setProperty("phoenix.schema.isNamespaceMappingEnabled", Boolean.toString(false));
        return (PhoenixConnection)DriverManager.getConnection(WALAnnotationIT.getUrl(), props);
    }

    private Connection getTenantConnection(String tenant) throws SQLException {
        Properties props = new Properties();
        props.setProperty("TenantId", tenant);
        props.setProperty("phoenix.schema.isNamespaceMappingEnabled", Boolean.toString(false));
        return DriverManager.getConnection(WALAnnotationIT.getUrl(), props);
    }

    public static class AnnotatedWALObserver
    implements WALCoprocessor,
    WALObserver {
        Map<TableName, List<Map<String, byte[]>>> walAnnotations = new HashMap<TableName, List<Map<String, byte[]>>>();

        public Map<TableName, List<Map<String, byte[]>>> getWalAnnotations() {
            return this.walAnnotations;
        }

        public List<Map<String, byte[]>> getWalAnnotationsByTable(TableName tableName) {
            return this.walAnnotations.get(tableName);
        }

        public void clearAnnotations() {
            this.walAnnotations.clear();
        }

        public void postWALWrite(ObserverContext<? extends WALCoprocessorEnvironment> ctx, RegionInfo info, WALKey logKey, WALEdit logEdit) throws IOException {
            TableName tableName = logKey.getTableName();
            Map annotationMap = IndexRegionObserver.getAttributeValuesFromWALKey((WALKey)logKey);
            if (annotationMap.size() > 0) {
                if (!this.walAnnotations.containsKey(tableName)) {
                    this.walAnnotations.put(tableName, new ArrayList());
                }
                this.walAnnotations.get(logKey.getTableName()).add(annotationMap);
            }
        }

        public Optional<WALObserver> getWALObserver() {
            return Optional.of(this);
        }
    }
}

