/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.coprocessorclient.MetaDataProtocol;
import org.apache.phoenix.coprocessorclient.TableInfo;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.end2end.ViewMetadataIT;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TableViewFinderResult;
import org.apache.phoenix.util.TestUtil;
import org.apache.phoenix.util.ViewUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class ViewUtilIT
extends ParallelStatsDisabledIT {
    @Test
    public void testGetSystemTableForChildLinks() throws Exception {
        Assert.assertEquals((Object)PhoenixDatabaseMetaData.SYSTEM_LINK_HBASE_TABLE_NAME, (Object)ViewUtil.getSystemTableForChildLinks((int)MetaDataProtocol.MIN_SPLITTABLE_SYSTEM_CATALOG, (Configuration)config));
        Assert.assertEquals((Object)PhoenixDatabaseMetaData.SYSTEM_LINK_HBASE_TABLE_NAME, (Object)ViewUtil.getSystemTableForChildLinks((int)(MetaDataProtocol.MIN_SPLITTABLE_SYSTEM_CATALOG - 1), (Configuration)config));
    }

    @Test
    public void testHasChildViewsInGlobalViewCase() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        TableName catalogOrChildTableName = ViewUtil.getSystemTableForChildLinks((int)0, (Configuration)config);
        String schema = ViewUtilIT.generateUniqueName();
        byte[] schemaInBytes = schema.getBytes(StandardCharsets.UTF_8);
        byte[] tenantIdInBytes = new byte[]{};
        String fullTableName = schema + "." + ViewUtilIT.generateUniqueName();
        String secondLevelViewName = schema + "." + ViewUtilIT.generateUniqueName();
        String thirdLevelViewName = schema + "." + ViewUtilIT.generateUniqueName();
        String leafViewName1 = schema + "." + ViewUtilIT.generateUniqueName();
        String leafViewName2 = schema + "." + ViewUtilIT.generateUniqueName();
        String tableDDLQuery = "CREATE TABLE " + fullTableName + " (A BIGINT PRIMARY KEY, B BIGINT)";
        String viewDDLQuery = "CREATE VIEW %s AS SELECT * FROM %s";
        try (Connection conn = DriverManager.getConnection(ViewUtilIT.getUrl(), props);){
            conn.createStatement().execute(tableDDLQuery);
            conn.createStatement().execute(String.format(viewDDLQuery, secondLevelViewName, fullTableName));
            conn.createStatement().execute(String.format(viewDDLQuery, leafViewName1, secondLevelViewName));
            conn.createStatement().execute(String.format(viewDDLQuery, thirdLevelViewName, secondLevelViewName));
            conn.createStatement().execute(String.format(viewDDLQuery, leafViewName2, thirdLevelViewName));
            try (PhoenixConnection phoenixConnection = DriverManager.getConnection(ViewUtilIT.getUrl(), props).unwrap(PhoenixConnection.class);
                 Table catalogOrChildTable = phoenixConnection.getQueryServices().getTable(SchemaUtil.getPhysicalName((byte[])catalogOrChildTableName.toBytes(), (ReadOnlyProps)phoenixConnection.getQueryServices().getProps()).getName());){
                Assert.assertTrue((boolean)ViewUtil.hasChildViews((Table)catalogOrChildTable, (byte[])tenantIdInBytes, (byte[])schemaInBytes, (byte[])SchemaUtil.getTableNameFromFullName((String)fullTableName).getBytes(StandardCharsets.UTF_8), (long)System.currentTimeMillis()));
                Assert.assertTrue((boolean)ViewUtil.hasChildViews((Table)catalogOrChildTable, (byte[])tenantIdInBytes, (byte[])schemaInBytes, (byte[])SchemaUtil.getTableNameFromFullName((String)secondLevelViewName).getBytes(StandardCharsets.UTF_8), (long)System.currentTimeMillis()));
                Assert.assertTrue((boolean)ViewUtil.hasChildViews((Table)catalogOrChildTable, (byte[])tenantIdInBytes, (byte[])schemaInBytes, (byte[])SchemaUtil.getTableNameFromFullName((String)thirdLevelViewName).getBytes(StandardCharsets.UTF_8), (long)System.currentTimeMillis()));
                Assert.assertFalse((boolean)ViewUtil.hasChildViews((Table)catalogOrChildTable, (byte[])tenantIdInBytes, (byte[])schemaInBytes, (byte[])SchemaUtil.getTableNameFromFullName((String)leafViewName1).getBytes(StandardCharsets.UTF_8), (long)System.currentTimeMillis()));
                Assert.assertFalse((boolean)ViewUtil.hasChildViews((Table)catalogOrChildTable, (byte[])tenantIdInBytes, (byte[])schemaInBytes, (byte[])SchemaUtil.getTableNameFromFullName((String)leafViewName2).getBytes(StandardCharsets.UTF_8), (long)System.currentTimeMillis()));
            }
        }
    }

    @Test
    public void testHasChildViewsInTenantViewCase() throws Exception {
        String tenantId = ViewUtilIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Properties tenantProps = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        tenantProps.setProperty("TenantId", tenantId);
        TableName catalogOrChildTableName = ViewUtil.getSystemTableForChildLinks((int)0, (Configuration)config);
        String schema = ViewUtilIT.generateUniqueName();
        byte[] schemaInBytes = schema.getBytes(StandardCharsets.UTF_8);
        byte[] tenantIdInBytes = tenantId.getBytes(StandardCharsets.UTF_8);
        byte[] emptyTenantIdInBytes = new byte[]{};
        String multiTenantTableName = schema + "." + ViewUtilIT.generateUniqueName();
        String globalViewName = schema + "." + ViewUtilIT.generateUniqueName();
        String tenantViewOnMultiTenantTable1 = schema + "." + ViewUtilIT.generateUniqueName();
        String viewName2 = ViewUtilIT.generateUniqueName();
        String tenantViewOnMultiTenantTable2 = schema + "." + viewName2;
        String tenantViewIndex = viewName2 + "_INDEX";
        String tenantViewOnGlobalView = schema + "." + ViewUtilIT.generateUniqueName();
        String multiTenantTableDDL = "CREATE TABLE " + multiTenantTableName + "(TENANT_ID CHAR(10) NOT NULL, ID CHAR(10) NOT NULL, NUM BIGINT CONSTRAINT PK PRIMARY KEY (TENANT_ID, ID)) MULTI_TENANT=true";
        String globalViewDDL = "CREATE VIEW " + globalViewName + "(PK1 BIGINT, PK2 BIGINT) AS SELECT * FROM " + multiTenantTableName + " WHERE NUM > -1";
        String viewDDL = "CREATE VIEW %s AS SELECT * FROM %s";
        String viewIndexDDL = "CREATE INDEX " + tenantViewIndex + " ON " + tenantViewOnMultiTenantTable2 + "(NUM DESC) INCLUDE (ID)";
        try (Connection conn = DriverManager.getConnection(ViewUtilIT.getUrl());){
            conn.createStatement().execute(multiTenantTableDDL);
            conn.createStatement().execute(globalViewDDL);
            try (Connection tenantConn = DriverManager.getConnection(ViewUtilIT.getUrl(), tenantProps);){
                tenantConn.createStatement().execute(String.format(viewDDL, tenantViewOnGlobalView, globalViewName));
                tenantConn.createStatement().execute(String.format(viewDDL, tenantViewOnMultiTenantTable1, multiTenantTableName));
                tenantConn.createStatement().execute(String.format(viewDDL, tenantViewOnMultiTenantTable2, multiTenantTableName));
                tenantConn.createStatement().execute(viewIndexDDL);
            }
            try (PhoenixConnection phoenixConnection = DriverManager.getConnection(ViewUtilIT.getUrl(), props).unwrap(PhoenixConnection.class);
                 Table catalogOrChildTable = phoenixConnection.getQueryServices().getTable(SchemaUtil.getPhysicalName((byte[])catalogOrChildTableName.toBytes(), (ReadOnlyProps)phoenixConnection.getQueryServices().getProps()).getName());){
                Assert.assertTrue((boolean)ViewUtil.hasChildViews((Table)catalogOrChildTable, (byte[])emptyTenantIdInBytes, (byte[])schemaInBytes, (byte[])SchemaUtil.getTableNameFromFullName((String)multiTenantTableName).getBytes(StandardCharsets.UTF_8), (long)System.currentTimeMillis()));
                Assert.assertTrue((boolean)ViewUtil.hasChildViews((Table)catalogOrChildTable, (byte[])emptyTenantIdInBytes, (byte[])schemaInBytes, (byte[])SchemaUtil.getTableNameFromFullName((String)globalViewName).getBytes(StandardCharsets.UTF_8), (long)System.currentTimeMillis()));
                Assert.assertFalse((boolean)ViewUtil.hasChildViews((Table)catalogOrChildTable, (byte[])tenantIdInBytes, (byte[])schemaInBytes, (byte[])SchemaUtil.getTableNameFromFullName((String)tenantViewOnMultiTenantTable1).getBytes(StandardCharsets.UTF_8), (long)System.currentTimeMillis()));
                Assert.assertFalse((boolean)ViewUtil.hasChildViews((Table)catalogOrChildTable, (byte[])tenantIdInBytes, (byte[])schemaInBytes, (byte[])SchemaUtil.getTableNameFromFullName((String)tenantViewOnMultiTenantTable2).getBytes(StandardCharsets.UTF_8), (long)System.currentTimeMillis()));
                Assert.assertFalse((boolean)ViewUtil.hasChildViews((Table)catalogOrChildTable, (byte[])tenantIdInBytes, (byte[])schemaInBytes, (byte[])SchemaUtil.getTableNameFromFullName((String)tenantViewOnGlobalView).getBytes(StandardCharsets.UTF_8), (long)System.currentTimeMillis()));
            }
        }
    }

    @Test
    public void testFindAllRelativesForGlobalConnection() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        TableName catalogOrChildTableName = ViewUtil.getSystemTableForChildLinks((int)0, (Configuration)config);
        String schema = ViewUtilIT.generateUniqueName();
        byte[] schemaInBytes = schema.getBytes(StandardCharsets.UTF_8);
        byte[] tenantIdInBytes = new byte[]{};
        String fullTableName = schema + "." + ViewUtilIT.generateUniqueName();
        String middleLevelViewName = schema + "." + ViewUtilIT.generateUniqueName();
        String leafViewName1 = schema + "." + ViewUtilIT.generateUniqueName();
        String leafViewName2 = schema + "." + ViewUtilIT.generateUniqueName();
        int NUMBER_OF_VIEWS = 3;
        String tableDDLQuery = "CREATE TABLE " + fullTableName + " (A BIGINT PRIMARY KEY, B BIGINT)";
        String viewDDLQuery = "CREATE VIEW %s AS SELECT * FROM %s";
        try (Connection conn = DriverManager.getConnection(ViewUtilIT.getUrl(), props);){
            conn.createStatement().execute(tableDDLQuery);
            conn.createStatement().execute(String.format(viewDDLQuery, middleLevelViewName, fullTableName));
            conn.createStatement().execute(String.format(viewDDLQuery, leafViewName1, middleLevelViewName));
            conn.createStatement().execute(String.format(viewDDLQuery, leafViewName2, middleLevelViewName));
            try (PhoenixConnection phoenixConnection = DriverManager.getConnection(ViewUtilIT.getUrl(), props).unwrap(PhoenixConnection.class);
                 Table catalogOrChildTable = phoenixConnection.getQueryServices().getTable(SchemaUtil.getPhysicalName((byte[])catalogOrChildTableName.toBytes(), (ReadOnlyProps)phoenixConnection.getQueryServices().getProps()).getName());){
                TableViewFinderResult result = new TableViewFinderResult();
                ViewUtil.findAllRelatives((Table)catalogOrChildTable, (byte[])tenantIdInBytes, (byte[])schemaInBytes, (byte[])SchemaUtil.getTableNameFromFullName((String)fullTableName).getBytes(StandardCharsets.UTF_8), (PTable.LinkType)PTable.LinkType.CHILD_TABLE, (TableViewFinderResult)result);
                Assert.assertEquals((long)NUMBER_OF_VIEWS, (long)result.getLinks().size());
                result = new TableViewFinderResult();
                ViewUtil.findAllRelatives((Table)catalogOrChildTable, (byte[])tenantIdInBytes, (byte[])schemaInBytes, (byte[])SchemaUtil.getTableNameFromFullName((String)middleLevelViewName).getBytes(StandardCharsets.UTF_8), (PTable.LinkType)PTable.LinkType.CHILD_TABLE, (TableViewFinderResult)result);
                Assert.assertEquals((long)2L, (long)result.getLinks().size());
                result = new TableViewFinderResult();
                ViewUtil.findAllRelatives((Table)catalogOrChildTable, (byte[])tenantIdInBytes, (byte[])schemaInBytes, (byte[])SchemaUtil.getTableNameFromFullName((String)leafViewName1).getBytes(StandardCharsets.UTF_8), (PTable.LinkType)PTable.LinkType.CHILD_TABLE, (TableViewFinderResult)result);
                Assert.assertEquals((long)0L, (long)result.getLinks().size());
                result = new TableViewFinderResult();
                ViewUtil.findAllRelatives((Table)catalogOrChildTable, (byte[])tenantIdInBytes, (byte[])schemaInBytes, (byte[])SchemaUtil.getTableNameFromFullName((String)leafViewName2).getBytes(StandardCharsets.UTF_8), (PTable.LinkType)PTable.LinkType.CHILD_TABLE, (TableViewFinderResult)result);
                Assert.assertEquals((long)0L, (long)result.getLinks().size());
            }
        }
    }

    @Test
    public void testFindAllRelativesForTenantConnection() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tenantId1 = ViewUtilIT.generateUniqueName();
        Properties tenantProps1 = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        tenantProps1.setProperty("TenantId", tenantId1);
        String tenantId2 = ViewUtilIT.generateUniqueName();
        Properties tenantProps2 = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        tenantProps2.setProperty("TenantId", tenantId2);
        TableName catalogOrChildTableName = ViewUtil.getSystemTableForChildLinks((int)0, (Configuration)config);
        String schema = ViewUtilIT.generateUniqueName();
        byte[] schemaInBytes = schema.getBytes(StandardCharsets.UTF_8);
        byte[] tenantId1InBytes = tenantId1.getBytes(StandardCharsets.UTF_8);
        byte[] tenantId2InBytes = tenantId2.getBytes(StandardCharsets.UTF_8);
        byte[] emptyTenantIdInBytes = new byte[]{};
        String multiTenantTableName = schema + "." + ViewUtilIT.generateUniqueName();
        String tenant1MiddleLevelViewOnMultiTenantTable = schema + "." + ViewUtilIT.generateUniqueName();
        String tenant1LeafViewName = schema + "." + ViewUtilIT.generateUniqueName();
        String tenant2LeafViewName = schema + "." + ViewUtilIT.generateUniqueName();
        int NUMBER_OF_VIEWS = 3;
        String multiTenantTableDDL = "CREATE TABLE " + multiTenantTableName + "(TENANT_ID CHAR(10) NOT NULL, ID CHAR(10) NOT NULL, NUM BIGINT CONSTRAINT PK PRIMARY KEY (TENANT_ID, ID)) MULTI_TENANT=true";
        String viewDDL = "CREATE VIEW %s AS SELECT * FROM %s";
        try (Connection conn = DriverManager.getConnection(ViewUtilIT.getUrl(), props);){
            conn.createStatement().execute(multiTenantTableDDL);
            try (Connection tenantConn = DriverManager.getConnection(ViewUtilIT.getUrl(), tenantProps1);){
                tenantConn.createStatement().execute(String.format(viewDDL, tenant1MiddleLevelViewOnMultiTenantTable, multiTenantTableName));
                tenantConn.createStatement().execute(String.format(viewDDL, tenant1LeafViewName, tenant1MiddleLevelViewOnMultiTenantTable));
            }
            tenantConn = DriverManager.getConnection(ViewUtilIT.getUrl(), tenantProps2);
            try {
                tenantConn.createStatement().execute(String.format(viewDDL, tenant2LeafViewName, multiTenantTableName));
            }
            finally {
                if (tenantConn != null) {
                    tenantConn.close();
                }
            }
            try (PhoenixConnection phoenixConnection = DriverManager.getConnection(ViewUtilIT.getUrl(), props).unwrap(PhoenixConnection.class);
                 Table catalogOrChildTable = phoenixConnection.getQueryServices().getTable(SchemaUtil.getPhysicalName((byte[])catalogOrChildTableName.toBytes(), (ReadOnlyProps)phoenixConnection.getQueryServices().getProps()).getName());){
                TableViewFinderResult result = new TableViewFinderResult();
                ViewUtil.findAllRelatives((Table)catalogOrChildTable, (byte[])emptyTenantIdInBytes, (byte[])schemaInBytes, (byte[])SchemaUtil.getTableNameFromFullName((String)multiTenantTableName).getBytes(StandardCharsets.UTF_8), (PTable.LinkType)PTable.LinkType.CHILD_TABLE, (TableViewFinderResult)result);
                Assert.assertEquals((long)NUMBER_OF_VIEWS, (long)result.getLinks().size());
                result = new TableViewFinderResult();
                ViewUtil.findAllRelatives((Table)catalogOrChildTable, (byte[])tenantId1InBytes, (byte[])schemaInBytes, (byte[])SchemaUtil.getTableNameFromFullName((String)tenant1MiddleLevelViewOnMultiTenantTable).getBytes(StandardCharsets.UTF_8), (PTable.LinkType)PTable.LinkType.CHILD_TABLE, (TableViewFinderResult)result);
                Assert.assertEquals((long)1L, (long)result.getLinks().size());
                result = new TableViewFinderResult();
                ViewUtil.findAllRelatives((Table)catalogOrChildTable, (byte[])tenantId1InBytes, (byte[])schemaInBytes, (byte[])SchemaUtil.getTableNameFromFullName((String)tenant1LeafViewName).getBytes(StandardCharsets.UTF_8), (PTable.LinkType)PTable.LinkType.CHILD_TABLE, (TableViewFinderResult)result);
                Assert.assertEquals((long)0L, (long)result.getLinks().size());
                result = new TableViewFinderResult();
                ViewUtil.findAllRelatives((Table)catalogOrChildTable, (byte[])tenantId2InBytes, (byte[])schemaInBytes, (byte[])SchemaUtil.getTableNameFromFullName((String)tenant2LeafViewName).getBytes(StandardCharsets.UTF_8), (PTable.LinkType)PTable.LinkType.CHILD_TABLE, (TableViewFinderResult)result);
                Assert.assertEquals((long)0L, (long)result.getLinks().size());
            }
        }
    }

    @Test
    public void testFindLegitChildViews() throws Exception {
        String parentTable = ViewUtilIT.generateUniqueName();
        ArrayList<CallSite> childViewNames = new ArrayList<CallSite>(3);
        childViewNames.add((CallSite)((Object)("A_" + ViewUtilIT.generateUniqueName())));
        childViewNames.add((CallSite)((Object)("B_" + ViewUtilIT.generateUniqueName())));
        childViewNames.add((CallSite)((Object)("C_" + ViewUtilIT.generateUniqueName())));
        try (Connection conn = DriverManager.getConnection(ViewUtilIT.getUrl());){
            conn.createStatement().execute(String.format("CREATE TABLE %s.%s (A INTEGER NOT NULL PRIMARY KEY, B INTEGER, C INTEGER)", "S", parentTable));
            for (String string : childViewNames) {
                conn.createStatement().execute(String.format("CREATE VIEW %s.%s (NEW_COL1 INTEGER) AS SELECT * FROM %s.%s WHERE B > 10", "S1", string, "S", parentTable));
            }
            ConnectionQueryServices cqs = conn.unwrap(PhoenixConnection.class).getQueryServices();
            try (Table table = cqs.getTable(SchemaUtil.getPhysicalName((byte[])PhoenixDatabaseMetaData.SYSTEM_LINK_HBASE_TABLE_NAME.toBytes(), (ReadOnlyProps)cqs.getProps()).getName());){
                Pair allDescendants = ViewUtil.findAllDescendantViews((Table)table, (Configuration)cqs.getConfiguration(), (byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])"S".getBytes(), (byte[])parentTable.getBytes(), (long)Long.MAX_VALUE, (boolean)true, (boolean)true);
                Assert.assertTrue((String)"No orphan views expected", (boolean)((List)allDescendants.getSecond()).isEmpty());
                List childViews = (List)allDescendants.getFirst();
                Assert.assertEquals((String)"Just 1 legit child view expected", (long)1L, (long)childViews.size());
                PTable childView = (PTable)childViews.get(0);
                Assert.assertEquals((Object)"S1", (Object)childView.getSchemaName().getString());
                Assert.assertEquals(childViewNames.get(0), (Object)childView.getTableName().getString());
                Assert.assertEquals((Object)"S", (Object)childView.getParentSchemaName().getString());
                Assert.assertEquals((Object)parentTable, (Object)childView.getParentTableName().getString());
                allDescendants = ViewUtil.findAllDescendantViews((Table)table, (Configuration)cqs.getConfiguration(), (byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])"S".getBytes(), (byte[])parentTable.getBytes(), (long)Long.MAX_VALUE, (boolean)false, (boolean)true);
                Assert.assertTrue((String)"No orphan views expected", (boolean)((List)allDescendants.getSecond()).isEmpty());
                childViews = (List)allDescendants.getFirst();
                Assert.assertEquals((String)"All child views expected", (long)childViewNames.size(), (long)childViews.size());
                for (int i = 0; i < childViewNames.size(); ++i) {
                    childView = (PTable)childViews.get(i);
                    Assert.assertEquals((Object)"S1", (Object)childView.getSchemaName().getString());
                    Assert.assertEquals(childViewNames.get(i), (Object)childView.getTableName().getString());
                    Assert.assertEquals((Object)"S", (Object)childView.getParentSchemaName().getString());
                    Assert.assertEquals((Object)parentTable, (Object)childView.getParentTableName().getString());
                }
            }
        }
    }

    @Test
    public void testOrphanViewDetection() throws Exception {
        String parent1TableName = ViewUtilIT.generateUniqueName();
        String parent2TableName = ViewUtilIT.generateUniqueName();
        String viewName = "V_" + ViewUtilIT.generateUniqueName();
        ViewMetadataIT.createOrphanLink("S", parent1TableName, parent2TableName, "S1", viewName);
        try (Connection conn = DriverManager.getConnection(ViewUtilIT.getUrl());){
            ConnectionQueryServices cqs = conn.unwrap(PhoenixConnection.class).getQueryServices();
            try (Table childLinkTable = cqs.getTable(SchemaUtil.getPhysicalName((byte[])PhoenixDatabaseMetaData.SYSTEM_LINK_HBASE_TABLE_NAME.toBytes(), (ReadOnlyProps)cqs.getProps()).getName());){
                Pair allDescendants = ViewUtil.findAllDescendantViews((Table)childLinkTable, (Configuration)cqs.getConfiguration(), (byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])"S".getBytes(), (byte[])parent2TableName.getBytes(), (long)Long.MAX_VALUE, (boolean)false, (boolean)true);
                Assert.assertTrue((String)"No orphan views expected", (boolean)((List)allDescendants.getSecond()).isEmpty());
                Assert.assertTrue((String)"No legitimate views expected", (boolean)((List)allDescendants.getFirst()).isEmpty());
                conn.createStatement().execute(String.format("DROP VIEW %s.%s", "S1", viewName));
                allDescendants = ViewUtil.findAllDescendantViews((Table)childLinkTable, (Configuration)cqs.getConfiguration(), (byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])"S".getBytes(), (byte[])parent2TableName.getBytes(), (long)Long.MAX_VALUE, (boolean)false, (boolean)true);
                Assert.assertTrue((String)"No legitimate views expected", (boolean)((List)allDescendants.getFirst()).isEmpty());
                List orphanViews = (List)allDescendants.getSecond();
                Assert.assertEquals((String)"1 orphan view expected", (long)1L, (long)orphanViews.size());
                Assert.assertEquals((Object)"S1", (Object)Bytes.toString((byte[])((TableInfo)orphanViews.get(0)).getSchemaName()));
                Assert.assertEquals((Object)viewName, (Object)Bytes.toString((byte[])((TableInfo)orphanViews.get(0)).getTableName()));
            }
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetViewIndexIdsForNonViewIndexTable() throws IOException, SQLException {
        try (Connection conn = DriverManager.getConnection(ViewUtilIT.getUrl());){
            ViewUtil.getViewIndexIds((PhoenixConnection)conn.unwrap(PhoenixConnection.class), (String)"TEST_TABLE", (boolean)true);
        }
    }

    @Test
    public void testGetViewIndexIdsWithSchema() throws SQLException, IOException {
        this.testGetViewIndexIds(ViewUtilIT.generateUniqueName());
    }

    @Test
    public void testGetViewIndexIdsWithoutSchema() throws SQLException, IOException {
        this.testGetViewIndexIds(null);
    }

    private void testGetViewIndexIds(String schemaPrefix) throws IOException, SQLException {
        String tableName = SchemaUtil.getTableName((String)schemaPrefix, (String)ViewUtilIT.generateUniqueName());
        String globalViewName1 = SchemaUtil.getTableName((String)schemaPrefix, (String)ViewUtilIT.generateUniqueName());
        String globalViewName2 = SchemaUtil.getTableName((String)schemaPrefix, (String)ViewUtilIT.generateUniqueName());
        String globalViewIndex11 = ViewUtilIT.generateUniqueName() + "_INDEX11";
        String globalViewIndex12 = ViewUtilIT.generateUniqueName() + "_INDEX12";
        String globalViewIndex21 = ViewUtilIT.generateUniqueName() + "_INDEX21";
        String globalViewIndex22 = ViewUtilIT.generateUniqueName() + "_INDEX22";
        String globalViewIndex23 = ViewUtilIT.generateUniqueName() + "_INDEX23";
        String tenantId = ViewUtilIT.generateUniqueName();
        Properties tenantProps = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        tenantProps.setProperty("TenantId", tenantId);
        String tenantViewName1 = SchemaUtil.getTableName((String)schemaPrefix, (String)ViewUtilIT.generateUniqueName());
        String tenantViewName2 = SchemaUtil.getTableName((String)schemaPrefix, (String)ViewUtilIT.generateUniqueName());
        String tenantViewIndex11 = ViewUtilIT.generateUniqueName() + "_INDEX11";
        String tenantViewIndex21 = ViewUtilIT.generateUniqueName() + "_INDEX21";
        String tenantViewIndex22 = ViewUtilIT.generateUniqueName() + "_INDEX22";
        String createTableDDL = "CREATE TABLE " + tableName + "(TENANT_ID CHAR(10) NOT NULL, ID CHAR(10) NOT NULL, NUM BIGINT CONSTRAINT PK PRIMARY KEY (TENANT_ID, ID)) MULTI_TENANT=true";
        String globalViewDDL = "CREATE VIEW %s (PK1 BIGINT, PK2 BIGINT) AS SELECT * FROM " + tableName + " WHERE NUM > -1";
        String viewIndexDDL = "CREATE INDEX %s ON %s (NUM DESC) INCLUDE (ID)";
        String tenantViewDDL = "CREATE VIEW %s AS SELECT * FROM %s";
        try (Connection conn = DriverManager.getConnection(ViewUtilIT.getUrl());){
            conn.createStatement().execute(createTableDDL);
            conn.createStatement().execute(String.format(globalViewDDL, globalViewName1));
            conn.createStatement().execute(String.format(globalViewDDL, globalViewName2));
            conn.createStatement().execute(String.format("CREATE INDEX %s ON %s (NUM DESC) INCLUDE (ID)", globalViewIndex11, globalViewName1));
            conn.createStatement().execute(String.format("CREATE INDEX %s ON %s (NUM DESC) INCLUDE (ID)", globalViewIndex12, globalViewName1));
            conn.createStatement().execute(String.format("CREATE INDEX %s ON %s (NUM DESC) INCLUDE (ID)", globalViewIndex21, globalViewName2));
            conn.createStatement().execute(String.format("CREATE INDEX %s ON %s (NUM DESC) INCLUDE (ID)", globalViewIndex22, globalViewName2));
            conn.createStatement().execute(String.format("CREATE INDEX %s ON %s (NUM DESC) INCLUDE (ID)", globalViewIndex23, globalViewName2));
            try (Connection tenantConn = DriverManager.getConnection(ViewUtilIT.getUrl(), tenantProps);){
                tenantConn.createStatement().execute(String.format("CREATE VIEW %s AS SELECT * FROM %s", tenantViewName1, tableName));
                tenantConn.createStatement().execute(String.format("CREATE VIEW %s AS SELECT * FROM %s", tenantViewName2, tableName));
                tenantConn.createStatement().execute(String.format("CREATE INDEX %s ON %s (NUM DESC) INCLUDE (ID)", tenantViewIndex11, tenantViewName1));
                tenantConn.createStatement().execute(String.format("CREATE INDEX %s ON %s (NUM DESC) INCLUDE (ID)", tenantViewIndex21, tenantViewName2));
                tenantConn.createStatement().execute(String.format("CREATE INDEX %s ON %s (NUM DESC) INCLUDE (ID)", tenantViewIndex22, tenantViewName2));
            }
            List list = ViewUtil.getViewIndexIds((PhoenixConnection)conn.unwrap(PhoenixConnection.class), (String)MetaDataUtil.getViewIndexPhysicalName((String)tableName), (boolean)false);
            Assert.assertEquals((long)5L, (long)list.size());
            list = ViewUtil.getViewIndexIds((PhoenixConnection)conn.unwrap(PhoenixConnection.class), (String)MetaDataUtil.getViewIndexPhysicalName((String)tableName), (boolean)true);
            Assert.assertEquals((long)8L, (long)list.size());
        }
    }
}

