/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.util.HashMap;
import org.apache.phoenix.end2end.BaseViewTTLIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class ViewTTLWithLongViewIndexEnabledIT
extends BaseViewTTLIT {
    public ViewTTLWithLongViewIndexEnabledIT(boolean useCondExpression) {
        super(useCondExpression);
    }

    @BeforeClass
    public static final void doSetup() throws Exception {
        HashMap<String, String> DEFAULT_PROPERTIES = new HashMap<String, String>(){
            {
                this.put("phoenix.compaction.enabled", String.valueOf(true));
                this.put("phoenix.index.longViewIndex.enabled", String.valueOf(true));
                this.put("hbase.procedure.remote.dispatcher.delay.msec", "0");
                this.put("phoenix.max.lookback.age.seconds", Integer.toString(0));
                this.put("phoenix.view.ttl.enabled", Boolean.toString(true));
                this.put("phoenix.view.ttl.tenant_views_per_scan.limit", String.valueOf(1));
            }
        };
        ViewTTLWithLongViewIndexEnabledIT.setUpTestDriver(new ReadOnlyProps(ReadOnlyProps.EMPTY_PROPS, DEFAULT_PROPERTIES.entrySet().iterator()));
    }

    @Override
    @Test
    public void testMajorCompactWithSimpleIndexedBaseTables() throws Exception {
        super.testMajorCompactWithSimpleIndexedBaseTables();
    }

    @Override
    @Test
    public void testMajorCompactFromMultipleGlobalIndexes() throws Exception {
        super.testMajorCompactFromMultipleGlobalIndexes();
    }

    @Override
    @Test
    public void testMajorCompactFromMultipleTenantIndexes() throws Exception {
        super.testMajorCompactFromMultipleTenantIndexes();
    }

    @Override
    @Test
    public void testMajorCompactWithOnlyTenantView() throws Exception {
        super.testMajorCompactWithOnlyTenantView();
    }

    @Override
    @Test
    public void testMajorCompactWithSaltedIndexedBaseTables() throws Exception {
        super.testMajorCompactWithSaltedIndexedBaseTables();
    }

    @Override
    @Test
    public void testMajorCompactWithSaltedIndexedTenantView() throws Exception {
        super.testMajorCompactWithSaltedIndexedTenantView();
    }

    @Override
    @Test
    public void testMajorCompactWithVariousViewsAndOptions() throws Exception {
        super.testMajorCompactWithVariousViewsAndOptions();
    }

    @Test
    public void testMajorCompactWithVariousTenantIdTypesAndRegions() throws Exception {
        super.testMajorCompactWithVariousTenantIdTypesAndRegions((PDataType)PVarchar.INSTANCE);
        super.testMajorCompactWithVariousTenantIdTypesAndRegions((PDataType)PInteger.INSTANCE);
        super.testMajorCompactWithVariousTenantIdTypesAndRegions((PDataType)PLong.INSTANCE);
    }

    @Override
    @Test
    public void testMajorCompactTenantViewsWithVariousPKTypesAndSortOrder() throws Exception {
        super.testMajorCompactTenantViewsWithVariousPKTypesAndSortOrder();
    }

    @Override
    @Test
    public void testMajorCompactWhenTTLSetForSomeTenants() throws Exception {
        super.testMajorCompactWhenTTLSetForSomeTenants();
    }

    @Override
    @Test
    public void testTenantViewsWithOverlappingRowPrefixes() throws Exception {
        super.testTenantViewsWithOverlappingRowPrefixes();
    }

    @Override
    @Test
    public void testMajorCompactWithGlobalAndTenantViewHierarchy() throws Exception {
        super.testMajorCompactWithGlobalAndTenantViewHierarchy();
    }
}

