/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.PhoenixTestBuilder;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class ViewTTLNotEnabledIT
extends ParallelStatsDisabledIT {
    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        props.put("phoenix.max.lookback.age.seconds", Integer.toString(3600));
        props.put("phoenix.use.stats.parallelization", Boolean.toString(false));
        props.put("phoenix.view.ttl.enabled", Boolean.toString(false));
        ViewTTLNotEnabledIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @Test
    public void testCreateViewWithTTLWithConfigFalse() throws Exception {
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(ViewTTLNotEnabledIT.getUrl());
        PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions globalViewOptions = PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions.withDefaults();
        globalViewOptions.setTableProps("TTL = 10000");
        try {
            schemaBuilder.withTableOptions(PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults()).withGlobalViewOptions(globalViewOptions).build();
            Assert.fail();
        }
        catch (SQLException sqe) {
            Assert.assertEquals((long)sqe.getErrorCode(), (long)SQLExceptionCode.VIEW_TTL_NOT_ENABLED.getErrorCode());
        }
    }

    @Test
    public void testAlterViewWithTTLWithConfigFalse() throws Exception {
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(ViewTTLNotEnabledIT.getUrl());
        PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions globalViewOptions = PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions.withDefaults();
        schemaBuilder.withTableOptions(PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults()).withGlobalViewOptions(globalViewOptions).build();
        String dml = "ALTER VIEW " + schemaBuilder.getEntityGlobalViewName() + " SET TTL = 10000";
        try (Connection connection = DriverManager.getConnection(ViewTTLNotEnabledIT.getUrl());){
            try {
                connection.createStatement().execute(dml);
                Assert.fail();
            }
            catch (SQLException sqe) {
                Assert.assertEquals((long)sqe.getErrorCode(), (long)SQLExceptionCode.VIEW_TTL_NOT_ENABLED.getErrorCode());
            }
        }
    }

    @Test
    public void testSettingTTLFromTableToViewWithConfigDisabled() throws Exception {
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(ViewTTLNotEnabledIT.getUrl());
        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
        tableOptions.setTableProps("TTL = 10000");
        PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions globalViewOptions = PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions.withDefaults();
        schemaBuilder.withTableOptions(tableOptions).withGlobalViewOptions(globalViewOptions).build();
        try (Connection connection = DriverManager.getConnection(ViewTTLNotEnabledIT.getUrl());){
            String dml = "ALTER TABLE " + schemaBuilder.getEntityTableName() + " SET TTL = NONE";
            connection.createStatement().execute(dml);
            connection.unwrap(PhoenixConnection.class).getQueryServices().clearCache();
            try {
                dml = "ALTER VIEW " + schemaBuilder.getEntityGlobalViewName() + " SET TTL = 10000";
                connection.createStatement().execute(dml);
                Assert.fail();
            }
            catch (SQLException sqe) {
                Assert.assertEquals((long)sqe.getErrorCode(), (long)SQLExceptionCode.VIEW_TTL_NOT_ENABLED.getErrorCode());
            }
        }
    }
}

