/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.end2end.BaseViewTTLIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.query.PhoenixTestBuilder;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.base.Joiner;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.ManualEnvironmentEdge;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class ViewTTLIT
extends BaseViewTTLIT {
    public ViewTTLIT(boolean useCondExpression) {
        super(useCondExpression);
    }

    @BeforeClass
    public static void doSetup() throws Exception {
        HashMap<String, String> DEFAULT_PROPERTIES = new HashMap<String, String>(){
            {
                this.put("phoenix.compaction.enabled", String.valueOf(true));
                this.put("phoenix.view.ttl.enabled", Boolean.toString(true));
                this.put("phoenix.index.longViewIndex.enabled", String.valueOf(false));
                this.put("hbase.procedure.remote.dispatcher.delay.msec", "0");
                this.put("phoenix.max.lookback.age.seconds", Integer.toString(0));
                this.put("phoenix.view.ttl.tenant_views_per_scan.limit", String.valueOf(1));
            }
        };
        ViewTTLIT.setUpTestDriver(new ReadOnlyProps(ReadOnlyProps.EMPTY_PROPS, DEFAULT_PROPERTIES.entrySet().iterator()));
    }

    @Override
    @Before
    public void beforeTest() {
        EnvironmentEdgeManager.reset();
        this.injectEdge = new ManualEnvironmentEdge();
        this.injectEdge.setValue(EnvironmentEdgeManager.currentTimeMillis());
    }

    @Override
    @After
    public synchronized void afterTest() throws Exception {
        EnvironmentEdgeManager.reset();
    }

    @Test
    public void testWithBasicGlobalViewWithNoPhoenixTTLDefined() throws Exception {
        long startTime = EnvironmentEdgeManager.currentTimeMillis();
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(ViewTTLIT.getUrl());
        schemaBuilder.withTableDefaults().withGlobalViewDefaults().build();
        this.assertViewHeaderRowsHavePhoenixTTLRelatedCells(schemaBuilder.getTableOptions().getSchemaName(), startTime, true, 2);
    }

    @Test
    public void testPhoenixTTLWithTableLevelTTLFails() throws Exception {
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(ViewTTLIT.getUrl());
        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
        tableOptions.setTableProps(String.format("COLUMN_ENCODED_BYTES=0,MULTI_TENANT=true,TTL='%s'", this.getTTLExpression(100)));
        PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewOptions = PhoenixTestBuilder.SchemaBuilder.TenantViewOptions.withDefaults();
        tenantViewOptions.setTableProps(String.format("TTL='%s'", this.getTTLExpression(1000)));
        try {
            schemaBuilder.withTableOptions(tableOptions).withTenantViewOptions(tenantViewOptions).buildNewView();
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.TTL_ALREADY_DEFINED_IN_HIERARCHY.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testPhoenixTTLWithViewIndexFails() throws Exception {
        PhoenixTestBuilder.SchemaBuilder.TenantViewIndexOptions tenantViewIndexOptions = PhoenixTestBuilder.SchemaBuilder.TenantViewIndexOptions.withDefaults();
        tenantViewIndexOptions.setIndexProps(String.format("TTL='%s'", this.getTTLExpression(1000)));
        try {
            PhoenixTestBuilder.SchemaBuilder schemaBuilder = this.createLevel1TenantView(null, tenantViewIndexOptions);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.CANNOT_SET_OR_ALTER_PROPERTY_FOR_INDEX.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testPhoenixTTLForLevelOneView() throws Exception {
        long startTime = EnvironmentEdgeManager.currentTimeMillis();
        PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewOptions = PhoenixTestBuilder.SchemaBuilder.TenantViewOptions.withDefaults();
        String ttlExpr = this.getTTLExpression(120);
        tenantViewOptions.setTableProps(String.format("TTL='%s'", ttlExpr));
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = this.createLevel1TenantView(tenantViewOptions, null);
        String tenantId = schemaBuilder.getDataOptions().getTenantId();
        String schemaName = this.stripQuotes(SchemaUtil.getSchemaNameFromFullName((String)schemaBuilder.getEntityTenantViewName()));
        String tenantViewName = this.stripQuotes(SchemaUtil.getTableNameFromFullName((String)schemaBuilder.getEntityTenantViewName()));
        String indexOnTenantViewName = String.format("IDX_%s", this.stripQuotes(schemaBuilder.getEntityKeyPrefix()));
        this.assertViewHeaderRowsHavePhoenixTTLRelatedCells(schemaBuilder.getTableOptions().getSchemaName(), startTime, false, 1);
        this.assertSyscatHavePhoenixTTLRelatedColumns(tenantId, schemaName, tenantViewName, PTableType.VIEW.getSerializedValue(), ttlExpr);
        this.assertSyscatHavePhoenixTTLRelatedColumns(tenantId, schemaName, indexOnTenantViewName, PTableType.INDEX.getSerializedValue(), "0");
    }

    @Test
    public void testPhoenixTTLForLevelTwoView() throws Exception {
        long startTime = EnvironmentEdgeManager.currentTimeMillis();
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = this.createLevel2TenantViewWithGlobalLevelTTL(null, null, false);
        String tenantId = schemaBuilder.getDataOptions().getTenantId();
        String schemaName = this.stripQuotes(SchemaUtil.getSchemaNameFromFullName((String)schemaBuilder.getEntityTenantViewName()));
        String globalViewName = this.stripQuotes(SchemaUtil.getTableNameFromFullName((String)schemaBuilder.getEntityGlobalViewName()));
        String tenantViewName = this.stripQuotes(SchemaUtil.getTableNameFromFullName((String)schemaBuilder.getEntityTenantViewName()));
        String ttlExpr = this.getTTLExpression(300);
        this.assertViewHeaderRowsHavePhoenixTTLRelatedCells(schemaBuilder.getTableOptions().getSchemaName(), startTime, false, 1);
        this.assertSyscatHavePhoenixTTLRelatedColumns("", schemaName, globalViewName, PTableType.VIEW.getSerializedValue(), ttlExpr);
        this.assertSyscatHavePhoenixTTLRelatedColumns(tenantId, schemaName, tenantViewName, PTableType.VIEW.getSerializedValue(), "0");
    }

    @Test
    public void testPhoenixTTLForWhenTTLIsZero() throws Exception {
        long startTime = EnvironmentEdgeManager.currentTimeMillis();
        PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewOptions = PhoenixTestBuilder.SchemaBuilder.TenantViewOptions.withDefaults();
        tenantViewOptions.setTableProps("TTL=0");
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = this.createLevel1TenantView(tenantViewOptions, null);
        String tenantId = schemaBuilder.getDataOptions().getTenantId();
        String schemaName = this.stripQuotes(SchemaUtil.getSchemaNameFromFullName((String)schemaBuilder.getEntityTenantViewName()));
        String tenantViewName = this.stripQuotes(SchemaUtil.getTableNameFromFullName((String)schemaBuilder.getEntityTenantViewName()));
        String indexOnTenantViewName = String.format("IDX_%s", this.stripQuotes(schemaBuilder.getEntityKeyPrefix()));
        this.assertViewHeaderRowsHavePhoenixTTLRelatedCells(schemaBuilder.getTableOptions().getSchemaName(), startTime, true, 3);
        this.assertSyscatHavePhoenixTTLRelatedColumns(tenantId, schemaName, tenantViewName, PTableType.VIEW.getSerializedValue(), "0");
        this.assertSyscatHavePhoenixTTLRelatedColumns(tenantId, schemaName, indexOnTenantViewName, PTableType.INDEX.getSerializedValue(), "0");
    }

    @Test
    public void testPhoenixTTLWithAlterView() throws Exception {
        long startTime = EnvironmentEdgeManager.currentTimeMillis();
        int ttl = 120;
        PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewOptions = PhoenixTestBuilder.SchemaBuilder.TenantViewOptions.withDefaults();
        tenantViewOptions.setTableProps("TTL=NONE");
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = this.createLevel1TenantView(tenantViewOptions, null);
        String tenantId = schemaBuilder.getDataOptions().getTenantId();
        String schemaName = this.stripQuotes(SchemaUtil.getSchemaNameFromFullName((String)schemaBuilder.getEntityTenantViewName()));
        String tenantViewName = this.stripQuotes(SchemaUtil.getTableNameFromFullName((String)schemaBuilder.getEntityTenantViewName()));
        String indexOnTenantViewName = String.format("IDX_%s", this.stripQuotes(schemaBuilder.getEntityKeyPrefix()));
        this.assertViewHeaderRowsHavePhoenixTTLRelatedCells(schemaBuilder.getTableOptions().getSchemaName(), startTime, true, 3);
        this.assertSyscatHavePhoenixTTLRelatedColumns(tenantId, schemaName, tenantViewName, PTableType.VIEW.getSerializedValue(), "0");
        this.assertSyscatHavePhoenixTTLRelatedColumns(tenantId, schemaName, indexOnTenantViewName, PTableType.INDEX.getSerializedValue(), "0");
        String tenantURL = ViewTTLIT.getUrl() + ";TenantId=" + tenantId;
        try (Connection connection = DriverManager.getConnection(tenantURL);
             Statement stmt = connection.createStatement();){
            String sql = String.format("ALTER VIEW \"%s\".\"%s\" set TTL='%s'", schemaName, tenantViewName, this.getTTLExpression(ttl));
            stmt.execute(sql);
        }
        this.assertViewHeaderRowsHavePhoenixTTLRelatedCells(schemaBuilder.getTableOptions().getSchemaName(), startTime, false, 1);
        this.assertSyscatHavePhoenixTTLRelatedColumns(tenantId, schemaName, tenantViewName, PTableType.VIEW.getSerializedValue(), this.getTTLExpression(ttl));
        this.assertSyscatHavePhoenixTTLRelatedColumns(tenantId, schemaName, indexOnTenantViewName, PTableType.INDEX.getSerializedValue(), "0");
    }

    @Test
    public void testTTLAlreadyDefinedInHierarchyWhenCreateView() throws Exception {
        try {
            PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewWithOverrideOptions = PhoenixTestBuilder.SchemaBuilder.TenantViewOptions.withDefaults();
            tenantViewWithOverrideOptions.setTableProps(String.format("TTL='%s'", this.getTTLExpression(120)));
            PhoenixTestBuilder.SchemaBuilder schemaBuilder = this.createLevel2TenantViewWithGlobalLevelTTL(tenantViewWithOverrideOptions, null, false);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.TTL_ALREADY_DEFINED_IN_HIERARCHY.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testTTLAlreadyDefinedInHierarchyWhenAlterTenantView() throws Exception {
        long startTime = EnvironmentEdgeManager.currentTimeMillis();
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = this.createLevel2TenantViewWithGlobalLevelTTL(null, null, false);
        String tenantId = schemaBuilder.getDataOptions().getTenantId();
        String schemaName = this.stripQuotes(SchemaUtil.getSchemaNameFromFullName((String)schemaBuilder.getEntityTenantViewName()));
        String globalViewName = this.stripQuotes(SchemaUtil.getTableNameFromFullName((String)schemaBuilder.getEntityGlobalViewName()));
        String tenantViewName = this.stripQuotes(SchemaUtil.getTableNameFromFullName((String)schemaBuilder.getEntityTenantViewName()));
        String ttlExpr = this.getTTLExpression(300);
        this.assertViewHeaderRowsHavePhoenixTTLRelatedCells(schemaBuilder.getTableOptions().getSchemaName(), startTime, false, 1);
        this.assertSyscatHavePhoenixTTLRelatedColumns("", schemaName, globalViewName, PTableType.VIEW.getSerializedValue(), ttlExpr);
        this.assertSyscatHavePhoenixTTLRelatedColumns(tenantId, schemaName, tenantViewName, PTableType.VIEW.getSerializedValue(), "0");
        String tenantURL = ViewTTLIT.getUrl() + ";TenantId=" + tenantId;
        try (Connection connection = DriverManager.getConnection(tenantURL);
             Statement stmt = connection.createStatement();){
            String sql = String.format("ALTER VIEW \"%s\".\"%s\" set TTL='%s'", schemaName, tenantViewName, "120");
            stmt.execute(sql);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.TTL_ALREADY_DEFINED_IN_HIERARCHY.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testTTLAlreadyDefinedInHierarchyWhenAlterGlobalView() throws Exception {
        long startTime = EnvironmentEdgeManager.currentTimeMillis();
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = this.createLevel2TenantViewWithTenantLevelTTL(null, null);
        String tenantId = schemaBuilder.getDataOptions().getTenantId();
        String schemaName = this.stripQuotes(SchemaUtil.getSchemaNameFromFullName((String)schemaBuilder.getEntityTenantViewName()));
        String globalViewName = this.stripQuotes(SchemaUtil.getTableNameFromFullName((String)schemaBuilder.getEntityGlobalViewName()));
        String tenantViewName = this.stripQuotes(SchemaUtil.getTableNameFromFullName((String)schemaBuilder.getEntityTenantViewName()));
        String indexOnGlobalViewName = String.format("IDX_%s", globalViewName);
        String indexOnTenantViewName = String.format("IDX_%s", this.stripQuotes(schemaBuilder.getEntityKeyPrefix()));
        String ttlExpr = this.getTTLExpression(300);
        this.assertViewHeaderRowsHavePhoenixTTLRelatedCells(schemaBuilder.getTableOptions().getSchemaName(), startTime, false, 1);
        this.assertSyscatHavePhoenixTTLRelatedColumns(tenantId, schemaName, tenantViewName, PTableType.VIEW.getSerializedValue(), ttlExpr);
        this.assertSyscatHavePhoenixTTLRelatedColumns(tenantId, schemaName, indexOnTenantViewName, PTableType.INDEX.getSerializedValue(), "0");
        try (Connection connection = DriverManager.getConnection(ViewTTLIT.getUrl());
             Statement stmt = connection.createStatement();){
            String sql = String.format("ALTER VIEW \"%s\".\"%s\" set TTL='%s'", schemaName, globalViewName, this.getTTLExpression(120));
            stmt.execute(sql);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.TTL_ALREADY_DEFINED_IN_HIERARCHY.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testAlterViewWithNoTTLPropertySucceed() throws Exception {
        long startTime = EnvironmentEdgeManager.currentTimeMillis();
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = this.createLevel2TenantViewWithTenantLevelTTL(null, null);
        String tenantId = schemaBuilder.getDataOptions().getTenantId();
        String schemaName = this.stripQuotes(SchemaUtil.getSchemaNameFromFullName((String)schemaBuilder.getEntityTenantViewName()));
        String globalViewName = this.stripQuotes(SchemaUtil.getTableNameFromFullName((String)schemaBuilder.getEntityGlobalViewName()));
        String tenantViewName = this.stripQuotes(SchemaUtil.getTableNameFromFullName((String)schemaBuilder.getEntityTenantViewName()));
        String indexOnGlobalViewName = String.format("IDX_%s", globalViewName);
        String indexOnTenantViewName = String.format("IDX_%s", this.stripQuotes(schemaBuilder.getEntityKeyPrefix()));
        String ttlExpr = this.getTTLExpression(300);
        this.assertViewHeaderRowsHavePhoenixTTLRelatedCells(schemaBuilder.getTableOptions().getSchemaName(), startTime, false, 1);
        this.assertSyscatHavePhoenixTTLRelatedColumns(tenantId, schemaName, tenantViewName, PTableType.VIEW.getSerializedValue(), ttlExpr);
        this.assertSyscatHavePhoenixTTLRelatedColumns(tenantId, schemaName, indexOnTenantViewName, PTableType.INDEX.getSerializedValue(), "0");
        try (Connection connection = DriverManager.getConnection(ViewTTLIT.getUrl());
             Statement stmt = connection.createStatement();){
            String sql = String.format("ALTER VIEW \"%s\".\"%s\" ADD IF NOT EXISTS %s CHAR(10)", schemaName, globalViewName, "COL_30");
            stmt.execute(sql);
        }
        String tenantURL = ViewTTLIT.getUrl() + ";TenantId=" + tenantId;
        try (Connection connection = DriverManager.getConnection(tenantURL);
             Statement stmt = connection.createStatement();){
            String sql = String.format("ALTER VIEW \"%s\".\"%s\" ADD IF NOT EXISTS %s CHAR(10)", schemaName, tenantViewName, "COL_100");
            stmt.execute(sql);
        }
    }

    @Test
    public void testResetViewTTL() throws Exception {
        long startTime = EnvironmentEdgeManager.currentTimeMillis();
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = this.createLevel2TenantViewWithGlobalLevelTTL(null, null, false);
        String tenantId = schemaBuilder.getDataOptions().getTenantId();
        String schemaName = this.stripQuotes(SchemaUtil.getSchemaNameFromFullName((String)schemaBuilder.getEntityTenantViewName()));
        String globalViewName = this.stripQuotes(SchemaUtil.getTableNameFromFullName((String)schemaBuilder.getEntityGlobalViewName()));
        String tenantViewName = this.stripQuotes(SchemaUtil.getTableNameFromFullName((String)schemaBuilder.getEntityTenantViewName()));
        String indexOnGlobalViewName = String.format("IDX_%s", globalViewName);
        String indexOnTenantViewName = String.format("IDX_%s", this.stripQuotes(schemaBuilder.getEntityKeyPrefix()));
        try (Connection connection = DriverManager.getConnection(ViewTTLIT.getUrl());
             Statement stmt = connection.createStatement();){
            String sql = String.format("ALTER VIEW \"%s\".\"%s\" set TTL='%s'", schemaName, globalViewName, "NONE");
            stmt.execute(sql);
        }
        this.assertViewHeaderRowsHavePhoenixTTLRelatedCells(schemaBuilder.getTableOptions().getSchemaName(), startTime, true, 4);
        this.assertSyscatHavePhoenixTTLRelatedColumns("", schemaName, globalViewName, PTableType.VIEW.getSerializedValue(), "0");
        this.assertSyscatHavePhoenixTTLRelatedColumns("", schemaName, indexOnGlobalViewName, PTableType.INDEX.getSerializedValue(), "0");
        this.assertSyscatHavePhoenixTTLRelatedColumns(tenantId, schemaName, tenantViewName, PTableType.VIEW.getSerializedValue(), "0");
        this.assertSyscatHavePhoenixTTLRelatedColumns(tenantId, schemaName, indexOnTenantViewName, PTableType.INDEX.getSerializedValue(), "0");
    }

    @Test
    public void testWithTenantViewAndNoGlobalView() throws Exception {
        int viewTTL = 10;
        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
        tableOptions.getTableColumns().clear();
        tableOptions.getTableColumnTypes().clear();
        Iterator iterator = Lists.newArrayList((Object[])new Boolean[]{true, false}).iterator();
        while (iterator.hasNext()) {
            final boolean isMultiTenant = (Boolean)iterator.next();
            this.resetEnvironmentEdgeManager();
            tableOptions.setMultiTenant(isMultiTenant);
            PhoenixTestBuilder.SchemaBuilder.DataOptions dataOptions = isMultiTenant ? PhoenixTestBuilder.SchemaBuilder.DataOptions.withDefaults() : PhoenixTestBuilder.SchemaBuilder.DataOptions.withPrefix("CUSTOM_OBJECT");
            int viewCounter = 1;
            final String orgId = String.format("00T0t%04d%s", viewCounter, dataOptions.getUniqueName());
            final String keyPrefix = "C01";
            PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(ViewTTLIT.getUrl());
            if (isMultiTenant) {
                PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewOptions = PhoenixTestBuilder.SchemaBuilder.TenantViewOptions.withDefaults();
                tenantViewOptions.setTableProps(String.format("TTL='%s'", this.getTTLExpression(viewTTL)));
                schemaBuilder.withTableOptions(tableOptions).withTenantViewOptions(tenantViewOptions).withDataOptions(dataOptions).withTenantViewIndexDefaults().buildWithNewTenant();
            } else {
                PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions globalViewOptions = new PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions();
                globalViewOptions.setSchemaName("TEST_ENTITY");
                globalViewOptions.setGlobalViewColumns(Lists.newArrayList(PhoenixTestBuilder.DDLDefaults.TENANT_VIEW_COLUMNS));
                globalViewOptions.setGlobalViewColumnTypes(Lists.newArrayList(PhoenixTestBuilder.DDLDefaults.COLUMN_TYPES));
                globalViewOptions.setGlobalViewPKColumns(Lists.newArrayList(PhoenixTestBuilder.DDLDefaults.TENANT_VIEW_PK_COLUMNS));
                globalViewOptions.setGlobalViewPKColumnTypes(Lists.newArrayList(PhoenixTestBuilder.DDLDefaults.TENANT_VIEW_PK_TYPES));
                globalViewOptions.setTableProps(String.format("TTL='%s'", this.getTTLExpression(viewTTL)));
                PhoenixTestBuilder.SchemaBuilder.GlobalViewIndexOptions globalViewIndexOptions = new PhoenixTestBuilder.SchemaBuilder.GlobalViewIndexOptions();
                globalViewIndexOptions.setGlobalViewIndexColumns(Lists.newArrayList(PhoenixTestBuilder.DDLDefaults.TENANT_VIEW_INDEX_COLUMNS));
                globalViewIndexOptions.setGlobalViewIncludeColumns(Lists.newArrayList(PhoenixTestBuilder.DDLDefaults.TENANT_VIEW_INCLUDE_COLUMNS));
                globalViewOptions.setGlobalViewCondition(String.format("SELECT * FROM %s.%s WHERE OID = '%s' AND KP = '%s'", dataOptions.getSchemaName(), dataOptions.getTableName(), orgId, keyPrefix));
                PhoenixTestBuilder.SchemaBuilder.ConnectOptions connectOptions = new PhoenixTestBuilder.SchemaBuilder.ConnectOptions();
                connectOptions.setUseGlobalConnectionOnly(true);
                schemaBuilder.withTableOptions(tableOptions).withGlobalViewOptions(globalViewOptions).withDataOptions(dataOptions).withConnectOptions(connectOptions).withGlobalViewIndexOptions(globalViewIndexOptions).build();
            }
            PhoenixTestBuilder.DataSupplier dataSupplier = new PhoenixTestBuilder.DataSupplier(){

                @Override
                public List<Object> getValues(int rowIndex) {
                    Random rnd = new Random();
                    String oid = orgId;
                    String kp = keyPrefix;
                    String zid = String.format("00A0y000%07d", rowIndex);
                    String col7 = String.format("g%05d", rowIndex + rnd.nextInt(10000));
                    String col8 = String.format("h%05d", rowIndex + rnd.nextInt(10000));
                    String col9 = String.format("i%05d", rowIndex + rnd.nextInt(10000));
                    return isMultiTenant ? Lists.newArrayList((Object[])new Object[]{zid, col7, col8, col9}) : Lists.newArrayList((Object[])new Object[]{oid, kp, zid, col7, col8, col9});
                }
            };
            PhoenixTestBuilder.BasicDataWriter dataWriter = new PhoenixTestBuilder.BasicDataWriter();
            PhoenixTestBuilder.BasicDataReader dataReader = new PhoenixTestBuilder.BasicDataReader();
            ArrayList columns = isMultiTenant ? Lists.newArrayList((Object[])new String[]{"ZID", "COL7", "COL8", "COL9"}) : Lists.newArrayList((Object[])new String[]{"OID", "KP", "ZID", "COL7", "COL8", "COL9"});
            ArrayList rowKeyColumns = isMultiTenant ? Lists.newArrayList((Object[])new String[]{"ZID"}) : Lists.newArrayList((Object[])new String[]{"OID", "KP", "ZID"});
            String tenantConnectUrl = ViewTTLIT.getUrl() + ";TenantId=" + schemaBuilder.getDataOptions().getTenantId();
            Connection writeConnection = DriverManager.getConnection(tenantConnectUrl);
            try {
                writeConnection.setAutoCommit(true);
                dataWriter.setConnection(writeConnection);
                dataWriter.setDataSupplier(dataSupplier);
                dataWriter.setUpsertColumns(columns);
                dataWriter.setRowKeyColumns(rowKeyColumns);
                dataWriter.setTargetEntity(isMultiTenant ? schemaBuilder.getEntityTenantViewName() : schemaBuilder.getEntityGlobalViewName());
                dataReader.setValidationColumns(columns);
                dataReader.setRowKeyColumns(rowKeyColumns);
                dataReader.setDML(String.format("SELECT %s from %s", Joiner.on((String)",").join((Iterable)columns), isMultiTenant ? schemaBuilder.getEntityTenantViewName() : schemaBuilder.getEntityGlobalViewName()));
                dataReader.setTargetEntity(isMultiTenant ? schemaBuilder.getEntityTenantViewName() : schemaBuilder.getEntityGlobalViewName());
                this.upsertDataAndRunValidations(viewTTL, 5, dataWriter, dataReader, schemaBuilder);
            }
            finally {
                if (writeConnection == null) continue;
                writeConnection.close();
            }
        }
    }

    @Test
    public void testWithSQLUsingIndexWithCoveredColsUpdates() throws Exception {
        int viewTTL = 10;
        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
        tableOptions.getTableColumns().clear();
        tableOptions.getTableColumnTypes().clear();
        PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions globalViewOptions = PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions.withDefaults();
        globalViewOptions.setTableProps(String.format("TTL='%s'", this.getTTLExpression(viewTTL)));
        PhoenixTestBuilder.SchemaBuilder.GlobalViewIndexOptions globalViewIndexOptions = PhoenixTestBuilder.SchemaBuilder.GlobalViewIndexOptions.withDefaults();
        PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewOptions = new PhoenixTestBuilder.SchemaBuilder.TenantViewOptions();
        tenantViewOptions.setTenantViewColumns(Arrays.asList("ZID", "COL7", "COL8", "COL9"));
        tenantViewOptions.setTenantViewColumnTypes(Arrays.asList("CHAR(15)", "VARCHAR", "VARCHAR", "VARCHAR"));
        PhoenixTestBuilder.SchemaBuilder.OtherOptions testCaseWhenAllCFMatchAndAllDefault = new PhoenixTestBuilder.SchemaBuilder.OtherOptions();
        testCaseWhenAllCFMatchAndAllDefault.setTestName("testCaseWhenAllCFMatchAndAllDefault");
        testCaseWhenAllCFMatchAndAllDefault.setTableCFs(Lists.newArrayList((Object[])new String[]{null, null, null}));
        testCaseWhenAllCFMatchAndAllDefault.setGlobalViewCFs(Lists.newArrayList((Object[])new String[]{null, null, null}));
        testCaseWhenAllCFMatchAndAllDefault.setTenantViewCFs(Lists.newArrayList((Object[])new String[]{null, null, null, null}));
        Iterator iterator = Lists.newArrayList((Object[])new Boolean[]{true, false}).iterator();
        while (iterator.hasNext()) {
            boolean isGlobalIndexLocal = (Boolean)iterator.next();
            globalViewIndexOptions.setLocal(isGlobalIndexLocal);
            PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(ViewTTLIT.getUrl());
            schemaBuilder.withTableOptions(tableOptions).withGlobalViewOptions(globalViewOptions).withGlobalViewIndexOptions(globalViewIndexOptions).withTenantViewOptions(tenantViewOptions).withOtherOptions(testCaseWhenAllCFMatchAndAllDefault).build();
            final ArrayList outerCol4s = Lists.newArrayList();
            PhoenixTestBuilder.DataSupplier dataSupplier = new PhoenixTestBuilder.DataSupplier(){
                String col4ForWhereClause;

                @Override
                public List<Object> getValues(int rowIndex) {
                    Random rnd = new Random();
                    String id = String.format("00A0y000%07d", rowIndex);
                    String zid = String.format("00B0y000%07d", rowIndex);
                    String col4 = String.format("d%05d", rowIndex + rnd.nextInt(10000));
                    outerCol4s.add(col4);
                    String col5 = String.format("e%05d", rowIndex + rnd.nextInt(10000));
                    String col6 = String.format("f%05d", rowIndex + rnd.nextInt(10000));
                    String col7 = String.format("g%05d", rowIndex + rnd.nextInt(10000));
                    String col8 = String.format("h%05d", rowIndex + rnd.nextInt(10000));
                    String col9 = String.format("i%05d", rowIndex + rnd.nextInt(10000));
                    return Lists.newArrayList((Object[])new Object[]{id, zid, col4, col5, col6, col7, col8, col9});
                }
            };
            PhoenixTestBuilder.BasicDataWriter dataWriter = new PhoenixTestBuilder.BasicDataWriter();
            PhoenixTestBuilder.BasicDataReader dataReader = new PhoenixTestBuilder.BasicDataReader();
            ArrayList columns = Lists.newArrayList((Object[])new String[]{"ID", "ZID", "COL4", "COL5", "COL6", "COL7", "COL8", "COL9"});
            ArrayList rowKeyColumns = Lists.newArrayList((Object[])new String[]{"COL6"});
            String tenantConnectUrl = ViewTTLIT.getUrl() + ";TenantId=" + schemaBuilder.getDataOptions().getTenantId();
            Connection writeConnection = DriverManager.getConnection(tenantConnectUrl);
            try {
                writeConnection.setAutoCommit(true);
                dataWriter.setConnection(writeConnection);
                dataWriter.setDataSupplier(dataSupplier);
                dataWriter.setUpsertColumns(columns);
                dataWriter.setRowKeyColumns(rowKeyColumns);
                dataWriter.setTargetEntity(schemaBuilder.getEntityTenantViewName());
                this.upsertData(dataWriter, 5);
                dataReader.setValidationColumns(rowKeyColumns);
                dataReader.setRowKeyColumns(rowKeyColumns);
                dataReader.setDML(String.format("SELECT col6 from %s where col4 = '%s'", schemaBuilder.getEntityTenantViewName(), outerCol4s.get(1)));
                dataReader.setTargetEntity(schemaBuilder.getEntityTenantViewName());
                this.validateExpiredRowsAreNotReturnedUsingCounts(viewTTL, dataReader, schemaBuilder);
            }
            finally {
                if (writeConnection == null) continue;
                writeConnection.close();
            }
        }
    }

    @Test
    public void testWithSQLUsingIndexAndNoCoveredColsUpdates() throws Exception {
        int viewTTL = 10;
        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
        tableOptions.getTableColumns().clear();
        tableOptions.getTableColumnTypes().clear();
        PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions globalViewOptions = PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions.withDefaults();
        globalViewOptions.setTableProps(String.format("TTL='%s'", this.getTTLExpression(viewTTL)));
        PhoenixTestBuilder.SchemaBuilder.GlobalViewIndexOptions globalViewIndexOptions = PhoenixTestBuilder.SchemaBuilder.GlobalViewIndexOptions.withDefaults();
        PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewOptions = new PhoenixTestBuilder.SchemaBuilder.TenantViewOptions();
        tenantViewOptions.setTenantViewColumns(Arrays.asList("ZID", "COL7", "COL8", "COL9"));
        tenantViewOptions.setTenantViewColumnTypes(Arrays.asList("CHAR(15)", "VARCHAR", "VARCHAR", "VARCHAR"));
        PhoenixTestBuilder.SchemaBuilder.OtherOptions testCaseWhenAllCFMatchAndAllDefault = new PhoenixTestBuilder.SchemaBuilder.OtherOptions();
        testCaseWhenAllCFMatchAndAllDefault.setTestName("testCaseWhenAllCFMatchAndAllDefault");
        testCaseWhenAllCFMatchAndAllDefault.setTableCFs(Lists.newArrayList((Object[])new String[]{null, null, null}));
        testCaseWhenAllCFMatchAndAllDefault.setGlobalViewCFs(Lists.newArrayList((Object[])new String[]{null, null, null}));
        testCaseWhenAllCFMatchAndAllDefault.setTenantViewCFs(Lists.newArrayList((Object[])new String[]{null, null, null, null}));
        Iterator iterator = Lists.newArrayList((Object[])new Boolean[]{true, false}).iterator();
        while (iterator.hasNext()) {
            boolean isGlobalIndexLocal = (Boolean)iterator.next();
            globalViewIndexOptions.setLocal(isGlobalIndexLocal);
            PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(ViewTTLIT.getUrl());
            schemaBuilder.withTableOptions(tableOptions).withGlobalViewOptions(globalViewOptions).withGlobalViewIndexOptions(globalViewIndexOptions).withTenantViewOptions(tenantViewOptions).withOtherOptions(testCaseWhenAllCFMatchAndAllDefault).build();
            final ArrayList outerCol4s = Lists.newArrayList();
            PhoenixTestBuilder.DataSupplier dataSupplier = new PhoenixTestBuilder.DataSupplier(){

                @Override
                public List<Object> getValues(int rowIndex) {
                    Random rnd = new Random();
                    String id = String.format("00A0y000%07d", rowIndex);
                    String zid = String.format("00B0y000%07d", rowIndex);
                    String col4 = String.format("d%05d", rowIndex + rnd.nextInt(10000));
                    outerCol4s.add(col4);
                    String col5 = String.format("e%05d", rowIndex + rnd.nextInt(10000));
                    String col6 = String.format("f%05d", rowIndex + rnd.nextInt(10000));
                    String col7 = String.format("g%05d", rowIndex + rnd.nextInt(10000));
                    String col8 = String.format("h%05d", rowIndex + rnd.nextInt(10000));
                    String col9 = String.format("i%05d", rowIndex + rnd.nextInt(10000));
                    return Lists.newArrayList((Object[])new Object[]{id, zid, col4, col5, col6, col7, col8, col9});
                }
            };
            PhoenixTestBuilder.BasicDataWriter dataWriter = new PhoenixTestBuilder.BasicDataWriter();
            PhoenixTestBuilder.BasicDataReader dataReader = new PhoenixTestBuilder.BasicDataReader();
            ArrayList columns = Lists.newArrayList((Object[])new String[]{"ID", "ZID", "COL4", "COL5", "COL6", "COL7", "COL8", "COL9"});
            ArrayList nonCoveredColumns = Lists.newArrayList((Object[])new String[]{"ID", "ZID", "COL5", "COL7", "COL8", "COL9"});
            ArrayList rowKeyColumns = Lists.newArrayList((Object[])new String[]{"COL6"});
            String tenantConnectUrl = ViewTTLIT.getUrl() + ";TenantId=" + schemaBuilder.getDataOptions().getTenantId();
            Connection writeConnection = DriverManager.getConnection(tenantConnectUrl);
            try {
                writeConnection.setAutoCommit(true);
                dataWriter.setConnection(writeConnection);
                dataWriter.setDataSupplier(dataSupplier);
                dataWriter.setUpsertColumns(columns);
                dataWriter.setRowKeyColumns(rowKeyColumns);
                dataWriter.setTargetEntity(schemaBuilder.getEntityTenantViewName());
                this.upsertData(dataWriter, 5);
                dataReader.setValidationColumns(rowKeyColumns);
                dataReader.setRowKeyColumns(rowKeyColumns);
                dataReader.setDML(String.format("SELECT col6 from %s where col4 = '%s'", schemaBuilder.getEntityTenantViewName(), outerCol4s.get(1)));
                dataReader.setTargetEntity(schemaBuilder.getEntityTenantViewName());
                this.validateExpiredRowsAreNotReturnedUsingCounts(viewTTL, dataReader, schemaBuilder);
                PhoenixTestBuilder.DataSupplier dataSupplierForNonCoveredColumns = new PhoenixTestBuilder.DataSupplier(){

                    @Override
                    public List<Object> getValues(int rowIndex) {
                        Random rnd = new Random();
                        String id = String.format("00A0y000%07d", rowIndex);
                        String zid = String.format("00B0y000%07d", rowIndex);
                        String col5 = String.format("e%05d", rowIndex + rnd.nextInt(10000));
                        String col7 = String.format("g%05d", rowIndex + rnd.nextInt(10000));
                        String col8 = String.format("h%05d", rowIndex + rnd.nextInt(10000));
                        String col9 = String.format("i%05d", rowIndex + rnd.nextInt(10000));
                        return Lists.newArrayList((Object[])new Object[]{id, zid, col5, col7, col8, col9});
                    }
                };
                dataWriter.setDataSupplier(dataSupplierForNonCoveredColumns);
                dataWriter.setUpsertColumns(nonCoveredColumns);
                this.upsertData(dataWriter, 5);
                ArrayList rowKeyColumns1 = Lists.newArrayList((Object[])new String[]{"ID", "COL6"});
                dataReader.setValidationColumns(rowKeyColumns1);
                dataReader.setRowKeyColumns(rowKeyColumns1);
                dataReader.setDML(String.format("SELECT id, col6 from %s where col4 = '%s'", schemaBuilder.getEntityTenantViewName(), outerCol4s.get(1)));
                this.validateExpiredRowsAreNotReturnedUsingCounts(viewTTL, dataReader, schemaBuilder);
            }
            finally {
                if (writeConnection == null) continue;
                writeConnection.close();
            }
        }
    }

    @Test
    public void testWithSQLUsingIndexAndMultiLevelViews() throws Exception {
        int viewTTL = 10;
        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
        tableOptions.getTableColumns().clear();
        tableOptions.getTableColumnTypes().clear();
        PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions globalViewOptions = PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions.withDefaults();
        globalViewOptions.setTableProps(String.format("TTL='%s'", this.getTTLExpression(viewTTL)));
        PhoenixTestBuilder.SchemaBuilder.GlobalViewIndexOptions globalViewIndexOptions = PhoenixTestBuilder.SchemaBuilder.GlobalViewIndexOptions.withDefaults();
        globalViewIndexOptions.setLocal(false);
        PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewOptions = new PhoenixTestBuilder.SchemaBuilder.TenantViewOptions();
        tenantViewOptions.setTenantViewColumns(Arrays.asList("ZID", "COL7", "COL8", "COL9"));
        tenantViewOptions.setTenantViewColumnTypes(Arrays.asList("CHAR(15)", "VARCHAR", "VARCHAR", "VARCHAR"));
        PhoenixTestBuilder.SchemaBuilder.OtherOptions testCaseWhenAllCFMatchAndAllDefault = new PhoenixTestBuilder.SchemaBuilder.OtherOptions();
        testCaseWhenAllCFMatchAndAllDefault.setTestName("testCaseWhenAllCFMatchAndAllDefault");
        testCaseWhenAllCFMatchAndAllDefault.setTableCFs(Lists.newArrayList((Object[])new String[]{null, null, null}));
        testCaseWhenAllCFMatchAndAllDefault.setGlobalViewCFs(Lists.newArrayList((Object[])new String[]{null, null, null}));
        testCaseWhenAllCFMatchAndAllDefault.setTenantViewCFs(Lists.newArrayList((Object[])new String[]{null, null, null, null}));
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(ViewTTLIT.getUrl());
        schemaBuilder.withTableOptions(tableOptions).withGlobalViewOptions(globalViewOptions).withGlobalViewIndexOptions(globalViewIndexOptions).withTenantViewOptions(tenantViewOptions).withOtherOptions(testCaseWhenAllCFMatchAndAllDefault).build();
        String level3ViewName = String.format("%s.%s", "TEST_ENTITY", "E11");
        String level3ViewCreateSQL = String.format("CREATE VIEW IF NOT EXISTS %s AS SELECT * FROM %s", level3ViewName, schemaBuilder.getEntityTenantViewName());
        String tConnectUrl = ViewTTLIT.getUrl() + ";TenantId=" + schemaBuilder.getDataOptions().getTenantId();
        try (Connection tConnection = DriverManager.getConnection(tConnectUrl);){
            tConnection.createStatement().execute(level3ViewCreateSQL);
        }
        final ArrayList outerCol4s = Lists.newArrayList();
        PhoenixTestBuilder.DataSupplier dataSupplier = new PhoenixTestBuilder.DataSupplier(){

            @Override
            public List<Object> getValues(int rowIndex) {
                Random rnd = new Random();
                String id = String.format("00A0y000%07d", rowIndex);
                String zid = String.format("00B0y000%07d", rowIndex);
                String col4 = String.format("d%05d", rowIndex + rnd.nextInt(10000));
                outerCol4s.add(col4);
                String col5 = String.format("e%05d", rowIndex + rnd.nextInt(10000));
                String col6 = String.format("f%05d", rowIndex + rnd.nextInt(10000));
                String col7 = String.format("g%05d", rowIndex + rnd.nextInt(10000));
                String col8 = String.format("h%05d", rowIndex + rnd.nextInt(10000));
                String col9 = String.format("i%05d", rowIndex + rnd.nextInt(10000));
                return Lists.newArrayList((Object[])new Object[]{id, zid, col4, col5, col6, col7, col8, col9});
            }
        };
        PhoenixTestBuilder.BasicDataWriter dataWriter = new PhoenixTestBuilder.BasicDataWriter();
        PhoenixTestBuilder.BasicDataReader dataReader = new PhoenixTestBuilder.BasicDataReader();
        ArrayList columns = Lists.newArrayList((Object[])new String[]{"ID", "ZID", "COL4", "COL5", "COL6", "COL7", "COL8", "COL9"});
        ArrayList nonCoveredColumns = Lists.newArrayList((Object[])new String[]{"ID", "ZID", "COL5", "COL7", "COL8", "COL9"});
        ArrayList rowKeyColumns = Lists.newArrayList((Object[])new String[]{"COL6"});
        String tenantConnectUrl = ViewTTLIT.getUrl() + ";TenantId=" + schemaBuilder.getDataOptions().getTenantId();
        try (Connection writeConnection = DriverManager.getConnection(tenantConnectUrl);){
            writeConnection.setAutoCommit(true);
            dataWriter.setConnection(writeConnection);
            dataWriter.setDataSupplier(dataSupplier);
            dataWriter.setUpsertColumns(columns);
            dataWriter.setRowKeyColumns(rowKeyColumns);
            dataWriter.setTargetEntity(level3ViewName);
            this.upsertData(dataWriter, 5);
            dataReader.setValidationColumns(rowKeyColumns);
            dataReader.setRowKeyColumns(rowKeyColumns);
            dataReader.setDML(String.format("SELECT col6 from %s where col4 = '%s'", level3ViewName, outerCol4s.get(1)));
            dataReader.setTargetEntity(level3ViewName);
            this.validateExpiredRowsAreNotReturnedUsingCounts(viewTTL, dataReader, schemaBuilder);
            PhoenixTestBuilder.DataSupplier dataSupplierForNonCoveredColumns = new PhoenixTestBuilder.DataSupplier(){

                @Override
                public List<Object> getValues(int rowIndex) {
                    Random rnd = new Random();
                    String id = String.format("00A0y000%07d", rowIndex);
                    String zid = String.format("00B0y000%07d", rowIndex);
                    String col5 = String.format("e%05d", rowIndex + rnd.nextInt(10000));
                    String col7 = String.format("g%05d", rowIndex + rnd.nextInt(10000));
                    String col8 = String.format("h%05d", rowIndex + rnd.nextInt(10000));
                    String col9 = String.format("i%05d", rowIndex + rnd.nextInt(10000));
                    return Lists.newArrayList((Object[])new Object[]{id, zid, col5, col7, col8, col9});
                }
            };
            dataWriter.setDataSupplier(dataSupplierForNonCoveredColumns);
            dataWriter.setUpsertColumns(nonCoveredColumns);
            this.upsertData(dataWriter, 5);
            ArrayList rowKeyColumns1 = Lists.newArrayList((Object[])new String[]{"ID", "COL6"});
            dataReader.setValidationColumns(rowKeyColumns1);
            dataReader.setRowKeyColumns(rowKeyColumns1);
            dataReader.setDML(String.format("SELECT id, col6 from %s where col4 = '%s'", level3ViewName, outerCol4s.get(1)));
            this.validateExpiredRowsAreNotReturnedUsingCounts(viewTTL, dataReader, schemaBuilder);
        }
    }

    @Test
    public void testWithVariousSQLs() throws Exception {
        int viewTTL = 10;
        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
        tableOptions.getTableColumns().clear();
        tableOptions.getTableColumnTypes().clear();
        PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions globalViewOptions = PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions.withDefaults();
        globalViewOptions.setTableProps(String.format("TTL='%s'", this.getTTLExpression(viewTTL)));
        PhoenixTestBuilder.SchemaBuilder.GlobalViewIndexOptions globalViewIndexOptions = PhoenixTestBuilder.SchemaBuilder.GlobalViewIndexOptions.withDefaults();
        globalViewIndexOptions.setLocal(false);
        PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewOptions = new PhoenixTestBuilder.SchemaBuilder.TenantViewOptions();
        tenantViewOptions.setTenantViewColumns(Arrays.asList("ZID", "COL7", "COL8", "COL9"));
        tenantViewOptions.setTenantViewColumnTypes(Arrays.asList("CHAR(15)", "VARCHAR", "VARCHAR", "VARCHAR"));
        PhoenixTestBuilder.SchemaBuilder.OtherOptions testCaseWhenAllCFMatchAndAllDefault = new PhoenixTestBuilder.SchemaBuilder.OtherOptions();
        testCaseWhenAllCFMatchAndAllDefault.setTestName("testCaseWhenAllCFMatchAndAllDefault");
        testCaseWhenAllCFMatchAndAllDefault.setTableCFs(Lists.newArrayList((Object[])new String[]{null, null, null}));
        testCaseWhenAllCFMatchAndAllDefault.setGlobalViewCFs(Lists.newArrayList((Object[])new String[]{null, null, null}));
        testCaseWhenAllCFMatchAndAllDefault.setTenantViewCFs(Lists.newArrayList((Object[])new String[]{null, null, null, null}));
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(ViewTTLIT.getUrl());
        schemaBuilder.withTableOptions(tableOptions).withGlobalViewOptions(globalViewOptions).withGlobalViewIndexOptions(globalViewIndexOptions).withTenantViewOptions(tenantViewOptions).withOtherOptions(testCaseWhenAllCFMatchAndAllDefault).build();
        final String groupById = String.format("00A0y000%07d", 0);
        PhoenixTestBuilder.DataSupplier dataSupplier = new PhoenixTestBuilder.DataSupplier(){

            @Override
            public List<Object> getValues(int rowIndex) {
                Random rnd = new Random();
                String zid = String.format("00B0y000%07d", rowIndex);
                String col4 = String.format("d%05d", rowIndex + rnd.nextInt(10000));
                String col5 = String.format("e%05d", rowIndex + rnd.nextInt(10000));
                String col6 = String.format("f%05d", rowIndex + rnd.nextInt(10000));
                String col7 = String.format("g%05d", rowIndex + rnd.nextInt(10000));
                String col8 = String.format("h%05d", rowIndex + rnd.nextInt(10000));
                String col9 = String.format("i%05d", rowIndex + rnd.nextInt(10000));
                return Lists.newArrayList((Object[])new Object[]{groupById, zid, col4, col5, col6, col7, col8, col9});
            }
        };
        PhoenixTestBuilder.BasicDataWriter dataWriter = new PhoenixTestBuilder.BasicDataWriter();
        ArrayList columns = Lists.newArrayList((Object[])new String[]{"ID", "ZID", "COL4", "COL5", "COL6", "COL7", "COL8", "COL9"});
        ArrayList rowKeyColumns = Lists.newArrayList((Object[])new String[]{"ID", "ZID"});
        String tenantConnectUrl = ViewTTLIT.getUrl() + ";TenantId=" + schemaBuilder.getDataOptions().getTenantId();
        try (Connection writeConnection = DriverManager.getConnection(tenantConnectUrl);){
            writeConnection.setAutoCommit(true);
            dataWriter.setConnection(writeConnection);
            dataWriter.setDataSupplier(dataSupplier);
            dataWriter.setUpsertColumns(columns);
            dataWriter.setRowKeyColumns(rowKeyColumns);
            dataWriter.setTargetEntity(schemaBuilder.getEntityTenantViewName());
            this.upsertData(dataWriter, 5);
            PhoenixTestBuilder.BasicDataReader dataReader = new PhoenixTestBuilder.BasicDataReader();
            dataReader.setValidationColumns(Arrays.asList("num_rows"));
            dataReader.setRowKeyColumns(Arrays.asList("num_rows"));
            dataReader.setDML(String.format("SELECT count(1) as num_rows from %s HAVING count(1) > 0", schemaBuilder.getEntityTenantViewName()));
            dataReader.setTargetEntity(schemaBuilder.getEntityTenantViewName());
            this.validateExpiredRowsAreNotReturnedUsingCounts(viewTTL, dataReader, schemaBuilder);
            dataReader.setValidationColumns(Arrays.asList("num_rows"));
            dataReader.setRowKeyColumns(Arrays.asList("num_rows"));
            dataReader.setDML(String.format("SELECT count(1) as num_rows from %s GROUP BY ID HAVING count(1) > 0", schemaBuilder.getEntityTenantViewName(), groupById));
            dataReader.setTargetEntity(schemaBuilder.getEntityTenantViewName());
            this.validateExpiredRowsAreNotReturnedUsingCounts(viewTTL, dataReader, schemaBuilder);
        }
    }

    @Test
    public void testWithVariousSQLsForMultipleTenants() throws Exception {
        int viewTTL = 10;
        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
        tableOptions.getTableColumns().clear();
        tableOptions.getTableColumnTypes().clear();
        PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions globalViewOptions = PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions.withDefaults();
        globalViewOptions.setTableProps(String.format("TTL='%s'", this.getTTLExpression(viewTTL)));
        PhoenixTestBuilder.SchemaBuilder.GlobalViewIndexOptions globalViewIndexOptions = PhoenixTestBuilder.SchemaBuilder.GlobalViewIndexOptions.withDefaults();
        globalViewIndexOptions.setLocal(false);
        PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewOptions = new PhoenixTestBuilder.SchemaBuilder.TenantViewOptions();
        tenantViewOptions.setTenantViewColumns(Arrays.asList("ZID", "COL7", "COL8", "COL9"));
        tenantViewOptions.setTenantViewColumnTypes(Arrays.asList("CHAR(15)", "VARCHAR", "VARCHAR", "VARCHAR"));
        PhoenixTestBuilder.SchemaBuilder.OtherOptions testCaseWhenAllCFMatchAndAllDefault = new PhoenixTestBuilder.SchemaBuilder.OtherOptions();
        testCaseWhenAllCFMatchAndAllDefault.setTestName("testCaseWhenAllCFMatchAndAllDefault");
        testCaseWhenAllCFMatchAndAllDefault.setTableCFs(Lists.newArrayList((Object[])new String[]{null, null, null}));
        testCaseWhenAllCFMatchAndAllDefault.setGlobalViewCFs(Lists.newArrayList((Object[])new String[]{null, null, null}));
        testCaseWhenAllCFMatchAndAllDefault.setTenantViewCFs(Lists.newArrayList((Object[])new String[]{null, null, null, null}));
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(ViewTTLIT.getUrl());
        schemaBuilder.withTableOptions(tableOptions).withGlobalViewOptions(globalViewOptions).withGlobalViewIndexOptions(globalViewIndexOptions).withTenantViewOptions(tenantViewOptions).withOtherOptions(testCaseWhenAllCFMatchAndAllDefault);
        for (int tenant : Arrays.asList(1, 2, 3)) {
            schemaBuilder.buildWithNewTenant();
            final String groupById = String.format("00A0y000%07d", 0);
            PhoenixTestBuilder.DataSupplier dataSupplier = new PhoenixTestBuilder.DataSupplier(){

                @Override
                public List<Object> getValues(int rowIndex) {
                    Random rnd = new Random();
                    String zid = String.format("00B0y000%07d", rowIndex);
                    String col4 = String.format("d%05d", rowIndex + rnd.nextInt(10000));
                    String col5 = String.format("e%05d", rowIndex + rnd.nextInt(10000));
                    String col6 = String.format("f%05d", rowIndex + rnd.nextInt(10000));
                    String col7 = String.format("g%05d", rowIndex + rnd.nextInt(10000));
                    String col8 = String.format("h%05d", rowIndex + rnd.nextInt(10000));
                    String col9 = String.format("i%05d", rowIndex + rnd.nextInt(10000));
                    return Lists.newArrayList((Object[])new Object[]{groupById, zid, col4, col5, col6, col7, col8, col9});
                }
            };
            PhoenixTestBuilder.BasicDataWriter dataWriter = new PhoenixTestBuilder.BasicDataWriter();
            ArrayList columns = Lists.newArrayList((Object[])new String[]{"ID", "ZID", "COL4", "COL5", "COL6", "COL7", "COL8", "COL9"});
            ArrayList rowKeyColumns = Lists.newArrayList((Object[])new String[]{"ID", "ZID"});
            String tenantConnectUrl = ViewTTLIT.getUrl() + ";TenantId=" + schemaBuilder.getDataOptions().getTenantId();
            Connection writeConnection = DriverManager.getConnection(tenantConnectUrl);
            try {
                writeConnection.setAutoCommit(true);
                dataWriter.setConnection(writeConnection);
                dataWriter.setDataSupplier(dataSupplier);
                dataWriter.setUpsertColumns(columns);
                dataWriter.setRowKeyColumns(rowKeyColumns);
                dataWriter.setTargetEntity(schemaBuilder.getEntityTenantViewName());
                this.upsertData(dataWriter, 5);
                PhoenixTestBuilder.BasicDataReader dataReader = new PhoenixTestBuilder.BasicDataReader();
                dataReader.setValidationColumns(Arrays.asList("num_rows"));
                dataReader.setRowKeyColumns(Arrays.asList("num_rows"));
                dataReader.setDML(String.format("SELECT count(1) as num_rows from %s HAVING count(1) > 0", schemaBuilder.getEntityTenantViewName()));
                dataReader.setTargetEntity(schemaBuilder.getEntityTenantViewName());
                this.validateExpiredRowsAreNotReturnedUsingCounts(viewTTL, dataReader, schemaBuilder);
                dataReader.setValidationColumns(Arrays.asList("num_rows"));
                dataReader.setRowKeyColumns(Arrays.asList("num_rows"));
                dataReader.setDML(String.format("SELECT count(1) as num_rows from %s GROUP BY ID HAVING count(1) > 0", schemaBuilder.getEntityTenantViewName()));
                dataReader.setTargetEntity(schemaBuilder.getEntityTenantViewName());
                this.validateExpiredRowsAreNotReturnedUsingCounts(viewTTL, dataReader, schemaBuilder);
            }
            finally {
                if (writeConnection == null) continue;
                writeConnection.close();
            }
        }
    }

    @Test
    public void testWithVariousSQLsForMultipleViews() throws Exception {
        int viewTTL = 10;
        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
        tableOptions.getTableColumns().clear();
        tableOptions.getTableColumnTypes().clear();
        PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewOptions = new PhoenixTestBuilder.SchemaBuilder.TenantViewOptions();
        tenantViewOptions.setTenantViewColumns(Arrays.asList("ZID", "COL7", "COL8", "COL9"));
        tenantViewOptions.setTenantViewColumnTypes(Arrays.asList("CHAR(15)", "VARCHAR", "VARCHAR", "VARCHAR"));
        tenantViewOptions.setTableProps(String.format("TTL='%s'", this.getTTLExpression(viewTTL)));
        PhoenixTestBuilder.SchemaBuilder.OtherOptions testCaseWhenAllCFMatchAndAllDefault = new PhoenixTestBuilder.SchemaBuilder.OtherOptions();
        testCaseWhenAllCFMatchAndAllDefault.setTestName("testCaseWhenAllCFMatchAndAllDefault");
        testCaseWhenAllCFMatchAndAllDefault.setTableCFs(Lists.newArrayList((Object[])new String[]{null, null, null}));
        testCaseWhenAllCFMatchAndAllDefault.setGlobalViewCFs(Lists.newArrayList((Object[])new String[]{null, null, null}));
        testCaseWhenAllCFMatchAndAllDefault.setTenantViewCFs(Lists.newArrayList((Object[])new String[]{null, null, null, null}));
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(ViewTTLIT.getUrl());
        schemaBuilder.withTableOptions(tableOptions).withTenantViewOptions(tenantViewOptions).withOtherOptions(testCaseWhenAllCFMatchAndAllDefault);
        for (int view : Arrays.asList(1, 2, 3)) {
            schemaBuilder.buildNewView();
            PhoenixTestBuilder.DataSupplier dataSupplier = new PhoenixTestBuilder.DataSupplier(){

                @Override
                public List<Object> getValues(int rowIndex) {
                    Random rnd = new Random();
                    String zid = String.format("00B0y000%07d", rowIndex);
                    String col7 = String.format("g%05d", rowIndex + rnd.nextInt(10000));
                    String col8 = String.format("h%05d", rowIndex + rnd.nextInt(10000));
                    String col9 = String.format("i%05d", rowIndex + rnd.nextInt(10000));
                    return Lists.newArrayList((Object[])new Object[]{zid, col7, col8, col9});
                }
            };
            PhoenixTestBuilder.BasicDataWriter dataWriter = new PhoenixTestBuilder.BasicDataWriter();
            ArrayList columns = Lists.newArrayList((Object[])new String[]{"ZID", "COL7", "COL8", "COL9"});
            ArrayList rowKeyColumns = Lists.newArrayList((Object[])new String[]{"ZID"});
            String tenantConnectUrl = ViewTTLIT.getUrl() + ";TenantId=" + schemaBuilder.getDataOptions().getTenantId();
            Connection writeConnection = DriverManager.getConnection(tenantConnectUrl);
            try {
                writeConnection.setAutoCommit(true);
                dataWriter.setConnection(writeConnection);
                dataWriter.setDataSupplier(dataSupplier);
                dataWriter.setUpsertColumns(columns);
                dataWriter.setRowKeyColumns(rowKeyColumns);
                dataWriter.setTargetEntity(schemaBuilder.getEntityTenantViewName());
                this.upsertData(dataWriter, 5);
                PhoenixTestBuilder.BasicDataReader dataReader = new PhoenixTestBuilder.BasicDataReader();
                dataReader.setValidationColumns(Arrays.asList("num_rows"));
                dataReader.setRowKeyColumns(Arrays.asList("num_rows"));
                dataReader.setDML(String.format("SELECT count(1) as num_rows from %s HAVING count(1) > 0", schemaBuilder.getEntityTenantViewName()));
                dataReader.setTargetEntity(schemaBuilder.getEntityTenantViewName());
                this.validateExpiredRowsAreNotReturnedUsingCounts(viewTTL, dataReader, schemaBuilder);
                dataReader.setValidationColumns(Arrays.asList("num_rows"));
                dataReader.setRowKeyColumns(Arrays.asList("num_rows"));
                dataReader.setDML(String.format("SELECT count(1) as num_rows from %s GROUP BY ZID HAVING count(1) > 0", schemaBuilder.getEntityTenantViewName()));
                dataReader.setTargetEntity(schemaBuilder.getEntityTenantViewName());
                this.validateExpiredRowsAreNotReturnedUsingCounts(viewTTL, dataReader, schemaBuilder);
            }
            finally {
                if (writeConnection == null) continue;
                writeConnection.close();
            }
        }
    }

    @Test
    public void testGlobalAndTenantViewTTLInheritance1() throws Exception {
        int tenantPhoenixTTL = 200;
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(ViewTTLIT.getUrl());
        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
        tableOptions.setTableProps("COLUMN_ENCODED_BYTES=0,MULTI_TENANT=true");
        PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions globalViewOptions = PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions.withDefaults();
        PhoenixTestBuilder.SchemaBuilder.GlobalViewIndexOptions globalViewIndexOptions = PhoenixTestBuilder.SchemaBuilder.GlobalViewIndexOptions.withDefaults();
        globalViewIndexOptions.setLocal(false);
        PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewWithOverrideOptions = new PhoenixTestBuilder.SchemaBuilder.TenantViewOptions();
        tenantViewWithOverrideOptions.setTenantViewColumns(Arrays.asList("ZID", "COL7", "COL8", "COL9"));
        tenantViewWithOverrideOptions.setTenantViewColumnTypes(Arrays.asList("CHAR(15)", "VARCHAR", "VARCHAR", "VARCHAR"));
        tenantViewWithOverrideOptions.setTableProps(String.format("TTL='%s'", this.getTTLExpression(tenantPhoenixTTL)));
        PhoenixTestBuilder.SchemaBuilder.OtherOptions testCaseWhenAllCFMatchAndAllDefault = new PhoenixTestBuilder.SchemaBuilder.OtherOptions();
        testCaseWhenAllCFMatchAndAllDefault.setTestName("testCaseWhenAllCFMatchAndAllDefault");
        testCaseWhenAllCFMatchAndAllDefault.setTableCFs(Lists.newArrayList((Object[])new String[]{null, null, null}));
        testCaseWhenAllCFMatchAndAllDefault.setGlobalViewCFs(Lists.newArrayList((Object[])new String[]{null, null, null}));
        testCaseWhenAllCFMatchAndAllDefault.setTenantViewCFs(Lists.newArrayList((Object[])new String[]{null, null, null, null}));
        schemaBuilder.withTableOptions(tableOptions).withGlobalViewOptions(globalViewOptions).withGlobalViewIndexOptions(globalViewIndexOptions).withTenantViewOptions(tenantViewWithOverrideOptions).withTenantViewIndexDefaults().withOtherOptions(testCaseWhenAllCFMatchAndAllDefault).buildWithNewTenant();
        final String id = String.format("00A0y000%07d", 0);
        PhoenixTestBuilder.DataSupplier dataSupplier = new PhoenixTestBuilder.DataSupplier(){

            @Override
            public List<Object> getValues(int rowIndex) {
                Random rnd = new Random();
                String zid = String.format("00B0y000%07d", rowIndex);
                String col1 = String.format("a%05d", rowIndex + rnd.nextInt(10000));
                String col2 = String.format("b%05d", rowIndex + rnd.nextInt(10000));
                String col3 = String.format("c%05d", rowIndex + rnd.nextInt(10000));
                String col4 = String.format("d%05d", rowIndex + rnd.nextInt(10000));
                String col5 = String.format("e%05d", rowIndex + rnd.nextInt(10000));
                String col6 = String.format("f%05d", rowIndex + rnd.nextInt(10000));
                String col7 = String.format("g%05d", rowIndex + rnd.nextInt(10000));
                String col8 = String.format("h%05d", rowIndex + rnd.nextInt(10000));
                String col9 = String.format("i%05d", rowIndex + rnd.nextInt(10000));
                return Lists.newArrayList((Object[])new Object[]{id, zid, col1, col2, col3, col4, col5, col6, col7, col8, col9});
            }
        };
        PhoenixTestBuilder.BasicDataWriter dataWriter = new PhoenixTestBuilder.BasicDataWriter();
        ArrayList columns = Lists.newArrayList((Object[])new String[]{"ID", "ZID", "COL1", "COL2", "COL3", "COL4", "COL5", "COL6", "COL7", "COL8", "COL9"});
        ArrayList rowKeyColumns = Lists.newArrayList((Object[])new String[]{"ID", "ZID"});
        String tenant1ConnectUrl = ViewTTLIT.getUrl() + ";TenantId=" + schemaBuilder.getDataOptions().getTenantId();
        try (Connection writeConnection = DriverManager.getConnection(tenant1ConnectUrl);){
            writeConnection.setAutoCommit(true);
            dataWriter.setConnection(writeConnection);
            dataWriter.setDataSupplier(dataSupplier);
            dataWriter.setUpsertColumns(columns);
            dataWriter.setRowKeyColumns(rowKeyColumns);
            dataWriter.setTargetEntity(schemaBuilder.getEntityTenantViewName());
            this.upsertData(dataWriter, 5);
            PhoenixTestBuilder.BasicDataReader dataReader = new PhoenixTestBuilder.BasicDataReader();
            dataReader.setValidationColumns(Arrays.asList("num_rows"));
            dataReader.setRowKeyColumns(Arrays.asList("num_rows"));
            dataReader.setDML(String.format("SELECT count(1) as num_rows from %s HAVING count(1) > 0", schemaBuilder.getEntityTenantViewName()));
            dataReader.setTargetEntity(schemaBuilder.getEntityTenantViewName());
            long probeTimestamp = EnvironmentEdgeManager.currentTimeMillis() + (long)(tenantPhoenixTTL * 1000 / 2);
            this.validateRowsAreNotMaskedUsingCounts(probeTimestamp, dataReader, schemaBuilder);
            this.validateExpiredRowsAreNotReturnedUsingCounts(tenantPhoenixTTL, dataReader, schemaBuilder);
        }
    }

    @Test
    public void testGlobalAndTenantViewTTLInheritance2() throws Exception {
        int globalViewTTL = 300;
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(ViewTTLIT.getUrl());
        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
        tableOptions.setTableProps("COLUMN_ENCODED_BYTES=0,MULTI_TENANT=true");
        PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions globalViewOptions = PhoenixTestBuilder.SchemaBuilder.GlobalViewOptions.withDefaults();
        globalViewOptions.setTableProps(String.format("TTL='%s'", this.getTTLExpression(globalViewTTL)));
        PhoenixTestBuilder.SchemaBuilder.GlobalViewIndexOptions globalViewIndexOptions = PhoenixTestBuilder.SchemaBuilder.GlobalViewIndexOptions.withDefaults();
        globalViewIndexOptions.setLocal(false);
        PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewWithOverrideOptions = new PhoenixTestBuilder.SchemaBuilder.TenantViewOptions();
        tenantViewWithOverrideOptions.setTenantViewColumns(Arrays.asList("ZID", "COL7", "COL8", "COL9"));
        tenantViewWithOverrideOptions.setTenantViewColumnTypes(Arrays.asList("CHAR(15)", "VARCHAR", "VARCHAR", "VARCHAR"));
        PhoenixTestBuilder.SchemaBuilder.OtherOptions testCaseWhenAllCFMatchAndAllDefault = new PhoenixTestBuilder.SchemaBuilder.OtherOptions();
        testCaseWhenAllCFMatchAndAllDefault.setTestName("testCaseWhenAllCFMatchAndAllDefault");
        testCaseWhenAllCFMatchAndAllDefault.setTableCFs(Lists.newArrayList((Object[])new String[]{null, null, null}));
        testCaseWhenAllCFMatchAndAllDefault.setGlobalViewCFs(Lists.newArrayList((Object[])new String[]{null, null, null}));
        testCaseWhenAllCFMatchAndAllDefault.setTenantViewCFs(Lists.newArrayList((Object[])new String[]{null, null, null, null}));
        schemaBuilder.withTableOptions(tableOptions).withGlobalViewOptions(globalViewOptions).withGlobalViewIndexOptions(globalViewIndexOptions).withTenantViewOptions(tenantViewWithOverrideOptions).withTenantViewIndexDefaults().withOtherOptions(testCaseWhenAllCFMatchAndAllDefault).buildWithNewTenant();
        final String id = String.format("00A0y000%07d", 0);
        PhoenixTestBuilder.DataSupplier dataSupplier = new PhoenixTestBuilder.DataSupplier(){

            @Override
            public List<Object> getValues(int rowIndex) {
                Random rnd = new Random();
                String zid = String.format("00B0y000%07d", rowIndex);
                String col1 = String.format("a%05d", rowIndex + rnd.nextInt(10000));
                String col2 = String.format("b%05d", rowIndex + rnd.nextInt(10000));
                String col3 = String.format("c%05d", rowIndex + rnd.nextInt(10000));
                String col4 = String.format("d%05d", rowIndex + rnd.nextInt(10000));
                String col5 = String.format("e%05d", rowIndex + rnd.nextInt(10000));
                String col6 = String.format("f%05d", rowIndex + rnd.nextInt(10000));
                String col7 = String.format("g%05d", rowIndex + rnd.nextInt(10000));
                String col8 = String.format("h%05d", rowIndex + rnd.nextInt(10000));
                String col9 = String.format("i%05d", rowIndex + rnd.nextInt(10000));
                return Lists.newArrayList((Object[])new Object[]{id, zid, col1, col2, col3, col4, col5, col6, col7, col8, col9});
            }
        };
        PhoenixTestBuilder.BasicDataWriter dataWriter = new PhoenixTestBuilder.BasicDataWriter();
        ArrayList columns = Lists.newArrayList((Object[])new String[]{"ID", "ZID", "COL1", "COL2", "COL3", "COL4", "COL5", "COL6", "COL7", "COL8", "COL9"});
        ArrayList rowKeyColumns = Lists.newArrayList((Object[])new String[]{"ID", "ZID"});
        String tenant1ConnectUrl = ViewTTLIT.getUrl() + ";TenantId=" + schemaBuilder.getDataOptions().getTenantId();
        try (Connection writeConnection = DriverManager.getConnection(tenant1ConnectUrl);){
            writeConnection.setAutoCommit(true);
            dataWriter.setConnection(writeConnection);
            dataWriter.setDataSupplier(dataSupplier);
            dataWriter.setUpsertColumns(columns);
            dataWriter.setRowKeyColumns(rowKeyColumns);
            dataWriter.setTargetEntity(schemaBuilder.getEntityTenantViewName());
            this.upsertData(dataWriter, 5);
            PhoenixTestBuilder.BasicDataReader dataReader = new PhoenixTestBuilder.BasicDataReader();
            dataReader.setValidationColumns(Arrays.asList("num_rows"));
            dataReader.setRowKeyColumns(Arrays.asList("num_rows"));
            dataReader.setDML(String.format("SELECT count(1) as num_rows from %s HAVING count(1) > 0", schemaBuilder.getEntityTenantViewName()));
            dataReader.setTargetEntity(schemaBuilder.getEntityTenantViewName());
            long probeTimestamp = EnvironmentEdgeManager.currentTimeMillis() + (long)(globalViewTTL * 1000 / 2);
            this.validateRowsAreNotMaskedUsingCounts(probeTimestamp, dataReader, schemaBuilder);
            this.validateExpiredRowsAreNotReturnedUsingCounts(globalViewTTL, dataReader, schemaBuilder);
        }
    }

    @Test
    public void testScanAttributes() throws Exception {
        QueryPlan queryPlan;
        PhoenixStatement pstmt;
        String stmtString;
        Statement statement;
        int phoenixTTL = 10;
        PhoenixTestBuilder.SchemaBuilder.TableOptions tableOptions = PhoenixTestBuilder.SchemaBuilder.TableOptions.withDefaults();
        tableOptions.getTableColumns().clear();
        tableOptions.getTableColumnTypes().clear();
        PhoenixTestBuilder.SchemaBuilder.TenantViewOptions tenantViewOptions = PhoenixTestBuilder.SchemaBuilder.TenantViewOptions.withDefaults();
        String ttlExpr = this.getTTLExpression(phoenixTTL);
        tenantViewOptions.setTableProps(String.format("TTL='%s'", ttlExpr));
        PhoenixTestBuilder.SchemaBuilder schemaBuilder = new PhoenixTestBuilder.SchemaBuilder(ViewTTLIT.getUrl());
        schemaBuilder.withTableOptions(tableOptions).withTenantViewOptions(tenantViewOptions).build();
        String viewName = schemaBuilder.getEntityTenantViewName();
        Properties props = new Properties();
        String tenantConnectUrl = ViewTTLIT.getUrl() + ";TenantId=" + schemaBuilder.getDataOptions().getTenantId();
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(tenantConnectUrl, props);){
            statement = conn.createStatement();
            try {
                conn.setAutoCommit(true);
                stmtString = String.format("select * from  %s", viewName);
                Preconditions.checkNotNull((Object)stmtString);
                pstmt = statement.unwrap(PhoenixStatement.class);
                queryPlan = pstmt.optimizeQuery(stmtString);
                PTable table = conn.getTable(schemaBuilder.getDataOptions().getTenantId(), viewName);
                PhoenixResultSet rs = pstmt.newResultSet(queryPlan.iterator(), queryPlan.getProjector(), queryPlan.getContext());
                Assert.assertFalse((String)"Should not have any rows", (boolean)rs.next());
                Assert.assertEquals((String)"Should have atleast one element", (long)1L, (long)queryPlan.getScans().size());
                Assert.assertEquals((String)"PhoenixTTL does not match", (Object)table.getCompiledTTLExpression(conn), (Object)ScanUtil.getTTLExpression((Scan)((Scan)((List)queryPlan.getScans().get(0)).get(0))));
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        conn = (PhoenixConnection)DriverManager.getConnection(tenantConnectUrl, props);
        try {
            statement = conn.createStatement();
            try {
                conn.setAutoCommit(true);
                stmtString = String.format("select * from  %s", viewName);
                Preconditions.checkNotNull((Object)stmtString);
                pstmt = statement.unwrap(PhoenixStatement.class);
                queryPlan = pstmt.optimizeQuery(stmtString);
                Scan scan = queryPlan.getContext().getScan();
                PTable table = conn.getTable(schemaBuilder.getDataOptions().getTenantId(), viewName);
                byte[] emptyColumnFamilyName = SchemaUtil.getEmptyColumnFamily((PTable)table);
                byte[] emptyColumnName = table.getEncodingScheme() == PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS ? QueryConstants.EMPTY_COLUMN_BYTES : table.getEncodingScheme().encode(QueryConstants.ENCODED_EMPTY_COLUMN_NAME.intValue());
                scan.setAttribute("_EmptyCFName", emptyColumnFamilyName);
                scan.setAttribute("_EmptyCQName", emptyColumnName);
                scan.setAttribute("_TTL", table.getCompiledTTLExpression(conn).serialize());
                PhoenixResultSet rs = pstmt.newResultSet(queryPlan.iterator(), queryPlan.getProjector(), queryPlan.getContext());
                Assert.assertFalse((String)"Should not have any rows", (boolean)rs.next());
                Assert.assertEquals((String)"Should have atleast one element", (long)1L, (long)queryPlan.getScans().size());
                Assert.assertEquals((String)"PhoenixTTL does not match", (Object)table.getCompiledTTLExpression(conn), (Object)ScanUtil.getTTLExpression((Scan)((Scan)((List)queryPlan.getScans().get(0)).get(0))));
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Override
    @Test
    public void testMajorCompactWithSimpleIndexedBaseTables() throws Exception {
        super.testMajorCompactWithSimpleIndexedBaseTables();
    }

    @Override
    @Test
    public void testMajorCompactFromMultipleGlobalIndexes() throws Exception {
        super.testMajorCompactFromMultipleGlobalIndexes();
    }

    @Override
    @Test
    public void testMajorCompactFromMultipleTenantIndexes() throws Exception {
        super.testMajorCompactFromMultipleTenantIndexes();
    }

    @Override
    @Test
    public void testMajorCompactWithOnlyTenantView() throws Exception {
        super.testMajorCompactWithOnlyTenantView();
    }

    @Override
    @Test
    public void testMajorCompactWithSaltedIndexedTenantView() throws Exception {
        super.testMajorCompactWithSaltedIndexedTenantView();
    }

    @Override
    @Test
    public void testMajorCompactWithSaltedIndexedBaseTables() throws Exception {
        super.testMajorCompactWithSaltedIndexedBaseTables();
    }

    @Override
    @Test
    public void testMajorCompactWithVariousViewsAndOptions() throws Exception {
        super.testMajorCompactWithVariousViewsAndOptions();
    }

    @Override
    @Test
    public void testMajorCompactWhenTTLSetForSomeTenants() throws Exception {
        super.testMajorCompactWhenTTLSetForSomeTenants();
    }

    @Override
    @Test
    public void testMajorCompactWithGlobalAndTenantViewHierarchy() throws Exception {
        super.testMajorCompactWithGlobalAndTenantViewHierarchy();
    }

    @Test
    public void testMajorCompactWithVariousTenantIdTypesAndRegions() throws Exception {
        super.testMajorCompactWithVariousTenantIdTypesAndRegions((PDataType)PVarchar.INSTANCE);
        super.testMajorCompactWithVariousTenantIdTypesAndRegions((PDataType)PInteger.INSTANCE);
        super.testMajorCompactWithVariousTenantIdTypesAndRegions((PDataType)PLong.INSTANCE);
    }

    @Override
    @Test
    public void testMajorCompactTenantViewsWithVariousPKTypesAndSortOrder() throws Exception {
        super.testMajorCompactTenantViewsWithVariousPKTypesAndSortOrder();
    }

    @Override
    @Test
    public void testTenantViewsWithOverlappingRowPrefixes() throws Exception {
        super.testTenantViewsWithOverlappingRowPrefixes();
    }
}

