/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class ViewIndexIdRetrieveIT
extends BaseTest {
    private final String BASE_TABLE_DDL = "CREATE TABLE %s (TENANT_ID CHAR(15) NOT NULL, ID CHAR(3) NOT NULL, NUM BIGINT CONSTRAINT PK PRIMARY KEY (TENANT_ID, ID)) MULTI_TENANT = true, COLUMN_ENCODED_BYTES=0 ";
    private final String VIEW_DDL = "CREATE VIEW %s (A BIGINT PRIMARY KEY, B BIGINT) AS SELECT * FROM %s WHERE ID='ABC'";
    private final String VIEW_INDEX_DDL = "CREATE INDEX %s ON %s (B DESC) INCLUDE (NUM)";
    private final String SELECT_ALL = "SELECT * FROM SYSTEM.CATALOG";
    private final String SELECT_ROW = "SELECT VIEW_INDEX_ID,VIEW_INDEX_ID_DATA_TYPE FROM SYSTEM.CATALOG WHERE TABLE_NAME='%s' AND COLUMN_COUNT IS NOT NULL";

    @BeforeClass
    public static synchronized void setUp() throws Exception {
        HashMap props = new HashMap();
        ViewIndexIdRetrieveIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @Test
    public void testSelectViewIndexIdAsLong() throws Exception {
        this.testSelectViewIndexId(true);
    }

    @Test
    public void testSelectViewIndexIdAsShort() throws Exception {
        this.testSelectViewIndexId(false);
    }

    private void testSelectViewIndexId(boolean isTestingLongViewIndexId) throws Exception {
        String val = isTestingLongViewIndexId ? "true" : "false";
        int expectedDataType = isTestingLongViewIndexId ? -5 : 5;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.index.longViewIndex.enabled", val);
        String schema = ViewIndexIdRetrieveIT.generateUniqueName();
        String baseTable = ViewIndexIdRetrieveIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schema, (String)baseTable);
        String viewName = ViewIndexIdRetrieveIT.generateUniqueName();
        String viewFullName = SchemaUtil.getTableName((String)schema, (String)viewName);
        String viewIndexName = ViewIndexIdRetrieveIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(url, props);
             Statement stmt = conn.createStatement();){
            stmt.execute(String.format("CREATE TABLE %s (TENANT_ID CHAR(15) NOT NULL, ID CHAR(3) NOT NULL, NUM BIGINT CONSTRAINT PK PRIMARY KEY (TENANT_ID, ID)) MULTI_TENANT = true, COLUMN_ENCODED_BYTES=0 ", fullTableName));
            stmt.execute(String.format("CREATE VIEW %s (A BIGINT PRIMARY KEY, B BIGINT) AS SELECT * FROM %s WHERE ID='ABC'", viewFullName, fullTableName));
            stmt.execute(String.format("CREATE INDEX %s ON %s (B DESC) INCLUDE (NUM)", viewIndexName, viewFullName));
            ResultSet rs = stmt.executeQuery(String.format("SELECT VIEW_INDEX_ID,VIEW_INDEX_ID_DATA_TYPE FROM SYSTEM.CATALOG WHERE TABLE_NAME='%s' AND COLUMN_COUNT IS NOT NULL", viewIndexName));
            rs.next();
            Assert.assertEquals((long)-32768L, (long)rs.getLong(1));
            Assert.assertEquals((long)expectedDataType, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testMixedCase() throws Exception {
        ResultSet rs;
        Statement stmt;
        Properties propsForLongType = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        propsForLongType.setProperty("phoenix.index.longViewIndex.enabled", "true");
        String schema = ViewIndexIdRetrieveIT.generateUniqueName();
        String baseTable = ViewIndexIdRetrieveIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schema, (String)baseTable);
        String viewName = ViewIndexIdRetrieveIT.generateUniqueName();
        String viewFullName = SchemaUtil.getTableName((String)schema, (String)viewName);
        String viewIndexName1 = ViewIndexIdRetrieveIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(url, propsForLongType);
             Statement stmt2 = conn.createStatement();){
            stmt2.execute(String.format("CREATE TABLE %s (TENANT_ID CHAR(15) NOT NULL, ID CHAR(3) NOT NULL, NUM BIGINT CONSTRAINT PK PRIMARY KEY (TENANT_ID, ID)) MULTI_TENANT = true, COLUMN_ENCODED_BYTES=0 ", fullTableName));
            stmt2.execute(String.format("CREATE VIEW %s (A BIGINT PRIMARY KEY, B BIGINT) AS SELECT * FROM %s WHERE ID='ABC'", viewFullName, fullTableName));
            stmt2.execute(String.format("CREATE INDEX %s ON %s (B DESC) INCLUDE (NUM)", viewIndexName1, viewFullName));
            ResultSet rs2 = stmt2.executeQuery(String.format("SELECT VIEW_INDEX_ID,VIEW_INDEX_ID_DATA_TYPE FROM SYSTEM.CATALOG WHERE TABLE_NAME='%s' AND COLUMN_COUNT IS NOT NULL", viewIndexName1));
            rs2.next();
            Assert.assertEquals((long)-32768L, (long)rs2.getLong(1));
            Assert.assertEquals((long)-5L, (long)rs2.getInt(2));
            Assert.assertFalse((boolean)rs2.next());
        }
        String viewIndexName2 = ViewIndexIdRetrieveIT.generateUniqueName();
        Properties propsForShortType = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        propsForShortType.setProperty("phoenix.index.longViewIndex.enabled", "false");
        try (Connection conn = DriverManager.getConnection(url, propsForShortType);){
            stmt = conn.createStatement();
            try {
                stmt.execute(String.format("CREATE INDEX %s ON %s (B DESC) INCLUDE (NUM)", viewIndexName2, viewFullName));
                rs = stmt.executeQuery(String.format("SELECT VIEW_INDEX_ID,VIEW_INDEX_ID_DATA_TYPE FROM SYSTEM.CATALOG WHERE TABLE_NAME='%s' AND COLUMN_COUNT IS NOT NULL", viewIndexName2));
                rs.next();
                Assert.assertEquals((long)-32767L, (long)rs.getLong(1));
                Assert.assertEquals((long)5L, (long)rs.getInt(2));
                Assert.assertFalse((boolean)rs.next());
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        conn = DriverManager.getConnection(url);
        try {
            stmt = conn.createStatement();
            try {
                rs = stmt.executeQuery(String.format("SELECT * FROM SYSTEM.CATALOG", new Object[0]));
                boolean checkShort = false;
                boolean checkLong = false;
                while (rs.next()) {
                    String schemaName = rs.getString("TABLE_SCHEM");
                    long viewIndexId = rs.getLong("VIEW_INDEX_ID");
                    if (schemaName == null || !schemaName.equals(schema) || viewIndexId == 0L) continue;
                    int viewIndexIdDataType = rs.getInt("VIEW_INDEX_ID_DATA_TYPE");
                    String tableName = rs.getString("TABLE_NAME");
                    if (tableName.equals(viewIndexName1)) {
                        Assert.assertEquals((long)-32768L, (long)viewIndexId);
                        Assert.assertEquals((long)-5L, (long)viewIndexIdDataType);
                        checkLong = true;
                        continue;
                    }
                    if (!tableName.equals(viewIndexName2)) continue;
                    Assert.assertEquals((long)-32767L, (long)viewIndexId);
                    Assert.assertEquals((long)5L, (long)viewIndexIdDataType);
                    checkShort = true;
                }
                Assert.assertTrue((boolean)checkLong);
                Assert.assertTrue((boolean)checkShort);
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }
}

