/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.end2end.AlterTableIT;
import org.apache.phoenix.end2end.CreateTableIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.SplitSystemCatalogIT;
import org.apache.phoenix.end2end.ViewConcurrencyAndFailureIT;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.ReadOnlyTableException;
import org.apache.phoenix.schema.SchemaNotFoundException;
import org.apache.phoenix.schema.TableAlreadyExistsException;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.export.DefaultSchemaRegistryRepository;
import org.apache.phoenix.schema.export.DefaultSchemaWriter;
import org.apache.phoenix.schema.export.SchemaRegistryRepository;
import org.apache.phoenix.schema.export.SchemaRegistryRepositoryFactory;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.transaction.PhoenixTransactionProvider;
import org.apache.phoenix.transaction.TransactionFactory;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.apache.phoenix.util.ViewUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=Parameterized.class)
public class ViewIT
extends SplitSystemCatalogIT {
    protected String tableDDLOptions;
    protected String transactionProvider;
    protected boolean columnEncoded;

    public ViewIT(String transactionProvider, boolean columnEncoded) {
        StringBuilder optionBuilder = new StringBuilder();
        this.transactionProvider = transactionProvider;
        this.columnEncoded = columnEncoded;
        if (transactionProvider != null) {
            optionBuilder.append(" TRANSACTION_PROVIDER='").append(transactionProvider).append("'");
        }
        if (!columnEncoded) {
            if (optionBuilder.length() != 0) {
                optionBuilder.append(",");
            }
            optionBuilder.append("COLUMN_ENCODED_BYTES=0");
        }
        this.tableDDLOptions = optionBuilder.toString();
    }

    @Parameterized.Parameters(name="ViewIT_transactionProvider={0}, columnEncoded={1}")
    public static synchronized Collection<Object[]> data() {
        return Arrays.asList({"OMID", false}, {null, false}, {null, true});
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        NUM_SLAVES_BASE = 6;
        boolean splitSystemCatalog = driver == null;
        HashMap serverProps = Maps.newHashMapWithExpectedSize((int)1);
        serverProps.put("phoenix.acls.enabled", "true");
        serverProps.put("hbase.coprocessor.phoenix.classes", ViewConcurrencyAndFailureIT.TestMetaDataRegionObserver.class.getName());
        serverProps.put("hbase.coprocessor.abortonerror", "false");
        ViewIT.setUpTestDriver(new ReadOnlyProps(serverProps.entrySet().iterator()), ReadOnlyProps.EMPTY_PROPS);
        if (splitSystemCatalog) {
            ViewIT.getUtility().getHBaseCluster().getMaster().balanceSwitch(false);
            ViewIT.splitSystemCatalog();
        }
    }

    @Test
    public void testReadOnlyOnUpdatableView() throws Exception {
        String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)ViewIT.generateUniqueName());
        String fullViewName1 = SchemaUtil.getTableName((String)SCHEMA2, (String)ViewIT.generateUniqueName());
        String fullViewName2 = SchemaUtil.getTableName((String)SCHEMA3, (String)ViewIT.generateUniqueName());
        String ddl = "CREATE VIEW " + fullViewName2 + " AS SELECT * FROM " + fullViewName1 + " WHERE k3 > 1 and k3 < 50";
        ViewIT.testUpdatableView(fullTableName, fullViewName1, fullViewName2, ddl, null, this.tableDDLOptions);
        try (Connection conn = DriverManager.getConnection(ViewIT.getUrl());
             Statement stmt = conn.createStatement();){
            ResultSet rs = stmt.executeQuery("SELECT k1, k2, k3 FROM " + fullViewName2);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((long)109L, (long)rs.getInt(2));
            Assert.assertEquals((long)2L, (long)rs.getInt(3));
            Assert.assertFalse((boolean)rs.next());
            try {
                stmt.execute("UPSERT INTO " + fullViewName2 + " VALUES(1)");
                Assert.fail();
            }
            catch (ReadOnlyTableException readOnlyTableException) {
                // empty catch block
            }
            stmt.execute("UPSERT INTO " + fullTableName + "(k1, k2,k3) VALUES(1, 122, 5)");
            conn.commit();
            rs = stmt.executeQuery("SELECT k1, k2, k3 FROM " + fullViewName2 + " WHERE k2 >= 120");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((long)122L, (long)rs.getInt(2));
            Assert.assertEquals((long)5L, (long)rs.getInt(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testReadOnlyViewWithCaseSensitiveTableNames() throws Exception {
        try (Connection earlierCon = DriverManager.getConnection(ViewIT.getUrl());
             Connection conn = DriverManager.getConnection(ViewIT.getUrl());
             Statement stmt = conn.createStatement();){
            String schemaName = "S_" + ViewIT.generateUniqueName();
            String caseSensitiveTableName = "\"t_" + ViewIT.generateUniqueName() + "\"";
            String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)caseSensitiveTableName);
            String caseSensitiveViewName = "\"v_" + ViewIT.generateUniqueName() + "\"";
            String ddl = "CREATE TABLE " + fullTableName + " (k INTEGER NOT NULL PRIMARY KEY, v1 DATE)" + this.tableDDLOptions;
            stmt.execute(ddl);
            ddl = "CREATE VIEW " + caseSensitiveViewName + " (v2 VARCHAR) AS SELECT * FROM " + fullTableName + " WHERE k > 5";
            stmt.execute(ddl);
            try {
                stmt.execute("UPSERT INTO " + caseSensitiveViewName + " VALUES(1)");
                Assert.fail();
            }
            catch (ReadOnlyTableException readOnlyTableException) {
                // empty catch block
            }
            for (int i = 0; i < 10; ++i) {
                stmt.execute("UPSERT INTO " + fullTableName + " VALUES(" + i + ")");
            }
            conn.commit();
            int count = 0;
            ResultSet rs = conn.createStatement().executeQuery("SELECT k FROM " + caseSensitiveViewName);
            while (rs.next()) {
                Assert.assertEquals((long)(++count + 5), (long)rs.getInt(1));
            }
            Assert.assertEquals((long)4L, (long)count);
            count = 0;
            try (Statement earlierStmt = earlierCon.createStatement();){
                rs = earlierStmt.executeQuery("SELECT k FROM " + caseSensitiveViewName);
                while (rs.next()) {
                    Assert.assertEquals((long)(++count + 5), (long)rs.getInt(1));
                }
                Assert.assertEquals((long)4L, (long)count);
            }
        }
    }

    @Test
    public void testReadOnlyViewWithCaseSensitiveColumnNames() throws Exception {
        try (Connection conn = DriverManager.getConnection(ViewIT.getUrl());
             Statement stmt = conn.createStatement();){
            String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)ViewIT.generateUniqueName());
            String viewName = SchemaUtil.getTableName((String)SCHEMA2, (String)ViewIT.generateUniqueName());
            String ddl = "CREATE TABLE " + fullTableName + " (\"k\" INTEGER NOT NULL PRIMARY KEY, \"v1\" INTEGER, \"a\".v2 VARCHAR)" + this.tableDDLOptions;
            stmt.execute(ddl);
            ddl = "CREATE VIEW " + viewName + " (v VARCHAR) AS SELECT * FROM " + fullTableName + " WHERE \"k\" > 5 and \"v1\" > 1";
            stmt.execute(ddl);
            try {
                stmt.execute("UPSERT INTO " + viewName + " VALUES(1)");
                Assert.fail();
            }
            catch (ReadOnlyTableException readOnlyTableException) {
                // empty catch block
            }
            for (int i = 0; i < 10; ++i) {
                stmt.execute("UPSERT INTO " + fullTableName + " VALUES(" + i + ", " + (i + 10) + ",'A')");
            }
            conn.commit();
            int count = 0;
            ResultSet rs = stmt.executeQuery("SELECT \"k\", \"v1\",\"a\".v2 FROM " + viewName);
            while (rs.next()) {
                Assert.assertEquals((long)(++count + 5), (long)rs.getInt(1));
            }
            Assert.assertEquals((long)4L, (long)count);
        }
    }

    @Test
    public void testCreateMappedViewWithHbaseNamespace() throws Exception {
        Properties props = new Properties();
        props.setProperty("phoenix.schema.isNamespaceMappingEnabled", Boolean.TRUE.toString());
        Connection conn1 = DriverManager.getConnection(ViewIT.getUrl(), props);
        conn1.setAutoCommit(true);
        HBaseTestingUtility testUtil = ViewIT.getUtility();
        Admin admin = testUtil.getAdmin();
        String nameSpace = ViewIT.generateUniqueName();
        admin.createNamespace(NamespaceDescriptor.create((String)nameSpace).build());
        String tableNameStr = ViewIT.generateUniqueName();
        TableName tableName = TableName.valueOf((String)nameSpace, (String)tableNameStr);
        String familyNameStr = "colFam1";
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)familyNameStr));
        admin.createTable(builder.build());
        String viewName = SchemaUtil.getTableName((String)nameSpace, (String)tableNameStr);
        try {
            conn1.createStatement().execute("CREATE VIEW " + viewName + " (pk VARCHAR PRIMARY KEY, \"colFam1\".\"lastname\" VARCHAR )");
        }
        catch (SchemaNotFoundException e) {
            Assert.assertEquals((Object)nameSpace, (Object)e.getSchemaName());
            Assert.assertEquals((Object)("ERROR 722 (43M05): Schema does not exist schemaName=" + nameSpace), (Object)e.getMessage());
        }
        conn1.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + nameSpace);
        conn1.createStatement().execute("CREATE VIEW " + viewName + " (pk VARCHAR PRIMARY KEY, \"colFam1\".\"lastname\" VARCHAR )");
    }

    @Test
    public void testViewWithCurrentDate() throws Exception {
        try (Connection conn = DriverManager.getConnection(ViewIT.getUrl());
             Statement stmt = conn.createStatement();){
            String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)ViewIT.generateUniqueName());
            String viewName = SchemaUtil.getTableName((String)SCHEMA2, (String)ViewIT.generateUniqueName());
            String ddl = "CREATE TABLE " + fullTableName + " (k INTEGER NOT NULL PRIMARY KEY, v1 INTEGER, v2 DATE)" + this.tableDDLOptions;
            stmt.execute(ddl);
            ddl = "CREATE VIEW " + viewName + " (v VARCHAR) AS SELECT * FROM " + fullTableName + " WHERE v2 > CURRENT_DATE()-5 AND v2 > DATE '2010-01-01'";
            stmt.execute(ddl);
            try {
                stmt.execute("UPSERT INTO " + viewName + " VALUES(1)");
                Assert.fail();
            }
            catch (ReadOnlyTableException readOnlyTableException) {
                // empty catch block
            }
            for (int i = 0; i < 10; ++i) {
                stmt.execute("UPSERT INTO " + fullTableName + " VALUES(" + i + ", " + (i + 10) + ",CURRENT_DATE()-" + i + ")");
            }
            conn.commit();
            int count = 0;
            ResultSet rs = stmt.executeQuery("SELECT k FROM " + viewName);
            while (rs.next()) {
                Assert.assertEquals((long)count, (long)rs.getInt(1));
                ++count;
            }
            Assert.assertEquals((long)5L, (long)count);
        }
    }

    @Test
    public void testViewUsesTableGlobalIndex() throws Exception {
        this.testViewUsesTableIndex(false);
    }

    @Test
    public void testViewUsesTableLocalIndex() throws Exception {
        if (this.transactionProvider == null || !TransactionFactory.getTransactionProvider((TransactionFactory.Provider)TransactionFactory.Provider.valueOf((String)this.transactionProvider)).isUnsupported(PhoenixTransactionProvider.Feature.ALLOW_LOCAL_INDEX)) {
            this.testViewUsesTableIndex(true);
        }
    }

    @Test
    public void testCreateViewSchemaVersion() throws Exception {
        Properties props = new Properties();
        String schemaName = ViewIT.generateUniqueName();
        String tableName = ViewIT.generateUniqueName();
        String viewName = ViewIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String viewFullName = SchemaUtil.getTableName((String)schemaName, (String)viewName);
        try (Connection conn = DriverManager.getConnection(ViewIT.getUrl(), props);){
            String version = "V1.0";
            String topicName = "MyTopicName";
            CreateTableIT.testCreateTableSchemaVersionAndTopicNameHelper(conn, schemaName, tableName, version, topicName);
            String createViewSql = "CREATE VIEW " + viewFullName + " AS SELECT * FROM " + dataTableFullName + " SCHEMA_VERSION='" + version + "', STREAMING_TOPIC_NAME='" + topicName + "'";
            conn.createStatement().execute(createViewSql);
            PTable view = conn.unwrap(PhoenixConnection.class).getTableNoCache(viewFullName);
            Assert.assertEquals((Object)version, (Object)view.getSchemaVersion());
            Assert.assertEquals((Object)topicName, (Object)view.getStreamingTopicName());
        }
    }

    @Test
    public void testCreateViewsWithChangeDetectionEnabled() throws Exception {
        String tenantId = "T_" + ViewIT.generateUniqueName();
        String schemaName = "S_" + ViewIT.generateUniqueName();
        String tableName = "T_" + ViewIT.generateUniqueName();
        String globalViewName = "GV_" + ViewIT.generateUniqueName();
        String tenantViewName = "TV_" + ViewIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String fullGlobalViewName = SchemaUtil.getTableName((String)schemaName, (String)globalViewName);
        String fullTenantViewName = SchemaUtil.getTableName((String)schemaName, (String)tenantViewName);
        PTable globalView = null;
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(ViewIT.getUrl());){
            String ddl = "CREATE TABLE " + fullTableName + " (id char(1) NOT NULL, col1 integer NOT NULL, col2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (id, col1, col2)) MULTI_TENANT=true, CHANGE_DETECTION_ENABLED=true";
            conn.createStatement().execute(ddl);
            PTable table = conn.getTableNoCache(fullTableName);
            Assert.assertTrue((boolean)table.isChangeDetectionEnabled());
            AlterTableIT.verifySchemaExport(table, ViewIT.getUtility().getConfiguration());
            String globalViewDdl = "CREATE VIEW " + fullGlobalViewName + " (id2 CHAR(12) PRIMARY KEY, col3 BIGINT NULL)  AS SELECT * FROM " + fullTableName + " CHANGE_DETECTION_ENABLED=true";
            conn.createStatement().execute(globalViewDdl);
            globalView = conn.getTableNoCache(fullGlobalViewName);
            Assert.assertTrue((boolean)globalView.isChangeDetectionEnabled());
            PTable globalViewWithParents = ViewUtil.addDerivedColumnsFromParent((PhoenixConnection)conn, (PTable)globalView, (PTable)table);
            PTableImpl.Builder builder = PTableImpl.builderFromExisting((PTable)globalViewWithParents);
            builder.setBaseColumnCount(table.getColumns().size());
            globalViewWithParents = builder.setColumns((Collection)globalViewWithParents.getColumns()).build();
            AlterTableIT.verifySchemaExport(globalViewWithParents, ViewIT.getUtility().getConfiguration());
        }
        Properties props = new Properties();
        props.setProperty("TenantId", tenantId);
        try (PhoenixConnection tenantConn = (PhoenixConnection)DriverManager.getConnection(ViewIT.getUrl(), props);){
            String tenantViewDdl = "CREATE VIEW " + fullTenantViewName + " (id3 VARCHAR PRIMARY KEY, col4 VARCHAR NULL)  AS SELECT * FROM " + fullGlobalViewName + " CHANGE_DETECTION_ENABLED=true";
            tenantConn.createStatement().execute(tenantViewDdl);
            PTable tenantView = tenantConn.getTableNoCache(fullTenantViewName);
            Assert.assertTrue((boolean)tenantView.isChangeDetectionEnabled());
            PTable tenantViewWithParents = ViewUtil.addDerivedColumnsFromParent((PhoenixConnection)tenantConn, (PTable)tenantView, (PTable)globalView);
            AlterTableIT.verifySchemaExport(tenantViewWithParents, ViewIT.getUtility().getConfiguration());
        }
    }

    @Test
    public void testCreateViewTimestamp() throws Exception {
        String tenantId = null;
        this.createViewTimestampHelper(tenantId);
    }

    @Test
    public void testCreateTenantViewTimestamp() throws Exception {
        this.createViewTimestampHelper(TENANT1);
    }

    private void createViewTimestampHelper(String tenantId) throws SQLException {
        Properties props = new Properties();
        if (tenantId != null) {
            props.setProperty("TenantId", tenantId);
        }
        String schemaName = "S_" + ViewIT.generateUniqueName();
        String tableName = "T_" + ViewIT.generateUniqueName();
        String viewName = "V_" + ViewIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String viewFullName = SchemaUtil.getTableName((String)schemaName, (String)viewName);
        String tableDDL = "CREATE TABLE " + dataTableFullName + " (\nID1 VARCHAR(15) NOT NULL,\nID2 VARCHAR(15) NOT NULL,\nCREATED_DATE DATE,\nCREATION_TIME BIGINT,\nLAST_USED DATE,\nCONSTRAINT PK PRIMARY KEY (ID1, ID2)) ";
        String viewDDL = "CREATE VIEW " + viewFullName + " AS SELECT * FROM " + dataTableFullName;
        long startTS = EnvironmentEdgeManager.currentTimeMillis();
        try (Connection conn = DriverManager.getConnection(ViewIT.getUrl());){
            conn.createStatement().execute(tableDDL);
        }
        conn = DriverManager.getConnection(ViewIT.getUrl(), props);
        try {
            conn.createStatement().execute(viewDDL);
            CreateTableIT.verifyLastDDLTimestamp(viewFullName, startTS, conn);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Test
    public void testCreateChangeDetectionEnabledTable() throws Exception {
        String schemaName = ViewIT.generateUniqueName();
        String tableName = ViewIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String viewName = ViewIT.generateUniqueName();
        String fullViewName = SchemaUtil.getTableName((String)schemaName, (String)viewName);
        try (Connection conn = DriverManager.getConnection(ViewIT.getUrl());){
            String ddl = "CREATE TABLE " + fullTableName + " (id char(1) NOT NULL, col1 integer NOT NULL, col2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (id, col1, col2)) CHANGE_DETECTION_ENABLED=true";
            conn.createStatement().execute(ddl);
            String viewDdl = "CREATE VIEW " + fullViewName + " AS SELECT * FROM " + fullTableName + " CHANGE_DETECTION_ENABLED=true";
            conn.createStatement().execute(viewDdl);
            PTable view = conn.unwrap(PhoenixConnection.class).getTableNoCache(fullViewName);
            Assert.assertTrue((boolean)view.isChangeDetectionEnabled());
            Assert.assertEquals((Object)DefaultSchemaRegistryRepository.getSchemaId((PTable)view), (Object)view.getExternalSchemaId());
            String schemaText = new DefaultSchemaWriter().exportSchema(view);
            SchemaRegistryRepository schemaRegistryRepository = SchemaRegistryRepositoryFactory.getSchemaRegistryRepository((Configuration)ViewIT.getUtility().getConfiguration());
        }
    }

    private void testViewUsesTableIndex(boolean localIndex) throws Exception {
        String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)ViewIT.generateUniqueName()) + (localIndex ? "_WITH_LI" : "_WITHOUT_LI");
        try (Connection conn = DriverManager.getConnection(ViewIT.getUrl());
             Statement stmt = conn.createStatement();){
            String ddl = "CREATE TABLE " + fullTableName + " (k1 INTEGER NOT NULL, k2 INTEGER NOT NULL, k3 DECIMAL, s1 VARCHAR, s2 VARCHAR CONSTRAINT pk PRIMARY KEY (k1, k2, k3))" + this.tableDDLOptions;
            stmt.execute(ddl);
            String indexName1 = "I_" + ViewIT.generateUniqueName();
            String fullIndexName1 = SchemaUtil.getTableName((String)SCHEMA1, (String)indexName1);
            stmt.execute("CREATE " + (localIndex ? "LOCAL " : "") + " INDEX " + indexName1 + " ON " + fullTableName + "(k3, k2) INCLUDE(s1, s2)");
            String indexName2 = "I_" + ViewIT.generateUniqueName();
            stmt.execute("CREATE INDEX " + indexName2 + " ON " + fullTableName + "(k3, k2, s2)");
            String fullViewName = SchemaUtil.getTableName((String)SCHEMA2, (String)ViewIT.generateUniqueName());
            ddl = "CREATE VIEW " + fullViewName + " AS SELECT * FROM " + fullTableName + " WHERE s1 = 'foo'";
            stmt.execute(ddl);
            String[] s1Values = new String[]{"foo", "bar"};
            for (int i = 0; i < 10; ++i) {
                stmt.execute("UPSERT INTO " + fullTableName + " VALUES(" + i % 4 + "," + (i + 100) + "," + (i > 5 ? 2 : 1) + ",'" + s1Values[i % 2] + "','bas')");
            }
            conn.commit();
            ResultSet rs = stmt.executeQuery("SELECT count(*) FROM " + fullViewName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)5L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
            String viewIndexName = "I_" + ViewIT.generateUniqueName();
            stmt.execute("CREATE INDEX " + viewIndexName + " on " + fullViewName + "(k2)");
            String query = "SELECT k2 FROM " + fullViewName + " WHERE k2 IN (100,109) AND k3 IN (1,2) AND s2='bas'";
            rs = stmt.executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)100L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            ExplainPlan plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"SKIP SCAN ON 4 KEYS ", (Object)explainPlanAttributes.getExplainScanType());
            Assert.assertEquals((Object)"SERVER FILTER BY (\"S2\" = 'bas' AND \"S1\" = 'foo')", (Object)explainPlanAttributes.getServerWhereFilter());
            if (localIndex) {
                Assert.assertEquals((Object)(fullIndexName1 + "(" + fullTableName + ")"), (Object)explainPlanAttributes.getTableName());
                Assert.assertEquals((Object)" [1,1,100] - [1,2,109]", (Object)explainPlanAttributes.getKeyRanges());
                Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
            } else {
                Assert.assertEquals((Object)fullIndexName1, (Object)explainPlanAttributes.getTableName());
                Assert.assertEquals((Object)" [1,100] - [2,109]", (Object)explainPlanAttributes.getKeyRanges());
                Assert.assertNull((Object)explainPlanAttributes.getClientSortAlgo());
            }
        }
    }

    @Test
    public void testCreateChildViewWithBaseTableLocalIndex() throws Exception {
        this.testCreateChildViewWithBaseTableIndex(true);
    }

    @Test
    public void testCreateChildViewWithBaseTableGlobalIndex() throws Exception {
        this.testCreateChildViewWithBaseTableIndex(false);
    }

    public void testCreateChildViewWithBaseTableIndex(boolean localIndex) throws Exception {
        String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)ViewIT.generateUniqueName());
        String fullViewName = SchemaUtil.getTableName((String)SCHEMA2, (String)ViewIT.generateUniqueName());
        String indexName = "I_" + ViewIT.generateUniqueName();
        String fullChildViewName = SchemaUtil.getTableName((String)SCHEMA2, (String)ViewIT.generateUniqueName());
        try (Connection conn = DriverManager.getConnection(ViewIT.getUrl());
             Statement stmt = conn.createStatement();){
            String sql = "CREATE TABLE " + fullTableName + " (ID INTEGER NOT NULL PRIMARY KEY, HOST VARCHAR(10), FLAG BOOLEAN)";
            stmt.execute(sql);
            sql = "CREATE VIEW " + fullViewName + " (COL1 INTEGER, COL2 INTEGER, COL3 INTEGER, COL4 INTEGER) AS SELECT * FROM " + fullTableName + " WHERE ID > 5";
            stmt.execute(sql);
            sql = "CREATE " + (localIndex ? "LOCAL " : "") + " INDEX " + indexName + " ON " + fullTableName + "(HOST)";
            stmt.execute(sql);
            sql = "CREATE VIEW " + fullChildViewName + " AS SELECT * FROM " + fullViewName + " WHERE COL1 > 2";
            stmt.execute(sql);
            stmt.executeUpdate("upsert into " + fullTableName + " values (1, 'host1', TRUE)");
            stmt.executeUpdate("upsert into " + fullTableName + " values (5, 'host5', FALSE)");
            stmt.executeUpdate("upsert into " + fullTableName + " values (7, 'host7', TRUE)");
            conn.commit();
            try {
                stmt.executeUpdate("upsert into " + fullViewName + " (ID, HOST, FLAG, COL1) values (7, 'host7', TRUE, 1)");
                Assert.fail();
            }
            catch (Exception exception) {
                // empty catch block
            }
            PTable table = conn.unwrap(PhoenixConnection.class).getTable(fullViewName);
            Assert.assertEquals((long)1L, (long)table.getIndexes().size());
            table = conn.unwrap(PhoenixConnection.class).getTable(fullChildViewName);
            Assert.assertEquals((long)0L, (long)table.getIndexes().size());
            ResultSet rs = stmt.executeQuery("select count(*) from " + fullTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*) from " + fullViewName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
        }
    }

    @Test
    public void testCreateViewDefinesPKColumn() throws Exception {
        try (Connection conn = DriverManager.getConnection(ViewIT.getUrl());
             Statement stmt = conn.createStatement();){
            String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)ViewIT.generateUniqueName());
            String fullViewName = SchemaUtil.getTableName((String)SCHEMA2, (String)ViewIT.generateUniqueName());
            String ddl = "CREATE TABLE " + fullTableName + " (k1 INTEGER NOT NULL, k2 INTEGER NOT NULL, v1 DECIMAL, CONSTRAINT pk PRIMARY KEY (k1, k2))" + this.tableDDLOptions;
            stmt.execute(ddl);
            ddl = "CREATE VIEW " + fullViewName + "(v2 VARCHAR, k3 VARCHAR PRIMARY KEY) AS SELECT * FROM " + fullTableName + " WHERE K1 = 1";
            stmt.execute(ddl);
            ResultSet rs = conn.getMetaData().getPrimaryKeys(null, SchemaUtil.getSchemaNameFromFullName((String)fullViewName), SchemaUtil.getTableNameFromFullName((String)fullViewName));
            this.assertPKs(rs, new String[]{"K1", "K2", "K3"});
            stmt.executeUpdate("upsert into " + fullTableName + " (k1, k2, v1) values (1, 1, 1)");
            stmt.executeUpdate("upsert into " + fullViewName + " (k1, k2, k3, v2) values (1, 1, 'abc', 'def')");
            conn.commit();
            rs = stmt.executeQuery("select count(*) from " + fullTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*) from " + fullViewName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
        }
    }

    @Test
    public void testQueryViewStatementOptimization() throws Exception {
        try (Connection conn = DriverManager.getConnection(ViewIT.getUrl());){
            QueryPlan plan;
            String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)ViewIT.generateUniqueName());
            String fullViewName1 = SchemaUtil.getTableName((String)SCHEMA2, (String)ViewIT.generateUniqueName());
            String fullViewName2 = SchemaUtil.getTableName((String)SCHEMA3, (String)ViewIT.generateUniqueName());
            String sql = "CREATE TABLE " + fullTableName + " (k1 INTEGER NOT NULL, k2 INTEGER NOT NULL, v1 DECIMAL, CONSTRAINT pk PRIMARY KEY (k1, k2))" + this.tableDDLOptions;
            try (Statement stmt = conn.createStatement();){
                stmt.execute(sql);
                sql = "CREATE VIEW " + fullViewName1 + "  AS SELECT * FROM " + fullTableName;
                stmt.execute(sql);
                sql = "CREATE VIEW " + fullViewName2 + "  AS SELECT * FROM " + fullTableName + " WHERE k1 = 1.0";
                stmt.execute(sql);
            }
            sql = "SELECT * FROM " + fullViewName1 + " order by k1, k2";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                plan = PhoenixRuntime.getOptimizedQueryPlan((PreparedStatement)stmt);
                Assert.assertEquals((long)0L, (long)plan.getOrderBy().getOrderByExpressions().size());
            }
            sql = "SELECT * FROM " + fullViewName2 + " order by k1, k2";
            stmt = conn.prepareStatement(sql);
            try {
                plan = PhoenixRuntime.getOptimizedQueryPlan((PreparedStatement)stmt);
                Assert.assertEquals((long)0L, (long)plan.getOrderBy().getOrderByExpressions().size());
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    private void assertPKs(ResultSet rs, String[] expectedPKs) throws SQLException {
        ArrayList pkCols = Lists.newArrayListWithExpectedSize((int)expectedPKs.length);
        while (rs.next()) {
            pkCols.add(rs.getString("COLUMN_NAME"));
        }
        Object[] actualPKs = pkCols.toArray(new String[0]);
        Assert.assertArrayEquals((Object[])expectedPKs, (Object[])actualPKs);
    }

    @Test
    public void testCompositeDescPK() throws Exception {
        Properties props = new Properties();
        try (Connection globalConn = DriverManager.getConnection(ViewIT.getUrl(), props);){
            String tableName = SchemaUtil.getTableName((String)SCHEMA1, (String)ViewIT.generateUniqueName());
            String viewName1 = SchemaUtil.getTableName((String)SCHEMA2, (String)ViewIT.generateUniqueName());
            String viewName2 = SchemaUtil.getTableName((String)SCHEMA3, (String)ViewIT.generateUniqueName());
            String viewName3 = SchemaUtil.getTableName((String)SCHEMA1, (String)ViewIT.generateUniqueName());
            String viewName4 = SchemaUtil.getTableName((String)SCHEMA2, (String)ViewIT.generateUniqueName());
            Object myTableDDLOptions = this.tableDDLOptions;
            if (((String)myTableDDLOptions).length() != 0) {
                myTableDDLOptions = (String)myTableDDLOptions + ",";
            }
            myTableDDLOptions = (String)myTableDDLOptions + "VERSIONS=1, MULTI_TENANT=true, IMMUTABLE_ROWS=TRUE, REPLICATION_SCOPE=1";
            try (Statement stmt = globalConn.createStatement();){
                stmt.execute("CREATE TABLE " + tableName + " (TENANT_ID CHAR(15) NOT NULL, KEY_PREFIX CHAR(3) NOT NULL, CREATED_DATE DATE, CREATED_BY CHAR(15), SYSTEM_MODSTAMP DATE CONSTRAINT PK PRIMARY KEY (TENANT_ID, KEY_PREFIX)) " + (String)myTableDDLOptions);
            }
            String tenantId = "tenantId";
            Properties tenantProps = new Properties();
            tenantProps.setProperty("TenantId", tenantId);
            try (Connection tenantConn = DriverManager.getConnection(ViewIT.getUrl(), tenantProps);
                 Statement tenantStmt = tenantConn.createStatement();){
                tenantStmt.execute("CREATE VIEW " + viewName1 + " (pk1 VARCHAR(10) NOT NULL, pk2 VARCHAR(10) NOT NULL, col1 DATE, col3 DECIMAL CONSTRAINT PK PRIMARY KEY (pk1 DESC, pk2 DESC)) AS SELECT * FROM " + tableName + " WHERE KEY_PREFIX = 'abc' ");
                tenantStmt.execute("CREATE VIEW " + viewName2 + " (pk1 VARCHAR(10) NOT NULL, pk2 VARCHAR(10) NOT NULL, col1 DATE, col3 DECIMAL CONSTRAINT PK PRIMARY KEY (pk1 DESC, pk2 DESC)) AS SELECT * FROM " + tableName + " WHERE KEY_PREFIX = 'abc' ");
                tenantStmt.execute("CREATE VIEW " + viewName3 + " (pk1 DATE(10) NOT NULL, pk2 DATE(10) NOT NULL, col1 VARCHAR(10), col3 DECIMAL CONSTRAINT PK PRIMARY KEY (pk1 DESC, pk2 DESC)) AS SELECT * FROM " + tableName + " WHERE KEY_PREFIX = 'ab3' ");
                tenantStmt.execute("CREATE VIEW " + viewName4 + " (pk1 DATE(10) NOT NULL, pk2 DECIMAL NOT NULL, pk3 VARCHAR(10) NOT NULL, col3 DECIMAL CONSTRAINT PK PRIMARY KEY (pk1 DESC, pk2 DESC, pk3 DESC)) AS SELECT * FROM " + tableName + " WHERE KEY_PREFIX = 'ab4' ");
                this.upsertRows(viewName1, tenantConn);
                this.upsertRows(viewName2, tenantConn);
                String[] whereClauses = new String[]{"pk1 = 'testa'", "", "pk1 >= 'testa'", "pk1 <= 'testa'", "pk1 > 'testa'", "pk1 < 'testa'"};
                long[] expectedArray = new long[]{4L, 5L, 5L, 4L, 1L, 0L};
                this.validate(viewName1, tenantConn, whereClauses, expectedArray);
                this.validate(viewName2, tenantConn, whereClauses, expectedArray);
                tenantStmt.execute("UPSERT INTO " + viewName3 + " (pk1, pk2, col1, col3) VALUES (TO_DATE('2017-10-16 22:00:00', 'yyyy-MM-dd HH:mm:ss'), TO_DATE('2017-10-16 21:00:00', 'yyyy-MM-dd HH:mm:ss'), 'txt1', 10)");
                tenantStmt.execute("UPSERT INTO " + viewName3 + " (pk1, pk2, col1, col3) VALUES (TO_DATE('2017-10-16 22:00:00', 'yyyy-MM-dd HH:mm:ss'), TO_DATE('2017-10-16 21:01:00', 'yyyy-MM-dd HH:mm:ss'), 'txt1', 10)");
                tenantStmt.execute("UPSERT INTO " + viewName3 + " (pk1, pk2, col1, col3) VALUES (TO_DATE('2017-10-16 22:00:00', 'yyyy-MM-dd HH:mm:ss'), TO_DATE('2017-10-16 21:02:00', 'yyyy-MM-dd HH:mm:ss'), 'txt1', 10)");
                tenantStmt.execute("UPSERT INTO " + viewName3 + " (pk1, pk2, col1, col3) VALUES (TO_DATE('2017-10-16 22:00:00', 'yyyy-MM-dd HH:mm:ss'), TO_DATE('2017-10-16 21:03:00', 'yyyy-MM-dd HH:mm:ss'), 'txt1', 10)");
                tenantStmt.execute("UPSERT INTO " + viewName3 + " (pk1, pk2, col1, col3) VALUES (TO_DATE('2017-10-16 23:00:00', 'yyyy-MM-dd HH:mm:ss'), TO_DATE('2017-10-16 21:04:00', 'yyyy-MM-dd HH:mm:ss'), 'txt1', 10)");
                tenantConn.commit();
                String[] view3WhereClauses = new String[]{"pk1 = TO_DATE('2017-10-16 22:00:00', 'yyyy-MM-dd HH:mm:ss')", "", "pk1 >= TO_DATE('2017-10-16 22:00:00', 'yyyy-MM-dd HH:mm:ss')", "pk1 <= TO_DATE('2017-10-16 22:00:00', 'yyyy-MM-dd HH:mm:ss')", "pk1 > TO_DATE('2017-10-16 22:00:00', 'yyyy-MM-dd HH:mm:ss')", "pk1 < TO_DATE('2017-10-16 22:00:00', 'yyyy-MM-dd HH:mm:ss')"};
                this.validate(viewName3, tenantConn, view3WhereClauses, expectedArray);
                tenantStmt.execute("UPSERT INTO " + viewName4 + " (pk1, pk2, pk3, col3) VALUES (TO_DATE('2017-10-16 22:00:00', 'yyyy-MM-dd HH:mm:ss'), 1, 'txt1', 10)");
                tenantStmt.execute("UPSERT INTO " + viewName4 + " (pk1, pk2, pk3, col3) VALUES (TO_DATE('2017-10-16 22:00:00', 'yyyy-MM-dd HH:mm:ss'), 2, 'txt2', 10)");
                tenantStmt.execute("UPSERT INTO " + viewName4 + " (pk1, pk2, pk3, col3) VALUES (TO_DATE('2017-10-16 22:00:00', 'yyyy-MM-dd HH:mm:ss'), 3, 'txt3', 10)");
                tenantStmt.execute("UPSERT INTO " + viewName4 + " (pk1, pk2, pk3, col3) VALUES (TO_DATE('2017-10-16 22:00:00', 'yyyy-MM-dd HH:mm:ss'), 4, 'txt4', 10)");
                tenantStmt.execute("UPSERT INTO " + viewName4 + " (pk1, pk2, pk3, col3) VALUES (TO_DATE('2017-10-16 23:00:00', 'yyyy-MM-dd HH:mm:ss'), 1, 'txt1', 10)");
                tenantConn.commit();
                String[] view4WhereClauses = new String[]{"pk1 = TO_DATE('2017-10-16 22:00:00', 'yyyy-MM-dd HH:mm:ss')", "pk1 = TO_DATE('2017-10-16 22:00:00', 'yyyy-MM-dd HH:mm:ss') AND pk2 = 2", "pk1 = TO_DATE('2017-10-16 22:00:00', 'yyyy-MM-dd HH:mm:ss') AND pk2 > 2", "", "pk1 >= TO_DATE('2017-10-16 22:00:00', 'yyyy-MM-dd HH:mm:ss')", "pk1 <= TO_DATE('2017-10-16 22:00:00', 'yyyy-MM-dd HH:mm:ss')", "pk1 > TO_DATE('2017-10-16 22:00:00', 'yyyy-MM-dd HH:mm:ss')", "pk1 < TO_DATE('2017-10-16 22:00:00', 'yyyy-MM-dd HH:mm:ss')"};
                long[] view4ExpectedArray = new long[]{4L, 1L, 2L, 5L, 5L, 4L, 1L, 0L};
                this.validate(viewName4, tenantConn, view4WhereClauses, view4ExpectedArray);
            }
        }
    }

    @Test
    public void testCreateViewWithUndefinedSameColumnName() throws Exception {
        String fullViewName = ViewIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(ViewIT.getUrl());
             Statement stmt = conn.createStatement();){
            String ddl = "CREATE VIEW " + fullViewName + " AS SELECT * FROM " + fullViewName + " WHERE " + fullViewName + " = 1";
            stmt.execute(ddl);
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (ColumnNotFoundException columnException) {
            Assert.assertEquals((String)"Undefined column", (long)SQLExceptionCode.COLUMN_NOT_FOUND.getErrorCode(), (long)columnException.getErrorCode());
            Assert.assertEquals((Object)fullViewName, (Object)columnException.getColumnName());
        }
    }

    @Test
    public void testCreateViewOnTopOfUndefinedTableWithSameName() throws Exception {
        try (Connection conn = DriverManager.getConnection(ViewIT.getUrl());
             Statement stmt = conn.createStatement();){
            String fullViewName = ViewIT.generateUniqueName();
            String ddl = "CREATE VIEW " + fullViewName + " AS SELECT * FROM " + fullViewName;
            stmt.execute(ddl);
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (TableNotFoundException tableException) {
            Assert.assertEquals((String)"Table Undefined", (long)SQLExceptionCode.TABLE_UNDEFINED.getErrorCode(), (long)tableException.getErrorCode());
        }
    }

    @Test
    public void testCreateViewOnTopOfTableWithSameName() throws Exception {
        try (Connection conn = DriverManager.getConnection(ViewIT.getUrl());
             Statement stmt = conn.createStatement();){
            String fullTableName = ViewIT.generateUniqueName();
            String ddl = "CREATE TABLE " + fullTableName + " (k1 INTEGER NOT NULL, k2 INTEGER NOT NULL, v1 DECIMAL, CONSTRAINT pk PRIMARY KEY (k1, k2))" + this.tableDDLOptions;
            stmt.execute(ddl);
            ddl = "CREATE VIEW " + fullTableName + "(v2 VARCHAR, k3 VARCHAR PRIMARY KEY) AS SELECT * FROM " + fullTableName + " WHERE K1 = 1";
            stmt.execute(ddl);
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (TableAlreadyExistsException tableException) {
            Assert.assertEquals((String)"Table already exists", (long)SQLExceptionCode.TABLE_ALREADY_EXIST.getErrorCode(), (long)tableException.getErrorCode());
        }
    }

    private void validate(String viewName, Connection tenantConn, String[] whereClauseArray, long[] expectedArray) throws SQLException {
        for (int i = 0; i < whereClauseArray.length; ++i) {
            String where = !whereClauseArray[i].isEmpty() ? " WHERE " + whereClauseArray[i] : "";
            try (Statement stmt = tenantConn.createStatement();){
                ResultSet rs = stmt.executeQuery("SELECT count(*) FROM " + viewName + where);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)expectedArray[i], (long)rs.getLong(1));
                Assert.assertFalse((boolean)rs.next());
                continue;
            }
        }
    }

    private void upsertRows(String viewName, Connection tenantConn) throws SQLException {
        try (Statement stmt = tenantConn.createStatement();){
            stmt.execute("UPSERT INTO " + viewName + " (pk1, pk2, col1, col3) VALUES ('testa', 'testb', TO_DATE('2017-10-16 22:00:00', 'yyyy-MM-dd HH:mm:ss'), 10)");
            stmt.execute("UPSERT INTO " + viewName + " (pk1, pk2, col1, col3) VALUES ('testa', 'testc', TO_DATE('2017-10-16 22:00:00', 'yyyy-MM-dd HH:mm:ss'), 10)");
            stmt.execute("UPSERT INTO " + viewName + " (pk1, pk2, col1, col3) VALUES ('testa', 'testd', TO_DATE('2017-10-16 22:00:00', 'yyyy-MM-dd HH:mm:ss'), 10)");
            stmt.execute("UPSERT INTO " + viewName + " (pk1, pk2, col1, col3) VALUES ('testa', 'teste', TO_DATE('2017-10-16 22:00:00', 'yyyy-MM-dd HH:mm:ss'), 10)");
            stmt.execute("UPSERT INTO " + viewName + " (pk1, pk2, col1, col3) VALUES ('testb', 'testa', TO_DATE('2017-10-16 22:00:00', 'yyyy-MM-dd HH:mm:ss'), 10)");
            tenantConn.commit();
        }
    }

    public static void testUpdatableView(String fullTableName, String fullViewName, String fullChildViewName, String childViewDDL, Integer saltBuckets, String tableDDLOptions) throws Exception {
        try (Connection conn = DriverManager.getConnection(ViewIT.getUrl());
             Statement stmt = conn.createStatement();){
            if (saltBuckets != null) {
                if (((String)tableDDLOptions).length() != 0) {
                    tableDDLOptions = (String)tableDDLOptions + ",";
                }
                tableDDLOptions = (String)tableDDLOptions + " SALT_BUCKETS=" + saltBuckets;
            }
            String ddl = "CREATE TABLE " + fullTableName + " (k1 INTEGER NOT NULL, k2 INTEGER NOT NULL, k3 DECIMAL, s VARCHAR CONSTRAINT pk PRIMARY KEY (k1, k2, k3))" + (String)tableDDLOptions;
            stmt.execute(ddl);
            ddl = "CREATE VIEW " + fullViewName + " AS SELECT * FROM " + fullTableName + " WHERE k1 = 1";
            stmt.execute(ddl);
            ArrayList splitPoints = Lists.newArrayList((Object[])new String[]{fullTableName, fullViewName});
            if (fullChildViewName != null) {
                stmt.execute(childViewDDL);
                splitPoints.add(fullChildViewName);
            }
            for (int i = 0; i < 10; ++i) {
                stmt.execute("UPSERT INTO " + fullTableName + " VALUES(" + i % 4 + "," + (i + 100) + "," + (i > 5 ? 2 : 1) + ")");
            }
            conn.commit();
            ResultSet rs = stmt.executeQuery("SELECT count(*) FROM " + fullTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)10L, (long)rs.getInt(1));
            rs = stmt.executeQuery("SELECT count(*) FROM " + fullViewName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            rs = stmt.executeQuery("SELECT k1, k2, k3 FROM " + fullViewName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((long)101L, (long)rs.getInt(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((long)105L, (long)rs.getInt(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((long)109L, (long)rs.getInt(2));
            Assert.assertEquals((long)2L, (long)rs.getInt(3));
            Assert.assertFalse((boolean)rs.next());
            stmt.execute("UPSERT INTO " + fullViewName + "(k2,S,k3) VALUES(120,'foo',50.0)");
            stmt.execute("UPSERT INTO " + fullViewName + "(k2,S,k3) VALUES(121,'bar',51.0)");
            conn.commit();
            rs = stmt.executeQuery("SELECT k1, k2 FROM " + fullViewName + " WHERE k2 >= 120");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((long)120L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((long)121L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    public static Pair<String, Scan> testUpdatableViewIndex(String fullTableName, Integer saltBuckets, boolean localIndex, String viewName) throws Exception {
        try (Connection conn = DriverManager.getConnection(ViewIT.getUrl());){
            Pair pair;
            block24: {
                Statement stmt = conn.createStatement();
                try {
                    String physicalTableName;
                    String viewIndexName1 = "I_" + ViewIT.generateUniqueName();
                    String schemaName = SchemaUtil.getSchemaNameFromFullName((String)viewName);
                    String viewIndexFullName1 = SchemaUtil.getTableName((String)schemaName, (String)viewIndexName1);
                    String viewIndexPhysicalName = MetaDataUtil.getViewIndexPhysicalName((String)fullTableName);
                    if (localIndex) {
                        stmt.execute("CREATE LOCAL INDEX " + viewIndexName1 + " on " + viewName + "(k3)");
                    } else {
                        stmt.execute("CREATE INDEX " + viewIndexName1 + " on " + viewName + "(k3) include (s)");
                    }
                    stmt.execute("UPSERT INTO " + viewName + "(k2,S,k3) VALUES(120,'foo',50.0)");
                    conn.commit();
                    TestUtil.analyzeTable(conn, viewName);
                    List<KeyRange> splits = TestUtil.getAllSplits(conn, viewIndexName1);
                    Assert.assertEquals((long)(saltBuckets == null ? 6L : 8L), (long)splits.size());
                    String query = "SELECT k1, k2, k3, s FROM " + viewName + " WHERE k3 = 51.0";
                    ResultSet rs = stmt.executeQuery(query);
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((long)1L, (long)rs.getInt(1));
                    Assert.assertEquals((long)121L, (long)rs.getInt(2));
                    Assert.assertEquals((long)0L, (long)BigDecimal.valueOf(51.0).compareTo(rs.getBigDecimal(3)));
                    Assert.assertEquals((Object)"bar", (Object)rs.getString(4));
                    Assert.assertFalse((boolean)rs.next());
                    ExplainPlan plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
                    ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
                    Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
                    if (localIndex) {
                        Assert.assertEquals((Object)("PARALLEL " + (saltBuckets == null ? 1 : saltBuckets) + "-WAY"), (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
                        Assert.assertEquals((Object)(viewIndexFullName1 + "(" + fullTableName + ")"), (Object)explainPlanAttributes.getTableName());
                        Assert.assertEquals((Object)" [1,51]", (Object)explainPlanAttributes.getKeyRanges());
                        Assert.assertTrue((explainPlanAttributes.getServerWhereFilter().equals("SERVER FILTER BY FIRST KEY ONLY") || explainPlanAttributes.getServerWhereFilter().equals("SERVER FILTER BY EMPTY COLUMN ONLY") ? 1 : 0) != 0);
                        Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
                    } else {
                        Assert.assertEquals((Object)viewIndexPhysicalName, (Object)explainPlanAttributes.getTableName());
                        if (saltBuckets == null) {
                            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
                            Assert.assertEquals((Object)" [-32768,51]", (Object)explainPlanAttributes.getKeyRanges());
                            Assert.assertNull((Object)explainPlanAttributes.getClientSortAlgo());
                        } else {
                            Assert.assertEquals((Object)("PARALLEL " + saltBuckets + "-WAY"), (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
                            Assert.assertEquals((Object)(" [X'00',-32768,51] - [" + PVarbinary.INSTANCE.toStringLiteral((Object)new byte[]{(byte)(saltBuckets - 1)}) + ",-32768,51]"), (Object)explainPlanAttributes.getKeyRanges());
                            Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
                        }
                    }
                    String viewIndexName2 = "I_" + ViewIT.generateUniqueName();
                    String viewIndexFullName2 = SchemaUtil.getTableName((String)schemaName, (String)viewIndexName2);
                    if (localIndex) {
                        stmt.execute("CREATE LOCAL INDEX " + viewIndexName2 + " on " + viewName + "(s)");
                    } else {
                        stmt.execute("CREATE INDEX " + viewIndexName2 + " on " + viewName + "(s)");
                    }
                    splits = TestUtil.getAllSplits(conn, viewIndexName2);
                    Assert.assertEquals((long)(saltBuckets == null ? 1L : 3L), (long)splits.size());
                    TestUtil.analyzeTable(conn, fullTableName);
                    splits = TestUtil.getAllSplits(conn, viewIndexName2);
                    Assert.assertEquals((long)(saltBuckets == null ? 6L : 8L), (long)splits.size());
                    query = "SELECT k1, k2, s FROM " + viewName + " WHERE s = 'foo'";
                    rs = stmt.executeQuery(query);
                    Scan scan = stmt.unwrap(PhoenixStatement.class).getQueryPlan().getContext().getScan();
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((long)1L, (long)rs.getInt(1));
                    Assert.assertEquals((long)120L, (long)rs.getInt(2));
                    Assert.assertEquals((Object)"foo", (Object)rs.getString(3));
                    Assert.assertFalse((boolean)rs.next());
                    plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
                    explainPlanAttributes = plan.getPlanStepsAsAttributes();
                    Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
                    Assert.assertTrue((explainPlanAttributes.getServerWhereFilter().equals("SERVER FILTER BY FIRST KEY ONLY") || explainPlanAttributes.getServerWhereFilter().equals("SERVER FILTER BY EMPTY COLUMN ONLY") ? 1 : 0) != 0);
                    if (localIndex) {
                        physicalTableName = fullTableName;
                        Assert.assertEquals((Object)("PARALLEL " + (saltBuckets == null ? 1 : saltBuckets) + "-WAY"), (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
                        Assert.assertEquals((Object)(viewIndexFullName2 + "(" + fullTableName + ")"), (Object)explainPlanAttributes.getTableName());
                        Assert.assertEquals((Object)" [2,'foo']", (Object)explainPlanAttributes.getKeyRanges());
                    } else {
                        physicalTableName = viewIndexPhysicalName;
                        Assert.assertEquals((Object)viewIndexPhysicalName, (Object)explainPlanAttributes.getTableName());
                        if (saltBuckets == null) {
                            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
                            Assert.assertEquals((Object)" [-32767,'foo']", (Object)explainPlanAttributes.getKeyRanges());
                            Assert.assertNull((Object)explainPlanAttributes.getClientSortAlgo());
                        } else {
                            Assert.assertEquals((Object)("PARALLEL " + saltBuckets + "-WAY"), (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
                            Assert.assertEquals((Object)(" [X'00',-32767,'foo'] - [" + PVarbinary.INSTANCE.toStringLiteral((Object)new byte[]{(byte)(saltBuckets - 1)}) + ",-32767,'foo']"), (Object)explainPlanAttributes.getKeyRanges());
                            Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
                        }
                    }
                    pair = new Pair((Object)physicalTableName, (Object)scan);
                    if (stmt == null) break block24;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return pair;
        }
    }

    @Test
    public void testDisallowCreatingViewsOnSystemTable() throws SQLException {
        try (Connection conn = DriverManager.getConnection(ViewIT.getUrl());){
            String viewDDL = "CREATE VIEW " + ViewIT.generateUniqueName() + " AS SELECT * FROM SYSTEM.CATALOG";
            try (Statement stmt = conn.createStatement();){
                stmt.execute(viewDDL);
                Assert.fail((String)"Should have thrown an exception");
            }
            catch (SQLException sqlE) {
                Assert.assertEquals((String)"Expected a different Error code", (long)SQLExceptionCode.CANNOT_CREATE_VIEWS_ON_SYSTEM_TABLES.getErrorCode(), (long)sqlE.getErrorCode());
            }
        }
    }
}

