/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ParallelStatsDisabledTest.class})
public class ViewExtendsPkRestrictionsIT
extends ParallelStatsDisabledIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(ViewExtendsPkRestrictionsIT.class);
    private static final String TENANT_ID = "tenant_01";

    private Connection getTenantConnection(String tenantId) throws Exception {
        Properties tenantProps = new Properties();
        tenantProps.setProperty("TenantId", tenantId);
        return DriverManager.getConnection(ViewExtendsPkRestrictionsIT.getUrl(), tenantProps);
    }

    private Connection getTenantConnection(String tenantId, boolean disableCreateIndexCheck) throws Exception {
        Properties tenantProps = new Properties();
        tenantProps.setProperty("TenantId", tenantId);
        tenantProps.setProperty("phoenix.disable.view.subtree.validation", Boolean.toString(disableCreateIndexCheck));
        return DriverManager.getConnection(ViewExtendsPkRestrictionsIT.getUrl(), tenantProps);
    }

    @Test
    public void testViewExtendsPkWithParentTableIndex1() {
        String tableName = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String indexName = "idx_" + tableName;
        String view01 = "v01_" + tableName;
        boolean allStmtExecuted = false;
        try (Connection conn = DriverManager.getConnection(ViewExtendsPkRestrictionsIT.getUrl());){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + tableName + " (COL1 CHAR(10) NOT NULL, COL2 CHAR(5) NOT NULL, COL3 VARCHAR, COL4 VARCHAR CONSTRAINT pk PRIMARY KEY(COL1, COL2))");
            stmt.execute("CREATE INDEX " + indexName + " ON " + tableName + " (COL3) INCLUDE (COL4)");
            allStmtExecuted = true;
            stmt.execute("CREATE VIEW " + view01 + " (VCOL1 CHAR(8) NOT NULL PRIMARY KEY, COL5 VARCHAR) AS SELECT * FROM " + tableName + " WHERE COL1 = 'col1'");
            Assert.fail();
        }
        catch (SQLException e) {
            try {
                Assert.assertEquals((long)SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES.getErrorCode(), (long)e.getErrorCode());
                Assert.assertEquals((Object)SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES.getSQLState(), (Object)e.getSQLState());
                Assert.assertTrue((boolean)e.getMessage().contains(SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES.getMessage()));
            }
            catch (AssertionError ae) {
                LOGGER.error("Exception: ", (Throwable)e);
                throw ae;
            }
        }
        Assert.assertTrue((String)"All statements could not be executed", (boolean)allStmtExecuted);
    }

    @Test
    public void testSchemaViewExtendsPkWithParentTableIndex1() {
        String tableName = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName1 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName2 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName1, (String)tableName);
        String indexName = "idx_" + tableName;
        String view01 = SchemaUtil.getTableName((String)schemaName2, (String)("v01_" + tableName));
        boolean allStmtExecuted = false;
        try (Connection conn = DriverManager.getConnection(ViewExtendsPkRestrictionsIT.getUrl());){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + fullTableName + " (COL1 CHAR(10) NOT NULL, COL2 CHAR(5) NOT NULL, COL3 VARCHAR, COL4 VARCHAR CONSTRAINT pk PRIMARY KEY(COL1, COL2))");
            stmt.execute("CREATE INDEX " + indexName + " ON " + fullTableName + " (COL3) INCLUDE (COL4)");
            allStmtExecuted = true;
            stmt.execute("CREATE VIEW " + view01 + " (VCOL1 CHAR(8) NOT NULL PRIMARY KEY, COL5 VARCHAR) AS SELECT * FROM " + fullTableName + " WHERE COL1 = 'col1'");
            Assert.fail();
        }
        catch (SQLException e) {
            try {
                Assert.assertEquals((long)SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES.getErrorCode(), (long)e.getErrorCode());
                Assert.assertEquals((Object)SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES.getSQLState(), (Object)e.getSQLState());
                Assert.assertTrue((boolean)e.getMessage().contains(SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES.getMessage()));
            }
            catch (AssertionError ae) {
                LOGGER.error("Exception: ", (Throwable)e);
                throw ae;
            }
        }
        Assert.assertTrue((String)"All statements could not be executed", (boolean)allStmtExecuted);
    }

    @Test
    public void testTenantSchemaViewExtendsPkWithParentTableIndex1() throws Exception {
        String tableName = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName1 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName2 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName1, (String)tableName);
        String indexName = "idx_" + tableName;
        String view01 = SchemaUtil.getTableName((String)schemaName2, (String)("v01_" + tableName));
        try (Connection conn = DriverManager.getConnection(ViewExtendsPkRestrictionsIT.getUrl());){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + fullTableName + " (TENANT_ID VARCHAR NOT NULL, COL1 CHAR(10) NOT NULL, COL2 CHAR(5) NOT NULL, COL3 VARCHAR, COL4 VARCHAR CONSTRAINT pk PRIMARY KEY(TENANT_ID, COL1, COL2)) MULTI_TENANT = true");
            stmt.execute("CREATE INDEX " + indexName + " ON " + fullTableName + " (COL3) INCLUDE (COL4)");
            try (Connection tenantConn = this.getTenantConnection(TENANT_ID);){
                Statement tenantStmt = tenantConn.createStatement();
                tenantStmt.execute("CREATE VIEW " + view01 + " (VCOL1 CHAR(8) NOT NULL PRIMARY KEY, COL5 VARCHAR) AS SELECT * FROM " + fullTableName + " WHERE COL1 = 'col1'");
                Assert.fail();
            }
            catch (SQLException e) {
                try {
                    Assert.assertEquals((long)SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES.getErrorCode(), (long)e.getErrorCode());
                    Assert.assertEquals((Object)SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES.getSQLState(), (Object)e.getSQLState());
                    Assert.assertTrue((boolean)e.getMessage().contains(SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES.getMessage()));
                }
                catch (AssertionError ae) {
                    LOGGER.error("Exception: ", (Throwable)e);
                    throw ae;
                }
            }
        }
    }

    @Test
    public void testViewExtendsPkWithParentTableIndex2() {
        String tableName = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String indexName = "idx_" + tableName;
        String view01 = "v01_" + tableName;
        boolean allStmtExecuted = false;
        try (Connection conn = DriverManager.getConnection(ViewExtendsPkRestrictionsIT.getUrl());){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + tableName + " (COL1 CHAR(10) NOT NULL, COL2 CHAR(5) NOT NULL, COL3 VARCHAR, COL4 VARCHAR CONSTRAINT pk PRIMARY KEY(COL1, COL2))");
            stmt.execute("CREATE INDEX " + indexName + " ON " + tableName + " (COL3) INCLUDE (COL4)");
            allStmtExecuted = true;
            stmt.execute("CREATE VIEW " + view01 + " (VCOL1 CHAR(8) NOT NULL, COL5 VARCHAR CONSTRAINT pk PRIMARY KEY(VCOL1)) AS SELECT * FROM " + tableName + " WHERE COL1 = 'col1'");
            Assert.fail();
        }
        catch (SQLException e) {
            try {
                Assert.assertEquals((long)SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES.getErrorCode(), (long)e.getErrorCode());
                Assert.assertEquals((Object)SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES.getSQLState(), (Object)e.getSQLState());
                Assert.assertTrue((boolean)e.getMessage().contains(SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES.getMessage()));
            }
            catch (AssertionError ae) {
                LOGGER.error("Exception: ", (Throwable)e);
                throw ae;
            }
        }
        Assert.assertTrue((String)"All statements could not be executed", (boolean)allStmtExecuted);
    }

    @Test
    public void testViewExtendsPkWithViewIndex1() throws Exception {
        String tableName = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String view01 = "v01_" + tableName;
        String view02 = "v02_" + tableName;
        String index_view01 = "idx_v01_" + tableName;
        String index_view02 = "idx_v02_" + tableName;
        try (Connection conn = DriverManager.getConnection(ViewExtendsPkRestrictionsIT.getUrl());){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + tableName + " (COL1 CHAR(10) NOT NULL, COL2 CHAR(5) NOT NULL, COL3 VARCHAR, COL4 VARCHAR CONSTRAINT pk PRIMARY KEY(COL1, COL2))");
            stmt.execute("CREATE VIEW " + view01 + " (VCOL1 CHAR(8) NOT NULL, COL5 VARCHAR CONSTRAINT pk PRIMARY KEY(VCOL1)) AS SELECT * FROM " + tableName + " WHERE COL1 = 'col1'");
            stmt.execute("CREATE INDEX " + index_view01 + " ON " + view01 + " (COL5) INCLUDE (COL1, COL2, COL3)");
            stmt.execute("CREATE VIEW " + view02 + " (VCOL2 CHAR(10), COL6 VARCHAR) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'vcol1'");
            stmt.execute("CREATE INDEX " + index_view02 + " ON " + view02 + " (COL6) INCLUDE (COL1, COL2, COL3)");
        }
    }

    @Test
    public void testViewExtendsPkWithViewIndex2() {
        String tableName = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String view01 = "v01_" + tableName;
        String view02 = "v02_" + tableName;
        String index_view01 = "idx_v01_" + tableName;
        boolean allStmtExecuted = false;
        try (Connection conn = DriverManager.getConnection(ViewExtendsPkRestrictionsIT.getUrl());){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + tableName + " (COL1 CHAR(10) NOT NULL, COL2 CHAR(5) NOT NULL, COL3 VARCHAR, COL4 VARCHAR CONSTRAINT pk PRIMARY KEY(COL1, COL2))");
            stmt.execute("CREATE VIEW " + view01 + " (VCOL1 CHAR(8) NOT NULL, COL5 VARCHAR CONSTRAINT pk PRIMARY KEY(VCOL1)) AS SELECT * FROM " + tableName + " WHERE COL1 = 'col1'");
            stmt.execute("CREATE INDEX " + index_view01 + " ON " + view01 + " (COL5) INCLUDE (COL1, COL2, COL3)");
            allStmtExecuted = true;
            stmt.execute("CREATE VIEW " + view02 + " (VCOL2 CHAR(10), COL6 VARCHAR CONSTRAINT pk PRIMARY KEY(VCOL2)) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'vcol1'");
            Assert.fail();
        }
        catch (SQLException e) {
            try {
                Assert.assertEquals((long)SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES.getErrorCode(), (long)e.getErrorCode());
                Assert.assertEquals((Object)SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES.getSQLState(), (Object)e.getSQLState());
                Assert.assertTrue((boolean)e.getMessage().contains(SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES.getMessage()));
            }
            catch (AssertionError ae) {
                LOGGER.error("Exception: ", (Throwable)e);
                throw ae;
            }
        }
        Assert.assertTrue((String)"All statements could not be executed", (boolean)allStmtExecuted);
    }

    @Test
    public void testSchemaViewExtendsPkWithViewIndex2() {
        String tableName = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName1 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName2 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName3 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName1, (String)tableName);
        String view01 = SchemaUtil.getTableName((String)schemaName2, (String)("v01_" + tableName));
        String view02 = SchemaUtil.getTableName((String)schemaName3, (String)("v02_" + tableName));
        String index_view01 = "idx_v01_" + tableName;
        boolean allStmtExecuted = false;
        try (Connection conn = DriverManager.getConnection(ViewExtendsPkRestrictionsIT.getUrl());){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + fullTableName + " (COL1 CHAR(10) NOT NULL, COL2 CHAR(5) NOT NULL, COL3 VARCHAR, COL4 VARCHAR CONSTRAINT pk PRIMARY KEY(COL1, COL2))");
            stmt.execute("CREATE VIEW " + view01 + " (VCOL1 CHAR(8) NOT NULL, COL5 VARCHAR CONSTRAINT pk PRIMARY KEY(VCOL1)) AS SELECT * FROM " + fullTableName + " WHERE COL1 = 'col1'");
            stmt.execute("CREATE INDEX " + index_view01 + " ON " + view01 + " (COL5) INCLUDE (COL1, COL2, COL3)");
            allStmtExecuted = true;
            stmt.execute("CREATE VIEW " + view02 + " (VCOL2 CHAR(10), COL6 VARCHAR CONSTRAINT pk PRIMARY KEY(VCOL2)) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'vcol1'");
            Assert.fail();
        }
        catch (SQLException e) {
            try {
                Assert.assertEquals((long)SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES.getErrorCode(), (long)e.getErrorCode());
                Assert.assertEquals((Object)SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES.getSQLState(), (Object)e.getSQLState());
                Assert.assertTrue((boolean)e.getMessage().contains(SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES.getMessage()));
            }
            catch (AssertionError ae) {
                LOGGER.error("Exception: ", (Throwable)e);
                throw ae;
            }
        }
        Assert.assertTrue((String)"All statements could not be executed", (boolean)allStmtExecuted);
    }

    @Test
    public void testTenantSchemaViewExtendsPkWithViewIndex2() throws Exception {
        String tableName = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName1 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName2 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName3 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName1, (String)tableName);
        String view01 = SchemaUtil.getTableName((String)schemaName2, (String)("v01_" + tableName));
        String view02 = SchemaUtil.getTableName((String)schemaName3, (String)("v02_" + tableName));
        String index_view01 = "idx_v01_" + tableName;
        boolean allStmtExecuted = false;
        try (Connection conn = DriverManager.getConnection(ViewExtendsPkRestrictionsIT.getUrl());){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + fullTableName + " (TENANT_ID VARCHAR NOT NULL, COL1 CHAR(10) NOT NULL, COL2 CHAR(5) NOT NULL, COL3 VARCHAR, COL4 VARCHAR CONSTRAINT pk PRIMARY KEY(TENANT_ID, COL1, COL2)) MULTI_TENANT = true");
            try (Connection tenantConn = this.getTenantConnection(TENANT_ID);){
                Statement tenantStmt = tenantConn.createStatement();
                tenantStmt.execute("CREATE VIEW " + view01 + " (VCOL1 CHAR(8) NOT NULL, COL5 VARCHAR CONSTRAINT pk PRIMARY KEY(VCOL1)) AS SELECT * FROM " + fullTableName + " WHERE COL1 = 'col1'");
                tenantStmt.execute("CREATE INDEX " + index_view01 + " ON " + view01 + " (COL5) INCLUDE (COL1, COL2, COL3)");
                allStmtExecuted = true;
                tenantStmt.execute("CREATE VIEW " + view02 + " (VCOL2 CHAR(10), COL6 VARCHAR CONSTRAINT pk PRIMARY KEY(VCOL2)) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'vcol1'");
                Assert.fail();
            }
        }
        catch (SQLException e) {
            try {
                Assert.assertEquals((long)SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES.getErrorCode(), (long)e.getErrorCode());
                Assert.assertEquals((Object)SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES.getSQLState(), (Object)e.getSQLState());
                Assert.assertTrue((boolean)e.getMessage().contains(SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES.getMessage()));
            }
            catch (AssertionError ae) {
                LOGGER.error("Exception: ", (Throwable)e);
                throw ae;
            }
        }
        Assert.assertTrue((String)"All statements could not be executed", (boolean)allStmtExecuted);
    }

    @Test
    public void testViewExtendsPkWithViewIndex3() {
        String tableName = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String view01 = "v01_" + tableName;
        String view02 = "v02_" + tableName;
        String view03 = "v03_" + tableName;
        String view04 = "v04_" + tableName;
        String index_view01 = "idx_v01_" + tableName;
        boolean allStmtExecuted = false;
        try (Connection conn = DriverManager.getConnection(ViewExtendsPkRestrictionsIT.getUrl());){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + tableName + " (COL1 CHAR(10) NOT NULL, COL2 CHAR(5) NOT NULL, COL3 VARCHAR, COL4 VARCHAR CONSTRAINT pk PRIMARY KEY(COL1, COL2))");
            stmt.execute("CREATE VIEW " + view01 + " (VCOL1 CHAR(8) NOT NULL, COL5 VARCHAR CONSTRAINT pk PRIMARY KEY(VCOL1)) AS SELECT * FROM " + tableName + " WHERE COL1 = 'col1'");
            stmt.execute("CREATE VIEW " + view02 + " (VCOL2 CHAR(8), COL6 VARCHAR) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'col2'");
            stmt.execute("CREATE VIEW " + view03 + " (VCOL3 CHAR(8), COL7 VARCHAR) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'col3'");
            stmt.execute("CREATE INDEX " + index_view01 + " ON " + view01 + " (COL5) INCLUDE (COL1, COL2, COL3)");
            allStmtExecuted = true;
            stmt.execute("CREATE VIEW " + view04 + " (VCOL2 CHAR(10), COL6 VARCHAR PRIMARY KEY) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'vcol4'");
            Assert.fail();
        }
        catch (SQLException e) {
            try {
                Assert.assertEquals((long)SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES.getErrorCode(), (long)e.getErrorCode());
                Assert.assertEquals((Object)SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES.getSQLState(), (Object)e.getSQLState());
                Assert.assertTrue((boolean)e.getMessage().contains(SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES.getMessage()));
            }
            catch (AssertionError ae) {
                LOGGER.error("Exception: ", (Throwable)e);
                throw ae;
            }
        }
        Assert.assertTrue((String)"All statements could not be executed", (boolean)allStmtExecuted);
    }

    @Test
    public void testTenantSchemaViewExtendsPkWithViewIndex3() throws Exception {
        String tableName = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName1 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName2 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName3 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName4 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName5 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName1, (String)tableName);
        String view01 = SchemaUtil.getTableName((String)schemaName2, (String)("v01_" + tableName));
        String view02 = SchemaUtil.getTableName((String)schemaName3, (String)("v02_" + tableName));
        String view03 = SchemaUtil.getTableName((String)schemaName4, (String)("v03_" + tableName));
        String view04 = SchemaUtil.getTableName((String)schemaName5, (String)("v04_" + tableName));
        String index_view01 = "idx_v01_" + tableName;
        boolean allStmtExecuted = false;
        try (Connection conn = DriverManager.getConnection(ViewExtendsPkRestrictionsIT.getUrl());){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + fullTableName + " (TENANT_ID VARCHAR NOT NULL, COL1 CHAR(10) NOT NULL, COL2 CHAR(5) NOT NULL, COL3 VARCHAR, COL4 VARCHAR CONSTRAINT pk PRIMARY KEY(TENANT_ID, COL1, COL2)) MULTI_TENANT = true");
            try (Connection tenantConn = this.getTenantConnection(TENANT_ID);){
                Statement tenantStmt = tenantConn.createStatement();
                stmt.execute("CREATE VIEW " + view01 + " (VCOL1 CHAR(8) NOT NULL, COL5 VARCHAR CONSTRAINT pk PRIMARY KEY(VCOL1)) AS SELECT * FROM " + fullTableName + " WHERE COL1 = 'col1'");
                tenantStmt.execute("CREATE VIEW " + view02 + " (VCOL2 CHAR(8), COL6 VARCHAR) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'col2'");
                tenantStmt.execute("CREATE VIEW " + view03 + " (VCOL3 CHAR(8), COL7 VARCHAR) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'col3'");
                stmt.execute("CREATE INDEX " + index_view01 + " ON " + view01 + " (COL5) INCLUDE (COL1, COL2, COL3)");
                allStmtExecuted = true;
                tenantStmt.execute("CREATE VIEW " + view04 + " (VCOL2 CHAR(10), COL6 VARCHAR PRIMARY KEY) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'vcol4'");
                Assert.fail();
            }
        }
        catch (SQLException e) {
            try {
                Assert.assertEquals((long)SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES.getErrorCode(), (long)e.getErrorCode());
                Assert.assertEquals((Object)SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES.getSQLState(), (Object)e.getSQLState());
                Assert.assertTrue((boolean)e.getMessage().contains(SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES.getMessage()));
            }
            catch (AssertionError ae) {
                LOGGER.error("Exception: ", (Throwable)e);
                throw ae;
            }
        }
        Assert.assertTrue((String)"All statements could not be executed", (boolean)allStmtExecuted);
    }

    @Test
    public void testTenantSchemaViewExtendsPkWithViewIndex4() throws Exception {
        String tableName = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName1 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName2 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName3 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName4 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName5 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName6 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName1, (String)tableName);
        String view01 = SchemaUtil.getTableName((String)schemaName2, (String)("v01_" + tableName));
        String view02 = SchemaUtil.getTableName((String)schemaName3, (String)("v02_" + tableName));
        String view03 = SchemaUtil.getTableName((String)schemaName4, (String)("v03_" + tableName));
        String view04 = SchemaUtil.getTableName((String)schemaName5, (String)("v04_" + tableName));
        String view05 = SchemaUtil.getTableName((String)schemaName6, (String)("v05_" + tableName));
        String index_view01 = "idx_v01_" + tableName;
        boolean allStmtExecuted = false;
        try (Connection conn = DriverManager.getConnection(ViewExtendsPkRestrictionsIT.getUrl());){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + fullTableName + " (TENANT_ID VARCHAR NOT NULL, COL1 CHAR(10) NOT NULL, COL2 CHAR(5) NOT NULL, COL3 VARCHAR, COL4 VARCHAR CONSTRAINT pk PRIMARY KEY(TENANT_ID, COL1, COL2)) MULTI_TENANT = true");
            try (Connection tenantConn = this.getTenantConnection(TENANT_ID);){
                Statement tenantStmt = tenantConn.createStatement();
                stmt.execute("CREATE VIEW " + view01 + " (VCOL1 CHAR(8) NOT NULL, COL5 VARCHAR CONSTRAINT pk PRIMARY KEY(VCOL1)) AS SELECT * FROM " + fullTableName + " WHERE COL1 = 'col1'");
                tenantStmt.execute("CREATE VIEW " + view02 + " (VCOL2 CHAR(8), COL6 VARCHAR) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'col2'");
                tenantStmt.execute("CREATE VIEW " + view03 + " (VCOL3 CHAR(8), COL7 VARCHAR) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'col3'");
                tenantStmt.execute("CREATE VIEW " + view04 + " (VCOL4 CHAR(10), COL8 VARCHAR) AS SELECT * FROM " + view02 + " WHERE VCOL1 = 'vcol4'");
                stmt.execute("CREATE INDEX " + index_view01 + " ON " + view01 + " (COL5) INCLUDE (COL1, COL2, COL3)");
                allStmtExecuted = true;
                tenantStmt.execute("CREATE VIEW " + view05 + " (VCOL5 CHAR(10), COL9 VARCHAR, COL10 INTEGER CONSTRAINT pk PRIMARY KEY(VCOL5)) AS SELECT * FROM " + view04 + " WHERE VCOL4 = 'vcol4'");
                Assert.fail();
            }
        }
        catch (SQLException e) {
            try {
                Assert.assertEquals((long)SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES.getErrorCode(), (long)e.getErrorCode());
                Assert.assertEquals((Object)SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES.getSQLState(), (Object)e.getSQLState());
                Assert.assertTrue((boolean)e.getMessage().contains(SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES.getMessage()));
            }
            catch (AssertionError ae) {
                LOGGER.error("Exception: ", (Throwable)e);
                throw ae;
            }
        }
        Assert.assertTrue((String)"All statements could not be executed", (boolean)allStmtExecuted);
    }

    @Test
    public void testTenantSchemaViewExtendsPkWithViewIndex5() throws Exception {
        String tableName = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName1 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName2 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName3 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName4 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName5 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName6 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName1, (String)tableName);
        String view01 = SchemaUtil.getTableName((String)schemaName2, (String)("v01_" + tableName));
        String view02 = SchemaUtil.getTableName((String)schemaName3, (String)("v02_" + tableName));
        String view03 = SchemaUtil.getTableName((String)schemaName4, (String)("v03_" + tableName));
        String view04 = SchemaUtil.getTableName((String)schemaName5, (String)("v04_" + tableName));
        String view05 = SchemaUtil.getTableName((String)schemaName6, (String)("v05_" + tableName));
        String index_view01 = "idx_v01_" + tableName;
        try (Connection conn = DriverManager.getConnection(ViewExtendsPkRestrictionsIT.getUrl());){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + fullTableName + " (TENANT_ID VARCHAR NOT NULL, COL1 CHAR(10) NOT NULL, COL2 CHAR(5) NOT NULL, COL3 VARCHAR, COL4 VARCHAR CONSTRAINT pk PRIMARY KEY(TENANT_ID, COL1, COL2)) MULTI_TENANT = true");
            try (Connection tenantConn = this.getTenantConnection(TENANT_ID);){
                Statement tenantStmt = tenantConn.createStatement();
                stmt.execute("CREATE VIEW " + view01 + " (VCOL1 CHAR(8) NOT NULL, COL5 VARCHAR CONSTRAINT pk PRIMARY KEY(VCOL1)) AS SELECT * FROM " + fullTableName + " WHERE COL1 = 'col1'");
                tenantStmt.execute("CREATE VIEW " + view02 + " (VCOL2 CHAR(8), COL6 VARCHAR) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'col2'");
                tenantStmt.execute("CREATE VIEW " + view03 + " (VCOL3 CHAR(8), COL7 VARCHAR) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'col3'");
                tenantStmt.execute("CREATE VIEW " + view04 + " (VCOL4 CHAR(10), COL8 VARCHAR) AS SELECT * FROM " + view02 + " WHERE VCOL1 = 'vcol4'");
                stmt.execute("CREATE INDEX " + index_view01 + " ON " + view01 + " (COL5) INCLUDE (COL1, COL2, COL3)");
                tenantStmt.execute("CREATE VIEW " + view05 + " (VCOL5 CHAR(10), COL9 VARCHAR, COL10 INTEGER) AS SELECT * FROM " + view04 + " WHERE VCOL4 = 'vcol4'");
            }
        }
    }

    @Test
    public void testTenantSchemaViewExtendsPkWithViewIndex6() throws Exception {
        String tableName = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName1 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName2 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName3 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName4 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName5 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName6 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName1, (String)tableName);
        String view01 = SchemaUtil.getTableName((String)schemaName2, (String)("v01_" + tableName));
        String view02 = SchemaUtil.getTableName((String)schemaName3, (String)("v02_" + tableName));
        String view03 = SchemaUtil.getTableName((String)schemaName4, (String)("v03_" + tableName));
        String view04 = SchemaUtil.getTableName((String)schemaName5, (String)("v04_" + tableName));
        String view05 = SchemaUtil.getTableName((String)schemaName6, (String)("v05_" + tableName));
        String index_view01 = "idx_v01_" + tableName;
        boolean allStmtExecuted = false;
        try (Connection conn = DriverManager.getConnection(ViewExtendsPkRestrictionsIT.getUrl());){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + fullTableName + " (TENANT_ID VARCHAR NOT NULL, COL1 CHAR(10) NOT NULL, COL2 CHAR(5) NOT NULL, COL3 VARCHAR, COL4 VARCHAR CONSTRAINT pk PRIMARY KEY(TENANT_ID, COL1, COL2)) MULTI_TENANT = true");
            try (Connection tenantConn = this.getTenantConnection(TENANT_ID);){
                Statement tenantStmt = tenantConn.createStatement();
                tenantStmt.execute("CREATE VIEW " + view01 + " (VCOL1 CHAR(8) NOT NULL, COL5 VARCHAR CONSTRAINT pk PRIMARY KEY(VCOL1)) AS SELECT * FROM " + fullTableName + " WHERE COL1 = 'col1'");
                tenantStmt.execute("CREATE VIEW " + view02 + " (VCOL2 CHAR(8), COL6 VARCHAR) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'col2'");
                tenantStmt.execute("CREATE VIEW " + view03 + " (VCOL3 CHAR(8), COL7 VARCHAR) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'col3'");
                tenantStmt.execute("CREATE VIEW " + view04 + " (VCOL4 CHAR(10), COL8 VARCHAR) AS SELECT * FROM " + view02 + " WHERE VCOL1 = 'vcol4'");
                tenantStmt.execute("CREATE INDEX " + index_view01 + " ON " + view01 + " (COL5) INCLUDE (COL1, COL2, COL3)");
                allStmtExecuted = true;
                tenantStmt.execute("CREATE VIEW " + view05 + " (VCOL5 CHAR(10), COL9 VARCHAR, COL10 INTEGER CONSTRAINT pk PRIMARY KEY(VCOL5)) AS SELECT * FROM " + view04 + " WHERE VCOL4 = 'vcol4'");
                Assert.fail();
            }
        }
        catch (SQLException e) {
            try {
                Assert.assertEquals((long)SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES.getErrorCode(), (long)e.getErrorCode());
                Assert.assertEquals((Object)SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES.getSQLState(), (Object)e.getSQLState());
                Assert.assertTrue((boolean)e.getMessage().contains(SQLExceptionCode.VIEW_CANNOT_EXTEND_PK_WITH_PARENT_INDEXES.getMessage()));
            }
            catch (AssertionError ae) {
                LOGGER.error("Exception: ", (Throwable)e);
                throw ae;
            }
        }
        Assert.assertTrue((String)"All statements could not be executed", (boolean)allStmtExecuted);
    }

    @Test
    public void testTenantSchemaViewExtendsPkWithViewIndex7() throws Exception {
        String tableName = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName1 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName2 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName3 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName4 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName5 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName6 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName1, (String)tableName);
        String view01 = SchemaUtil.getTableName((String)schemaName2, (String)("v01_" + tableName));
        String view02 = SchemaUtil.getTableName((String)schemaName3, (String)("v02_" + tableName));
        String view03 = SchemaUtil.getTableName((String)schemaName4, (String)("v03_" + tableName));
        String view04 = SchemaUtil.getTableName((String)schemaName5, (String)("v04_" + tableName));
        String view05 = SchemaUtil.getTableName((String)schemaName6, (String)("v05_" + tableName));
        String index_table = "idx_" + tableName;
        boolean allStmtExecuted = false;
        try (Connection conn = DriverManager.getConnection(ViewExtendsPkRestrictionsIT.getUrl());){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + fullTableName + " (TENANT_ID VARCHAR NOT NULL, COL1 CHAR(10) NOT NULL, COL2 CHAR(5) NOT NULL, COL3 VARCHAR, COL4 VARCHAR CONSTRAINT pk PRIMARY KEY(TENANT_ID, COL1, COL2)) MULTI_TENANT = true");
            try (Connection tenantConn = this.getTenantConnection(TENANT_ID);){
                Statement tenantStmt = tenantConn.createStatement();
                tenantStmt.execute("CREATE VIEW " + view01 + " (VCOL1 CHAR(8) NOT NULL, COL5 VARCHAR CONSTRAINT pk PRIMARY KEY(VCOL1)) AS SELECT * FROM " + fullTableName + " WHERE COL1 = 'col1'");
                tenantStmt.execute("CREATE VIEW " + view02 + " (VCOL2 CHAR(8), COL6 VARCHAR) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'col2'");
                tenantStmt.execute("CREATE VIEW " + view03 + " (VCOL3 CHAR(8), COL7 VARCHAR) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'col3'");
                tenantStmt.execute("CREATE VIEW " + view04 + " (VCOL4 CHAR(10), COL8 VARCHAR) AS SELECT * FROM " + view02 + " WHERE VCOL1 = 'vcol4'");
                allStmtExecuted = true;
                stmt.execute("CREATE INDEX " + index_table + " ON " + fullTableName + " (COL4) INCLUDE (COL2)");
                tenantStmt.execute("CREATE VIEW " + view05 + " (VCOL5 CHAR(10), COL9 VARCHAR, COL10 INTEGER CONSTRAINT pk PRIMARY KEY(VCOL5)) AS SELECT * FROM " + view04 + " WHERE VCOL4 = 'vcol4'");
                Assert.fail();
            }
        }
        catch (SQLException e) {
            try {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_CREATE_INDEX_CHILD_VIEWS_EXTEND_PK.getErrorCode(), (long)e.getErrorCode());
                Assert.assertEquals((Object)SQLExceptionCode.CANNOT_CREATE_INDEX_CHILD_VIEWS_EXTEND_PK.getSQLState(), (Object)e.getSQLState());
                Assert.assertTrue((boolean)e.getMessage().contains(SQLExceptionCode.CANNOT_CREATE_INDEX_CHILD_VIEWS_EXTEND_PK.getMessage()));
            }
            catch (AssertionError ae) {
                LOGGER.error("Exception: ", (Throwable)e);
                throw ae;
            }
        }
        Assert.assertTrue((String)"All statements could not be executed", (boolean)allStmtExecuted);
    }

    @Test
    public void testTenantSchemaViewExtendsPkWithViewIndex8() throws Exception {
        String tableName = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName1 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName2 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName3 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName4 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName5 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName1, (String)tableName);
        String view01 = SchemaUtil.getTableName((String)schemaName2, (String)("v01_" + tableName));
        String view02 = SchemaUtil.getTableName((String)schemaName3, (String)("v02_" + tableName));
        String view03 = SchemaUtil.getTableName((String)schemaName4, (String)("v03_" + tableName));
        String view04 = SchemaUtil.getTableName((String)schemaName5, (String)("v04_" + tableName));
        String index_table = "idx_" + tableName;
        Properties props = new Properties();
        props.setProperty("phoenix.disable.view.subtree.validation", "true");
        try (Connection conn = DriverManager.getConnection(ViewExtendsPkRestrictionsIT.getUrl(), props);){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + fullTableName + " (TENANT_ID VARCHAR NOT NULL, COL1 CHAR(10) NOT NULL, COL2 CHAR(5) NOT NULL, COL3 VARCHAR, COL4 VARCHAR CONSTRAINT pk PRIMARY KEY(TENANT_ID, COL1, COL2)) MULTI_TENANT = true");
            try (Connection tenantConn = this.getTenantConnection(TENANT_ID, true);){
                Statement tenantStmt = tenantConn.createStatement();
                tenantStmt.execute("CREATE VIEW " + view01 + " (VCOL1 CHAR(8) NOT NULL, COL5 VARCHAR CONSTRAINT pk PRIMARY KEY(VCOL1)) AS SELECT * FROM " + fullTableName + " WHERE COL1 = 'col1'");
                tenantStmt.execute("CREATE VIEW " + view02 + " (VCOL2 CHAR(8), COL6 VARCHAR) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'col2'");
                tenantStmt.execute("CREATE VIEW " + view03 + " (VCOL3 CHAR(8), COL7 VARCHAR) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'col3'");
                tenantStmt.execute("CREATE VIEW " + view04 + " (VCOL4 CHAR(10), COL8 VARCHAR) AS SELECT * FROM " + view02 + " WHERE VCOL1 = 'vcol4'");
                stmt.execute("CREATE INDEX " + index_table + " ON " + fullTableName + " (COL4) INCLUDE (COL2)");
            }
        }
    }

    @Test
    public void testViewIndexWithChildViewExtendedPk1() throws Exception {
        String tableName = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String view01 = "v01_" + tableName;
        String view02 = "v02_" + tableName;
        String view03 = "v03_" + tableName;
        String view04 = "v04_" + tableName;
        String index_view01 = "idx_v01_" + tableName;
        String index_view02 = "idx_v02_" + tableName;
        Properties props = new Properties();
        props.setProperty("phoenix.disable.view.subtree.validation", "true");
        try (Connection conn = DriverManager.getConnection(ViewExtendsPkRestrictionsIT.getUrl(), props);){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + tableName + " (COL1 CHAR(10) NOT NULL, COL2 CHAR(5) NOT NULL, COL3 VARCHAR, COL4 VARCHAR CONSTRAINT pk PRIMARY KEY(COL1, COL2))");
            stmt.execute("CREATE VIEW " + view01 + " (VCOL1 CHAR(8) NOT NULL, COL5 VARCHAR CONSTRAINT pk PRIMARY KEY(VCOL1)) AS SELECT * FROM " + tableName + " WHERE COL1 = 'col1'");
            stmt.execute("CREATE VIEW " + view02 + " (VCOL2 CHAR(10) PRIMARY KEY, COL6 VARCHAR) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'vcol1'");
            stmt.execute("CREATE INDEX " + index_view02 + " ON " + view02 + " (COL6) INCLUDE (COL1, COL2, COL3)");
            stmt.execute("CREATE VIEW " + view03 + " (VCOL3 CHAR(8), COL7 VARCHAR) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'col3'");
            stmt.execute("CREATE VIEW " + view04 + " (VCOL2 CHAR(10), COL6 VARCHAR PRIMARY KEY) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'vcol4'");
            stmt.execute("CREATE INDEX " + index_view01 + " ON " + view01 + " (COL5) INCLUDE (COL1, COL2, COL3)");
        }
    }

    @Test
    public void testViewIndexWithChildViewExtendedPk4() {
        String tableName = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String view01 = "v01_" + tableName;
        String view02 = "v02_" + tableName;
        String view03 = "v03_" + tableName;
        String view04 = "v04_" + tableName;
        String index_view01 = "idx_v01_" + tableName;
        String index_view02 = "idx_v02_" + tableName;
        boolean allStmtExecuted = false;
        try (Connection conn = DriverManager.getConnection(ViewExtendsPkRestrictionsIT.getUrl());){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + tableName + " (COL1 CHAR(10) NOT NULL, COL2 CHAR(5) NOT NULL, COL3 VARCHAR, COL4 VARCHAR CONSTRAINT pk PRIMARY KEY(COL1, COL2))");
            stmt.execute("CREATE VIEW " + view01 + " (VCOL1 CHAR(8) NOT NULL, COL5 VARCHAR CONSTRAINT pk PRIMARY KEY(VCOL1)) AS SELECT * FROM " + tableName + " WHERE COL1 = 'col1'");
            stmt.execute("CREATE VIEW " + view02 + " (VCOL2 CHAR(10) PRIMARY KEY, COL6 VARCHAR) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'vcol1'");
            stmt.execute("CREATE INDEX " + index_view02 + " ON " + view02 + " (COL6) INCLUDE (COL1, COL2, COL3)");
            stmt.execute("CREATE VIEW " + view03 + " (VCOL3 CHAR(8), COL7 VARCHAR) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'col3'");
            stmt.execute("CREATE VIEW " + view04 + " (VCOL2 CHAR(10), COL6 VARCHAR PRIMARY KEY) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'vcol4'");
            allStmtExecuted = true;
            stmt.execute("CREATE INDEX " + index_view01 + " ON " + view01 + " (COL5) INCLUDE (COL1, COL2, COL3)");
            Assert.fail();
        }
        catch (SQLException e) {
            try {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_CREATE_INDEX_CHILD_VIEWS_EXTEND_PK.getErrorCode(), (long)e.getErrorCode());
                Assert.assertEquals((Object)SQLExceptionCode.CANNOT_CREATE_INDEX_CHILD_VIEWS_EXTEND_PK.getSQLState(), (Object)e.getSQLState());
                Assert.assertTrue((boolean)e.getMessage().contains(SQLExceptionCode.CANNOT_CREATE_INDEX_CHILD_VIEWS_EXTEND_PK.getMessage()));
            }
            catch (AssertionError ae) {
                LOGGER.error("Exception: ", (Throwable)e);
                throw ae;
            }
        }
        Assert.assertTrue((String)"All statements could not be executed", (boolean)allStmtExecuted);
    }

    @Test
    public void testSchemaViewIndexWithChildViewExtendedPk1() {
        String tableName = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName1 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName2 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName3 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName4 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName5 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName1, (String)tableName);
        String view01 = SchemaUtil.getTableName((String)schemaName2, (String)("v01_" + tableName));
        String view02 = SchemaUtil.getTableName((String)schemaName3, (String)("v02_" + tableName));
        String view03 = SchemaUtil.getTableName((String)schemaName4, (String)("v03_" + tableName));
        String view04 = SchemaUtil.getTableName((String)schemaName5, (String)("v04_" + tableName));
        String index_view01 = "idx_v01_" + tableName;
        String index_view02 = "idx_v02_" + tableName;
        boolean allStmtExecuted = false;
        try (Connection conn = DriverManager.getConnection(ViewExtendsPkRestrictionsIT.getUrl());){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + fullTableName + " (COL1 CHAR(10) NOT NULL, COL2 CHAR(5) NOT NULL, COL3 VARCHAR, COL4 VARCHAR CONSTRAINT pk PRIMARY KEY(COL1, COL2))");
            stmt.execute("CREATE VIEW " + view01 + " (VCOL1 CHAR(8) NOT NULL, COL5 VARCHAR CONSTRAINT pk PRIMARY KEY(VCOL1)) AS SELECT * FROM " + fullTableName + " WHERE COL1 = 'col1'");
            stmt.execute("CREATE VIEW " + view02 + " (VCOL2 CHAR(10) PRIMARY KEY, COL6 VARCHAR) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'vcol1'");
            stmt.execute("CREATE INDEX " + index_view02 + " ON " + view02 + " (COL6) INCLUDE (COL1, COL2, COL3)");
            stmt.execute("CREATE VIEW " + view03 + " (VCOL3 CHAR(8), COL7 VARCHAR) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'col3'");
            stmt.execute("CREATE VIEW " + view04 + " (VCOL2 CHAR(10), COL6 VARCHAR PRIMARY KEY) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'vcol4'");
            allStmtExecuted = true;
            stmt.execute("CREATE INDEX " + index_view01 + " ON " + view01 + " (COL5) INCLUDE (COL1, COL2, COL3)");
            Assert.fail();
        }
        catch (SQLException e) {
            try {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_CREATE_INDEX_CHILD_VIEWS_EXTEND_PK.getErrorCode(), (long)e.getErrorCode());
                Assert.assertEquals((Object)SQLExceptionCode.CANNOT_CREATE_INDEX_CHILD_VIEWS_EXTEND_PK.getSQLState(), (Object)e.getSQLState());
                Assert.assertTrue((boolean)e.getMessage().contains(SQLExceptionCode.CANNOT_CREATE_INDEX_CHILD_VIEWS_EXTEND_PK.getMessage()));
            }
            catch (AssertionError ae) {
                LOGGER.error("Exception: ", (Throwable)e);
                throw ae;
            }
        }
        Assert.assertTrue((String)"All statements could not be executed", (boolean)allStmtExecuted);
    }

    @Test
    public void testTenantSchemaViewIndexWithChildViewExtendedPk1() throws Exception {
        String tableName = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName1 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName2 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName3 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName4 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName5 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName1, (String)tableName);
        String view01 = SchemaUtil.getTableName((String)schemaName2, (String)("v01_" + tableName));
        String view02 = SchemaUtil.getTableName((String)schemaName3, (String)("v02_" + tableName));
        String view03 = SchemaUtil.getTableName((String)schemaName4, (String)("v03_" + tableName));
        String view04 = SchemaUtil.getTableName((String)schemaName5, (String)("v04_" + tableName));
        String index_view01 = "idx_v01_" + tableName;
        String index_view02 = "idx_v02_" + tableName;
        boolean allStmtExecuted = false;
        try (Connection conn = DriverManager.getConnection(ViewExtendsPkRestrictionsIT.getUrl());){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + fullTableName + " (TENANT_ID VARCHAR NOT NULL, COL1 CHAR(10) NOT NULL, COL2 CHAR(5) NOT NULL, COL3 VARCHAR, COL4 VARCHAR CONSTRAINT pk PRIMARY KEY(TENANT_ID, COL1, COL2)) MULTI_TENANT = true");
            try (Connection tenantConn = this.getTenantConnection(TENANT_ID);){
                Statement tenantStmt = tenantConn.createStatement();
                tenantStmt.execute("CREATE VIEW " + view01 + " (VCOL1 CHAR(8) NOT NULL, COL5 VARCHAR CONSTRAINT pk PRIMARY KEY(VCOL1)) AS SELECT * FROM " + fullTableName + " WHERE COL1 = 'col1'");
                tenantStmt.execute("CREATE VIEW " + view02 + " (VCOL2 CHAR(10) PRIMARY KEY, COL6 VARCHAR) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'vcol1'");
                tenantStmt.execute("CREATE INDEX " + index_view02 + " ON " + view02 + " (COL6) INCLUDE (COL1, COL2, COL3)");
                tenantStmt.execute("CREATE VIEW " + view03 + " (VCOL3 CHAR(8), COL7 VARCHAR) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'col3'");
                tenantStmt.execute("CREATE VIEW " + view04 + " (VCOL2 CHAR(10), COL6 VARCHAR PRIMARY KEY) AS SELECT * FROM " + view03 + " WHERE VCOL1 = 'vcol4'");
                allStmtExecuted = true;
                tenantStmt.execute("CREATE INDEX " + index_view01 + " ON " + view01 + " (COL5) INCLUDE (COL1, COL2, COL3)");
                Assert.fail();
            }
        }
        catch (SQLException e) {
            try {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_CREATE_INDEX_CHILD_VIEWS_EXTEND_PK.getErrorCode(), (long)e.getErrorCode());
                Assert.assertEquals((Object)SQLExceptionCode.CANNOT_CREATE_INDEX_CHILD_VIEWS_EXTEND_PK.getSQLState(), (Object)e.getSQLState());
                Assert.assertTrue((boolean)e.getMessage().contains(SQLExceptionCode.CANNOT_CREATE_INDEX_CHILD_VIEWS_EXTEND_PK.getMessage()));
            }
            catch (AssertionError ae) {
                LOGGER.error("Exception: ", (Throwable)e);
                throw ae;
            }
        }
        Assert.assertTrue((String)"All statements could not be executed", (boolean)allStmtExecuted);
    }

    @Test
    public void testViewIndexWithChildViewExtendedPk2() {
        String tableName = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String view01 = "v01_" + tableName;
        String view02 = "v02_" + tableName;
        String view03 = "v03_" + tableName;
        String view04 = "v04_" + tableName;
        String index_view01 = "idx_v01_" + tableName;
        String index_view02 = "idx_v02_" + tableName;
        boolean allStmtExecuted = false;
        try (Connection conn = DriverManager.getConnection(ViewExtendsPkRestrictionsIT.getUrl());){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + tableName + " (COL1 CHAR(10) NOT NULL, COL2 CHAR(5) NOT NULL, COL3 VARCHAR, COL4 VARCHAR CONSTRAINT pk PRIMARY KEY(COL1, COL2))");
            stmt.execute("CREATE VIEW " + view01 + " (VCOL1 CHAR(8) NOT NULL, COL5 VARCHAR CONSTRAINT pk PRIMARY KEY(VCOL1)) AS SELECT * FROM " + tableName + " WHERE COL1 = 'col1'");
            stmt.execute("CREATE VIEW " + view02 + " (VCOL2 CHAR(10), COL6 VARCHAR CONSTRAINT pk PRIMARY KEY(COL6)) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'vcol1'");
            stmt.execute("CREATE INDEX " + index_view02 + " ON " + view02 + " (COL6) INCLUDE (COL1, COL2, COL3)");
            stmt.execute("CREATE VIEW " + view03 + " (VCOL3 CHAR(8), COL7 VARCHAR) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'col3'");
            stmt.execute("CREATE VIEW " + view04 + " (VCOL2 CHAR(10), COL6 VARCHAR PRIMARY KEY) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'vcol4'");
            allStmtExecuted = true;
            stmt.execute("CREATE INDEX " + index_view01 + " ON " + view01 + " (COL5) INCLUDE (COL1, COL2, COL3)");
            Assert.fail();
        }
        catch (SQLException e) {
            try {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_CREATE_INDEX_CHILD_VIEWS_EXTEND_PK.getErrorCode(), (long)e.getErrorCode());
                Assert.assertEquals((Object)SQLExceptionCode.CANNOT_CREATE_INDEX_CHILD_VIEWS_EXTEND_PK.getSQLState(), (Object)e.getSQLState());
                Assert.assertTrue((boolean)e.getMessage().contains(SQLExceptionCode.CANNOT_CREATE_INDEX_CHILD_VIEWS_EXTEND_PK.getMessage()));
            }
            catch (AssertionError ae) {
                LOGGER.error("Exception: ", (Throwable)e);
                throw ae;
            }
        }
        Assert.assertTrue((String)"All statements could not be executed", (boolean)allStmtExecuted);
    }

    @Test
    public void testSchemaViewIndexWithChildViewExtendedPk2() {
        String tableName = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName1 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName2 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName3 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName4 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName5 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName1, (String)tableName);
        String view01 = SchemaUtil.getTableName((String)schemaName2, (String)("v01_" + tableName));
        String view02 = SchemaUtil.getTableName((String)schemaName3, (String)("v02_" + tableName));
        String view03 = SchemaUtil.getTableName((String)schemaName4, (String)("v03_" + tableName));
        String view04 = SchemaUtil.getTableName((String)schemaName5, (String)("v04_" + tableName));
        String index_view01 = "idx_v01_" + tableName;
        String index_view02 = "idx_v02_" + tableName;
        boolean allStmtExecuted = false;
        try (Connection conn = DriverManager.getConnection(ViewExtendsPkRestrictionsIT.getUrl());){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + fullTableName + " (COL1 CHAR(10) NOT NULL, COL2 CHAR(5) NOT NULL, COL3 VARCHAR, COL4 VARCHAR CONSTRAINT pk PRIMARY KEY(COL1, COL2))");
            stmt.execute("CREATE VIEW " + view01 + " (VCOL1 CHAR(8) NOT NULL, COL5 VARCHAR CONSTRAINT pk PRIMARY KEY(VCOL1)) AS SELECT * FROM " + fullTableName + " WHERE COL1 = 'col1'");
            stmt.execute("CREATE VIEW " + view02 + " (VCOL2 CHAR(10), COL6 VARCHAR CONSTRAINT pk PRIMARY KEY(COL6)) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'vcol1'");
            stmt.execute("CREATE INDEX " + index_view02 + " ON " + view02 + " (COL6) INCLUDE (COL1, COL2, COL3)");
            stmt.execute("CREATE VIEW " + view03 + " (VCOL3 CHAR(8), COL7 VARCHAR) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'col3'");
            stmt.execute("CREATE VIEW " + view04 + " (VCOL2 CHAR(10), COL6 VARCHAR PRIMARY KEY) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'vcol4'");
            allStmtExecuted = true;
            stmt.execute("CREATE INDEX " + index_view01 + " ON " + view01 + " (COL5) INCLUDE (COL1, COL2, COL3)");
            Assert.fail();
        }
        catch (SQLException e) {
            try {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_CREATE_INDEX_CHILD_VIEWS_EXTEND_PK.getErrorCode(), (long)e.getErrorCode());
                Assert.assertEquals((Object)SQLExceptionCode.CANNOT_CREATE_INDEX_CHILD_VIEWS_EXTEND_PK.getSQLState(), (Object)e.getSQLState());
                Assert.assertTrue((boolean)e.getMessage().contains(SQLExceptionCode.CANNOT_CREATE_INDEX_CHILD_VIEWS_EXTEND_PK.getMessage()));
            }
            catch (AssertionError ae) {
                LOGGER.error("Exception: ", (Throwable)e);
                throw ae;
            }
        }
        Assert.assertTrue((String)"All statements could not be executed", (boolean)allStmtExecuted);
    }

    @Test
    public void testTenantSchemaViewIndexWithChildViewExtendedPk2() throws Exception {
        String tableName = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName1 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName2 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName3 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName4 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String schemaName5 = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName1, (String)tableName);
        String view01 = SchemaUtil.getTableName((String)schemaName2, (String)("v01_" + tableName));
        String view02 = SchemaUtil.getTableName((String)schemaName3, (String)("v02_" + tableName));
        String view03 = SchemaUtil.getTableName((String)schemaName4, (String)("v03_" + tableName));
        String view04 = SchemaUtil.getTableName((String)schemaName5, (String)("v04_" + tableName));
        String index_view01 = "idx_v01_" + tableName;
        boolean allStmtExecuted = false;
        try (Connection conn = DriverManager.getConnection(ViewExtendsPkRestrictionsIT.getUrl());){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + fullTableName + " (TENANT_ID VARCHAR NOT NULL, COL1 CHAR(10) NOT NULL, COL2 CHAR(5) NOT NULL, COL3 VARCHAR, COL4 VARCHAR CONSTRAINT pk PRIMARY KEY(TENANT_ID, COL1, COL2)) MULTI_TENANT = true");
            try (Connection tenantConn = this.getTenantConnection(TENANT_ID);){
                Statement tenantStmt = tenantConn.createStatement();
                stmt.execute("CREATE VIEW " + view01 + " (VCOL1 CHAR(8) NOT NULL, COL5 VARCHAR CONSTRAINT pk PRIMARY KEY(VCOL1)) AS SELECT * FROM " + fullTableName + " WHERE COL1 = 'col1'");
                tenantStmt.execute("CREATE VIEW " + view02 + " (VCOL2 CHAR(10), COL6 VARCHAR CONSTRAINT pk PRIMARY KEY(VCOL2)) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'vcol1'");
                tenantStmt.execute("CREATE VIEW " + view03 + " (VCOL3 CHAR(8), COL7 VARCHAR) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'col3'");
                tenantStmt.execute("CREATE VIEW " + view04 + " (VCOL3 CHAR(10), COL6 VARCHAR PRIMARY KEY) AS SELECT * FROM " + view02 + " WHERE VCOL1 = 'vcol4'");
                allStmtExecuted = true;
                stmt.execute("CREATE INDEX " + index_view01 + " ON " + view01 + " (COL5) INCLUDE (COL1, COL2, COL3)");
                Assert.fail();
            }
        }
        catch (SQLException e) {
            try {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_CREATE_INDEX_CHILD_VIEWS_EXTEND_PK.getErrorCode(), (long)e.getErrorCode());
                Assert.assertEquals((Object)SQLExceptionCode.CANNOT_CREATE_INDEX_CHILD_VIEWS_EXTEND_PK.getSQLState(), (Object)e.getSQLState());
                Assert.assertTrue((boolean)e.getMessage().contains(SQLExceptionCode.CANNOT_CREATE_INDEX_CHILD_VIEWS_EXTEND_PK.getMessage()));
            }
            catch (AssertionError ae) {
                LOGGER.error("Exception: ", (Throwable)e);
                throw ae;
            }
        }
        Assert.assertTrue((String)"All statements could not be executed", (boolean)allStmtExecuted);
    }

    @Test
    public void testViewIndexWithChildViewExtendedPk3() throws Exception {
        String tableName = ViewExtendsPkRestrictionsIT.generateUniqueName();
        String view01 = "v01_" + tableName;
        String view02 = "v02_" + tableName;
        String view03 = "v03_" + tableName;
        String view04 = "v04_" + tableName;
        String index_view01 = "idx_v01_" + tableName;
        String index_view02 = "idx_v02_" + tableName;
        try (Connection conn = DriverManager.getConnection(ViewExtendsPkRestrictionsIT.getUrl());){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + tableName + " (COL1 CHAR(10) NOT NULL, COL2 CHAR(5) NOT NULL, COL3 VARCHAR, COL4 VARCHAR CONSTRAINT pk PRIMARY KEY(COL1, COL2))");
            stmt.execute("CREATE VIEW " + view01 + " (VCOL1 CHAR(8) NOT NULL, COL5 VARCHAR CONSTRAINT pk PRIMARY KEY(VCOL1)) AS SELECT * FROM " + tableName + " WHERE COL1 = 'col1'");
            stmt.execute("CREATE VIEW " + view02 + " (VCOL2 CHAR(10), COL6 VARCHAR) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'vcol1'");
            stmt.execute("CREATE INDEX " + index_view02 + " ON " + view02 + " (COL6) INCLUDE (COL1, COL2, COL3)");
            stmt.execute("CREATE VIEW " + view03 + " (VCOL3 CHAR(8), COL7 VARCHAR) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'col3'");
            stmt.execute("CREATE VIEW " + view04 + " (VCOL2 CHAR(10), COL6 VARCHAR) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'vcol4'");
            stmt.execute("CREATE INDEX " + index_view01 + " ON " + view01 + " (COL5) INCLUDE (COL1, COL2, COL3)");
        }
    }
}

