/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelStatsDisabledTest.class})
@RunWith(value=Parameterized.class)
public class VarBinaryEncoded1IT
extends ParallelStatsDisabledIT {
    private final String tableDDLOptions;
    private final boolean isBindStatement;

    public VarBinaryEncoded1IT(boolean columnEncoded, String transactionProvider, boolean mutable, boolean isBindStatement) {
        boolean transactional;
        StringBuilder optionBuilder = new StringBuilder();
        if (!columnEncoded) {
            if (optionBuilder.length() != 0) {
                optionBuilder.append(",");
            }
            optionBuilder.append("COLUMN_ENCODED_BYTES=0");
        }
        if (!mutable) {
            if (optionBuilder.length() != 0) {
                optionBuilder.append(",");
            }
            optionBuilder.append("IMMUTABLE_ROWS=true");
            if (!columnEncoded) {
                optionBuilder.append(",IMMUTABLE_STORAGE_SCHEME=" + PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN);
            }
        }
        boolean bl = transactional = transactionProvider != null;
        if (transactional) {
            if (optionBuilder.length() != 0) {
                optionBuilder.append(",");
            }
            optionBuilder.append(" TRANSACTIONAL=true,TRANSACTION_PROVIDER='" + transactionProvider + "'");
        }
        this.tableDDLOptions = optionBuilder.toString();
        this.isBindStatement = isBindStatement;
    }

    @Parameterized.Parameters(name="VarBinary1IT_columnEncoded={0}, transactionProvider={1}, mutable={2}")
    public static synchronized Collection<Object[]> data() {
        return Arrays.asList({false, null, false, false}, {false, "OMID", false, false}, {false, null, true, false}, {false, "OMID", true, false}, {true, null, false, false}, {true, "OMID", false, false}, {true, null, true, false}, {true, "OMID", true, false}, {false, null, false, true}, {false, "OMID", false, true}, {false, null, true, true}, {false, "OMID", true, true}, {true, null, false, true}, {true, "OMID", false, true}, {true, null, true, true}, {true, "OMID", true, true});
    }

    @Test
    public void testVarBinaryPkSchema1() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = VarBinaryEncoded1IT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(VarBinaryEncoded1IT.getUrl(), props);){
            PreparedStatement preparedStatement;
            conn.createStatement().execute("CREATE TABLE " + tableName + " (PK1 VARBINARY_ENCODED, PK2 VARBINARY_ENCODED, PK3 VARBINARY_ENCODED, COL1 VARBINARY_ENCODED, COL2 VARBINARY_ENCODED, COL3 VARBINARY_ENCODED CONSTRAINT pk PRIMARY KEY(PK1, PK2, PK3)) " + this.tableDDLOptions);
            byte[] b1 = new byte[]{1, 1, 19, -28, 24, 1, 1, -11, -21, 1};
            byte[] b2 = new byte[]{57, -83, 2, 83, -7, 12, -13, 4};
            byte[] b3 = new byte[]{4, 34, -19, 8, -73, 3, 4, 23};
            byte[] b4 = new byte[]{56, 50, 19, 34, 83, -101, -102, 91};
            byte[] b5 = new byte[]{10, 55, 19, -5, -34, 0, 0, 0, 0, 1};
            byte[] b6 = new byte[]{-11, 55, -119, 8, 0, 1, 2, -4, 33};
            byte[] b10 = new byte[]{1, 1, 19, -28, 25, -1, 1, -11, -21, -1};
            byte[] b20 = new byte[]{57, -83, -2, 83, 0, -7, -12, -13, 4};
            byte[] b30 = new byte[]{4, 1, -19, 8, 0, -73, 3, 4, 23};
            byte[] b40 = new byte[]{56, 50, 19, 34, 83, -101, -102, 91};
            byte[] b50 = new byte[]{10, 55, 19, -5, -34, 0, 0, 0, 0, 1};
            byte[] b60 = new byte[]{-11, 55, -119, 8, 0, 1, 2, -4, 33};
            byte[] b11 = new byte[]{1, 1, 20, -28, 0, -1, 0, -11, -21, -1};
            byte[] b21 = new byte[]{57, -83, 0, -2, 0, -7, -12, -13, 4};
            byte[] b31 = new byte[]{4, 1, 0, 0, 0, 73, 3, 0, 23};
            byte[] b41 = new byte[]{56, 50, 19, 0, 34, 83, -101, -102, 91};
            byte[] b51 = new byte[]{10, 55, 0, 19, -5, -34, 0, 0, 0, 0, 1};
            byte[] b61 = new byte[]{-11, 55, -119, 0, 8, 0, 1, 2, -4, 33};
            byte[] b12 = new byte[]{1, 1, 20, -28, 0, -1, 0, -11, -21, -1};
            byte[] b22 = new byte[]{57, -83, 0, -2, 0, -7, -12, -13, 4, 0};
            byte[] b32 = new byte[]{4, 1, 75, 0, 0, 73, 0, -24, 3, 0, 12, 99, 23};
            byte[] b42 = new byte[]{56, 50, 19, 0, 34, 83, -101, -102, 91};
            byte[] b52 = new byte[]{10, 55, 0, 19, -5, -34, 0, 0, 0, 0, 1};
            byte[] b62 = new byte[]{-11, 55, -119, 0, 8, 0, 1, 2, -4, 33};
            byte[] b13 = new byte[]{1, 1, 20, -28, 0, -1, 0, -11, -21, -1};
            byte[] b23 = new byte[]{57, -83, 0, -2, 0, -7, -12, -13, 4};
            byte[] b33 = new byte[]{4, 1, 0, 0, 0, 0, 22, 122, 48, -121, 73, 3, 0, 23};
            byte[] b43 = new byte[]{56, 50, 19, 0, 34, 83, -101, -102, 91, 92};
            byte[] b53 = new byte[]{10, 55, 0, 19, -5, -34, 0, -12, 0, 0, 0, 1};
            byte[] b63 = new byte[]{-11, 55, -119, 0, 8, 0, 1, 2, -4, 33};
            byte[] b14 = new byte[]{1, 1, 20, -28, 0, -1, 0, -11, -21, -1};
            byte[] b24 = null;
            byte[] b34 = new byte[]{5, 1, 0, 0, 0, 0, 22, 122, 48, -121, 73, 3, 0, 23};
            byte[] b44 = new byte[]{56, 50, 19, 0, 34, 83, -101, -102, 91, 92};
            byte[] b54 = new byte[]{10, 55, 0, 19, -5, -34, 0, -12, 0, 0, 0, 1};
            byte[] b64 = new byte[]{-11, 55, -119, 0, 8, 0, 1, 2, -4, 33};
            byte[] b15 = new byte[]{1, 1, 20, -28, 0, -1, 0, -11, -21, -1};
            byte[] b25 = new byte[]{57, -83, 0, -2, 0, -7, -12, -13, 4};
            byte[] b35 = null;
            byte[] b45 = new byte[]{56, 50, 19, 0, 34, 83, -101, -102, 91, 92};
            byte[] b55 = new byte[]{10, 55, 0, 19, -5, -34, 0, -12, 0, 0, 0, 1};
            byte[] b65 = new byte[]{-11, 55, -119, 0, 8, 0, 1, 2, -4, 33};
            try (PreparedStatement preparedStatement2 = conn.prepareStatement("UPSERT INTO " + tableName + "(PK1, PK2, PK3, COL1, COL2, COL3) VALUES (?, ?, ?, ?, ?, ?)");){
                VarBinaryEncoded1IT.upsertRow(preparedStatement2, Bytes.toBytes((String)"pk1-ehgir4jf"), Bytes.toBytes((String)"pk22p0jfdkhrgi"), Bytes.toBytes((String)"pk33ogjirhhf"), Bytes.toBytes((String)"col19fnbb0hf0t"), Bytes.toBytes((String)"col21048rnbfpe3-"), Bytes.toBytes((String)"col319efnrugifj"));
                VarBinaryEncoded1IT.upsertRow(preparedStatement2, b10, b20, b30, b40, b50, b60);
                VarBinaryEncoded1IT.upsertRow(preparedStatement2, b1, b2, b3, b4, b5, b6);
                VarBinaryEncoded1IT.upsertRow(preparedStatement2, b11, b21, b31, b41, b51, b61);
                VarBinaryEncoded1IT.upsertRow(preparedStatement2, b12, b22, b32, b42, b52, b62);
                VarBinaryEncoded1IT.upsertRow(preparedStatement2, b13, b23, b33, b43, b53, b63);
                VarBinaryEncoded1IT.upsertRow(preparedStatement2, b14, b24, b34, b44, b54, b64);
                VarBinaryEncoded1IT.upsertRow(preparedStatement2, b15, b25, b35, b45, b55, b65);
            }
            conn.commit();
            PreparedStatement pst = conn.prepareStatement("SELECT * FROM " + tableName);
            ResultSet resultSet = pst.executeQuery();
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b1, (byte[])resultSet.getBytes(1));
            Assert.assertArrayEquals((byte[])b2, (byte[])resultSet.getBytes(2));
            Assert.assertArrayEquals((byte[])b3, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b4, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b5, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b6, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b10, (byte[])resultSet.getBytes(1));
            Assert.assertArrayEquals((byte[])b20, (byte[])resultSet.getBytes(2));
            Assert.assertArrayEquals((byte[])b30, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b40, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b50, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b60, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b14, (byte[])resultSet.getBytes(1));
            Assert.assertNull((Object)resultSet.getBytes(2));
            Assert.assertArrayEquals((byte[])b34, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b44, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b54, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b64, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b15, (byte[])resultSet.getBytes(1));
            Assert.assertArrayEquals((byte[])b25, (byte[])resultSet.getBytes(2));
            Assert.assertNull((Object)resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b45, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b55, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b65, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b13, (byte[])resultSet.getBytes(1));
            Assert.assertArrayEquals((byte[])b23, (byte[])resultSet.getBytes(2));
            Assert.assertArrayEquals((byte[])b33, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b43, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b53, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b63, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b11, (byte[])resultSet.getBytes(1));
            Assert.assertArrayEquals((byte[])b21, (byte[])resultSet.getBytes(2));
            Assert.assertArrayEquals((byte[])b31, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b41, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b51, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b61, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b12, (byte[])resultSet.getBytes(1));
            Assert.assertArrayEquals((byte[])b22, (byte[])resultSet.getBytes(2));
            Assert.assertArrayEquals((byte[])b32, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b42, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b52, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b62, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"pk1-ehgir4jf"), (byte[])resultSet.getBytes(1));
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"pk22p0jfdkhrgi"), (byte[])resultSet.getBytes(2));
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"pk33ogjirhhf"), (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"col19fnbb0hf0t"), (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"col21048rnbfpe3-"), (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"col319efnrugifj"), (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
            if (this.isBindStatement) {
                preparedStatement = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE PK1 = ?");
                preparedStatement.setBytes(1, b11);
                resultSet = preparedStatement.executeQuery();
            } else {
                resultSet = conn.createStatement().executeQuery("SELECT * FROM " + tableName + " WHERE PK1 = " + PVarbinary.INSTANCE.toStringLiteral((Object)b11));
            }
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b14, (byte[])resultSet.getBytes(1));
            Assert.assertNull((Object)resultSet.getBytes(2));
            Assert.assertArrayEquals((byte[])b34, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b44, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b54, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b64, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b15, (byte[])resultSet.getBytes(1));
            Assert.assertArrayEquals((byte[])b25, (byte[])resultSet.getBytes(2));
            Assert.assertNull((Object)resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b45, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b55, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b65, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b13, (byte[])resultSet.getBytes(1));
            Assert.assertArrayEquals((byte[])b23, (byte[])resultSet.getBytes(2));
            Assert.assertArrayEquals((byte[])b33, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b43, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b53, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b63, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b11, (byte[])resultSet.getBytes(1));
            Assert.assertArrayEquals((byte[])b21, (byte[])resultSet.getBytes(2));
            Assert.assertArrayEquals((byte[])b31, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b41, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b51, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b61, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b12, (byte[])resultSet.getBytes(1));
            Assert.assertArrayEquals((byte[])b22, (byte[])resultSet.getBytes(2));
            Assert.assertArrayEquals((byte[])b32, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b42, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b52, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b62, (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
            if (this.isBindStatement) {
                preparedStatement = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE PK1 = ? AND PK2 IS NOT NULL ");
                preparedStatement.setBytes(1, b11);
                resultSet = preparedStatement.executeQuery();
            } else {
                resultSet = conn.createStatement().executeQuery("SELECT * FROM " + tableName + " WHERE PK1 = " + PVarbinary.INSTANCE.toStringLiteral((Object)b11) + " AND PK2 IS NOT NULL");
            }
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b15, (byte[])resultSet.getBytes(1));
            Assert.assertArrayEquals((byte[])b25, (byte[])resultSet.getBytes(2));
            Assert.assertNull((Object)resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b45, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b55, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b65, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b13, (byte[])resultSet.getBytes(1));
            Assert.assertArrayEquals((byte[])b23, (byte[])resultSet.getBytes(2));
            Assert.assertArrayEquals((byte[])b33, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b43, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b53, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b63, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b11, (byte[])resultSet.getBytes(1));
            Assert.assertArrayEquals((byte[])b21, (byte[])resultSet.getBytes(2));
            Assert.assertArrayEquals((byte[])b31, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b41, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b51, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b61, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b12, (byte[])resultSet.getBytes(1));
            Assert.assertArrayEquals((byte[])b22, (byte[])resultSet.getBytes(2));
            Assert.assertArrayEquals((byte[])b32, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b42, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b52, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b62, (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
            if (this.isBindStatement) {
                preparedStatement = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE PK1 = ? AND PK2 = ?");
                preparedStatement.setBytes(1, b11);
                preparedStatement.setBytes(2, b21);
                resultSet = preparedStatement.executeQuery();
            } else {
                resultSet = conn.createStatement().executeQuery("SELECT * FROM " + tableName + " WHERE PK1 = " + PVarbinary.INSTANCE.toStringLiteral((Object)b11) + " AND PK2 = " + PVarbinary.INSTANCE.toStringLiteral((Object)b21));
            }
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b15, (byte[])resultSet.getBytes(1));
            Assert.assertArrayEquals((byte[])b25, (byte[])resultSet.getBytes(2));
            Assert.assertNull((Object)resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b45, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b55, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b65, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b13, (byte[])resultSet.getBytes(1));
            Assert.assertArrayEquals((byte[])b23, (byte[])resultSet.getBytes(2));
            Assert.assertArrayEquals((byte[])b33, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b43, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b53, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b63, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b11, (byte[])resultSet.getBytes(1));
            Assert.assertArrayEquals((byte[])b21, (byte[])resultSet.getBytes(2));
            Assert.assertArrayEquals((byte[])b31, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b41, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b51, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b61, (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
            if (this.isBindStatement) {
                preparedStatement = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE PK1 = ? AND PK2 BETWEEN ? AND ? AND PK3 IS NOT NULL");
                preparedStatement.setBytes(1, b11);
                preparedStatement.setBytes(2, new byte[]{57, -83, 0, -2, 0, -7, -12, -13, 3, 24, -121});
                preparedStatement.setBytes(3, new byte[]{57, -83, 0, -2, 0, -7, -12, -13, 4});
                resultSet = preparedStatement.executeQuery();
            } else {
                resultSet = conn.createStatement().executeQuery("SELECT * FROM " + tableName + " WHERE PK1 = " + PVarbinary.INSTANCE.toStringLiteral((Object)b11) + " AND PK2 BETWEEN " + PVarbinary.INSTANCE.toStringLiteral((Object)new byte[]{57, -83, 0, -2, 0, -7, -12, -13, 3, 24, -121}) + " AND " + PVarbinary.INSTANCE.toStringLiteral((Object)new byte[]{57, -83, 0, -2, 0, -7, -12, -13, 4}) + " AND PK3 IS NOT NULL");
            }
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b13, (byte[])resultSet.getBytes(1));
            Assert.assertArrayEquals((byte[])b23, (byte[])resultSet.getBytes(2));
            Assert.assertArrayEquals((byte[])b33, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b43, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b53, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b63, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b11, (byte[])resultSet.getBytes(1));
            Assert.assertArrayEquals((byte[])b21, (byte[])resultSet.getBytes(2));
            Assert.assertArrayEquals((byte[])b31, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b41, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b51, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b61, (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
            if (this.isBindStatement) {
                preparedStatement = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE PK1 = ? AND PK2 IN (?, ?, ?)");
                preparedStatement.setBytes(1, b11);
                preparedStatement.setBytes(2, b21);
                preparedStatement.setBytes(3, b23);
                preparedStatement.setBytes(4, b22);
                resultSet = preparedStatement.executeQuery();
            } else {
                resultSet = conn.createStatement().executeQuery("SELECT * FROM " + tableName + " WHERE PK1 = " + PVarbinary.INSTANCE.toStringLiteral((Object)b11) + " AND PK2 IN (" + PVarbinary.INSTANCE.toStringLiteral((Object)b21) + ", " + PVarbinary.INSTANCE.toStringLiteral((Object)b23) + ", " + PVarbinary.INSTANCE.toStringLiteral((Object)b22) + ")");
            }
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b15, (byte[])resultSet.getBytes(1));
            Assert.assertArrayEquals((byte[])b25, (byte[])resultSet.getBytes(2));
            Assert.assertArrayEquals(b35, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b45, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b55, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b65, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b13, (byte[])resultSet.getBytes(1));
            Assert.assertArrayEquals((byte[])b23, (byte[])resultSet.getBytes(2));
            Assert.assertArrayEquals((byte[])b33, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b43, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b53, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b63, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b11, (byte[])resultSet.getBytes(1));
            Assert.assertArrayEquals((byte[])b21, (byte[])resultSet.getBytes(2));
            Assert.assertArrayEquals((byte[])b31, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b41, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b51, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b61, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b12, (byte[])resultSet.getBytes(1));
            Assert.assertArrayEquals((byte[])b22, (byte[])resultSet.getBytes(2));
            Assert.assertArrayEquals((byte[])b32, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b42, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b52, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b62, (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
            if (this.isBindStatement) {
                preparedStatement = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE PK1 = ? AND PK2 = ? AND PK3 = ?");
                preparedStatement.setBytes(1, b11);
                preparedStatement.setBytes(2, b21);
                preparedStatement.setBytes(3, b31);
                resultSet = preparedStatement.executeQuery();
            } else {
                resultSet = conn.createStatement().executeQuery("SELECT * FROM " + tableName + " WHERE PK1 = " + PVarbinary.INSTANCE.toStringLiteral((Object)b11) + " AND PK2 = " + PVarbinary.INSTANCE.toStringLiteral((Object)b21) + " AND PK3 = " + PVarbinary.INSTANCE.toStringLiteral((Object)b31));
            }
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b11, (byte[])resultSet.getBytes(1));
            Assert.assertArrayEquals((byte[])b21, (byte[])resultSet.getBytes(2));
            Assert.assertArrayEquals((byte[])b31, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b41, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b51, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b61, (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
            if (this.isBindStatement) {
                preparedStatement = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE PK1 = ? AND PK2 = ? AND PK3 IS NULL");
                preparedStatement.setBytes(1, b11);
                preparedStatement.setBytes(2, b21);
                resultSet = preparedStatement.executeQuery();
            } else {
                resultSet = conn.createStatement().executeQuery("SELECT * FROM " + tableName + " WHERE PK1 = " + PVarbinary.INSTANCE.toStringLiteral((Object)b11) + " AND PK2 = " + PVarbinary.INSTANCE.toStringLiteral((Object)b21) + " AND PK3 IS NULL");
            }
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b15, (byte[])resultSet.getBytes(1));
            Assert.assertArrayEquals((byte[])b25, (byte[])resultSet.getBytes(2));
            Assert.assertNull((Object)resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b45, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b55, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b65, (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
        }
    }

    private static void upsertRow(PreparedStatement preparedStatement, byte[] b1, byte[] b2, byte[] b3, byte[] b4, byte[] b5, byte[] b6) throws SQLException {
        preparedStatement.setBytes(1, b1);
        preparedStatement.setBytes(2, b2);
        preparedStatement.setBytes(3, b3);
        preparedStatement.setBytes(4, b4);
        preparedStatement.setBytes(5, b5);
        preparedStatement.setBytes(6, b6);
        preparedStatement.executeUpdate();
    }

    @Test
    public void testVarBinaryPkSchema2() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = VarBinaryEncoded1IT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(VarBinaryEncoded1IT.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE " + tableName + " (PK1 VARBINARY_ENCODED, PK2 VARBINARY_ENCODED, PK3 VARBINARY_ENCODED, COL1 VARBINARY_ENCODED, COL2 VARBINARY_ENCODED, COL3 VARBINARY_ENCODED CONSTRAINT pk PRIMARY KEY(PK1 DESC, PK2 DESC, PK3 DESC)) " + this.tableDDLOptions);
            byte[] b1 = new byte[]{1, 1, 19, -28, 24, 1, 1, -11, -21, 1};
            byte[] b2 = new byte[]{57, -83, 2, 83, -7, 12, -13, 4};
            byte[] b3 = new byte[]{4, 34, -19, 8, -73, 3, 4, 23};
            byte[] b4 = new byte[]{56, 50, 19, 34, 83, -101, -102, 91};
            byte[] b5 = new byte[]{10, 55, 19, -5, -34, 0, 0, 0, 0, 1};
            byte[] b6 = new byte[]{-11, 55, -119, 8, 0, 1, 2, -4, 33};
            byte[] b10 = new byte[]{1, 1, 19, -28, 25, -1, 1, -11, -21, -1};
            byte[] b20 = new byte[]{57, -83, -2, 83, 0, -7, -12, -13, 4};
            byte[] b30 = new byte[]{4, 1, -19, 8, 0, -73, 3, 4, 23};
            byte[] b40 = new byte[]{56, 50, 19, 34, 83, -101, -102, 91};
            byte[] b50 = new byte[]{10, 55, 19, -5, -34, 0, 0, 0, 0, 1};
            byte[] b60 = new byte[]{-11, 55, -119, 8, 0, 1, 2, -4, 33};
            byte[] b11 = new byte[]{1, 1, 20, -28, 0, -1, 0, -11, -21, -1};
            byte[] b21 = new byte[]{57, -83, 0, -2, 0, -7, -12, -13, 4};
            byte[] b31 = new byte[]{4, 1, 0, 0, 0, 73, 3, 0, 23};
            byte[] b41 = new byte[]{56, 50, 19, 0, 34, 83, -101, -102, 91};
            byte[] b51 = new byte[]{10, 55, 0, 19, -5, -34, 0, 0, 0, 0, 1};
            byte[] b61 = new byte[]{-11, 55, -119, 0, 8, 0, 1, 2, -4, 33};
            try (PreparedStatement preparedStatement = conn.prepareStatement("UPSERT INTO " + tableName + "(PK1, PK2, PK3, COL1, COL2, COL3) VALUES (?, ?, ?, ?, ?, ?)");){
                VarBinaryEncoded1IT.upsertRow(preparedStatement, Bytes.toBytes((String)"pk1-ehgir4jf"), Bytes.toBytes((String)"pk22p0jfdkhrgi"), Bytes.toBytes((String)"pk33ogjirhhf"), Bytes.toBytes((String)"col19fnbb0hf0t"), Bytes.toBytes((String)"col21048rnbfpe3-"), Bytes.toBytes((String)"col319efnrugifj"));
                VarBinaryEncoded1IT.upsertRow(preparedStatement, b10, b20, b30, b40, b50, b60);
                VarBinaryEncoded1IT.upsertRow(preparedStatement, b1, b2, b3, b4, b5, b6);
                VarBinaryEncoded1IT.upsertRow(preparedStatement, b11, b21, b31, b41, b51, b61);
            }
            conn.commit();
            ResultSet resultSet = conn.createStatement().executeQuery("SELECT * FROM " + tableName);
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"pk1-ehgir4jf"), (byte[])resultSet.getBytes(1));
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"pk22p0jfdkhrgi"), (byte[])resultSet.getBytes(2));
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"pk33ogjirhhf"), (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"col19fnbb0hf0t"), (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"col21048rnbfpe3-"), (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"col319efnrugifj"), (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b11, (byte[])resultSet.getBytes(1));
            Assert.assertArrayEquals((byte[])b21, (byte[])resultSet.getBytes(2));
            Assert.assertArrayEquals((byte[])b31, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b41, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b51, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b61, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b10, (byte[])resultSet.getBytes(1));
            Assert.assertArrayEquals((byte[])b20, (byte[])resultSet.getBytes(2));
            Assert.assertArrayEquals((byte[])b30, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b40, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b50, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b60, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b1, (byte[])resultSet.getBytes(1));
            Assert.assertArrayEquals((byte[])b2, (byte[])resultSet.getBytes(2));
            Assert.assertArrayEquals((byte[])b3, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b4, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b5, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b6, (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
        }
    }

    @Test
    public void testVarBinaryPkSchema3() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = VarBinaryEncoded1IT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(VarBinaryEncoded1IT.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE " + tableName + " (PK1 VARBINARY_ENCODED, PK2 VARBINARY_ENCODED, PK3 VARBINARY_ENCODED, COL1 VARBINARY_ENCODED, COL2 VARBINARY_ENCODED, COL3 VARBINARY_ENCODED CONSTRAINT pk PRIMARY KEY(PK1 DESC, PK2 ASC, PK3 DESC)) " + this.tableDDLOptions);
            byte[] b1 = new byte[]{1, 1, 19, -28, 24, 1, 1, -11, -21, 1};
            byte[] b2 = new byte[]{57, -83, 2, 83, -7, 12, -13, 4};
            byte[] b3 = new byte[]{4, 34, -19, 8, -73, 3, 4, 23};
            byte[] b4 = new byte[]{56, 50, 19, 34, 83, -101, -102, 91};
            byte[] b5 = new byte[]{10, 55, 19, -5, -34, 0, 0, 0, 0, 1};
            byte[] b6 = new byte[]{-11, 55, -119, 8, 0, 1, 2, -4, 33};
            byte[] b10 = new byte[]{1, 1, 19, -28, 25, -1, 1, -11, -21, -1};
            byte[] b20 = new byte[]{57, -83, -2, 83, 0, -7, -12, -13, 4};
            byte[] b30 = new byte[]{4, 1, -19, 8, 0, -73, 3, 4, 23};
            byte[] b40 = new byte[]{56, 50, 19, 34, 83, -101, -102, 91};
            byte[] b50 = new byte[]{10, 55, 19, -5, -34, 0, 0, 0, 0, 1};
            byte[] b60 = new byte[]{-11, 55, -119, 8, 0, 1, 2, -4, 33};
            byte[] b11 = new byte[]{1, 1, 20, -28, 0, -1, 0, -11, -21, -1};
            byte[] b21 = new byte[]{57, -83, 0, -2, 0, -7, -12, -13, 4};
            byte[] b31 = new byte[]{4, 1, 0, 0, 0, 73, 3, 0, 23};
            byte[] b41 = new byte[]{56, 50, 19, 0, 34, 83, -101, -102, 91};
            byte[] b51 = new byte[]{10, 55, 0, 19, -5, -34, 0, 0, 0, 0, 1};
            byte[] b61 = new byte[]{-11, 55, -119, 0, 8, 0, 1, 2, -4, 33};
            try (PreparedStatement preparedStatement = conn.prepareStatement("UPSERT INTO " + tableName + "(PK1, PK2, PK3, COL1, COL2, COL3) VALUES (?, ?, ?, ?, ?, ?)");){
                VarBinaryEncoded1IT.upsertRow(preparedStatement, Bytes.toBytes((String)"pk1-ehgir4jf"), Bytes.toBytes((String)"pk22p0jfdkhrgi"), Bytes.toBytes((String)"pk33ogjirhhf"), Bytes.toBytes((String)"col19fnbb0hf0t"), Bytes.toBytes((String)"col21048rnbfpe3-"), Bytes.toBytes((String)"col319efnrugifj"));
                VarBinaryEncoded1IT.upsertRow(preparedStatement, b10, b20, b30, b40, b50, b60);
                VarBinaryEncoded1IT.upsertRow(preparedStatement, b1, b2, b3, b4, b5, b6);
                VarBinaryEncoded1IT.upsertRow(preparedStatement, b11, b21, b31, b41, b51, b61);
            }
            conn.commit();
            ResultSet resultSet = conn.createStatement().executeQuery("SELECT * FROM " + tableName);
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"pk1-ehgir4jf"), (byte[])resultSet.getBytes(1));
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"pk22p0jfdkhrgi"), (byte[])resultSet.getBytes(2));
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"pk33ogjirhhf"), (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"col19fnbb0hf0t"), (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"col21048rnbfpe3-"), (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"col319efnrugifj"), (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b11, (byte[])resultSet.getBytes(1));
            Assert.assertArrayEquals((byte[])b21, (byte[])resultSet.getBytes(2));
            Assert.assertArrayEquals((byte[])b31, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b41, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b51, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b61, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b10, (byte[])resultSet.getBytes(1));
            Assert.assertArrayEquals((byte[])b20, (byte[])resultSet.getBytes(2));
            Assert.assertArrayEquals((byte[])b30, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b40, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b50, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b60, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b1, (byte[])resultSet.getBytes(1));
            Assert.assertArrayEquals((byte[])b2, (byte[])resultSet.getBytes(2));
            Assert.assertArrayEquals((byte[])b3, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b4, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b5, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b6, (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
        }
    }

    @Test
    public void testVarBinaryPkSchema4() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = VarBinaryEncoded1IT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(VarBinaryEncoded1IT.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE " + tableName + " (PK1 VARBINARY_ENCODED, PK2 VARCHAR, PK3 VARBINARY_ENCODED, COL1 VARBINARY_ENCODED, COL2 VARBINARY_ENCODED, COL3 VARBINARY_ENCODED CONSTRAINT pk PRIMARY KEY(PK1, PK2, PK3)) " + this.tableDDLOptions);
            byte[] b1 = new byte[]{1, 1, 19, -28, 24, 1, 1, -11, -21, 1};
            String b2 = "OfMOvIIuXZddTZ0VOkyAlPhdm";
            byte[] b3 = new byte[]{4, 34, -19, 8, -73, 3, 4, 23};
            byte[] b4 = new byte[]{56, 50, 19, 34, 83, -101, -102, 91};
            byte[] b5 = new byte[]{10, 55, 19, -5, -34, 0, 0, 0, 0, 1};
            byte[] b6 = new byte[]{-11, 55, -119, 8, 0, 1, 2, -4, 33};
            byte[] b10 = new byte[]{1, 1, 19, -28, 25, -1, 1, -11, -21, -1};
            String b20 = "OfMOpvIIuXZddTZ0VOkyAlPhdm";
            byte[] b30 = new byte[]{4, 1, -19, 8, 0, -73, 3, 4, 23};
            byte[] b40 = new byte[]{56, 50, 19, 34, 83, -101, -102, 91};
            byte[] b50 = new byte[]{10, 55, 19, -5, -34, 0, 0, 0, 0, 1};
            byte[] b60 = new byte[]{-11, 55, -119, 8, 0, 1, 2, -4, 33};
            byte[] b11 = new byte[]{1, 1, 20, -28, 0, -1, 0, -11, -21, -1};
            String b21 = "OfMOqvIIuXZddTZ0VOkyAlPhdm";
            byte[] b31 = new byte[]{4, 1, 0, 0, 0, 73, 3, 0, 23};
            byte[] b41 = new byte[]{56, 50, 19, 0, 34, 83, -101, -102, 91};
            byte[] b51 = new byte[]{10, 55, 0, 19, -5, -34, 0, 0, 0, 0, 1};
            byte[] b61 = new byte[]{-11, 55, -119, 0, 8, 0, 1, 2, -4, 33};
            byte[] b12 = new byte[]{1, 1, 20, -28, 0, -1, 0, -11, -21, -1};
            String b22 = "OfMOqvIIuXZddTZ0VOkyAlPhdma";
            byte[] b32 = new byte[]{4, 1, 75, 0, 0, 73, 0, -24, 3, 0, 12, 99, 23};
            byte[] b42 = new byte[]{56, 50, 19, 0, 34, 83, -101, -102, 91};
            byte[] b52 = new byte[]{10, 55, 0, 19, -5, -34, 0, 0, 0, 0, 1};
            byte[] b62 = new byte[]{-11, 55, -119, 0, 8, 0, 1, 2, -4, 33};
            byte[] b13 = new byte[]{1, 1, 20, -28, 0, -1, 0, -11, -21, -1};
            String b23 = "OfMOqvIIuXZddTZ0VOkyAlPhdm";
            byte[] b33 = new byte[]{4, 1, 0, 0, 0, 0, 22, 122, 48, -121, 73, 3, 0, 23};
            byte[] b43 = new byte[]{56, 50, 19, 0, 34, 83, -101, -102, 91, 92};
            byte[] b53 = new byte[]{10, 55, 0, 19, -5, -34, 0, -12, 0, 0, 0, 1};
            byte[] b63 = new byte[]{-11, 55, -119, 0, 8, 0, 1, 2, -4, 33};
            byte[] b14 = new byte[]{1, 1, 20, -28, 0, -1, 0, -11, -21, -1};
            String b24 = null;
            byte[] b34 = new byte[]{5, 1, 0, 0, 0, 0, 22, 122, 48, -121, 73, 3, 0, 23};
            byte[] b44 = new byte[]{56, 50, 19, 0, 34, 83, -101, -102, 91, 92};
            byte[] b54 = new byte[]{10, 55, 0, 19, -5, -34, 0, -12, 0, 0, 0, 1};
            byte[] b64 = new byte[]{-11, 55, -119, 0, 8, 0, 1, 2, -4, 33};
            byte[] b15 = new byte[]{1, 1, 20, -28, 0, -1, 0, -11, -21, -1};
            String b25 = "OfMOqvIIuXZddTZ0VOkyAlPhdm";
            byte[] b35 = null;
            byte[] b45 = new byte[]{56, 50, 19, 0, 34, 83, -101, -102, 91, 92};
            byte[] b55 = new byte[]{10, 55, 0, 19, -5, -34, 0, -12, 0, 0, 0, 1};
            byte[] b65 = new byte[]{-11, 55, -119, 0, 8, 0, 1, 2, -4, 33};
            try (PreparedStatement preparedStatement = conn.prepareStatement("UPSERT INTO " + tableName + "(PK1, PK2, PK3, COL1, COL2, COL3) VALUES (?, ?, ?, ?, ?, ?)");){
                VarBinaryEncoded1IT.upsertRow(preparedStatement, Bytes.toBytes((String)"pk1-ehgir4jf"), "pk22p0jfdkhrgi", Bytes.toBytes((String)"pk33ogjirhhf"), Bytes.toBytes((String)"col19fnbb0hf0t"), Bytes.toBytes((String)"col21048rnbfpe3-"), Bytes.toBytes((String)"col319efnrugifj"));
                VarBinaryEncoded1IT.upsertRow(preparedStatement, b10, b20, b30, b40, b50, b60);
                VarBinaryEncoded1IT.upsertRow(preparedStatement, b1, b2, b3, b4, b5, b6);
                VarBinaryEncoded1IT.upsertRow(preparedStatement, b11, b21, b31, b41, b51, b61);
                VarBinaryEncoded1IT.upsertRow(preparedStatement, b12, b22, b32, b42, b52, b62);
                VarBinaryEncoded1IT.upsertRow(preparedStatement, b13, b23, b33, b43, b53, b63);
                VarBinaryEncoded1IT.upsertRow(preparedStatement, b14, b24, b34, b44, b54, b64);
                VarBinaryEncoded1IT.upsertRow(preparedStatement, b15, b25, b35, b45, b55, b65);
            }
            conn.commit();
            PreparedStatement pst = conn.prepareStatement("SELECT * FROM " + tableName);
            ResultSet resultSet = pst.executeQuery();
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b1, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((Object)b2, (Object)resultSet.getString(2));
            Assert.assertArrayEquals((byte[])b3, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b4, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b5, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b6, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b10, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((Object)b20, (Object)resultSet.getString(2));
            Assert.assertArrayEquals((byte[])b30, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b40, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b50, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b60, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b14, (byte[])resultSet.getBytes(1));
            Assert.assertNull((Object)resultSet.getBytes(2));
            Assert.assertArrayEquals((byte[])b34, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b44, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b54, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b64, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b15, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((Object)b25, (Object)resultSet.getString(2));
            Assert.assertNull((Object)resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b45, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b55, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b65, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b13, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((Object)b23, (Object)resultSet.getString(2));
            Assert.assertArrayEquals((byte[])b33, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b43, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b53, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b63, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b11, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((Object)b21, (Object)resultSet.getString(2));
            Assert.assertArrayEquals((byte[])b31, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b41, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b51, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b61, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b12, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((Object)b22, (Object)resultSet.getString(2));
            Assert.assertArrayEquals((byte[])b32, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b42, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b52, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b62, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"pk1-ehgir4jf"), (byte[])resultSet.getBytes(1));
            Assert.assertEquals((Object)"pk22p0jfdkhrgi", (Object)resultSet.getString(2));
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"pk33ogjirhhf"), (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"col19fnbb0hf0t"), (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"col21048rnbfpe3-"), (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"col319efnrugifj"), (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
            PreparedStatement preparedStatement = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE PK1 = ?");
            preparedStatement.setBytes(1, b11);
            resultSet = preparedStatement.executeQuery();
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b14, (byte[])resultSet.getBytes(1));
            Assert.assertNull((Object)resultSet.getBytes(2));
            Assert.assertArrayEquals((byte[])b34, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b44, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b54, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b64, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b15, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((Object)b25, (Object)resultSet.getString(2));
            Assert.assertNull((Object)resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b45, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b55, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b65, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b13, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((Object)b23, (Object)resultSet.getString(2));
            Assert.assertArrayEquals((byte[])b33, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b43, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b53, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b63, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b11, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((Object)b21, (Object)resultSet.getString(2));
            Assert.assertArrayEquals((byte[])b31, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b41, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b51, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b61, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b12, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((Object)b22, (Object)resultSet.getString(2));
            Assert.assertArrayEquals((byte[])b32, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b42, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b52, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b62, (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
            preparedStatement = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE PK1 = ? AND PK2 IS NOT NULL ");
            preparedStatement.setBytes(1, b11);
            resultSet = preparedStatement.executeQuery();
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b15, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((Object)b25, (Object)resultSet.getString(2));
            Assert.assertNull((Object)resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b45, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b55, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b65, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b13, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((Object)b23, (Object)resultSet.getString(2));
            Assert.assertArrayEquals((byte[])b33, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b43, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b53, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b63, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b11, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((Object)b21, (Object)resultSet.getString(2));
            Assert.assertArrayEquals((byte[])b31, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b41, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b51, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b61, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b12, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((Object)b22, (Object)resultSet.getString(2));
            Assert.assertArrayEquals((byte[])b32, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b42, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b52, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b62, (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
            preparedStatement = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE PK1 = ? AND PK2 = ?");
            preparedStatement.setBytes(1, b11);
            preparedStatement.setString(2, b21);
            resultSet = preparedStatement.executeQuery();
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b15, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((Object)b25, (Object)resultSet.getString(2));
            Assert.assertNull((Object)resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b45, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b55, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b65, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b13, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((Object)b23, (Object)resultSet.getString(2));
            Assert.assertArrayEquals((byte[])b33, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b43, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b53, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b63, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b11, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((Object)b21, (Object)resultSet.getString(2));
            Assert.assertArrayEquals((byte[])b31, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b41, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b51, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b61, (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
            preparedStatement = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE PK1 = ? AND PK2 BETWEEN ? AND ? AND PK3 IS NOT NULL");
            preparedStatement.setBytes(1, b11);
            preparedStatement.setString(2, "OfMOqvIIuXZddTZ0VOkyAlPhcAB193hfo");
            preparedStatement.setString(3, "OfMOqvIIuXZddTZ0VOkyAlPhdm");
            resultSet = preparedStatement.executeQuery();
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b13, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((Object)b23, (Object)resultSet.getString(2));
            Assert.assertArrayEquals((byte[])b33, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b43, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b53, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b63, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b11, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((Object)b21, (Object)resultSet.getString(2));
            Assert.assertArrayEquals((byte[])b31, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b41, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b51, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b61, (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
            preparedStatement = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE PK1 = ? AND PK2 IN (?, ?, ?)");
            preparedStatement.setBytes(1, b11);
            preparedStatement.setString(2, b21);
            preparedStatement.setString(3, b23);
            preparedStatement.setString(4, b22);
            resultSet = preparedStatement.executeQuery();
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b15, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((Object)b25, (Object)resultSet.getString(2));
            Assert.assertArrayEquals(b35, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b45, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b55, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b65, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b13, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((Object)b23, (Object)resultSet.getString(2));
            Assert.assertArrayEquals((byte[])b33, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b43, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b53, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b63, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b11, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((Object)b21, (Object)resultSet.getString(2));
            Assert.assertArrayEquals((byte[])b31, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b41, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b51, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b61, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b12, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((Object)b22, (Object)resultSet.getString(2));
            Assert.assertArrayEquals((byte[])b32, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b42, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b52, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b62, (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
            preparedStatement = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE PK1 = ? AND PK2 = ? AND PK3 = ?");
            preparedStatement.setBytes(1, b11);
            preparedStatement.setString(2, b21);
            preparedStatement.setBytes(3, b31);
            resultSet = preparedStatement.executeQuery();
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b11, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((Object)b21, (Object)resultSet.getString(2));
            Assert.assertArrayEquals((byte[])b31, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b41, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b51, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b61, (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
            preparedStatement = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE PK1 = ? AND PK2 = ? AND PK3 IS NULL");
            preparedStatement.setBytes(1, b11);
            preparedStatement.setString(2, b21);
            resultSet = preparedStatement.executeQuery();
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b15, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((Object)b25, (Object)resultSet.getString(2));
            Assert.assertNull((Object)resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b45, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b55, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b65, (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
        }
    }

    @Test
    public void testVarBinaryPkSchema5() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = VarBinaryEncoded1IT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(VarBinaryEncoded1IT.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE " + tableName + " (PK1 VARCHAR, PK2 VARBINARY_ENCODED, PK3 VARCHAR, COL1 VARBINARY_ENCODED, COL2 VARBINARY_ENCODED, COL3 VARBINARY_ENCODED CONSTRAINT pk PRIMARY KEY(PK1, PK2, PK3)) " + this.tableDDLOptions);
            String b1 = "Rq1MxfBzM8DaPIjTamS94s9KbaC098Tou4V7kj4nQJ7YwiNBmfS5lg1WGE83s1z0";
            byte[] b2 = new byte[]{57, -83, 2, 83, -7, 12, -13, 4};
            String b3 = "RTHsOtc26ErkbgPDtTvsQl9M0fLOGQ6b";
            byte[] b4 = new byte[]{56, 50, 19, 34, 83, -101, -102, 91};
            byte[] b5 = new byte[]{10, 55, 19, -5, -34, 0, 0, 0, 0, 1};
            byte[] b6 = new byte[]{-11, 55, -119, 8, 0, 1, 2, -4, 33};
            String b10 = "Rq1MxfBzM8DaPIjTamS94s9KbaC098Uou4V7kj4nQJ7YwiNBmfS5lg1WGE83s1z0";
            byte[] b20 = new byte[]{57, -83, -2, 83, 0, -7, -12, -13, 4};
            String b30 = "YfDgzIC56WYUzouTGGISJdB4egYpmqbt";
            byte[] b40 = new byte[]{56, 50, 19, 34, 83, -101, -102, 91};
            byte[] b50 = new byte[]{10, 55, 19, -5, -34, 0, 0, 0, 0, 1};
            byte[] b60 = new byte[]{-11, 55, -119, 8, 0, 1, 2, -4, 33};
            String b11 = "Rq1MxfBzM8HDaPIjTamS94s9KbaC098Uou4V7kj4nQJ7YwiNBmfS5lg1WGE83s1z0";
            byte[] b21 = new byte[]{57, -83, 0, -2, 0, -7, -12, -13, 4};
            String b31 = "waWm2saGCnR8uE9fd0kww23947fu9@#54zGVOHoE0w4";
            byte[] b41 = new byte[]{56, 50, 19, 0, 34, 83, -101, -102, 91};
            byte[] b51 = new byte[]{10, 55, 0, 19, -5, -34, 0, 0, 0, 0, 1};
            byte[] b61 = new byte[]{-11, 55, -119, 0, 8, 0, 1, 2, -4, 33};
            String b12 = "Rq1MxfBzM8HDaPIjTamS94s9KbaC098Uou4V7kj4nQJ7YwiNBmfS5lg1WGE83s1z0";
            byte[] b22 = new byte[]{57, -83, 0, -2, 0, -7, -12, -13, 4, 0};
            String b32 = "u4V7kj4nQJ7YwiNBmfS5lg1WGE83s1z0";
            byte[] b42 = new byte[]{56, 50, 19, 0, 34, 83, -101, -102, 91};
            byte[] b52 = new byte[]{10, 55, 0, 19, -5, -34, 0, 0, 0, 0, 1};
            byte[] b62 = new byte[]{-11, 55, -119, 0, 8, 0, 1, 2, -4, 33};
            String b13 = "Rq1MxfBzM8HDaPIjTamS94s9KbaC098Uou4V7kj4nQJ7YwiNBmfS5lg1WGE83s1z0";
            byte[] b23 = new byte[]{57, -83, 0, -2, 0, -7, -12, -13, 4};
            String b33 = "fV5EeHtPbrEd92iNh7dnVJctScCT2jvP";
            byte[] b43 = new byte[]{56, 50, 19, 0, 34, 83, -101, -102, 91, 92};
            byte[] b53 = new byte[]{10, 55, 0, 19, -5, -34, 0, -12, 0, 0, 0, 1};
            byte[] b63 = new byte[]{-11, 55, -119, 0, 8, 0, 1, 2, -4, 33};
            String b14 = "Rq1MxfBzM8HDaPIjTamS94s9KbaC098Uou4V7kj4nQJ7YwiNBmfS5lg1WGE83s1z0";
            byte[] b24 = null;
            String b34 = "ifgTLSG0IlTqjmzN3rp0!@#%c93%^8Yu4d56NRNTHYbuR";
            byte[] b44 = new byte[]{56, 50, 19, 0, 34, 83, -101, -102, 91, 92};
            byte[] b54 = new byte[]{10, 55, 0, 19, -5, -34, 0, -12, 0, 0, 0, 1};
            byte[] b64 = new byte[]{-11, 55, -119, 0, 8, 0, 1, 2, -4, 33};
            String b15 = "Rq1MxfBzM8HDaPIjTamS94s9KbaC098Uou4V7kj4nQJ7YwiNBmfS5lg1WGE83s1z0";
            byte[] b25 = new byte[]{57, -83, 0, -2, 0, -7, -12, -13, 4};
            String b35 = null;
            byte[] b45 = new byte[]{56, 50, 19, 0, 34, 83, -101, -102, 91, 92};
            byte[] b55 = new byte[]{10, 55, 0, 19, -5, -34, 0, -12, 0, 0, 0, 1};
            byte[] b65 = new byte[]{-11, 55, -119, 0, 8, 0, 1, 2, -4, 33};
            try (PreparedStatement preparedStatement = conn.prepareStatement("UPSERT INTO " + tableName + "(PK1, PK2, PK3, COL1, COL2, COL3) VALUES (?, ?, ?, ?, ?, ?)");){
                VarBinaryEncoded1IT.upsertRow(preparedStatement, "pk1-ehgir4jf", Bytes.toBytes((String)"pk22p0jfdkhrgi"), "pk33ogjirhhf", Bytes.toBytes((String)"col19fnbb0hf0t"), Bytes.toBytes((String)"col21048rnbfpe3-"), Bytes.toBytes((String)"col319efnrugifj"));
                VarBinaryEncoded1IT.upsertRow(preparedStatement, b10, b20, b30, b40, b50, b60);
                VarBinaryEncoded1IT.upsertRow(preparedStatement, b1, b2, b3, b4, b5, b6);
                VarBinaryEncoded1IT.upsertRow(preparedStatement, b11, b21, b31, b41, b51, b61);
                VarBinaryEncoded1IT.upsertRow(preparedStatement, b12, b22, b32, b42, b52, b62);
                VarBinaryEncoded1IT.upsertRow(preparedStatement, b13, b23, b33, b43, b53, b63);
                VarBinaryEncoded1IT.upsertRow(preparedStatement, b14, b24, b34, b44, b54, b64);
                VarBinaryEncoded1IT.upsertRow(preparedStatement, b15, b25, b35, b45, b55, b65);
            }
            conn.commit();
            PreparedStatement pst = conn.prepareStatement("SELECT * FROM " + tableName);
            ResultSet resultSet = pst.executeQuery();
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)b1, (Object)resultSet.getString(1));
            Assert.assertArrayEquals((byte[])b2, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((Object)b3, (Object)resultSet.getString(3));
            Assert.assertArrayEquals((byte[])b4, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b5, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b6, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)b10, (Object)resultSet.getString(1));
            Assert.assertArrayEquals((byte[])b20, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((Object)b30, (Object)resultSet.getString(3));
            Assert.assertArrayEquals((byte[])b40, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b50, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b60, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)b14, (Object)resultSet.getString(1));
            Assert.assertNull((Object)resultSet.getBytes(2));
            Assert.assertEquals((Object)b34, (Object)resultSet.getString(3));
            Assert.assertArrayEquals((byte[])b44, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b54, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b64, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)b15, (Object)resultSet.getString(1));
            Assert.assertArrayEquals((byte[])b25, (byte[])resultSet.getBytes(2));
            Assert.assertNull((Object)resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b45, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b55, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b65, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)b13, (Object)resultSet.getString(1));
            Assert.assertArrayEquals((byte[])b23, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((Object)b33, (Object)resultSet.getString(3));
            Assert.assertArrayEquals((byte[])b43, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b53, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b63, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)b11, (Object)resultSet.getString(1));
            Assert.assertArrayEquals((byte[])b21, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((Object)b31, (Object)resultSet.getString(3));
            Assert.assertArrayEquals((byte[])b41, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b51, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b61, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)b12, (Object)resultSet.getString(1));
            Assert.assertArrayEquals((byte[])b22, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((Object)b32, (Object)resultSet.getString(3));
            Assert.assertArrayEquals((byte[])b42, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b52, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b62, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)"pk1-ehgir4jf", (Object)resultSet.getString(1));
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"pk22p0jfdkhrgi"), (byte[])resultSet.getBytes(2));
            Assert.assertEquals((Object)"pk33ogjirhhf", (Object)resultSet.getString(3));
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"col19fnbb0hf0t"), (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"col21048rnbfpe3-"), (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"col319efnrugifj"), (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
            PreparedStatement preparedStatement = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE PK1 = ?");
            preparedStatement.setString(1, b11);
            resultSet = preparedStatement.executeQuery();
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)b14, (Object)resultSet.getString(1));
            Assert.assertNull((Object)resultSet.getBytes(2));
            Assert.assertEquals((Object)b34, (Object)resultSet.getString(3));
            Assert.assertArrayEquals((byte[])b44, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b54, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b64, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)b15, (Object)resultSet.getString(1));
            Assert.assertArrayEquals((byte[])b25, (byte[])resultSet.getBytes(2));
            Assert.assertNull((Object)resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b45, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b55, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b65, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)b13, (Object)resultSet.getString(1));
            Assert.assertArrayEquals((byte[])b23, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((Object)b33, (Object)resultSet.getString(3));
            Assert.assertArrayEquals((byte[])b43, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b53, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b63, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)b11, (Object)resultSet.getString(1));
            Assert.assertArrayEquals((byte[])b21, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((Object)b31, (Object)resultSet.getString(3));
            Assert.assertArrayEquals((byte[])b41, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b51, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b61, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)b12, (Object)resultSet.getString(1));
            Assert.assertArrayEquals((byte[])b22, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((Object)b32, (Object)resultSet.getString(3));
            Assert.assertArrayEquals((byte[])b42, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b52, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b62, (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
            preparedStatement = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE PK1 = ? AND PK2 IS NOT NULL ");
            preparedStatement.setString(1, b11);
            resultSet = preparedStatement.executeQuery();
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)b15, (Object)resultSet.getString(1));
            Assert.assertArrayEquals((byte[])b25, (byte[])resultSet.getBytes(2));
            Assert.assertNull((Object)resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b45, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b55, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b65, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)b13, (Object)resultSet.getString(1));
            Assert.assertArrayEquals((byte[])b23, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((Object)b33, (Object)resultSet.getString(3));
            Assert.assertArrayEquals((byte[])b43, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b53, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b63, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)b11, (Object)resultSet.getString(1));
            Assert.assertArrayEquals((byte[])b21, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((Object)b31, (Object)resultSet.getString(3));
            Assert.assertArrayEquals((byte[])b41, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b51, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b61, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)b12, (Object)resultSet.getString(1));
            Assert.assertArrayEquals((byte[])b22, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((Object)b32, (Object)resultSet.getString(3));
            Assert.assertArrayEquals((byte[])b42, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b52, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b62, (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
            preparedStatement = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE PK1 = ? AND PK2 = ?");
            preparedStatement.setString(1, b11);
            preparedStatement.setBytes(2, b21);
            resultSet = preparedStatement.executeQuery();
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)b15, (Object)resultSet.getString(1));
            Assert.assertArrayEquals((byte[])b25, (byte[])resultSet.getBytes(2));
            Assert.assertNull((Object)resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b45, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b55, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b65, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)b13, (Object)resultSet.getString(1));
            Assert.assertArrayEquals((byte[])b23, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((Object)b33, (Object)resultSet.getString(3));
            Assert.assertArrayEquals((byte[])b43, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b53, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b63, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)b11, (Object)resultSet.getString(1));
            Assert.assertArrayEquals((byte[])b21, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((Object)b31, (Object)resultSet.getString(3));
            Assert.assertArrayEquals((byte[])b41, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b51, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b61, (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
            preparedStatement = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE PK1 = ? AND PK2 BETWEEN ? AND ? AND PK3 IS NOT NULL");
            preparedStatement.setString(1, b11);
            preparedStatement.setBytes(2, new byte[]{57, -83, 0, -2, 0, -7, -12, -13, 3, 24, -121});
            preparedStatement.setBytes(3, new byte[]{57, -83, 0, -2, 0, -7, -12, -13, 4});
            resultSet = preparedStatement.executeQuery();
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)b13, (Object)resultSet.getString(1));
            Assert.assertArrayEquals((byte[])b23, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((Object)b33, (Object)resultSet.getString(3));
            Assert.assertArrayEquals((byte[])b43, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b53, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b63, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)b11, (Object)resultSet.getString(1));
            Assert.assertArrayEquals((byte[])b21, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((Object)b31, (Object)resultSet.getString(3));
            Assert.assertArrayEquals((byte[])b41, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b51, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b61, (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
            preparedStatement = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE PK1 = ? AND PK2 IN (?, ?, ?)");
            preparedStatement.setString(1, b11);
            preparedStatement.setBytes(2, b21);
            preparedStatement.setBytes(3, b23);
            preparedStatement.setBytes(4, b22);
            resultSet = preparedStatement.executeQuery();
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)b15, (Object)resultSet.getString(1));
            Assert.assertArrayEquals((byte[])b25, (byte[])resultSet.getBytes(2));
            Assert.assertEquals(b35, (Object)resultSet.getString(3));
            Assert.assertArrayEquals((byte[])b45, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b55, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b65, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)b13, (Object)resultSet.getString(1));
            Assert.assertArrayEquals((byte[])b23, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((Object)b33, (Object)resultSet.getString(3));
            Assert.assertArrayEquals((byte[])b43, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b53, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b63, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)b11, (Object)resultSet.getString(1));
            Assert.assertArrayEquals((byte[])b21, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((Object)b31, (Object)resultSet.getString(3));
            Assert.assertArrayEquals((byte[])b41, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b51, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b61, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)b12, (Object)resultSet.getString(1));
            Assert.assertArrayEquals((byte[])b22, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((Object)b32, (Object)resultSet.getString(3));
            Assert.assertArrayEquals((byte[])b42, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b52, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b62, (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
            preparedStatement = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE PK1 = ? AND PK2 = ? AND PK3 = ?");
            preparedStatement.setString(1, b11);
            preparedStatement.setBytes(2, b21);
            preparedStatement.setString(3, b31);
            resultSet = preparedStatement.executeQuery();
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)b11, (Object)resultSet.getString(1));
            Assert.assertArrayEquals((byte[])b21, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((Object)b31, (Object)resultSet.getString(3));
            Assert.assertArrayEquals((byte[])b41, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b51, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b61, (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
            preparedStatement = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE PK1 = ? AND PK2 = ? AND PK3 IS NULL");
            preparedStatement.setString(1, b11);
            preparedStatement.setBytes(2, b21);
            resultSet = preparedStatement.executeQuery();
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)b15, (Object)resultSet.getString(1));
            Assert.assertArrayEquals((byte[])b25, (byte[])resultSet.getBytes(2));
            Assert.assertNull((Object)resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b45, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b55, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b65, (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
        }
    }

    @Test
    public void testVarBinaryPkSchema6() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = VarBinaryEncoded1IT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(VarBinaryEncoded1IT.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE " + tableName + " (PK1 VARBINARY_ENCODED, PK2 DOUBLE NOT NULL, PK3 VARBINARY_ENCODED, COL1 VARBINARY_ENCODED, COL2 VARBINARY_ENCODED, COL3 VARBINARY_ENCODED CONSTRAINT pk PRIMARY KEY(PK1, PK2, PK3)) " + this.tableDDLOptions);
            byte[] b1 = new byte[]{1, 1, 19, -28, 24, 1, 1, -11, -21, 1};
            double b2 = 4148316.50906;
            byte[] b3 = new byte[]{4, 34, -19, 8, -73, 3, 4, 23};
            byte[] b4 = new byte[]{56, 50, 19, 34, 83, -101, -102, 91};
            byte[] b5 = new byte[]{10, 55, 19, -5, -34, 0, 0, 0, 0, 1};
            byte[] b6 = new byte[]{-11, 55, -119, 8, 0, 1, 2, -4, 33};
            byte[] b10 = new byte[]{1, 1, 19, -28, 25, -1, 1, -11, -21, -1};
            double b20 = 3479039.03887;
            byte[] b30 = new byte[]{4, 1, -19, 8, 0, -73, 3, 4, 23};
            byte[] b40 = new byte[]{56, 50, 19, 34, 83, -101, -102, 91};
            byte[] b50 = new byte[]{10, 55, 19, -5, -34, 0, 0, 0, 0, 1};
            byte[] b60 = new byte[]{-11, 55, -119, 8, 0, 1, 2, -4, 33};
            byte[] b11 = new byte[]{1, 1, 20, -28, 0, -1, 0, -11, -21, -1};
            double b21 = 3579039.03887;
            byte[] b31 = new byte[]{4, 1, 0, 0, 0, 73, 3, 0, 23};
            byte[] b41 = new byte[]{56, 50, 19, 0, 34, 83, -101, -102, 91};
            byte[] b51 = new byte[]{10, 55, 0, 19, -5, -34, 0, 0, 0, 0, 1};
            byte[] b61 = new byte[]{-11, 55, -119, 0, 8, 0, 1, 2, -4, 33};
            byte[] b12 = new byte[]{1, 1, 20, -28, 0, -1, 0, -11, -21, -1};
            double b22 = 3579039.038871;
            byte[] b32 = new byte[]{4, 1, 75, 0, 0, 73, 0, -24, 3, 0, 12, 99, 23};
            byte[] b42 = new byte[]{56, 50, 19, 0, 34, 83, -101, -102, 91};
            byte[] b52 = new byte[]{10, 55, 0, 19, -5, -34, 0, 0, 0, 0, 1};
            byte[] b62 = new byte[]{-11, 55, -119, 0, 8, 0, 1, 2, -4, 33};
            byte[] b13 = new byte[]{1, 1, 20, -28, 0, -1, 0, -11, -21, -1};
            double b23 = 3579039.03887;
            byte[] b33 = new byte[]{4, 1, 0, 0, 0, 0, 22, 122, 48, -121, 73, 3, 0, 23};
            byte[] b43 = new byte[]{56, 50, 19, 0, 34, 83, -101, -102, 91, 92};
            byte[] b53 = new byte[]{10, 55, 0, 19, -5, -34, 0, -12, 0, 0, 0, 1};
            byte[] b63 = new byte[]{-11, 55, -119, 0, 8, 0, 1, 2, -4, 33};
            byte[] b15 = new byte[]{1, 1, 20, -28, 0, -1, 0, -11, -21, -1};
            double b25 = 3579039.03887;
            byte[] b35 = null;
            byte[] b45 = new byte[]{56, 50, 19, 0, 34, 83, -101, -102, 91, 92};
            byte[] b55 = new byte[]{10, 55, 0, 19, -5, -34, 0, -12, 0, 0, 0, 1};
            byte[] b65 = new byte[]{-11, 55, -119, 0, 8, 0, 1, 2, -4, 33};
            try (PreparedStatement preparedStatement = conn.prepareStatement("UPSERT INTO " + tableName + "(PK1, PK2, PK3, COL1, COL2, COL3) VALUES (?, ?, ?, ?, ?, ?)");){
                VarBinaryEncoded1IT.upsertRow(preparedStatement, Bytes.toBytes((String)"pk1-ehgir4jf"), 937598.284, Bytes.toBytes((String)"pk33ogjirhhf"), Bytes.toBytes((String)"col19fnbb0hf0t"), Bytes.toBytes((String)"col21048rnbfpe3-"), Bytes.toBytes((String)"col319efnrugifj"));
                VarBinaryEncoded1IT.upsertRow(preparedStatement, b10, b20, b30, b40, b50, b60);
                VarBinaryEncoded1IT.upsertRow(preparedStatement, b1, b2, b3, b4, b5, b6);
                VarBinaryEncoded1IT.upsertRow(preparedStatement, b11, b21, b31, b41, b51, b61);
                VarBinaryEncoded1IT.upsertRow(preparedStatement, b12, b22, b32, b42, b52, b62);
                VarBinaryEncoded1IT.upsertRow(preparedStatement, b13, b23, b33, b43, b53, b63);
                VarBinaryEncoded1IT.upsertRow(preparedStatement, b15, b25, b35, b45, b55, b65);
            }
            conn.commit();
            PreparedStatement pst = conn.prepareStatement("SELECT * FROM " + tableName);
            ResultSet resultSet = pst.executeQuery();
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b1, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((double)b2, (double)resultSet.getDouble(2), (double)0.0);
            Assert.assertArrayEquals((byte[])b3, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b4, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b5, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b6, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b10, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((double)b20, (double)resultSet.getDouble(2), (double)0.0);
            Assert.assertArrayEquals((byte[])b30, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b40, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b50, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b60, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b15, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((double)b25, (double)resultSet.getDouble(2), (double)0.0);
            Assert.assertNull((Object)resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b45, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b55, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b65, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b13, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((double)b23, (double)resultSet.getDouble(2), (double)0.0);
            Assert.assertArrayEquals((byte[])b33, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b43, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b53, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b63, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b11, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((double)b21, (double)resultSet.getDouble(2), (double)0.0);
            Assert.assertArrayEquals((byte[])b31, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b41, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b51, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b61, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b12, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((double)b22, (double)resultSet.getDouble(2), (double)0.0);
            Assert.assertArrayEquals((byte[])b32, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b42, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b52, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b62, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"pk1-ehgir4jf"), (byte[])resultSet.getBytes(1));
            Assert.assertEquals((double)937598.284, (double)resultSet.getDouble(2), (double)0.0);
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"pk33ogjirhhf"), (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"col19fnbb0hf0t"), (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"col21048rnbfpe3-"), (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"col319efnrugifj"), (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
            PreparedStatement preparedStatement = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE PK1 = ?");
            preparedStatement.setBytes(1, b11);
            resultSet = preparedStatement.executeQuery();
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b15, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((double)b25, (double)resultSet.getDouble(2), (double)0.0);
            Assert.assertNull((Object)resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b45, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b55, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b65, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b13, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((double)b23, (double)resultSet.getDouble(2), (double)0.0);
            Assert.assertArrayEquals((byte[])b33, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b43, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b53, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b63, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b11, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((double)b21, (double)resultSet.getDouble(2), (double)0.0);
            Assert.assertArrayEquals((byte[])b31, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b41, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b51, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b61, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b12, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((double)b22, (double)resultSet.getDouble(2), (double)0.0);
            Assert.assertArrayEquals((byte[])b32, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b42, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b52, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b62, (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
            preparedStatement = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE PK1 = ? AND PK2 IS NOT NULL ");
            preparedStatement.setBytes(1, b11);
            resultSet = preparedStatement.executeQuery();
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b15, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((double)b25, (double)resultSet.getDouble(2), (double)0.0);
            Assert.assertNull((Object)resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b45, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b55, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b65, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b13, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((double)b23, (double)resultSet.getDouble(2), (double)0.0);
            Assert.assertArrayEquals((byte[])b33, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b43, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b53, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b63, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b11, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((double)b21, (double)resultSet.getDouble(2), (double)0.0);
            Assert.assertArrayEquals((byte[])b31, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b41, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b51, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b61, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b12, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((double)b22, (double)resultSet.getDouble(2), (double)0.0);
            Assert.assertArrayEquals((byte[])b32, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b42, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b52, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b62, (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
            preparedStatement = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE PK1 = ? AND PK2 = ?");
            preparedStatement.setBytes(1, b11);
            preparedStatement.setDouble(2, b21);
            resultSet = preparedStatement.executeQuery();
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b15, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((double)b25, (double)resultSet.getDouble(2), (double)0.0);
            Assert.assertNull((Object)resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b45, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b55, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b65, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b13, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((double)b23, (double)resultSet.getDouble(2), (double)0.0);
            Assert.assertArrayEquals((byte[])b33, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b43, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b53, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b63, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b11, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((double)b21, (double)resultSet.getDouble(2), (double)0.0);
            Assert.assertArrayEquals((byte[])b31, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b41, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b51, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b61, (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
            preparedStatement = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE PK1 = ? AND PK2 BETWEEN ? AND ? AND PK3 IS NOT NULL");
            preparedStatement.setBytes(1, b11);
            preparedStatement.setDouble(2, 3579039.0388);
            preparedStatement.setDouble(3, 3579039.03887);
            resultSet = preparedStatement.executeQuery();
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b13, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((double)b23, (double)resultSet.getDouble(2), (double)0.0);
            Assert.assertArrayEquals((byte[])b33, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b43, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b53, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b63, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b11, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((double)b21, (double)resultSet.getDouble(2), (double)0.0);
            Assert.assertArrayEquals((byte[])b31, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b41, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b51, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b61, (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
            preparedStatement = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE PK1 = ? AND PK2 IN (?, ?, ?)");
            preparedStatement.setBytes(1, b11);
            preparedStatement.setDouble(2, b21);
            preparedStatement.setDouble(3, b23);
            preparedStatement.setDouble(4, b22);
            resultSet = preparedStatement.executeQuery();
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b15, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((double)b25, (double)resultSet.getDouble(2), (double)0.0);
            Assert.assertArrayEquals(b35, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b45, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b55, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b65, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b13, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((double)b23, (double)resultSet.getDouble(2), (double)0.0);
            Assert.assertArrayEquals((byte[])b33, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b43, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b53, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b63, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b11, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((double)b21, (double)resultSet.getDouble(2), (double)0.0);
            Assert.assertArrayEquals((byte[])b31, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b41, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b51, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b61, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b12, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((double)b22, (double)resultSet.getDouble(2), (double)0.0);
            Assert.assertArrayEquals((byte[])b32, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b42, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b52, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b62, (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
            preparedStatement = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE PK1 = ? AND PK2 = ? AND PK3 = ?");
            preparedStatement.setBytes(1, b11);
            preparedStatement.setDouble(2, b21);
            preparedStatement.setBytes(3, b31);
            resultSet = preparedStatement.executeQuery();
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b11, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((double)b21, (double)resultSet.getDouble(2), (double)0.0);
            Assert.assertArrayEquals((byte[])b31, (byte[])resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b41, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b51, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b61, (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
            preparedStatement = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE PK1 = ? AND PK2 = ? AND PK3 IS NULL");
            preparedStatement.setBytes(1, b11);
            preparedStatement.setDouble(2, b21);
            resultSet = preparedStatement.executeQuery();
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertArrayEquals((byte[])b15, (byte[])resultSet.getBytes(1));
            Assert.assertEquals((double)b25, (double)resultSet.getDouble(2), (double)0.0);
            Assert.assertNull((Object)resultSet.getBytes(3));
            Assert.assertArrayEquals((byte[])b45, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b55, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b65, (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
        }
    }

    @Test
    public void testVarBinaryPkSchema7() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = VarBinaryEncoded1IT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(VarBinaryEncoded1IT.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE " + tableName + " (PK1 DOUBLE NOT NULL, PK2 VARBINARY_ENCODED, PK3 DOUBLE NOT NULL, COL1 VARBINARY_ENCODED, COL2 VARBINARY_ENCODED, COL3 VARBINARY_ENCODED CONSTRAINT pk PRIMARY KEY(PK1, PK2, PK3)) " + this.tableDDLOptions);
            double b1 = -8594240.7859859;
            byte[] b2 = new byte[]{57, -83, 2, 83, -7, 12, -13, 4};
            double b3 = 4.1404609573566E7;
            byte[] b4 = new byte[]{56, 50, 19, 34, 83, -101, -102, 91};
            byte[] b5 = new byte[]{10, 55, 19, -5, -34, 0, 0, 0, 0, 1};
            byte[] b6 = new byte[]{-11, 55, -119, 8, 0, 1, 2, -4, 33};
            double b10 = 8595240.7859859;
            byte[] b20 = new byte[]{57, -83, -2, 83, 0, -7, -12, -13, 4};
            double b30 = 9.5321094384728E8;
            byte[] b40 = new byte[]{56, 50, 19, 34, 83, -101, -102, 91};
            byte[] b50 = new byte[]{10, 55, 19, -5, -34, 0, 0, 0, 0, 1};
            byte[] b60 = new byte[]{-11, 55, -119, 8, 0, 1, 2, -4, 33};
            double b11 = 5.618007932343711E8;
            byte[] b21 = new byte[]{57, -83, 0, -2, 0, -7, -12, -13, 4};
            double b31 = 4.7070995373489E8;
            byte[] b41 = new byte[]{56, 50, 19, 0, 34, 83, -101, -102, 91};
            byte[] b51 = new byte[]{10, 55, 0, 19, -5, -34, 0, 0, 0, 0, 1};
            byte[] b61 = new byte[]{-11, 55, -119, 0, 8, 0, 1, 2, -4, 33};
            double b12 = 5.618007932343711E8;
            byte[] b22 = new byte[]{57, -83, 0, -2, 0, -7, -12, -13, 4, 0};
            double b32 = 7.3877404849662E8;
            byte[] b42 = new byte[]{56, 50, 19, 0, 34, 83, -101, -102, 91};
            byte[] b52 = new byte[]{10, 55, 0, 19, -5, -34, 0, 0, 0, 0, 1};
            byte[] b62 = new byte[]{-11, 55, -119, 0, 8, 0, 1, 2, -4, 33};
            double b13 = 5.618007932343711E8;
            byte[] b23 = new byte[]{57, -83, 0, -2, 0, -7, -12, -13, 4};
            double b33 = 8.9048526181873E7;
            byte[] b43 = new byte[]{56, 50, 19, 0, 34, 83, -101, -102, 91, 92};
            byte[] b53 = new byte[]{10, 55, 0, 19, -5, -34, 0, -12, 0, 0, 0, 1};
            byte[] b63 = new byte[]{-11, 55, -119, 0, 8, 0, 1, 2, -4, 33};
            double b14 = 5.618007932343711E8;
            byte[] b24 = null;
            double b34 = 9.6945574504936E8;
            byte[] b44 = new byte[]{56, 50, 19, 0, 34, 83, -101, -102, 91, 92};
            byte[] b54 = new byte[]{10, 55, 0, 19, -5, -34, 0, -12, 0, 0, 0, 1};
            byte[] b64 = new byte[]{-11, 55, -119, 0, 8, 0, 1, 2, -4, 33};
            try (PreparedStatement preparedStatement = conn.prepareStatement("UPSERT INTO " + tableName + "(PK1, PK2, PK3, COL1, COL2, COL3) VALUES (?, ?, ?, ?, ?, ?)");){
                VarBinaryEncoded1IT.upsertRow(preparedStatement, 5.618007934232344E9, Bytes.toBytes((String)"pk22p0jfdkhrgi"), -9.6945574504936E8, Bytes.toBytes((String)"col19fnbb0hf0t"), Bytes.toBytes((String)"col21048rnbfpe3-"), Bytes.toBytes((String)"col319efnrugifj"));
                VarBinaryEncoded1IT.upsertRow(preparedStatement, b10, b20, b30, b40, b50, b60);
                VarBinaryEncoded1IT.upsertRow(preparedStatement, b1, b2, b3, b4, b5, b6);
                VarBinaryEncoded1IT.upsertRow(preparedStatement, b11, b21, b31, b41, b51, b61);
                VarBinaryEncoded1IT.upsertRow(preparedStatement, b12, b22, b32, b42, b52, b62);
                VarBinaryEncoded1IT.upsertRow(preparedStatement, b13, b23, b33, b43, b53, b63);
                VarBinaryEncoded1IT.upsertRow(preparedStatement, b14, b24, b34, b44, b54, b64);
            }
            conn.commit();
            PreparedStatement pst = conn.prepareStatement("SELECT * FROM " + tableName);
            ResultSet resultSet = pst.executeQuery();
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((double)b1, (double)resultSet.getDouble(1), (double)0.0);
            Assert.assertArrayEquals((byte[])b2, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((double)b3, (double)resultSet.getDouble(3), (double)0.0);
            Assert.assertArrayEquals((byte[])b4, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b5, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b6, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((double)b10, (double)resultSet.getDouble(1), (double)0.0);
            Assert.assertArrayEquals((byte[])b20, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((double)b30, (double)resultSet.getDouble(3), (double)0.0);
            Assert.assertArrayEquals((byte[])b40, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b50, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b60, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((double)b14, (double)resultSet.getDouble(1), (double)0.0);
            Assert.assertNull((Object)resultSet.getBytes(2));
            Assert.assertEquals((double)b34, (double)resultSet.getDouble(3), (double)0.0);
            Assert.assertArrayEquals((byte[])b44, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b54, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b64, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((double)b13, (double)resultSet.getDouble(1), (double)0.0);
            Assert.assertArrayEquals((byte[])b23, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((double)b33, (double)resultSet.getDouble(3), (double)0.0);
            Assert.assertArrayEquals((byte[])b43, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b53, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b63, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((double)b11, (double)resultSet.getDouble(1), (double)0.0);
            Assert.assertArrayEquals((byte[])b21, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((double)b31, (double)resultSet.getDouble(3), (double)0.0);
            Assert.assertArrayEquals((byte[])b41, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b51, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b61, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((double)b12, (double)resultSet.getDouble(1), (double)0.0);
            Assert.assertArrayEquals((byte[])b22, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((double)b32, (double)resultSet.getDouble(3), (double)0.0);
            Assert.assertArrayEquals((byte[])b42, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b52, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b62, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((double)5.618007934232344E9, (double)resultSet.getDouble(1), (double)0.0);
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"pk22p0jfdkhrgi"), (byte[])resultSet.getBytes(2));
            Assert.assertEquals((double)-9.6945574504936E8, (double)resultSet.getDouble(3), (double)0.0);
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"col19fnbb0hf0t"), (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"col21048rnbfpe3-"), (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"col319efnrugifj"), (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
            PreparedStatement preparedStatement = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE PK1 = ?");
            preparedStatement.setDouble(1, b11);
            resultSet = preparedStatement.executeQuery();
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((double)b14, (double)resultSet.getDouble(1), (double)0.0);
            Assert.assertNull((Object)resultSet.getBytes(2));
            Assert.assertEquals((double)b34, (double)resultSet.getDouble(3), (double)0.0);
            Assert.assertArrayEquals((byte[])b44, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b54, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b64, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((double)b13, (double)resultSet.getDouble(1), (double)0.0);
            Assert.assertArrayEquals((byte[])b23, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((double)b33, (double)resultSet.getDouble(3), (double)0.0);
            Assert.assertArrayEquals((byte[])b43, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b53, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b63, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((double)b11, (double)resultSet.getDouble(1), (double)0.0);
            Assert.assertArrayEquals((byte[])b21, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((double)b31, (double)resultSet.getDouble(3), (double)0.0);
            Assert.assertArrayEquals((byte[])b41, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b51, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b61, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((double)b12, (double)resultSet.getDouble(1), (double)0.0);
            Assert.assertArrayEquals((byte[])b22, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((double)b32, (double)resultSet.getDouble(3), (double)0.0);
            Assert.assertArrayEquals((byte[])b42, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b52, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b62, (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
            preparedStatement = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE PK1 = ? AND PK2 IS NOT NULL");
            preparedStatement.setDouble(1, b11);
            resultSet = preparedStatement.executeQuery();
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((double)b13, (double)resultSet.getDouble(1), (double)0.0);
            Assert.assertArrayEquals((byte[])b23, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((double)b33, (double)resultSet.getDouble(3), (double)0.0);
            Assert.assertArrayEquals((byte[])b43, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b53, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b63, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((double)b11, (double)resultSet.getDouble(1), (double)0.0);
            Assert.assertArrayEquals((byte[])b21, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((double)b31, (double)resultSet.getDouble(3), (double)0.0);
            Assert.assertArrayEquals((byte[])b41, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b51, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b61, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((double)b12, (double)resultSet.getDouble(1), (double)0.0);
            Assert.assertArrayEquals((byte[])b22, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((double)b32, (double)resultSet.getDouble(3), (double)0.0);
            Assert.assertArrayEquals((byte[])b42, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b52, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b62, (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
            preparedStatement = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE PK1 = ? AND PK2 = ?");
            preparedStatement.setDouble(1, b11);
            preparedStatement.setBytes(2, b21);
            resultSet = preparedStatement.executeQuery();
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((double)b13, (double)resultSet.getDouble(1), (double)0.0);
            Assert.assertArrayEquals((byte[])b23, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((double)b33, (double)resultSet.getDouble(3), (double)0.0);
            Assert.assertArrayEquals((byte[])b43, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b53, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b63, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((double)b11, (double)resultSet.getDouble(1), (double)0.0);
            Assert.assertArrayEquals((byte[])b21, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((double)b31, (double)resultSet.getDouble(3), (double)0.0);
            Assert.assertArrayEquals((byte[])b41, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b51, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b61, (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
            if (this.isBindStatement) {
                preparedStatement = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE PK1 = ? AND PK2 BETWEEN ? AND ? AND PK3 IS NOT NULL");
                preparedStatement.setDouble(1, b11);
                preparedStatement.setBytes(2, new byte[]{57, -83, 0, -2, 0, -7, -12, -13, 3, 24, -121});
                preparedStatement.setBytes(3, new byte[]{57, -83, 0, -2, 0, -7, -12, -13, 4});
                resultSet = preparedStatement.executeQuery();
            } else {
                resultSet = conn.createStatement().executeQuery("SELECT * FROM " + tableName + " WHERE PK1 = " + b11 + " AND PK2 BETWEEN " + PVarbinary.INSTANCE.toStringLiteral((Object)new byte[]{57, -83, 0, -2, 0, -7, -12, -13, 3, 24, -121}) + " AND " + PVarbinary.INSTANCE.toStringLiteral((Object)new byte[]{57, -83, 0, -2, 0, -7, -12, -13, 4}) + " AND PK3 IS NOT NULL");
            }
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((double)b13, (double)resultSet.getDouble(1), (double)0.0);
            Assert.assertArrayEquals((byte[])b23, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((double)b33, (double)resultSet.getDouble(3), (double)0.0);
            Assert.assertArrayEquals((byte[])b43, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b53, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b63, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((double)b11, (double)resultSet.getDouble(1), (double)0.0);
            Assert.assertArrayEquals((byte[])b21, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((double)b31, (double)resultSet.getDouble(3), (double)0.0);
            Assert.assertArrayEquals((byte[])b41, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b51, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b61, (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
            if (this.isBindStatement) {
                preparedStatement = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE PK1 = ? AND PK2 IN (?, ?, ?)");
                preparedStatement.setDouble(1, b11);
                preparedStatement.setBytes(2, b21);
                preparedStatement.setBytes(3, b23);
                preparedStatement.setBytes(4, b22);
                resultSet = preparedStatement.executeQuery();
            } else {
                resultSet = conn.createStatement().executeQuery("SELECT * FROM " + tableName + " WHERE PK1 = " + b11 + " AND PK2 IN (" + PVarbinary.INSTANCE.toStringLiteral((Object)b21) + "," + PVarbinary.INSTANCE.toStringLiteral((Object)b22) + ", " + PVarbinary.INSTANCE.toStringLiteral((Object)b23) + ")");
            }
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((double)b13, (double)resultSet.getDouble(1), (double)0.0);
            Assert.assertArrayEquals((byte[])b23, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((double)b33, (double)resultSet.getDouble(3), (double)0.0);
            Assert.assertArrayEquals((byte[])b43, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b53, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b63, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((double)b11, (double)resultSet.getDouble(1), (double)0.0);
            Assert.assertArrayEquals((byte[])b21, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((double)b31, (double)resultSet.getDouble(3), (double)0.0);
            Assert.assertArrayEquals((byte[])b41, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b51, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b61, (byte[])resultSet.getBytes(6));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((double)b12, (double)resultSet.getDouble(1), (double)0.0);
            Assert.assertArrayEquals((byte[])b22, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((double)b32, (double)resultSet.getDouble(3), (double)0.0);
            Assert.assertArrayEquals((byte[])b42, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b52, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b62, (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
            preparedStatement = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE PK1 = ? AND PK2 = ? AND PK3 = ?");
            preparedStatement.setDouble(1, b11);
            preparedStatement.setBytes(2, b21);
            preparedStatement.setDouble(3, b31);
            resultSet = preparedStatement.executeQuery();
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((double)b11, (double)resultSet.getDouble(1), (double)0.0);
            Assert.assertArrayEquals((byte[])b21, (byte[])resultSet.getBytes(2));
            Assert.assertEquals((double)b31, (double)resultSet.getDouble(3), (double)0.0);
            Assert.assertArrayEquals((byte[])b41, (byte[])resultSet.getBytes(4));
            Assert.assertArrayEquals((byte[])b51, (byte[])resultSet.getBytes(5));
            Assert.assertArrayEquals((byte[])b61, (byte[])resultSet.getBytes(6));
            Assert.assertFalse((boolean)resultSet.next());
            preparedStatement = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE PK1 = ? AND PK2 = ? AND PK3 IS NULL");
            preparedStatement.setDouble(1, b11);
            preparedStatement.setBytes(2, b21);
            resultSet = preparedStatement.executeQuery();
            Assert.assertFalse((boolean)resultSet.next());
        }
    }

    private static void upsertRow(PreparedStatement preparedStatement, byte[] b10, String b20, byte[] b30, byte[] b40, byte[] b50, byte[] b60) throws SQLException {
        preparedStatement.setBytes(1, b10);
        preparedStatement.setString(2, b20);
        preparedStatement.setBytes(3, b30);
        preparedStatement.setBytes(4, b40);
        preparedStatement.setBytes(5, b50);
        preparedStatement.setBytes(6, b60);
        preparedStatement.executeUpdate();
    }

    private static void upsertRow(PreparedStatement preparedStatement, byte[] b10, Double b20, byte[] b30, byte[] b40, byte[] b50, byte[] b60) throws SQLException {
        preparedStatement.setBytes(1, b10);
        preparedStatement.setDouble(2, b20);
        preparedStatement.setBytes(3, b30);
        preparedStatement.setBytes(4, b40);
        preparedStatement.setBytes(5, b50);
        preparedStatement.setBytes(6, b60);
        preparedStatement.executeUpdate();
    }

    private static void upsertRow(PreparedStatement preparedStatement, String b10, byte[] b20, String b30, byte[] b40, byte[] b50, byte[] b60) throws SQLException {
        preparedStatement.setString(1, b10);
        preparedStatement.setBytes(2, b20);
        preparedStatement.setString(3, b30);
        preparedStatement.setBytes(4, b40);
        preparedStatement.setBytes(5, b50);
        preparedStatement.setBytes(6, b60);
        preparedStatement.executeUpdate();
    }

    private static void upsertRow(PreparedStatement preparedStatement, double b10, byte[] b20, double b30, byte[] b40, byte[] b50, byte[] b60) throws SQLException {
        preparedStatement.setDouble(1, b10);
        preparedStatement.setBytes(2, b20);
        preparedStatement.setDouble(3, b30);
        preparedStatement.setBytes(4, b40);
        preparedStatement.setBytes(5, b50);
        preparedStatement.setBytes(6, b60);
        preparedStatement.executeUpdate();
    }
}

