/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

@Category(value={ParallelStatsDisabledTest.class})
public class UpsertWithSCNIT
extends ParallelStatsDisabledIT {
    @Rule
    public final ExpectedException exception = ExpectedException.none();
    Properties props = null;
    private PreparedStatement prep = null;
    String tableName = null;

    private void helpTestUpsertWithSCNIT(boolean rowColumn, boolean txTable, boolean mutable, boolean local, boolean global) throws SQLException {
        this.tableName = UpsertWithSCNIT.generateUniqueName();
        String createTable = "CREATE TABLE " + this.tableName + " (" + (rowColumn ? "CREATED_DATE DATE NOT NULL, " : "") + "METRIC_ID CHAR(15) NOT NULL,METRIC_VALUE VARCHAR(50) CONSTRAINT PK PRIMARY KEY(" + (rowColumn ? "CREATED_DATE ROW_TIMESTAMP, " : "") + "METRIC_ID)) IMMUTABLE_ROWS=" + (mutable ? "false" : "true") + (txTable ? ", TRANSACTION_PROVIDER='OMID',TRANSACTIONAL=true" : "");
        this.props = new Properties();
        Connection conn = DriverManager.getConnection(UpsertWithSCNIT.getUrl(), this.props);
        conn.createStatement().execute(createTable);
        if (local || global) {
            String indx = "CREATE " + (local ? "LOCAL " : "") + "INDEX " + this.tableName + "_idx ON " + this.tableName + " (METRIC_VALUE)";
            conn.createStatement().execute(indx);
        }
        this.props.setProperty("CurrentSCN", Long.toString(System.currentTimeMillis()));
        conn = DriverManager.getConnection(UpsertWithSCNIT.getUrl(), this.props);
        conn.setAutoCommit(true);
        String upsert = "UPSERT INTO " + this.tableName + " (METRIC_ID, METRIC_VALUE) VALUES (?,?)";
        this.prep = conn.prepareStatement(upsert);
        this.prep.setString(1, "abc");
        this.prep.setString(2, "This is the first comment!");
    }

    @Test
    public void testUpsertOnSCNSetTxnTable() throws SQLException {
        this.helpTestUpsertWithSCNIT(false, true, false, false, false);
        this.exception.expect(SQLException.class);
        this.exception.expectMessage(String.valueOf(SQLExceptionCode.CANNOT_SPECIFY_SCN_FOR_TXN_TABLE.getErrorCode()));
        this.prep.executeUpdate();
    }

    @Test
    public void testUpsertOnSCNSetMutTableWithoutIdx() throws Exception {
        this.helpTestUpsertWithSCNIT(false, false, true, false, false);
        this.prep.executeUpdate();
        this.props = new Properties();
        Connection conn = DriverManager.getConnection(UpsertWithSCNIT.getUrl(), this.props);
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + this.tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"abc", (Object)rs.getString(1));
        Assert.assertEquals((Object)"This is the first comment!", (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testUpsertOnSCNSetTable() throws Exception {
        this.helpTestUpsertWithSCNIT(false, false, false, false, false);
        this.prep.executeUpdate();
        this.props = new Properties();
        Connection conn = DriverManager.getConnection(UpsertWithSCNIT.getUrl(), this.props);
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + this.tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"abc", (Object)rs.getString(1));
        Assert.assertEquals((Object)"This is the first comment!", (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testUpsertOnSCNSetMutTableWithLocalIdx() throws Exception {
        this.helpTestUpsertWithSCNIT(false, false, true, true, false);
        this.exception.expect(SQLException.class);
        this.exception.expectMessage(String.valueOf(SQLExceptionCode.CANNOT_UPSERT_WITH_SCN_FOR_TABLE_WITH_INDEXES.getErrorCode()));
        this.prep.executeUpdate();
    }

    @Test
    public void testUpsertOnSCNSetImmutableTableWithLocalIdx() throws Exception {
        this.helpTestUpsertWithSCNIT(false, false, false, true, false);
        this.exception.expect(SQLException.class);
        this.exception.expectMessage(String.valueOf(SQLExceptionCode.CANNOT_UPSERT_WITH_SCN_FOR_TABLE_WITH_INDEXES.getErrorCode()));
        this.prep.executeUpdate();
    }

    @Test
    public void testUpsertOnSCNSetMutTableWithGlobalIdx() throws Exception {
        this.helpTestUpsertWithSCNIT(false, false, true, false, true);
        this.exception.expect(SQLException.class);
        this.exception.expectMessage(String.valueOf(SQLExceptionCode.CANNOT_UPSERT_WITH_SCN_FOR_TABLE_WITH_INDEXES.getErrorCode()));
        this.prep.executeUpdate();
    }

    @Test
    public void testUpsertOnSCNSetImmutableTableWithGlobalIdx() throws Exception {
        this.helpTestUpsertWithSCNIT(false, false, false, false, true);
        this.exception.expect(SQLException.class);
        this.exception.expectMessage(String.valueOf(SQLExceptionCode.CANNOT_UPSERT_WITH_SCN_FOR_TABLE_WITH_INDEXES.getErrorCode()));
        this.prep.executeUpdate();
    }

    @Test
    public void testUpsertOnSCNSetWithRowTSColumn() throws Exception {
        this.helpTestUpsertWithSCNIT(true, false, false, false, false);
        this.exception.expect(SQLException.class);
        this.exception.expectMessage(String.valueOf(SQLExceptionCode.CANNOT_UPSERT_WITH_SCN_FOR_ROW_TIMESTAMP_COLUMN.getErrorCode()));
        this.prep.executeUpdate();
    }
}

