/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.schema.SequenceNotFoundException;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.util.DateUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class UpsertValuesIT
extends ParallelStatsDisabledIT {
    @Test
    public void testGroupByWithLimitOverRowKey() throws Exception {
        String tableName = UpsertValuesIT.generateUniqueName();
        UpsertValuesIT.ensureTableCreated(UpsertValuesIT.getUrl(), tableName, "PTSDB", null, null, null);
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
        conn.setAutoCommit(true);
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " (inst,host,\"DATE\") VALUES(?,'b',CURRENT_DATE())");
        stmt.setString(1, "a");
        stmt.execute();
        Assert.assertNull((Object)stmt.getResultSet());
        Assert.assertEquals((long)1L, (long)stmt.getUpdateCount());
        stmt.execute();
        stmt.execute();
        stmt.setString(1, "b");
        stmt.execute();
        stmt.execute();
        conn.close();
        conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
        ResultSet rs = conn.createStatement().executeQuery("select count(1) from " + tableName + " group by inst limit 1");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)3L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("select inst from " + tableName + " where inst > 'a' group by inst limit 1");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"b", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }

    @Test
    public void testPlainUpsertWithReturning() throws Exception {
        String tableName = UpsertValuesIT.generateUniqueName();
        UpsertValuesIT.ensureTableCreated(UpsertValuesIT.getUrl(), tableName, "PTSDB", null, null, null);
        Properties props = new Properties();
        props.put("phoenix.task.handling.interval.ms", Long.toString(Long.MAX_VALUE));
        props.put("hbase.client.scanner.timeout.period", "6000000");
        props.put("phoenix.query.timeoutMs", "6000000");
        props.put("zookeeper.session.timeout", "6000000");
        props.put("hbase.rpc.timeout", "6000000");
        Connection conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
        conn.setAutoCommit(true);
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " (inst,host,\"DATE\") VALUES(?,'b',CURRENT_DATE()) RETURNING *");
        stmt.setString(1, "a");
        stmt.execute();
        ResultSet rs = stmt.getResultSet();
        Assert.assertNotNull((Object)rs);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)stmt.getUpdateCount());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((Object)"b", (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
        stmt = conn.prepareStatement("UPSERT INTO " + tableName + " (inst,host,\"DATE\") VALUES(?,'b',CURRENT_DATE())");
        stmt.setString(1, "a");
        stmt.execute();
        rs = stmt.getResultSet();
        Assert.assertNull((Object)rs);
        conn.close();
    }

    @Test
    public void testUpsertDateValues() throws Exception {
        String tableName = UpsertValuesIT.generateUniqueName();
        Date now = new Date(EnvironmentEdgeManager.currentTimeMillis());
        UpsertValuesIT.ensureTableCreated(UpsertValuesIT.getUrl(), tableName, "PTSDB", null, null, null);
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
        String dateString = "1999-01-01 02:00:00";
        PreparedStatement upsertStmt = conn.prepareStatement("upsert into " + tableName + "(inst,host,\"DATE\") values('aaa','bbb',to_date('" + dateString + "'))");
        int rowsInserted = upsertStmt.executeUpdate();
        Assert.assertEquals((long)1L, (long)rowsInserted);
        upsertStmt = conn.prepareStatement("upsert into " + tableName + "(inst,host,\"DATE\") values('ccc','ddd',current_date())");
        rowsInserted = upsertStmt.executeUpdate();
        Assert.assertEquals((long)1L, (long)rowsInserted);
        conn.commit();
        conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
        String select = "SELECT \"DATE\",current_date() FROM " + tableName;
        ResultSet rs = conn.createStatement().executeQuery(select);
        Date then = new Date(EnvironmentEdgeManager.currentTimeMillis());
        Assert.assertTrue((boolean)rs.next());
        Date date = DateUtil.parseDate((String)dateString);
        Assert.assertEquals((Object)date, (Object)rs.getDate(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((rs.getDate(1).after(now) && rs.getDate(1).before(then) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testUpsertValuesWithExpression() throws Exception {
        String tableName = UpsertValuesIT.generateUniqueName();
        UpsertValuesIT.ensureTableCreated(UpsertValuesIT.getUrl(), tableName, "IntKeyTest", null, null, null);
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
        String upsert = "UPSERT INTO " + tableName + " VALUES(-1)";
        PreparedStatement upsertStmt = conn.prepareStatement(upsert);
        int rowsInserted = upsertStmt.executeUpdate();
        Assert.assertEquals((long)1L, (long)rowsInserted);
        upsert = "UPSERT INTO " + tableName + " VALUES(1+2)";
        upsertStmt = conn.prepareStatement(upsert);
        rowsInserted = upsertStmt.executeUpdate();
        Assert.assertEquals((long)1L, (long)rowsInserted);
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
        String select = "SELECT i FROM " + tableName;
        ResultSet rs = conn.createStatement().executeQuery(select);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)-1L, (long)rs.getInt(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)3L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testUpsertValuesWithDate() throws Exception {
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
        String tableName = UpsertValuesIT.generateUniqueName();
        conn.createStatement().execute("create table " + tableName + " (k VARCHAR not null primary key,\"DATE\" DATE)");
        conn.close();
        conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
        conn.createStatement().execute("upsert into " + tableName + " values ('a',to_date('2013-06-08 00:00:00'))");
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
        ResultSet rs = conn.createStatement().executeQuery("select k,to_char(\"DATE\") from " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((Object)"2013-06-08 00:00:00.000", (Object)rs.getString(2));
    }

    @Test
    public void testUpsertValuesWithDescDecimal() throws Exception {
        Properties props = new Properties();
        String tableName = UpsertValuesIT.generateUniqueName();
        Connection conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
        conn.createStatement().execute("create table " + tableName + " (k DECIMAL(12,3) NOT NULL PRIMARY KEY DESC)");
        conn.close();
        conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
        conn.createStatement().execute("upsert into " + tableName + " values (0.0)");
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
        ResultSet rs = conn.createStatement().executeQuery("select k from " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((double)0.0, (double)rs.getDouble(1), (double)0.001);
    }

    @Test
    public void testUpsertRandomValues() throws Exception {
        Properties props = new Properties();
        String tableName = UpsertValuesIT.generateUniqueName();
        Connection conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
        conn.createStatement().execute("create table " + tableName + " (k UNSIGNED_DOUBLE not null primary key, v1 UNSIGNED_DOUBLE, v2 UNSIGNED_DOUBLE, v3 UNSIGNED_DOUBLE, v4 UNSIGNED_DOUBLE)");
        conn.close();
        conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
        conn.createStatement().execute("upsert into " + tableName + " values (RAND(), RAND(), RAND(1), RAND(2), RAND(1))");
        conn.createStatement().execute("upsert into " + tableName + " values (RAND(), RAND(), RAND(1), RAND(2), RAND(1))");
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
        ResultSet rs = conn.createStatement().executeQuery("select k,v1,v2,v3,v4 from " + tableName);
        Assert.assertTrue((boolean)rs.next());
        double rand0 = rs.getDouble(1);
        double rand1 = rs.getDouble(3);
        double rand2 = rs.getDouble(4);
        Assert.assertTrue((rs.getDouble(1) != rs.getDouble(2) ? 1 : 0) != 0);
        Assert.assertTrue((rs.getDouble(2) != rs.getDouble(3) ? 1 : 0) != 0);
        Assert.assertTrue((rand1 == rs.getDouble(5) ? 1 : 0) != 0);
        Assert.assertTrue((rs.getDouble(4) != rs.getDouble(5) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((rand0 != rs.getDouble(1) ? 1 : 0) != 0);
        Assert.assertTrue((rand1 == rs.getDouble(3) && rand1 == rs.getDouble(5) ? 1 : 0) != 0);
        Assert.assertTrue((rand2 == rs.getDouble(4) ? 1 : 0) != 0);
        conn.close();
    }

    @Test
    public void testUpsertVarCharWithMaxLength() throws Exception {
        Properties props = new Properties();
        String tableName = UpsertValuesIT.generateUniqueName();
        Connection conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
        conn.createStatement().execute("create table " + tableName + " (mac_md5 VARCHAR not null primary key,raw_mac VARCHAR)");
        conn.close();
        conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
        conn.createStatement().execute("upsert into " + tableName + " values ('00000000591','a')");
        conn.createStatement().execute("upsert into " + tableName + " values ('000000005919','b')");
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
        ResultSet rs = conn.createStatement().executeQuery("select max(mac_md5) from " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"000000005919", (Object)rs.getString(1));
        conn.close();
        conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
        conn.createStatement().execute("upsert into " + tableName + " values ('000000005919adfasfasfsafdasdfasfdasdfdasfdsafaxxf1','b')");
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
        rs = conn.createStatement().executeQuery("select max(mac_md5) from " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"000000005919adfasfasfsafdasdfasfdasdfdasfdsafaxxf1", (Object)rs.getString(1));
        conn.close();
    }

    @Test
    public void testUpsertValuesWithDescExpression() throws Exception {
        String tableName = UpsertValuesIT.generateUniqueName();
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
        conn.createStatement().execute("create table " + tableName + " (k VARCHAR not null primary key desc)");
        conn.close();
        conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
        conn.createStatement().execute("upsert into " + tableName + " values (to_char(100))");
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
        ResultSet rs = conn.createStatement().executeQuery("select to_number(k) from " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)100L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpsertValuesWithMoreValuesThanNumColsInTable() throws Exception {
        String tableName = UpsertValuesIT.generateUniqueName();
        Properties props = new Properties();
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
            stmt = conn.createStatement();
            stmt.execute("create table " + tableName + " (k VARCHAR not null primary key desc)");
        }
        catch (Throwable throwable) {
            TestUtil.closeStmtAndConn(stmt, conn);
            throw throwable;
        }
        TestUtil.closeStmtAndConn(stmt, conn);
        try {
            conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
            stmt = conn.createStatement();
            stmt.execute("upsert into " + tableName + " values (to_char(100), to_char(100), to_char(100))");
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.UPSERT_COLUMN_NUMBERS_MISMATCH.getErrorCode(), (long)e.getErrorCode());
        }
        finally {
            TestUtil.closeStmtAndConn(stmt, conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimestampSerializedAndDeserializedCorrectly() throws Exception {
        String tableName = UpsertValuesIT.generateUniqueName();
        Properties props = new Properties();
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
            conn.createStatement().execute("create table " + tableName + " (a integer NOT NULL, t timestamp NOT NULL CONSTRAINT pk PRIMARY KEY (a, t))");
        }
        finally {
            TestUtil.closeStmtAndConn(stmt, conn);
        }
        Timestamp ts1 = new Timestamp(120055L);
        ts1.setNanos(ts1.getNanos() + 60);
        try {
            conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
            stmt = conn.prepareStatement("upsert into " + tableName + " values (1, ?)");
            stmt.setTimestamp(1, ts1);
            stmt.executeUpdate();
            conn.commit();
        }
        catch (Throwable throwable) {
            TestUtil.closeStmtAndConn(stmt, conn);
            throw throwable;
        }
        TestUtil.closeStmtAndConn(stmt, conn);
        try {
            conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
            stmt = conn.prepareStatement("select t from " + tableName + " where t = ?");
            stmt.setTimestamp(1, ts1);
            ResultSet rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)ts1, (Object)rs.getTimestamp(1));
        }
        finally {
            TestUtil.closeStmtAndConn(stmt, conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimestampAddSubtractArithmetic() throws Exception {
        ResultSet rs;
        String tableName = UpsertValuesIT.generateUniqueName();
        Properties props = new Properties();
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
            conn.createStatement().execute("create table " + tableName + " (a integer NOT NULL, t timestamp NOT NULL CONSTRAINT pk PRIMARY KEY (a, t))");
        }
        finally {
            TestUtil.closeStmtAndConn(stmt, conn);
        }
        Timestamp ts1 = new Timestamp(120550L);
        int extraNanos = 60;
        ts1.setNanos(ts1.getNanos() + extraNanos);
        try {
            conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
            stmt = conn.prepareStatement("upsert into " + tableName + " values (1, ?)");
            stmt.setTimestamp(1, ts1);
            stmt.executeUpdate();
            conn.commit();
        }
        catch (Throwable throwable) {
            TestUtil.closeStmtAndConn(stmt, conn);
            throw throwable;
        }
        TestUtil.closeStmtAndConn(stmt, conn);
        try {
            conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
            stmt = conn.prepareStatement("select t from " + tableName + " LIMIT 1");
            ResultSet rs2 = stmt.executeQuery();
            Assert.assertTrue((boolean)rs2.next());
            Assert.assertEquals((Object)ts1, (Object)rs2.getTimestamp(1));
            Assert.assertFalse((boolean)rs2.next());
        }
        finally {
            TestUtil.closeStmtAndConn(stmt, conn);
        }
        BigDecimal msInDay = BigDecimal.valueOf(86400000L);
        BigDecimal nanosInDay = BigDecimal.valueOf(86400000L).multiply(BigDecimal.valueOf(1000000L));
        try {
            conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
            stmt = conn.prepareStatement("select 500.0/(1*24*60*60*1000) c1, 10.0/(1*24*60*60*1000*1000000) c2  from " + tableName + " LIMIT 1");
            ResultSet rs3 = stmt.executeQuery();
            Assert.assertTrue((boolean)rs3.next());
            BigDecimal c1 = rs3.getBigDecimal(1);
            BigDecimal rc1 = c1.multiply(msInDay).setScale(0, RoundingMode.HALF_UP);
            BigDecimal c2 = rs3.getBigDecimal(2);
            BigDecimal rc2 = c2.multiply(nanosInDay).setScale(0, RoundingMode.HALF_UP);
            Assert.assertTrue((BigDecimal.valueOf(500L).compareTo(rc1) == 0 ? 1 : 0) != 0);
            Assert.assertTrue((BigDecimal.valueOf(10L).compareTo(rc2) == 0 ? 1 : 0) != 0);
            Assert.assertFalse((boolean)rs3.next());
        }
        finally {
            TestUtil.closeStmtAndConn(stmt, conn);
        }
        Timestamp ts2 = new Timestamp(ts1.getTime() + 500L);
        ts2.setNanos(ts2.getNanos() + extraNanos + 10);
        try {
            conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
            stmt = conn.prepareStatement("select (t + (500.0/(1*24*60*60*1000) + 10.0/(1*24*60*60*1000*1000000)))  from " + tableName + " LIMIT 1");
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)ts2, (Object)rs.getTimestamp(1));
        }
        finally {
            TestUtil.closeStatement(stmt);
        }
        ts2 = new Timestamp(ts1.getTime() - 250L);
        ts2.setNanos(ts2.getNanos() + extraNanos - 30);
        try {
            stmt = conn.prepareStatement("select (t - (250.0/(1*24*60*60*1000) + 30.0/(1*24*60*60*1000*1000000)))  from " + tableName + " LIMIT 1");
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)ts2, (Object)rs.getTimestamp(1));
        }
        finally {
            TestUtil.closeStatement(stmt);
        }
        ts2 = new Timestamp(ts1.getTime() + 250L);
        ts2.setNanos(ts2.getNanos() + extraNanos);
        try {
            stmt = conn.prepareStatement("select t from " + tableName + " where t = ? - 250.0/(1*24*60*60*1000) LIMIT 1");
            stmt.setTimestamp(1, ts2);
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)ts1, (Object)rs.getTimestamp(1));
        }
        finally {
            TestUtil.closeStmtAndConn(stmt, conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpsertIntoFloat() throws Exception {
        String tableName = UpsertValuesIT.generateUniqueName();
        Properties props = new Properties();
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
            conn.createStatement().execute("create table " + tableName + " (k varchar primary key, v float)");
        }
        finally {
            TestUtil.closeStmtAndConn(stmt, conn);
        }
        try {
            conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
            stmt = conn.prepareStatement("upsert into " + tableName + " values ('a', 0.0)");
            stmt.executeUpdate();
            conn.commit();
        }
        catch (Throwable throwable) {
            TestUtil.closeStmtAndConn(stmt, conn);
            throw throwable;
        }
        TestUtil.closeStmtAndConn(stmt, conn);
        try {
            conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
            stmt = conn.prepareStatement("select * from " + tableName);
            ResultSet rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertTrue((boolean)Float.valueOf(0.0f).equals(Float.valueOf(rs.getFloat(2))));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            TestUtil.closeStmtAndConn(stmt, conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testBatchedUpsert(boolean autocommit) throws Exception {
        ResultSet rs;
        String tableName = UpsertValuesIT.generateUniqueName();
        Properties props = new Properties();
        props.setProperty("RequestMetric", "true");
        props.setProperty("phoenix.query.request.metrics.enabled", "true");
        Connection conn = null;
        PreparedStatement pstmt = null;
        Statement stmt = null;
        try {
            conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
            conn.createStatement().execute("create table " + tableName + " (k varchar primary key, v integer)");
        }
        finally {
            TestUtil.closeStmtAndConn(pstmt, conn);
        }
        try {
            conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
            conn.setAutoCommit(autocommit);
            pstmt = conn.prepareStatement("upsert into " + tableName + " values (?, ?)");
            pstmt.setString(1, "a");
            pstmt.setInt(2, 1);
            pstmt.addBatch();
            pstmt.setString(1, "b");
            pstmt.setInt(2, 2);
            pstmt.addBatch();
            pstmt.setString(1, "c");
            pstmt.setInt(2, 3);
            pstmt.addBatch();
            pstmt.executeBatch();
            if (!autocommit) {
                conn.commit();
            }
            PhoenixConnection pConn = conn.unwrap(PhoenixConnection.class);
            Map mutationMetrics = pConn.getMutationMetrics();
            Assert.assertEquals((long)3L, (long)((Long)((Map)mutationMetrics.get(tableName)).get(MetricType.MUTATION_BATCH_SIZE)));
            Assert.assertEquals((long)3L, (long)((Long)((Map)mutationMetrics.get(tableName)).get(MetricType.UPSERT_MUTATION_SQL_COUNTER)));
            Assert.assertEquals((Object)autocommit, (Object)conn.getAutoCommit());
        }
        catch (Throwable throwable) {
            TestUtil.closeStmtAndConn(pstmt, conn);
            throw throwable;
        }
        TestUtil.closeStmtAndConn(pstmt, conn);
        try {
            conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
            pstmt = conn.prepareStatement("select * from " + tableName);
            rs = pstmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((long)2L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertEquals((long)3L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            TestUtil.closeStmtAndConn(pstmt, conn);
        }
        try {
            conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
            conn.setAutoCommit(autocommit);
            stmt = conn.createStatement();
            stmt.addBatch("upsert into " + tableName + " values ('d', 4)");
            stmt.addBatch("upsert into " + tableName + " values ('a', 5)");
            rs = stmt.executeQuery("select count(*) from " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            int[] result = stmt.executeBatch();
            Assert.assertEquals((long)2L, (long)result.length);
            Assert.assertEquals((long)result[0], (long)1L);
            Assert.assertEquals((long)result[1], (long)1L);
            conn.commit();
        }
        catch (Throwable throwable) {
            TestUtil.closeStmtAndConn(stmt, conn);
            throw throwable;
        }
        TestUtil.closeStmtAndConn(stmt, conn);
        try {
            conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
            stmt = conn.createStatement();
            rs = stmt.executeQuery("select * from " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((long)5L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((long)2L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertEquals((long)3L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"d", (Object)rs.getString(1));
            Assert.assertEquals((long)4L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            TestUtil.closeStmtAndConn(stmt, conn);
        }
        try {
            conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
            conn.setAutoCommit(autocommit);
            stmt = conn.createStatement();
            stmt.addBatch("delete from " + tableName + " where v <= 4");
            stmt.addBatch("delete from " + tableName + " where v = 5");
            int[] result = stmt.executeBatch();
            Assert.assertEquals((long)2L, (long)result.length);
            Assert.assertEquals((long)result[0], (long)3L);
            Assert.assertEquals((long)result[1], (long)1L);
            conn.commit();
        }
        finally {
            TestUtil.closeStmtAndConn(stmt, conn);
        }
        try {
            conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
            pstmt = conn.prepareStatement("select count(*) from " + tableName);
            rs = pstmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)rs.getInt(1));
        }
        finally {
            TestUtil.closeStmtAndConn(stmt, conn);
        }
    }

    @Test
    public void testBatchedUpsert() throws Exception {
        this.testBatchedUpsert(false);
    }

    @Test
    public void testBatchedUpsertAutoCommit() throws Exception {
        this.testBatchedUpsert(true);
    }

    @Test
    public void testBatchedUpsertMultipleBatches() throws Exception {
        String tableName = UpsertValuesIT.generateUniqueName();
        Properties props = new Properties();
        try (Connection conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);){
            conn.createStatement().execute("create table " + tableName + " (k varchar primary key, v integer)");
            PreparedStatement pstmt = conn.prepareStatement("upsert into " + tableName + " values (?, ?)");
            pstmt.setString(1, "a");
            pstmt.setInt(2, 1);
            pstmt.addBatch();
            pstmt.executeBatch();
            pstmt.setString(1, "b");
            pstmt.setInt(2, 2);
            pstmt.addBatch();
            pstmt.executeBatch();
            conn.commit();
        }
        conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select count(*) from " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    private void testBatchRollback(boolean autocommit) throws Exception {
        String tableName = UpsertValuesIT.generateUniqueName();
        Properties props = new Properties();
        try (Connection conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);){
            conn.createStatement().execute("create table " + tableName + " (k varchar primary key, v integer)");
            conn.setAutoCommit(autocommit);
            PreparedStatement pstmt = conn.prepareStatement("upsert into " + tableName + " values (?, ?)");
            pstmt.setString(1, "a");
            pstmt.setInt(2, 1);
            pstmt.addBatch();
            pstmt.executeBatch();
            conn.rollback();
        }
        conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select count(*) from " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)(autocommit ? 1L : 0L), (long)rs.getInt(1));
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Test
    public void testBatchRollback() throws Exception {
        this.testBatchRollback(false);
    }

    @Test
    public void testBatchNoRollbackWithAutoCommit() throws Exception {
        this.testBatchRollback(true);
    }

    @Test
    public void testDQLFailsInBatch() throws Exception {
        String tableName = UpsertValuesIT.generateUniqueName();
        Properties props = new Properties();
        try (Connection conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);){
            conn.createStatement().execute("create table " + tableName + " (k varchar primary key, v integer)");
            Statement stmt = conn.createStatement();
            stmt.addBatch("select * from " + tableName);
            BatchUpdateException ex = (BatchUpdateException)Assert.assertThrows(BatchUpdateException.class, () -> stmt.executeBatch());
            Assert.assertEquals((Object)"java.sql.BatchUpdateException: ERROR 1151 (XCL51): A batch operation can't include a statement that produces result sets.", (Object)ex.getMessage());
        }
    }

    private static Date toDate(String dateString) {
        return DateUtil.parseDate((String)dateString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpsertDateIntoDescUnsignedDate() throws Exception {
        String tableName = UpsertValuesIT.generateUniqueName();
        Properties props = new Properties();
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
            conn.createStatement().execute("create table " + tableName + " (k varchar, v unsigned_date not null, constraint pk primary key (k,v desc))");
        }
        finally {
            TestUtil.closeStmtAndConn(stmt, conn);
        }
        String dateStr = "2013-01-01 04:00:00";
        try {
            conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
            stmt = conn.prepareStatement("upsert into " + tableName + "(k,v) values ('a', to_date(?))");
            stmt.setString(1, dateStr);
            stmt.executeUpdate();
            conn.commit();
        }
        catch (Throwable throwable) {
            TestUtil.closeStmtAndConn(stmt, conn);
            throw throwable;
        }
        TestUtil.closeStmtAndConn(stmt, conn);
        Date date = UpsertValuesIT.toDate(dateStr);
        try {
            conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
            stmt = conn.prepareStatement("select * from " + tableName);
            ResultSet rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)date, (Object)rs.getDate(2));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            TestUtil.closeStmtAndConn(stmt, conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpsertDateString() throws Exception {
        String tableName = UpsertValuesIT.generateUniqueName();
        Properties props = new Properties();
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
            conn.createStatement().execute("create table " + tableName + " (k varchar, v date not null, t timestamp, tt time constraint pk primary key (k,v desc))");
        }
        finally {
            TestUtil.closeStmtAndConn(stmt, conn);
        }
        String dateStr = "2013-01-01";
        String timeStampStr = "2013-01-01 04:00:00.123456";
        String timeStr = "2013-01-01 04:00:00";
        try {
            conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
            stmt = conn.prepareStatement("upsert into " + tableName + "(k,v,t,tt) values ('a', ?, ?, ?)");
            stmt.setString(1, dateStr);
            stmt.setString(2, timeStampStr);
            stmt.setString(3, timeStr);
            stmt.executeUpdate();
            conn.commit();
        }
        catch (Throwable throwable) {
            TestUtil.closeStmtAndConn(stmt, conn);
            throw throwable;
        }
        TestUtil.closeStmtAndConn(stmt, conn);
        Date date = UpsertValuesIT.toDate(dateStr);
        Timestamp timeStamp = new Timestamp(UpsertValuesIT.toDate(timeStampStr).getTime());
        timeStamp.setNanos(Timestamp.valueOf(timeStampStr).getNanos());
        Time time = new Time(UpsertValuesIT.toDate(timeStr).getTime());
        try {
            conn = DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
            stmt = conn.prepareStatement("select * from " + tableName);
            ResultSet rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)date, (Object)rs.getDate(2));
            Assert.assertEquals((Object)timeStamp, (Object)rs.getTimestamp(3));
            Assert.assertEquals((Object)time, (Object)rs.getTime(4));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            TestUtil.closeStmtAndConn(stmt, conn);
        }
    }

    @Test
    public void testAutoCastLongToBigDecimal() throws Exception {
        try (Connection conn = DriverManager.getConnection(UpsertValuesIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE LONG_BUG (NAME VARCHAR PRIMARY KEY, AMOUNT DECIMAL)");
        }
        conn = DriverManager.getConnection(UpsertValuesIT.getUrl());
        try {
            conn.createStatement().execute("UPSERT INTO LONG_BUG (NAME, AMOUNT) VALUES('HELLO1', -50000)");
            conn.commit();
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        conn = DriverManager.getConnection(UpsertValuesIT.getUrl());
        try {
            ResultSet rs = conn.createStatement().executeQuery("SELECT NAME, AMOUNT FROM LONG_BUG");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"HELLO1", (Object)rs.getString(1));
            Assert.assertTrue((new BigDecimal(-50000).compareTo(rs.getBigDecimal(2)) == 0 ? 1 : 0) != 0);
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public void testColumnQualifierForUpsertedValues() throws Exception {
        String schemaName = "A";
        String tableName = "TEST";
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String ddl = "create table " + fullTableName + " ( K varchar primary key, CF1.V1 varchar, CF2.V2 VARCHAR, CF2.V3 VARCHAR)";
        try (Connection conn = DriverManager.getConnection(UpsertValuesIT.getUrl());){
            conn.createStatement().execute(ddl);
        }
        String dml = "UPSERT INTO " + fullTableName + " VALUES (?, ?, ?, ?)";
        try (Connection conn = DriverManager.getConnection(UpsertValuesIT.getUrl());){
            PreparedStatement stmt = conn.prepareStatement(dml);
            stmt.setString(1, "KEY1");
            stmt.setString(2, "VALUE1");
            stmt.setString(3, "VALUE2");
            stmt.setString(4, "VALUE3");
            stmt.executeUpdate();
            conn.commit();
        }
        conn = DriverManager.getConnection(UpsertValuesIT.getUrl());
        try {
            Table table = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(Bytes.toBytes((String)fullTableName));
            ResultScanner scanner = table.getScanner(new Scan());
            Result next = scanner.next();
            Assert.assertTrue((boolean)next.containsColumn(Bytes.toBytes((String)"CF1"), PInteger.INSTANCE.toBytes((Object)1)));
            Assert.assertTrue((boolean)next.containsColumn(Bytes.toBytes((String)"CF2"), PInteger.INSTANCE.toBytes((Object)2)));
            Assert.assertTrue((boolean)next.containsColumn(Bytes.toBytes((String)"CF2"), PInteger.INSTANCE.toBytes((Object)3)));
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Test
    public void testUpsertValueWithDiffSequenceAndConnections() throws Exception {
        String tableName = UpsertValuesIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(UpsertValuesIT.getUrl());){
            conn.setAutoCommit(true);
            PreparedStatement createTableStatement = conn.prepareStatement(String.format("CREATE TABLE IF NOT EXISTS %s (SERVICE VARCHAR NOT NULL, SEQUENCE_NUMBER BIGINT NOT NULL , CONSTRAINT PK PRIMARY KEY (SERVICE, SEQUENCE_NUMBER)) MULTI_TENANT = TRUE", tableName));
            createTableStatement.execute();
        }
        this.testGlobalSequenceUpsertWithTenantConnection(tableName, false);
        this.testGlobalSequenceUpsertWithTenantConnection(tableName, true);
        this.testGlobalSequenceUpsertWithGlobalConnection(tableName);
        this.testTenantSequenceUpsertWithSameTenantConnection(tableName);
        this.testTenantSequenceUpsertWithDifferentTenantConnection(tableName);
        this.testTenantSequenceUpsertWithGlobalConnection(tableName);
    }

    private void testTenantSequenceUpsertWithGlobalConnection(String tableName) throws Exception {
        String sequenceName = UpsertValuesIT.generateUniqueSequenceName();
        try (Connection conn = UpsertValuesIT.getTenantConnection("PHOENIX");){
            conn.setAutoCommit(true);
            PreparedStatement createSequenceStatement = conn.prepareStatement(String.format("CREATE SEQUENCE IF NOT EXISTS %s", sequenceName));
            createSequenceStatement.execute();
        }
        try (Connection tenantConn = DriverManager.getConnection(UpsertValuesIT.getUrl());){
            tenantConn.setAutoCommit(true);
            Statement executeUpdateStatement = tenantConn.createStatement();
            try {
                executeUpdateStatement.execute(String.format("UPSERT INTO %s ( SERVICE, SEQUENCE_NUMBER) VALUES ( 'PHOENIX', NEXT VALUE FOR %s)", tableName, sequenceName));
                Assert.fail();
            }
            catch (SequenceNotFoundException e) {
                Assert.assertTrue((boolean)true);
            }
            catch (Exception e) {
                Assert.fail();
            }
        }
    }

    private void testTenantSequenceUpsertWithDifferentTenantConnection(String tableName) throws Exception {
        String sequenceName = UpsertValuesIT.generateUniqueSequenceName();
        try (Connection conn = UpsertValuesIT.getTenantConnection("PHOENIX");){
            conn.setAutoCommit(true);
            PreparedStatement createSequenceStatement = conn.prepareStatement(String.format("CREATE SEQUENCE IF NOT EXISTS %s", sequenceName));
            createSequenceStatement.execute();
        }
        try (Connection tenantConn = UpsertValuesIT.getTenantConnection("HBASE");){
            tenantConn.setAutoCommit(true);
            Statement executeUpdateStatement = tenantConn.createStatement();
            try {
                executeUpdateStatement.execute(String.format("UPSERT INTO %s ( SEQUENCE_NUMBER) VALUES ( NEXT VALUE FOR %s)", tableName, sequenceName));
                Assert.fail();
            }
            catch (SequenceNotFoundException e) {
                Assert.assertTrue((boolean)true);
            }
            catch (Exception e) {
                Assert.fail();
            }
        }
    }

    private void testTenantSequenceUpsertWithSameTenantConnection(String tableName) throws Exception {
        String sequenceName = UpsertValuesIT.generateUniqueSequenceName();
        try (Connection conn = UpsertValuesIT.getTenantConnection("ZOOKEEPER");){
            conn.setAutoCommit(true);
            PreparedStatement createSequenceStatement = conn.prepareStatement(String.format("CREATE SEQUENCE IF NOT EXISTS %s", sequenceName));
            createSequenceStatement.execute();
            Statement executeUpdateStatement = conn.createStatement();
            executeUpdateStatement.execute(String.format("UPSERT INTO %s ( SEQUENCE_NUMBER) VALUES ( NEXT VALUE FOR %s)", tableName, sequenceName));
            ResultSet rs = executeUpdateStatement.executeQuery("select * from " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"1", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    private void testGlobalSequenceUpsertWithGlobalConnection(String tableName) throws Exception {
        String sequenceName = UpsertValuesIT.generateUniqueSequenceName();
        try (Connection conn = DriverManager.getConnection(UpsertValuesIT.getUrl());){
            conn.setAutoCommit(true);
            PreparedStatement createSequenceStatement = conn.prepareStatement(String.format("CREATE SEQUENCE IF NOT EXISTS %s", sequenceName));
            createSequenceStatement.execute();
            Statement executeUpdateStatement = conn.createStatement();
            executeUpdateStatement.execute(String.format("UPSERT INTO %s ( SERVICE, SEQUENCE_NUMBER) VALUES ( 'PHOENIX', NEXT VALUE FOR %s)", tableName, sequenceName));
            ResultSet rs = executeUpdateStatement.executeQuery("select * from " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"HBASE", (Object)rs.getString(1));
            Assert.assertEquals((Object)"1", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"PHOENIX", (Object)rs.getString(1));
            Assert.assertEquals((Object)"1", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    private void testGlobalSequenceUpsertWithTenantConnection(String tableName, boolean withReturningRow) throws Exception {
        String sequenceName = UpsertValuesIT.generateUniqueSequenceName();
        try (Connection conn = DriverManager.getConnection(UpsertValuesIT.getUrl());){
            conn.setAutoCommit(true);
            PreparedStatement createSequenceStatement = conn.prepareStatement(String.format("CREATE SEQUENCE IF NOT EXISTS %s", sequenceName));
            createSequenceStatement.execute();
        }
        try (Connection tenantConn = UpsertValuesIT.getTenantConnection("HBASE");){
            tenantConn.setAutoCommit(true);
            Statement executeUpdateStatement = tenantConn.createStatement();
            Object sql = String.format("UPSERT INTO %s (SEQUENCE_NUMBER) VALUES (NEXT VALUE FOR %s)", tableName, sequenceName);
            if (withReturningRow) {
                sql = (String)sql + " RETURNING *";
            }
            executeUpdateStatement.execute((String)sql);
            ResultSet rs = withReturningRow ? executeUpdateStatement.getResultSet() : executeUpdateStatement.executeQuery("select * from " + tableName);
            Assert.assertNotNull((Object)rs);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"1", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    private static Connection getTenantConnection(String tenantId) throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("TenantId", tenantId);
        return DriverManager.getConnection(UpsertValuesIT.getUrl(), props);
    }
}

