/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Properties;
import org.apache.hadoop.hbase.TableName;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ParallelStatsDisabledWithRegionMovesIT;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.monitoring.GlobalMetric;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=Parameterized.class)
public class UpsertSelectWithRegionMovesIT
extends ParallelStatsDisabledWithRegionMovesIT {
    private final String allowServerSideMutations;

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        props.put("phoenix.max.lookback.age.seconds", Integer.toString(3600));
        props.put("phoenix.task.handling.interval.ms", Long.toString(Long.MAX_VALUE));
        props.put("phoenix.task.handling.initial.delay.ms", Long.toString(Long.MAX_VALUE));
        props.put("phoenix.server.page.size.ms", Long.toString(0L));
        props.put("phoenix.tests.minicluster.numregionservers", String.valueOf(2));
        props.put("hbase.client.scanner.max.result.size", String.valueOf(1));
        props.put("phoenix.scanning.result.post.dummy.process", ParallelStatsDisabledWithRegionMovesIT.TestScanningResultPostDummyResultCaller.class.getName());
        UpsertSelectWithRegionMovesIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    public UpsertSelectWithRegionMovesIT(String allowServerSideMutations) {
        this.allowServerSideMutations = allowServerSideMutations;
    }

    @Before
    public void setup() {
        hasTestStarted = true;
        Assert.assertTrue((boolean)PhoenixRuntime.areGlobalClientMetricsBeingCollected());
        for (GlobalMetric m : PhoenixRuntime.getGlobalPhoenixClientMetrics()) {
            m.reset();
        }
    }

    @After
    public void assertNoConnLeak() throws Exception {
        countOfDummyResults = 0;
        TABLE_NAMES.clear();
        hasTestStarted = false;
    }

    @Parameterized.Parameters(name="UpsertSelecttIT_allowServerSideMutations={0}")
    public static synchronized Object[] data() {
        return new Object[]{"true", "false"};
    }

    @Test
    public void testUpsertSelectWithNoIndex() throws Exception {
        this.testUpsertSelect(false, false);
    }

    @Test
    public void testUpsertSelectWithIndex() throws Exception {
        this.testUpsertSelect(true, false);
    }

    @Test
    public void testUpsertSelectWithIndexWithSalt() throws Exception {
        this.testUpsertSelect(true, true);
    }

    @Test
    public void testUpsertSelectWithNoIndexWithSalt() throws Exception {
        this.testUpsertSelect(false, true);
    }

    private void testUpsertSelect(boolean createIndex, boolean saltTable) throws Exception {
        ResultSet rs;
        PreparedStatement statement;
        Connection conn;
        String tenantId = UpsertSelectWithRegionMovesIT.getOrganizationId();
        byte[][] splits = UpsertSelectWithRegionMovesIT.getDefaultSplits(tenantId);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        String aTable = UpsertSelectWithRegionMovesIT.initATableValues(tenantId, saltTable ? null : splits, null, null, UpsertSelectWithRegionMovesIT.getUrl(), saltTable ? "salt_buckets = 2" : null);
        String customEntityTable = UpsertSelectWithRegionMovesIT.generateUniqueName();
        TABLE_NAMES.add(customEntityTable);
        try (Connection conn2 = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
             Statement stmt = conn2.createStatement();){
            String ddl = "create table " + customEntityTable + "   (organization_id char(15) not null, \n    key_prefix char(3) not null,\n    custom_entity_data_id char(12) not null,\n    created_by varchar,\n    created_date date,\n    currency_iso_code char(3),\n    deleted char(1),\n    division decimal(31,10),\n    last_activity date,\n    last_update date,\n    last_update_by varchar,\n    name varchar(240),\n    owner varchar,\n    record_type_id char(15),\n    setup_owner varchar,\n    system_modstamp date,\n    b.val0 varchar,\n    b.val1 varchar,\n    b.val2 varchar,\n    b.val3 varchar,\n    b.val4 varchar,\n    b.val5 varchar,\n    b.val6 varchar,\n    b.val7 varchar,\n    b.val8 varchar,\n    b.val9 varchar\n    CONSTRAINT pk PRIMARY KEY (organization_id, key_prefix, custom_entity_data_id)) " + (saltTable ? "salt_buckets = 2" : "");
            stmt.execute(ddl);
        }
        String indexName = UpsertSelectWithRegionMovesIT.generateUniqueName();
        if (createIndex) {
            conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
            try (Statement stmt = conn.createStatement();){
                stmt.execute("CREATE INDEX IF NOT EXISTS " + indexName + " ON " + aTable + "(a_string)");
                TABLE_NAMES.add(indexName);
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        props.setProperty("UpsertBatchSize", Integer.toString(3));
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            PreparedStatement upsertStmt;
            conn.setAutoCommit(true);
            String upsert = "UPSERT INTO " + customEntityTable + "(custom_entity_data_id, key_prefix, organization_id, created_by) SELECT substr(entity_id, 4), substr(entity_id, 1, 3), organization_id, a_string  FROM " + aTable + " WHERE ?=a_string";
            if (createIndex) {
                upsertStmt = conn.prepareStatement("EXPLAIN " + upsert);
                try {
                    upsertStmt.setString(1, tenantId);
                    ResultSet ers = upsertStmt.executeQuery();
                    Assert.assertTrue((boolean)ers.next());
                    String explainPlan = QueryUtil.getExplainPlan((ResultSet)ers);
                    Assert.assertTrue((boolean)explainPlan.contains(" SCAN OVER " + indexName));
                }
                finally {
                    if (upsertStmt != null) {
                        upsertStmt.close();
                    }
                }
            }
            upsertStmt = conn.prepareStatement(upsert);
            try {
                upsertStmt.setString(1, "a");
                int rowsInserted = upsertStmt.executeUpdate();
                Assert.assertEquals((long)4L, (long)rowsInserted);
            }
            finally {
                if (upsertStmt != null) {
                    upsertStmt.close();
                }
            }
            conn.commit();
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        String query = "SELECT key_prefix, substr(custom_entity_data_id, 1, 1), created_by FROM " + customEntityTable + " WHERE organization_id = ? ";
        try (Connection conn3 = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);){
            statement = conn3.prepareStatement(query);
            try {
                statement.setString(1, tenantId);
                rs = statement.executeQuery();
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"00A", (Object)rs.getString(1));
                Assert.assertEquals((Object)"1", (Object)rs.getString(2));
                Assert.assertEquals((Object)"a", (Object)rs.getString(3));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"00A", (Object)rs.getString(1));
                Assert.assertEquals((Object)"2", (Object)rs.getString(2));
                Assert.assertEquals((Object)"a", (Object)rs.getString(3));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"00A", (Object)rs.getString(1));
                Assert.assertEquals((Object)"3", (Object)rs.getString(2));
                Assert.assertEquals((Object)"a", (Object)rs.getString(3));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"00A", (Object)rs.getString(1));
                Assert.assertEquals((Object)"4", (Object)rs.getString(2));
                Assert.assertEquals((Object)"a", (Object)rs.getString(3));
                Assert.assertFalse((boolean)rs.next());
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        conn3 = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            conn3.setAutoCommit(true);
            String upsert = "UPSERT INTO " + customEntityTable + "(custom_entity_data_id, key_prefix, organization_id, last_update_by, division) SELECT custom_entity_data_id, key_prefix, organization_id, created_by, 1.0  FROM " + customEntityTable + " WHERE organization_id = ? and created_by >= 'a'";
            try (PreparedStatement upsertStmt = conn3.prepareStatement(upsert);){
                upsertStmt.setString(1, tenantId);
                Assert.assertEquals((long)4L, (long)upsertStmt.executeUpdate());
            }
            conn3.commit();
        }
        finally {
            if (conn3 != null) {
                conn3.close();
            }
        }
        query = "SELECT key_prefix, substr(custom_entity_data_id, 1, 1), created_by, last_update_by, division FROM " + customEntityTable + " WHERE organization_id = ?";
        conn3 = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            statement = conn3.prepareStatement(query);
            try {
                statement.setString(1, tenantId);
                rs = statement.executeQuery();
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"00A", (Object)rs.getString(1));
                Assert.assertEquals((Object)"1", (Object)rs.getString(2));
                Assert.assertEquals((Object)"a", (Object)rs.getString(3));
                Assert.assertEquals((Object)"a", (Object)rs.getString(4));
                Assert.assertTrue((BigDecimal.valueOf(1.0).compareTo(rs.getBigDecimal(5)) == 0 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"00A", (Object)rs.getString(1));
                Assert.assertEquals((Object)"2", (Object)rs.getString(2));
                Assert.assertEquals((Object)"a", (Object)rs.getString(3));
                Assert.assertEquals((Object)"a", (Object)rs.getString(4));
                Assert.assertTrue((BigDecimal.valueOf(1.0).compareTo(rs.getBigDecimal(5)) == 0 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"00A", (Object)rs.getString(1));
                Assert.assertEquals((Object)"3", (Object)rs.getString(2));
                Assert.assertEquals((Object)"a", (Object)rs.getString(3));
                Assert.assertEquals((Object)"a", (Object)rs.getString(4));
                Assert.assertTrue((BigDecimal.valueOf(1.0).compareTo(rs.getBigDecimal(5)) == 0 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"00A", (Object)rs.getString(1));
                Assert.assertEquals((Object)"4", (Object)rs.getString(2));
                Assert.assertEquals((Object)"a", (Object)rs.getString(3));
                Assert.assertEquals((Object)"a", (Object)rs.getString(4));
                Assert.assertTrue((BigDecimal.valueOf(1.0).compareTo(rs.getBigDecimal(5)) == 0 ? 1 : 0) != 0);
                Assert.assertFalse((boolean)rs.next());
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        finally {
            if (conn3 != null) {
                conn3.close();
            }
        }
    }

    @Test
    public void testUpsertSelectEmptyPKColumn() throws Exception {
        PreparedStatement statement;
        ResultSet rs;
        int rowsInserted;
        String upsert;
        String tenantId = UpsertSelectWithRegionMovesIT.getOrganizationId();
        String aTable = UpsertSelectWithRegionMovesIT.initATableValues(tenantId, UpsertSelectWithRegionMovesIT.getDefaultSplits(tenantId));
        String ptsdbTable = UpsertSelectWithRegionMovesIT.generateUniqueName();
        TABLE_NAMES.add(ptsdbTable);
        UpsertSelectWithRegionMovesIT.ensureTableCreated(UpsertSelectWithRegionMovesIT.getUrl(), ptsdbTable, "PTSDB");
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);){
            conn.setAutoCommit(false);
            upsert = "UPSERT INTO " + ptsdbTable + "(\"DATE\", val, host) SELECT current_date(), x_integer+2, entity_id FROM " + aTable + " WHERE a_integer >= ?";
            try (PreparedStatement upsertStmt = conn.prepareStatement(upsert);){
                upsertStmt.setInt(1, 6);
                rowsInserted = upsertStmt.executeUpdate();
                Assert.assertEquals((long)4L, (long)rowsInserted);
            }
            conn.commit();
        }
        String query = "SELECT inst,host,\"DATE\",val FROM " + ptsdbTable;
        try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
             PreparedStatement statement2 = conn.prepareStatement(query);){
            rs = statement2.executeQuery();
            Date now = new Date(EnvironmentEdgeManager.currentTimeMillis());
            Assert.assertTrue((boolean)rs.next());
            UpsertSelectWithRegionMovesIT.moveRegionsOfTable(ptsdbTable);
            UpsertSelectWithRegionMovesIT.moveRegionsOfTable(aTable);
            Assert.assertEquals(null, (Object)rs.getString(1));
            Assert.assertEquals((Object)"00B623122312312", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.getDate(3).before(now));
            Assert.assertEquals(null, (Object)rs.getBigDecimal(4));
            Assert.assertTrue((boolean)rs.next());
            UpsertSelectWithRegionMovesIT.moveRegionsOfTable(ptsdbTable);
            UpsertSelectWithRegionMovesIT.moveRegionsOfTable(aTable);
            Assert.assertEquals(null, (Object)rs.getString(1));
            Assert.assertEquals((Object)"00B723122312312", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.getDate(3).before(now));
            Assert.assertTrue((BigDecimal.valueOf(7L).compareTo(rs.getBigDecimal(4)) == 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals(null, (Object)rs.getString(1));
            Assert.assertEquals((Object)"00B823122312312", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.getDate(3).before(now));
            Assert.assertTrue((BigDecimal.valueOf(6L).compareTo(rs.getBigDecimal(4)) == 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals(null, (Object)rs.getString(1));
            Assert.assertEquals((Object)"00C923122312312", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.getDate(3).before(now));
            Assert.assertTrue((BigDecimal.valueOf(5L).compareTo(rs.getBigDecimal(4)) == 0 ? 1 : 0) != 0);
            Assert.assertFalse((boolean)rs.next());
        }
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            conn.setAutoCommit(true);
            upsert = "UPSERT INTO " + ptsdbTable + "(\"DATE\", val, inst) SELECT \"DATE\"+1, val*10, host FROM " + ptsdbTable;
            try (PreparedStatement upsertStmt = conn.prepareStatement(upsert);){
                rowsInserted = upsertStmt.executeUpdate();
                Assert.assertEquals((long)4L, (long)rowsInserted);
            }
            conn.commit();
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        Date now = new Date(EnvironmentEdgeManager.currentTimeMillis());
        Date then = new Date(now.getTime() + 86400000L);
        query = "SELECT host,inst, \"DATE\",val FROM " + ptsdbTable + " where inst is not null";
        try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);){
            statement = conn.prepareStatement(query);
            try {
                rs = statement.executeQuery();
                Assert.assertTrue((boolean)rs.next());
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(ptsdbTable);
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(aTable);
                Assert.assertEquals(null, (Object)rs.getString(1));
                Assert.assertEquals((Object)"00B623122312312", (Object)rs.getString(2));
                Assert.assertTrue((rs.getDate(3).after(now) && rs.getDate(3).before(then) ? 1 : 0) != 0);
                Assert.assertEquals(null, (Object)rs.getBigDecimal(4));
                Assert.assertTrue((boolean)rs.next());
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(ptsdbTable);
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(aTable);
                Assert.assertEquals(null, (Object)rs.getString(1));
                Assert.assertEquals((Object)"00B723122312312", (Object)rs.getString(2));
                Assert.assertTrue((rs.getDate(3).after(now) && rs.getDate(3).before(then) ? 1 : 0) != 0);
                Assert.assertTrue((BigDecimal.valueOf(70L).compareTo(rs.getBigDecimal(4)) == 0 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)rs.next());
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(ptsdbTable);
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(aTable);
                Assert.assertEquals(null, (Object)rs.getString(1));
                Assert.assertEquals((Object)"00B823122312312", (Object)rs.getString(2));
                Assert.assertTrue((rs.getDate(3).after(now) && rs.getDate(3).before(then) ? 1 : 0) != 0);
                Assert.assertTrue((BigDecimal.valueOf(60L).compareTo(rs.getBigDecimal(4)) == 0 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals(null, (Object)rs.getString(1));
                Assert.assertEquals((Object)"00C923122312312", (Object)rs.getString(2));
                Assert.assertTrue((rs.getDate(3).after(now) && rs.getDate(3).before(then) ? 1 : 0) != 0);
                Assert.assertTrue((BigDecimal.valueOf(50L).compareTo(rs.getBigDecimal(4)) == 0 ? 1 : 0) != 0);
                Assert.assertFalse((boolean)rs.next());
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            conn.setAutoCommit(true);
            upsert = "UPSERT INTO " + ptsdbTable + " SELECT * FROM " + ptsdbTable;
            try (PreparedStatement upsertStmt = conn.prepareStatement(upsert);){
                TestUtil.dumpTable(conn, TableName.valueOf((String)ptsdbTable));
                rowsInserted = upsertStmt.executeUpdate();
                Assert.assertEquals((long)8L, (long)rowsInserted);
            }
            conn.commit();
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        query = "SELECT * FROM " + ptsdbTable;
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            statement = conn.prepareStatement(query);
            try {
                rs = statement.executeQuery();
                Assert.assertTrue((boolean)rs.next());
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(ptsdbTable);
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(aTable);
                Assert.assertEquals(null, (Object)rs.getString(1));
                Assert.assertEquals((Object)"00B623122312312", (Object)rs.getString(2));
                Assert.assertTrue((boolean)rs.getDate(3).before(now));
                Assert.assertEquals(null, (Object)rs.getBigDecimal(4));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals(null, (Object)rs.getString(1));
                Assert.assertEquals((Object)"00B723122312312", (Object)rs.getString(2));
                Assert.assertTrue((boolean)rs.getDate(3).before(now));
                Assert.assertTrue((BigDecimal.valueOf(7L).compareTo(rs.getBigDecimal(4)) == 0 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals(null, (Object)rs.getString(1));
                Assert.assertEquals((Object)"00B823122312312", (Object)rs.getString(2));
                Assert.assertTrue((boolean)rs.getDate(3).before(now));
                Assert.assertTrue((BigDecimal.valueOf(6L).compareTo(rs.getBigDecimal(4)) == 0 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)rs.next());
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(ptsdbTable);
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(aTable);
                Assert.assertEquals(null, (Object)rs.getString(1));
                Assert.assertEquals((Object)"00C923122312312", (Object)rs.getString(2));
                Assert.assertTrue((boolean)rs.getDate(3).before(now));
                Assert.assertTrue((BigDecimal.valueOf(5L).compareTo(rs.getBigDecimal(4)) == 0 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"00B623122312312", (Object)rs.getString(1));
                Assert.assertEquals(null, (Object)rs.getString(2));
                Assert.assertTrue((rs.getDate(3).after(now) && rs.getDate(3).before(then) ? 1 : 0) != 0);
                Assert.assertEquals(null, (Object)rs.getBigDecimal(4));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"00B723122312312", (Object)rs.getString(1));
                Assert.assertEquals(null, (Object)rs.getString(2));
                Assert.assertTrue((rs.getDate(3).after(now) && rs.getDate(3).before(then) ? 1 : 0) != 0);
                Assert.assertTrue((BigDecimal.valueOf(70L).compareTo(rs.getBigDecimal(4)) == 0 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)rs.next());
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(ptsdbTable);
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(aTable);
                Assert.assertEquals((Object)"00B823122312312", (Object)rs.getString(1));
                Assert.assertEquals(null, (Object)rs.getString(2));
                Assert.assertTrue((rs.getDate(3).after(now) && rs.getDate(3).before(then) ? 1 : 0) != 0);
                Assert.assertTrue((BigDecimal.valueOf(60L).compareTo(rs.getBigDecimal(4)) == 0 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"00C923122312312", (Object)rs.getString(1));
                Assert.assertEquals(null, (Object)rs.getString(2));
                Assert.assertTrue((rs.getDate(3).after(now) && rs.getDate(3).before(then) ? 1 : 0) != 0);
                Assert.assertTrue((BigDecimal.valueOf(50L).compareTo(rs.getBigDecimal(4)) == 0 ? 1 : 0) != 0);
                Assert.assertFalse((boolean)rs.next());
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Test
    public void testUpsertSelectForAggAutoCommit() throws Exception {
        this.testUpsertSelectForAgg(true);
    }

    @Test
    public void testUpsertSelectForAgg() throws Exception {
        this.testUpsertSelectForAgg(false);
    }

    private void testUpsertSelectForAgg(boolean autoCommit) throws Exception {
        ResultSet rs;
        PreparedStatement statement;
        String tenantId = UpsertSelectWithRegionMovesIT.getOrganizationId();
        String aTable = UpsertSelectWithRegionMovesIT.initATableValues(tenantId, UpsertSelectWithRegionMovesIT.getDefaultSplits(tenantId));
        String ptsdbTable = UpsertSelectWithRegionMovesIT.generateUniqueName();
        TABLE_NAMES.add(aTable);
        TABLE_NAMES.add(ptsdbTable);
        UpsertSelectWithRegionMovesIT.ensureTableCreated(UpsertSelectWithRegionMovesIT.getUrl(), ptsdbTable, "PTSDB");
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);){
            conn.setAutoCommit(autoCommit);
            String upsert = "UPSERT INTO " + ptsdbTable + "(\"DATE\", val, host) SELECT current_date(), sum(a_integer), a_string FROM " + aTable + " GROUP BY a_string";
            try (PreparedStatement upsertStmt = conn.prepareStatement(upsert);){
                int rowsInserted = upsertStmt.executeUpdate();
                Assert.assertEquals((long)3L, (long)rowsInserted);
            }
            if (!autoCommit) {
                conn.commit();
            }
        }
        String query = "SELECT inst,host,\"DATE\",val FROM " + ptsdbTable;
        try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);){
            statement = conn.prepareStatement(query);
            try {
                rs = statement.executeQuery();
                Date now = new Date(EnvironmentEdgeManager.currentTimeMillis());
                Assert.assertTrue((boolean)rs.next());
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(ptsdbTable);
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(aTable);
                Assert.assertEquals(null, (Object)rs.getString(1));
                Assert.assertEquals((Object)"a", (Object)rs.getString(2));
                Assert.assertTrue((boolean)rs.getDate(3).before(now));
                Assert.assertTrue((BigDecimal.valueOf(10L).compareTo(rs.getBigDecimal(4)) == 0 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals(null, (Object)rs.getString(1));
                Assert.assertEquals((Object)"b", (Object)rs.getString(2));
                Assert.assertTrue((boolean)rs.getDate(3).before(now));
                Assert.assertTrue((BigDecimal.valueOf(26L).compareTo(rs.getBigDecimal(4)) == 0 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals(null, (Object)rs.getString(1));
                Assert.assertEquals((Object)"c", (Object)rs.getString(2));
                Assert.assertTrue((boolean)rs.getDate(3).before(now));
                Assert.assertTrue((BigDecimal.valueOf(9L).compareTo(rs.getBigDecimal(4)) == 0 ? 1 : 0) != 0);
                Assert.assertFalse((boolean)rs.next());
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            conn.setAutoCommit(true);
            String upsert = "UPSERT INTO " + ptsdbTable + "(\"DATE\", val, host, inst) SELECT current_date(), max(val), max(host), 'x' FROM " + ptsdbTable;
            try (PreparedStatement upsertStmt = conn.prepareStatement(upsert);){
                int rowsInserted = upsertStmt.executeUpdate();
                Assert.assertEquals((long)1L, (long)rowsInserted);
            }
            if (!autoCommit) {
                conn.commit();
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        query = "SELECT inst,host,\"DATE\",val FROM " + ptsdbTable + " WHERE inst='x'";
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            statement = conn.prepareStatement(query);
            try {
                rs = statement.executeQuery();
                Date now = new Date(EnvironmentEdgeManager.currentTimeMillis());
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"x", (Object)rs.getString(1));
                Assert.assertEquals((Object)"c", (Object)rs.getString(2));
                Assert.assertTrue((boolean)rs.getDate(3).before(now));
                Assert.assertTrue((BigDecimal.valueOf(26L).compareTo(rs.getBigDecimal(4)) == 0 ? 1 : 0) != 0);
                Assert.assertFalse((boolean)rs.next());
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Test
    public void testUpsertSelectLongToInt() throws Exception {
        int rowsInserted;
        PreparedStatement upsertStmt;
        byte[][] splits = new byte[][]{PInteger.INSTANCE.toBytes((Object)1), PInteger.INSTANCE.toBytes((Object)2), PInteger.INSTANCE.toBytes((Object)3), PInteger.INSTANCE.toBytes((Object)4)};
        String tableName = UpsertSelectWithRegionMovesIT.generateUniqueName();
        TABLE_NAMES.add(tableName);
        UpsertSelectWithRegionMovesIT.ensureTableCreated(UpsertSelectWithRegionMovesIT.getUrl(), tableName, "IntKeyTest", splits, null);
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        String upsert = "UPSERT INTO " + tableName + " VALUES(1)";
        try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);){
            upsertStmt = conn.prepareStatement(upsert);
            try {
                rowsInserted = upsertStmt.executeUpdate();
                Assert.assertEquals((long)1L, (long)rowsInserted);
                conn.commit();
            }
            finally {
                if (upsertStmt != null) {
                    upsertStmt.close();
                }
            }
        }
        upsert = "UPSERT INTO " + tableName + "  select i+1 from " + tableName;
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            upsertStmt = conn.prepareStatement(upsert);
            try {
                rowsInserted = upsertStmt.executeUpdate();
                Assert.assertEquals((long)1L, (long)rowsInserted);
                conn.commit();
            }
            finally {
                if (upsertStmt != null) {
                    upsertStmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        String select = "SELECT i FROM " + tableName;
        try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
             Statement stmt = conn.createStatement();){
            ResultSet rs = stmt.executeQuery(select);
            Assert.assertTrue((boolean)rs.next());
            UpsertSelectWithRegionMovesIT.moveRegionsOfTable(tableName);
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertTrue((boolean)rs.next());
            UpsertSelectWithRegionMovesIT.moveRegionsOfTable(tableName);
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testUpsertSelectRunOnServer() throws Exception {
        PreparedStatement upsertStmt;
        ResultSet rs;
        Statement stmt;
        int rowsInserted;
        byte[][] splits = new byte[][]{PInteger.INSTANCE.toBytes((Object)1), PInteger.INSTANCE.toBytes((Object)2), PInteger.INSTANCE.toBytes((Object)3), PInteger.INSTANCE.toBytes((Object)4)};
        String tableName = UpsertSelectWithRegionMovesIT.generateUniqueName();
        TABLE_NAMES.add(tableName);
        UpsertSelectWithRegionMovesIT.createTestTable(UpsertSelectWithRegionMovesIT.getUrl(), "create table " + tableName + " (i integer not null primary key desc, j integer)", splits, null);
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        String upsert = "UPSERT INTO " + tableName + " VALUES(1, 1)";
        try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
             PreparedStatement upsertStmt2 = conn.prepareStatement(upsert);){
            rowsInserted = upsertStmt2.executeUpdate();
            Assert.assertEquals((long)1L, (long)rowsInserted);
            conn.commit();
        }
        String select = "SELECT i,j+1 FROM " + tableName;
        try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);){
            stmt = conn.createStatement();
            try {
                rs = stmt.executeQuery(select);
                Assert.assertTrue((boolean)rs.next());
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(tableName);
                Assert.assertEquals((long)1L, (long)rs.getInt(1));
                Assert.assertEquals((long)2L, (long)rs.getInt(2));
                Assert.assertFalse((boolean)rs.next());
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        upsert = "UPSERT INTO " + tableName + "(i,j) select i, j+1 from " + tableName;
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            conn.setAutoCommit(true);
            upsertStmt = conn.prepareStatement(upsert);
            try {
                rowsInserted = upsertStmt.executeUpdate();
                Assert.assertEquals((long)1L, (long)rowsInserted);
            }
            finally {
                if (upsertStmt != null) {
                    upsertStmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        select = "SELECT j FROM " + tableName;
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            stmt = conn.createStatement();
            try {
                rs = stmt.executeQuery(select);
                Assert.assertTrue((boolean)rs.next());
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(tableName);
                Assert.assertEquals((long)2L, (long)rs.getInt(1));
                Assert.assertFalse((boolean)rs.next());
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        upsert = "UPSERT INTO " + tableName + "(i,j) select i, i from " + tableName;
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            conn.setAutoCommit(true);
            upsertStmt = conn.prepareStatement(upsert);
            try {
                rowsInserted = upsertStmt.executeUpdate();
                Assert.assertEquals((long)1L, (long)rowsInserted);
            }
            finally {
                if (upsertStmt != null) {
                    upsertStmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        select = "SELECT j FROM " + tableName;
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            stmt = conn.createStatement();
            try {
                rs = stmt.executeQuery(select);
                Assert.assertTrue((boolean)rs.next());
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(tableName);
                Assert.assertEquals((long)1L, (long)rs.getInt(1));
                Assert.assertFalse((boolean)rs.next());
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Test
    public void testUpsertSelectOnDescToAsc() throws Exception {
        int rowsInserted;
        PreparedStatement upsertStmt;
        byte[][] splits = new byte[][]{PInteger.INSTANCE.toBytes((Object)1), PInteger.INSTANCE.toBytes((Object)2), PInteger.INSTANCE.toBytes((Object)3), PInteger.INSTANCE.toBytes((Object)4)};
        String tableName = UpsertSelectWithRegionMovesIT.generateUniqueName();
        TABLE_NAMES.add(tableName);
        UpsertSelectWithRegionMovesIT.createTestTable(UpsertSelectWithRegionMovesIT.getUrl(), "create table " + tableName + " (i integer not null primary key desc, j integer)", splits, null);
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        String upsert = "UPSERT INTO " + tableName + " VALUES(1, 1)";
        try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);){
            upsertStmt = conn.prepareStatement(upsert);
            try {
                rowsInserted = upsertStmt.executeUpdate();
                Assert.assertEquals((long)1L, (long)rowsInserted);
                conn.commit();
            }
            finally {
                if (upsertStmt != null) {
                    upsertStmt.close();
                }
            }
        }
        upsert = "UPSERT INTO " + tableName + " (i,j) select i+1, j+1 from " + tableName;
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            conn.setAutoCommit(true);
            upsertStmt = conn.prepareStatement(upsert);
            try {
                rowsInserted = upsertStmt.executeUpdate();
                Assert.assertEquals((long)1L, (long)rowsInserted);
            }
            finally {
                if (upsertStmt != null) {
                    upsertStmt.close();
                }
            }
            conn.commit();
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        String select = "SELECT i,j FROM " + tableName;
        try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
             Statement stmt = conn.createStatement();){
            ResultSet rs = stmt.executeQuery(select);
            Assert.assertTrue((boolean)rs.next());
            UpsertSelectWithRegionMovesIT.moveRegionsOfTable(tableName);
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertEquals((long)2L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testUpsertSelectRowKeyMutationOnSplitedTable() throws Exception {
        PreparedStatement upsertStmt;
        byte[][] splits = new byte[][]{PInteger.INSTANCE.toBytes((Object)1), PInteger.INSTANCE.toBytes((Object)2), PInteger.INSTANCE.toBytes((Object)3), PInteger.INSTANCE.toBytes((Object)4)};
        String tableName = UpsertSelectWithRegionMovesIT.generateUniqueName();
        TABLE_NAMES.add(tableName);
        UpsertSelectWithRegionMovesIT.ensureTableCreated(UpsertSelectWithRegionMovesIT.getUrl(), tableName, "IntKeyTest", splits, null, null);
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        String upsert = "UPSERT INTO " + tableName + " VALUES(?)";
        try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);){
            upsertStmt = conn.prepareStatement(upsert);
            try {
                upsertStmt.setInt(1, 1);
                upsertStmt.executeUpdate();
                upsertStmt.setInt(1, 3);
                upsertStmt.executeUpdate();
                conn.commit();
            }
            finally {
                if (upsertStmt != null) {
                    upsertStmt.close();
                }
            }
        }
        upsert = "UPSERT INTO " + tableName + " (i) SELECT i+1 from " + tableName;
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            conn.setAutoCommit(true);
            upsertStmt = conn.prepareStatement(upsert);
            try {
                int rowsInserted = upsertStmt.executeUpdate();
                Assert.assertEquals((long)2L, (long)rowsInserted);
            }
            finally {
                if (upsertStmt != null) {
                    upsertStmt.close();
                }
            }
            conn.commit();
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        String select = "SELECT i FROM " + tableName;
        try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
             Statement stmt = conn.createStatement();){
            ResultSet rs = stmt.executeQuery(select);
            Assert.assertTrue((boolean)rs.next());
            UpsertSelectWithRegionMovesIT.moveRegionsOfTable(tableName);
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertTrue((boolean)rs.next());
            UpsertSelectWithRegionMovesIT.moveRegionsOfTable(tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testUpsertSelectWithLimit() throws Exception {
        ResultSet rs;
        Statement stmt;
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        String tableName = UpsertSelectWithRegionMovesIT.generateUniqueName();
        TABLE_NAMES.add(tableName);
        try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);){
            stmt = conn.createStatement();
            try {
                stmt.execute("create table " + tableName + " (id varchar(10) not null primary key, val varchar(10), ts timestamp)");
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            stmt = conn.createStatement();
            try {
                stmt.execute("upsert into " + tableName + " values ('aaa', 'abc', current_date())");
                stmt.execute("upsert into " + tableName + " values ('bbb', 'bcd', current_date())");
                stmt.execute("upsert into " + tableName + " values ('ccc', 'cde', current_date())");
                conn.commit();
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            stmt = conn.createStatement();
            try {
                rs = stmt.executeQuery("select * from " + tableName);
                Assert.assertTrue((boolean)rs.next());
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(tableName);
                Assert.assertEquals((Object)"aaa", (Object)rs.getString(1));
                Assert.assertEquals((Object)"abc", (Object)rs.getString(2));
                Assert.assertNotNull((Object)rs.getDate(3));
                Assert.assertTrue((boolean)rs.next());
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(tableName);
                Assert.assertEquals((Object)"bbb", (Object)rs.getString(1));
                Assert.assertEquals((Object)"bcd", (Object)rs.getString(2));
                Assert.assertNotNull((Object)rs.getDate(3));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"ccc", (Object)rs.getString(1));
                Assert.assertEquals((Object)"cde", (Object)rs.getString(2));
                Assert.assertNotNull((Object)rs.getDate(3));
                Assert.assertFalse((boolean)rs.next());
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            stmt = conn.createStatement();
            try {
                stmt.execute("upsert into " + tableName + " (id, ts) select id, CAST(null AS timestamp) from " + tableName + " where id <= 'bbb' limit 1");
                conn.commit();
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            stmt = conn.createStatement();
            try {
                rs = stmt.executeQuery("select * from " + tableName);
                Assert.assertTrue((boolean)rs.next());
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(tableName);
                Assert.assertEquals((Object)"aaa", (Object)rs.getString(1));
                Assert.assertEquals((Object)"abc", (Object)rs.getString(2));
                Assert.assertNull((Object)rs.getDate(3));
                Assert.assertTrue((boolean)rs.next());
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(tableName);
                Assert.assertEquals((Object)"bbb", (Object)rs.getString(1));
                Assert.assertEquals((Object)"bcd", (Object)rs.getString(2));
                Assert.assertNotNull((Object)rs.getDate(3));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"ccc", (Object)rs.getString(1));
                Assert.assertEquals((Object)"cde", (Object)rs.getString(2));
                Assert.assertNotNull((Object)rs.getDate(3));
                Assert.assertFalse((boolean)rs.next());
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Test
    public void testUpsertSelectWithSequence() throws Exception {
        Statement stmt;
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        String t1 = UpsertSelectWithRegionMovesIT.generateUniqueName();
        String t2 = UpsertSelectWithRegionMovesIT.generateUniqueName();
        String seq = UpsertSelectWithRegionMovesIT.generateUniqueName();
        TABLE_NAMES.add(t1);
        TABLE_NAMES.add(t2);
        try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);){
            stmt = conn.createStatement();
            try {
                stmt.execute("create table  " + t1 + " (id bigint not null primary key, v varchar)");
                stmt.execute("create table " + t2 + " (k varchar primary key)");
                stmt.execute("create sequence " + seq);
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            stmt = conn.createStatement();
            try {
                stmt.execute("upsert into " + t2 + " values ('a')");
                stmt.execute("upsert into " + t2 + " values ('b')");
                stmt.execute("upsert into " + t2 + " values ('c')");
                conn.commit();
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            stmt = conn.createStatement();
            try {
                stmt.execute("upsert into " + t1 + " select next value for  " + seq + " , k from " + t2);
                conn.commit();
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            stmt = conn.createStatement();
            try {
                ResultSet rs = stmt.executeQuery("select * from " + t1);
                Assert.assertTrue((boolean)rs.next());
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(t1);
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(t2);
                Assert.assertEquals((long)1L, (long)rs.getLong(1));
                Assert.assertEquals((Object)"a", (Object)rs.getString(2));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)2L, (long)rs.getLong(1));
                Assert.assertEquals((Object)"b", (Object)rs.getString(2));
                Assert.assertTrue((boolean)rs.next());
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(t1);
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(t2);
                Assert.assertEquals((long)3L, (long)rs.getLong(1));
                Assert.assertEquals((Object)"c", (Object)rs.getString(2));
                Assert.assertFalse((boolean)rs.next());
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Test
    public void testUpsertSelectWithSequenceAndOrderByWithSalting() throws Exception {
        Statement stmt;
        int numOfRecords = 200;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        String t1 = UpsertSelectWithRegionMovesIT.generateUniqueName();
        String t2 = UpsertSelectWithRegionMovesIT.generateUniqueName();
        TABLE_NAMES.add(t1);
        TABLE_NAMES.add(t2);
        String ddl = "CREATE TABLE IF NOT EXISTS " + t1 + "(ORGANIZATION_ID CHAR(15) NOT NULL, QUERY_ID CHAR(15) NOT NULL, CURSOR_ORDER BIGINT NOT NULL, K1 INTEGER, V1 INTEGER CONSTRAINT MAIN_PK PRIMARY KEY (ORGANIZATION_ID, QUERY_ID, CURSOR_ORDER) ) SALT_BUCKETS = 4";
        try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);){
            stmt = conn.createStatement();
            try {
                stmt.execute(ddl);
                stmt.execute("CREATE TABLE " + t2 + "(ORGANIZATION_ID CHAR(15) NOT NULL, k1 integer NOT NULL, v1 integer NOT NULL CONSTRAINT PK PRIMARY KEY (ORGANIZATION_ID, k1, v1) ) VERSIONS=1, SALT_BUCKETS = 4");
                stmt.execute("create sequence s cache 2147483647");
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            stmt = conn.createStatement();
            try {
                for (int i = 0; i < numOfRecords; ++i) {
                    stmt.execute("UPSERT INTO " + t2 + " values ('00Dxx0000001gEH'," + i + "," + (i + 2) + ")");
                }
                conn.commit();
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            stmt = conn.createStatement();
            try {
                conn.setAutoCommit(true);
                stmt.execute("UPSERT INTO " + t1 + " SELECT '00Dxx0000001gEH', 'MyQueryId', NEXT VALUE FOR S, k1, v1  FROM " + t2 + " ORDER BY K1, V1");
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            stmt = conn.createStatement();
            try {
                ResultSet rs = stmt.executeQuery("select count(*) from " + t1);
                Assert.assertTrue((boolean)rs.next());
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(t1);
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(t2);
                Assert.assertEquals((long)numOfRecords, (long)rs.getLong(1));
                ResultSet rs2 = stmt.executeQuery("select cursor_order, k1, v1 from " + t1 + " order by cursor_order");
                long seq = 1L;
                while (rs2.next()) {
                    if (seq % 75L == 0L) {
                        UpsertSelectWithRegionMovesIT.moveRegionsOfTable(t1);
                        UpsertSelectWithRegionMovesIT.moveRegionsOfTable(t2);
                    }
                    Assert.assertEquals((long)seq, (long)rs2.getLong("cursor_order"));
                    Assert.assertEquals((long)(seq - 1L), (long)rs2.getLong("k1"));
                    ++seq;
                }
                stmt.execute("drop sequence s");
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Test
    public void testUpsertSelectWithRowtimeStampColumn() throws Exception {
        ResultSet rs;
        ResultSet rs2;
        PreparedStatement prepStmt;
        Statement stmt;
        String t1 = UpsertSelectWithRegionMovesIT.generateUniqueName();
        String t2 = UpsertSelectWithRegionMovesIT.generateUniqueName();
        String t3 = UpsertSelectWithRegionMovesIT.generateUniqueName();
        TABLE_NAMES.add(t1);
        TABLE_NAMES.add(t2);
        TABLE_NAMES.add(t3);
        try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl());
             Statement stmt2 = conn.createStatement();){
            stmt2.execute("CREATE TABLE " + t1 + " (PK1 VARCHAR NOT NULL, PK2 DATE NOT NULL, KV1 VARCHAR CONSTRAINT PK PRIMARY KEY(PK1, PK2 DESC ROW_TIMESTAMP )) ");
            stmt2.execute("CREATE TABLE " + t2 + " (PK1 VARCHAR NOT NULL, PK2 DATE NOT NULL, KV1 VARCHAR CONSTRAINT PK PRIMARY KEY(PK1, PK2 ROW_TIMESTAMP)) ");
            stmt2.execute("CREATE TABLE " + t3 + " (PK1 VARCHAR NOT NULL, PK2 DATE NOT NULL, KV1 VARCHAR CONSTRAINT PK PRIMARY KEY(PK1, PK2 DESC ROW_TIMESTAMP )) ");
        }
        long rowTimestamp = EnvironmentEdgeManager.currentTimeMillis();
        Date rowTimestampDate = new Date(rowTimestamp);
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);){
            stmt = conn.prepareStatement("UPSERT INTO " + t1 + " (PK1, PK2, KV1) VALUES(?, ?, ?)");
            try {
                stmt.setString(1, "PK1");
                stmt.setDate(2, rowTimestampDate);
                stmt.setString(3, "KV1");
                stmt.executeUpdate();
                conn.commit();
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl());
        try {
            stmt = conn.createStatement();
            try {
                stmt.executeUpdate("UPSERT INTO " + t2 + " SELECT * FROM " + t1);
                conn.commit();
                prepStmt = conn.prepareStatement("SELECT * FROM " + t2 + " WHERE PK1 = ? AND PK2 = ?");
                try {
                    prepStmt.setString(1, "PK1");
                    prepStmt.setDate(2, rowTimestampDate);
                    rs2 = prepStmt.executeQuery();
                    Assert.assertTrue((boolean)rs2.next());
                    Assert.assertEquals((Object)"PK1", (Object)rs2.getString("PK1"));
                    Assert.assertEquals((Object)rowTimestampDate, (Object)rs2.getDate("PK2"));
                    Assert.assertEquals((Object)"KV1", (Object)rs2.getString("KV1"));
                }
                finally {
                    if (prepStmt != null) {
                        prepStmt.close();
                    }
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        props.setProperty("CurrentSCN", Long.toString(rowTimestamp - 1L));
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            stmt = conn.prepareStatement("SELECT * FROM " + t2 + " WHERE PK1 = ? AND PK2 = ?");
            try {
                stmt.setString(1, "PK1");
                stmt.setDate(2, rowTimestampDate);
                rs = stmt.executeQuery();
                Assert.assertFalse((boolean)rs.next());
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl());
        try {
            stmt = conn.createStatement();
            try {
                stmt.executeUpdate("UPSERT INTO " + t3 + " SELECT * FROM " + t1);
                conn.commit();
                prepStmt = conn.prepareStatement("SELECT * FROM " + t3 + " WHERE PK1 = ? AND PK2 = ?");
                try {
                    prepStmt.setString(1, "PK1");
                    prepStmt.setDate(2, rowTimestampDate);
                    rs2 = prepStmt.executeQuery();
                    Assert.assertTrue((boolean)rs2.next());
                    Assert.assertEquals((Object)"PK1", (Object)rs2.getString("PK1"));
                    Assert.assertEquals((Object)rowTimestampDate, (Object)rs2.getDate("PK2"));
                    Assert.assertEquals((Object)"KV1", (Object)rs2.getString("KV1"));
                }
                finally {
                    if (prepStmt != null) {
                        prepStmt.close();
                    }
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            stmt = conn.prepareStatement("SELECT * FROM " + t3 + " WHERE PK1 = ? AND PK2 = ?");
            try {
                stmt.setString(1, "PK1");
                stmt.setDate(2, rowTimestampDate);
                rs = stmt.executeQuery();
                Assert.assertFalse((boolean)rs.next());
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Test
    public void testUpsertSelectSameTableWithRowTimestampColumn() throws Exception {
        Statement stmt;
        String tableName = UpsertSelectWithRegionMovesIT.generateUniqueName();
        TABLE_NAMES.add(tableName);
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
             Statement stmt2 = conn.createStatement();){
            stmt2.execute("CREATE TABLE " + tableName + " (PK1 INTEGER NOT NULL, PK2 DATE NOT NULL, KV1 VARCHAR CONSTRAINT PK PRIMARY KEY(PK1, PK2 ROW_TIMESTAMP)) ");
        }
        long rowTimestamp = 100L;
        Date rowTimestampDate = new Date(rowTimestamp);
        try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
             PreparedStatement stmt3 = conn.prepareStatement("UPSERT INTO  " + tableName + " (PK1, PK2, KV1) VALUES(?, ?, ?)");){
            stmt3.setInt(1, 1);
            stmt3.setDate(2, rowTimestampDate);
            stmt3.setString(3, "KV1");
            stmt3.executeUpdate();
            conn.commit();
        }
        String seq = UpsertSelectWithRegionMovesIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);){
            stmt = conn.createStatement();
            try {
                stmt.execute("CREATE SEQUENCE " + seq);
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            stmt = conn.createStatement();
            try {
                stmt.executeUpdate("UPSERT INTO  " + tableName + "  SELECT NEXT VALUE FOR " + seq + ", PK2 FROM  " + tableName);
                conn.commit();
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            stmt = conn.createStatement();
            try {
                conn.setAutoCommit(true);
                for (int i = 0; i < 10; ++i) {
                    int count = stmt.executeUpdate("UPSERT INTO  " + tableName + "  SELECT NEXT VALUE FOR " + seq + ", PK2 FROM  " + tableName);
                    Assert.assertEquals((long)((int)Math.pow(2.0, i)), (long)count);
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Test
    public void testAutomaticallySettingRowtimestamp() throws Exception {
        ResultSet rs;
        PreparedStatement stmt;
        String table1 = UpsertSelectWithRegionMovesIT.generateUniqueName();
        String table2 = UpsertSelectWithRegionMovesIT.generateUniqueName();
        String table3 = UpsertSelectWithRegionMovesIT.generateUniqueName();
        TABLE_NAMES.add(table1);
        TABLE_NAMES.add(table2);
        TABLE_NAMES.add(table3);
        try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl());
             Statement stmt2 = conn.createStatement();){
            stmt2.execute("CREATE TABLE " + table1 + " (T1PK1 VARCHAR NOT NULL, T1PK2 DATE NOT NULL, T1KV1 VARCHAR, T1KV2 VARCHAR CONSTRAINT PK PRIMARY KEY(T1PK1, T1PK2 DESC ROW_TIMESTAMP)) ");
            stmt2.execute("CREATE TABLE " + table2 + " (T2PK1 VARCHAR NOT NULL, T2PK2 DATE NOT NULL, T2KV1 VARCHAR, T2KV2 VARCHAR CONSTRAINT PK PRIMARY KEY(T2PK1, T2PK2 ROW_TIMESTAMP)) ");
            stmt2.execute("CREATE TABLE " + table3 + " (T3PK1 VARCHAR NOT NULL, T3PK2 DATE NOT NULL, T3KV1 VARCHAR, T3KV2 VARCHAR CONSTRAINT PK PRIMARY KEY(T3PK1, T3PK2 DESC ROW_TIMESTAMP)) ");
        }
        long startTime = EnvironmentEdgeManager.currentTimeMillis();
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
             PreparedStatement stmt3 = conn.prepareStatement("UPSERT INTO  " + table1 + " (T1PK1, T1KV1, T1KV2) VALUES (?, ?, ?)");){
            stmt3.setString(1, "PK1");
            stmt3.setString(2, "KV1");
            stmt3.setString(3, "KV2");
            stmt3.executeUpdate();
            conn.commit();
        }
        long endTime = EnvironmentEdgeManager.currentTimeMillis();
        try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);){
            stmt = conn.prepareStatement("SELECT T1KV1, T1KV2 FROM " + table1 + " WHERE T1PK1 = ? AND T1PK2 >= ? AND T1PK2 <= ?");
            try {
                stmt.setString(1, "PK1");
                stmt.setDate(2, new Date(startTime));
                stmt.setDate(3, new Date(endTime));
                rs = stmt.executeQuery();
                Assert.assertTrue((boolean)rs.next());
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(table1);
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(table2);
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(table3);
                Assert.assertEquals((Object)"KV1", (Object)rs.getString(1));
                Assert.assertEquals((Object)"KV2", (Object)rs.getString(2));
                Assert.assertFalse((boolean)rs.next());
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        startTime = EnvironmentEdgeManager.currentTimeMillis();
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            stmt = conn.prepareStatement("UPSERT INTO  " + table2 + " (T2PK1, T2KV1, T2KV2) SELECT T1PK1, T1KV1, T1KV2 FROM " + table1);
            try {
                stmt.executeUpdate();
                conn.commit();
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        endTime = EnvironmentEdgeManager.currentTimeMillis();
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            stmt = conn.prepareStatement("SELECT T2KV1, T2KV2 FROM " + table2 + " WHERE T2PK1 = ? AND T2PK2 >= ?  AND T2PK2 <= ?");
            try {
                stmt.setString(1, "PK1");
                stmt.setDate(2, new Date(startTime));
                stmt.setDate(3, new Date(endTime));
                rs = stmt.executeQuery();
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"KV1", (Object)rs.getString(1));
                Assert.assertEquals((Object)"KV2", (Object)rs.getString(2));
                Assert.assertFalse((boolean)rs.next());
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        startTime = EnvironmentEdgeManager.currentTimeMillis();
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            stmt = conn.prepareStatement("UPSERT INTO  " + table3 + " (T3PK1, T3KV1, T3KV2) SELECT T2PK1, T2KV1, T2KV2 FROM " + table2);
            try {
                stmt.executeUpdate();
                conn.commit();
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        endTime = EnvironmentEdgeManager.currentTimeMillis();
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            stmt = conn.prepareStatement("SELECT T3KV1, T3KV2 FROM " + table3 + " WHERE T3PK1 = ? AND T3PK2 >= ? AND T3PK2 <= ?");
            try {
                stmt.setString(1, "PK1");
                stmt.setDate(2, new Date(startTime));
                stmt.setDate(3, new Date(endTime));
                rs = stmt.executeQuery();
                Assert.assertTrue((boolean)rs.next());
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(table1);
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(table2);
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(table3);
                Assert.assertEquals((Object)"KV1", (Object)rs.getString(1));
                Assert.assertEquals((Object)"KV2", (Object)rs.getString(2));
                Assert.assertFalse((boolean)rs.next());
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Test
    public void testUpsertSelectAutoCommitWithRowTimestampColumn() throws Exception {
        String[] tableNames;
        String tableName1 = UpsertSelectWithRegionMovesIT.generateUniqueName();
        String tableName2 = UpsertSelectWithRegionMovesIT.generateUniqueName();
        TABLE_NAMES.add(tableName1);
        TABLE_NAMES.add(tableName2);
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
             Statement stmt = conn.createStatement();){
            stmt.execute("CREATE TABLE " + tableName1 + " (PK1 INTEGER NOT NULL, PK2 DATE NOT NULL, PK3 INTEGER NOT NULL, KV1 VARCHAR CONSTRAINT PK PRIMARY KEY(PK1, PK2 ROW_TIMESTAMP, PK3)) ");
            stmt.execute("CREATE TABLE " + tableName2 + " (PK1 INTEGER NOT NULL, PK2 DATE NOT NULL, PK3 INTEGER NOT NULL, KV1 VARCHAR CONSTRAINT PK PRIMARY KEY(PK1, PK2 DESC ROW_TIMESTAMP, PK3)) ");
        }
        for (String tableName : tableNames = new String[]{tableName1, tableName2}) {
            ResultSet rs;
            Statement stmt;
            long rowTimestamp1 = 100L;
            Date rowTimestampDate = new Date(rowTimestamp1);
            try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
                 PreparedStatement stmt2 = conn.prepareStatement("UPSERT INTO  " + tableName + " (PK1, PK2, PK3, KV1) VALUES(?, ?, ?, ?)");){
                stmt2.setInt(1, 1);
                stmt2.setDate(2, rowTimestampDate);
                stmt2.setInt(3, 3);
                stmt2.setString(4, "KV1");
                stmt2.executeUpdate();
                conn.commit();
            }
            long startTime = EnvironmentEdgeManager.currentTimeMillis();
            try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
                 Statement stmt3 = conn.createStatement();){
                conn.setAutoCommit(true);
                stmt3.executeUpdate("UPSERT INTO  " + tableName + " (PK1, PK3, KV1) SELECT PK1, PK3, KV1 FROM  " + tableName);
            }
            long endTime = EnvironmentEdgeManager.currentTimeMillis();
            try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);){
                stmt = conn.prepareStatement("SELECT * FROM  " + tableName + " WHERE PK1 = ? AND PK2 >= ? AND PK2<= ? AND PK3 = ?");
                try {
                    stmt.setInt(1, 1);
                    stmt.setDate(2, new Date(startTime));
                    stmt.setDate(3, new Date(endTime));
                    stmt.setInt(4, 3);
                    rs = stmt.executeQuery();
                    Assert.assertTrue((boolean)rs.next());
                    UpsertSelectWithRegionMovesIT.moveRegionsOfTable(tableName);
                    Assert.assertEquals((long)1L, (long)rs.getInt("PK1"));
                    Assert.assertEquals((long)3L, (long)rs.getInt("PK3"));
                    Assert.assertEquals((Object)"KV1", (Object)rs.getString("KV1"));
                    Assert.assertFalse((boolean)rs.next());
                    try (Statement newStmt = conn.createStatement();){
                        rs = newStmt.executeQuery("SELECT COUNT(*) FROM " + tableName);
                        Assert.assertTrue((boolean)rs.next());
                        Assert.assertEquals((long)2L, (long)rs.getInt(1));
                    }
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
            try {
                stmt = conn.createStatement();
                try {
                    conn.setAutoCommit(true);
                    stmt.executeUpdate("UPSERT INTO  " + tableName + " (PK1, PK2, PK3, KV1) SELECT PK1, PK2, PK3, KV1 FROM  " + tableName);
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
            conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
            try {
                stmt = conn.createStatement();
                try {
                    rs = stmt.executeQuery("SELECT COUNT(*) FROM " + tableName);
                    Assert.assertTrue((boolean)rs.next());
                    UpsertSelectWithRegionMovesIT.moveRegionsOfTable(tableName);
                    Assert.assertEquals((long)2L, (long)rs.getInt(1));
                    Assert.assertFalse((boolean)rs.next());
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testRowTimestampColWithViewsIndexesAndSaltedTables() throws Exception {
        Date upsertedDate;
        ResultSet rs;
        PreparedStatement stmt;
        long upsertedTs;
        ResultSet rs2;
        PreparedStatement stmt2;
        String baseTable = UpsertSelectWithRegionMovesIT.generateUniqueName();
        String tenantView = UpsertSelectWithRegionMovesIT.generateUniqueName();
        String globalView = UpsertSelectWithRegionMovesIT.generateUniqueName();
        String baseTableIdx = UpsertSelectWithRegionMovesIT.generateUniqueName();
        String tenantViewIdx = UpsertSelectWithRegionMovesIT.generateUniqueName();
        TABLE_NAMES.add(baseTable);
        TABLE_NAMES.add(baseTableIdx);
        TABLE_NAMES.add("_IDX_" + baseTable);
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
             Statement stmt3 = conn.createStatement();){
            stmt3.execute("CREATE IMMUTABLE TABLE " + baseTable + " (TENANT_ID CHAR(15) NOT NULL, PK2 DATE NOT NULL, PK3 INTEGER NOT NULL, KV1 VARCHAR, KV2 VARCHAR, KV3 VARCHAR CONSTRAINT PK PRIMARY KEY(TENANT_ID, PK2 ROW_TIMESTAMP, PK3)) MULTI_TENANT = true, SALT_BUCKETS = 8");
            stmt3.execute("CREATE INDEX " + baseTableIdx + " ON " + baseTable + " (PK2, KV3) INCLUDE (KV1)");
            stmt3.execute("CREATE VIEW " + globalView + " AS SELECT * FROM " + baseTable + " WHERE KV1 = 'KV1'");
        }
        String tenantId = "tenant1";
        try (Connection conn = this.getTenantConnection(tenantId);
             Statement stmt4 = conn.createStatement();){
            stmt4.execute("CREATE VIEW " + tenantView + " AS SELECT * FROM " + baseTable);
            stmt4.execute("CREATE INDEX " + tenantViewIdx + " ON " + tenantView + " (PK2, KV2) INCLUDE (KV1)");
        }
        long startTime = EnvironmentEdgeManager.currentTimeMillis();
        try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
             PreparedStatement stmt5 = conn.prepareStatement("UPSERT INTO  " + baseTable + " (TENANT_ID, PK3, KV1, KV2, KV3) VALUES (?, ?, ?, ?, ?)");){
            stmt5.setString(1, tenantId);
            stmt5.setInt(2, 3);
            stmt5.setString(3, "KV1");
            stmt5.setString(4, "KV2");
            stmt5.setString(5, "KV3");
            stmt5.executeUpdate();
            conn.commit();
        }
        long endTime = EnvironmentEdgeManager.currentTimeMillis();
        try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);){
            stmt2 = conn.prepareStatement("SELECT * FROM  " + baseTable + " WHERE TENANT_ID = ? AND PK2 >= ? AND PK2 <= ? AND PK3 = ?");
            try {
                stmt2.setString(1, tenantId);
                stmt2.setDate(2, new Date(startTime));
                stmt2.setDate(3, new Date(endTime));
                stmt2.setInt(4, 3);
                rs2 = stmt2.executeQuery();
                Assert.assertTrue((boolean)rs2.next());
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(baseTable);
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(baseTableIdx);
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable("_IDX_" + baseTable);
                Assert.assertEquals((Object)tenantId, (Object)rs2.getString("TENANT_ID"));
                Assert.assertEquals((Object)"KV1", (Object)rs2.getString("KV1"));
                Assert.assertEquals((Object)"KV2", (Object)rs2.getString("KV2"));
                Assert.assertEquals((Object)"KV3", (Object)rs2.getString("KV3"));
                Assert.assertFalse((boolean)rs2.next());
            }
            finally {
                if (stmt2 != null) {
                    stmt2.close();
                }
            }
            stmt2 = conn.prepareStatement("SELECT /*+ NO_INDEX */ * FROM  " + globalView + " WHERE TENANT_ID = ? AND PK2 >= ? AND PK2 <= ? AND PK3 = ?");
            try {
                stmt2.setString(1, tenantId);
                stmt2.setDate(2, new Date(startTime));
                stmt2.setDate(3, new Date(endTime));
                stmt2.setInt(4, 3);
                rs2 = stmt2.executeQuery();
                Assert.assertTrue((boolean)rs2.next());
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(baseTable);
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(baseTableIdx);
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable("_IDX_" + baseTable);
                Assert.assertEquals((Object)tenantId, (Object)rs2.getString("TENANT_ID"));
                Assert.assertEquals((Object)"KV1", (Object)rs2.getString("KV1"));
                Assert.assertEquals((Object)"KV2", (Object)rs2.getString("KV2"));
                Assert.assertEquals((Object)"KV3", (Object)rs2.getString("KV3"));
                Assert.assertFalse((boolean)rs2.next());
            }
            finally {
                if (stmt2 != null) {
                    stmt2.close();
                }
            }
            stmt2 = conn.prepareStatement("SELECT KV1 FROM  " + baseTable + " WHERE PK2 >= ? AND PK2 <= ? AND KV3 = ?");
            try {
                stmt2.setDate(1, new Date(startTime));
                stmt2.setDate(2, new Date(endTime));
                stmt2.setString(3, "KV3");
                rs2 = stmt2.executeQuery();
                QueryPlan plan = stmt2.unwrap(PhoenixStatement.class).getQueryPlan();
                Assert.assertEquals((Object)plan.getTableRef().getTable().getName().getString(), (Object)baseTableIdx);
                Assert.assertTrue((boolean)rs2.next());
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(baseTable);
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(baseTableIdx);
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable("_IDX_" + baseTable);
                Assert.assertEquals((Object)"KV1", (Object)rs2.getString("KV1"));
                Assert.assertFalse((boolean)rs2.next());
            }
            finally {
                if (stmt2 != null) {
                    stmt2.close();
                }
            }
        }
        try (Connection tenantConn = this.getTenantConnection(tenantId);){
            stmt2 = tenantConn.prepareStatement("SELECT * FROM  " + tenantView + " WHERE PK2 >= ? AND PK2 <= ? AND PK3 = ?");
            try {
                stmt2.setDate(1, new Date(startTime));
                stmt2.setDate(2, new Date(endTime));
                stmt2.setInt(3, 3);
                rs2 = stmt2.executeQuery();
                Assert.assertTrue((boolean)rs2.next());
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(baseTable);
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(baseTableIdx);
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable("_IDX_" + baseTable);
                Assert.assertEquals((Object)"KV1", (Object)rs2.getString("KV1"));
                Assert.assertEquals((Object)"KV2", (Object)rs2.getString("KV2"));
                Assert.assertEquals((Object)"KV3", (Object)rs2.getString("KV3"));
                Assert.assertFalse((boolean)rs2.next());
            }
            finally {
                if (stmt2 != null) {
                    stmt2.close();
                }
            }
        }
        try (Connection tenantConn = this.getTenantConnection(tenantId);){
            startTime = EnvironmentEdgeManager.currentTimeMillis();
            try (PreparedStatement stmt6 = tenantConn.prepareStatement("UPSERT INTO  " + tenantView + " (PK3, KV1, KV2, KV3) VALUES (?, ?, ?, ?)");){
                stmt6.setInt(1, 33);
                stmt6.setString(2, "KV13");
                stmt6.setString(3, "KV23");
                stmt6.setString(4, "KV33");
                stmt6.executeUpdate();
            }
            tenantConn.commit();
            upsertedTs = endTime = EnvironmentEdgeManager.currentTimeMillis();
            stmt6 = tenantConn.prepareStatement("UPSERT INTO  " + tenantView + " (PK2, PK3, KV1, KV2, KV3) VALUES (?, ?, ?, ?, ?)");
            try {
                stmt6.setDate(1, new Date(upsertedTs));
                stmt6.setInt(2, 44);
                stmt6.setString(3, "KV14");
                stmt6.setString(4, "KV24");
                stmt6.setString(5, "KV34");
                stmt6.executeUpdate();
            }
            finally {
                if (stmt6 != null) {
                    stmt6.close();
                }
            }
            tenantConn.commit();
        }
        try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);){
            stmt = conn.prepareStatement("SELECT * FROM  " + baseTable + " WHERE TENANT_ID = ? AND PK2 >= ? AND PK2 <= ? AND PK3 = ? ");
            try {
                stmt.setString(1, tenantId);
                stmt.setDate(2, new Date(startTime));
                stmt.setDate(3, new Date(endTime));
                stmt.setInt(4, 33);
                rs = stmt.executeQuery();
                Assert.assertTrue((boolean)rs.next());
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(baseTable);
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(baseTableIdx);
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable("_IDX_" + baseTable);
                Assert.assertEquals((Object)tenantId, (Object)rs.getString("TENANT_ID"));
                Assert.assertEquals((Object)"KV13", (Object)rs.getString("KV1"));
                Assert.assertEquals((Object)"KV23", (Object)rs.getString("KV2"));
                Assert.assertEquals((Object)"KV33", (Object)rs.getString("KV3"));
                upsertedDate = rs.getDate("PK2");
                Assert.assertFalse((boolean)rs.next());
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
            stmt = conn.prepareStatement("SELECT * FROM  " + baseTable + " WHERE TENANT_ID = ? AND PK2 = ? AND PK3 = ? ");
            try {
                stmt.setString(1, tenantId);
                stmt.setDate(2, new Date(upsertedTs));
                stmt.setInt(3, 44);
                rs = stmt.executeQuery();
                Assert.assertTrue((boolean)rs.next());
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(baseTable);
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(baseTableIdx);
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable("_IDX_" + baseTable);
                Assert.assertEquals((Object)tenantId, (Object)rs.getString("TENANT_ID"));
                Assert.assertEquals((Object)"KV14", (Object)rs.getString("KV1"));
                Assert.assertEquals((Object)"KV24", (Object)rs.getString("KV2"));
                Assert.assertEquals((Object)"KV34", (Object)rs.getString("KV3"));
                Assert.assertFalse((boolean)rs.next());
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
            stmt = conn.prepareStatement("SELECT KV1 FROM  " + baseTable + " WHERE (PK2, KV3) IN ((?, ?), (?, ?)) ORDER BY KV1");
            try {
                stmt.setDate(1, upsertedDate);
                stmt.setString(2, "KV33");
                stmt.setDate(3, new Date(upsertedTs));
                stmt.setString(4, "KV34");
                rs = stmt.executeQuery();
                QueryPlan plan = stmt.unwrap(PhoenixStatement.class).getQueryPlan();
                Assert.assertTrue((boolean)plan.getTableRef().getTable().getName().getString().equals(baseTableIdx));
                Assert.assertTrue((boolean)rs.next());
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(baseTable);
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(baseTableIdx);
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable("_IDX_" + baseTable);
                Assert.assertEquals((Object)"KV13", (Object)rs.getString("KV1"));
                Assert.assertTrue((boolean)rs.next());
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(baseTable);
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(baseTableIdx);
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable("_IDX_" + baseTable);
                Assert.assertEquals((Object)"KV14", (Object)rs.getString("KV1"));
                Assert.assertFalse((boolean)rs.next());
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        try (Connection tenantConn = this.getTenantConnection(tenantId);){
            stmt = tenantConn.prepareStatement("SELECT * FROM  " + tenantView + " WHERE (PK2, PK3) IN ((?, ?), (?, ?)) ORDER BY KV1");
            try {
                stmt.setDate(1, upsertedDate);
                stmt.setInt(2, 33);
                stmt.setDate(3, new Date(upsertedTs));
                stmt.setInt(4, 44);
                rs = stmt.executeQuery();
                Assert.assertTrue((boolean)rs.next());
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(baseTable);
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(baseTableIdx);
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable("_IDX_" + baseTable);
                Assert.assertEquals((Object)"KV13", (Object)rs.getString("KV1"));
                Assert.assertTrue((boolean)rs.next());
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(baseTable);
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(baseTableIdx);
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable("_IDX_" + baseTable);
                Assert.assertEquals((Object)"KV14", (Object)rs.getString("KV1"));
                Assert.assertFalse((boolean)rs.next());
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    @Test
    public void testDisallowNegativeValuesForRowTsColumn() throws Exception {
        PreparedStatement stmt;
        String tableName = UpsertSelectWithRegionMovesIT.generateUniqueName();
        String tableName2 = UpsertSelectWithRegionMovesIT.generateUniqueName();
        TABLE_NAMES.add(tableName);
        TABLE_NAMES.add(tableName2);
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
             Statement stmt2 = conn.createStatement();){
            stmt2.execute("CREATE TABLE " + tableName + " (PK1 BIGINT NOT NULL PRIMARY KEY ROW_TIMESTAMP, KV1 VARCHAR)");
            stmt2.execute("CREATE TABLE " + tableName2 + " (PK1 BIGINT NOT NULL PRIMARY KEY ROW_TIMESTAMP, KV1 VARCHAR)");
        }
        long upsertedTs = 100L;
        try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);){
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?, ?)");
            try {
                stmt.setLong(1, upsertedTs);
                stmt.setString(2, "KV1");
                stmt.executeUpdate();
                conn.commit();
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        try {
            conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
            try {
                stmt = conn.prepareStatement("UPSERT INTO " + tableName2 + " SELECT (PK1 - 500), KV1 FROM " + tableName);
                try {
                    stmt.executeUpdate();
                    Assert.fail();
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.ILLEGAL_DATA.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testUpsertSelectWithFixedWidthNullByteSizeArray() throws Exception {
        Statement stmt;
        ResultSet rs;
        Statement stmt2;
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        String t1 = UpsertSelectWithRegionMovesIT.generateUniqueName();
        TABLE_NAMES.add(t1);
        try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);){
            stmt2 = conn.createStatement();
            try {
                stmt2.execute("create table " + t1 + " (id bigint not null primary key, ca char(3)[])");
            }
            finally {
                if (stmt2 != null) {
                    stmt2.close();
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            stmt2 = conn.createStatement();
            try {
                stmt2.execute("upsert into " + t1 + " values (1, ARRAY['aaa', 'bbb'])");
                conn.commit();
            }
            finally {
                if (stmt2 != null) {
                    stmt2.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            stmt2 = conn.createStatement();
            try {
                stmt2.execute("upsert into " + t1 + " (id, ca) select id, ARRAY['ccc', 'ddd'] from " + t1 + " WHERE id = 1");
                conn.commit();
            }
            finally {
                if (stmt2 != null) {
                    stmt2.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            stmt2 = conn.createStatement();
            try {
                rs = stmt2.executeQuery("select * from " + t1);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)1L, (long)rs.getLong(1));
                Assert.assertEquals((Object)"['ccc', 'ddd']", (Object)rs.getArray(2).toString());
            }
            finally {
                if (stmt2 != null) {
                    stmt2.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        String t2 = UpsertSelectWithRegionMovesIT.generateUniqueName();
        TABLE_NAMES.add(t2);
        try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);){
            stmt = conn.createStatement();
            try {
                stmt.execute("create table " + t2 + " (id bigint not null primary key, ba binary(4)[])");
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            stmt = conn.createStatement();
            try {
                stmt.execute("upsert into " + t2 + " values (2, ARRAY[1, 27])");
                conn.commit();
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            stmt = conn.createStatement();
            try {
                stmt.execute("upsert into " + t2 + " (id, ba) select id, ARRAY[54, 1024] from " + t2 + " WHERE id = 2");
                conn.commit();
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            stmt = conn.createStatement();
            try {
                rs = stmt.executeQuery("select * from " + t2);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)2L, (long)rs.getLong(1));
                Assert.assertEquals((Object)"[X'80000036', X'80000400']", (Object)rs.getArray(2).toString());
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Test
    public void testUpsertSelectWithMultiByteCharsNoAutoCommit() throws Exception {
        this.testUpsertSelectWithMultiByteChars(false);
    }

    @Test
    public void testUpsertSelectWithMultiByteCharsAutoCommit() throws Exception {
        this.testUpsertSelectWithMultiByteChars(true);
    }

    private void testUpsertSelectWithMultiByteChars(boolean autoCommit) throws Exception {
        Statement stmt;
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        String t1 = UpsertSelectWithRegionMovesIT.generateUniqueName();
        TABLE_NAMES.add(t1);
        String validValue = "\u6fb4\u7c96\u87e4\u092f\u893b\u9143\u5ca4\u8c66\ud311\u85b0\u9129\u813c\u056a\ub066\u7889\u7889\u7889\u7889\u7889\u7889";
        String invalidValue = "\u6fb4\u7c96\u87e4\u092f\u893b\u9143\u5ca4\u8c66\ud311\u85b0\u9129\u813c\u056a\ub066\u7889\u7889\u7889\u7889\u7889\u7889\u7889";
        String columnTypeInfo = "VARCHAR(20)";
        try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);){
            stmt = conn.createStatement();
            try {
                conn.setAutoCommit(autoCommit);
                stmt.execute("create table " + t1 + " (id bigint not null primary key, v varchar(20))");
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            stmt = conn.createStatement();
            try {
                conn.setAutoCommit(autoCommit);
                stmt.execute("upsert into " + t1 + " values (1, 'foo')");
                conn.commit();
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            stmt = conn.createStatement();
            try {
                conn.setAutoCommit(autoCommit);
                stmt.execute("upsert into " + t1 + " (id, v) select id, '" + validValue + "' from " + t1 + " WHERE id = 1");
                conn.commit();
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            stmt = conn.createStatement();
            try {
                conn.setAutoCommit(autoCommit);
                ResultSet rs = stmt.executeQuery("select * from  " + t1);
                Assert.assertTrue((boolean)rs.next());
                UpsertSelectWithRegionMovesIT.moveRegionsOfTable(t1);
                Assert.assertEquals((long)1L, (long)rs.getLong(1));
                Assert.assertEquals((Object)validValue, (Object)rs.getString(2));
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        try {
            conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
            try {
                stmt = conn.createStatement();
                try {
                    conn.setAutoCommit(autoCommit);
                    stmt.execute("upsert into  " + t1 + " (id, v) select id, '" + invalidValue + "' from " + t1 + " WHERE id = 1");
                    conn.commit();
                    Assert.fail();
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.DATA_EXCEEDS_MAX_CAPACITY.getErrorCode(), (long)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().contains(columnTypeInfo));
        }
    }

    @Test
    public void testParallelUpsertSelect() throws Exception {
        Statement stmt;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.mutate.batchSizeBytes", Integer.toString(512));
        props.setProperty("hbase.client.scanner.caching", Integer.toString(3));
        props.setProperty("phoenix.query.scanResultChunkSize", Integer.toString(3));
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        String t1 = UpsertSelectWithRegionMovesIT.generateUniqueName();
        String t2 = UpsertSelectWithRegionMovesIT.generateUniqueName();
        String seq = UpsertSelectWithRegionMovesIT.generateUniqueName();
        TABLE_NAMES.add(t1);
        TABLE_NAMES.add(t2);
        try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);){
            stmt = conn.createStatement();
            try {
                conn.setAutoCommit(false);
                stmt.execute("CREATE SEQUENCE " + seq);
                stmt.execute("CREATE TABLE  " + t1 + "  (pk INTEGER PRIMARY KEY, val INTEGER) SALT_BUCKETS=4");
                stmt.execute("CREATE TABLE  " + t2 + "  (pk INTEGER PRIMARY KEY, val INTEGER)");
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            stmt = conn.createStatement();
            try {
                for (int i = 0; i < 100; ++i) {
                    stmt.execute("UPSERT INTO  " + t1 + "  VALUES (NEXT VALUE FOR " + seq + ", " + i % 10 + ")");
                }
                conn.commit();
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
        try {
            conn.setAutoCommit(true);
            stmt = conn.createStatement();
            try {
                int upsertCount = stmt.executeUpdate("UPSERT INTO " + t2 + " SELECT pk, val FROM  " + t1);
                Assert.assertEquals((long)100L, (long)upsertCount);
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Test
    public void testLongCodecUsedForRowTimestamp() throws Exception {
        String tableName = UpsertSelectWithRegionMovesIT.generateUniqueName();
        String indexName = UpsertSelectWithRegionMovesIT.generateUniqueName();
        TABLE_NAMES.add(tableName);
        TABLE_NAMES.add(indexName);
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
             Statement statement = conn.createStatement();){
            statement.execute("CREATE IMMUTABLE TABLE " + tableName + " (k1 TIMESTAMP not null, k2 bigint not null, v bigint, constraint pk primary key (k1 row_timestamp, k2)) SALT_BUCKETS = 9");
            statement.execute("CREATE INDEX " + indexName + " ON " + tableName + " (v) INCLUDE (k2)");
            try (PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?, ?, ?) ");){
                stmt.setTimestamp(1, new Timestamp(1000L));
                stmt.setLong(2, 2000L);
                stmt.setLong(3, 1000L);
                stmt.executeUpdate();
                stmt.setTimestamp(1, new Timestamp(2000L));
                stmt.setLong(2, 5000L);
                stmt.setLong(3, 5L);
                stmt.executeUpdate();
                stmt.setTimestamp(1, new Timestamp(3000L));
                stmt.setLong(2, 5000L);
                stmt.setLong(3, 5L);
                stmt.executeUpdate();
                stmt.setTimestamp(1, new Timestamp(4000L));
                stmt.setLong(2, 5000L);
                stmt.setLong(3, 5L);
                stmt.executeUpdate();
                stmt.setTimestamp(1, new Timestamp(5000L));
                stmt.setLong(2, 2000L);
                stmt.setLong(3, 10L);
                stmt.executeUpdate();
                stmt.setTimestamp(1, new Timestamp(6000L));
                stmt.setLong(2, 2000L);
                stmt.setLong(3, 20L);
                stmt.executeUpdate();
            }
            conn.commit();
            ResultSet rs = statement.executeQuery("SELECT  K2 FROM " + tableName + " WHERE V = 5");
            Assert.assertTrue((String)("Index " + indexName + " should have been used"), (boolean)rs.unwrap(PhoenixResultSet.class).getStatement().getQueryPlan().getTableRef().getTable().getName().getString().equals(indexName));
            Assert.assertTrue((boolean)rs.next());
            UpsertSelectWithRegionMovesIT.moveRegionsOfTable(tableName);
            UpsertSelectWithRegionMovesIT.moveRegionsOfTable(indexName);
            Assert.assertEquals((long)5000L, (long)rs.getLong("k2"));
            Assert.assertTrue((boolean)rs.next());
            UpsertSelectWithRegionMovesIT.moveRegionsOfTable(tableName);
            UpsertSelectWithRegionMovesIT.moveRegionsOfTable(indexName);
            Assert.assertEquals((long)5000L, (long)rs.getLong("k2"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)5000L, (long)rs.getLong("k2"));
            Assert.assertFalse((boolean)rs.next());
            rs = statement.executeQuery("SELECT /*+ INDEX(" + tableName + " " + indexName + ") */  K2 FROM " + tableName + " WHERE V = 5");
            Assert.assertTrue((String)("Index " + indexName + " should have been used"), (boolean)rs.unwrap(PhoenixResultSet.class).getStatement().getQueryPlan().getTableRef().getTable().getName().getString().equals(indexName));
            Assert.assertTrue((boolean)rs.next());
            UpsertSelectWithRegionMovesIT.moveRegionsOfTable(tableName);
            UpsertSelectWithRegionMovesIT.moveRegionsOfTable(indexName);
            Assert.assertEquals((long)5000L, (long)rs.getLong("k2"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)5000L, (long)rs.getLong("k2"));
            Assert.assertTrue((boolean)rs.next());
            UpsertSelectWithRegionMovesIT.moveRegionsOfTable(tableName);
            UpsertSelectWithRegionMovesIT.moveRegionsOfTable(indexName);
            Assert.assertEquals((long)5000L, (long)rs.getLong("k2"));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testLengthLimitedVarchar() throws Exception {
        String tableName1 = UpsertSelectWithRegionMovesIT.generateUniqueName();
        String tableName2 = UpsertSelectWithRegionMovesIT.generateUniqueName();
        TABLE_NAMES.add(tableName1);
        TABLE_NAMES.add(tableName2);
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        try (Connection conn = DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
             Statement stmt = conn.createStatement();){
            conn.setAutoCommit(true);
            stmt.execute("create table " + tableName1 + "(name varchar(160) primary key, id varchar(120), address varchar(160))");
            stmt.execute("create table " + tableName2 + "(name varchar(160) primary key, id varchar(10), address  varchar(10))");
            stmt.execute("upsert into " + tableName1 + " values('test','test','test')");
            stmt.execute("upsert into " + tableName2 + " select * from " + tableName1);
            ResultSet rs = stmt.executeQuery("select * from " + tableName2);
            Assert.assertTrue((boolean)rs.next());
            UpsertSelectWithRegionMovesIT.moveRegionsOfTable(tableName1);
            UpsertSelectWithRegionMovesIT.moveRegionsOfTable(tableName2);
            Assert.assertEquals((Object)"test", (Object)rs.getString(1));
            Assert.assertEquals((Object)"test", (Object)rs.getString(2));
            Assert.assertEquals((Object)"test", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    private Connection getTenantConnection(String tenantId) throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        props.setProperty("TenantId", tenantId);
        return DriverManager.getConnection(UpsertSelectWithRegionMovesIT.getUrl(), props);
    }
}

