/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class UpsertBigValuesIT
extends ParallelStatsDisabledIT {
    private static final long INTEGER_MIN_MINUS_ONE = -2147483649L;
    private static final long INTEGER_MAX_PLUS_ONE = 0x80000000L;

    @Test
    public void testIntegerPK() throws Exception {
        int i;
        int[] testNumbers = new int[]{Integer.MIN_VALUE, -2147483647, -2, -1, 0, 1, 2, 0x7FFFFFFE, Integer.MAX_VALUE};
        String tableName = UpsertBigValuesIT.generateUniqueName();
        UpsertBigValuesIT.ensureTableCreated(UpsertBigValuesIT.getUrl(), tableName, "PKIntValueTest");
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(UpsertBigValuesIT.getUrl(), props);
        String upsert = "UPSERT INTO " + tableName + " VALUES(?)";
        PreparedStatement stmt = conn.prepareStatement(upsert);
        for (int i2 = 0; i2 < testNumbers.length; ++i2) {
            stmt.setInt(1, testNumbers[i2]);
            stmt.execute();
        }
        conn.commit();
        String select = "SELECT COUNT(*) from " + tableName;
        ResultSet rs = conn.createStatement().executeQuery(select);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)testNumbers.length, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        select = "SELECT count(*) FROM " + tableName + " where pk >= -2147483648";
        rs = conn.createStatement().executeQuery(select);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)testNumbers.length, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        select = "SELECT pk FROM " + tableName + " where pk >= -2147483648 GROUP BY pk ORDER BY pk ASC NULLS LAST";
        rs = conn.createStatement().executeQuery(select);
        for (i = 0; i < testNumbers.length; ++i) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)testNumbers[i], (long)rs.getInt(1));
        }
        Assert.assertFalse((boolean)rs.next());
        select = "SELECT count(*) FROM " + tableName + " where pk <= 2147483647";
        rs = conn.createStatement().executeQuery(select);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)testNumbers.length, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        select = "SELECT pk FROM " + tableName + " where pk <= 2147483647 GROUP BY pk ORDER BY pk DESC NULLS LAST";
        rs = conn.createStatement().executeQuery(select);
        for (i = testNumbers.length - 1; i >= 0; --i) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)testNumbers[i], (long)rs.getInt(1));
        }
        Assert.assertFalse((boolean)rs.next());
        select = "SELECT count(*) FROM " + tableName + " where pk >= -2147483649";
        rs = conn.createStatement().executeQuery(select);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)testNumbers.length, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        select = "SELECT pk FROM " + tableName + " where pk >= -2147483649 GROUP BY pk ORDER BY pk ASC NULLS LAST ";
        rs = conn.createStatement().executeQuery(select);
        for (i = 0; i < testNumbers.length; ++i) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)testNumbers[i], (long)rs.getInt(1));
        }
        Assert.assertFalse((boolean)rs.next());
        select = "SELECT count(*) FROM " + tableName + " where pk <= 2147483648";
        rs = conn.createStatement().executeQuery(select);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)testNumbers.length, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        select = "SELECT pk FROM " + tableName + " where pk <= 2147483648 GROUP BY pk ORDER BY pk DESC NULLS LAST";
        rs = conn.createStatement().executeQuery(select);
        for (i = testNumbers.length - 1; i >= 0; --i) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)testNumbers[i], (long)rs.getInt(1));
        }
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }

    @Test
    public void testBigIntPK() throws Exception {
        int i;
        String tableName = UpsertBigValuesIT.generateUniqueName();
        long[] testNumbers = new long[]{-9223372036854775807L, -9223372036854775806L, -2L, -1L, 0L, 1L, 2L, 0x7FFFFFFFFFFFFFFEL, Long.MAX_VALUE};
        UpsertBigValuesIT.ensureTableCreated(UpsertBigValuesIT.getUrl(), tableName, "PKBigIntValueTest");
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(UpsertBigValuesIT.getUrl(), props);
        String upsert = "UPSERT INTO " + tableName + " VALUES(?)";
        PreparedStatement stmt = conn.prepareStatement(upsert);
        for (int i2 = 0; i2 < testNumbers.length; ++i2) {
            stmt.setLong(1, testNumbers[i2]);
            stmt.execute();
        }
        conn.commit();
        String select = "SELECT COUNT(*) from " + tableName;
        ResultSet rs = conn.createStatement().executeQuery(select);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)testNumbers.length, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        select = "SELECT count(*) FROM " + tableName + " where pk >= -9223372036854775807";
        rs = conn.createStatement().executeQuery(select);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)testNumbers.length, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        select = "SELECT pk FROM " + tableName + " WHERE pk >= -9223372036854775807 GROUP BY pk ORDER BY pk ASC NULLS LAST";
        rs = conn.createStatement().executeQuery(select);
        for (i = 0; i < testNumbers.length; ++i) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)testNumbers[i], (long)rs.getLong(1));
        }
        Assert.assertFalse((boolean)rs.next());
        select = "SELECT count(*) FROM " + tableName + " where pk <= 9223372036854775807";
        rs = conn.createStatement().executeQuery(select);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)testNumbers.length, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        select = "SELECT pk FROM " + tableName + " WHERE pk <= 9223372036854775807 GROUP BY pk ORDER BY pk DESC NULLS LAST";
        rs = conn.createStatement().executeQuery(select);
        for (i = testNumbers.length - 1; i >= 0; --i) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)testNumbers[i], (long)rs.getLong(1));
        }
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }

    @Test
    public void testIntegerKV() throws Exception {
        int i;
        String tableName = UpsertBigValuesIT.generateUniqueName();
        int[] testNumbers = new int[]{Integer.MIN_VALUE, -2147483647, -2, -1, 0, 1, 2, 0x7FFFFFFE, Integer.MAX_VALUE};
        UpsertBigValuesIT.ensureTableCreated(UpsertBigValuesIT.getUrl(), tableName, "KVIntValueTest");
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(UpsertBigValuesIT.getUrl(), props);
        String upsert = "UPSERT INTO " + tableName + " VALUES(?, ?)";
        PreparedStatement stmt = conn.prepareStatement(upsert);
        for (int i2 = 0; i2 < testNumbers.length; ++i2) {
            stmt.setInt(1, i2);
            stmt.setInt(2, testNumbers[i2]);
            stmt.execute();
        }
        conn.commit();
        String select = "SELECT COUNT(*) from " + tableName;
        ResultSet rs = conn.createStatement().executeQuery(select);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)testNumbers.length, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        select = "SELECT count(*) FROM " + tableName + " where kv >= -2147483648";
        rs = conn.createStatement().executeQuery(select);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)testNumbers.length, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        select = "SELECT kv FROM " + tableName + " WHERE kv >= -2147483648 GROUP BY kv ORDER BY kv ASC NULLS LAST";
        rs = conn.createStatement().executeQuery(select);
        for (i = 0; i < testNumbers.length; ++i) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)testNumbers[i], (long)rs.getInt(1));
        }
        Assert.assertFalse((boolean)rs.next());
        select = "SELECT count(*) FROM " + tableName + " where kv <= 2147483647";
        rs = conn.createStatement().executeQuery(select);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)testNumbers.length, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        select = "SELECT kv FROM " + tableName + " WHERE kv <= 2147483647 GROUP BY kv ORDER BY kv DESC NULLS LAST";
        rs = conn.createStatement().executeQuery(select);
        for (i = testNumbers.length - 1; i >= 0; --i) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)testNumbers[i], (long)rs.getInt(1));
        }
        Assert.assertFalse((boolean)rs.next());
        select = "SELECT count(*) FROM " + tableName + " where kv >= -2147483649";
        rs = conn.createStatement().executeQuery(select);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)testNumbers.length, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        select = "SELECT kv FROM " + tableName + " WHERE kv >= -2147483649 GROUP BY kv ORDER BY kv ASC NULLS LAST ";
        rs = conn.createStatement().executeQuery(select);
        for (i = 0; i < testNumbers.length; ++i) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)testNumbers[i], (long)rs.getInt(1));
        }
        Assert.assertFalse((boolean)rs.next());
        select = "SELECT count(*) FROM " + tableName + " where kv <= 2147483648";
        rs = conn.createStatement().executeQuery(select);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)testNumbers.length, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        select = "SELECT kv FROM " + tableName + " WHERE kv <= 2147483648 GROUP BY kv ORDER BY kv DESC NULLS LAST";
        rs = conn.createStatement().executeQuery(select);
        for (i = testNumbers.length - 1; i >= 0; --i) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)testNumbers[i], (long)rs.getInt(1));
        }
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }

    @Test
    public void testBigIntKV() throws Exception {
        int i;
        String tableName = UpsertBigValuesIT.generateUniqueName();
        long[] testNumbers = new long[]{-9223372036854775807L, -9223372036854775806L, -2L, -1L, 0L, 1L, 2L, 0x7FFFFFFFFFFFFFFEL, Long.MAX_VALUE};
        UpsertBigValuesIT.ensureTableCreated(UpsertBigValuesIT.getUrl(), tableName, "KVBigIntValueTest");
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(UpsertBigValuesIT.getUrl(), props);
        String upsert = "UPSERT INTO " + tableName + " VALUES(?,?)";
        PreparedStatement stmt = conn.prepareStatement(upsert);
        for (int i2 = 0; i2 < testNumbers.length; ++i2) {
            stmt.setLong(1, i2);
            stmt.setLong(2, testNumbers[i2]);
            stmt.execute();
        }
        conn.commit();
        String select = "SELECT COUNT(*) from " + tableName;
        ResultSet rs = conn.createStatement().executeQuery(select);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)testNumbers.length, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        select = "SELECT count(*) FROM " + tableName + " where kv >= -9223372036854775807";
        rs = conn.createStatement().executeQuery(select);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)testNumbers.length, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        select = "SELECT kv FROM " + tableName + " WHERE kv >= -9223372036854775807 GROUP BY kv ORDER BY kv ASC NULLS LAST";
        rs = conn.createStatement().executeQuery(select);
        for (i = 0; i < testNumbers.length; ++i) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)testNumbers[i], (long)rs.getLong(1));
        }
        Assert.assertFalse((boolean)rs.next());
        select = "SELECT count(*) FROM " + tableName + " where kv <= 9223372036854775807";
        rs = conn.createStatement().executeQuery(select);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)testNumbers.length, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        select = "SELECT kv FROM " + tableName + " WHERE kv <= 9223372036854775807 GROUP BY kv ORDER BY kv DESC NULLS LAST";
        rs = conn.createStatement().executeQuery(select);
        for (i = testNumbers.length - 1; i >= 0; --i) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)testNumbers[i], (long)rs.getLong(1));
        }
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }

    @Test
    public void testShort() throws Exception {
        List<Short> testData = Arrays.asList((short)Short.MIN_VALUE, (short)Short.MAX_VALUE, (short)-32767, (short)32766, (short)0, (short)1, (short)-1);
        this.testValues(false, (PDataType<?>)PSmallint.INSTANCE, (List)testData);
        this.testValues(true, (PDataType<?>)PSmallint.INSTANCE, (List)testData);
    }

    @Test
    public void testBigInt() throws Exception {
        List<Long> testData = Arrays.asList(Long.MIN_VALUE, Long.MAX_VALUE, -9223372036854775807L, 0x7FFFFFFFFFFFFFFEL, 0L, 1L, -1L);
        this.testValues(false, (PDataType<?>)PLong.INSTANCE, (List)testData);
        this.testValues(true, (PDataType<?>)PLong.INSTANCE, (List)testData);
    }

    private <T extends Number> void testValues(boolean immutable, PDataType<?> dataType, List<T> testData) throws Exception {
        String tableName = UpsertBigValuesIT.generateUniqueName();
        String ddl = String.format("CREATE %s TABLE %s (K INTEGER PRIMARY KEY, V1 %s)", immutable ? "IMMUTABLE" : "", tableName, dataType.getSqlTypeName());
        try (Connection conn = DriverManager.getConnection(UpsertBigValuesIT.getUrl());){
            conn.createStatement().execute(ddl);
            String upsert = "UPSERT INTO " + tableName + " VALUES(?, ?)";
            PreparedStatement stmt = conn.prepareStatement(upsert);
            int id = 1;
            for (Number testVal : testData) {
                stmt.setInt(1, id++);
                stmt.setObject(2, (Object)testVal, dataType.getSqlType());
                stmt.execute();
            }
            conn.commit();
            String query = String.format("SELECT K,V1 FROM %s ORDER BY K ASC", tableName);
            ResultSet rs = conn.createStatement().executeQuery(query);
            int index = 0;
            boolean failed = false;
            ArrayList errors = Lists.newArrayList();
            while (rs.next()) {
                Number testVal;
                Number resultVal = (Number)rs.getObject(2, ((Number)testData.get(0)).getClass());
                if ((testVal = (Number)testData.get(index++)).equals(resultVal)) continue;
                errors.add(String.format("[expected=%s actual=%s] ", testVal, resultVal));
                failed = true;
            }
            String errorMsg = String.format("Data in table didn't match input: immutable=%s, dataType=%s, %s", immutable, dataType.getSqlTypeName(), errors);
            Assert.assertFalse((String)errorMsg, (boolean)failed);
        }
    }
}

