/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.exception.UpgradeInProgressException;
import org.apache.phoenix.exception.UpgradeRequiredException;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.ConnectionQueryServicesImpl;
import org.apache.phoenix.query.DelegateConnectionQueryServices;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.SequenceAllocation;
import org.apache.phoenix.schema.SequenceKey;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Sets;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.apache.phoenix.util.UpgradeUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class UpgradeIT
extends ParallelStatsDisabledIT {
    @Test
    public void testUpgradeRequiredPreventsSQL() throws SQLException {
        String tableName = UpgradeIT.generateUniqueName();
        try (Connection conn = this.getConnection(false, null);){
            conn.createStatement().execute("CREATE TABLE " + tableName + " (PK1 VARCHAR NOT NULL, PK2 VARCHAR, KV1 VARCHAR, KV2 VARCHAR CONSTRAINT PK PRIMARY KEY(PK1, PK2))");
            ConnectionQueryServices delegate = conn.unwrap(PhoenixConnection.class).getQueryServices();
            DelegateConnectionQueryServices servicesWithUpgrade = new DelegateConnectionQueryServices(delegate){

                public boolean isUpgradeRequired() {
                    return true;
                }
            };
            try (PhoenixConnection phxConn = new PhoenixConnection((ConnectionQueryServices)servicesWithUpgrade, UpgradeIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));){
                try {
                    phxConn.createStatement().execute("CREATE TABLE " + UpgradeIT.generateUniqueName() + " (k1 VARCHAR NOT NULL, k2 VARCHAR, CONSTRAINT PK PRIMARY KEY(K1,K2))");
                    Assert.fail((String)"CREATE TABLE should have failed with UpgradeRequiredException");
                }
                catch (UpgradeRequiredException upgradeRequiredException) {
                    // empty catch block
                }
                try {
                    phxConn.createStatement().execute("SELECT * FROM " + tableName);
                    Assert.fail((String)"SELECT should have failed with UpgradeRequiredException");
                }
                catch (UpgradeRequiredException upgradeRequiredException) {
                    // empty catch block
                }
                try {
                    phxConn.createStatement().execute("DELETE FROM " + tableName);
                    Assert.fail((String)"DELETE should have failed with UpgradeRequiredException");
                }
                catch (UpgradeRequiredException upgradeRequiredException) {
                    // empty catch block
                }
                try {
                    phxConn.createStatement().execute("CREATE INDEX " + tableName + "_IDX ON " + tableName + " (KV1) INCLUDE (KV2)");
                    Assert.fail((String)"CREATE INDEX should have failed with UpgradeRequiredException");
                }
                catch (UpgradeRequiredException upgradeRequiredException) {
                    // empty catch block
                }
                try {
                    phxConn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('PK1', 'PK2', 'KV1', 'KV2')");
                    Assert.fail((String)"UPSERT VALUES should have failed with UpgradeRequiredException");
                }
                catch (UpgradeRequiredException upgradeRequiredException) {
                    // empty catch block
                }
            }
        }
    }

    @Test
    public void testUpgradingConnectionBypassesUpgradeRequiredCheck() throws Exception {
        String tableName = UpgradeIT.generateUniqueName();
        try (Connection conn = this.getConnection(false, null);){
            conn.createStatement().execute("CREATE TABLE " + tableName + " (PK1 VARCHAR NOT NULL, PK2 VARCHAR, KV1 VARCHAR, KV2 VARCHAR CONSTRAINT PK PRIMARY KEY(PK1, PK2))");
            ConnectionQueryServices delegate = conn.unwrap(PhoenixConnection.class).getQueryServices();
            DelegateConnectionQueryServices servicesWithUpgrade = new DelegateConnectionQueryServices(delegate){

                public boolean isUpgradeRequired() {
                    return true;
                }
            };
            try (PhoenixConnection phxConn = new PhoenixConnection(conn.unwrap(PhoenixConnection.class), (ConnectionQueryServices)servicesWithUpgrade, conn.getClientInfo());){
                try {
                    phxConn.createStatement().executeQuery("SELECT * FROM " + tableName);
                    Assert.fail((String)"SELECT should have failed with UpgradeRequiredException");
                }
                catch (UpgradeRequiredException upgradeRequiredException) {
                    // empty catch block
                }
                phxConn.setRunningUpgrade(true);
                phxConn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('PK1', 'PK2', 'KV1', 'KV2')");
                phxConn.commit();
                try (ResultSet rs = phxConn.createStatement().executeQuery("SELECT * FROM " + tableName);){
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertFalse((boolean)rs.next());
                }
            }
        }
    }

    @Test
    public void testAcquiringAndReleasingUpgradeMutex() throws Exception {
        ConnectionQueryServices services = null;
        try (Connection conn = this.getConnection(false, null);){
            services = conn.unwrap(PhoenixConnection.class).getQueryServices();
            Assert.assertTrue((boolean)((ConnectionQueryServicesImpl)services).acquireUpgradeMutex(15L));
            try {
                ((ConnectionQueryServicesImpl)services).acquireUpgradeMutex(15L);
                Assert.fail();
            }
            catch (UpgradeInProgressException upgradeInProgressException) {
                // empty catch block
            }
            ((ConnectionQueryServicesImpl)services).releaseUpgradeMutex();
        }
    }

    @Test
    public void testConcurrentUpgradeThrowsUpgradeInProgressException() throws Exception {
        AtomicBoolean mutexStatus1 = new AtomicBoolean(false);
        AtomicBoolean mutexStatus2 = new AtomicBoolean(false);
        AtomicBoolean mutexStatus3 = new AtomicBoolean(true);
        CountDownLatch latch = new CountDownLatch(2);
        AtomicInteger numExceptions = new AtomicInteger(0);
        try (Connection conn = this.getConnection(false, null);){
            ConnectionQueryServices services = conn.unwrap(PhoenixConnection.class).getQueryServices();
            AcquireMutexRunnable task1 = new AcquireMutexRunnable(mutexStatus1, services, latch, numExceptions);
            AcquireMutexRunnable task2 = new AcquireMutexRunnable(mutexStatus2, services, latch, numExceptions);
            AcquireMutexRunnable task3 = new AcquireMutexRunnable(mutexStatus3, services, latch, numExceptions);
            ExecutorService executorService = Executors.newFixedThreadPool(2, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("mutex-acquire-%d").build());
            Future<Void> futureTask1 = executorService.submit(task1);
            Future<Void> futureTask2 = executorService.submit(task2);
            latch.await();
            futureTask1.get();
            futureTask2.get();
            executorService.submit(task3).get();
            Assert.assertTrue((String)"One of the threads should have acquired the mutex", (mutexStatus1.get() || mutexStatus2.get() || mutexStatus3.get() ? 1 : 0) != 0);
            Assert.assertNotEquals((String)"One and only one thread should have acquired the mutex ", (Object)mutexStatus1.get(), (Object)mutexStatus2.get());
            Assert.assertFalse((String)"mutexStatus3 should never be true ", (boolean)mutexStatus3.get());
            Assert.assertEquals((String)"One and only one thread should have caught UpgradeRequiredException ", (long)2L, (long)numExceptions.get());
            ((ConnectionQueryServicesImpl)services).releaseUpgradeMutex();
        }
    }

    private Connection createTenantConnection(String tenantId) throws SQLException {
        Properties props = new Properties();
        props.setProperty("TenantId", tenantId);
        return DriverManager.getConnection(UpgradeIT.getUrl(), props);
    }

    private Connection getConnection(boolean tenantSpecific, String tenantId, boolean isNamespaceMappingEnabled, boolean copyChildLinksDuringUpgrade) throws SQLException {
        if (tenantSpecific) {
            Preconditions.checkNotNull((Object)tenantId);
            return this.createTenantConnection(tenantId);
        }
        Properties props = new Properties();
        if (isNamespaceMappingEnabled) {
            props.setProperty("phoenix.schema.isNamespaceMappingEnabled", "true");
        }
        if (copyChildLinksDuringUpgrade) {
            props.setProperty("phoenix.move.child_link.during.upgrade", "false");
        }
        return DriverManager.getConnection(UpgradeIT.getUrl(), props);
    }

    private Connection getConnection(boolean tenantSpecific, String tenantId) throws SQLException {
        return this.getConnection(tenantSpecific, tenantId, false, false);
    }

    @Test
    public void testMoveParentChildLinks() throws Exception {
        this.testParentChildLinksHelper(false);
    }

    @Test
    public void testCopyParentChildLinks() throws Exception {
        this.testParentChildLinksHelper(true);
    }

    @Test
    public void testCopyTTLValuesFromPhoenixTTLColumnToTTLColumn() throws Exception {
        try (PhoenixConnection conn = this.getConnection(false, null).unwrap(PhoenixConnection.class);
             Connection metaConn = this.getConnection(false, null, false, false);){
            String dml = "UPSERT INTO SYSTEM.CATALOG (TENANT_ID, TABLE_SCHEM, TABLE_NAME, PHOENIX_TTL) VALUES (?,?,?,?)";
            String tableName = "T_" + UpgradeIT.generateUniqueName();
            String tableName1 = "T_" + UpgradeIT.generateUniqueName();
            String tableName2 = "T_" + UpgradeIT.generateUniqueName();
            long randomValue = 181938859789797187L;
            long randomIntValue = 156743L;
            PreparedStatement prepareStatement = conn.prepareStatement(dml);
            for (int i = 1; i < 6; ++i) {
                prepareStatement.setString(1, null);
                prepareStatement.setString(2, "S_" + UpgradeIT.generateUniqueName());
                prepareStatement.setString(3, "T_" + UpgradeIT.generateUniqueName());
                prepareStatement.setNull(4, -5);
                prepareStatement.execute();
            }
            prepareStatement.setString(1, null);
            prepareStatement.setString(2, "S_" + UpgradeIT.generateUniqueName());
            prepareStatement.setString(3, tableName);
            prepareStatement.setLong(4, randomValue);
            prepareStatement.execute();
            prepareStatement.setString(1, null);
            prepareStatement.setString(2, "S_" + UpgradeIT.generateUniqueName());
            prepareStatement.setString(3, tableName1);
            prepareStatement.setLong(4, randomIntValue);
            prepareStatement.execute();
            prepareStatement.setString(1, null);
            prepareStatement.setString(2, "S_" + UpgradeIT.generateUniqueName());
            prepareStatement.setString(3, tableName2);
            prepareStatement.setLong(4, Long.MAX_VALUE);
            prepareStatement.execute();
            conn.commit();
            String sql = "SELECT PHOENIX_TTL FROM SYSTEM.CATALOG WHERE TABLE_NAME = '" + tableName + "'";
            ResultSet rs = conn.createStatement().executeQuery(sql);
            rs.next();
            Assert.assertEquals((String)"Should have return one value for PHOENIX_TTL column", (long)randomValue, (long)rs.getLong(1));
            String sql1 = "SELECT PHOENIX_TTL FROM SYSTEM.CATALOG WHERE TABLE_NAME = '" + tableName1 + "'";
            ResultSet rs1 = conn.createStatement().executeQuery(sql1);
            rs1.next();
            Assert.assertEquals((String)"Should have return one value for PHOENIX_TTL column", (long)randomIntValue, (long)rs1.getLong(1));
            String sql2 = "SELECT PHOENIX_TTL FROM SYSTEM.CATALOG WHERE TABLE_NAME = '" + tableName2 + "'";
            ResultSet rs2 = conn.createStatement().executeQuery(sql2);
            rs2.next();
            Assert.assertEquals((String)"Should have return one value for PHOENIX_TTL column", (long)Long.MAX_VALUE, (long)rs2.getLong(1));
            PhoenixConnection phxMetaConn = metaConn.unwrap(PhoenixConnection.class);
            phxMetaConn.setRunningUpgrade(true);
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("hbase.rpc.timeout", Integer.toString(1800000));
            options.put("hbase.client.scanner.timeout.period", Integer.toString(1800000));
            String clientPort = UpgradeIT.getUtility().getConfiguration().get("hbase.zookeeper.property.clientPort");
            String localQuorum = String.format("localhost:%s", clientPort);
            options.put("hbase.zookeeper.quorum", localQuorum);
            options.put("hbase.zookeeper.property.clientPort", clientPort);
            UpgradeUtil.copyTTLValuesFromPhoenixTTLColumnToTTLColumn((PhoenixConnection)phxMetaConn, options);
            String sql3 = "SELECT TTL FROM SYSTEM.CATALOG WHERE TABLE_NAME = '" + tableName + "'";
            ResultSet rs3 = conn.createStatement().executeQuery(sql3);
            Assert.assertTrue((boolean)rs3.next());
            int ttl = Integer.valueOf(rs3.getString(1));
            Assert.assertEquals((String)"Should have return one value for PHOENIX_TTL column", (long)Integer.MAX_VALUE, (long)ttl);
            String sql4 = "SELECT TTL FROM SYSTEM.CATALOG WHERE TABLE_NAME = '" + tableName1 + "'";
            ResultSet rs4 = conn.createStatement().executeQuery(sql4);
            Assert.assertTrue((boolean)rs4.next());
            ttl = Integer.valueOf(rs4.getString(1));
            Assert.assertEquals((String)"Should have return one value for PHOENIX_TTL column", (long)randomIntValue, (long)ttl);
            String sql5 = "SELECT TTL FROM SYSTEM.CATALOG WHERE TABLE_NAME = '" + tableName2 + "'";
            ResultSet rs5 = conn.createStatement().executeQuery(sql5);
            Assert.assertTrue((boolean)rs5.next());
            ttl = Integer.valueOf(rs5.getString(1));
            Assert.assertEquals((String)"Should have return one value for PHOENIX_TTL column", (long)Integer.MAX_VALUE, (long)ttl);
        }
    }

    private void testParentChildLinksHelper(boolean copyMode) throws Exception {
        String schema = "S_" + UpgradeIT.generateUniqueName();
        String table1 = "T_" + UpgradeIT.generateUniqueName();
        String table2 = "T_" + UpgradeIT.generateUniqueName();
        String tableName = SchemaUtil.getTableName((String)schema, (String)table1);
        String multiTenantTableName = SchemaUtil.getTableName((String)schema, (String)table2);
        String viewName1 = "VIEW_" + UpgradeIT.generateUniqueName();
        String viewIndexName1 = "VIDX_" + UpgradeIT.generateUniqueName();
        String viewName2 = "VIEW_" + UpgradeIT.generateUniqueName();
        String viewIndexName2 = "VIDX_" + UpgradeIT.generateUniqueName();
        try (Connection conn = this.getConnection(false, null);
             Connection tenantConn = this.getConnection(true, "tenant1");
             Connection metaConn = this.getConnection(false, null, false, copyMode);){
            conn.createStatement().execute("CREATE TABLE IF NOT EXISTS " + tableName + " ( TENANT_ID CHAR(15) NOT NULL,  PK1 integer NOT NULL, PK2 bigint NOT NULL, V1 VARCHAR, V2 VARCHAR  CONSTRAINT NAME_PK PRIMARY KEY (TENANT_ID, PK1, PK2))");
            conn.createStatement().execute("CREATE TABLE IF NOT EXISTS " + multiTenantTableName + " ( TENANT_ID CHAR(15) NOT NULL,  PK1 integer NOT NULL, PK2 bigint NOT NULL, V1 VARCHAR, V2 VARCHAR  CONSTRAINT NAME_PK PRIMARY KEY (TENANT_ID, PK1, PK2) ) MULTI_TENANT= true");
            conn.createStatement().execute("CREATE VIEW " + viewName1 + " (col VARCHAR) AS SELECT * FROM " + tableName);
            tenantConn.createStatement().execute("CREATE VIEW " + viewName2 + "(col VARCHAR) AS SELECT * FROM " + multiTenantTableName);
            conn.createStatement().execute("create index " + viewIndexName1 + "  on " + viewName1 + "(col)");
            tenantConn.createStatement().execute("create index " + viewIndexName2 + " on " + viewName2 + "(col)");
            Set<String> expectedChildLinkSet = this.getChildLinks(conn, PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME);
            conn.createStatement().execute("DELETE FROM SYSTEM.CHILD_LINK WHERE LINK_TYPE = " + PTable.LinkType.CHILD_TABLE.getSerializedValue());
            PhoenixConnection phxMetaConn = metaConn.unwrap(PhoenixConnection.class);
            phxMetaConn.setRunningUpgrade(true);
            UpgradeUtil.addParentToChildLinks((PhoenixConnection)phxMetaConn);
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("hbase.rpc.timeout", Integer.toString(1800000));
            options.put("hbase.client.scanner.timeout.period", Integer.toString(1800000));
            String clientPort = UpgradeIT.getUtility().getConfiguration().get("hbase.zookeeper.property.clientPort");
            String localQuorum = String.format("localhost:%s", clientPort);
            options.put("hbase.zookeeper.quorum", localQuorum);
            options.put("hbase.zookeeper.property.clientPort", clientPort);
            UpgradeUtil.moveOrCopyChildLinks((PhoenixConnection)phxMetaConn, options);
            Set<String> actualChildLinkSet = this.getChildLinks(conn, PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME);
            Set<String> actualChildLinkInSyscatSet = this.getChildLinks(conn, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME);
            Assert.assertEquals((String)"Unexpected child links", expectedChildLinkSet, actualChildLinkSet);
            if (copyMode) {
                Assert.assertEquals((String)"Unexpected child links in catalog", expectedChildLinkSet, actualChildLinkInSyscatSet);
            } else {
                Assert.assertEquals((String)"Unexpected child links in catalog", new HashSet(), actualChildLinkInSyscatSet);
            }
        }
    }

    @Test
    public void testRemoveScnFromTaskAndLog() throws Exception {
        PhoenixConnection conn = this.getConnection(false, null).unwrap(PhoenixConnection.class);
        ConnectionQueryServicesImpl cqs = (ConnectionQueryServicesImpl)conn.getQueryServices();
        try (Statement stmt = conn.createStatement();){
            stmt.executeUpdate("ALTER TABLE " + PhoenixDatabaseMetaData.SYSTEM_LOG_NAME + " SET KEEP_DELETED_CELLS='" + KeepDeletedCells.TRUE + "',\nVERSIONS='1000'\n");
            stmt.executeUpdate("ALTER TABLE " + PhoenixDatabaseMetaData.SYSTEM_STATS_NAME + " SET KEEP_DELETED_CELLS='" + KeepDeletedCells.TRUE + "',\nVERSIONS='1000'\n");
        }
        PTable sysLogTable = conn.getTable(PhoenixDatabaseMetaData.SYSTEM_LOG_NAME);
        TableDescriptor sysLogDesc = utility.getAdmin().getDescriptor(SchemaUtil.getPhysicalTableName((String)PhoenixDatabaseMetaData.SYSTEM_LOG_NAME, (ReadOnlyProps)cqs.getProps()));
        Assert.assertEquals((Object)KeepDeletedCells.TRUE, (Object)sysLogDesc.getColumnFamily(SchemaUtil.getEmptyColumnFamily((PTable)sysLogTable)).getKeepDeletedCells());
        Assert.assertEquals((long)1000L, (long)sysLogDesc.getColumnFamily(SchemaUtil.getEmptyColumnFamily((PTable)sysLogTable)).getMaxVersions());
        PTable sysStatsTable = conn.getTable(PhoenixDatabaseMetaData.SYSTEM_STATS_NAME);
        TableDescriptor sysStatsDesc = utility.getAdmin().getDescriptor(SchemaUtil.getPhysicalTableName((String)PhoenixDatabaseMetaData.SYSTEM_STATS_NAME, (ReadOnlyProps)cqs.getProps()));
        Assert.assertEquals((Object)KeepDeletedCells.TRUE, (Object)sysStatsDesc.getColumnFamily(SchemaUtil.getEmptyColumnFamily((PTable)sysStatsTable)).getKeepDeletedCells());
        Assert.assertEquals((long)1000L, (long)sysStatsDesc.getColumnFamily(SchemaUtil.getEmptyColumnFamily((PTable)sysStatsTable)).getMaxVersions());
        cqs.upgradeSystemLog(conn, new HashMap());
        cqs.upgradeSystemStats(conn, new HashMap());
        sysLogDesc = utility.getAdmin().getDescriptor(SchemaUtil.getPhysicalTableName((String)PhoenixDatabaseMetaData.SYSTEM_LOG_NAME, (ReadOnlyProps)cqs.getProps()));
        Assert.assertEquals((Object)KeepDeletedCells.FALSE, (Object)sysLogDesc.getColumnFamily(SchemaUtil.getEmptyColumnFamily((PTable)sysLogTable)).getKeepDeletedCells());
        Assert.assertEquals((long)1L, (long)sysLogDesc.getColumnFamily(SchemaUtil.getEmptyColumnFamily((PTable)sysLogTable)).getMaxVersions());
        sysStatsDesc = utility.getAdmin().getDescriptor(SchemaUtil.getPhysicalTableName((String)PhoenixDatabaseMetaData.SYSTEM_STATS_NAME, (ReadOnlyProps)cqs.getProps()));
        Assert.assertEquals((Object)KeepDeletedCells.FALSE, (Object)sysStatsDesc.getColumnFamily(SchemaUtil.getEmptyColumnFamily((PTable)sysStatsTable)).getKeepDeletedCells());
        Assert.assertEquals((long)1L, (long)sysStatsDesc.getColumnFamily(SchemaUtil.getEmptyColumnFamily((PTable)sysStatsTable)).getMaxVersions());
    }

    @Test
    public void testCacheOnWritePropsOnSystemSequence() throws Exception {
        PhoenixConnection conn = this.getConnection(false, null).unwrap(PhoenixConnection.class);
        ConnectionQueryServicesImpl cqs = (ConnectionQueryServicesImpl)conn.getQueryServices();
        TableDescriptor initialTD = utility.getAdmin().getDescriptor(SchemaUtil.getPhysicalTableName((String)PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME, (ReadOnlyProps)cqs.getProps()));
        ColumnFamilyDescriptor initialCFD = initialTD.getColumnFamily(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)initialCFD.isCacheBloomsOnWrite());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)initialCFD.isCacheDataOnWrite());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)initialCFD.isCacheIndexesOnWrite());
        ColumnFamilyDescriptorBuilder newCFBuilder = ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)initialCFD);
        newCFBuilder.setCacheBloomsOnWrite(false);
        newCFBuilder.setCacheDataOnWrite(false);
        newCFBuilder.setCacheIndexesOnWrite(false);
        TableDescriptorBuilder newTD = TableDescriptorBuilder.newBuilder((TableDescriptor)initialTD);
        newTD.modifyColumnFamily(newCFBuilder.build());
        utility.getAdmin().modifyTable(newTD.build());
        TableDescriptor updatedTD = utility.getAdmin().getDescriptor(SchemaUtil.getPhysicalTableName((String)PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME, (ReadOnlyProps)cqs.getProps()));
        ColumnFamilyDescriptor updatedCFD = updatedTD.getColumnFamily(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)updatedCFD.isCacheBloomsOnWrite());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)updatedCFD.isCacheDataOnWrite());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)updatedCFD.isCacheIndexesOnWrite());
        cqs.upgradeSystemSequence(conn, new HashMap());
        updatedTD = utility.getAdmin().getDescriptor(SchemaUtil.getPhysicalTableName((String)PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME, (ReadOnlyProps)cqs.getProps()));
        updatedCFD = updatedTD.getColumnFamily(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)updatedCFD.isCacheBloomsOnWrite());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)updatedCFD.isCacheDataOnWrite());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)updatedCFD.isCacheIndexesOnWrite());
    }

    private Set<String> getChildLinks(Connection conn, String tableName) throws SQLException {
        ResultSet rs = conn.createStatement().executeQuery(String.format("SELECT TENANT_ID, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, COLUMN_FAMILY FROM %s WHERE LINK_TYPE = %d", tableName, PTable.LinkType.CHILD_TABLE.getSerializedValue()));
        HashSet childLinkSet = Sets.newHashSet();
        while (rs.next()) {
            String key = rs.getString("TENANT_ID") + " " + rs.getString("TABLE_SCHEM") + " " + rs.getString("TABLE_NAME") + " " + rs.getString("COLUMN_NAME") + " " + rs.getString("COLUMN_FAMILY");
            childLinkSet.add(key);
        }
        return childLinkSet;
    }

    @Test
    public void testMergeViewIndexSequences() throws Exception {
        this.testMergeViewIndexSequencesHelper(false);
    }

    @Test
    public void testMergeViewIndexSequencesWithNamespaces() throws Exception {
        this.testMergeViewIndexSequencesHelper(true);
    }

    private void testMergeViewIndexSequencesHelper(boolean isNamespaceMappingEnabled) throws Exception {
        PhoenixConnection conn = this.getConnection(false, null, isNamespaceMappingEnabled, false).unwrap(PhoenixConnection.class);
        ConnectionQueryServices cqs = conn.getQueryServices();
        conn.createStatement().execute("DELETE FROM SYSTEM.\"SEQUENCE\"");
        conn.commit();
        cqs.clearCache();
        try (PhoenixConnection mockUpgradeScnTsConn = new PhoenixConnection(conn, 29L);){
            UpgradeUtil.mergeViewIndexIdSequences((PhoenixConnection)mockUpgradeScnTsConn);
        }
        PName tenantOne = PNameFactory.newName((String)"TENANT_ONE");
        PName tenantTwo = PNameFactory.newName((String)"TENANT_TWO");
        String tableName = SchemaUtil.getPhysicalHBaseTableName((String)"TEST", (String)("T_" + UpgradeIT.generateUniqueName()), (boolean)isNamespaceMappingEnabled).getString();
        PName viewIndexTable = PNameFactory.newName((String)MetaDataUtil.getViewIndexPhysicalName((String)tableName));
        SequenceKey sequenceOne = this.createViewIndexSequenceWithOldName(cqs, tenantOne, viewIndexTable, isNamespaceMappingEnabled);
        SequenceKey sequenceTwo = this.createViewIndexSequenceWithOldName(cqs, tenantTwo, viewIndexTable, isNamespaceMappingEnabled);
        SequenceKey sequenceGlobal = this.createViewIndexSequenceWithOldName(cqs, null, viewIndexTable, isNamespaceMappingEnabled);
        ArrayList allocations = Lists.newArrayList();
        long val1 = 10L;
        long val2 = 100L;
        long val3 = 1000L;
        allocations.add(new SequenceAllocation(sequenceOne, val1));
        allocations.add(new SequenceAllocation(sequenceGlobal, val2));
        allocations.add(new SequenceAllocation(sequenceTwo, val3));
        long[] incrementedValues = new long[3];
        SQLException[] exceptions = new SQLException[3];
        cqs.incrementSequences((List)allocations, EnvironmentEdgeManager.currentTimeMillis(), incrementedValues, exceptions);
        for (SQLException e : exceptions) {
            Assert.assertNull((Object)e);
        }
        try (PhoenixConnection mockUpgradeScnTsConn = new PhoenixConnection(conn, 29L);){
            UpgradeUtil.mergeViewIndexIdSequences((PhoenixConnection)mockUpgradeScnTsConn);
        }
        ArrayList afterUpgradeAllocations = Lists.newArrayList();
        SequenceKey sequenceUpgrade = MetaDataUtil.getViewIndexSequenceKey(null, (PName)viewIndexTable, (int)0, (boolean)isNamespaceMappingEnabled);
        afterUpgradeAllocations.add(new SequenceAllocation(sequenceUpgrade, 1L));
        long[] afterUpgradeValues = new long[1];
        SQLException[] afterUpgradeExceptions = new SQLException[1];
        cqs.incrementSequences((List)afterUpgradeAllocations, EnvironmentEdgeManager.currentTimeMillis(), afterUpgradeValues, afterUpgradeExceptions);
        Assert.assertNull((Object)afterUpgradeExceptions[0]);
        int safetyIncrement = 100;
        if (isNamespaceMappingEnabled) {
            Assert.assertEquals((long)(Long.MIN_VALUE + val3 + (long)safetyIncrement + 1L), (long)afterUpgradeValues[0]);
        } else {
            Assert.assertEquals((long)(Long.MIN_VALUE + val3 + (long)safetyIncrement), (long)afterUpgradeValues[0]);
        }
    }

    private SequenceKey createViewIndexSequenceWithOldName(ConnectionQueryServices cqs, PName tenant, PName viewIndexTable, boolean isNamespaceMapped) throws SQLException {
        String tenantId = tenant == null ? null : tenant.getString();
        SequenceKey key = MetaDataUtil.getOldViewIndexSequenceKey((String)tenantId, (PName)viewIndexTable, (int)0, (boolean)isNamespaceMapped);
        String sequenceTenantId = isNamespaceMapped ? tenantId : null;
        cqs.createSequence(sequenceTenantId, key.getSchemaName(), key.getSequenceName(), Long.MIN_VALUE, 1L, 1L, Long.MIN_VALUE, Long.MAX_VALUE, false, EnvironmentEdgeManager.currentTimeMillis());
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpgradeViewIndexIdDataType() throws Exception {
        byte[] rowKey = SchemaUtil.getColumnKey(null, (String)"SYSTEM", (String)"CATALOG", (String)"VIEW_INDEX_ID", (String)"0");
        byte[] syscatBytes = PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME.getBytes();
        byte[] viewIndexIdTypeCellValueIn414 = PInteger.INSTANCE.toBytes((Object)5);
        byte[] viewIndexIdTypeCellValueIn416 = PInteger.INSTANCE.toBytes((Object)-5);
        try (PhoenixConnection conn = this.getConnection(false, null).unwrap(PhoenixConnection.class);){
            this.updateViewIndexIdColumnValue(rowKey, syscatBytes, viewIndexIdTypeCellValueIn414);
            Assert.assertTrue((boolean)UpgradeUtil.isUpdateViewIndexIdColumnDataTypeFromShortToLongNeeded((PhoenixConnection)conn, (byte[])rowKey, (byte[])syscatBytes));
            this.verifyExpectedCellValue(rowKey, syscatBytes, viewIndexIdTypeCellValueIn414);
            UpgradeUtil.updateViewIndexIdColumnDataTypeFromShortToLong((PhoenixConnection)conn, (byte[])rowKey, (byte[])syscatBytes);
            this.verifyExpectedCellValue(rowKey, syscatBytes, viewIndexIdTypeCellValueIn416);
            Assert.assertFalse((boolean)UpgradeUtil.isUpdateViewIndexIdColumnDataTypeFromShortToLongNeeded((PhoenixConnection)conn, (byte[])rowKey, (byte[])syscatBytes));
        }
        finally {
            this.updateViewIndexIdColumnValue(rowKey, syscatBytes, viewIndexIdTypeCellValueIn416);
        }
    }

    private void updateViewIndexIdColumnValue(byte[] rowKey, byte[] syscatBytes, byte[] newColumnValue) throws Exception {
        try (PhoenixConnection conn = DriverManager.getConnection(UpgradeIT.getUrl()).unwrap(PhoenixConnection.class);
             Table sysTable = conn.getQueryServices().getTable(syscatBytes);){
            KeyValue viewIndexIdKV = new KeyValue(rowKey, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.DATA_TYPE_BYTES, 42L, newColumnValue);
            Put viewIndexIdPut = new Put(rowKey);
            viewIndexIdPut.add((Cell)viewIndexIdKV);
            sysTable.put(viewIndexIdPut);
        }
    }

    private void verifyExpectedCellValue(byte[] rowKey, byte[] syscatBytes, byte[] expectedDateTypeBytes) throws Exception {
        try (PhoenixConnection conn = this.getConnection(false, null).unwrap(PhoenixConnection.class);
             Table sysTable = conn.getQueryServices().getTable(syscatBytes);){
            Scan s = new Scan();
            s.setRowPrefixFilter(rowKey);
            s.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.DATA_TYPE_BYTES);
            ResultScanner scanner = sysTable.getScanner(s);
            Result result = scanner.next();
            Cell cell = result.getColumnLatestCell(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.DATA_TYPE_BYTES);
            Assert.assertArrayEquals((byte[])expectedDateTypeBytes, (byte[])CellUtil.cloneValue((Cell)cell));
        }
    }

    @Test
    public void testLastDDLTimestampBootstrap() throws Exception {
        Long testStartTime = EnvironmentEdgeManager.currentTimeMillis();
        String schemaName = "S_" + UpgradeIT.generateUniqueName();
        String tableName = "T_" + UpgradeIT.generateUniqueName();
        String viewName = "V_" + UpgradeIT.generateUniqueName();
        String indexName = "I_" + UpgradeIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String fullViewName = SchemaUtil.getTableName((String)schemaName, (String)viewName);
        try (Connection conn = this.getConnection(false, null);){
            conn.createStatement().execute("CREATE TABLE " + fullTableName + " (PK1 VARCHAR NOT NULL, PK2 VARCHAR, KV1 VARCHAR, KV2 VARCHAR CONSTRAINT PK PRIMARY KEY(PK1, PK2)) ");
            conn.createStatement().execute("CREATE VIEW " + fullViewName + " AS SELECT * FROM " + fullTableName);
            conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + fullTableName + " (KV1) ASYNC");
            this.nullDDLTimestamps(conn);
            long tableTS = this.getRowTimestampForMetadata(conn, schemaName, tableName, PTableType.TABLE);
            long viewTS = this.getRowTimestampForMetadata(conn, schemaName, viewName, PTableType.VIEW);
            long indexTS = this.getRowTimestampForMetadata(conn, schemaName, indexName, PTableType.INDEX);
            Assert.assertTrue((tableTS > testStartTime ? 1 : 0) != 0);
            Assert.assertTrue((viewTS > testStartTime ? 1 : 0) != 0);
            Assert.assertTrue((indexTS > testStartTime ? 1 : 0) != 0);
            UpgradeUtil.bootstrapLastDDLTimestampForTablesAndViews((Connection)((Connection)conn.unwrap(PhoenixConnection.class)));
            long actualTableTS = this.getLastTimestampForMetadata(conn, schemaName, tableName, PTableType.TABLE);
            long actualViewTS = this.getLastTimestampForMetadata(conn, schemaName, viewName, PTableType.VIEW);
            long actualIndexTS = this.getLastTimestampForMetadata(conn, schemaName, indexName, PTableType.INDEX);
            Assert.assertEquals((long)tableTS, (long)actualTableTS);
            Assert.assertEquals((long)viewTS, (long)actualViewTS);
            Assert.assertEquals((long)0L, (long)actualIndexTS);
            UpgradeUtil.bootstrapLastDDLTimestampForIndexes((Connection)((Connection)conn.unwrap(PhoenixConnection.class)));
            actualIndexTS = this.getLastTimestampForMetadata(conn, schemaName, indexName, PTableType.INDEX);
            Assert.assertEquals((long)indexTS, (long)actualIndexTS);
        }
    }

    private void nullDDLTimestamps(Connection conn) throws SQLException {
        String pkCols = "TENANT_ID, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, COLUMN_FAMILY";
        String upsertSql = "UPSERT INTO " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " (" + pkCols + ", LAST_DDL_TIMESTAMP) SELECT " + pkCols + ", NULL FROM " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " WHERE TABLE_TYPE  != '" + PTableType.SYSTEM.getSerializedValue() + "'";
        conn.createStatement().execute(upsertSql);
        conn.commit();
    }

    private long getRowTimestampForMetadata(Connection conn, String schemaName, String objectName, PTableType type) throws SQLException {
        String sql = "SELECT PHOENIX_ROW_TIMESTAMP() FROM " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " WHERE  TENANT_ID IS NULL AND TABLE_SCHEM = ? AND TABLE_NAME = ? and TABLE_TYPE = ?";
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmt.setString(1, schemaName);
        stmt.setString(2, objectName);
        stmt.setString(3, type.getSerializedValue());
        ResultSet rs = stmt.executeQuery();
        Assert.assertNotNull((Object)rs);
        Assert.assertTrue((String)"Result set was empty!", (boolean)rs.next());
        return rs.getLong(1);
    }

    private long getLastTimestampForMetadata(Connection conn, String schemaName, String objectName, PTableType type) throws SQLException {
        String sql = "SELECT LAST_DDL_TIMESTAMP FROM " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " WHERE  TENANT_ID IS NULL AND TABLE_SCHEM = ? AND TABLE_NAME = ? and TABLE_TYPE = ?";
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmt.setString(1, schemaName);
        stmt.setString(2, objectName);
        stmt.setString(3, type.getSerializedValue());
        ResultSet rs = stmt.executeQuery();
        Assert.assertNotNull((Object)rs);
        Assert.assertTrue((String)"Result set was empty!", (boolean)rs.next());
        return rs.getLong(1);
    }

    private static class AcquireMutexRunnable
    implements Callable<Void> {
        private final AtomicBoolean acquireStatus;
        private final ConnectionQueryServices services;
        private final CountDownLatch latch;
        private final AtomicInteger numExceptions;

        private AcquireMutexRunnable(AtomicBoolean acquireStatus, ConnectionQueryServices services, CountDownLatch latch, AtomicInteger numExceptions) {
            this.acquireStatus = acquireStatus;
            this.services = services;
            this.latch = latch;
            this.numExceptions = numExceptions;
        }

        @Override
        public Void call() throws Exception {
            try {
                ((ConnectionQueryServicesImpl)this.services).acquireUpgradeMutex(15L);
                this.acquireStatus.set(true);
            }
            catch (UpgradeInProgressException e) {
                this.acquireStatus.set(false);
                this.numExceptions.incrementAndGet();
            }
            finally {
                this.latch.countDown();
            }
            return null;
        }
    }
}

