/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Table;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PMetaData;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.thirdparty.com.google.common.base.Throwables;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class UpdateCacheAcrossDifferentClientsIT
extends BaseTest {
    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        HBaseTestingUtility hbaseTestUtil = new HBaseTestingUtility(conf);
        UpdateCacheAcrossDifferentClientsIT.setUpConfigForMiniCluster(conf);
        conf.set("phoenix.jdbc.extra.arguments", "");
        conf.set("phoenix.schema.dropMetaData", Boolean.TRUE.toString());
        conf.set("phoenix.mutate.batchSize", Integer.toString(3000));
        hbaseTestUtil.startMiniCluster();
        String zkQuorum = "localhost:" + hbaseTestUtil.getZkCluster().getClientPort();
        url = "jdbc:phoenix:" + zkQuorum;
        DriverManager.registerDriver((Driver)PhoenixDriver.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateCacheFrequencyWithAddAndDropTable() throws Exception {
        Properties longRunningProps = new Properties();
        longRunningProps.put("phoenix.jdbc.extra.arguments", "");
        longRunningProps.put("phoenix.schema.dropMetaData", Boolean.TRUE.toString());
        longRunningProps.put("hbase.client.registry.impl", "org.apache.hadoop.hbase.client.ZKConnectionRegistry");
        Connection conn1 = DriverManager.getConnection(url, longRunningProps);
        String url2 = url + ":LongRunningQueries";
        Connection conn2 = DriverManager.getConnection(url2, longRunningProps);
        conn1.setAutoCommit(true);
        conn2.setAutoCommit(true);
        String tableName = UpdateCacheAcrossDifferentClientsIT.generateUniqueName();
        String tableCreateQuery = "create table " + tableName + " (k VARCHAR PRIMARY KEY, v1 VARCHAR, v2 VARCHAR) UPDATE_CACHE_FREQUENCY=1000000000";
        String dropTableQuery = "DROP table " + tableName;
        try {
            conn1.createStatement().execute(tableCreateQuery);
            conn1.createStatement().execute("upsert into " + tableName + " values ('row1', 'value1', 'key1')");
            conn1.createStatement().execute("upsert into " + tableName + " values ('row2', 'value2', 'key2')");
            conn1.commit();
            ResultSet rs = conn1.createStatement().executeQuery("select * from " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertFalse((boolean)rs.next());
            rs = conn2.createStatement().executeQuery("select * from " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertFalse((boolean)rs.next());
            conn1.createStatement().execute(dropTableQuery);
            try {
                rs = conn1.createStatement().executeQuery("select * from " + tableName);
                Assert.fail((String)"Should throw TableNotFoundException after dropping table");
            }
            catch (org.apache.phoenix.schema.TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
            try {
                rs = conn2.createStatement().executeQuery("select * from " + tableName);
                rs.next();
                Assert.fail((String)"Should throw org.apache.hadoop.hbase.TableNotFoundException since the latest metadata wasn't fetched");
            }
            catch (SQLException ex) {
                boolean foundHBaseTableNotFound = ex instanceof org.apache.phoenix.schema.TableNotFoundException;
                if (!foundHBaseTableNotFound) {
                    for (Throwable throwable : Throwables.getCausalChain((Throwable)ex)) {
                        if (!TableNotFoundException.class.equals(throwable.getClass())) continue;
                        foundHBaseTableNotFound = true;
                        break;
                    }
                }
                Assert.assertTrue((String)"Should throw org.apache.hadoop.hbase.TableNotFoundException since the latest metadata wasn't fetched", (boolean)foundHBaseTableNotFound);
            }
        }
        finally {
            conn1.close();
            conn2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableSentWhenIndexStateChanges() throws Throwable {
        Properties longRunningProps = new Properties();
        longRunningProps.put("phoenix.jdbc.extra.arguments", "");
        longRunningProps.put("phoenix.schema.dropMetaData", Boolean.TRUE.toString());
        longRunningProps.put("hbase.client.registry.impl", "org.apache.hadoop.hbase.client.ZKConnectionRegistry");
        Connection conn1 = DriverManager.getConnection(url, longRunningProps);
        String url2 = url + ":LongRunningQueries";
        Connection conn2 = DriverManager.getConnection(url2, longRunningProps);
        conn1.setAutoCommit(true);
        conn2.setAutoCommit(true);
        try {
            String schemaName = UpdateCacheAcrossDifferentClientsIT.generateUniqueName();
            String tableName = UpdateCacheAcrossDifferentClientsIT.generateUniqueName();
            String indexName = UpdateCacheAcrossDifferentClientsIT.generateUniqueName();
            String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
            String fullIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
            conn1.createStatement().execute("CREATE TABLE " + fullTableName + "(k INTEGER PRIMARY KEY, v1 INTEGER, v2 INTEGER) COLUMN_ENCODED_BYTES = 0, STORE_NULLS=true");
            conn1.createStatement().execute("CREATE INDEX " + indexName + " ON " + fullTableName + " (v1) INCLUDE (v2)");
            Table metaTable = conn2.unwrap(PhoenixConnection.class).getQueryServices().getTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
            IndexUtil.updateIndexState((String)fullIndexName, (long)0L, (Table)metaTable, (PIndexState)PIndexState.DISABLE);
            conn2.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES(1,2,3)");
            conn2.commit();
            conn1.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES(4,5,6)");
            conn1.commit();
            PTableKey key = new PTableKey(null, fullTableName);
            PMetaData metaCache = conn1.unwrap(PhoenixConnection.class).getMetaDataCache();
            PTable table = metaCache.getTableRef(key).getTable();
            for (PTable index : table.getIndexes()) {
                Assert.assertEquals((Object)PIndexState.DISABLE, (Object)index.getIndexState());
            }
        }
        finally {
            conn1.close();
            conn2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateCacheFrequencyWithAddColumn() throws Exception {
        Properties longRunningProps = new Properties();
        longRunningProps.put("hbase.client.registry.impl", "org.apache.hadoop.hbase.client.ZKConnectionRegistry");
        Connection conn1 = DriverManager.getConnection(url, longRunningProps);
        Connection conn2 = DriverManager.getConnection(url, longRunningProps);
        conn1.setAutoCommit(true);
        conn2.setAutoCommit(true);
        String tableName = UpdateCacheAcrossDifferentClientsIT.generateUniqueName();
        String createTableQuery = "create table " + tableName + " (k UNSIGNED_DOUBLE not null primary key, v1 UNSIGNED_DOUBLE, v2 UNSIGNED_DOUBLE, v3 UNSIGNED_DOUBLE, v4 UNSIGNED_DOUBLE) UPDATE_CACHE_FREQUENCY=1000000000";
        try {
            conn1.createStatement().execute(createTableQuery);
            conn1.createStatement().execute("upsert into " + tableName + " values (1, 2, 3, 4, 5)");
            conn1.createStatement().execute("upsert into " + tableName + " values (6, 7, 8, 9, 10)");
            conn1.commit();
            ResultSet rs = conn1.createStatement().executeQuery("select k,v1,v2,v3 from " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.next());
            rs = conn2.createStatement().executeQuery("select k,v1,v2,v3 from " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.next());
            PreparedStatement alterStatement = conn1.prepareStatement("ALTER TABLE " + tableName + " ADD v9 UNSIGNED_DOUBLE");
            alterStatement.execute();
            rs = conn1.createStatement().executeQuery("select k,v1,v2,v3,v9 from " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.next());
            rs = conn2.createStatement().executeQuery("select k,v1,v2,v3,V9 from " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.next());
        }
        finally {
            conn1.close();
            conn2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateCacheFrequencyWithAddAndDropIndex() throws Exception {
        Properties longRunningProps = new Properties();
        longRunningProps.put("phoenix.jdbc.extra.arguments", "");
        longRunningProps.put("hbase.client.registry.impl", "org.apache.hadoop.hbase.client.ZKConnectionRegistry");
        Connection conn1 = DriverManager.getConnection(url, longRunningProps);
        String url2 = url + ":LongRunningQueries";
        Connection conn2 = DriverManager.getConnection(url2, longRunningProps);
        conn1.setAutoCommit(true);
        conn2.setAutoCommit(true);
        String tableName = UpdateCacheAcrossDifferentClientsIT.generateUniqueName();
        String indexName = "I_" + tableName;
        String tableCreateQuery = "create table " + tableName + " (k VARCHAR PRIMARY KEY, v1 VARCHAR, v2 VARCHAR) UPDATE_CACHE_FREQUENCY=1000000000";
        String value1SelQuery = "SELECT v2 FROM " + tableName + " WHERE v1 = 'value1'";
        String indexCreateQuery = "CREATE INDEX " + indexName + " ON " + tableName + " (v1) INCLUDE (v2)";
        String indexDropQuery = "DROP INDEX " + indexName + " ON " + tableName;
        try {
            conn1.createStatement().execute(tableCreateQuery);
            conn1.createStatement().execute("upsert into " + tableName + " values ('row1', 'value1', 'key1')");
            conn1.createStatement().execute("upsert into " + tableName + " values ('row2', 'value2', 'key2')");
            conn1.commit();
            ResultSet rs = conn1.createStatement().executeQuery("select k,v1,v2 from " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.next());
            rs = conn2.createStatement().executeQuery("select k,v1,v2 from " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.next());
            PreparedStatement createIndexStatement = conn1.prepareStatement(indexCreateQuery);
            createIndexStatement.execute();
            rs = conn1.createStatement().executeQuery(value1SelQuery);
            Assert.assertTrue((boolean)rs.next());
            rs = conn2.createStatement().executeQuery(value1SelQuery);
            Assert.assertTrue((boolean)rs.next());
            PreparedStatement dropIndexStatement = conn1.prepareStatement(indexDropQuery);
            dropIndexStatement.execute();
            rs = conn2.createStatement().executeQuery(value1SelQuery);
            Assert.assertTrue((boolean)rs.next());
            rs = conn1.createStatement().executeQuery(value1SelQuery);
            Assert.assertTrue((boolean)rs.next());
        }
        finally {
            conn1.close();
            conn2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateCacheFrequencyWithAddAndDropView() throws Exception {
        Properties longRunningProps = new Properties();
        longRunningProps.put("phoenix.jdbc.extra.arguments", "");
        longRunningProps.put("hbase.client.registry.impl", "org.apache.hadoop.hbase.client.ZKConnectionRegistry");
        Connection conn1 = DriverManager.getConnection(url, longRunningProps);
        String url2 = url + ":LongRunningQueries";
        Connection conn2 = DriverManager.getConnection(url2, longRunningProps);
        conn1.setAutoCommit(true);
        conn2.setAutoCommit(true);
        String tableName = UpdateCacheAcrossDifferentClientsIT.generateUniqueName();
        String viewName = "V_" + tableName;
        String createQry = "create table " + tableName + " (k VARCHAR PRIMARY KEY, v1 VARCHAR, v2 VARCHAR) UPDATE_CACHE_FREQUENCY=1000000000";
        String valueSelQuery = "SELECT * FROM " + tableName + " WHERE v1 = 'value1'";
        String viewCreateQuery = "CREATE VIEW " + viewName + " (v43 VARCHAR) AS SELECT * FROM " + tableName + " WHERE v1 = 'value1'";
        try {
            conn1.createStatement().execute(createQry);
            conn1.createStatement().execute("upsert into " + tableName + " values ('row1', 'value1', 'key1')");
            conn1.createStatement().execute("upsert into " + tableName + " values ('row2', 'value2', 'key2')");
            conn1.commit();
            ResultSet rs = conn1.createStatement().executeQuery("select k,v1,v2 from " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.next());
            rs = conn2.createStatement().executeQuery("select k,v1,v2 from " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.next());
            conn1.createStatement().execute(viewCreateQuery);
            rs = conn2.createStatement().executeQuery(valueSelQuery);
            Assert.assertTrue((boolean)rs.next());
            rs = conn1.createStatement().executeQuery(valueSelQuery);
            Assert.assertTrue((boolean)rs.next());
            conn1.createStatement().execute("DROP VIEW " + viewName);
            rs = conn2.createStatement().executeQuery(valueSelQuery);
            Assert.assertTrue((boolean)rs.next());
            rs = conn1.createStatement().executeQuery(valueSelQuery);
            Assert.assertTrue((boolean)rs.next());
        }
        finally {
            conn1.close();
            conn2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateCacheFrequencyWithCreateTableAndViewOnDiffConns() throws Exception {
        Properties longRunningProps = new Properties();
        longRunningProps.put("phoenix.jdbc.extra.arguments", "");
        longRunningProps.put("hbase.client.registry.impl", "org.apache.hadoop.hbase.client.ZKConnectionRegistry");
        Connection conn1 = DriverManager.getConnection(url, longRunningProps);
        String url2 = url + ":LongRunningQueries";
        Connection conn2 = DriverManager.getConnection(url2, longRunningProps);
        conn1.setAutoCommit(true);
        conn2.setAutoCommit(true);
        String tableName = UpdateCacheAcrossDifferentClientsIT.generateUniqueName();
        String viewName = "V1_" + tableName;
        String valueSelQuery = "SELECT * FROM " + tableName + " WHERE v1 = 'value1'";
        try {
            String createQry = "create table " + tableName + " (k VARCHAR PRIMARY KEY, v1 VARCHAR, v2 VARCHAR) UPDATE_CACHE_FREQUENCY=1000000000";
            conn1.createStatement().execute(createQry);
            conn1.createStatement().execute("upsert into " + tableName + " values ('row1', 'value1', 'key1')");
            conn1.createStatement().execute("upsert into " + tableName + " values ('row2', 'value2', 'key2')");
            conn1.commit();
            ResultSet rs = conn1.createStatement().executeQuery("select k,v1,v2 from " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.next());
            String viewCreateQuery = "CREATE VIEW " + viewName + " (v43 VARCHAR) AS SELECT * FROM " + tableName + " WHERE v1 = 'value1'";
            conn2.createStatement().execute(viewCreateQuery);
            rs = conn2.createStatement().executeQuery(valueSelQuery);
            Assert.assertTrue((boolean)rs.next());
            rs = conn1.createStatement().executeQuery(valueSelQuery);
            Assert.assertTrue((boolean)rs.next());
        }
        finally {
            conn1.close();
            conn2.close();
        }
    }
}

