/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public abstract class UnnestArrayIT
extends ParallelStatsDisabledIT {
    private String tableName;

    @Before
    public void setup() {
        this.tableName = UnnestArrayIT.generateUniqueName();
    }

    @Test
    public void testUnnestWithIntArray1() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(UnnestArrayIT.getUrl(), props);
        String ddl = "CREATE TABLE " + this.tableName + " (p INTEGER PRIMARY KEY, k INTEGER[])";
        conn.createStatement().execute(ddl);
        conn.close();
        conn = DriverManager.getConnection(UnnestArrayIT.getUrl(), props);
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + this.tableName + " VALUES (1, ARRAY[2, 3])");
        stmt.execute();
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(UnnestArrayIT.getUrl(), props);
        stmt = conn.prepareStatement("SELECT t.k FROM UNNEST((SELECT k FROM " + this.tableName + ")) AS t(k)");
        ResultSet rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)rs.getInt(1), (long)2L);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)rs.getInt(1), (long)3L);
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testUnnestWithIntArray2() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(UnnestArrayIT.getUrl(), props);
        String ddl = "CREATE TABLE " + this.tableName + " (p INTEGER PRIMARY KEY, k INTEGER[])";
        conn.createStatement().execute(ddl);
        conn.close();
        conn = DriverManager.getConnection(UnnestArrayIT.getUrl(), props);
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + this.tableName + " VALUES (1, ARRAY[2, 3])");
        stmt.execute();
        stmt = conn.prepareStatement("UPSERT INTO " + this.tableName + " VALUES (2, ARRAY[4, 5])");
        stmt.execute();
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(UnnestArrayIT.getUrl(), props);
        stmt = conn.prepareStatement("SELECT t.k FROM UNNEST((SELECT k FROM " + this.tableName + ")) AS t(k)");
        ResultSet rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)rs.getInt(1), (long)2L);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)rs.getInt(1), (long)3L);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)rs.getInt(1), (long)4L);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)rs.getInt(1), (long)5L);
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testUnnestWithVarcharArray1() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(UnnestArrayIT.getUrl(), props);
        String ddl = "CREATE TABLE " + this.tableName + " (p INTEGER PRIMARY KEY, k VARCHAR[])";
        conn.createStatement().execute(ddl);
        conn.close();
        conn = DriverManager.getConnection(UnnestArrayIT.getUrl(), props);
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + this.tableName + " VALUES (1, ARRAY['a', 'b', 'c'])");
        stmt.execute();
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(UnnestArrayIT.getUrl(), props);
        stmt = conn.prepareStatement("SELECT t.k FROM UNNEST((SELECT k FROM " + this.tableName + ")) AS t(k)");
        ResultSet rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)rs.getString(1), (Object)"a");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)rs.getString(1), (Object)"b");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)rs.getString(1), (Object)"c");
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testUnnestWithDoubleArray1() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(UnnestArrayIT.getUrl(), props);
        String ddl = "CREATE TABLE " + this.tableName + " (p INTEGER PRIMARY KEY, k DOUBLE[])";
        conn.createStatement().execute(ddl);
        conn.close();
        conn = DriverManager.getConnection(UnnestArrayIT.getUrl(), props);
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + this.tableName + " VALUES (1, ARRAY[2.3, 3.4, 4.5])");
        stmt.execute();
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(UnnestArrayIT.getUrl(), props);
        stmt = conn.prepareStatement("SELECT t.k FROM UNNEST((SELECT k FROM " + this.tableName + ")) AS t(k)");
        ResultSet rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((double)rs.getDouble(1), (double)2.3);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((double)rs.getDouble(1), (double)3.4);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((double)rs.getDouble(1), (double)4.5);
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testUnnestWithBooleanArray1() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(UnnestArrayIT.getUrl(), props);
        String ddl = "CREATE TABLE " + this.tableName + " (p INTEGER PRIMARY KEY, k BOOLEAN[])";
        conn.createStatement().execute(ddl);
        conn.close();
        conn = DriverManager.getConnection(UnnestArrayIT.getUrl(), props);
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + this.tableName + " VALUES (1, ARRAY[true, true, false])");
        stmt.execute();
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(UnnestArrayIT.getUrl(), props);
        stmt = conn.prepareStatement("SELECT t.k FROM UNNEST((SELECT k FROM " + this.tableName + ")) AS t(k)");
        ResultSet rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)rs.getBoolean(1), (Object)true);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)rs.getBoolean(1), (Object)true);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)rs.getBoolean(1), (Object)false);
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testUnnestWithOrdinality() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(UnnestArrayIT.getUrl(), props);
        PreparedStatement stmt = conn.prepareStatement("SELECT ar1, ordinality FROM UNNEST(ARRAY['a','b','c']) WITH ORDINALITY AS t1(ar1, ordinality)");
        ResultSet rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)rs.getString(1), (Object)"a");
        Assert.assertEquals((long)rs.getInt(2), (long)1L);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)rs.getString(1), (Object)"b");
        Assert.assertEquals((long)rs.getInt(2), (long)2L);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)rs.getString(1), (Object)"c");
        Assert.assertEquals((long)rs.getInt(2), (long)3L);
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testUnnestWithJoins1() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(UnnestArrayIT.getUrl(), props);
        PreparedStatement stmt = conn.prepareStatement("SELECT ar1, ar2 FROM UNNEST(ARRAY[2,3,4]) WITH ORDINALITY AS t1(ar1, index) FULL OUTER JOIN UNNEST(ARRAY[5,6]) with ORDINALITY AS t2(ar2, index) ON t1.index=t2.index");
        ResultSet rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)rs.getInt(1), (long)2L);
        Assert.assertEquals((long)rs.getInt(2), (long)5L);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)rs.getInt(1), (long)3L);
        Assert.assertEquals((long)rs.getInt(2), (long)6L);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)rs.getInt(1), (long)4L);
        Assert.assertEquals((long)rs.getInt(2), (long)0L);
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testUnnestWithJoins2() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(UnnestArrayIT.getUrl(), props);
        PreparedStatement stmt = conn.prepareStatement("SELECT ar1, ar2 FROM UNNEST(ARRAY[2,3,4]) WITH ORDINALITY AS t1(ar1, index) INNER JOIN UNNEST(ARRAY[5,6]) with ORDINALITY AS t2(ar2, index) ON t1.index=t2.index");
        ResultSet rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)rs.getInt(1), (long)2L);
        Assert.assertEquals((long)rs.getInt(2), (long)5L);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)rs.getInt(1), (long)3L);
        Assert.assertEquals((long)rs.getInt(2), (long)6L);
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testUnnestWithJoins3() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(UnnestArrayIT.getUrl(), props);
        String ddl = "CREATE TABLE " + this.tableName + " (p INTEGER PRIMARY KEY, k VARCHAR[])";
        conn.createStatement().execute(ddl);
        conn.close();
        conn = DriverManager.getConnection(UnnestArrayIT.getUrl(), props);
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + this.tableName + " VALUES (1, ARRAY['a', 'b', 'c'])");
        stmt.execute();
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(UnnestArrayIT.getUrl(), props);
        stmt = conn.prepareStatement("SELECT ar1, ar2 FROM UNNEST(ARRAY[2,3,4]) WITH ORDINALITY AS t1(ar1, index) FULL OUTER JOIN UNNEST((SELECT k FROM " + this.tableName + ")) with ORDINALITY AS t2(ar2, index) ON t1.index=t2.index");
        ResultSet rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)rs.getInt(1), (long)2L);
        Assert.assertEquals((Object)rs.getString(2), (Object)"a");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)rs.getInt(1), (long)3L);
        Assert.assertEquals((Object)rs.getString(2), (Object)"b");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)rs.getInt(1), (long)4L);
        Assert.assertEquals((Object)rs.getString(2), (Object)"c");
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testUnnestWithJoins4() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(UnnestArrayIT.getUrl(), props);
        PreparedStatement stmt = conn.prepareStatement("SELECT ar1, ar2 FROM UNNEST(ARRAY[2,3,4]) WITH ORDINALITY AS t1(ar1, index) FULL OUTER JOIN UNNEST(ARRAY['a','b']) with ORDINALITY AS t2(ar2, index) ON t1.index=t2.index");
        ResultSet rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)rs.getInt(1), (long)2L);
        Assert.assertEquals((Object)rs.getString(2), (Object)"a");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)rs.getInt(1), (long)3L);
        Assert.assertEquals((Object)rs.getString(2), (Object)"b");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)rs.getInt(1), (long)4L);
        Assert.assertEquals((Object)rs.getString(2), null);
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testUnnestWithJoins5() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(UnnestArrayIT.getUrl(), props);
        PreparedStatement stmt = conn.prepareStatement("SELECT ar1, ar2 FROM UNNEST(ARRAY[1,2]) AS t1(ar1), UNNEST(ARRAY[2,3]) AS t2(ar2);");
        ResultSet rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)rs.getInt(1), (long)1L);
        Assert.assertEquals((long)rs.getInt(2), (long)2L);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)rs.getInt(1), (long)1L);
        Assert.assertEquals((long)rs.getInt(2), (long)3L);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)rs.getInt(1), (long)2L);
        Assert.assertEquals((long)rs.getInt(2), (long)2L);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)rs.getInt(1), (long)2L);
        Assert.assertEquals((long)rs.getInt(2), (long)3L);
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testUnnestInWhere() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(UnnestArrayIT.getUrl(), props);
        String ddl = "CREATE TABLE " + this.tableName + " (p INTEGER PRIMARY KEY)";
        conn.createStatement().execute(ddl);
        conn.close();
        conn = DriverManager.getConnection(UnnestArrayIT.getUrl(), props);
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + this.tableName + " VALUES (2)");
        stmt.execute();
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(UnnestArrayIT.getUrl(), props);
        stmt = conn.prepareStatement("SELECT * FROM " + this.tableName + " WHERE p IN(SELECT t.a FROM UNNEST(ARRAY[2,3]) AS t(a))");
        ResultSet rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)rs.getInt(1), (long)2L);
        Assert.assertFalse((boolean)rs.next());
    }
}

