/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionStatesCount;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.index.GlobalIndexCheckerIT;
import org.apache.phoenix.iterate.ScanningResultPostDummyResultCaller;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
public class UncoveredIndexWithRegionMovesIT
extends ParallelStatsDisabledIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(UncoveredIndexWithRegionMovesIT.class);
    private static boolean hasTestStarted = false;
    private static int countOfDummyResults = 0;
    private static final List<String> TABLE_NAMES = Collections.synchronizedList(new ArrayList());

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)2);
        props.put("phoenix.server.page.size.ms", Long.toString(0L));
        props.put("phoenix.query.request.metrics.enabled", String.valueOf(true));
        props.put("phoenix.tests.minicluster.numregionservers", String.valueOf(2));
        props.put("hbase.client.scanner.max.result.size", String.valueOf(1));
        props.put("phoenix.scanning.result.post.dummy.process", TestScanningResultPostDummyResultCaller.class.getName());
        UncoveredIndexWithRegionMovesIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @After
    public void tearDown() throws Exception {
        TABLE_NAMES.clear();
        hasTestStarted = false;
        countOfDummyResults = 0;
    }

    private void assertServerPagingMetric(String tableName, ResultSet rs, boolean isPaged) throws SQLException {
        Map metrics = PhoenixRuntime.getRequestReadMetricInfo((ResultSet)rs);
        for (Map.Entry entry : metrics.entrySet()) {
            Assert.assertEquals((String)String.format("Got %s", entry.getKey()), (Object)tableName, entry.getKey());
            Map metricValues = (Map)entry.getValue();
            Long pagedRowsCntr = (Long)metricValues.get(MetricType.PAGED_ROWS_COUNTER);
            Assert.assertNotNull((Object)pagedRowsCntr);
            if (isPaged) {
                Assert.assertTrue((String)String.format("Got %d", pagedRowsCntr), (pagedRowsCntr > 0L ? 1 : 0) != 0);
                continue;
            }
            Assert.assertEquals((String)String.format("Got %d", pagedRowsCntr), (long)0L, (long)pagedRowsCntr);
        }
        Assert.assertTrue((GlobalClientMetrics.GLOBAL_PAGED_ROWS_COUNTER.getMetric().getValue() > 0L ? 1 : 0) != 0);
    }

    private static void moveRegionsOfTable(String tableName) throws IOException {
        try (AsyncConnection asyncConnection = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)UncoveredIndexWithRegionMovesIT.getUtility().getConfiguration()).get();){
            AsyncAdmin admin = asyncConnection.getAdmin();
            ArrayList servers = new ArrayList((Collection)admin.getRegionServers().get());
            ServerName server1 = (ServerName)servers.get(0);
            ServerName server2 = (ServerName)servers.get(1);
            List regionsOnServer1 = (List)admin.getRegions(server1).get();
            List regionsOnServer2 = (List)admin.getRegions(server2).get();
            regionsOnServer1.forEach(regionInfo -> {
                if (regionInfo.getTable().equals((Object)TableName.valueOf((String)tableName))) {
                    try {
                        for (int i = 0; i < 2; ++i) {
                            RegionStatesCount regionStatesCount = (RegionStatesCount)((ClusterMetrics)admin.getClusterMetrics().get()).getTableRegionStatesCount().get(TableName.valueOf((String)tableName));
                            if (regionStatesCount.getRegionsInTransition() == 0 && regionStatesCount.getOpenRegions() == regionStatesCount.getTotalRegions()) {
                                LOGGER.info("Moving region {} to {}", (Object)regionInfo.getRegionNameAsString(), (Object)server2);
                                admin.move(regionInfo.getEncodedNameAsBytes(), server2).get(3L, TimeUnit.SECONDS);
                                break;
                            }
                            LOGGER.info("Table {} has some region(s) in RIT or not online", (Object)tableName);
                        }
                    }
                    catch (InterruptedException | ExecutionException | TimeoutException e) {
                        LOGGER.error("Something went wrong", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            });
            regionsOnServer2.forEach(regionInfo -> {
                if (regionInfo.getTable().equals((Object)TableName.valueOf((String)tableName))) {
                    try {
                        for (int i = 0; i < 2; ++i) {
                            RegionStatesCount regionStatesCount = (RegionStatesCount)((ClusterMetrics)admin.getClusterMetrics().get()).getTableRegionStatesCount().get(TableName.valueOf((String)tableName));
                            if (regionStatesCount.getRegionsInTransition() == 0 && regionStatesCount.getOpenRegions() == regionStatesCount.getTotalRegions()) {
                                admin.move(regionInfo.getEncodedNameAsBytes(), server1).get(3L, TimeUnit.SECONDS);
                                LOGGER.info("Moving region {} to {}", (Object)regionInfo.getRegionNameAsString(), (Object)server1);
                                break;
                            }
                            LOGGER.info("Table {} has some region(s) in RIT or not online", (Object)tableName);
                        }
                    }
                    catch (InterruptedException | ExecutionException | TimeoutException e) {
                        LOGGER.error("Something went wrong", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Something went wrong..", (Throwable)e);
        }
    }

    @Test
    public void testUncoveredQueryWithGroupBy() throws Exception {
        hasTestStarted = true;
        String dataTableName = UncoveredIndexWithRegionMovesIT.generateUniqueName();
        this.populateTable(dataTableName);
        try (Connection conn = DriverManager.getConnection(UncoveredIndexWithRegionMovesIT.getUrl());){
            String indexTableName = UncoveredIndexWithRegionMovesIT.generateUniqueName();
            conn.createStatement().execute("CREATE UNCOVERED INDEX " + indexTableName + " on " + dataTableName + " (val1) ");
            TABLE_NAMES.add(dataTableName);
            TABLE_NAMES.add(indexTableName);
            int limit = 10;
            String selectSql = "SELECT  val2, val3 from " + dataTableName + " WHERE val1 = 'bc' AND (val2 = 'bcd' OR val3 ='bcde') LIMIT " + limit;
            GlobalIndexCheckerIT.assertExplainPlanWithLimit(conn, selectSql, dataTableName, indexTableName, limit);
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            UncoveredIndexWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            UncoveredIndexWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bcd", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bcde", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            this.assertServerPagingMetric(indexTableName, rs, true);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('c', 'ab','cde', 'cdef')");
            conn.commit();
            selectSql = "SELECT count(val3) from " + dataTableName + " where val1 > '0' GROUP BY val1";
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(selectSql);
            TestUtil.dumpTable(conn, TableName.valueOf((String)dataTableName));
            TestUtil.dumpTable(conn, TableName.valueOf((String)indexTableName));
            UncoveredIndexWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            UncoveredIndexWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            UncoveredIndexWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            UncoveredIndexWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertFalse((boolean)rs.next());
            selectSql = "SELECT count(val3) from " + dataTableName + " where val1 > '0'";
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            selectSql = "SELECT val3 from " + dataTableName + " where val1 > '0' ORDER BY val1";
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(selectSql);
            UncoveredIndexWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            UncoveredIndexWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abcd", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"cdef", (Object)rs.getString(1));
            UncoveredIndexWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            UncoveredIndexWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bcde", (Object)rs.getString(1));
            UncoveredIndexWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            UncoveredIndexWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testUncoveredQuery() throws Exception {
        this.testUncoveredUtil(false);
    }

    @Test
    public void testUncoveredQueryWithLimit() throws Exception {
        this.testUncoveredUtil(true);
    }

    private void testUncoveredUtil(boolean limit) throws Exception {
        hasTestStarted = true;
        String dataTableName = UncoveredIndexWithRegionMovesIT.generateUniqueName();
        this.populateTable(dataTableName);
        try (Connection conn = DriverManager.getConnection(UncoveredIndexWithRegionMovesIT.getUrl());){
            String indexTableName = UncoveredIndexWithRegionMovesIT.generateUniqueName();
            conn.createStatement().execute("CREATE UNCOVERED INDEX " + indexTableName + " on " + dataTableName + " (val1) ");
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('c', 'cd','cde', 'cdef')");
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('d', 'de','de1', 'de11')");
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('e', 'ef','ef1', 'ef11')");
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('f', 'fg','fg1', 'fg11')");
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('g', 'gh','gh1', 'gh11')");
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('h', 'hi','hi1', 'hi11')");
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('i', 'ij','ij1', 'ij11')");
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('j', 'jk','jk1', 'jk11')");
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('k', 'kl','kl1', 'kl11')");
            conn.commit();
            TABLE_NAMES.add(dataTableName);
            TABLE_NAMES.add(indexTableName);
            String selectSql = "SELECT  val2, val3 from " + dataTableName + " WHERE val1 IS NOT NULL" + (limit ? " LIMIT 15" : "");
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            UncoveredIndexWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            UncoveredIndexWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"abcd", (Object)rs.getString(2));
            UncoveredIndexWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            UncoveredIndexWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bcd", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bcde", (Object)rs.getString(2));
            UncoveredIndexWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            UncoveredIndexWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"cde", (Object)rs.getString(1));
            Assert.assertEquals((Object)"cdef", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"de1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"de11", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"ef1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ef11", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"fg1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"fg11", (Object)rs.getString(2));
            UncoveredIndexWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            UncoveredIndexWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"gh1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"gh11", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"hi1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"hi11", (Object)rs.getString(2));
            UncoveredIndexWithRegionMovesIT.moveRegionsOfTable(dataTableName);
            UncoveredIndexWithRegionMovesIT.moveRegionsOfTable(indexTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"ij1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ij11", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"jk1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"jk11", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"kl1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"kl11", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            this.assertServerPagingMetric(indexTableName, rs, true);
        }
    }

    private void populateTable(String tableName) throws Exception {
        Connection conn = DriverManager.getConnection(UncoveredIndexWithRegionMovesIT.getUrl());
        conn.createStatement().execute("create table " + tableName + " (id varchar(10) not null primary key, val1 varchar(10), val2 varchar(10), val3 varchar(10))");
        conn.createStatement().execute("upsert into " + tableName + " values ('a', 'ab', 'abc', 'abcd')");
        conn.commit();
        conn.createStatement().execute("upsert into " + tableName + " values ('b', 'bc', 'bcd', 'bcde')");
        conn.commit();
        conn.close();
    }

    private static class TestScanningResultPostDummyResultCaller
    extends ScanningResultPostDummyResultCaller {
        private TestScanningResultPostDummyResultCaller() {
        }

        public void postDummyProcess() {
            if (hasTestStarted && countOfDummyResults++ % 3 == 0 && (countOfDummyResults < 17 || countOfDummyResults > 28 && countOfDummyResults < 40)) {
                LOGGER.info("Moving regions of tables {}. current count of dummy results: {}", TABLE_NAMES, (Object)countOfDummyResults);
                TABLE_NAMES.forEach(table -> {
                    try {
                        UncoveredIndexWithRegionMovesIT.moveRegionsOfTable(table);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
    }
}

