/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class TopNIT
extends ParallelStatsDisabledIT {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiOrderByExpr() throws Exception {
        String tenantId = TopNIT.getOrganizationId();
        String tableName = TopNIT.initATableValues(null, tenantId, TopNIT.getDefaultSplits(tenantId), null, null, TopNIT.getUrl(), null);
        String query = "SELECT entity_id FROM " + tableName + " ORDER BY b_string, entity_id LIMIT 5";
        try (Connection conn = DriverManager.getConnection(TopNIT.getUrl());){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"00A123122312312");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"00A423122312312");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"00B723122312312");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"00A223122312312");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"00B523122312312");
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDescMultiOrderByExpr() throws Exception {
        String tenantId = TopNIT.getOrganizationId();
        String tableName = TopNIT.initATableValues(null, tenantId, TopNIT.getDefaultSplits(tenantId), null, null, TopNIT.getUrl(), null);
        String query = "SELECT entity_id FROM  " + tableName + "  ORDER BY b_string || entity_id desc LIMIT 5";
        try (Connection conn = DriverManager.getConnection(TopNIT.getUrl());){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"00C923122312312");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"00B623122312312");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"00A323122312312");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"00B823122312312");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"00B523122312312");
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testTopNDeleteAutoCommitOn() throws Exception {
        this.testTopNDelete(true);
    }

    @Test
    public void testTopNDeleteAutoCommitOff() throws Exception {
        this.testTopNDelete(false);
    }

    private void testTopNDelete(boolean autoCommit) throws Exception {
        String tenantId = TopNIT.getOrganizationId();
        String tableName = TopNIT.initATableValues(null, tenantId, TopNIT.getDefaultSplits(tenantId), null, null, TopNIT.getUrl(), null);
        String query = "DELETE FROM  " + tableName + "  ORDER BY b_string, entity_id LIMIT 5";
        try (Connection conn = DriverManager.getConnection(TopNIT.getUrl());){
            conn.setAutoCommit(autoCommit);
            PreparedStatement statement = conn.prepareStatement(query);
            statement.execute();
            Assert.assertEquals((long)5L, (long)statement.getUpdateCount());
            if (!autoCommit) {
                conn.commit();
            }
            query = "SELECT entity_id FROM  " + tableName + "  ORDER BY b_string, x_decimal nulls last, 8-a_integer LIMIT 5";
            statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B823122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00C923122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B623122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A323122312312", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }
}

