/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.schema.TypeMismatchException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class ToDateFunctionIT
extends ParallelStatsDisabledIT {
    private static final long ONE_HOUR_IN_MILLIS = 3600000L;
    private Connection conn;

    @Before
    public void setUp() throws SQLException {
        this.conn = DriverManager.getConnection(ToDateFunctionIT.getUrl());
    }

    @After
    public void tearDown() throws SQLException {
        this.conn.close();
    }

    private static Date callToDateFunction(Connection conn, String invocation) throws SQLException {
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(String.format("SELECT %s FROM \"SYSTEM\".CATALOG LIMIT 1", invocation));
        Assert.assertTrue((boolean)rs.next());
        Date returnValue = (Date)rs.getObject(1);
        rs.close();
        stmt.close();
        return returnValue;
    }

    private java.sql.Date callToDateFunction(String invocation) throws SQLException {
        return (java.sql.Date)ToDateFunctionIT.callToDateFunction(this.conn, invocation);
    }

    private Time callToTimeFunction(String invocation) throws SQLException {
        return (Time)ToDateFunctionIT.callToDateFunction(this.conn, invocation);
    }

    private Timestamp callToTimestampFunction(String invocation) throws SQLException {
        return (Timestamp)ToDateFunctionIT.callToDateFunction(this.conn, invocation);
    }

    @Test
    public void testToDate_Default() throws SQLException {
        Assert.assertEquals((long)0L, (long)this.callToDateFunction("TO_DATE('1970-01-01 00:00:00')").getTime());
        Assert.assertEquals((long)0L, (long)this.callToDateFunction("TO_DATE('1970-01-01 00:00:00.000')").getTime());
        Assert.assertEquals((long)0L, (long)this.callToDateFunction("TO_DATE('1970-01-01')").getTime());
        Assert.assertEquals((long)0L, (long)this.callToDateFunction("TO_DATE('1970/01/01','yyyy/MM/dd')").getTime());
        try {
            this.callToDateFunction("TO_DATE('2015-01-27T16:17:57+00:00')");
            this.callToDateFunction("TO_DATE('2015-01-27T16:17:57Z')");
            this.callToDateFunction("TO_DATE('2015-W05')");
            this.callToDateFunction("TO_DATE('2015-W05-2')");
        }
        catch (Exception ex) {
            Assert.fail((String)("TO_DATE Parse ISO8601 Time Failed due to:" + ex));
        }
    }

    @Test
    public void testToTime_Default() throws SQLException {
        Assert.assertEquals((long)0L, (long)this.callToTimeFunction("TO_TIME('1970-01-01 00:00:00')").getTime());
        Assert.assertEquals((long)0L, (long)this.callToTimeFunction("TO_TIME('1970-01-01 00:00:00.000')").getTime());
        Assert.assertEquals((long)0L, (long)this.callToTimeFunction("TO_TIME('1970-01-01')").getTime());
        Assert.assertEquals((long)0L, (long)this.callToTimeFunction("TO_TIME('1970/01/01','yyyy/MM/dd')").getTime());
        try {
            this.callToTimeFunction("TO_TIME('2015-01-27T16:17:57+00:00')");
            this.callToTimeFunction("TO_TIME('2015-01-27T16:17:57Z')");
            this.callToTimeFunction("TO_TIME('2015-W05')");
            this.callToTimeFunction("TO_TIME('2015-W05-2')");
        }
        catch (Exception ex) {
            Assert.fail((String)("TO_TIME Parse ISO8601 Time Failed due to:" + ex));
        }
    }

    @Test
    public void testToTimestamp_Default() throws SQLException {
        Assert.assertEquals((long)0L, (long)this.callToTimestampFunction("TO_TIMESTAMP('1970-01-01 00:00:00')").getTime());
        Assert.assertEquals((long)0L, (long)this.callToTimestampFunction("TO_TIMESTAMP('1970-01-01 00:00:00.000')").getTime());
        Assert.assertEquals((long)0L, (long)this.callToTimestampFunction("TO_TIMESTAMP('1970-01-01')").getTime());
        Assert.assertEquals((long)0L, (long)this.callToTimestampFunction("TO_TIMESTAMP('1970/01/01','yyyy/MM/dd')").getTime());
        try {
            this.callToTimestampFunction("TO_TIMESTAMP('2015-01-27T16:17:57+00:00')");
            this.callToTimestampFunction("TO_TIMESTAMP('2015-01-27T16:17:57Z')");
            this.callToTimestampFunction("TO_TIMESTAMP('2015-W05')");
            this.callToTimestampFunction("TO_TIMESTAMP('2015-W05-2')");
        }
        catch (Exception ex) {
            Assert.fail((String)("TO_TIMESTAMP Parse ISO8601 Time Failed due to:" + ex));
        }
    }

    @Test
    public void testToDate_CustomDateFormat() throws SQLException {
        Assert.assertEquals((long)0L, (long)this.callToDateFunction("TO_DATE('1970-01-01', 'yyyy-MM-dd')").getTime());
    }

    @Test
    public void testToDate_CustomTimeZone() throws SQLException {
        Assert.assertEquals((long)-3600000L, (long)this.callToDateFunction("TO_DATE('1970-01-01', 'yyyy-MM-dd', 'GMT+1')").getTime());
    }

    @Test
    public void testToDate_LocalTimeZone() throws SQLException {
        Assert.assertEquals((Object)java.sql.Date.valueOf("1970-01-01"), (Object)this.callToDateFunction("TO_DATE('1970-01-01', 'yyyy-MM-dd', 'local')"));
    }

    @Test
    public void testToDate_CustomTimeZoneViaQueryServices() throws SQLException {
        Properties props = new Properties();
        props.setProperty("phoenix.query.dateFormatTimeZone", "GMT+1");
        Connection customTimeZoneConn = DriverManager.getConnection(ToDateFunctionIT.getUrl(), props);
        Assert.assertEquals((long)-3600000L, (long)ToDateFunctionIT.callToDateFunction(customTimeZoneConn, "TO_DATE('1970-01-01 00:00:00.000')").getTime());
    }

    @Test
    public void testToDate_CustomTimeZoneViaQueryServicesAndCustomFormat() throws SQLException {
        Properties props = new Properties();
        props.setProperty("phoenix.query.dateFormatTimeZone", "GMT+1");
        Connection customTimeZoneConn = DriverManager.getConnection(ToDateFunctionIT.getUrl(), props);
        Assert.assertEquals((long)-3600000L, (long)ToDateFunctionIT.callToDateFunction(customTimeZoneConn, "TO_DATE('1970-01-01', 'yyyy-MM-dd')").getTime());
    }

    @Test
    public void testTimestampCast() throws SQLException {
        Properties props = new Properties();
        props.setProperty("phoenix.query.dateFormatTimeZone", "GMT+1");
        Connection customTimeZoneConn = DriverManager.getConnection(ToDateFunctionIT.getUrl(), props);
        Assert.assertEquals((long)1426188807198L, (long)ToDateFunctionIT.callToDateFunction(customTimeZoneConn, "CAST(1426188807198 AS TIMESTAMP)").getTime());
        try {
            ToDateFunctionIT.callToDateFunction(customTimeZoneConn, "CAST(22005 AS TIMESTAMP)");
            Assert.fail();
        }
        catch (TypeMismatchException typeMismatchException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnsignedLongToTimestampCast() throws SQLException {
        Properties props = new Properties();
        props.setProperty("phoenix.query.dateFormatTimeZone", "GMT+1");
        conn.setAutoCommit(false);
        try (Connection conn = DriverManager.getConnection(ToDateFunctionIT.getUrl(), props);){
            conn.prepareStatement("create table TT(a unsigned_int not null, b unsigned_int not null, ts unsigned_long not null constraint PK primary key (a, b, ts))").execute();
            conn.commit();
            conn.prepareStatement("upsert into TT values (0, 22120, 1426188807198)").execute();
            conn.commit();
            ResultSet rs = conn.prepareStatement("select a, b, ts, CAST(ts AS TIMESTAMP) from TT").executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)new java.sql.Date(1426188807198L), (Object)rs.getObject(4));
            rs.close();
            try {
                rs = conn.prepareStatement("select a, b, ts, CAST(b AS TIMESTAMP) from TT").executeQuery();
                Assert.fail();
            }
            catch (TypeMismatchException typeMismatchException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testVarcharToDateComparision() throws SQLException {
        String dateString1 = "1900-01-02";
        String dateString2 = "2100-01-01";
        this.conn.prepareStatement("CREATE TABLE SB(DATE_STRING VARCHAR(50) NOT NULL CONSTRAINT PK PRIMARY KEY (DATE_STRING))").execute();
        this.conn.commit();
        String upsertSql = String.format("upsert into SB values (?)", new Object[0]);
        PreparedStatement stmt = this.conn.prepareStatement(upsertSql);
        stmt.setString(1, "1900-01-02");
        stmt.execute();
        stmt.setString(1, "2100-01-01");
        stmt.execute();
        this.conn.commit();
        String selectSql = "SELECT DATE_STRING FROM SB WHERE TO_DATE(DATE_STRING) > TO_DATE('2001-01-01')";
        ResultSet rs = this.conn.prepareStatement(selectSql).executeQuery();
        Assert.assertTrue((boolean)rs.next());
        String obtainedString = rs.getString("DATE_STRING");
        Assert.assertEquals((String)"Did not get value that was inserted!!", (Object)"2100-01-01", (Object)obtainedString);
        Assert.assertFalse((String)"No more rows expected!!", (boolean)rs.next());
    }

    @Test
    public void testToDateWithCloneMethod() throws SQLException {
        Connection conn = DriverManager.getConnection(ToDateFunctionIT.getUrl());
        String tableName = ToDateFunctionIT.generateUniqueName();
        String ddl = "create table " + tableName + " (k varchar primary key, v varchar[])";
        conn.createStatement().execute(ddl);
        String dateStr = "2100-01-01";
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('x',ARRAY['" + dateStr + "'])");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("select to_date(v[1], 'yyyy-MM-dd', 'local') from " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Unexpected value for date ", (Object)java.sql.Date.valueOf(dateStr), (Object)rs.getDate(1));
        Assert.assertFalse((boolean)rs.next());
    }
}

