/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class ToCharFunctionIT
extends ParallelStatsDisabledIT {
    private String TO_CHAR_TABLE_NAME;
    private Date row1Date;
    private Time row1Time;
    private Timestamp row1Timestamp;
    private Integer row1Integer;
    private BigDecimal row1Decimal;
    private Date row2Date;
    private Time row2Time;
    private Timestamp row2Timestamp;
    private Integer row2Integer;
    private BigDecimal row2Decimal;

    @Before
    @SuppressWarnings(value={"DMI_BIGDECIMAL_CONSTRUCTED_FROM_DOUBLE"}, justification="Test code.")
    public void initTable() throws Exception {
        this.TO_CHAR_TABLE_NAME = ToCharFunctionIT.generateUniqueName();
        String ddl = "create table " + this.TO_CHAR_TABLE_NAME + "(pk integer not null, \ncol_date date, \ncol_time date, \ncol_timestamp timestamp, \ncol_integer integer, \ncol_decimal decimal\nCONSTRAINT my_pk PRIMARY KEY (pk))";
        ToCharFunctionIT.createTestTable(ToCharFunctionIT.getUrl(), ddl);
        Connection conn = DriverManager.getConnection(ToCharFunctionIT.getUrl());
        conn.setAutoCommit(false);
        PreparedStatement stmt = conn.prepareStatement("upsert into " + this.TO_CHAR_TABLE_NAME + "    (pk,     col_date,    col_time,    col_timestamp,    col_integer,    col_decimal)VALUES (?, ?, ?, ?, ?, ?)");
        this.row1Date = new Date(System.currentTimeMillis() - 10000L);
        this.row1Time = new Time(System.currentTimeMillis() - 1000L);
        this.row1Timestamp = new Timestamp(System.currentTimeMillis() + 10000L);
        this.row1Integer = 666;
        this.row1Decimal = new BigDecimal(33.333);
        stmt.setInt(1, 1);
        stmt.setDate(2, this.row1Date);
        stmt.setTime(3, this.row1Time);
        stmt.setTimestamp(4, this.row1Timestamp);
        stmt.setInt(5, this.row1Integer);
        stmt.setBigDecimal(6, this.row1Decimal);
        stmt.execute();
        this.row2Date = new Date(System.currentTimeMillis() - 1234567L);
        this.row2Time = new Time(System.currentTimeMillis() - 1234L);
        this.row2Timestamp = new Timestamp(System.currentTimeMillis() + 1234567L);
        this.row2Integer = 10011;
        this.row2Decimal = new BigDecimal(1.2345678966E8);
        stmt.setInt(1, 2);
        stmt.setDate(2, this.row2Date);
        stmt.setTime(3, this.row2Time);
        stmt.setTimestamp(4, this.row2Timestamp);
        stmt.setInt(5, this.row2Integer);
        stmt.setBigDecimal(6, this.row2Decimal);
        stmt.execute();
        conn.commit();
        conn.close();
    }

    @Test
    public void testDateProjection() throws Exception {
        String pattern = "yyyy.MM.dd G HH:mm:ss z";
        String query = "select to_char(col_date, '" + pattern + "') from " + this.TO_CHAR_TABLE_NAME + " WHERE pk = 1";
        String expectedString = this.getGMTDateFormat(pattern).format(this.row1Date);
        this.runOneRowProjectionQuery(query, expectedString);
    }

    @Test
    public void testTimeProjection() throws Exception {
        String pattern = "HH:mm:ss z";
        String query = "select to_char(col_time, '" + pattern + "') from " + this.TO_CHAR_TABLE_NAME + " WHERE pk = 1";
        String expectedString = this.getGMTDateFormat(pattern).format(this.row1Time);
        this.runOneRowProjectionQuery(query, expectedString);
    }

    @Test
    public void testTimestampProjection() throws Exception {
        String pattern = "yyMMddHHmmssZ";
        String query = "select to_char(col_timestamp, '" + pattern + "') from " + this.TO_CHAR_TABLE_NAME + " WHERE pk = 2";
        String expectedString = this.getGMTDateFormat(pattern).format(this.row2Timestamp);
        this.runOneRowProjectionQuery(query, expectedString);
    }

    @Test
    public void testIntegerProjection() throws Exception {
        String pattern = "00";
        String query = "select to_char(col_integer, '" + pattern + "') from " + this.TO_CHAR_TABLE_NAME + " WHERE pk = 1";
        String expectedString = new DecimalFormat(pattern).format(this.row1Integer);
        this.runOneRowProjectionQuery(query, expectedString);
    }

    @Test
    public void testDecimalProjection() throws Exception {
        String pattern = "0.###E0";
        String query = "select to_char(col_decimal, '" + pattern + "') from " + this.TO_CHAR_TABLE_NAME + " WHERE pk = 2";
        String expectedString = new DecimalFormat(pattern).format(this.row2Decimal);
        this.runOneRowProjectionQuery(query, expectedString);
    }

    @Test
    public void testDateFilter() throws Exception {
        String pattern = "yyyyMMddHHmmssZ";
        String expectedString = this.getGMTDateFormat(pattern).format(this.row1Date);
        String query = "select pk from " + this.TO_CHAR_TABLE_NAME + " WHERE to_char(col_date, '" + pattern + "') = '" + expectedString + "'";
        this.runOneRowFilterQuery(query, 1);
    }

    @Test
    public void testTimeFilter() throws Exception {
        String pattern = "ddHHmmssSSSZ";
        String expectedString = this.getGMTDateFormat(pattern).format(this.row1Time);
        String query = "select pk from " + this.TO_CHAR_TABLE_NAME + " WHERE to_char(col_time, '" + pattern + "') = '" + expectedString + "'";
        this.runOneRowFilterQuery(query, 1);
    }

    @Test
    public void testTimestampFilter() throws Exception {
        String pattern = "yy.MM.dd G HH:mm:ss z";
        String expectedString = this.getGMTDateFormat(pattern).format(this.row2Timestamp);
        String query = "select pk from " + this.TO_CHAR_TABLE_NAME + " WHERE to_char(col_timestamp, '" + pattern + "') = '" + expectedString + "'";
        this.runOneRowFilterQuery(query, 2);
    }

    @Test
    public void testIntegerFilter() throws Exception {
        String pattern = "000";
        String expectedString = new DecimalFormat(pattern).format(this.row1Integer);
        String query = "select pk from " + this.TO_CHAR_TABLE_NAME + " WHERE to_char(col_integer, '" + pattern + "') = '" + expectedString + "'";
        this.runOneRowFilterQuery(query, 1);
    }

    @Test
    public void testDecimalFilter() throws Exception {
        String pattern = "00.###E0";
        String expectedString = new DecimalFormat(pattern).format(this.row2Decimal);
        String query = "select pk from " + this.TO_CHAR_TABLE_NAME + " WHERE to_char(col_decimal, '" + pattern + "') = '" + expectedString + "'";
        this.runOneRowFilterQuery(query, 2);
    }

    private void runOneRowProjectionQuery(String oneRowQuery, String projectedValue) throws Exception {
        this.runOneRowQueryTest(oneRowQuery, null, projectedValue);
    }

    private void runOneRowFilterQuery(String oneRowQuery, int pkValue) throws Exception {
        this.runOneRowQueryTest(oneRowQuery, pkValue, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runOneRowQueryTest(String oneRowQuery, Integer pkValue, String projectedValue) throws Exception {
        try (Connection conn = DriverManager.getConnection(ToCharFunctionIT.getUrl());){
            PreparedStatement statement = conn.prepareStatement(oneRowQuery);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            if (pkValue != null) {
                Assert.assertEquals((long)pkValue.intValue(), (long)rs.getInt(1));
            } else {
                Assert.assertEquals((Object)projectedValue, (Object)rs.getString(1));
            }
            Assert.assertFalse((boolean)rs.next());
        }
    }

    private DateFormat getGMTDateFormat(String pattern) {
        SimpleDateFormat result = new SimpleDateFormat(pattern);
        result.setTimeZone(TimeZone.getTimeZone("GMT"));
        return result;
    }

    @Test
    public void testToCharWithCloneMethod() throws SQLException {
        Connection conn = DriverManager.getConnection(ToCharFunctionIT.getUrl());
        String tableName = ToCharFunctionIT.generateUniqueName();
        String ddl = "create table " + tableName + " (k varchar primary key, v integer[])";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('x',ARRAY[1234])");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("select to_char(v[1],'000') from " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)"Unexpected value for date ", (Object)String.valueOf(1234), (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testIndexedNull() throws SQLException {
        String tableName = ToCharFunctionIT.generateUniqueName();
        Connection conn = DriverManager.getConnection(ToCharFunctionIT.getUrl());
        conn.createStatement().execute("create table " + tableName + " (id integer primary key, ts1 timestamp, ts2 timestamp)");
        conn.createStatement().execute("create index t_ts2_idx on " + tableName + " (ts2)");
        conn.createStatement().execute("upsert into " + tableName + " values (1, null, null)");
        conn.commit();
        for (String columnName : new String[]{"ts1", "ts2"}) {
            try (ResultSet rs = conn.createStatement().executeQuery(String.format("select to_char(%s) from %s", columnName, tableName));){
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals(null, (Object)rs.getString(1));
            }
        }
        conn.close();
    }

    @Test
    public void testToChar100Times() throws Exception {
        String tableName = ToCharFunctionIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(ToCharFunctionIT.getUrl());
             Statement statement = conn.createStatement();){
            conn.setAutoCommit(true);
            statement.execute("create table " + tableName + " (id varchar primary key, ts varchar)");
            statement.execute("upsert into " + tableName + " values ('id', '1596067200000')");
            String query = "select ts from " + tableName + " where ts <= (select to_char(cast(to_number(to_date('2020-07-30 00:00:00')) as BIGINT), '#############')) and ts >= (select to_char(cast(to_number(to_date('2020-07-29 00:00:00')) as BIGINT), '#############'))";
            for (int i = 0; i < 100; ++i) {
                try (ResultSet rs = statement.executeQuery(query);){
                    Assert.assertTrue((boolean)rs.next());
                    continue;
                }
            }
        }
    }
}

