/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class TimezoneOffsetFunctionIT
extends ParallelStatsDisabledIT {
    @Test
    public void testTimezoneOffset() throws Exception {
        Connection conn = DriverManager.getConnection(TimezoneOffsetFunctionIT.getUrl());
        String timezone_offset_test = TimezoneOffsetFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + timezone_offset_test + " (k1 INTEGER NOT NULL, dates DATE CONSTRAINT pk PRIMARY KEY (k1))";
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + timezone_offset_test + " (k1, dates) VALUES (1, TO_DATE('2014-02-02 00:00:00'))";
        conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + timezone_offset_test + " (k1, dates) VALUES (2, TO_DATE('2014-06-02 00:00:00'))";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT k1, dates, TIMEZONE_OFFSET('Indian/Cocos', dates) FROM " + timezone_offset_test);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)390L, (long)rs.getInt(3));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)390L, (long)rs.getInt(3));
    }

    @Test
    public void testUnknownTimezone() throws Exception {
        Connection conn = DriverManager.getConnection(TimezoneOffsetFunctionIT.getUrl());
        String timezone_offset_test = TimezoneOffsetFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + timezone_offset_test + " (k1 INTEGER NOT NULL, dates DATE CONSTRAINT pk PRIMARY KEY (k1))";
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + timezone_offset_test + " (k1, dates) VALUES (1, TO_DATE('2014-02-02 00:00:00'))";
        conn.createStatement().execute(dml);
        conn.commit();
        try {
            ResultSet rs = conn.createStatement().executeQuery("SELECT k1, dates, TIMEZONE_OFFSET('Unknown_Timezone', dates) FROM " + timezone_offset_test);
            rs.next();
            Assert.assertEquals((long)0L, (long)rs.getInt(3));
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.ILLEGAL_DATA.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testInRowKeyDSTTimezoneDesc() throws Exception {
        Connection conn = DriverManager.getConnection(TimezoneOffsetFunctionIT.getUrl());
        String timezone_offset_test = TimezoneOffsetFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + timezone_offset_test + " (k1 INTEGER NOT NULL, dates DATE NOT NULL CONSTRAINT pk PRIMARY KEY (k1, dates DESC))";
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + timezone_offset_test + " (k1, dates) VALUES (1, TO_DATE('2014-02-02 00:00:00'))";
        conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + timezone_offset_test + " (k1, dates) VALUES (2, TO_DATE('2014-06-02 00:00:00'))";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT k1, dates, TIMEZONE_OFFSET('Europe/Prague', dates)FROM " + timezone_offset_test + " ORDER BY k1 ASC");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)60L, (long)rs.getInt(3));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)120L, (long)rs.getInt(3));
    }

    @Test
    public void testBothParametersNull() throws Exception {
        Connection conn = DriverManager.getConnection(TimezoneOffsetFunctionIT.getUrl());
        String timezone_offset_test = TimezoneOffsetFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + timezone_offset_test + " (k1 INTEGER NOT NULL, dates DATE, v1 VARCHAR CONSTRAINT pk PRIMARY KEY (k1))";
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + timezone_offset_test + " (k1, dates, v1) VALUES (2, null, null)";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT k1, dates, TIMEZONE_OFFSET(v1, dates)FROM " + timezone_offset_test + " ORDER BY k1 ASC");
        Assert.assertTrue((boolean)rs.next());
        rs.getInt(3);
        Assert.assertTrue((boolean)rs.wasNull());
    }

    @Test
    public void timezoneParameterNull() throws Exception {
        Connection conn = DriverManager.getConnection(TimezoneOffsetFunctionIT.getUrl());
        String timezone_offset_test = TimezoneOffsetFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + timezone_offset_test + " (k1 INTEGER NOT NULL, dates DATE, v1 VARCHAR CONSTRAINT pk PRIMARY KEY (k1))";
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + timezone_offset_test + " (k1, dates, v1) VALUES (2, TO_DATE('2014-06-02 00:00:00'), null)";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT k1, dates, TIMEZONE_OFFSET(v1, dates)FROM " + timezone_offset_test + " ORDER BY k1 ASC");
        Assert.assertTrue((boolean)rs.next());
        rs.getInt(3);
        Assert.assertTrue((boolean)rs.wasNull());
    }

    @Test
    public void dateParameterNull() throws Exception {
        Connection conn = DriverManager.getConnection(TimezoneOffsetFunctionIT.getUrl());
        String timezone_offset_test = TimezoneOffsetFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + timezone_offset_test + " (k1 INTEGER NOT NULL, dates DATE, v1 VARCHAR CONSTRAINT pk PRIMARY KEY (k1))";
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + timezone_offset_test + " (k1, dates, v1) VALUES (2, null, 'Asia/Aden')";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT k1, dates, TIMEZONE_OFFSET(v1, dates)FROM " + timezone_offset_test + " ORDER BY k1 ASC");
        Assert.assertTrue((boolean)rs.next());
        rs.getInt(3);
        Assert.assertTrue((boolean)rs.wasNull());
    }

    @Test
    public void testInsertingRetrivingTimestamp() throws Exception {
        Connection conn = DriverManager.getConnection(TimezoneOffsetFunctionIT.getUrl());
        String t = TimezoneOffsetFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + t + " (K INTEGER NOT NULL PRIMARY KEY, V TIMESTAMP)";
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + t + " VALUES (?, ?)";
        PreparedStatement stmt = conn.prepareStatement(dml);
        stmt.setInt(1, 1);
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone("US/Hawaii"));
        long time = System.currentTimeMillis();
        stmt.setTimestamp(2, new Timestamp(time), cal);
        stmt.executeUpdate();
        conn.commit();
        String query = "SELECT V FROM " + t;
        ResultSet rs = conn.createStatement().executeQuery(query);
        rs.next();
        Assert.assertEquals((Object)new Timestamp(time), (Object)rs.getTimestamp(1));
        Assert.assertEquals((Object)new Timestamp(time), (Object)rs.getTimestamp("V"));
        Assert.assertEquals((Object)new Timestamp(time), (Object)rs.getTimestamp(1, cal));
        Assert.assertEquals((Object)new Timestamp(time), (Object)rs.getTimestamp("V", cal));
    }
}

