/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.phoenix.end2end.ParallelStatsEnabledIT;
import org.apache.phoenix.end2end.ParallelStatsEnabledTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.util.DateUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsEnabledTest.class})
public class TimeZoneDisplacementIT
extends ParallelStatsEnabledIT {
    @Test
    public void testCompliantCorrection() throws Exception {
        String tableName = TimeZoneDisplacementIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.put("phoenix.query.applyTimeZoneDisplacement", Boolean.TRUE.toString());
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(TimeZoneDisplacementIT.getUrl(), props);
             Statement stmt = conn.createStatement();
             PreparedStatement insertPstmt = conn.prepareStatement("upsert into " + tableName + " (ID, D1, D2, T1, T2, S1, S2, UD1, UD2, UT1, UT2, US1, US2) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ");){
            conn.setAutoCommit(true);
            stmt.executeUpdate("create table " + tableName + " (id integer primary key,D1 DATE, D2 DATE,T1 TIME, T2 TIME,S1 TIMESTAMP, S2 TIMESTAMP,UD1 UNSIGNED_DATE, UD2 UNSIGNED_DATE,UT1 UNSIGNED_TIME, UT2 UNSIGNED_TIME,US1 UNSIGNED_TIMESTAMP, US2 UNSIGNED_TIMESTAMP)");
            java.util.Date nowJud = new java.util.Date();
            Date nowSqlDate = new Date(nowJud.getTime());
            Time nowSqlTime = new Time(nowJud.getTime());
            Timestamp nowSqlTimestamp = new Timestamp(nowJud.getTime());
            String nowString = DateUtil.getDateFormatter((String)conn.getDatePattern(), (String)TimeZone.getDefault().getID()).format(nowJud);
            insertPstmt.setInt(1, 1);
            insertPstmt.setString(2, nowString);
            insertPstmt.setDate(3, nowSqlDate);
            insertPstmt.setString(4, nowString);
            insertPstmt.setTime(5, nowSqlTime);
            insertPstmt.setString(6, nowString);
            insertPstmt.setTimestamp(7, nowSqlTimestamp);
            insertPstmt.setString(8, nowString);
            insertPstmt.setDate(9, nowSqlDate);
            insertPstmt.setString(10, nowString);
            insertPstmt.setTime(11, nowSqlTime);
            insertPstmt.setString(12, nowString);
            insertPstmt.setTimestamp(13, nowSqlTimestamp);
            insertPstmt.execute();
            ResultSet rs = stmt.executeQuery("select * from " + tableName + " where D1 = D2 AND T1 = T2 and S1 = S2 and UD1 = UD2 and UT1 = UT2 and US1 = US2");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)nowSqlDate, (Object)rs.getDate("D1"));
            Assert.assertEquals((Object)nowSqlDate, (Object)rs.getDate("D2"));
            Assert.assertEquals((Object)nowSqlTime, (Object)rs.getDate("T1"));
            Assert.assertEquals((Object)nowSqlTime, (Object)rs.getDate("T2"));
            Assert.assertEquals((Object)nowSqlTimestamp, (Object)rs.getTimestamp("S1"));
            Assert.assertEquals((Object)nowSqlTimestamp, (Object)rs.getTimestamp("S2"));
            Assert.assertEquals((Object)nowSqlDate, (Object)rs.getDate("UD1"));
            Assert.assertEquals((Object)nowSqlDate, (Object)rs.getDate("UD2"));
            Assert.assertEquals((Object)nowSqlTime, (Object)rs.getDate("UT1"));
            Assert.assertEquals((Object)nowSqlTime, (Object)rs.getDate("UT2"));
            Assert.assertEquals((Object)nowSqlTimestamp, (Object)rs.getTimestamp("US1"));
            Assert.assertEquals((Object)nowSqlTimestamp, (Object)rs.getTimestamp("US2"));
            Assert.assertEquals((Object)nowString, (Object)rs.getString("D1"));
            Assert.assertEquals((Object)nowString, (Object)rs.getString("D2"));
            Assert.assertEquals((Object)nowString, (Object)rs.getString("T1"));
            Assert.assertEquals((Object)nowString, (Object)rs.getString("T2"));
            Assert.assertEquals((Object)nowString, (Object)rs.getString("S1"));
            Assert.assertEquals((Object)nowString, (Object)rs.getString("S2"));
            Assert.assertEquals((Object)nowString, (Object)rs.getString("UD1"));
            Assert.assertEquals((Object)nowString, (Object)rs.getString("UD2"));
            Assert.assertEquals((Object)nowString, (Object)rs.getString("UT1"));
            Assert.assertEquals((Object)nowString, (Object)rs.getString("UT2"));
            Assert.assertEquals((Object)nowString, (Object)rs.getString("US1"));
            Assert.assertEquals((Object)nowString, (Object)rs.getString("US2"));
        }
    }

    @Test
    public void testPhoenix5066() throws Exception {
        String tableName = TimeZoneDisplacementIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.put("phoenix.query.applyTimeZoneDisplacement", Boolean.TRUE.toString());
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(TimeZoneDisplacementIT.getUrl(), props);
             Statement stmt = conn.createStatement();
             PreparedStatement insertPstmt = conn.prepareStatement("upsert into " + tableName + " (ID, D, T, S) VALUES (?, ?, ?, ?) ");){
            conn.setAutoCommit(true);
            stmt.executeUpdate("create table " + tableName + " (id integer primary key,D DATE, T TIME, S TIMESTAMP)");
            String dateString = "2018-12-10 15:40:47";
            java.util.Date dateJud = new java.util.Date(LocalDateTime.parse(dateString.replace(" ", "T")).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
            Date sqlDate = new Date(dateJud.getTime());
            Time sqlTime = new Time(dateJud.getTime());
            Timestamp sqlTimestamp = new Timestamp(dateJud.getTime());
            stmt.executeUpdate("upsert into " + tableName + "(ID, D, T, S) VALUES (1,'" + dateString + "','" + dateString + "','" + dateString + "')");
            stmt.executeUpdate("upsert into " + tableName + "(ID, D, T, S) VALUES (2,to_date('" + dateString + "'),to_time('" + dateString + "'),to_timestamp('" + dateString + "'))");
            insertPstmt.setInt(1, 3);
            insertPstmt.setDate(2, sqlDate);
            insertPstmt.setTime(3, sqlTime);
            insertPstmt.setTimestamp(4, sqlTimestamp);
            insertPstmt.executeUpdate();
            ResultSet rs = stmt.executeQuery("select * from " + tableName + " order by id asc");
            for (int i = 0; i < 3; ++i) {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)(dateString + ".000"), (Object)rs.getString("D"));
                Assert.assertEquals((Object)(dateString + ".000"), (Object)rs.getString("T"));
                Assert.assertEquals((Object)(dateString + ".000"), (Object)rs.getString("S"));
                Assert.assertEquals((Object)sqlDate, (Object)rs.getDate("D"));
                Assert.assertEquals((Object)sqlTime, (Object)rs.getTime("T"));
                Assert.assertEquals((Object)sqlTimestamp, (Object)rs.getTimestamp("S"));
            }
        }
    }

    @Test
    public void testCurrent() throws Exception {
        String tableName = TimeZoneDisplacementIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.put("phoenix.query.applyTimeZoneDisplacement", Boolean.TRUE.toString());
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(TimeZoneDisplacementIT.getUrl(), props);
             Statement stmt = conn.createStatement();){
            conn.setAutoCommit(true);
            stmt.executeUpdate("create table " + tableName + " (ID integer primary key, D DATE, T TIME, S TIMESTAMP, UD UNSIGNED_DATE, UT UNSIGNED_TIME, US UNSIGNED_TIMESTAMP)");
            java.util.Date nowJud = new java.util.Date();
            stmt.executeUpdate("UPSERT INTO " + tableName + " (ID, D, T, S, UD, UT, US) VALUES (1, CURRENT_DATE(), CURRENT_TIME(), CURRENT_DATE(),CURRENT_DATE(), CURRENT_TIME(), CURRENT_DATE())");
            ResultSet rs = stmt.executeQuery("select * from " + tableName + " order by id asc");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((Math.abs(nowJud.getTime() - rs.getDate("D").getTime()) < 1000L ? 1 : 0) != 0);
            Assert.assertTrue((Math.abs(nowJud.getTime() - rs.getTime("T").getTime()) < 1000L ? 1 : 0) != 0);
            Assert.assertTrue((Math.abs(nowJud.getTime() - rs.getTimestamp("S").getTime()) < 1000L ? 1 : 0) != 0);
            Assert.assertTrue((Math.abs(nowJud.getTime() - rs.getDate("UD").getTime()) < 1000L ? 1 : 0) != 0);
            Assert.assertTrue((Math.abs(nowJud.getTime() - rs.getTime("UT").getTime()) < 1000L ? 1 : 0) != 0);
            Assert.assertTrue((Math.abs(nowJud.getTime() - rs.getTimestamp("US").getTime()) < 1000L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testRowTimestamp() throws Exception {
        TimeZone tz = TimeZone.getDefault();
        String tableName = TimeZoneDisplacementIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.put("phoenix.query.applyTimeZoneDisplacement", Boolean.TRUE.toString());
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(TimeZoneDisplacementIT.getUrl(), props);
             Statement stmt = conn.createStatement();
             PreparedStatement upsertStmt = conn.prepareStatement("upsert into " + tableName + " (ID, ROWTS, D) VALUES (?, ?, ?)");){
            conn.setAutoCommit(true);
            stmt.executeUpdate("create table " + tableName + " (ID integer not null, ROWTS DATE NOT NULL, D DATE, CONSTRAINT pk PRIMARY KEY (ID, ROWTS ROW_TIMESTAMP) )");
            String dateString = "2018-12-10 15:40:47";
            java.util.Date dateJudLocal = new java.util.Date(LocalDateTime.parse(dateString.replace(" ", "T")).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
            Date sqlDateLocal = new Date(dateJudLocal.getTime());
            stmt.executeUpdate("upsert into " + tableName + " (ID, D) VALUES (1, '" + dateString + "')");
            stmt.executeUpdate("upsert into " + tableName + " (ID, ROWTS, D) VALUES (2, '" + dateString + "','" + dateString + "')");
            upsertStmt.setInt(1, 3);
            upsertStmt.setDate(2, sqlDateLocal);
            upsertStmt.setDate(3, sqlDateLocal);
            upsertStmt.executeUpdate();
            Date nowDate = new Date(new java.util.Date().getTime());
            upsertStmt.setInt(1, 4);
            upsertStmt.setDate(2, nowDate);
            upsertStmt.setDate(3, nowDate);
            upsertStmt.executeUpdate();
            ResultSet rs = stmt.executeQuery("select * from " + tableName + " order by id asc");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt("ID"));
            Assert.assertEquals((Object)sqlDateLocal, (Object)rs.getDate("D"));
            Assert.assertTrue((Math.abs(DateUtil.applyOutputDisplacement((Date)new Date(new java.util.Date().getTime()), (TimeZone)tz).getTime() - rs.getDate("ROWTS").getTime()) < 10000L ? 1 : 0) != 0);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt("ID"));
            Assert.assertEquals((Object)sqlDateLocal, (Object)rs.getDate("D"));
            Assert.assertEquals((Object)sqlDateLocal, (Object)rs.getDate("ROWTS"));
            Assert.assertEquals((Object)(dateString + ".000"), (Object)rs.getString("ROWTS"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt("ID"));
            Assert.assertEquals((Object)sqlDateLocal, (Object)rs.getDate("D"));
            Assert.assertEquals((Object)sqlDateLocal, (Object)rs.getDate("ROWTS"));
            Assert.assertEquals((Object)(dateString + ".000"), (Object)rs.getString("ROWTS"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt("ID"));
            Assert.assertEquals((Object)nowDate, (Object)rs.getDate("D"));
            Assert.assertEquals((Object)nowDate, (Object)rs.getDate("ROWTS"));
            Assert.assertEquals((Object)DateUtil.getDateFormatter((String)"yyyy-MM-dd HH:mm:ss.SSS").format(DateUtil.applyInputDisplacement((Date)nowDate, (TimeZone)tz)), (Object)rs.getString("ROWTS"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetObjectWithNullValue() throws Exception {
        String tableName = TimeZoneDisplacementIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.put("phoenix.query.applyTimeZoneDisplacement", Boolean.TRUE.toString());
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(TimeZoneDisplacementIT.getUrl(), props);){
            conn.setAutoCommit(true);
            try (Statement stmt = conn.createStatement();){
                stmt.execute("CREATE TABLE " + tableName + " (ID INTEGER PRIMARY KEY, D1 DATE)");
            }
            String dateString = "2025-01-01 10:00:00";
            try (PreparedStatement insertPstmt = conn.prepareStatement("UPSERT INTO " + tableName + " (ID, D1) values (?, ?) ");){
                insertPstmt.setInt(1, 1);
                insertPstmt.setString(2, dateString);
                insertPstmt.executeUpdate();
                insertPstmt.setInt(1, 2);
                insertPstmt.setString(2, null);
                insertPstmt.executeUpdate();
            }
            try (PreparedStatement queryPstmt = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE ID = ?");){
                queryPstmt.setInt(1, 1);
                ResultSet resultSet = queryPstmt.executeQuery();
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertNotNull((Object)resultSet.getObject("D1"));
                queryPstmt.setInt(1, 2);
                resultSet = queryPstmt.executeQuery();
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertNull((Object)resultSet.getObject("D1"));
            }
        }
    }
}

