/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.coprocessor.PhoenixMasterObserver;

public class TestPhoenixMasterObserver
extends PhoenixMasterObserver {
    private int splitFailureCount;
    private int mergeFailureCount;
    private static final int SPLIT_FAILURE_THRESHOLD = 24;
    private static final int MERGE_FAILURE_THRESHOLD = 15;

    public void start(CoprocessorEnvironment env) throws IOException {
        super.start(env);
        this.splitFailureCount = 0;
        this.mergeFailureCount = 0;
    }

    protected Pair<List<String>, List<Long>> getAncestorIdsForSplit(Connection conn, String tableName, String streamName, RegionInfo regionInfoA, RegionInfo regionInfoB) throws SQLException {
        if (this.splitFailureCount < 24) {
            ++this.splitFailureCount;
            throw new SQLException("Test failure for split operation, attempt " + this.splitFailureCount);
        }
        return super.getAncestorIdsForSplit(conn, tableName, streamName, regionInfoA, regionInfoB);
    }

    protected List<String> getAncestorIdsForMerge(Connection conn, String tableName, String streamName, RegionInfo parent) throws SQLException {
        if (this.mergeFailureCount < 15) {
            ++this.mergeFailureCount;
            throw new SQLException("Test failure for merge operation, attempt " + this.mergeFailureCount);
        }
        return super.getAncestorIdsForMerge(conn, tableName, streamName, parent);
    }
}

