/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.util.Arrays;
import java.util.Collection;
import org.apache.phoenix.end2end.BaseTenantSpecificViewIndexIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=Parameterized.class)
public class TenantSpecificViewIndexSaltedIT
extends BaseTenantSpecificViewIndexIT {
    private final Integer saltBuckets;

    public TenantSpecificViewIndexSaltedIT(Integer saltBuckets) {
        this.saltBuckets = saltBuckets;
    }

    @Parameterized.Parameters(name="TenantSpecificViewIndexSaltedIT_SaltBuckets={0}")
    public static synchronized Collection<Object[]> data() {
        return Arrays.asList({3}, {13}, {39});
    }

    @Test
    public void testUpdatableSaltedView() throws Exception {
        this.testUpdatableView(this.saltBuckets);
    }

    @Test
    public void testUpdatableViewsWithSameNameDifferentTenants() throws Exception {
        this.testUpdatableViewsWithSameNameDifferentTenants(this.saltBuckets);
    }

    @Test
    public void testUpdatableSaltedViewWithLocalIndex() throws Exception {
        this.testUpdatableView(this.saltBuckets, true);
    }

    @Test
    public void testUpdatableViewsWithSameNameDifferentTenantsWithLocalIndex() throws Exception {
        this.testUpdatableViewsWithSameNameDifferentTenants(this.saltBuckets, true);
    }
}

