/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.end2end.BaseTenantSpecificViewIndexIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class TenantSpecificViewIndexIT
extends BaseTenantSpecificViewIndexIT {
    @Test
    public void testUpdatableView() throws Exception {
        this.testUpdatableView(null);
    }

    @Test
    public void testUpdatableViewLocalIndex() throws Exception {
        this.testUpdatableView(null, true);
    }

    @Test
    public void testUpdatableViewLocalIndexNonStringTenantId() throws Exception {
        this.testUpdatableViewNonString(null, true);
    }

    @Test
    public void testUpdatableViewsWithSameNameDifferentTenants() throws Exception {
        this.testUpdatableViewsWithSameNameDifferentTenants(null);
    }

    @Test
    public void testUpdatableViewsWithSameNameDifferentTenantsWithLocalIndex() throws Exception {
        this.testUpdatableViewsWithSameNameDifferentTenants(null, true);
    }

    @Test
    public void testMultiCFViewIndex() throws Exception {
        this.testMultiCFViewIndex(false, false);
    }

    @Test
    public void testMultiCFViewIndexWithNamespaceMapping() throws Exception {
        this.testMultiCFViewIndex(false, true);
    }

    @Test
    public void testMultiCFViewLocalIndex() throws Exception {
        this.testMultiCFViewIndex(true, false);
    }

    private void createTableAndValidate(String tableName, boolean isNamespaceEnabled) throws Exception {
        Properties props = new Properties();
        if (isNamespaceEnabled) {
            props.setProperty("phoenix.schema.isNamespaceMappingEnabled", Boolean.toString(true));
        }
        Connection conn = DriverManager.getConnection(TenantSpecificViewIndexIT.getUrl(), props);
        if (isNamespaceEnabled) {
            conn.createStatement().execute("CREATE SCHEMA " + SchemaUtil.getSchemaNameFromFullName((String)tableName));
        }
        String ddl = "CREATE TABLE " + tableName + " (PK1 VARCHAR not null, PK2 VARCHAR not null, MYCF1.COL1 varchar,MYCF2.COL2 varchar CONSTRAINT pk PRIMARY KEY(PK1,PK2)) MULTI_TENANT=true";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("UPSERT INTO " + tableName + " values ('a','b','c','d')");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("select * from " + tableName + " where (pk1,pk2) IN (('a','b'),('b','b'))");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((Object)"b", (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }

    private void testMultiCFViewIndex(boolean localIndex, boolean isNamespaceEnabled) throws Exception {
        String tableName = SchemaUtil.getTableName((String)SCHEMA1, (String)TenantSpecificViewIndexIT.generateUniqueName());
        String viewName1 = SchemaUtil.getTableName((String)SCHEMA2, (String)TenantSpecificViewIndexIT.generateUniqueName());
        String viewName2 = SchemaUtil.getTableName((String)SCHEMA4, (String)TenantSpecificViewIndexIT.generateUniqueName());
        this.createTableAndValidate(tableName, isNamespaceEnabled);
        String tenantId1 = TENANT1;
        String tenantId2 = TENANT2;
        this.createViewAndIndexesWithTenantId(tableName, viewName1, localIndex, tenantId1, isNamespaceEnabled, 0L);
        this.createViewAndIndexesWithTenantId(tableName, viewName2, localIndex, tenantId2, isNamespaceEnabled, 1L);
        String sequenceNameA = MetaDataUtil.getViewIndexSequenceName((PName)PNameFactory.newName((String)tableName), (PName)PNameFactory.newName((String)tenantId2), (boolean)isNamespaceEnabled);
        String sequenceNameB = MetaDataUtil.getViewIndexSequenceName((PName)PNameFactory.newName((String)tableName), (PName)PNameFactory.newName((String)tenantId1), (boolean)isNamespaceEnabled);
        Assert.assertEquals((Object)sequenceNameA, (Object)sequenceNameB);
        String sequenceSchemaName = MetaDataUtil.getViewIndexSequenceSchemaName((PName)PNameFactory.newName((String)tableName), (boolean)isNamespaceEnabled);
        TenantSpecificViewIndexIT.verifySequenceValue(null, sequenceNameA, sequenceSchemaName, -32766L);
        Properties props = new Properties();
        props.setProperty("TenantId", tenantId2);
        try (Connection conn = DriverManager.getConnection(TenantSpecificViewIndexIT.getUrl(), props);){
            conn.createStatement().execute("DROP VIEW  " + viewName2);
        }
        props.setProperty("TenantId", tenantId1);
        conn = DriverManager.getConnection(TenantSpecificViewIndexIT.getUrl(), props);
        try {
            conn.createStatement().execute("DROP VIEW  " + viewName1);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        DriverManager.getConnection(TenantSpecificViewIndexIT.getUrl()).createStatement().execute("DROP TABLE " + tableName + " CASCADE");
        TenantSpecificViewIndexIT.verifySequenceNotExists(null, sequenceNameA, sequenceSchemaName);
    }

    private void createViewAndIndexesWithTenantId(String tableName, String viewName, boolean localIndex, String tenantId, boolean isNamespaceMapped, long indexIdOffset) throws Exception {
        ResultSet rs;
        Connection conn;
        block12: {
            Properties props = new Properties();
            String indexName = "I_" + TenantSpecificViewIndexIT.generateUniqueName();
            String schemaName = SchemaUtil.getSchemaNameFromFullName((String)viewName);
            String fullIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
            if (tenantId != null) {
                props.setProperty("TenantId", tenantId);
            }
            conn = DriverManager.getConnection(TenantSpecificViewIndexIT.getUrl(), props);
            conn.createStatement().execute("CREATE VIEW " + viewName + " AS SELECT * FROM " + tableName);
            rs = conn.createStatement().executeQuery("select * from " + viewName);
            int i = 1;
            if ("a".equals(tenantId)) {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"b", (Object)rs.getString(i++));
                Assert.assertEquals((Object)"c", (Object)rs.getString(i++));
                Assert.assertEquals((Object)"d", (Object)rs.getString(i++));
            }
            Assert.assertFalse((boolean)rs.next());
            conn.createStatement().execute("UPSERT INTO " + viewName + " VALUES ('e','f','g')");
            conn.commit();
            if (localIndex) {
                conn.createStatement().execute("create local index " + indexName + " on " + viewName + " (COL1)");
            } else {
                conn.createStatement().execute("create index " + indexName + " on " + viewName + " (COL1)");
            }
            rs = conn.createStatement().executeQuery("select * from " + viewName);
            i = 1;
            if ("a".equals(tenantId)) {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"b", (Object)rs.getString(i++));
                Assert.assertEquals((Object)"c", (Object)rs.getString(i++));
                Assert.assertEquals((Object)"d", (Object)rs.getString(i++));
            }
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"e", (Object)rs.getString(1));
            Assert.assertEquals((Object)"f", (Object)rs.getString(2));
            Assert.assertEquals((Object)"g", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            String query = "select * from " + viewName;
            ExplainPlan plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            Assert.assertEquals((Object)SchemaUtil.getPhysicalTableName((byte[])Bytes.toBytes((String)tableName), (boolean)isNamespaceMapped).toString(), (Object)explainPlanAttributes.getTableName());
            Assert.assertEquals((Object)(" ['" + tenantId + "']"), (Object)explainPlanAttributes.getKeyRanges());
            rs = conn.createStatement().executeQuery("select pk2,col1 from " + viewName + " where col1='f'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"e", (Object)rs.getString(1));
            Assert.assertEquals((Object)"f", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            query = "select pk2,col1 from " + viewName + " where col1='f'";
            plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
            if (localIndex) {
                Assert.assertEquals((Object)(fullIndexName + "(" + SchemaUtil.getPhysicalTableName((byte[])Bytes.toBytes((String)tableName), (boolean)isNamespaceMapped).toString() + ")"), (Object)explainPlanAttributes.getTableName());
                Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
                Assert.assertEquals((Object)(" [" + (1L + indexIdOffset) + ",'" + tenantId + "','f']"), (Object)explainPlanAttributes.getKeyRanges());
            } else {
                Assert.assertEquals((Object)Bytes.toString((byte[])MetaDataUtil.getViewIndexPhysicalName((byte[])SchemaUtil.getPhysicalTableName((byte[])Bytes.toBytes((String)tableName), (boolean)isNamespaceMapped).toBytes())), (Object)explainPlanAttributes.getTableName());
                Assert.assertNull((Object)explainPlanAttributes.getClientSortAlgo());
                Assert.assertEquals((Object)(" [" + (-32768L + indexIdOffset) + ",'" + tenantId + "','f']"), (Object)explainPlanAttributes.getKeyRanges());
            }
            try {
                conn.createStatement().executeQuery("select * from " + tableName + " where (pk1,pk2) IN (('a','b'),('b','b'))");
                if (tenantId != null) {
                    Assert.fail();
                }
            }
            catch (ColumnNotFoundException e) {
                if (tenantId != null) break block12;
                Assert.fail();
            }
        }
        rs = conn.createStatement().executeQuery("select * from " + tableName + " where pk2 IN ('b','e')");
        if ("a".equals(tenantId)) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
        }
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"e", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("select * from " + viewName + " where pk2 IN ('b','e')");
        if ("a".equals(tenantId)) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
        }
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"e", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }

    @Test
    public void testNonPaddedTenantId() throws Exception {
        String tenantId1 = TENANT1;
        String tenantId2 = TENANT2;
        String tableName = SchemaUtil.getTableName((String)SCHEMA1, (String)TenantSpecificViewIndexIT.generateUniqueName());
        String viewName = SchemaUtil.getTableName((String)SCHEMA2, (String)TenantSpecificViewIndexIT.generateUniqueName());
        String ddl = "CREATE TABLE " + tableName + " (tenantId char(15) NOT NULL, pk1 varchar NOT NULL, pk2 INTEGER NOT NULL, val1 VARCHAR CONSTRAINT pk primary key (tenantId,pk1,pk2)) MULTI_TENANT = true";
        Connection conn = DriverManager.getConnection(TenantSpecificViewIndexIT.getUrl());
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + " (tenantId, pk1, pk2, val1) VALUES (?, ?, ?, ?)";
        PreparedStatement stmt = conn.prepareStatement(dml);
        String pk = "pk1b";
        stmt.setString(1, tenantId1);
        stmt.setString(2, pk);
        stmt.setInt(3, 100);
        stmt.setString(4, "value1");
        stmt.executeUpdate();
        stmt.setString(1, tenantId2);
        stmt.setString(2, pk);
        stmt.setInt(3, 200);
        stmt.setString(4, "value2");
        stmt.executeUpdate();
        conn.commit();
        conn.close();
        String tenantUrl = TenantSpecificViewIndexIT.getUrl() + ";TenantId=" + tenantId1;
        Connection tenantConn = DriverManager.getConnection(tenantUrl);
        tenantConn.createStatement().execute("CREATE VIEW " + viewName + " AS select * from " + tableName);
        String query = "SELECT val1 FROM " + viewName + " WHERE pk1 = ?";
        PreparedStatement stmt2 = tenantConn.prepareStatement(query);
        stmt2.setString(1, pk);
        ResultSet rs = stmt2.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"value1", (Object)rs.getString(1));
        Assert.assertFalse((String)"No other rows should have been returned for the tenant", (boolean)rs.next());
    }

    @Test
    public void testOverlappingDatesFilter() throws Exception {
        String tenantId = TENANT1;
        String tenantUrl = TenantSpecificViewIndexIT.getUrl() + ";TenantId=" + tenantId + ";phoenix.query.force.rowkeyorder=true";
        String tableName = SchemaUtil.getTableName((String)SCHEMA1, (String)TenantSpecificViewIndexIT.generateUniqueName());
        String viewName = SchemaUtil.getTableName((String)SCHEMA2, (String)TenantSpecificViewIndexIT.generateUniqueName());
        String ddl = "CREATE TABLE " + tableName + "(ORGANIZATION_ID CHAR(15) NOT NULL, PARENT_TYPE CHAR(3) NOT NULL, PARENT_ID CHAR(15) NOT NULL,CREATED_DATE DATE NOT NULL CONSTRAINT PK PRIMARY KEY (ORGANIZATION_ID, PARENT_TYPE, PARENT_ID, CREATED_DATE DESC)) VERSIONS=1,MULTI_TENANT=true,REPLICATION_SCOPE=1";
        try (Connection conn = DriverManager.getConnection(TenantSpecificViewIndexIT.getUrl());
             Connection viewConn = DriverManager.getConnection(tenantUrl);){
            conn.createStatement().execute(ddl);
            conn.createStatement().execute("CREATE INDEX IF NOT EXISTS IDX ON " + tableName + "(PARENT_TYPE, CREATED_DATE, PARENT_ID)");
            viewConn.createStatement().execute("CREATE VIEW IF NOT EXISTS " + viewName + " AS SELECT * FROM " + tableName);
            String query = "EXPLAIN SELECT PARENT_ID FROM " + viewName + " WHERE PARENT_TYPE='001' AND (CREATED_DATE > to_date('2011-01-01') AND CREATED_DATE < to_date('2016-10-31'))ORDER BY PARENT_TYPE,CREATED_DATE LIMIT 501";
            ResultSet rs = viewConn.createStatement().executeQuery(query);
            String exptectedIndexName = SchemaUtil.getTableName((String)SCHEMA1, (String)"IDX");
            String expectedPlanFormat = "CLIENT SERIAL 1-WAY RANGE SCAN OVER " + exptectedIndexName + " ['tenant1        ','001','%s 00:00:00.001'] - ['tenant1        ','001','%s 00:00:00.000']\n    SERVER FILTER BY FIRST KEY ONLY\n    SERVER 501 ROW LIMIT\nCLIENT 501 ROW LIMIT";
            Assert.assertEquals((Object)String.format(expectedPlanFormat, "2011-01-01", "2016-10-31"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
            query = "EXPLAIN SELECT PARENT_ID FROM " + viewName + " WHERE PARENT_TYPE='001'  AND (CREATED_DATE >= to_date('2011-01-01') AND CREATED_DATE <= to_date('2016-01-01')) AND (CREATED_DATE > to_date('2012-10-21') AND CREATED_DATE < to_date('2016-10-31')) ORDER BY PARENT_TYPE,CREATED_DATE LIMIT 501";
            rs = viewConn.createStatement().executeQuery(query);
            Assert.assertEquals((Object)String.format(expectedPlanFormat, "2012-10-21", "2016-01-01"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
        }
    }

    @Test
    public void testCurrentTimeWithViewIndexes() throws Exception {
        String baseName = TenantSpecificViewIndexIT.generateUniqueName();
        String baseTable = String.format("BT_%s", baseName);
        String globalView = String.format("GV_%s", baseName);
        String tenantView = String.format("TV_%s", baseName);
        String viewIndex = String.format("IDX_%s", globalView);
        String tenant = "00D0t000T000001";
        String tenantConnectionUrl = String.format("%s;%s=%s", TenantSpecificViewIndexIT.getUrl(), "TenantId", tenant);
        String BASE_TABLE_TEMPLATE = "CREATE TABLE IF NOT EXISTS %s  (TENANT_ID CHAR(15) NOT NULL,  KP CHAR(3) NOT NULL,  COL1 VARCHAR,COL2 VARCHAR,COL3 VARCHAR  CONSTRAINT PK PRIMARY KEY (TENANT_ID, KP))  MULTI_TENANT=true, COLUMN_ENCODED_BYTES = 0";
        String GLOBAL_VIEW_TEMPLATE = "CREATE VIEW IF NOT EXISTS %s  (GID CHAR(15) NOT NULL, COL4 VARCHAR, COL5 VARCHAR, COL6 VARCHAR  CONSTRAINT pk PRIMARY KEY (GID))  AS SELECT * FROM %s WHERE KP = 'A'";
        String TENANT_VIEW_TEMPLATE = "CREATE VIEW IF NOT EXISTS %s AS SELECT * FROM %s";
        String INDEX_TEMPLATE = "CREATE INDEX IF NOT EXISTS %s ON %s(%s) INCLUDE (%s)";
        try (Connection globalConn = DriverManager.getConnection(TenantSpecificViewIndexIT.getUrl());
             Connection tenantConnection = DriverManager.getConnection(tenantConnectionUrl);){
            globalConn.createStatement().execute(String.format(BASE_TABLE_TEMPLATE, baseTable));
            globalConn.createStatement().execute(String.format(GLOBAL_VIEW_TEMPLATE, globalView, baseTable));
            globalConn.createStatement().execute(String.format(INDEX_TEMPLATE, viewIndex, globalView, "COL4", "COL6"));
            tenantConnection.createStatement().execute(String.format(TENANT_VIEW_TEMPLATE, tenantView, globalView));
            try (Statement stmt = tenantConnection.createStatement();){
                stmt.execute(String.format("UPSERT INTO %s (GID,COL1,COL2,COL3,COL4,COL5,COL6) VALUES('gv1', 'a1','b1','c1','d41','e51','f61')", tenantView));
                tenantConnection.commit();
            }
        }
        try (Connection readConnection = DriverManager.getConnection(tenantConnectionUrl);){
            long time;
            ResultSet rs;
            String planWithIndex = String.format("SELECT to_number(current_time()) as t, col6 from %s where col4 = 'd41'", tenantView);
            String planNoIndex = String.format("SELECT to_number(current_time()) as t, col6 from %s where col5 = 'e51'", tenantView);
            try (Statement stmt = readConnection.createStatement();){
                rs = stmt.executeQuery(planWithIndex);
                rs.next();
                time = rs.getLong(1);
                Assert.assertTrue((time != -1L ? 1 : 0) != 0);
            }
            stmt = readConnection.createStatement();
            try {
                rs = stmt.executeQuery(planNoIndex);
                rs.next();
                time = rs.getLong(1);
                Assert.assertTrue((time != -1L ? 1 : 0) != 0);
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }
}

