/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.apache.phoenix.end2end.BaseTenantSpecificTablesIT;
import org.apache.phoenix.end2end.ParallelStatsEnabledTest;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsEnabledTest.class})
public class TenantSpecificTablesDMLIT
extends BaseTenantSpecificTablesIT {
    @Test
    public void testSelectWithLimit() throws Exception {
        Connection conn = DriverManager.getConnection(this.PHOENIX_JDBC_TENANT_SPECIFIC_URL, PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + this.TENANT_TABLE_NAME + " LIMIT 100");
        while (rs.next()) {
        }
    }

    @Test
    public void testPointLookupOnBaseTable() throws Exception {
        String tableName = "T_" + TenantSpecificTablesDMLIT.generateUniqueName();
        String viewName = "V_" + TenantSpecificTablesDMLIT.generateUniqueName();
        String tenantId = "tenant1";
        String kp = "abc";
        String ddl = String.format("CREATE TABLE %s (ORG_ID CHAR(15) NOT NULL, KP CHAR(3) NOT NULL, V1 INTEGER, V2 VARCHAR,CONSTRAINT PK PRIMARY KEY(ORG_ID, KP)) MULTI_TENANT=true", tableName);
        int nRows = 16;
        try (Connection conn = DriverManager.getConnection(TenantSpecificTablesDMLIT.getUrl());){
            String explainPlan;
            PhoenixResultSet prs;
            conn.createStatement().execute(ddl);
            Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            props.setProperty("TenantId", "tenant1");
            try (Connection tconn = DriverManager.getConnection(TenantSpecificTablesDMLIT.getUrl(), props);){
                ddl = String.format("CREATE VIEW %s (PK1 VARCHAR PRIMARY KEY, V3 VARCHAR) AS SELECT * FROM %s WHERE KP='%s'", viewName, tableName, "abc");
                tconn.createStatement().execute(ddl);
                tconn.commit();
                try (PreparedStatement ps = tconn.prepareStatement(String.format("UPSERT INTO %s(V1,V2,PK1,V3) VALUES (?, ?, ?, ?)", viewName));){
                    for (int i = 0; i < nRows; ++i) {
                        ps.setInt(1, i);
                        ps.setString(2, "v2");
                        ps.setString(3, "pk_" + i);
                        ps.setString(4, "v3");
                        ps.executeUpdate();
                    }
                    tconn.commit();
                }
            }
            String dql = String.format("SELECT * FROM %s where org_id='%s' AND kp='%s' LIMIT 1", tableName, "tenant1", "abc");
            try (ResultSet rs = conn.createStatement().executeQuery(dql);){
                prs = rs.unwrap(PhoenixResultSet.class);
                explainPlan = QueryUtil.getExplainPlan((ResultIterator)prs.getUnderlyingIterator());
                Assert.assertTrue((boolean)explainPlan.contains("POINT LOOKUP ON 1 KEY"));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"tenant1", (Object)rs.getString(1));
                Assert.assertEquals((Object)"abc", (Object)rs.getString(2));
            }
            dql = String.format("SELECT count(*) FROM %s where org_id='%s' AND kp='%s'", tableName, "tenant1", "abc");
            rs = conn.createStatement().executeQuery(dql);
            try {
                prs = rs.unwrap(PhoenixResultSet.class);
                explainPlan = QueryUtil.getExplainPlan((ResultIterator)prs.getUnderlyingIterator());
                Assert.assertTrue((boolean)explainPlan.contains("POINT LOOKUP ON 1 KEY"));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)nRows, (long)rs.getInt(1));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    @Test
    public void testBasicUpsertSelect() throws Exception {
        try (Connection conn = DriverManager.getConnection(this.PHOENIX_JDBC_TENANT_SPECIFIC_URL, PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));){
            conn.setAutoCommit(false);
            conn.createStatement().executeUpdate("upsert into " + this.TENANT_TABLE_NAME + " (id, tenant_col) values (1, 'Cheap Sunglasses')");
            conn.createStatement().executeUpdate("upsert into " + this.TENANT_TABLE_NAME + " (id, tenant_col) values (2, 'Viva Las Vegas')");
            conn.commit();
            TestUtil.analyzeTable(conn, this.TENANT_TABLE_NAME);
            ResultSet rs = conn.createStatement().executeQuery("select tenant_col from " + this.TENANT_TABLE_NAME + " where id = 1");
            Assert.assertTrue((String)"Expected 1 row in result set", (boolean)rs.next());
            Assert.assertEquals((Object)"Cheap Sunglasses", (Object)rs.getString(1));
            Assert.assertFalse((String)"Expected 1 row in result set", (boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicUpsertSelect2() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn1 = DriverManager.getConnection(this.PHOENIX_JDBC_TENANT_SPECIFIC_URL, props);
        TenantSpecificTablesDMLIT.createTestTable(this.PHOENIX_JDBC_TENANT_SPECIFIC_URL2, this.TENANT_TABLE_DDL);
        Connection conn2 = DriverManager.getConnection(this.PHOENIX_JDBC_TENANT_SPECIFIC_URL2, props);
        try {
            conn1.setAutoCommit(false);
            conn1.createStatement().executeUpdate("upsert into " + this.TENANT_TABLE_NAME + " values ('me','" + this.TENANT_TYPE_ID + "',1,'Cheap Sunglasses')");
            conn1.createStatement().executeUpdate("upsert into " + this.TENANT_TABLE_NAME + " values ('you','" + this.TENANT_TYPE_ID + "',2,'Viva Las Vegas')");
            conn1.commit();
            TestUtil.analyzeTable(conn1, this.TENANT_TABLE_NAME);
            conn2.setAutoCommit(true);
            conn2.createStatement().executeUpdate("upsert into " + this.TENANT_TABLE_NAME + " values ('them','" + this.TENANT_TYPE_ID + "',1,'Long Hair')");
            conn2.createStatement().executeUpdate("upsert into " + this.TENANT_TABLE_NAME + " values ('us','" + this.TENANT_TYPE_ID + "',2,'Black Hat')");
            ResultSet rs = conn1.createStatement().executeQuery("select * from " + this.TENANT_TABLE_NAME + " where id = 1");
            Assert.assertTrue((String)"Expected 1 row in result set", (boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((Object)"Cheap Sunglasses", (Object)rs.getString(4));
            Assert.assertFalse((String)"Expected 1 row in result set", (boolean)rs.next());
            TestUtil.analyzeTable(conn2, this.TENANT_TABLE_NAME);
            rs = conn2.createStatement().executeQuery("select * from " + this.TENANT_TABLE_NAME + " where id = 2");
            Assert.assertTrue((String)"Expected 1 row in result set", (boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(3));
            Assert.assertEquals((Object)"Black Hat", (Object)rs.getString(4));
            Assert.assertFalse((String)"Expected 1 row in result set", (boolean)rs.next());
            TestUtil.analyzeTable(conn1, this.TENANT_TABLE_NAME);
            conn2.createStatement().executeUpdate("upsert into " + this.TENANT_TABLE_NAME + " select * from " + this.TENANT_TABLE_NAME);
            conn2.commit();
            rs = conn2.createStatement().executeQuery("select * from " + this.TENANT_TABLE_NAME);
            Assert.assertTrue((String)"Expected row in result set", (boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((Object)"Long Hair", (Object)rs.getString(4));
            Assert.assertTrue((String)"Expected row in result set", (boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(3));
            Assert.assertEquals((Object)"Black Hat", (Object)rs.getString(4));
            Assert.assertFalse((String)"Expected 2 rows total", (boolean)rs.next());
            conn2.setAutoCommit(true);
            conn2.createStatement().executeUpdate("upsert into " + this.TENANT_TABLE_NAME + " select 'all', tenant_type_id, id, 'Big ' || tenant_col from " + this.TENANT_TABLE_NAME);
            TestUtil.analyzeTable(conn2, this.TENANT_TABLE_NAME);
            rs = conn2.createStatement().executeQuery("select * from " + this.TENANT_TABLE_NAME);
            Assert.assertTrue((String)"Expected row in result set", (boolean)rs.next());
            Assert.assertEquals((Object)"all", (Object)rs.getString(1));
            Assert.assertEquals((Object)this.TENANT_TYPE_ID, (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((Object)"Big Long Hair", (Object)rs.getString(4));
            Assert.assertTrue((String)"Expected row in result set", (boolean)rs.next());
            Assert.assertEquals((Object)"all", (Object)rs.getString(1));
            Assert.assertEquals((Object)this.TENANT_TYPE_ID, (Object)rs.getString(2));
            Assert.assertEquals((long)2L, (long)rs.getInt(3));
            Assert.assertEquals((Object)"Big Black Hat", (Object)rs.getString(4));
            Assert.assertFalse((String)"Expected 2 rows total", (boolean)rs.next());
            rs = conn1.createStatement().executeQuery("select * from " + this.TENANT_TABLE_NAME);
            Assert.assertTrue((String)"Expected row row in result set", (boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(3));
            Assert.assertEquals((Object)"Cheap Sunglasses", (Object)rs.getString(4));
            Assert.assertTrue((String)"Expected 1 row in result set", (boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(3));
            Assert.assertEquals((Object)"Viva Las Vegas", (Object)rs.getString(4));
            List<KeyRange> splits = TestUtil.getAllSplits(conn1, this.TENANT_TABLE_NAME);
            Assert.assertEquals((long)3L, (long)splits.size());
        }
        finally {
            conn1.close();
            conn2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJoinWithGlobalTable() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(TenantSpecificTablesDMLIT.getUrl(), props);
        conn.createStatement().execute("create table foo (k INTEGER NOT NULL PRIMARY KEY)");
        conn.createStatement().execute("upsert into foo(k) values(1)");
        conn.commit();
        conn = DriverManager.getConnection(this.PHOENIX_JDBC_TENANT_SPECIFIC_URL, props);
        try {
            conn.setAutoCommit(false);
            conn.createStatement().executeUpdate("upsert into " + this.TENANT_TABLE_NAME + " (id, tenant_col) values (1, 'Cheap Sunglasses')");
            conn.createStatement().executeUpdate("upsert into " + this.TENANT_TABLE_NAME + " (id, tenant_col) values (2, 'Viva Las Vegas')");
            conn.commit();
            TestUtil.analyzeTable(conn, this.TENANT_TABLE_NAME);
            ResultSet rs = conn.createStatement().executeQuery("select tenant_col from " + this.TENANT_TABLE_NAME + " join foo on k=id");
            Assert.assertTrue((String)"Expected 1 row in result set", (boolean)rs.next());
            Assert.assertEquals((Object)"Cheap Sunglasses", (Object)rs.getString(1));
            Assert.assertFalse((String)"Expected 1 row in result set", (boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectOnlySeesTenantData() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(TenantSpecificTablesDMLIT.getUrl(), props);){
            conn.setAutoCommit(true);
            conn.createStatement().executeUpdate("delete from " + this.PARENT_TABLE_NAME);
            conn.createStatement().executeUpdate("upsert into " + this.PARENT_TABLE_NAME + " (tenant_id, tenant_type_id, id, \"user\") values ('AC/DC', 'abc', 1, 'Bon Scott')");
            conn.createStatement().executeUpdate("upsert into " + this.PARENT_TABLE_NAME + " (tenant_id, tenant_type_id, id, \"user\") values ('" + this.TENANT_ID + "', '" + this.TENANT_TYPE_ID + "', 1, 'Billy Gibbons')");
            conn.createStatement().executeUpdate("upsert into " + this.PARENT_TABLE_NAME + " (tenant_id, tenant_type_id, id, \"user\") values ('" + this.TENANT_ID + "', 'def', 1, 'Billy Gibbons')");
            conn = DriverManager.getConnection(this.PHOENIX_JDBC_TENANT_SPECIFIC_URL, props);
            ResultSet rs = conn.createStatement().executeQuery("select \"user\" from " + this.TENANT_TABLE_NAME);
            Assert.assertTrue((String)"Expected 1 row in result set", (boolean)rs.next());
            Assert.assertEquals((Object)"Billy Gibbons", (Object)rs.getString(1));
            Assert.assertFalse((String)"Expected 1 row in result set", (boolean)rs.next());
            rs = conn.createStatement().executeQuery("select count(*) from " + this.TENANT_TABLE_NAME);
            TestUtil.analyzeTable(conn, this.PARENT_TABLE_NAME);
            Assert.assertTrue((String)"Expected 1 row in result set", (boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertFalse((String)"Expected 1 row in result set", (boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteOnlyDeletesTenantData() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(TenantSpecificTablesDMLIT.getUrl(), props);){
            conn.setAutoCommit(true);
            conn.createStatement().executeUpdate("delete from " + this.PARENT_TABLE_NAME);
            conn.createStatement().executeUpdate("upsert into " + this.PARENT_TABLE_NAME + " (tenant_id, tenant_type_id, id, \"user\") values ('AC/DC', 'abc', 1, 'Bon Scott')");
            conn.createStatement().executeUpdate("upsert into " + this.PARENT_TABLE_NAME + " (tenant_id, tenant_type_id, id, \"user\") values ('" + this.TENANT_ID + "', '" + this.TENANT_TYPE_ID + "', 1, 'Billy Gibbons')");
            conn.createStatement().executeUpdate("upsert into " + this.PARENT_TABLE_NAME + " (tenant_id, tenant_type_id, id, \"user\") values ('" + this.TENANT_ID + "', 'def', 1, 'Billy Gibbons')");
            conn = DriverManager.getConnection(this.PHOENIX_JDBC_TENANT_SPECIFIC_URL, props);
            conn.setAutoCommit(true);
            int count = conn.createStatement().executeUpdate("delete from " + this.TENANT_TABLE_NAME);
            Assert.assertEquals((String)"Expected 1 row have been deleted", (long)1L, (long)count);
            ResultSet rs = conn.createStatement().executeQuery("select * from " + this.TENANT_TABLE_NAME);
            Assert.assertFalse((String)"Expected no rows in result set", (boolean)rs.next());
            conn = DriverManager.getConnection(TenantSpecificTablesDMLIT.getUrl(), props);
            TestUtil.analyzeTable(conn, this.PARENT_TABLE_NAME);
            rs = conn.createStatement().executeQuery("select count(*) from " + this.PARENT_TABLE_NAME);
            rs.next();
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteWhenImmutableIndex() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(TenantSpecificTablesDMLIT.getUrl(), props);){
            conn.setAutoCommit(true);
            conn.createStatement().executeUpdate("delete from " + this.PARENT_TABLE_NAME);
            conn.createStatement().executeUpdate("upsert into " + this.PARENT_TABLE_NAME + " (tenant_id, tenant_type_id, id, \"user\") values ('AC/DC', 'abc', 1, 'Bon Scott')");
            conn.createStatement().executeUpdate("upsert into " + this.PARENT_TABLE_NAME + " (tenant_id, tenant_type_id, id, \"user\") values ('" + this.TENANT_ID + "', '" + this.TENANT_TYPE_ID + "', 1, 'Billy Gibbons')");
            conn.createStatement().executeUpdate("upsert into " + this.PARENT_TABLE_NAME + " (tenant_id, tenant_type_id, id, \"user\") values ('" + this.TENANT_ID + "', 'def', 1, 'Billy Gibbons')");
            Connection tsConn = DriverManager.getConnection(this.PHOENIX_JDBC_TENANT_SPECIFIC_URL, props);
            tsConn.setAutoCommit(true);
            tsConn.createStatement().executeUpdate("create index idx1 on " + this.TENANT_TABLE_NAME + "(\"user\")");
            int count = tsConn.createStatement().executeUpdate("delete from " + this.TENANT_TABLE_NAME + " where \"user\"='Billy Gibbons'");
            Assert.assertEquals((String)"Expected 1 row have been deleted", (long)1L, (long)count);
            ResultSet rs = tsConn.createStatement().executeQuery("select * from " + this.TENANT_TABLE_NAME);
            Assert.assertFalse((String)"Expected no rows in result set", (boolean)rs.next());
            tsConn.close();
            TestUtil.analyzeTable(conn, this.PARENT_TABLE_NAME);
            rs = conn.createStatement().executeQuery("select count(*) from " + this.PARENT_TABLE_NAME);
            rs.next();
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteOnlyDeletesTenantDataWithNoTenantTypeId() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(TenantSpecificTablesDMLIT.getUrl(), props);){
            conn.setAutoCommit(true);
            conn.createStatement().executeUpdate("delete from " + this.PARENT_TABLE_NAME_NO_TENANT_TYPE_ID);
            conn.createStatement().executeUpdate("upsert into " + this.PARENT_TABLE_NAME_NO_TENANT_TYPE_ID + " (tenant_id, id, \"user\") values ('AC/DC', 1, 'Bon Scott')");
            conn.createStatement().executeUpdate("upsert into " + this.PARENT_TABLE_NAME_NO_TENANT_TYPE_ID + " (tenant_id, id, \"user\") values ('" + this.TENANT_ID + "', 1, 'Billy Gibbons')");
            conn.createStatement().executeUpdate("upsert into " + this.PARENT_TABLE_NAME_NO_TENANT_TYPE_ID + " (tenant_id, id, \"user\") values ('" + this.TENANT_ID + "', 2, 'Billy Gibbons')");
            Connection tsConn = DriverManager.getConnection(this.PHOENIX_JDBC_TENANT_SPECIFIC_URL, props);
            tsConn.setAutoCommit(true);
            int count = tsConn.createStatement().executeUpdate("delete from " + this.TENANT_TABLE_NAME_NO_TENANT_TYPE_ID);
            Assert.assertEquals((String)"Expected 2 rows have been deleted", (long)2L, (long)count);
            ResultSet rs = tsConn.createStatement().executeQuery("select * from " + this.TENANT_TABLE_NAME_NO_TENANT_TYPE_ID);
            Assert.assertFalse((String)"Expected no rows in result set", (boolean)rs.next());
            rs = conn.createStatement().executeQuery("select count(*) from " + this.PARENT_TABLE_NAME_NO_TENANT_TYPE_ID);
            rs.next();
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteAllTenantTableData() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(TenantSpecificTablesDMLIT.getUrl(), props);
        Connection tsConn = DriverManager.getConnection(this.PHOENIX_JDBC_TENANT_SPECIFIC_URL, props);
        try {
            conn.setAutoCommit(true);
            conn.createStatement().executeUpdate("delete from " + this.PARENT_TABLE_NAME);
            conn.createStatement().executeUpdate("upsert into " + this.PARENT_TABLE_NAME + " (tenant_id, tenant_type_id, id, \"user\") values ('AC/DC', 'abc', 1, 'Bon Scott')");
            conn.createStatement().executeUpdate("upsert into " + this.PARENT_TABLE_NAME + " (tenant_id, tenant_type_id, id, \"user\") values ('" + this.TENANT_ID + "', '" + this.TENANT_TYPE_ID + "', 1, 'Billy Gibbons')");
            conn.createStatement().executeUpdate("upsert into " + this.PARENT_TABLE_NAME + " (tenant_id, tenant_type_id, id, \"user\") values ('" + this.TENANT_ID + "', 'def', 1, 'Billy Gibbons')");
            TestUtil.analyzeTable(tsConn, this.PARENT_TABLE_NAME);
            tsConn.createStatement().execute("delete from " + this.TENANT_TABLE_NAME);
            tsConn.commit();
            ResultSet rs = conn.createStatement().executeQuery("select count(*) from " + this.PARENT_TABLE_NAME);
            rs.next();
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
        }
        finally {
            if (conn != null) {
                conn.close();
            }
            if (tsConn != null) {
                tsConn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDropTenantTableDeletesNoData() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(TenantSpecificTablesDMLIT.getUrl(), props);
        Connection tsConn = DriverManager.getConnection(this.PHOENIX_JDBC_TENANT_SPECIFIC_URL, props);
        try {
            conn.setAutoCommit(true);
            conn.createStatement().executeUpdate("delete from " + this.PARENT_TABLE_NAME_NO_TENANT_TYPE_ID);
            conn.createStatement().executeUpdate("upsert into " + this.PARENT_TABLE_NAME_NO_TENANT_TYPE_ID + " (tenant_id, id, \"user\") values ('AC/DC', 1, 'Bon Scott')");
            conn.createStatement().executeUpdate("upsert into " + this.PARENT_TABLE_NAME_NO_TENANT_TYPE_ID + " (tenant_id, id, \"user\") values ('" + this.TENANT_ID + "', 1, 'Billy Gibbons')");
            conn.createStatement().executeUpdate("upsert into " + this.PARENT_TABLE_NAME_NO_TENANT_TYPE_ID + " (tenant_id, id, \"user\") values ('" + this.TENANT_ID + "', 2, 'Billy Gibbons')");
            tsConn.createStatement().execute("drop view " + this.TENANT_TABLE_NAME_NO_TENANT_TYPE_ID);
            TestUtil.analyzeTable(conn, this.PARENT_TABLE_NAME_NO_TENANT_TYPE_ID);
            ResultSet rs = conn.createStatement().executeQuery("select count(*) from " + this.PARENT_TABLE_NAME_NO_TENANT_TYPE_ID);
            rs.next();
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
        }
        finally {
            if (conn != null) {
                conn.close();
            }
            if (tsConn != null) {
                tsConn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpsertSelectOnlyUpsertsTenantData() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(TenantSpecificTablesDMLIT.getUrl(), props);
        Connection tsConn = DriverManager.getConnection(this.PHOENIX_JDBC_TENANT_SPECIFIC_URL, props);
        try {
            conn.setAutoCommit(true);
            conn.createStatement().executeUpdate("delete from " + this.PARENT_TABLE_NAME);
            conn.createStatement().executeUpdate("upsert into " + this.PARENT_TABLE_NAME + " (tenant_id, tenant_type_id, id, \"user\") values ('AC/DC', 'aaa', 1, 'Bon Scott')");
            conn.createStatement().executeUpdate("upsert into " + this.PARENT_TABLE_NAME + " (tenant_id, tenant_type_id, id, \"user\") values ('" + this.TENANT_ID + "', '" + this.TENANT_TYPE_ID + "', 1, 'Billy Gibbons')");
            conn.createStatement().executeUpdate("upsert into " + this.PARENT_TABLE_NAME + " (tenant_id, tenant_type_id, id, \"user\") values ('" + this.TENANT_ID + "', 'def', 2, 'Billy Gibbons')");
            TestUtil.analyzeTable(tsConn, this.TENANT_TABLE_NAME);
            int count = tsConn.createStatement().executeUpdate("upsert into " + this.TENANT_TABLE_NAME + "(id, \"user\") select id+100, \"user\" from " + this.TENANT_TABLE_NAME);
            tsConn.commit();
            Assert.assertEquals((String)"Expected 1 row to have been inserted", (long)1L, (long)count);
            ResultSet rs = tsConn.createStatement().executeQuery("select count(*) from " + this.TENANT_TABLE_NAME);
            rs.next();
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
        }
        finally {
            if (conn != null) {
                conn.close();
            }
            if (tsConn != null) {
                tsConn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpsertSelectOnlyUpsertsTenantDataWithDifferentTenantTable() throws Exception {
        String anotherTableName = "V_" + TenantSpecificTablesDMLIT.generateUniqueName();
        TenantSpecificTablesDMLIT.createTestTable(this.PHOENIX_JDBC_TENANT_SPECIFIC_URL, "CREATE VIEW " + anotherTableName + " ( tenant_col VARCHAR) AS SELECT * FROM " + this.PARENT_TABLE_NAME + " WHERE tenant_type_id = 'def'");
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(TenantSpecificTablesDMLIT.getUrl(), props);
        Connection tsConn = DriverManager.getConnection(this.PHOENIX_JDBC_TENANT_SPECIFIC_URL, props);
        try {
            conn.setAutoCommit(true);
            conn.createStatement().executeUpdate("delete from " + this.PARENT_TABLE_NAME);
            conn.createStatement().executeUpdate("upsert into " + this.PARENT_TABLE_NAME + " (tenant_id, tenant_type_id, id, \"user\") values ('AC/DC', 'aaa', 1, 'Bon Scott')");
            conn.createStatement().executeUpdate("upsert into " + this.PARENT_TABLE_NAME + " (tenant_id, tenant_type_id, id, \"user\") values ('" + this.TENANT_ID + "', '" + this.TENANT_TYPE_ID + "', 1, 'Billy Gibbons')");
            conn.createStatement().executeUpdate("upsert into " + this.PARENT_TABLE_NAME + " (tenant_id, tenant_type_id, id, \"user\") values ('" + this.TENANT_ID + "', 'def', 2, 'Billy Gibbons')");
            TestUtil.analyzeTable(tsConn, this.TENANT_TABLE_NAME);
            tsConn.setAutoCommit(true);
            int count = tsConn.createStatement().executeUpdate("upsert into " + this.TENANT_TABLE_NAME + "(id, \"user\")select id+100, \"user\" from " + anotherTableName + " where id=2");
            Assert.assertEquals((String)"Expected 1 row to have been inserted", (long)1L, (long)count);
            ResultSet rs = tsConn.createStatement().executeQuery("select count(*) from " + this.TENANT_TABLE_NAME);
            rs.next();
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
        }
        finally {
            if (conn != null) {
                conn.close();
            }
            if (tsConn != null) {
                tsConn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpsertValuesOnlyUpsertsTenantData() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(this.PHOENIX_JDBC_TENANT_SPECIFIC_URL, props);){
            int count = conn.createStatement().executeUpdate("upsert into " + this.TENANT_TABLE_NAME + " (id, \"user\") values (1, 'Bon Scott')");
            conn.commit();
            Assert.assertEquals((String)"Expected 1 row to have been inserted", (long)1L, (long)count);
            ResultSet rs = conn.createStatement().executeQuery("select count(*) from " + this.TENANT_TABLE_NAME);
            rs.next();
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBaseTableCanBeUsedInStatementsInMultitenantConnections() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(this.PHOENIX_JDBC_TENANT_SPECIFIC_URL, props);){
            ResultSet rs = conn.createStatement().executeQuery("select * from " + this.PARENT_TABLE_NAME);
            Assert.assertFalse((boolean)rs.next());
            conn.createStatement().executeUpdate("upsert into " + this.PARENT_TABLE_NAME + " (tenant_type_id, id, \"user\") values ('" + this.TENANT_TYPE_ID + "', 1, 'Billy Gibbons')");
            conn.commit();
            TestUtil.analyzeTable(conn, this.PARENT_TABLE_NAME);
            rs = conn.createStatement().executeQuery("select \"user\" from " + this.PARENT_TABLE_NAME);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"Billy Gibbons");
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTenantTableCannotBeUsedInStatementsInNonMultitenantConnections() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(TenantSpecificTablesDMLIT.getUrl(), props);){
            try {
                conn.createStatement().execute("select * from " + this.TENANT_TABLE_NAME);
                Assert.fail();
            }
            catch (TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpsertValuesUsingViewWithNoWhereClause() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(this.PHOENIX_JDBC_TENANT_SPECIFIC_URL, props);){
            conn.createStatement().executeUpdate("upsert into " + this.TENANT_TABLE_NAME_NO_TENANT_TYPE_ID + " (id) values (0)");
            conn.commit();
            ResultSet rs = conn.createStatement().executeQuery("select id from " + this.TENANT_TABLE_NAME_NO_TENANT_TYPE_ID);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }
}

