/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.schema.SequenceNotFoundException;
import org.apache.phoenix.schema.TableAlreadyExistsException;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelStatsDisabledTest.class})
@RunWith(value=Parameterized.class)
public class TenantIdTypeIT
extends ParallelStatsDisabledIT {
    private final String ddl;
    private final String dataType;
    private final String tenantId;
    private final String otherTenantId;
    private final String table;
    private final String view;
    private final String sequence;

    private Connection regularConnection(String url) throws SQLException {
        return DriverManager.getConnection(url);
    }

    private Connection tenantConnection(String url) throws SQLException {
        Properties props = new Properties();
        String tenantIdProperty = this.tenantId.replaceAll("'", "");
        props.setProperty("TenantId", tenantIdProperty);
        return DriverManager.getConnection(url, props);
    }

    private Connection inconvertibleConnection(String url) throws SQLException {
        Properties props = new Properties();
        String tenantIdProperty = "ABigOlString";
        props.setProperty("TenantId", tenantIdProperty);
        return DriverManager.getConnection(url, props);
    }

    public TenantIdTypeIT(String dataType, String tenantId, String otherTenantId) {
        this.dataType = dataType;
        this.tenantId = tenantId;
        this.otherTenantId = otherTenantId;
        String tbl = TenantIdTypeIT.generateUniqueName();
        if (tbl.contains("(")) {
            tbl = tbl.substring(0, tbl.indexOf("("));
        }
        this.table = tbl;
        this.view = tbl + "view";
        this.sequence = tbl + "sequence";
        this.ddl = "create table " + this.table + " (tid " + dataType + " NOT NULL,id INTEGER NOT NULL, \nval VARCHAR CONSTRAINT pk PRIMARY KEY(tid, id)) \nMULTI_TENANT=true";
    }

    @Parameterized.Parameters(name="TenantIdTypeIT_datatype={0}")
    public static synchronized Collection<Object[]> data() {
        ArrayList testCases = Lists.newArrayList();
        testCases.add(new Object[]{"INTEGER", "2147483647", "2147483646"});
        testCases.add(new Object[]{"UNSIGNED_INT", "2147483647", "2147483646"});
        testCases.add(new Object[]{"BIGINT", "9223372036854775807", "9223372036854775806"});
        testCases.add(new Object[]{"UNSIGNED_LONG", "9223372036854775807", "9223372036854775806"});
        testCases.add(new Object[]{"TINYINT", "127", "126"});
        testCases.add(new Object[]{"UNSIGNED_TINYINT", "85", "84"});
        testCases.add(new Object[]{"SMALLINT", "32767", "32766"});
        testCases.add(new Object[]{"UNSIGNED_SMALLINT", "32767", "32766"});
        testCases.add(new Object[]{"FLOAT", "3.4028234", "3.4028232"});
        testCases.add(new Object[]{"UNSIGNED_FLOAT", "3.4028234", "3.4028232"});
        testCases.add(new Object[]{"DOUBLE", "1.7976931348623157", "1.7976931348623156"});
        testCases.add(new Object[]{"UNSIGNED_DOUBLE", "1.7976931348623157", "1.7976931348623156"});
        testCases.add(new Object[]{"DECIMAL", "3.402823466", "3.402823465"});
        testCases.add(new Object[]{"VARCHAR", "'NameOfTenant'", "'Nemesis'"});
        testCases.add(new Object[]{"CHAR(10)", "'1234567890'", "'Nemesis'"});
        return testCases;
    }

    @Test
    public void testMultiTenantTables() throws Exception {
        ResultSet rs;
        try (Connection conn = this.regularConnection(TenantIdTypeIT.getUrl());){
            conn.setAutoCommit(true);
            conn.createStatement().execute(this.ddl);
            try {
                conn.createStatement().execute(this.ddl);
                Assert.fail((String)("Table with " + this.dataType + " tenantId not created correctly"));
            }
            catch (TableAlreadyExistsException tableAlreadyExistsException) {
                // empty catch block
            }
        }
        conn = this.regularConnection(TenantIdTypeIT.getUrl());
        try {
            conn.setAutoCommit(true);
            String query = "upsert into " + this.table + " values (" + this.tenantId + ", 1 , 'valid')";
            conn.createStatement().execute("upsert into " + this.table + " values (" + this.tenantId + ", 1 , 'valid')");
            conn.createStatement().execute("upsert into " + this.table + " values (" + this.otherTenantId + ", 2 , 'invalid')");
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        conn = this.tenantConnection(TenantIdTypeIT.getUrl());
        try {
            conn.setAutoCommit(true);
            rs = conn.createStatement().executeQuery("select * from " + this.table);
            Assert.assertTrue((String)"Expected 1 row in result set", (boolean)rs.next());
            Assert.assertEquals((Object)"valid", (Object)rs.getString(2));
            Assert.assertFalse((String)"Expected 1 row in result set", (boolean)rs.next());
            try {
                conn.createStatement().executeQuery("select * from " + this.table + " where tenantId = 2");
                Assert.fail((String)"TenantId column not hidden on multi-tenant connection");
            }
            catch (SQLException ex) {
                Assert.assertEquals((long)SQLExceptionCode.COLUMN_NOT_FOUND.getErrorCode(), (long)ex.getErrorCode());
            }
            conn.createStatement().execute("create view " + this.view + " as select * from " + this.table);
            conn.createStatement().execute("create sequence " + this.sequence + " start with 100");
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        conn = this.tenantConnection(TenantIdTypeIT.getUrl());
        try {
            conn.setAutoCommit(true);
            conn.createStatement().execute("upsert into " + this.view + " values ( next value for " + this.sequence + ", 'valid')");
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        conn = this.tenantConnection(TenantIdTypeIT.getUrl());
        try {
            rs = conn.createStatement().executeQuery("select * from " + this.view);
            Assert.assertTrue((String)"Expected 2 rows in result set", (boolean)rs.next());
            Assert.assertEquals((Object)"valid", (Object)rs.getString(2));
            Assert.assertTrue((String)"Expected 2 rows in result set", (boolean)rs.next());
            Assert.assertEquals((Object)"valid", (Object)rs.getString(2));
            Assert.assertFalse((String)"Expected 2 rows in result set", (boolean)rs.next());
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        conn = this.regularConnection(TenantIdTypeIT.getUrl());
        try {
            try {
                conn.createStatement().execute("upsert into " + this.table + " values (" + this.tenantId + ", next value for " + this.sequence + ", 'valid')");
                Assert.fail();
            }
            catch (SequenceNotFoundException rs2) {
                // empty catch block
            }
            try {
                rs = conn.createStatement().executeQuery("select * from " + this.view);
                Assert.fail();
            }
            catch (SQLException ex) {
                Assert.assertEquals((long)SQLExceptionCode.TABLE_UNDEFINED.getErrorCode(), (long)ex.getErrorCode());
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        if (this.dataType != "VARCHAR" && this.dataType != "CHAR(10)") {
            conn = this.inconvertibleConnection(TenantIdTypeIT.getUrl());
            try {
                conn.setAutoCommit(true);
                conn.createStatement().execute("create view " + this.view + " as select * from " + this.table);
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
            conn = this.inconvertibleConnection(TenantIdTypeIT.getUrl());
            try {
                conn.setAutoCommit(true);
                try {
                    conn.createStatement().execute("upsert into " + this.view + " values ( 3 , 'invalid')");
                    Assert.fail();
                }
                catch (SQLException ex) {
                    Assert.assertEquals((long)SQLExceptionCode.TENANTID_IS_OF_WRONG_TYPE.getErrorCode(), (long)ex.getErrorCode());
                }
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
            conn = this.inconvertibleConnection(TenantIdTypeIT.getUrl());
            try {
                try {
                    rs = conn.createStatement().executeQuery("select * from " + this.view);
                    Assert.fail();
                }
                catch (SQLException ex) {
                    Assert.assertEquals((long)SQLExceptionCode.TENANTID_IS_OF_WRONG_TYPE.getErrorCode(), (long)ex.getErrorCode());
                }
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
    }
}

