/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.LiteralTTLExpression;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.TTLExpression;
import org.apache.phoenix.schema.TTLExpressionFactory;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelStatsDisabledTest.class})
@RunWith(value=Parameterized.class)
public class TTLAsPhoenixTTLIT
extends ParallelStatsDisabledIT {
    private static final String DDL_TEMPLATE = "CREATE TABLE IF NOT EXISTS %s ( ID INTEGER NOT NULL, COL1 INTEGER NOT NULL, COL2 bigint NOT NULL, CREATED_DATE DATE, CREATION_TIME TIME, CONSTRAINT NAME_PK PRIMARY KEY (ID, COL1, COL2))";
    private static final String DEFAULT_DDL_OPTIONS = "MULTI_TENANT=true";
    private static final int DEFAULT_TTL_FOR_TEST = 86400;
    private static final int DEFAULT_TTL_FOR_CHILD = 10000;
    private static final int DEFAULT_TTL_FOR_ALTER = 7000;
    private static final String DEFAULT_TTL_EXPRESSION = "CURRENT_TIME() - cREATION_TIME > 500";
    private static final String DEFAULT_TTL_EXPRESSION_FOR_ALTER = "CURRENT_TIME() - PHOENIX_ROW_TIMESTAMP() > 100";
    private boolean useExpression;
    private TTLExpression defaultTTL;
    private String defaultTTLDDLOption;
    private TTLExpression alterTTL;
    private String alterTTLDDLOption;

    public TTLAsPhoenixTTLIT(boolean useExpression) {
        this.useExpression = useExpression;
        this.defaultTTL = useExpression ? TTLExpressionFactory.create((String)DEFAULT_TTL_EXPRESSION) : TTLExpressionFactory.create((int)86400);
        this.defaultTTLDDLOption = useExpression ? String.format("'%s'", DEFAULT_TTL_EXPRESSION) : String.valueOf(86400);
        this.alterTTL = useExpression ? TTLExpressionFactory.create((String)DEFAULT_TTL_EXPRESSION_FOR_ALTER) : TTLExpressionFactory.create((int)7000);
        this.alterTTLDDLOption = useExpression ? String.format("'%s'", DEFAULT_TTL_EXPRESSION_FOR_ALTER) : String.valueOf(7000);
    }

    @Parameterized.Parameters(name="useExpression={0}")
    public static synchronized Collection<Boolean[]> data() {
        return Arrays.asList({false}, {true});
    }

    @Test
    public void testCreateTableWithTTL() throws Exception {
        try (Connection conn = DriverManager.getConnection(TTLAsPhoenixTTLIT.getUrl());){
            PTable table = conn.unwrap(PhoenixConnection.class).getTable(new PTableKey(null, this.createTableWithOrWithOutTTLAsItsProperty(conn, true)));
            TestUtil.assertTTLValue(conn, table, this.defaultTTL);
            Assert.assertTrue((String)"RowKeyMatcher should be Null", (Bytes.compareTo((byte[])HConstants.EMPTY_BYTE_ARRAY, (byte[])table.getRowKeyMatcher()) == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCreateTableWithNoTTL() throws Exception {
        try (Connection conn = DriverManager.getConnection(TTLAsPhoenixTTLIT.getUrl());){
            PTable table = conn.unwrap(PhoenixConnection.class).getTable(new PTableKey(null, this.createTableWithOrWithOutTTLAsItsProperty(conn, false)));
            TestUtil.assertTTLValue(conn, table, (TTLExpression)LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED);
            Assert.assertFalse((boolean)table.hasConditionalTTL());
        }
    }

    @Test
    public void testSwitchingTTLFromCondToValue() throws Exception {
        try (Connection conn = DriverManager.getConnection(TTLAsPhoenixTTLIT.getUrl());){
            String tableName = this.createTableWithOrWithOutTTLAsItsProperty(conn, true);
            PTable table = conn.unwrap(PhoenixConnection.class).getTable(new PTableKey(null, tableName));
            TestUtil.assertTTLValue(conn, table, this.defaultTTL);
            Assert.assertTrue((table.hasConditionalTTL() == this.useExpression ? 1 : 0) != 0);
            String alterTTL = this.useExpression ? String.valueOf(7000) : String.format("'%s'", DEFAULT_TTL_EXPRESSION_FOR_ALTER);
            String alterDDL = "ALTER TABLE " + tableName + " SET TTL = " + alterTTL;
            conn.createStatement().execute(alterDDL);
            LiteralTTLExpression expected = this.useExpression ? TTLExpressionFactory.create((int)7000) : TTLExpressionFactory.create((String)DEFAULT_TTL_EXPRESSION_FOR_ALTER);
            TestUtil.assertTTLValue((Connection)conn.unwrap(PhoenixConnection.class), (TTLExpression)expected, tableName);
        }
    }

    @Test
    public void testCreateTableWithTTLWithDifferentColumnFamilies() throws Exception {
        if (this.useExpression) {
            return;
        }
        String tableName = TTLAsPhoenixTTLIT.generateUniqueName();
        String ddl = "create table IF NOT EXISTS  " + tableName + "  ( id char(1) NOT NULL, col1 integer NOT NULL, b.col2 bigint, col3 bigint,  CONSTRAINT NAME_PK PRIMARY KEY (id, col1) ) TTL=86400";
        Connection conn = DriverManager.getConnection(TTLAsPhoenixTTLIT.getUrl());
        conn.createStatement().execute(ddl);
        LiteralTTLExpression expected = TTLExpressionFactory.create((int)86400);
        TestUtil.assertTTLValue((Connection)conn.unwrap(PhoenixConnection.class), (TTLExpression)expected, tableName);
        Admin admin = driver.getConnectionQueryServices(TTLAsPhoenixTTLIT.getUrl(), new Properties()).getAdmin();
        ColumnFamilyDescriptor[] columnFamilies = admin.getDescriptor(TableName.valueOf((String)tableName)).getColumnFamilies();
        Assert.assertEquals((long)86400L, (long)columnFamilies[0].getTimeToLive());
    }

    @Test
    public void testCreateAndAlterTableDDLWithForeverAndNoneTTLValues() throws Exception {
        if (this.useExpression) {
            return;
        }
        String tableName = TTLAsPhoenixTTLIT.generateUniqueName();
        String ddl = "create table IF NOT EXISTS  " + tableName + "  ( id char(1) NOT NULL, col1 integer NOT NULL, b.col2 bigint, col3 bigint,  CONSTRAINT NAME_PK PRIMARY KEY (id, col1) ) TTL=FOREVER";
        try (Connection conn = DriverManager.getConnection(TTLAsPhoenixTTLIT.getUrl());){
            conn.createStatement().execute(ddl);
            TestUtil.assertTTLValue((Connection)conn.unwrap(PhoenixConnection.class), (TTLExpression)LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED, tableName);
            ddl = "ALTER TABLE  " + tableName + " SET TTL=NONE";
            conn.createStatement().execute(ddl);
            TestUtil.assertTTLValue((Connection)conn.unwrap(PhoenixConnection.class), (TTLExpression)LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED, tableName);
            Admin admin = driver.getConnectionQueryServices(TTLAsPhoenixTTLIT.getUrl(), new Properties()).getAdmin();
            ColumnFamilyDescriptor[] columnFamilies = admin.getDescriptor(TableName.valueOf((String)tableName)).getColumnFamilies();
            Assert.assertEquals((long)Integer.MAX_VALUE, (long)columnFamilies[0].getTimeToLive());
            tableName = TTLAsPhoenixTTLIT.generateUniqueName();
            ddl = "create table IF NOT EXISTS  " + tableName + "  ( id char(1) NOT NULL, col1 integer NOT NULL, b.col2 bigint, col3 bigint,  CONSTRAINT NAME_PK PRIMARY KEY (id, col1) ) TTL=NONE";
            conn.createStatement().execute(ddl);
            TestUtil.assertTTLValue((Connection)conn.unwrap(PhoenixConnection.class), (TTLExpression)LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED, tableName);
            ddl = "ALTER TABLE  " + tableName + " SET TTL=FOREVER";
            conn.createStatement().execute(ddl);
            TestUtil.assertTTLValue((Connection)conn.unwrap(PhoenixConnection.class), (TTLExpression)LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED, tableName);
            columnFamilies = admin.getDescriptor(TableName.valueOf((String)tableName)).getColumnFamilies();
            Assert.assertEquals((long)Integer.MAX_VALUE, (long)columnFamilies[0].getTimeToLive());
        }
    }

    @Test
    public void testSettingTTLAsAlterTableCommand() throws Exception {
        try (Connection conn = DriverManager.getConnection(TTLAsPhoenixTTLIT.getUrl(), new Properties());
             PhoenixConnection pConn = conn.unwrap(PhoenixConnection.class);){
            String tableName = this.createTableWithOrWithOutTTLAsItsProperty(conn, false);
            TestUtil.assertTTLValue((Connection)conn.unwrap(PhoenixConnection.class), (TTLExpression)LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED, tableName);
            String ddl = "ALTER TABLE  " + tableName + " SET TTL = " + this.alterTTLDDLOption;
            conn.createStatement().execute(ddl);
            TestUtil.assertTTLValue((Connection)conn.unwrap(PhoenixConnection.class), this.alterTTL, tableName);
            Admin admin = driver.getConnectionQueryServices(TTLAsPhoenixTTLIT.getUrl(), new Properties()).getAdmin();
            ColumnFamilyDescriptor[] columnFamilies = admin.getDescriptor(TableName.valueOf((String)tableName)).getColumnFamilies();
            PTable pTable = pConn.getTableNoCache(tableName);
            TestUtil.assertTTLValue((Connection)conn.unwrap(PhoenixConnection.class), this.alterTTL, tableName);
        }
    }

    @Test
    public void testSettingTTLForIndexes() throws Exception {
        try (Connection conn = DriverManager.getConnection(TTLAsPhoenixTTLIT.getUrl());){
            String tableName = this.createTableWithOrWithOutTTLAsItsProperty(conn, true);
            this.createIndexOnTableOrViewProvidedWithTTL(conn, tableName, PTable.IndexType.LOCAL, false);
            this.createIndexOnTableOrViewProvidedWithTTL(conn, tableName, PTable.IndexType.GLOBAL, false);
            List indexes = PhoenixRuntime.getTable((Connection)conn, (String)tableName).getIndexes();
            for (PTable index : indexes) {
                TestUtil.assertTTLValue(conn, index, this.defaultTTL);
            }
            tableName = this.createTableWithOrWithOutTTLAsItsProperty(conn, false);
            String localIndexName = this.createIndexOnTableOrViewProvidedWithTTL(conn, tableName, PTable.IndexType.LOCAL, false);
            String globalIndexName = this.createIndexOnTableOrViewProvidedWithTTL(conn, tableName, PTable.IndexType.GLOBAL, false);
            indexes = conn.unwrap(PhoenixConnection.class).getTable(new PTableKey(null, tableName)).getIndexes();
            for (PTable index : indexes) {
                TestUtil.assertTTLValue(conn, index, (TTLExpression)LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED);
                Assert.assertTrue((Bytes.compareTo((byte[])index.getRowKeyMatcher(), (byte[])HConstants.EMPTY_BYTE_ARRAY) == 0 ? 1 : 0) != 0);
            }
            String ttl = this.useExpression ? String.format("'%s'", DEFAULT_TTL_EXPRESSION) : String.valueOf(1000);
            try {
                conn.createStatement().execute("ALTER TABLE " + localIndexName + " SET TTL = " + ttl);
                Assert.fail();
            }
            catch (SQLException sqe) {
                Assert.assertEquals((String)"Should fail with cannot set or alter property for index", (long)SQLExceptionCode.CANNOT_SET_OR_ALTER_PROPERTY_FOR_INDEX.getErrorCode(), (long)sqe.getErrorCode());
            }
            try {
                conn.createStatement().execute("ALTER TABLE " + globalIndexName + " SET TTL = " + ttl);
                Assert.fail();
            }
            catch (SQLException sqe) {
                Assert.assertEquals((String)"Should fail with cannot set or alter property for index", (long)SQLExceptionCode.CANNOT_SET_OR_ALTER_PROPERTY_FOR_INDEX.getErrorCode(), (long)sqe.getErrorCode());
            }
            try {
                this.createIndexOnTableOrViewProvidedWithTTL(conn, tableName, PTable.IndexType.LOCAL, true);
                Assert.fail();
            }
            catch (SQLException sqe) {
                Assert.assertEquals((String)"Should fail with cannot set or alter property for index", (long)SQLExceptionCode.CANNOT_SET_OR_ALTER_PROPERTY_FOR_INDEX.getErrorCode(), (long)sqe.getErrorCode());
            }
            try {
                this.createIndexOnTableOrViewProvidedWithTTL(conn, tableName, PTable.IndexType.GLOBAL, true);
                Assert.fail();
            }
            catch (SQLException sqe) {
                Assert.assertEquals((String)"Should fail with cannot set or alter property for index", (long)SQLExceptionCode.CANNOT_SET_OR_ALTER_PROPERTY_FOR_INDEX.getErrorCode(), (long)sqe.getErrorCode());
            }
        }
    }

    @Test
    public void testConditionalTTLDDL() throws Exception {
        if (!this.useExpression) {
            return;
        }
        try (Connection conn = DriverManager.getConnection(TTLAsPhoenixTTLIT.getUrl());){
            String tableName = TTLAsPhoenixTTLIT.generateUniqueName();
            String ddl = "CREATE TABLE %s (ID1 VARCHAR NOT NULL, ID2 INTEGER NOT NULL, COL1 VARCHAR, COL2 DATE CONSTRAINT PK PRIMARY KEY(ID1, ID2)) TTL = '%s'";
            try {
                conn.createStatement().execute(String.format(ddl, tableName, "ID2 = 12 OR UNKNOWN_COLUMN = 67"));
                Assert.fail((String)"Should have thrown ColumnNotFoundException");
            }
            catch (SQLException e) {
                Assert.assertTrue((boolean)(e.getCause() instanceof ColumnNotFoundException));
            }
            String ttl = "ID2 = 34 AND COL2 > CURRENT_DATE() + 1000";
            conn.createStatement().execute(String.format(ddl, tableName, ttl));
            TTLExpression expected = TTLExpressionFactory.create((String)ttl);
            TestUtil.assertTTLValue((Connection)conn.unwrap(PhoenixConnection.class), expected, tableName);
            conn.createStatement().execute(String.format("ALTER TABLE %s SET TTL=NONE", tableName));
            TestUtil.assertTTLValue((Connection)conn.unwrap(PhoenixConnection.class), (TTLExpression)LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED, tableName);
            try {
                conn.createStatement().execute(String.format("ALTER TABLE %s SET TTL='%s'", tableName, "UNKNOWN_COLUMN=67"));
                Assert.fail((String)"Alter table should have thrown ColumnNotFoundException");
            }
            catch (SQLException e) {
                Assert.assertTrue((boolean)(e.getCause() instanceof ColumnNotFoundException));
            }
            String viewName = TTLAsPhoenixTTLIT.generateUniqueName();
            ddl = "CREATE VIEW %s ( VINT SMALLINT) AS SELECT * FROM %s TTL='%s'";
            ttl = "F.ID2 = 124";
            try {
                conn.createStatement().execute(String.format(ddl, viewName, tableName, ttl));
                Assert.fail((String)"Should have thrown ColumnFamilyNotFoundException");
            }
            catch (SQLException e) {
                Assert.assertTrue((boolean)(e.getCause() instanceof ColumnFamilyNotFoundException));
            }
            ttl = "COL2 > CURRENT_DATE() + 200 AND VINT > 123";
            conn.createStatement().execute(String.format(ddl, viewName, tableName, ttl));
            expected = TTLExpressionFactory.create((String)ttl);
            TestUtil.assertTTLValue((Connection)conn.unwrap(PhoenixConnection.class), expected, viewName);
            ttl = "COL2 > CURRENT_DATE() + 500 AND VINT > 123";
            conn.createStatement().execute(String.format("ALTER VIEW %s SET TTL='%s'", viewName, ttl));
            expected = TTLExpressionFactory.create((String)ttl);
            TestUtil.assertTTLValue((Connection)conn.unwrap(PhoenixConnection.class), expected, viewName);
        }
    }

    @Test
    public void testSettingTTLForViewsOnTableWithTTL() throws Exception {
        try (Connection conn = DriverManager.getConnection(TTLAsPhoenixTTLIT.getUrl());){
            String tenantID = TTLAsPhoenixTTLIT.generateUniqueName().substring(1);
            String tenantID1 = TTLAsPhoenixTTLIT.generateUniqueName().substring(1);
            Properties props = new Properties();
            props.setProperty("TenantId", tenantID);
            Connection tenantConn = DriverManager.getConnection(TTLAsPhoenixTTLIT.getUrl(), props);
            Properties props1 = new Properties();
            props1.setProperty("TenantId", tenantID1);
            Connection tenantConn1 = DriverManager.getConnection(TTLAsPhoenixTTLIT.getUrl(), props1);
            String tableName = this.createTableWithOrWithOutTTLAsItsProperty(conn, true);
            TestUtil.assertTTLValue((Connection)conn.unwrap(PhoenixConnection.class), this.defaultTTL, tableName);
            try {
                this.createUpdatableViewOnTableWithTTL(conn, tableName, true);
                Assert.fail();
            }
            catch (SQLException sqe) {
                Assert.assertEquals((String)"Should fail with TTL already defined in hierarchy", (long)SQLExceptionCode.TTL_ALREADY_DEFINED_IN_HIERARCHY.getErrorCode(), (long)sqe.getErrorCode());
            }
            try {
                this.createReadOnlyViewOnTableWithTTL(conn, tableName, true);
                Assert.fail();
            }
            catch (SQLException sqe) {
                Assert.assertEquals((String)"Should have failed with TTL supported on Table and UpdatableView only", (long)SQLExceptionCode.TTL_SUPPORTED_FOR_TABLES_AND_VIEWS_ONLY.getErrorCode(), (long)sqe.getErrorCode());
            }
            String viewName = this.createUpdatableViewOnTableWithTTL(conn, tableName, false);
            TestUtil.assertTTLValue((Connection)conn.unwrap(PhoenixConnection.class), this.defaultTTL, viewName);
            String childView = this.createViewOnViewWithTTL(tenantConn, viewName, false);
            TestUtil.assertTTLValue((Connection)tenantConn.unwrap(PhoenixConnection.class), this.defaultTTL, childView);
            String childView1 = this.createViewOnViewWithTTL(tenantConn1, viewName, false);
            TestUtil.assertTTLValue((Connection)tenantConn1.unwrap(PhoenixConnection.class), this.defaultTTL, childView1);
            this.createIndexOnTableOrViewProvidedWithTTL(conn, viewName, PTable.IndexType.GLOBAL, false);
            this.createIndexOnTableOrViewProvidedWithTTL(conn, viewName, PTable.IndexType.LOCAL, false);
            List indexes = PhoenixRuntime.getTable((Connection)((Connection)conn.unwrap(PhoenixConnection.class)), (String)viewName).getIndexes();
            for (PTable index : indexes) {
                TestUtil.assertTTLValue(conn, index, this.defaultTTL);
            }
            this.createIndexOnTableOrViewProvidedWithTTL(conn, tableName, PTable.IndexType.GLOBAL, false);
            List tIndexes = PhoenixRuntime.getTable((Connection)((Connection)conn.unwrap(PhoenixConnection.class)), (String)tableName).getIndexes();
            for (PTable index : tIndexes) {
                TestUtil.assertTTLValue(conn, index, this.defaultTTL);
            }
        }
    }

    @Test
    public void testAlteringTTLToNONEAndThenSettingAtAnotherLevel() throws Exception {
        try (Connection conn = DriverManager.getConnection(TTLAsPhoenixTTLIT.getUrl());){
            String tenantID = TTLAsPhoenixTTLIT.generateUniqueName().substring(1);
            Properties props = new Properties();
            props.setProperty("TenantId", tenantID);
            Connection tenantConn = DriverManager.getConnection(TTLAsPhoenixTTLIT.getUrl(), props);
            String tableName = this.createTableWithOrWithOutTTLAsItsProperty(conn, true);
            TestUtil.assertTTLValue((Connection)conn.unwrap(PhoenixConnection.class), this.defaultTTL, tableName);
            try {
                this.createUpdatableViewOnTableWithTTL(conn, tableName, true);
                Assert.fail();
            }
            catch (SQLException sqe) {
                Assert.assertEquals((String)"Should fail with TTL already defined in hierarchy", (long)SQLExceptionCode.TTL_ALREADY_DEFINED_IN_HIERARCHY.getErrorCode(), (long)sqe.getErrorCode());
            }
            String ddl = "ALTER TABLE " + tableName + " SET TTL=NONE";
            conn.createStatement().execute(ddl);
            TestUtil.assertTTLValue((Connection)conn.unwrap(PhoenixConnection.class), (TTLExpression)LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED, tableName);
            String viewName = this.createUpdatableViewOnTableWithTTL(conn, tableName, true);
            TTLExpression expectedChildTTl = this.useExpression ? TTLExpressionFactory.create((String)DEFAULT_TTL_EXPRESSION) : TTLExpressionFactory.create((int)10000);
            TestUtil.assertTTLValue((Connection)conn.unwrap(PhoenixConnection.class), expectedChildTTl, viewName);
            try {
                this.createViewOnViewWithTTL(tenantConn, viewName, true);
                Assert.fail();
            }
            catch (SQLException sqe) {
                Assert.assertEquals((String)"Should fail with TTL already defined in hierarchy", (long)SQLExceptionCode.TTL_ALREADY_DEFINED_IN_HIERARCHY.getErrorCode(), (long)sqe.getErrorCode());
            }
            String ttlAlter = this.useExpression ? String.format("'%s'", DEFAULT_TTL_EXPRESSION_FOR_ALTER) : String.valueOf(7000);
            try {
                ddl = "ALTER TABLE " + tableName + " SET TTL=" + ttlAlter;
                conn.createStatement().execute(ddl);
            }
            catch (SQLException sqe) {
                Assert.assertEquals((String)"Should fail with TTL already defined in hierarchy", (long)SQLExceptionCode.TTL_ALREADY_DEFINED_IN_HIERARCHY.getErrorCode(), (long)sqe.getErrorCode());
            }
            ddl = "ALTER VIEW " + viewName + " SET TTL=NONE";
            conn.createStatement().execute(ddl);
            String childView = this.createViewOnViewWithTTL(tenantConn, viewName, true);
            TestUtil.assertTTLValue((Connection)tenantConn.unwrap(PhoenixConnection.class), expectedChildTTl, childView);
            ddl = "ALTER VIEW " + childView + " SET TTL=NONE";
            tenantConn.createStatement().execute(ddl);
            TestUtil.assertTTLValue((Connection)tenantConn.unwrap(PhoenixConnection.class), (TTLExpression)LiteralTTLExpression.TTL_EXPRESSION_NOT_DEFINED, childView);
            ddl = "ALTER VIEW " + viewName + " SET TTL=" + ttlAlter;
            conn.createStatement().execute(ddl);
            TTLExpression expectedAlterTTl = this.useExpression ? TTLExpressionFactory.create((String)DEFAULT_TTL_EXPRESSION_FOR_ALTER) : TTLExpressionFactory.create((int)7000);
            TestUtil.assertTTLValue((Connection)conn.unwrap(PhoenixConnection.class), expectedAlterTTl, viewName);
        }
    }

    @Test
    public void testAlteringTTLAtOneLevelAndCheckingAtAnotherLevel() throws Exception {
        try (Connection conn = DriverManager.getConnection(TTLAsPhoenixTTLIT.getUrl());){
            String tenantID = TTLAsPhoenixTTLIT.generateUniqueName().substring(1);
            String tenantID1 = TTLAsPhoenixTTLIT.generateUniqueName().substring(1);
            Properties props = new Properties();
            props.setProperty("TenantId", tenantID);
            Connection tenantConn = DriverManager.getConnection(TTLAsPhoenixTTLIT.getUrl(), props);
            Properties props1 = new Properties();
            props1.setProperty("TenantId", tenantID1);
            Connection tenantConn1 = DriverManager.getConnection(TTLAsPhoenixTTLIT.getUrl(), props1);
            String tableName = this.createTableWithOrWithOutTTLAsItsProperty(conn, true);
            TestUtil.assertTTLValue((Connection)conn.unwrap(PhoenixConnection.class), this.defaultTTL, tableName);
            String viewName = this.createUpdatableViewOnTableWithTTL(conn, tableName, false);
            TestUtil.assertTTLValue((Connection)conn.unwrap(PhoenixConnection.class), this.defaultTTL, viewName);
            String childView = this.createViewOnViewWithTTL(tenantConn, viewName, false);
            TestUtil.assertTTLValue((Connection)tenantConn.unwrap(PhoenixConnection.class), this.defaultTTL, childView);
            String childView1 = this.createViewOnViewWithTTL(tenantConn1, viewName, false);
            TestUtil.assertTTLValue((Connection)tenantConn1.unwrap(PhoenixConnection.class), this.defaultTTL, childView1);
            String ttlAlter = this.useExpression ? String.format("'%s'", DEFAULT_TTL_EXPRESSION_FOR_ALTER) : String.valueOf(7000);
            String alter = "ALTER TABLE " + tableName + " SET TTL = " + ttlAlter;
            conn.createStatement().execute(alter);
            TTLAsPhoenixTTLIT.clearCache(conn, null, tableName);
            TTLAsPhoenixTTLIT.clearCache(conn, null, viewName);
            TTLAsPhoenixTTLIT.clearCache(tenantConn, null, childView);
            TTLAsPhoenixTTLIT.clearCache(tenantConn1, null, childView1);
            TTLExpression expectedAlterTTl = this.useExpression ? TTLExpressionFactory.create((String)DEFAULT_TTL_EXPRESSION_FOR_ALTER) : TTLExpressionFactory.create((int)7000);
            TestUtil.assertTTLValue((Connection)conn.unwrap(PhoenixConnection.class), expectedAlterTTl, viewName);
            TestUtil.assertTTLValue((Connection)tenantConn.unwrap(PhoenixConnection.class), expectedAlterTTl, childView);
            TestUtil.assertTTLValue((Connection)tenantConn1.unwrap(PhoenixConnection.class), expectedAlterTTl, childView1);
        }
    }

    private String createTableWithOrWithOutTTLAsItsProperty(Connection conn, boolean withTTL) throws SQLException {
        String tableName = TTLAsPhoenixTTLIT.generateUniqueName();
        StringBuilder ddl = new StringBuilder();
        ddl.append(String.format(DDL_TEMPLATE, tableName));
        ddl.append(DEFAULT_DDL_OPTIONS);
        if (withTTL) {
            ddl.append(", TTL = " + this.defaultTTLDDLOption);
        }
        conn.createStatement().execute(ddl.toString());
        return tableName;
    }

    private String createIndexOnTableOrViewProvidedWithTTL(Connection conn, String baseTableOrViewName, PTable.IndexType indexType, boolean withTTL) throws SQLException {
        String ttl = this.useExpression ? String.format("'%s'", DEFAULT_TTL_EXPRESSION) : String.valueOf(10000);
        switch (indexType) {
            case LOCAL: {
                String localIndexName = baseTableOrViewName + "_Local_" + TTLAsPhoenixTTLIT.generateUniqueName();
                conn.createStatement().execute("CREATE LOCAL INDEX " + localIndexName + " ON " + baseTableOrViewName + " (COL2) INCLUDE (CREATION_TIME)" + (String)(withTTL ? "TTL = " + ttl : ""));
                return localIndexName;
            }
            case GLOBAL: {
                String globalIndexName = baseTableOrViewName + "_Global_" + TTLAsPhoenixTTLIT.generateUniqueName();
                conn.createStatement().execute("CREATE INDEX " + globalIndexName + " ON " + baseTableOrViewName + " (COL2) INCLUDE (CREATION_TIME) " + (String)(withTTL ? "TTL = " + ttl : ""));
                return globalIndexName;
            }
        }
        return baseTableOrViewName;
    }

    private String createReadOnlyViewOnTableWithTTL(Connection conn, String baseTableName, boolean withTTL) throws SQLException {
        String ttl = this.useExpression ? String.format("'%s'", DEFAULT_TTL_EXPRESSION) : String.valueOf(10000);
        String viewName = "VIEW_" + baseTableName + "_" + TTLAsPhoenixTTLIT.generateUniqueName();
        conn.createStatement().execute("CREATE VIEW " + viewName + " (" + TTLAsPhoenixTTLIT.generateUniqueName() + " SMALLINT) as select * from " + baseTableName + " where COL1 > 1 " + (String)(withTTL ? "TTL = " + ttl : ""));
        return viewName;
    }

    private String createUpdatableViewOnTableWithTTL(Connection conn, String baseTableName, boolean withTTL) throws SQLException {
        String ttl = this.useExpression ? String.format("'%s'", DEFAULT_TTL_EXPRESSION) : String.valueOf(10000);
        String viewName = "VIEW_" + baseTableName + "_" + TTLAsPhoenixTTLIT.generateUniqueName();
        conn.createStatement().execute("CREATE VIEW " + viewName + " (" + TTLAsPhoenixTTLIT.generateUniqueName() + " SMALLINT) as select * from " + baseTableName + " where COL1 = 1 " + (String)(withTTL ? "TTL = " + ttl : ""));
        return viewName;
    }

    private String createViewOnViewWithTTL(Connection conn, String parentViewName, boolean withTTL) throws SQLException {
        String ttl = this.useExpression ? String.format("'%s'", DEFAULT_TTL_EXPRESSION) : String.valueOf(10000);
        String childView = parentViewName + "_" + TTLAsPhoenixTTLIT.generateUniqueName();
        conn.createStatement().execute("CREATE VIEW " + childView + " (E BIGINT, F BIGINT) AS SELECT * FROM " + parentViewName + (String)(withTTL ? " TTL = " + ttl : ""));
        return childView;
    }

    public static void clearCache(Connection tenantConnection, String schemaName, String tableName) throws SQLException {
        PhoenixConnection currentConnection = tenantConnection.unwrap(PhoenixConnection.class);
        PName tenantIdName = currentConnection.getTenantId();
        String tenantId = tenantIdName == null ? "" : tenantIdName.getString();
        ((PhoenixConnection)currentConnection.unwrap(PhoenixConnection.class)).getQueryServices().clearTableFromCache(Bytes.toBytes((String)tenantId), schemaName == null ? ByteUtil.EMPTY_BYTE_ARRAY : Bytes.toBytes((String)schemaName), Bytes.toBytes((String)tableName), 0L);
        currentConnection.getMetaDataCache().removeTable(currentConnection.getTenantId(), String.format("%s.%s", schemaName, tableName), null, 0L);
    }
}

