/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.ipc.controller.ServerToServerRpcController;
import org.apache.phoenix.coprocessorclient.MetaDataProtocol;
import org.apache.phoenix.end2end.ConnectionQueryServicesTestImpl;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.PhoenixRegionServerEndpointTestImpl;
import org.apache.phoenix.end2end.ServerMetadataCacheTestImpl;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.UpgradeRequiredException;
import org.apache.phoenix.jdbc.ConnectionInfo;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.jdbc.PhoenixTestDriver;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.ConnectionQueryServicesImpl;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.query.QueryServices;
import org.apache.phoenix.query.QueryServicesTestImpl;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.UpgradeUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
public class SystemTablesCreationOnConnectionIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemTablesCreationOnConnectionIT.class);
    private HBaseTestingUtility testUtil = null;
    private Set<String> hbaseTables;
    private static boolean setOldTimestampToInduceUpgrade = false;
    private static int countUpgradeAttempts;
    private static int actualSysCatUpgrades;
    private static final String PHOENIX_NAMESPACE_MAPPED_SYSTEM_CATALOG = "SYSTEM:CATALOG";
    private static final String PHOENIX_SYSTEM_CATALOG = "SYSTEM.CATALOG";
    private static final String EXECUTE_UPGRADE_COMMAND = "EXECUTE UPGRADE";
    private static final String MODIFIED_MAX_VERSIONS = "5";
    private static final String CREATE_TABLE_STMT = "CREATE TABLE %s (k1 VARCHAR NOT NULL, k2 VARCHAR, CONSTRAINT PK PRIMARY KEY(K1,K2))";
    private static final String SELECT_STMT = "SELECT * FROM %s";
    private static final String DELETE_STMT = "DELETE FROM %s";
    private static final String CREATE_INDEX_STMT = "CREATE INDEX DUMMYIDX ON %s (K1) INCLUDE (K2)";
    private static final String UPSERT_STMT = "UPSERT INTO %s VALUES ('A', 'B')";
    private static final String QUERY_SYSTEM_CATALOG = "SELECT * FROM SYSTEM.CATALOG LIMIT 1";
    private static final Set<String> PHOENIX_SYSTEM_TABLES;
    private static final Set<String> PHOENIX_NAMESPACE_MAPPED_SYSTEM_TABLES;

    @BeforeClass
    public static synchronized void registerTestDriver() throws SQLException {
        DriverManager.registerDriver((Driver)((Object)new PhoenixTestDriver()));
    }

    @Before
    public void resetVariables() {
        setOldTimestampToInduceUpgrade = false;
        countUpgradeAttempts = 0;
        actualSysCatUpgrades = 0;
    }

    @After
    public synchronized void tearDownMiniCluster() {
        try {
            if (this.testUtil != null) {
                boolean isMasterAvailable = this.testUtil.getHBaseCluster().getMaster() != null;
                boolean refCountLeaked = false;
                if (isMasterAvailable) {
                    refCountLeaked = BaseTest.isAnyStoreRefCountLeaked(this.testUtil.getAdmin());
                }
                this.testUtil.shutdownMiniCluster();
                ServerMetadataCacheTestImpl.resetCache();
                this.testUtil = null;
                Assert.assertFalse((String)"refCount leaked", (boolean)refCountLeaked);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testFirstConnectionDoNotUpgradePropSet() throws Exception {
        this.startMiniClusterWithToggleNamespaceMapping(Boolean.FALSE.toString());
        Properties propsDoNotUpgradePropSet = new Properties();
        UpgradeUtil.doNotUpgradeOnFirstConnection((Properties)propsDoNotUpgradePropSet);
        PhoenixSysCatCreationTestingDriver driver = new PhoenixSysCatCreationTestingDriver(ReadOnlyProps.EMPTY_PROPS);
        driver.getConnectionQueryServices(this.getJdbcUrl(), propsDoNotUpgradePropSet);
        this.hbaseTables = this.getHBaseTables();
        Assert.assertFalse((this.hbaseTables.contains(PHOENIX_SYSTEM_CATALOG) || this.hbaseTables.contains(PHOENIX_NAMESPACE_MAPPED_SYSTEM_CATALOG) ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)this.hbaseTables.size());
        Assert.assertEquals((long)1L, (long)countUpgradeAttempts);
    }

    @Test
    public void testGetConnectionOnServer() throws Exception {
        this.startMiniClusterWithToggleNamespaceMapping(Boolean.FALSE.toString());
        this.verifyCQSIUsingAppropriateRPCContoller(true);
    }

    @Test
    public void testGetRegularConnection() throws Exception {
        this.startMiniClusterWithToggleNamespaceMapping(Boolean.FALSE.toString());
        this.verifyCQSIUsingAppropriateRPCContoller(false);
    }

    private void verifyCQSIUsingAppropriateRPCContoller(boolean isServerSideConnection) throws Exception {
        Properties serverSideProperties = new Properties();
        UpgradeUtil.doNotUpgradeOnFirstConnection((Properties)serverSideProperties);
        if (isServerSideConnection) {
            QueryUtil.setServerConnection((Properties)serverSideProperties);
        }
        PhoenixTestDriver driver = new PhoenixTestDriver(ReadOnlyProps.EMPTY_PROPS);
        ConnectionQueryServices cqsi = driver.getConnectionQueryServices(this.getJdbcUrl(), serverSideProperties);
        Assert.assertTrue((boolean)(cqsi instanceof ConnectionQueryServicesTestImpl));
        ConnectionQueryServicesTestImpl testCQSI = (ConnectionQueryServicesTestImpl)cqsi;
        if (isServerSideConnection) {
            Assert.assertTrue((boolean)(testCQSI.getController() instanceof ServerToServerRpcController));
        } else {
            Assert.assertTrue((boolean)(testCQSI.getController() instanceof ServerRpcController));
        }
        Assert.assertTrue((boolean)testCQSI.isUpgradeRequired());
        this.hbaseTables = this.getHBaseTables();
        Assert.assertFalse((this.hbaseTables.contains(PHOENIX_SYSTEM_CATALOG) || this.hbaseTables.contains(PHOENIX_NAMESPACE_MAPPED_SYSTEM_CATALOG) ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)this.hbaseTables.size());
    }

    @Ignore
    @Test
    public void testUpgradeAttempted() throws Exception {
        setOldTimestampToInduceUpgrade = true;
        PhoenixSysCatCreationTestingDriver driver = this.firstConnNSMappingServerEnabledClientEnabled();
        driver.resetCQS();
        Properties clientProps = this.getClientProperties(true, true);
        setOldTimestampToInduceUpgrade = false;
        driver.getConnectionQueryServices(this.getJdbcUrl(), clientProps);
        Assert.assertEquals(this.hbaseTables, this.getHBaseTables());
        Assert.assertEquals((long)1L, (long)countUpgradeAttempts);
        Assert.assertEquals((long)1L, (long)actualSysCatUpgrades);
    }

    @Test
    public void testUpgradeNotAllowed() throws Exception {
        setOldTimestampToInduceUpgrade = true;
        PhoenixSysCatCreationTestingDriver driver = this.firstConnNSMappingServerEnabledClientEnabled();
        driver.resetCQS();
        Properties clientProps = this.getClientProperties(true, true);
        UpgradeUtil.doNotUpgradeOnFirstConnection((Properties)clientProps);
        setOldTimestampToInduceUpgrade = false;
        try {
            driver.getConnectionQueryServices(this.getJdbcUrl(), clientProps);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof UpgradeRequiredException));
        }
        Assert.assertEquals(this.hbaseTables, this.getHBaseTables());
        Assert.assertEquals((long)1L, (long)countUpgradeAttempts);
        Assert.assertEquals((long)0L, (long)actualSysCatUpgrades);
        try (PhoenixConnection conn = driver.getConnectionQueryServices(this.getJdbcUrl(), new Properties()).connect(this.getJdbcUrl(), new Properties());
             Statement stmt = conn.createStatement();){
            stmt.execute(EXECUTE_UPGRADE_COMMAND);
            Assert.assertEquals((long)1L, (long)actualSysCatUpgrades);
        }
    }

    @Test
    public void testMigrateToSystemNamespaceAndUpgradeSysCat() throws Exception {
        setOldTimestampToInduceUpgrade = true;
        PhoenixSysCatCreationTestingDriver driver = this.firstConnNSMappingServerEnabledClientEnabledMappingDisabled();
        driver.resetCQS();
        setOldTimestampToInduceUpgrade = false;
        Properties clientProps = this.getClientProperties(true, true);
        driver.getConnectionQueryServices(this.getJdbcUrl(), clientProps);
        this.hbaseTables = this.getHBaseTables();
        Assert.assertEquals(PHOENIX_NAMESPACE_MAPPED_SYSTEM_TABLES, this.hbaseTables);
        Assert.assertEquals((long)1L, (long)countUpgradeAttempts);
        Assert.assertEquals((long)1L, (long)actualSysCatUpgrades);
    }

    @Test
    public void testTablesExistInconsistentNSMappingFails() throws Exception {
        PhoenixSysCatCreationTestingDriver driver = this.firstConnNSMappingServerEnabledClientEnabled();
        driver.resetCQS();
        Properties clientProps = this.getClientProperties(false, false);
        try {
            driver.getConnectionQueryServices(this.getJdbcUrl(), clientProps);
            Assert.fail((String)"Client should not be able to connect to cluster with inconsistent client-server namespace mapping properties");
        }
        catch (SQLException sqlE) {
            Assert.assertEquals((long)SQLExceptionCode.INCONSISTENT_NAMESPACE_MAPPING_PROPERTIES.getErrorCode(), (long)sqlE.getErrorCode());
        }
        this.hbaseTables = this.getHBaseTables();
        Assert.assertEquals(PHOENIX_NAMESPACE_MAPPED_SYSTEM_TABLES, this.hbaseTables);
        Assert.assertEquals((long)0L, (long)countUpgradeAttempts);
    }

    @Test
    public void testIncompatibleNSMappingServerEnabledConnectionFails() throws Exception {
        PhoenixSysCatCreationTestingDriver driver = this.firstConnNSMappingServerEnabledClientDisabled();
        driver.resetCQS();
        Properties clientProps = this.getClientProperties(true, true);
        try (PhoenixConnection conn = driver.getConnectionQueryServices(this.getJdbcUrl(), clientProps).connect(this.getJdbcUrl(), new Properties());){
            this.hbaseTables = this.getHBaseTables();
            Assert.assertEquals(PHOENIX_NAMESPACE_MAPPED_SYSTEM_TABLES, this.hbaseTables);
            Assert.assertEquals((long)0L, (long)countUpgradeAttempts);
            try (Statement stmt = conn.createStatement();){
                ResultSet rs = stmt.executeQuery(QUERY_SYSTEM_CATALOG);
                Assert.assertTrue((boolean)rs.next());
            }
        }
    }

    @Test
    public void testSysTablesExistNSMappingDisabled() throws Exception {
        PhoenixSysCatCreationTestingDriver driver = this.firstConnNSMappingServerDisabledClientDisabled();
        driver.resetCQS();
        Properties clientProps = this.getClientProperties(true, true);
        try {
            driver.getConnectionQueryServices(this.getJdbcUrl(), clientProps);
            Assert.fail((String)"Client should not be able to connect to cluster with inconsistent client-server namespace mapping properties");
        }
        catch (SQLException sqlE) {
            Assert.assertEquals((long)SQLExceptionCode.INCONSISTENT_NAMESPACE_MAPPING_PROPERTIES.getErrorCode(), (long)sqlE.getErrorCode());
        }
        this.hbaseTables = this.getHBaseTables();
        Assert.assertEquals(PHOENIX_SYSTEM_TABLES, this.hbaseTables);
        Assert.assertEquals((long)0L, (long)countUpgradeAttempts);
        driver.resetCQS();
        clientProps = this.getClientProperties(false, false);
        driver.getConnectionQueryServices(this.getJdbcUrl(), clientProps);
        this.hbaseTables = this.getHBaseTables();
        Assert.assertEquals(PHOENIX_SYSTEM_TABLES, this.hbaseTables);
        Assert.assertEquals((long)0L, (long)countUpgradeAttempts);
    }

    @Test
    public void testIncompatibleNSMappingServerDisabledConnectionFails() throws Exception {
        PhoenixSysCatCreationTestingDriver driver = this.firstConnNSMappingServerDisabledClientEnabled();
        driver.resetCQS();
        Properties clientProps = this.getClientProperties(false, false);
        try (PhoenixConnection conn = driver.getConnectionQueryServices(this.getJdbcUrl(), clientProps).connect(this.getJdbcUrl(), new Properties());){
            this.hbaseTables = this.getHBaseTables();
            Assert.assertEquals(PHOENIX_SYSTEM_TABLES, this.hbaseTables);
            Assert.assertEquals((long)0L, (long)countUpgradeAttempts);
            try (Statement stmt = conn.createStatement();){
                ResultSet rs = stmt.executeQuery(QUERY_SYSTEM_CATALOG);
                Assert.assertTrue((boolean)rs.next());
            }
        }
    }

    @Test
    public void testMetadataAlterRemainsAutoUpgradeDisabled() throws Exception {
        PhoenixSysCatCreationTestingDriver driver = this.firstConnAutoUpgradeToggle(false);
        Assert.assertEquals((long)Integer.parseInt(MODIFIED_MAX_VERSIONS), (long)this.verifyModifiedTableMetadata(driver));
    }

    @Test
    public void testMetadataAlterRemainsAutoUpgradeEnabled() throws Exception {
        PhoenixSysCatCreationTestingDriver driver = this.firstConnAutoUpgradeToggle(true);
        Assert.assertEquals((long)Integer.parseInt(MODIFIED_MAX_VERSIONS), (long)this.verifyModifiedTableMetadata(driver));
    }

    @Test
    public void testExecuteUpgradeSameConnWithPhoenixDriver() throws Exception {
        DriverManager.registerDriver((Driver)PhoenixDriver.INSTANCE);
        this.startMiniClusterWithToggleNamespaceMapping(Boolean.FALSE.toString());
        Properties propsDoNotUpgradeSet = new Properties();
        UpgradeUtil.doNotUpgradeOnFirstConnection((Properties)propsDoNotUpgradeSet);
        try (Connection conn = DriverManager.getConnection(this.getJdbcUrl(), propsDoNotUpgradeSet);){
            Statement stmt2;
            this.hbaseTables = this.getHBaseTables();
            Assert.assertFalse((this.hbaseTables.contains(PHOENIX_SYSTEM_CATALOG) || this.hbaseTables.contains(PHOENIX_NAMESPACE_MAPPED_SYSTEM_CATALOG) ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)this.hbaseTables.size());
            String tableName = BaseTest.generateUniqueName();
            try {
                stmt2 = conn.createStatement();
                try {
                    stmt2.execute(String.format(CREATE_TABLE_STMT, tableName));
                    Assert.fail((String)"CREATE TABLE should have failed with UpgradeRequiredException");
                }
                finally {
                    if (stmt2 != null) {
                        stmt2.close();
                    }
                }
            }
            catch (UpgradeRequiredException stmt2) {
                // empty catch block
            }
            try {
                stmt2 = conn.createStatement();
                try {
                    stmt2.execute(String.format(SELECT_STMT, tableName));
                    Assert.fail((String)"SELECT should have failed with UpgradeRequiredException");
                }
                finally {
                    if (stmt2 != null) {
                        stmt2.close();
                    }
                }
            }
            catch (UpgradeRequiredException stmt3) {
                // empty catch block
            }
            try {
                stmt2 = conn.createStatement();
                try {
                    stmt2.execute(String.format(DELETE_STMT, tableName));
                    Assert.fail((String)"DELETE should have failed with UpgradeRequiredException");
                }
                finally {
                    if (stmt2 != null) {
                        stmt2.close();
                    }
                }
            }
            catch (UpgradeRequiredException stmt4) {
                // empty catch block
            }
            try {
                stmt2 = conn.createStatement();
                try {
                    stmt2.execute(String.format(CREATE_INDEX_STMT, tableName));
                    Assert.fail((String)"CREATE INDEX should have failed with UpgradeRequiredException");
                }
                finally {
                    if (stmt2 != null) {
                        stmt2.close();
                    }
                }
            }
            catch (UpgradeRequiredException stmt5) {
                // empty catch block
            }
            try {
                stmt2 = conn.createStatement();
                try {
                    stmt2.execute(String.format(UPSERT_STMT, tableName));
                    Assert.fail((String)"UPSERT VALUES should have failed with UpgradeRequiredException");
                }
                finally {
                    if (stmt2 != null) {
                        stmt2.close();
                    }
                }
            }
            catch (UpgradeRequiredException stmt6) {
                // empty catch block
            }
            stmt2 = conn.createStatement();
            try {
                stmt2.execute(EXECUTE_UPGRADE_COMMAND);
            }
            finally {
                if (stmt2 != null) {
                    stmt2.close();
                }
            }
            this.hbaseTables = this.getHBaseTables();
            Assert.assertEquals(PHOENIX_SYSTEM_TABLES, this.hbaseTables);
            stmt2 = conn.createStatement();
            try {
                stmt2.execute(String.format(CREATE_TABLE_STMT, tableName));
            }
            finally {
                if (stmt2 != null) {
                    stmt2.close();
                }
            }
            stmt2 = conn.createStatement();
            try {
                stmt2.execute(String.format(SELECT_STMT, tableName));
            }
            finally {
                if (stmt2 != null) {
                    stmt2.close();
                }
            }
            stmt2 = conn.createStatement();
            try {
                stmt2.execute(String.format(DELETE_STMT, tableName));
            }
            finally {
                if (stmt2 != null) {
                    stmt2.close();
                }
            }
            stmt2 = conn.createStatement();
            try {
                stmt2.execute(String.format(CREATE_INDEX_STMT, tableName));
            }
            finally {
                if (stmt2 != null) {
                    stmt2.close();
                }
            }
            stmt2 = conn.createStatement();
            try {
                stmt2.execute(String.format(UPSERT_STMT, tableName));
            }
            finally {
                if (stmt2 != null) {
                    stmt2.close();
                }
            }
        }
    }

    @Test
    public void testSysMutexHasCorrectTTL() throws Exception {
        DriverManager.registerDriver((Driver)PhoenixDriver.INSTANCE);
        this.startMiniClusterWithToggleNamespaceMapping(Boolean.FALSE.toString());
        try (Connection ignored = DriverManager.getConnection(this.getJdbcUrl());
             Admin admin = this.testUtil.getAdmin();){
            TableDescriptor htd = admin.getDescriptor(PhoenixDatabaseMetaData.SYSTEM_MUTEX_HBASE_TABLE_NAME);
            ColumnFamilyDescriptor hColDesc = htd.getColumnFamily(PhoenixDatabaseMetaData.SYSTEM_MUTEX_FAMILY_NAME_BYTES);
            Assert.assertEquals((String)"Did not find the correct TTL for SYSTEM.MUTEX", (long)900L, (long)hColDesc.getTimeToLive());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDoNotUpgradePropSet() throws Exception {
        String tableName = "HBASE_SYNTH_TEST";
        this.startMiniClusterWithToggleNamespaceMapping(Boolean.FALSE.toString());
        Properties propsDoNotUpgradePropSet = new Properties();
        try (Connection con1 = DriverManager.getConnection(this.getJdbcUrl(), propsDoNotUpgradePropSet);
             Statement stmt1 = con1.createStatement();){
            String ddl = "CREATE TABLE " + tableName + " (PK1 VARCHAR not null, PK2 VARCHAR not null, COL1 varchar, COL2 varchar CONSTRAINT pk PRIMARY KEY(PK1,PK2))";
            stmt1.execute(ddl);
            stmt1.execute("UPSERT INTO " + tableName + " values ('pk1','pk2','c1','c2')");
            con1.commit();
            this.testUtil.getMiniHBaseCluster().getMaster().stopMaster();
            UpgradeUtil.doNotUpgradeOnFirstConnection((Properties)propsDoNotUpgradePropSet);
            try (Connection con2 = DriverManager.getConnection(this.getJdbcUrl(), propsDoNotUpgradePropSet);
                 Statement stmt2 = con2.createStatement();
                 ResultSet rs = stmt2.executeQuery("select * from " + tableName);){
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"pk1", (Object)rs.getString(1));
                Assert.assertEquals((Object)"pk2", (Object)rs.getString(2));
                Assert.assertFalse((boolean)rs.next());
            }
        }
        finally {
            this.testUtil.getMiniHBaseCluster().startMaster();
        }
    }

    private Set<String> getHBaseTables() throws IOException {
        HashSet<String> tables = new HashSet<String>();
        for (TableName tn : this.testUtil.getAdmin().listTableNames()) {
            tables.add(tn.getNameAsString());
        }
        return tables;
    }

    private boolean isSystemNamespaceCreated() throws IOException {
        try {
            this.testUtil.getAdmin().getNamespaceDescriptor("SYSTEM");
        }
        catch (NamespaceNotFoundException ex) {
            return false;
        }
        return true;
    }

    private int verifyModifiedTableMetadata(PhoenixSysCatCreationTestingDriver driver) throws Exception {
        try (PhoenixConnection conn = driver.getConnectionQueryServices(this.getJdbcUrl(), new Properties()).connect(this.getJdbcUrl(), new Properties());
             Statement stmt = conn.createStatement();){
            stmt.execute("ALTER TABLE SYSTEM.CATALOG SET VERSIONS = 5");
        }
        driver.resetCQS();
        PhoenixConnection ignored = driver.getConnectionQueryServices(this.getJdbcUrl(), new Properties()).connect(this.getJdbcUrl(), new Properties());
        if (ignored != null) {
            ignored.close();
        }
        TableDescriptor descriptor = this.testUtil.getAdmin().getDescriptor(TableName.valueOf((String)PHOENIX_SYSTEM_CATALOG));
        return descriptor.getColumnFamily(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES).getMaxVersions();
    }

    private void startMiniClusterWithToggleNamespaceMapping(String isNamespaceMappingEnabled) throws Exception {
        this.testUtil = new HBaseTestingUtility();
        Configuration conf = this.testUtil.getConfiguration();
        conf.set("phoenix.schema.isNamespaceMappingEnabled", isNamespaceMappingEnabled);
        conf.setInt("hbase.master.info.port", -1);
        conf.set("hbase.coprocessor.regionserver.classes", PhoenixRegionServerEndpointTestImpl.class.getName());
        this.testUtil.startMiniCluster(1);
    }

    private String getJdbcUrl() {
        return "jdbc:phoenix:localhost:" + this.testUtil.getZkCluster().getClientPort() + ":/hbase";
    }

    private Properties getClientProperties(boolean nsMappingEnabled, boolean systemTableMappingEnabled) {
        Properties clientProps = new Properties();
        clientProps.setProperty("phoenix.schema.isNamespaceMappingEnabled", Boolean.valueOf(nsMappingEnabled).toString());
        clientProps.setProperty("phoenix.schema.mapSystemTablesToNamespace", Boolean.valueOf(systemTableMappingEnabled).toString());
        return clientProps;
    }

    private PhoenixSysCatCreationTestingDriver firstConnAutoUpgradeToggle(boolean isAutoUpgradeEnabled) throws Exception {
        if (isAutoUpgradeEnabled) {
            return this.firstConnNSMappingServerDisabledClientDisabled();
        }
        return this.firstConnAutoUpgradeDisabled();
    }

    private PhoenixSysCatCreationTestingDriver firstConnAutoUpgradeDisabled() throws Exception {
        this.startMiniClusterWithToggleNamespaceMapping(Boolean.FALSE.toString());
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("phoenix.autoupgrade.enabled", Boolean.FALSE.toString());
        ReadOnlyProps readOnlyProps = new ReadOnlyProps(props);
        PhoenixSysCatCreationTestingDriver driver = new PhoenixSysCatCreationTestingDriver(readOnlyProps);
        try (PhoenixConnection conn = driver.getConnectionQueryServices(this.getJdbcUrl(), new Properties()).connect(this.getJdbcUrl(), new Properties());){
            this.hbaseTables = this.getHBaseTables();
            Assert.assertFalse((this.hbaseTables.contains(PHOENIX_SYSTEM_CATALOG) || this.hbaseTables.contains(PHOENIX_NAMESPACE_MAPPED_SYSTEM_CATALOG) ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)this.hbaseTables.size());
            Assert.assertEquals((long)1L, (long)countUpgradeAttempts);
            try (Statement stmt = conn.createStatement();){
                stmt.execute(EXECUTE_UPGRADE_COMMAND);
            }
        }
        this.hbaseTables = this.getHBaseTables();
        Assert.assertEquals(PHOENIX_SYSTEM_TABLES, this.hbaseTables);
        return driver;
    }

    private PhoenixSysCatCreationTestingDriver firstConnNSMappingServerEnabledClientEnabled() throws Exception {
        this.startMiniClusterWithToggleNamespaceMapping(Boolean.TRUE.toString());
        Properties clientProps = this.getClientProperties(true, true);
        PhoenixSysCatCreationTestingDriver driver = new PhoenixSysCatCreationTestingDriver(ReadOnlyProps.EMPTY_PROPS);
        driver.getConnectionQueryServices(this.getJdbcUrl(), clientProps);
        this.hbaseTables = this.getHBaseTables();
        Assert.assertEquals(PHOENIX_NAMESPACE_MAPPED_SYSTEM_TABLES, this.hbaseTables);
        Assert.assertEquals((long)0L, (long)countUpgradeAttempts);
        Assert.assertTrue((boolean)this.isSystemNamespaceCreated());
        return driver;
    }

    private PhoenixSysCatCreationTestingDriver firstConnNSMappingServerEnabledClientEnabledMappingDisabled() throws Exception {
        this.startMiniClusterWithToggleNamespaceMapping(Boolean.TRUE.toString());
        Properties clientProps = this.getClientProperties(true, false);
        PhoenixSysCatCreationTestingDriver driver = new PhoenixSysCatCreationTestingDriver(ReadOnlyProps.EMPTY_PROPS);
        driver.getConnectionQueryServices(this.getJdbcUrl(), clientProps);
        this.hbaseTables = this.getHBaseTables();
        Assert.assertEquals(PHOENIX_SYSTEM_TABLES, this.hbaseTables);
        Assert.assertEquals((long)0L, (long)countUpgradeAttempts);
        Assert.assertFalse((boolean)this.isSystemNamespaceCreated());
        return driver;
    }

    private PhoenixSysCatCreationTestingDriver firstConnNSMappingServerEnabledClientDisabled() throws Exception {
        this.startMiniClusterWithToggleNamespaceMapping(Boolean.TRUE.toString());
        Properties clientProps = this.getClientProperties(false, false);
        PhoenixSysCatCreationTestingDriver driver = new PhoenixSysCatCreationTestingDriver(ReadOnlyProps.EMPTY_PROPS);
        try {
            driver.getConnectionQueryServices(this.getJdbcUrl(), clientProps);
            Assert.fail((String)"Client should not be able to connect to cluster with inconsistent client-server namespace mapping properties");
        }
        catch (SQLException sqlE) {
            Assert.assertEquals((long)SQLExceptionCode.INCONSISTENT_NAMESPACE_MAPPING_PROPERTIES.getErrorCode(), (long)sqlE.getErrorCode());
        }
        this.hbaseTables = this.getHBaseTables();
        Assert.assertEquals((long)0L, (long)this.hbaseTables.size());
        Assert.assertEquals((long)0L, (long)countUpgradeAttempts);
        return driver;
    }

    private PhoenixSysCatCreationTestingDriver firstConnNSMappingServerDisabledClientEnabled() throws Exception {
        this.startMiniClusterWithToggleNamespaceMapping(Boolean.FALSE.toString());
        Properties clientProps = this.getClientProperties(true, true);
        PhoenixSysCatCreationTestingDriver driver = new PhoenixSysCatCreationTestingDriver(ReadOnlyProps.EMPTY_PROPS);
        try {
            driver.getConnectionQueryServices(this.getJdbcUrl(), clientProps);
            Assert.fail((String)"Client should not be able to connect to cluster with inconsistent client-server namespace mapping properties");
        }
        catch (SQLException sqlE) {
            Assert.assertEquals((long)SQLExceptionCode.INCONSISTENT_NAMESPACE_MAPPING_PROPERTIES.getErrorCode(), (long)sqlE.getErrorCode());
        }
        this.hbaseTables = this.getHBaseTables();
        Assert.assertEquals((long)0L, (long)this.hbaseTables.size());
        Assert.assertEquals((long)0L, (long)countUpgradeAttempts);
        Assert.assertFalse((boolean)this.isSystemNamespaceCreated());
        return driver;
    }

    private PhoenixSysCatCreationTestingDriver firstConnNSMappingServerDisabledClientDisabled() throws Exception {
        this.startMiniClusterWithToggleNamespaceMapping(Boolean.FALSE.toString());
        Properties clientProps = this.getClientProperties(false, false);
        PhoenixSysCatCreationTestingDriver driver = new PhoenixSysCatCreationTestingDriver(ReadOnlyProps.EMPTY_PROPS);
        driver.getConnectionQueryServices(this.getJdbcUrl(), clientProps);
        this.hbaseTables = this.getHBaseTables();
        Assert.assertEquals(PHOENIX_SYSTEM_TABLES, this.hbaseTables);
        Assert.assertEquals((long)0L, (long)countUpgradeAttempts);
        Assert.assertFalse((boolean)this.isSystemNamespaceCreated());
        return driver;
    }

    static {
        PHOENIX_SYSTEM_TABLES = new HashSet<String>(Arrays.asList(PHOENIX_SYSTEM_CATALOG, "SYSTEM.SEQUENCE", "SYSTEM.STATS", "SYSTEM.FUNCTION", "SYSTEM.MUTEX", "SYSTEM.LOG", "SYSTEM.CHILD_LINK", "SYSTEM.TASK", "SYSTEM.TRANSFORM", "SYSTEM.CDC_STREAM_STATUS", "SYSTEM.CDC_STREAM"));
        PHOENIX_NAMESPACE_MAPPED_SYSTEM_TABLES = new HashSet<String>(Arrays.asList(PHOENIX_NAMESPACE_MAPPED_SYSTEM_CATALOG, "SYSTEM:SEQUENCE", "SYSTEM:STATS", "SYSTEM:FUNCTION", "SYSTEM:MUTEX", "SYSTEM:LOG", "SYSTEM:CHILD_LINK", "SYSTEM:TASK", "SYSTEM:TRANSFORM", "SYSTEM:CDC_STREAM_STATUS", "SYSTEM:CDC_STREAM"));
    }

    public static class PhoenixSysCatCreationTestingDriver
    extends PhoenixTestDriver {
        private ConnectionQueryServices cqs;
        private final ReadOnlyProps overrideProps;

        PhoenixSysCatCreationTestingDriver(ReadOnlyProps props) {
            this.overrideProps = props;
        }

        @Override
        public synchronized ConnectionQueryServices getConnectionQueryServices(String url, Properties info) throws SQLException {
            QueryServicesTestImpl qsti = new QueryServicesTestImpl(this.getDefaultProps(), this.overrideProps);
            if (this.cqs == null) {
                this.cqs = new PhoenixSysCatCreationServices((QueryServices)qsti, ConnectionInfo.create((String)url, (ReadOnlyProps)qsti.getProps(), (Properties)info), info);
                this.cqs.init(url, info);
            }
            return this.cqs;
        }

        void resetCQS() {
            this.cqs = null;
        }
    }

    private static class PhoenixSysCatCreationServices
    extends ConnectionQueryServicesImpl {
        PhoenixSysCatCreationServices(QueryServices services, ConnectionInfo connectionInfo, Properties info) {
            super(services, connectionInfo, info);
        }

        protected void setUpgradeRequired() {
            super.setUpgradeRequired();
            ++countUpgradeAttempts;
        }

        protected long getSystemTableVersion() {
            if (setOldTimestampToInduceUpgrade) {
                return MetaDataProtocol.getPriorUpgradeVersion();
            }
            return 42L;
        }

        protected PhoenixConnection upgradeSystemCatalogIfRequired(PhoenixConnection metaConnection, long currentServerSideTableTimeStamp) throws InterruptedException, SQLException, TimeoutException, IOException {
            PhoenixConnection newMetaConnection = super.upgradeSystemCatalogIfRequired(metaConnection, currentServerSideTableTimeStamp);
            if (currentServerSideTableTimeStamp < 42L) {
                ++actualSysCatUpgrades;
            }
            return newMetaConnection;
        }
    }
}

