/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class SumFunctionIT
extends ParallelStatsDisabledIT {
    @Test
    public void testSumFunctionWithCaseWhenStatement() throws Exception {
        String tableName = SumFunctionIT.generateUniqueName();
        try (Connection c = DriverManager.getConnection(SumFunctionIT.getUrl());
             Statement s = c.createStatement();){
            s.execute("create table " + tableName + " (id varchar primary key, col1 varchar, col2 integer)");
            s.execute("upsert into " + tableName + " values('id1', 'aaa', 2)");
            s.execute("upsert into " + tableName + " values('id2', null, 1)");
            c.commit();
            try (ResultSet rs = s.executeQuery("select sum(case when col1 is null then col2 else 0 end), sum(case when col1 is not null then col2 else 0 end) from " + tableName);){
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)rs.getInt(1), (long)1L);
                Assert.assertEquals((long)rs.getInt(2), (long)2L);
                Assert.assertFalse((boolean)rs.next());
            }
        }
    }
}

