/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.schema.types.PhoenixArray;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class StringToArrayFunctionIT
extends ParallelStatsDisabledIT {
    private String tableName;

    @Before
    public void initTables() throws Exception {
        this.tableName = StringToArrayFunctionIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(StringToArrayFunctionIT.getUrl());){
            String ddl = "CREATE TABLE " + this.tableName + " (region_name VARCHAR PRIMARY KEY, string1 VARCHAR, string2 CHAR(50), delimiter1 VARCHAR, delimiter2 CHAR(20), nullstring1 VARCHAR, nullstring2 CHAR(20))";
            conn.createStatement().execute(ddl);
            String dml = "UPSERT INTO " + this.tableName + "(region_name, string1, string2, delimiter1, delimiter2, nullstring1, nullstring2) VALUES('SF Bay Area','a,b,c,d','1.2.3.4',',','.','c','3')";
            PreparedStatement stmt = conn.prepareStatement(dml);
            stmt.execute();
            conn.commit();
        }
    }

    @Test
    public void testStringToArrayFunction1() throws Exception {
        Connection conn = DriverManager.getConnection(StringToArrayFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT STRING_TO_ARRAY(string1, delimiter1) FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, new Object[]{"a", "b", "c", "d"});
        Assert.assertEquals((Object)expected, (Object)rs.getArray(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testStringToArrayFunction2() throws Exception {
        Connection conn = DriverManager.getConnection(StringToArrayFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT STRING_TO_ARRAY(string1, delimiter1, nullstring1) FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, new Object[]{"a", "b", null, "d"});
        Assert.assertEquals((Object)expected, (Object)rs.getArray(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testStringToArrayFunction3() throws Exception {
        Connection conn = DriverManager.getConnection(StringToArrayFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT STRING_TO_ARRAY(string1, delimiter1, 'a') FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, new Object[]{null, "b", "c", "d"});
        Assert.assertEquals((Object)expected, (Object)rs.getArray(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testStringToArrayFunction4() throws Exception {
        Connection conn = DriverManager.getConnection(StringToArrayFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT STRING_TO_ARRAY(string1, delimiter1, 'd') FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, new Object[]{"a", "b", "c", null});
        Assert.assertEquals((Object)expected, (Object)rs.getArray(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testStringToArrayFunction5() throws Exception {
        Connection conn = DriverManager.getConnection(StringToArrayFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT STRING_TO_ARRAY(string2, delimiter2) FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, new Object[]{"1", "2", "3", "4"});
        Assert.assertEquals((Object)expected, (Object)rs.getArray(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testStringToArrayFunction6() throws Exception {
        Connection conn = DriverManager.getConnection(StringToArrayFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT STRING_TO_ARRAY(string2, delimiter2, nullstring2) FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, new Object[]{"1", "2", null, "4"});
        Assert.assertEquals((Object)expected, (Object)rs.getArray(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testStringToArrayFunction7() throws Exception {
        Connection conn = DriverManager.getConnection(StringToArrayFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT STRING_TO_ARRAY(string2, delimiter2, '1') FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, new Object[]{null, "2", "3", "4"});
        Assert.assertEquals((Object)expected, (Object)rs.getArray(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testStringToArrayFunction8() throws Exception {
        Connection conn = DriverManager.getConnection(StringToArrayFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT STRING_TO_ARRAY(string2, delimiter2, '4') FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, new Object[]{"1", "2", "3", null});
        Assert.assertEquals((Object)expected, (Object)rs.getArray(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testStringToArrayFunction9() throws Exception {
        Connection conn = DriverManager.getConnection(StringToArrayFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT STRING_TO_ARRAY(region_name, ' ', '4') FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, new Object[]{"SF", "Bay", "Area"});
        Assert.assertEquals((Object)expected, (Object)rs.getArray(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testStringToArrayFunction10() throws Exception {
        Connection conn = DriverManager.getConnection(StringToArrayFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT STRING_TO_ARRAY('hello,hello,hello', delimiter1) FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, new Object[]{"hello", "hello", "hello"});
        Assert.assertEquals((Object)expected, (Object)rs.getArray(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testStringToArrayFunction11() throws Exception {
        Connection conn = DriverManager.getConnection(StringToArrayFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT STRING_TO_ARRAY('a,hello,hello,hello,b', ',', 'hello') FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, new Object[]{"a", null, null, null, "b"});
        Assert.assertEquals((Object)expected, (Object)rs.getArray(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testStringToArrayFunction12() throws Exception {
        Connection conn = DriverManager.getConnection(StringToArrayFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT STRING_TO_ARRAY('b.a.b', delimiter2, 'b') FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, new Object[]{null, "a", null});
        Assert.assertEquals((Object)expected, (Object)rs.getArray(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testStringToArrayFunctionWithNestedFunctions1() throws Exception {
        Connection conn = DriverManager.getConnection(StringToArrayFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT ARRAY_LENGTH(STRING_TO_ARRAY('a, b, c', ', ')) FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)3L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testStringToArrayFunctionWithNestedFunctions2() throws Exception {
        Connection conn = DriverManager.getConnection(StringToArrayFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT STRING_TO_ARRAY(ARRAY_TO_STRING(ARRAY['a', 'b', 'c'], delimiter2), delimiter2, 'b') FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, new Object[]{"a", null, "c"});
        Assert.assertEquals((Object)expected, (Object)rs.getArray(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testStringToArrayFunctionWithNestedFunctions3() throws Exception {
        Connection conn = DriverManager.getConnection(StringToArrayFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT STRING_TO_ARRAY(ARRAY_TO_STRING(ARRAY['a', 'b', 'c'], delimiter2), ARRAY_ELEM(ARRAY[',', '.'], 2), 'b') FROM " + this.tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, new Object[]{"a", null, "c"});
        Assert.assertEquals((Object)expected, (Object)rs.getArray(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testStringToArrayFunctionWithUpsert1() throws Exception {
        Connection conn = DriverManager.getConnection(StringToArrayFunctionIT.getUrl());
        String tableName = StringToArrayFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + " (region_name VARCHAR PRIMARY KEY,varchars VARCHAR[])";
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + "(region_name,varchars) VALUES('SF Bay Area', STRING_TO_ARRAY('hello, world, :-)', ', '))";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT varchars FROM " + tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, new Object[]{"hello", "world", ":-)"});
        Assert.assertEquals((Object)expected, (Object)rs.getArray(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testStringToArrayFunctionWithUpsert2() throws Exception {
        Connection conn = DriverManager.getConnection(StringToArrayFunctionIT.getUrl());
        String tableName = StringToArrayFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + " (region_name VARCHAR PRIMARY KEY,varchars VARCHAR[])";
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + "(region_name,varchars) VALUES('SF Bay Area', STRING_TO_ARRAY('a, b, -, c', ', ', '-'))";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT varchars FROM " + tableName + " WHERE region_name = 'SF Bay Area'");
        Assert.assertTrue((boolean)rs.next());
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, new Object[]{"a", "b", null, "c"});
        Assert.assertEquals((Object)expected, (Object)rs.getArray(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testStringToArrayFunctionWithUpsertSelect1() throws Exception {
        Connection conn = DriverManager.getConnection(StringToArrayFunctionIT.getUrl());
        String table1 = StringToArrayFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + table1 + " (region_name VARCHAR PRIMARY KEY, varchar VARCHAR)";
        conn.createStatement().execute(ddl);
        String table2 = StringToArrayFunctionIT.generateUniqueName();
        ddl = "CREATE TABLE " + table2 + " (region_name VARCHAR PRIMARY KEY, varchars VARCHAR[])";
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + table1 + "(region_name, varchar) VALUES('SF Bay Area', 'a,b,c,d')";
        conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + table1 + "(region_name, varchar) VALUES('SF Bay Area2', '1,2,3,4')";
        conn.createStatement().execute(dml);
        conn.commit();
        dml = "UPSERT INTO " + table2 + "(region_name, varchars) SELECT region_name, STRING_TO_ARRAY(varchar, ',') FROM " + table1;
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT varchars FROM " + table2);
        Assert.assertTrue((boolean)rs.next());
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, new Object[]{"a", "b", "c", "d"});
        Assert.assertEquals((Object)expected, (Object)rs.getArray(1));
        Assert.assertTrue((boolean)rs.next());
        expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, new Object[]{"1", "2", "3", "4"});
        Assert.assertEquals((Object)expected, (Object)rs.getArray(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testStringToArrayFunctionWithUpsertSelect2() throws Exception {
        Connection conn = DriverManager.getConnection(StringToArrayFunctionIT.getUrl());
        String sourceTable = StringToArrayFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + sourceTable + " (region_name VARCHAR PRIMARY KEY, varchar VARCHAR)";
        conn.createStatement().execute(ddl);
        String targetTable = StringToArrayFunctionIT.generateUniqueName();
        ddl = "CREATE TABLE " + targetTable + " (region_name VARCHAR PRIMARY KEY, varchars VARCHAR[])";
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + sourceTable + "(region_name, varchar) VALUES('SF Bay Area', 'a,b,-,c,d')";
        conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + sourceTable + "(region_name, varchar) VALUES('SF Bay Area2', '1,2,-,3,4')";
        conn.createStatement().execute(dml);
        conn.commit();
        dml = "UPSERT INTO " + targetTable + "(region_name, varchars) SELECT region_name, STRING_TO_ARRAY(varchar, ',', '-') FROM " + sourceTable;
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT varchars FROM " + targetTable);
        Assert.assertTrue((boolean)rs.next());
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, new Object[]{"a", "b", null, "c", "d"});
        Assert.assertEquals((Object)expected, (Object)rs.getArray(1));
        Assert.assertTrue((boolean)rs.next());
        expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, new Object[]{"1", "2", null, "3", "4"});
        Assert.assertEquals((Object)expected, (Object)rs.getArray(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testStringToArrayFunctionInWhere1() throws Exception {
        Connection conn = DriverManager.getConnection(StringToArrayFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT region_name FROM " + this.tableName + " WHERE ARRAY['a', 'b', 'c', 'd']=STRING_TO_ARRAY(string1, delimiter1)");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"SF Bay Area", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testStringToArrayFunctionInWhere2() throws Exception {
        Connection conn = DriverManager.getConnection(StringToArrayFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT region_name FROM " + this.tableName + " WHERE 'a'=ANY(STRING_TO_ARRAY(string1, delimiter1))");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"SF Bay Area", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testStringToArrayFunctionInWhere3() throws Exception {
        Connection conn = DriverManager.getConnection(StringToArrayFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT region_name FROM " + this.tableName + " WHERE 'a'=ALL(STRING_TO_ARRAY('a,a,a,', delimiter1))");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"SF Bay Area", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }
}

