/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class StringIT
extends ParallelStatsDisabledIT {
    private void testLpadHelper(Connection conn, String colName, int length, List<String> fillStringList, List<String> expectedOutputList, String tableName, String sortOrder) throws Exception {
        Assert.assertEquals((String)"fillStringList and expectedOutputList should be of equal size", (long)fillStringList.size(), (long)expectedOutputList.size());
        for (int id = 0; id < fillStringList.size(); ++id) {
            String fillString = fillStringList.get(id);
            String lPadExpr = fillString != null ? "LPAD(%s,?,?)" : "LPAD(%s,?)";
            String sql = String.format("SELECT " + lPadExpr + " FROM " + tableName + "_%s WHERE id=?", colName, sortOrder);
            PreparedStatement stmt = conn.prepareStatement(sql);
            int index = 1;
            stmt.setInt(index++, length);
            if (fillString != null) {
                stmt.setString(index++, fillString);
            }
            stmt.setInt(index++, id);
            ResultSet rs = stmt.executeQuery();
            Assert.assertTrue((String)"Expected exactly one row to be returned ", (boolean)rs.next());
            Assert.assertEquals((String)"LPAD returned incorrect result ", (Object)expectedOutputList.get(id), (Object)rs.getString(1));
            Assert.assertFalse((String)"Expected exactly one row to be returned ", (boolean)rs.next());
        }
    }

    private void testLpad(Connection conn, List<String> inputList, int length, List<String> fillStringList, String colName, List<String> expectedOutputList) throws Exception {
        String tableName = TestUtil.initTables(conn, "VARCHAR", new ArrayList<Object>(inputList));
        this.testLpadHelper(conn, colName, length, fillStringList, expectedOutputList, tableName, "ASC");
        this.testLpadHelper(conn, colName, length, fillStringList, expectedOutputList, tableName, "DESC");
    }

    private void testLpad(Connection conn, List<String> inputList, int length, List<String> fillStringList, List<String> expectedOutputList) throws Exception {
        this.testLpad(conn, inputList, length, fillStringList, "pk", expectedOutputList);
    }

    @Test
    public void testCharPadding() throws Exception {
        Connection conn = DriverManager.getConnection(StringIT.getUrl());
        String tableName = StringIT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE " + tableName + " (k CHAR(3) PRIMARY KEY)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('ab')");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName + " ORDER BY k");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"ab", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
        String tableNameDesc = StringIT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE " + tableNameDesc + " (k CHAR(3) PRIMARY KEY DESC)");
        conn.createStatement().execute("UPSERT INTO " + tableNameDesc + " VALUES('a')");
        conn.createStatement().execute("UPSERT INTO " + tableNameDesc + " VALUES('ab')");
        conn.commit();
        rs = conn.createStatement().executeQuery("SELECT * FROM " + tableNameDesc + " ORDER BY k DESC");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"ab", (Object)rs.getString(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testBinaryPadding() throws Exception {
        Connection conn = DriverManager.getConnection(StringIT.getUrl());
        String tableName = StringIT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE " + tableName + " (k BINARY(3) PRIMARY KEY)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('ab')");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName + " ORDER BY k");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertArrayEquals((byte[])ByteUtil.concat((byte[])Bytes.toBytes((String)"a"), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, QueryConstants.SEPARATOR_BYTE_ARRAY}), (byte[])rs.getBytes(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertArrayEquals((byte[])ByteUtil.concat((byte[])Bytes.toBytes((String)"ab"), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY}), (byte[])rs.getBytes(1));
        Assert.assertFalse((boolean)rs.next());
        String tableNameDesc = StringIT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE " + tableNameDesc + " (k BINARY(3) PRIMARY KEY DESC)");
        conn.createStatement().execute("UPSERT INTO " + tableNameDesc + " VALUES('a')");
        conn.createStatement().execute("UPSERT INTO " + tableNameDesc + " VALUES('ab')");
        conn.commit();
        rs = conn.createStatement().executeQuery("SELECT * FROM " + tableNameDesc + " ORDER BY k DESC");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertArrayEquals((byte[])ByteUtil.concat((byte[])Bytes.toBytes((String)"ab"), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY}), (byte[])rs.getBytes(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertArrayEquals((byte[])ByteUtil.concat((byte[])Bytes.toBytes((String)"a"), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, QueryConstants.SEPARATOR_BYTE_ARRAY}), (byte[])rs.getBytes(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testNullInputStringSB() throws Exception {
        Connection conn = DriverManager.getConnection(StringIT.getUrl());
        this.testLpad(conn, Lists.newArrayList((Object[])new String[]{"X", "X"}), 4, Lists.newArrayList((Object[])new String[]{"", ""}), "kv", Lists.newArrayList((Object[])new String[]{null, null}));
    }

    @Test
    public void testEmptyFillExpr() throws Exception {
        Connection conn = DriverManager.getConnection(StringIT.getUrl());
        this.testLpad(conn, Lists.newArrayList((Object[])new String[]{"ABCD", "\u0d23\u0d2b\u0270\u0278"}), 6, Lists.newArrayList((Object[])new String[]{"", ""}), Lists.newArrayList((Object[])new String[]{null, null}));
    }

    @Test
    public void testDefaultFill() throws Exception {
        Connection conn = DriverManager.getConnection(StringIT.getUrl());
        this.testLpad(conn, Lists.newArrayList((Object[])new String[]{"ABCD", "\u0d23\u0d2b\u0270\u0278"}), 6, Lists.newArrayList((Object[])new String[]{null, null}), Lists.newArrayList((Object[])new String[]{"  ABCD", "  \u0d23\u0d2b\u0270\u0278"}));
    }

    @Test
    public void testLpadFillLengthGreaterThanPadLength() throws Exception {
        Connection conn = DriverManager.getConnection(StringIT.getUrl());
        this.testLpad(conn, Lists.newArrayList((Object[])new String[]{"ABCD", "\u0d23\u0d2b\u0270\u0278", "\u0d23\u0d2b\u0270\u0278", "ABCD"}), 8, Lists.newArrayList((Object[])new String[]{"123456", "\u025a\u025a\u0266\u025a\u025a\u0266", "123456", "\u0d23\u0d2b\u0270\u0278\u0d23\u0d2b"}), Lists.newArrayList((Object[])new String[]{"1234ABCD", "\u025a\u025a\u0266\u025a\u0d23\u0d2b\u0270\u0278", "1234\u0d23\u0d2b\u0270\u0278", "\u0d23\u0d2b\u0270\u0278ABCD"}));
    }

    @Test
    public void testLpadFillLengthLessThanPadLength() throws Exception {
        Connection conn = DriverManager.getConnection(StringIT.getUrl());
        this.testLpad(conn, Lists.newArrayList((Object[])new String[]{"ABCD", "\u0270\u0278\u0270\u0278", "\u0270\u0278\u0270\u0278", "ABCD"}), 8, Lists.newArrayList((Object[])new String[]{"12", "\u0d2b\u0270", "12", "\u0d2b\u0270"}), Lists.newArrayList((Object[])new String[]{"1212ABCD", "\u0d2b\u0270\u0d2b\u0270\u0270\u0278\u0270\u0278", "1212\u0270\u0278\u0270\u0278", "\u0d2b\u0270\u0d2b\u0270ABCD"}));
    }

    @Test
    public void testLpadFillLengthEqualPadLength() throws Exception {
        Connection conn = DriverManager.getConnection(StringIT.getUrl());
        this.testLpad(conn, Lists.newArrayList((Object[])new String[]{"ABCD", "\u0270\u0278\u0270\u0278", "\u0270\u0278\u0270\u0278", "ABCD"}), 8, Lists.newArrayList((Object[])new String[]{"1234", "\u0d23\u0d2b\u0270\u0278", "1234", "\u0d23\u0d2b\u0270\u0278"}), Lists.newArrayList((Object[])new String[]{"1234ABCD", "\u0d23\u0d2b\u0270\u0278\u0270\u0278\u0270\u0278", "1234\u0270\u0278\u0270\u0278", "\u0d23\u0d2b\u0270\u0278ABCD"}));
    }

    @Test
    public void testLpadZeroPadding() throws Exception {
        Connection conn = DriverManager.getConnection(StringIT.getUrl());
        ArrayList inputList = Lists.newArrayList((Object[])new String[]{"ABCD", "\u0d23\u0d2b\u0270\u0278", "\u0d23\u0d2b\u0270\u0278", "ABCD"});
        this.testLpad(conn, inputList, 4, Lists.newArrayList((Object[])new String[]{"1234", "\u025a\u0266\u025a\u0266", "1234", "\u025a\u0266\u025a\u0266"}), inputList);
    }

    @Test
    public void testLpadTrucate() throws Exception {
        Connection conn = DriverManager.getConnection(StringIT.getUrl());
        this.testLpad(conn, Lists.newArrayList((Object[])new String[]{"ABCD", "\u0d23\u0d2b\u0270\u0278", "\u0d23\u0d2b\u0270\u0278", "ABCD"}), 2, Lists.newArrayList((Object[])new String[]{"12", "\u025a\u0266", "12", "\u025a\u0266"}), Lists.newArrayList((Object[])new String[]{"AB", "\u0d23\u0d2b", "\u0d23\u0d2b", "AB"}));
    }

    @Test
    public void testLpadZeroOutputStringLength() throws Exception {
        Connection conn = DriverManager.getConnection(StringIT.getUrl());
        this.testLpad(conn, Lists.newArrayList((Object[])new String[]{"ABCD", "\u0d23\u0d2b\u0270\u0278", "\u0d23\u0d2b\u0270\u0278", "ABCD"}), 0, Lists.newArrayList((Object[])new String[]{"12", "\u025a\u0266", "12", "\u025a\u0266"}), Lists.newArrayList((Object[])new String[]{null, null, null, null}));
    }

    @Test
    public void testNegativeOutputStringLength() throws Exception {
        Connection conn = DriverManager.getConnection(StringIT.getUrl());
        this.testLpad(conn, Lists.newArrayList((Object[])new String[]{"ABCD", "\u0d23\u0d2b\u0270\u0278", "\u0d23\u0d2b\u0270\u0278", "ABCD"}), -1, Lists.newArrayList((Object[])new String[]{"12", "\u025a\u0266", "12", "\u025a\u0266"}), Lists.newArrayList((Object[])new String[]{null, null, null, null}));
    }

    @Test
    public void testStrConcat() throws Exception {
        Connection conn = DriverManager.getConnection(StringIT.getUrl());
        String tableName = StringIT.generateUniqueName();
        conn.createStatement().execute("create table " + tableName + " (PK1 integer, F1 varchar, F2 varchar, F3 varchar, F4 varchar, constraint PK primary key (PK1))");
        conn.createStatement().execute("upsert into " + tableName + "(PK1, F1,F3) values(0, 'tortilla', 'chip')");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("select * from " + tableName + " where (F1||F2||F3||F4)='tortillachip'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)0L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testLpadWithNullArgs() throws Exception {
        Connection conn = DriverManager.getConnection(StringIT.getUrl());
        String tableName = StringIT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE " + tableName + " (k CHAR(3) PRIMARY KEY, v1 VARCHAR, v2 INTEGER)");
        conn.createStatement().execute("UPSERT INTO " + tableName + "(k) VALUES('a')");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT LPAD(v1, 5, 'ab') FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"ababa", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT LPAD('abc', v2, 'a') FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        rs.getString(1);
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT LPAD('abc', 5, v1) FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        rs.getString(1);
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testValidStringConcatExpression() throws Exception {
        String[] queries;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Date date = new Date(System.currentTimeMillis());
        Connection conn = DriverManager.getConnection(StringIT.getUrl(), props);
        String tableName = StringIT.initATableValues(StringIT.generateUniqueName(), StringIT.getOrganizationId(), StringIT.getDefaultSplits(StringIT.getOrganizationId()), date, null, StringIT.getUrl(), "COLUMN_ENCODED_BYTES=0");
        int counter = 0;
        String[] answers = new String[]{"00D300000000XHP5bar", "a5bar", "15bar", "5bar", "5bar"};
        for (String query : queries = new String[]{"SELECT  organization_id || 5 || 'bar' FROM " + tableName + " limit 1", "SELECT a_string || 5 || 'bar' FROM " + tableName + "  order by a_string  limit 1", "SELECT a_integer||5||'bar' FROM " + tableName + " order by a_integer  limit 1", "SELECT x_decimal||5||'bar' FROM " + tableName + " limit 1", "SELECT x_long||5||'bar' FROM " + tableName + " limit 1"}) {
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)answers[counter++], (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
        conn.close();
    }
}

