/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class StrictTTLPropertyIT
extends ParallelStatsDisabledIT {
    @Test
    public void testCreateTableWithStrictTTLDefault() throws Exception {
        String schemaName = StrictTTLPropertyIT.generateUniqueName();
        String tableName = StrictTTLPropertyIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(StrictTTLPropertyIT.getUrl());){
            String ddl = "CREATE TABLE " + fullTableName + " (id char(1) NOT NULL, col1 integer NOT NULL, col2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (id, col1, col2))";
            conn.createStatement().execute(ddl);
            PTable table = conn.getTableNoCache(fullTableName);
            Assert.assertTrue((String)"IS_STRICT_TTL should default to true", (boolean)table.isStrictTTL());
        }
    }

    @Test
    public void testCreateTableWithStrictTTLTrue() throws Exception {
        String schemaName = StrictTTLPropertyIT.generateUniqueName();
        String tableName = StrictTTLPropertyIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(StrictTTLPropertyIT.getUrl());){
            String ddl = "CREATE TABLE " + fullTableName + " (id char(1) NOT NULL, col1 integer NOT NULL, col2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (id, col1, col2)) IS_STRICT_TTL=true";
            conn.createStatement().execute(ddl);
            PTable table = conn.getTableNoCache(fullTableName);
            Assert.assertTrue((String)"IS_STRICT_TTL should be true", (boolean)table.isStrictTTL());
        }
    }

    @Test
    public void testCreateTableWithStrictTTLFalse() throws Exception {
        String schemaName = StrictTTLPropertyIT.generateUniqueName();
        String tableName = StrictTTLPropertyIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(StrictTTLPropertyIT.getUrl());){
            String ddl = "CREATE TABLE " + fullTableName + " (id char(1) NOT NULL, col1 integer NOT NULL, col2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (id, col1, col2)) IS_STRICT_TTL=false";
            conn.createStatement().execute(ddl);
            PTable table = conn.getTableNoCache(fullTableName);
            Assert.assertFalse((String)"IS_STRICT_TTL should be false", (boolean)table.isStrictTTL());
        }
    }

    @Test
    public void testAlterTableSetStrictTTLTrue() throws Exception {
        String schemaName = StrictTTLPropertyIT.generateUniqueName();
        String tableName = StrictTTLPropertyIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(StrictTTLPropertyIT.getUrl());){
            String createDdl = "CREATE TABLE " + fullTableName + " (id char(1) NOT NULL, col1 integer NOT NULL, col2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (id, col1, col2)) IS_STRICT_TTL=false";
            conn.createStatement().execute(createDdl);
            PTable table = conn.getTableNoCache(fullTableName);
            Assert.assertFalse((String)"IS_STRICT_TTL should be false initially", (boolean)table.isStrictTTL());
            String alterDdl = "ALTER TABLE " + fullTableName + " SET IS_STRICT_TTL=true";
            conn.createStatement().execute(alterDdl);
            PTable alteredTable = conn.getTableNoCache(fullTableName);
            Assert.assertTrue((String)"IS_STRICT_TTL should be true after ALTER", (boolean)alteredTable.isStrictTTL());
        }
    }

    @Test
    public void testAlterTableSetStrictTTLFalse() throws Exception {
        String schemaName = StrictTTLPropertyIT.generateUniqueName();
        String tableName = StrictTTLPropertyIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(StrictTTLPropertyIT.getUrl());){
            String createDdl = "CREATE TABLE " + fullTableName + " (id char(1) NOT NULL, col1 integer NOT NULL, col2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (id, col1, col2))";
            conn.createStatement().execute(createDdl);
            PTable table = conn.getTableNoCache(fullTableName);
            Assert.assertTrue((String)"IS_STRICT_TTL should be true initially", (boolean)table.isStrictTTL());
            String alterDdl = "ALTER TABLE " + fullTableName + " SET IS_STRICT_TTL=false";
            conn.createStatement().execute(alterDdl);
            PTable alteredTable = conn.getTableNoCache(fullTableName);
            Assert.assertFalse((String)"IS_STRICT_TTL should be false after ALTER", (boolean)alteredTable.isStrictTTL());
        }
    }

    @Test
    public void testStrictTTLPropertyPersistsInSystemCatalog() throws Exception {
        String schemaName = StrictTTLPropertyIT.generateUniqueName();
        String tableName = StrictTTLPropertyIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        try (Connection conn = DriverManager.getConnection(StrictTTLPropertyIT.getUrl());){
            String ddl = "CREATE TABLE " + fullTableName + " (id char(1) NOT NULL, col1 integer NOT NULL, col2 bigint NOT NULL, CONSTRAINT NAME_PK PRIMARY KEY (id, col1, col2)) IS_STRICT_TTL=false";
            conn.createStatement().execute(ddl);
            String query = "SELECT IS_STRICT_TTL FROM SYSTEM.CATALOG WHERE TABLE_SCHEM = ? AND TABLE_NAME = ? AND COLUMN_NAME IS NULL";
            try (PreparedStatement stmt = conn.prepareStatement(query);){
                stmt.setString(1, schemaName);
                stmt.setString(2, tableName);
                ResultSet rs = stmt.executeQuery();
                Assert.assertTrue((String)"Should find table row", (boolean)rs.next());
                Assert.assertFalse((String)"IS_STRICT_TTL should be false in SYSTEM.CATALOG", (boolean)rs.getBoolean("IS_STRICT_TTL"));
            }
        }
    }
}

