/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.SingleCellColumnExpression;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=Parameterized.class)
public class StoreNullsIT
extends ParallelStatsDisabledIT {
    private final boolean mutable;
    private final boolean columnEncoded;
    private final boolean storeNulls;
    private final String ddlFormat;
    private String dataTableName;

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        props.put("phoenix.max.lookback.age.seconds", Integer.toString(0));
        StoreNullsIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    public StoreNullsIT(boolean mutable, boolean columnEncoded, boolean storeNulls) {
        this.mutable = mutable;
        this.columnEncoded = columnEncoded;
        this.storeNulls = storeNulls;
        StringBuilder sb = new StringBuilder("CREATE TABLE %s (id SMALLINT NOT NULL PRIMARY KEY, name VARCHAR) VERSIONS = 1000, KEEP_DELETED_CELLS = false ");
        if (!columnEncoded) {
            sb.append(",").append("COLUMN_ENCODED_BYTES=0");
        }
        if (!mutable) {
            sb.append(",").append("IMMUTABLE_ROWS=true");
            if (!columnEncoded) {
                sb.append(",IMMUTABLE_STORAGE_SCHEME=" + PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN);
            }
        }
        if (storeNulls) {
            sb.append(",").append("STORE_NULLS=true");
        }
        this.ddlFormat = sb.toString();
    }

    @Parameterized.Parameters(name="StoreNullsIT_mutable={0}, columnEncoded={1}, storeNulls={2}")
    public static synchronized Collection<Boolean[]> data() {
        return Arrays.asList({false, false, false}, {false, false, true}, {false, true, false}, {false, true, true}, {true, false, false}, {true, false, true}, {true, true, false}, {true, true, true});
    }

    @Before
    public void setupTableNames() throws Exception {
        this.dataTableName = StoreNullsIT.generateUniqueName();
    }

    @Test
    public void testStoringNullsForImmutableTables() throws Exception {
        try (Connection conn = DriverManager.getConnection(StoreNullsIT.getUrl());
             Statement stmt = conn.createStatement();){
            conn.setAutoCommit(true);
            stmt.execute(String.format(this.ddlFormat, this.dataTableName));
            stmt.executeUpdate("UPSERT INTO " + this.dataTableName + " VALUES (1, 'v1')");
            stmt.executeUpdate("UPSERT INTO " + this.dataTableName + " VALUES (2, null)");
            TestUtil.doMajorCompaction(conn, this.dataTableName);
            this.ensureNullsStoredCorrectly(conn);
        }
    }

    private void ensureNullsStoredCorrectly(Connection conn) throws Exception {
        ResultSet rs1 = conn.createStatement().executeQuery("SELECT NAME FROM " + this.dataTableName);
        rs1.next();
        Assert.assertEquals((Object)"v1", (Object)rs1.getString(1));
        rs1.next();
        Assert.assertNull((Object)rs1.getString(1));
        rs1.next();
        Table htable = ConnectionFactory.createConnection((Configuration)StoreNullsIT.getUtility().getConfiguration()).getTable(TableName.valueOf((String)this.dataTableName));
        Scan s = new Scan();
        s.setRaw(true);
        ResultScanner scanner = htable.getScanner(s);
        Result rs = scanner.next();
        PTable table = conn.unwrap(PhoenixConnection.class).getTable(new PTableKey(null, this.dataTableName));
        PColumn nameColumn = table.getColumnForColumnName("NAME");
        byte[] qualifier = table.getImmutableStorageScheme() == PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS ? QueryConstants.SINGLE_KEYVALUE_COLUMN_QUALIFIER_BYTES : nameColumn.getColumnQualifierBytes();
        Assert.assertTrue((boolean)rs.containsColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, qualifier));
        Assert.assertTrue((rs.size() == 2 ? 1 : 0) != 0);
        SingleCellColumnExpression colExpression = table.getImmutableStorageScheme() == PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS ? new SingleCellColumnExpression(nameColumn, "NAME", table.getEncodingScheme(), table.getImmutableStorageScheme()) : new KeyValueColumnExpression(nameColumn);
        ImmutableBytesPtr ptr = new ImmutableBytesPtr();
        colExpression.evaluate((Tuple)new ResultTuple(rs), (ImmutableBytesWritable)ptr);
        Assert.assertEquals((Object)new ImmutableBytesPtr(PVarchar.INSTANCE.toBytes((Object)"v1")), (Object)ptr);
        rs = scanner.next();
        if (!this.mutable && !this.columnEncoded || this.mutable && !this.storeNulls) {
            Assert.assertFalse((boolean)rs.containsColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, qualifier));
            Assert.assertEquals((long)1L, (long)rs.size());
        } else {
            Assert.assertTrue((boolean)rs.containsColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, qualifier));
            Assert.assertEquals((long)2L, (long)rs.size());
        }
        ptr = new ImmutableBytesPtr();
        if (colExpression.evaluate((Tuple)new ResultTuple(rs), (ImmutableBytesWritable)ptr)) {
            Assert.assertEquals((Object)new ImmutableBytesPtr(ByteUtil.EMPTY_BYTE_ARRAY), (Object)ptr);
        }
        Assert.assertNull((Object)scanner.next());
        scanner.close();
        htable.close();
    }

    @Test
    public void testQueryingHistory() throws Exception {
        try (Connection conn = DriverManager.getConnection(StoreNullsIT.getUrl());
             Statement stmt = conn.createStatement();){
            conn.setAutoCommit(true);
            stmt.execute(String.format(this.ddlFormat, this.dataTableName));
            stmt.executeUpdate("UPSERT INTO " + this.dataTableName + " VALUES (1, 'v1')");
            Thread.sleep(10L);
            long afterFirstInsert = EnvironmentEdgeManager.currentTimeMillis();
            Thread.sleep(10L);
            stmt.executeUpdate("UPSERT INTO " + this.dataTableName + " VALUES (1, null)");
            Thread.sleep(10L);
            TestUtil.doMajorCompaction(conn, this.dataTableName);
            Properties historicalProps = new Properties();
            historicalProps.setProperty("CurrentSCN", Long.toString(afterFirstInsert));
            Connection historicalConn = DriverManager.getConnection(StoreNullsIT.getUrl(), historicalProps);
            Statement historicalStmt = historicalConn.createStatement();
            ResultSet rs = historicalStmt.executeQuery("SELECT name FROM " + this.dataTableName + " WHERE id = 1");
            if (this.storeNulls || !this.mutable) {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"v1", (Object)rs.getString(1));
                rs.close();
            } else {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertNull((Object)rs.getString(1));
            }
            rs.close();
            historicalStmt.close();
            conn.close();
            historicalConn.close();
        }
    }

    @Test
    public void testDeletes() throws Exception {
        try (Connection conn = DriverManager.getConnection(StoreNullsIT.getUrl());
             Statement stmt = conn.createStatement();){
            conn.setAutoCommit(true);
            stmt.execute(String.format(this.ddlFormat, this.dataTableName));
            stmt.executeUpdate("UPSERT INTO " + this.dataTableName + " VALUES (1, 'v1')");
            Thread.sleep(10L);
            long afterFirstInsert = EnvironmentEdgeManager.currentTimeMillis();
            Thread.sleep(10L);
            stmt.executeUpdate("DELETE FROM " + this.dataTableName + " WHERE id = 1");
            Thread.sleep(10L);
            TestUtil.doMajorCompaction(conn, this.dataTableName);
            Properties historicalProps = new Properties();
            historicalProps.setProperty("CurrentSCN", Long.toString(afterFirstInsert));
            Connection historicalConn = DriverManager.getConnection(StoreNullsIT.getUrl(), historicalProps);
            Statement historicalStmt = historicalConn.createStatement();
            ResultSet rs = historicalStmt.executeQuery("SELECT name FROM " + this.dataTableName + " WHERE id = 1");
            Assert.assertFalse((boolean)rs.next());
            rs.close();
            rs = historicalStmt.executeQuery("SELECT name FROM " + this.dataTableName + " WHERE id = 1");
            Assert.assertFalse((boolean)rs.next());
            rs.close();
            conn.close();
            historicalStmt.close();
            historicalConn.close();
        }
    }

    private static long getRowCount(Connection conn, String tableName) throws SQLException {
        ResultSet rs = conn.createStatement().executeQuery("SELECT /*+ NO_INDEX */ count(*) FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        return rs.getLong(1);
    }

    @Test
    public void testSetIndexedColumnToNullTwiceWithStoreNulls() throws Exception {
        if (!this.mutable) {
            return;
        }
        String tableName = StoreNullsIT.generateUniqueName();
        String indexName = StoreNullsIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(StoreNullsIT.getUrl(), props);
        conn.createStatement().execute("CREATE TABLE " + tableName + "(k1 CHAR(2) NOT NULL, k2 CHAR(2) NOT NULL, ts TIMESTAMP, V VARCHAR, V2 VARCHAR, CONSTRAINT pk PRIMARY KEY (k1,k2)) STORE_NULLS=" + this.storeNulls + (this.columnEncoded ? "" : ",COLUMN_ENCODED_BYTES=0"));
        conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + tableName + "(k2,k1,ts) INCLUDE (V, v2)");
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES('aa','aa',?, '0')");
        stmt.setTimestamp(1, new Timestamp(1000L));
        stmt.executeUpdate();
        conn.commit();
        stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES('aa','aa',?, null)");
        Timestamp expectedTimestamp = null;
        stmt.setTimestamp(1, expectedTimestamp);
        stmt.executeUpdate();
        conn.commit();
        stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES('aa','aa',?, null)");
        expectedTimestamp = null;
        stmt.setTimestamp(1, expectedTimestamp);
        stmt.executeUpdate();
        conn.commit();
        TestUtil.dumpTable(conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(Bytes.toBytes((String)tableName)));
        TestUtil.dumpTable(conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(Bytes.toBytes((String)indexName)));
        long count1 = StoreNullsIT.getRowCount(conn, tableName);
        long count2 = StoreNullsIT.getRowCount(conn, indexName);
        Assert.assertEquals((String)"Table should have 1 row", (long)1L, (long)count1);
        Assert.assertEquals((String)"Index should have 1 row", (long)1L, (long)count2);
        ResultSet rs = conn.createStatement().executeQuery("SELECT /*+ NO_INDEX */ ts,v FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals(expectedTimestamp, (Object)rs.getTimestamp(1));
        Assert.assertEquals(null, (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT \"0:TS\", \"0:V\" FROM " + indexName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals(expectedTimestamp, (Object)rs.getTimestamp(1));
        Assert.assertEquals(null, (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }
}

