/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class StddevIT
extends ParallelStatsDisabledIT {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSTDDEV_POP() throws Exception {
        String tenantId = StddevIT.getOrganizationId();
        String tableName = StddevIT.initATableValues(tenantId, StddevIT.getDefaultSplits(tenantId), StddevIT.getUrl());
        String query = "SELECT STDDEV_POP(A_INTEGER) FROM " + tableName;
        try (Connection conn = DriverManager.getConnection(StddevIT.getUrl());){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            BigDecimal stddev = rs.getBigDecimal(1);
            stddev = stddev.setScale(1, RoundingMode.HALF_UP);
            Assert.assertEquals((double)2.6, (double)stddev.doubleValue(), (double)0.0);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSTDDEV_SAMP() throws Exception {
        String tenantId = StddevIT.getOrganizationId();
        String tableName = StddevIT.initATableValues(tenantId, StddevIT.getDefaultSplits(tenantId), StddevIT.getUrl());
        String query = "SELECT STDDEV_SAMP(x_decimal) FROM " + tableName;
        try (Connection conn = DriverManager.getConnection(StddevIT.getUrl());){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            BigDecimal stddev = rs.getBigDecimal(1);
            stddev = stddev.setScale(1, RoundingMode.HALF_UP);
            Assert.assertEquals((double)2.0, (double)stddev.doubleValue(), (double)0.0);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSTDDEV_POPOnDecimalColType() throws Exception {
        String tenantId = StddevIT.getOrganizationId();
        String tableName = StddevIT.initATableValues(tenantId, StddevIT.getDefaultSplits(tenantId), StddevIT.getUrl());
        String query = "SELECT STDDEV_POP(x_decimal) FROM " + tableName;
        try (Connection conn = DriverManager.getConnection(StddevIT.getUrl());){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            BigDecimal stddev = rs.getBigDecimal(1);
            stddev = stddev.setScale(10, RoundingMode.HALF_UP);
            Assert.assertEquals((double)1.6679994671, (double)stddev.doubleValue(), (double)0.0);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSTDDEV_SAMPOnDecimalColType() throws Exception {
        String tenantId = StddevIT.getOrganizationId();
        String tableName = StddevIT.initATableValues(tenantId, StddevIT.getDefaultSplits(tenantId), StddevIT.getUrl());
        String query = "SELECT STDDEV_SAMP(x_decimal) FROM " + tableName;
        try (Connection conn = DriverManager.getConnection(StddevIT.getUrl());){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            BigDecimal stddev = rs.getBigDecimal(1);
            stddev = stddev.setScale(10, RoundingMode.HALF_UP);
            Assert.assertEquals((double)2.0428737928, (double)stddev.doubleValue(), (double)0.0);
            Assert.assertFalse((boolean)rs.next());
        }
    }
}

