/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ViewIT;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.ReadOnlyTableException;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.transaction.PhoenixTransactionProvider;
import org.apache.phoenix.transaction.TransactionFactory;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=Parameterized.class)
public class StatsEnabledSplitSystemCatalogIT
extends BaseTest {
    private String tableDDLOptions;
    private String transactionProvider;

    public StatsEnabledSplitSystemCatalogIT(String transactionProvider) {
        StringBuilder optionBuilder = new StringBuilder();
        this.transactionProvider = transactionProvider;
        if (transactionProvider != null) {
            optionBuilder.append(" TRANSACTIONAL=true, TRANSACTION_PROVIDER='" + transactionProvider + "'");
        }
        this.tableDDLOptions = optionBuilder.toString();
    }

    @Parameterized.Parameters(name="transactionProvider = {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"OMID"}, {null});
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        NUM_SLAVES_BASE = 3;
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        props.put("phoenix.stats.guidepost.width", Long.toString(20L));
        props.put("phoenix.stats.updateFrequency", Long.toString(5L));
        props.put("phoenix.use.stats.parallelization", Boolean.toString(true));
        StatsEnabledSplitSystemCatalogIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @Test
    public void testSaltedUpdatableViewWithIndex() throws Exception {
        this.testUpdatableViewWithIndex(3, false);
    }

    @Test
    public void testSaltedUpdatableViewWithLocalIndex() throws Exception {
        if (this.transactionProvider == null || !TransactionFactory.getTransactionProvider((TransactionFactory.Provider)TransactionFactory.Provider.valueOf((String)this.transactionProvider)).isUnsupported(PhoenixTransactionProvider.Feature.ALLOW_LOCAL_INDEX)) {
            this.testUpdatableViewWithIndex(3, true);
        }
    }

    @Test
    public void testNonSaltedUpdatableViewWithIndex() throws Exception {
        this.testUpdatableViewWithIndex(null, false);
    }

    @Test
    public void testNonSaltedUpdatableViewWithLocalIndex() throws Exception {
        if (this.transactionProvider == null || !TransactionFactory.getTransactionProvider((TransactionFactory.Provider)TransactionFactory.Provider.valueOf((String)this.transactionProvider)).isUnsupported(PhoenixTransactionProvider.Feature.ALLOW_LOCAL_INDEX)) {
            this.testUpdatableViewWithIndex(null, true);
        }
    }

    @Test
    public void testUpdatableOnUpdatableView() throws Exception {
        String fullTableName = SchemaUtil.getTableName((String)StatsEnabledSplitSystemCatalogIT.generateUniqueName(), (String)StatsEnabledSplitSystemCatalogIT.generateUniqueName());
        String fullViewName1 = SchemaUtil.getTableName((String)StatsEnabledSplitSystemCatalogIT.generateUniqueName(), (String)StatsEnabledSplitSystemCatalogIT.generateUniqueName());
        String fullViewName2 = SchemaUtil.getTableName((String)StatsEnabledSplitSystemCatalogIT.generateUniqueName(), (String)StatsEnabledSplitSystemCatalogIT.generateUniqueName());
        String ddl = "CREATE VIEW " + fullViewName2 + " AS SELECT * FROM " + fullViewName1 + " WHERE k3 = 2";
        ViewIT.testUpdatableView(fullTableName, fullViewName1, fullViewName2, ddl, null, this.tableDDLOptions);
        Connection conn = DriverManager.getConnection(StatsEnabledSplitSystemCatalogIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT k1, k2, k3 FROM " + fullViewName2);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)109L, (long)rs.getInt(2));
        Assert.assertEquals((long)2L, (long)rs.getInt(3));
        Assert.assertFalse((boolean)rs.next());
        conn.createStatement().execute("UPSERT INTO " + fullViewName2 + "(k2) VALUES(122)");
        conn.commit();
        rs = conn.createStatement().executeQuery("SELECT k1, k2, k3 FROM " + fullViewName2 + " WHERE k2 >= 120");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)122L, (long)rs.getInt(2));
        Assert.assertEquals((long)2L, (long)rs.getInt(3));
        Assert.assertFalse((boolean)rs.next());
        try {
            conn.createStatement().execute("UPSERT INTO " + fullViewName2 + "(k2,k3) VALUES(123,3)");
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.CANNOT_UPDATE_VIEW_COLUMN.getErrorCode(), (long)e.getErrorCode());
        }
        try {
            conn.createStatement().execute("UPSERT INTO " + fullViewName2 + "(k2,k3) select k2, 3 from " + fullViewName1);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.CANNOT_UPDATE_VIEW_COLUMN.getErrorCode(), (long)e.getErrorCode());
        }
    }

    private void testUpdatableViewWithIndex(Integer saltBuckets, boolean localIndex) throws Exception {
        String schemaName = "S_" + StatsEnabledSplitSystemCatalogIT.generateUniqueName();
        String tableName = "T_" + StatsEnabledSplitSystemCatalogIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String viewName = "V_" + StatsEnabledSplitSystemCatalogIT.generateUniqueName();
        ViewIT.testUpdatableView(fullTableName, viewName, null, null, saltBuckets, this.tableDDLOptions);
        Pair<String, Scan> pair = ViewIT.testUpdatableViewIndex(fullTableName, saltBuckets, localIndex, viewName);
        Scan scan = (Scan)pair.getSecond();
        String physicalTableName = (String)pair.getFirst();
        if (saltBuckets == null) {
            try (Connection conn = DriverManager.getConnection(StatsEnabledSplitSystemCatalogIT.getUrl());){
                ResultScanner scanner;
                Result result;
                Table htable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(Bytes.toBytes((String)physicalTableName));
                if (ScanUtil.isLocalIndex((Scan)scan)) {
                    ScanUtil.setLocalIndexAttributes((Scan)scan, (int)0, (byte[])HConstants.EMPTY_BYTE_ARRAY, (byte[])HConstants.EMPTY_BYTE_ARRAY, (byte[])scan.getStartRow(), (byte[])scan.getStopRow());
                }
                Assert.assertTrue(((result = (scanner = htable.getScanner(scan)).next()) != null && !result.isEmpty() ? 1 : 0) != 0);
                conn.createStatement().execute("DROP VIEW " + viewName);
                scanner = htable.getScanner(scan);
                result = scanner.next();
                Assert.assertTrue((result == null || result.isEmpty() ? 1 : 0) != 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadOnlyOnReadOnlyView() throws Exception {
        Connection earlierCon = DriverManager.getConnection(StatsEnabledSplitSystemCatalogIT.getUrl());
        Connection conn = DriverManager.getConnection(StatsEnabledSplitSystemCatalogIT.getUrl());
        String fullTableName = SchemaUtil.getTableName((String)StatsEnabledSplitSystemCatalogIT.generateUniqueName(), (String)StatsEnabledSplitSystemCatalogIT.generateUniqueName());
        String fullParentViewName = SchemaUtil.getTableName((String)StatsEnabledSplitSystemCatalogIT.generateUniqueName(), (String)StatsEnabledSplitSystemCatalogIT.generateUniqueName());
        String fullViewName = SchemaUtil.getTableName((String)StatsEnabledSplitSystemCatalogIT.generateUniqueName(), (String)StatsEnabledSplitSystemCatalogIT.generateUniqueName());
        String ddl = "CREATE TABLE " + fullTableName + " (k INTEGER NOT NULL PRIMARY KEY, v1 DATE) " + this.tableDDLOptions;
        conn.createStatement().execute(ddl);
        ddl = "CREATE VIEW " + fullParentViewName + " (v2 VARCHAR) AS SELECT * FROM " + fullTableName + " WHERE k > 5";
        conn.createStatement().execute(ddl);
        ddl = "CREATE VIEW " + fullViewName + " AS SELECT * FROM " + fullParentViewName + " WHERE k < 9";
        conn.createStatement().execute(ddl);
        try {
            conn.createStatement().execute("UPSERT INTO " + fullParentViewName + " VALUES(1)");
            Assert.fail();
        }
        catch (ReadOnlyTableException readOnlyTableException) {
            // empty catch block
        }
        for (int i = 0; i < 10; ++i) {
            conn.createStatement().execute("UPSERT INTO " + fullTableName + " VALUES(" + i + ")");
        }
        conn.commit();
        TestUtil.analyzeTable(conn, fullParentViewName, this.transactionProvider != null);
        List<KeyRange> splits = TestUtil.getAllSplits(conn, fullParentViewName);
        Assert.assertEquals((long)4L, (long)splits.size());
        int count = 0;
        ResultSet rs = conn.createStatement().executeQuery("SELECT k FROM " + fullTableName);
        while (rs.next()) {
            Assert.assertEquals((long)count++, (long)rs.getInt(1));
        }
        Assert.assertEquals((long)10L, (long)count);
        count = 0;
        rs = conn.createStatement().executeQuery("SELECT k FROM " + fullParentViewName);
        while (rs.next()) {
            Assert.assertEquals((long)(++count + 5), (long)rs.getInt(1));
        }
        Assert.assertEquals((long)4L, (long)count);
        count = 0;
        rs = earlierCon.createStatement().executeQuery("SELECT k FROM " + fullParentViewName);
        while (rs.next()) {
            Assert.assertEquals((long)(++count + 5), (long)rs.getInt(1));
        }
        Assert.assertEquals((long)4L, (long)count);
        try {
            conn.createStatement().execute("UPSERT INTO " + fullViewName + " VALUES(1)");
            Assert.fail();
        }
        catch (ReadOnlyTableException readOnlyTableException) {
        }
        finally {
            conn.close();
        }
        conn = DriverManager.getConnection(StatsEnabledSplitSystemCatalogIT.getUrl());
        count = 0;
        rs = conn.createStatement().executeQuery("SELECT k FROM " + fullViewName);
        while (rs.next()) {
            Assert.assertEquals((long)(++count + 5), (long)rs.getInt(1));
        }
        Assert.assertEquals((long)3L, (long)count);
    }
}

