/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.end2end.BaseOwnClusterIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class SpillableGroupByIT
extends BaseOwnClusterIT {
    private static final int NUM_ROWS_INSERTED = 1000;
    private static String GROUPBY1 = "select count(*), sum(appcpu), avg(appcpu), uri, min(id), max(id) from %s group by uri";
    private static String GROUPBY2 = "select count(distinct uri) from %s";
    private int id;

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)11);
        props.put("phoenix.groupby.maxCacheSize", Integer.toString(1));
        props.put("phoenix.groupby.spillable", String.valueOf(true));
        props.put("phoenix.groupby.spillFiles", Integer.toString(1));
        props.put("phoenix.query.maxGlobalMemorySize", Integer.toString(40000));
        props.put("phoenix.stats.guidepost.width", Long.toString(20L));
        props.put("phoenix.stats.collection.enabled", Boolean.toString(false));
        props.put("phoenix.explain.displayChunkCount", Boolean.TRUE.toString());
        props.put("phoenix.explain.displayRowCount", Boolean.TRUE.toString());
        props.put("phoenix.server.page.size.ms", Long.toString(60000L));
        SpillableGroupByIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    private void createTable(Connection conn, String tableName) throws Exception {
        TestUtil.createGroupByTestTable(conn, tableName);
    }

    private void loadData(Connection conn, String tableName) throws SQLException {
        int groupFactor = 500;
        for (int i = 0; i < 1000; ++i) {
            this.insertRow(conn, tableName, Integer.toString(i % groupFactor), 10);
            if (i % 1000 != 0) continue;
            conn.commit();
        }
        conn.commit();
    }

    private void loadUniqueURIData(Connection conn, String tableName, int rowsToInsert) throws SQLException {
        for (int i = 0; i < rowsToInsert; ++i) {
            this.insertRow(conn, tableName, Integer.toString(i), 10);
            if (i % 1000 != 0) continue;
            conn.commit();
        }
        conn.commit();
    }

    private void insertRow(Connection conn, String tableName, String uri, int appcpu) throws SQLException {
        PreparedStatement statement = conn.prepareStatement("UPSERT INTO " + tableName + "(id, uri, appcpu) values (?,?,?)");
        statement.setString(1, String.valueOf(this.id));
        statement.setString(2, uri);
        statement.setInt(3, appcpu);
        statement.executeUpdate();
        ++this.id;
    }

    @Test
    public void testScanUri() throws Exception {
        String tableName = SpillableGroupByIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SpillableGroupByIT.getUrl(), props);
        this.createTable(conn, tableName);
        this.loadData(conn, tableName);
        props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(String.format(GROUPBY1, tableName));
        int count = 0;
        while (rs.next()) {
            String uri = rs.getString(4);
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertEquals((long)20L, (long)rs.getInt(2));
            Assert.assertEquals((long)10L, (long)rs.getInt(3));
            int a = Integer.valueOf(rs.getString(5));
            int b = Integer.valueOf(rs.getString(6));
            Assert.assertEquals((long)Integer.valueOf(uri).intValue(), (long)Math.min(a, b));
            Assert.assertEquals((long)(500 + Integer.valueOf(uri)), (long)Math.max(a, b));
            ++count;
        }
        Assert.assertEquals((long)500L, (long)count);
        conn.createStatement();
        rs = stmt.executeQuery("SELECT appcpu FROM " + tableName + " group by appcpu limit 1");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)10L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        stmt = conn.createStatement();
        rs = stmt.executeQuery("SELECT to_number(uri) FROM " + tableName + " group by to_number(uri) limit 100");
        count = 0;
        while (rs.next()) {
            ++count;
        }
        Assert.assertEquals((long)100L, (long)count);
    }

    @Test
    public void testStatisticsAreNotWritten() throws SQLException {
        String tableName = SpillableGroupByIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SpillableGroupByIT.getUrl(), props);
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE TABLE " + tableName + " (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR)");
        stmt.execute("UPSERT INTO " + tableName + " VALUES (1, 'NAME1')");
        stmt.execute("UPSERT INTO " + tableName + " VALUES (2, 'NAME2')");
        stmt.execute("UPSERT INTO " + tableName + " VALUES (3, 'NAME3')");
        conn.commit();
        try {
            stmt.execute("UPDATE STATISTICS " + tableName);
            Assert.fail((String)"Update Statistics SQL should have failed");
        }
        catch (SQLException e) {
            Assert.assertEquals((String)"StatsCollectionDisabledOnServerException expected", (long)1401L, (long)e.getErrorCode());
            Assert.assertEquals((String)"StatsCollectionDisabledOnServerException expected", (Object)"STS01", (Object)e.getSQLState());
        }
        ResultSet rs = stmt.executeQuery("SELECT * FROM \"SYSTEM\".STATS");
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        stmt.close();
        String query = "SELECT * FROM " + tableName;
        ExplainPlan plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
        Assert.assertEquals((Object)new Integer(1), (Object)explainPlanAttributes.getSplitsChunk());
        Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
        Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
        Assert.assertEquals((Object)tableName, (Object)explainPlanAttributes.getTableName());
        conn.close();
    }

    @Test
    public void testDistinctCountFails() throws Exception {
        String tableName = SpillableGroupByIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SpillableGroupByIT.getUrl(), props);
        this.createTable(conn, tableName);
        this.loadUniqueURIData(conn, tableName, 1000);
        props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(String.format(GROUPBY2, tableName));
        try {
            rs.next();
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.INSUFFICIENT_MEMORY.getErrorCode(), (long)e.getErrorCode());
        }
    }
}

