/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class SkipScanAfterManualSplitIT
extends ParallelStatsDisabledIT {
    private static final int BATCH_SIZE = 25;
    private static final int MAX_FILESIZE = 10240;
    private static final int PAYLOAD_SIZE = 1024;
    private static final String PAYLOAD;
    private static final int MIN_CHAR = 97;
    private static final int MAX_CHAR = 122;
    private static final int REGION_BOUND_LENGTH_BYTES = 54;
    private static final byte[][] REGION_BOUNDS;

    private static Connection getConnection() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.query.force.rowkeyorder", Boolean.toString(false));
        Connection conn = DriverManager.getConnection(SkipScanAfterManualSplitIT.getUrl(), props);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initTable(String tableName) throws Exception {
        Connection conn = SkipScanAfterManualSplitIT.getConnection();
        conn.createStatement().execute("CREATE TABLE " + tableName + "(a VARCHAR PRIMARY KEY, b VARCHAR) MAX_FILESIZE=10240, SALT_BUCKETS = 4");
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES(?,?)");
        int rowCount = 0;
        for (int c1 = 97; c1 <= 122; ++c1) {
            for (int c2 = 97; c2 <= 122; ++c2) {
                String pk = Character.toString((char)c1) + Character.toString((char)c2);
                stmt.setString(1, pk);
                stmt.setString(2, PAYLOAD);
                stmt.execute();
                if (++rowCount % 25 != 0) continue;
                conn.commit();
            }
        }
        conn.commit();
        ConnectionQueryServices services = conn.unwrap(PhoenixConnection.class).getQueryServices();
        try (Admin admin = services.getAdmin();){
            admin.flush(TableName.valueOf((String)tableName));
        }
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testManualSplit() throws Exception {
        int nRegions;
        String tableName = SkipScanAfterManualSplitIT.generateUniqueName();
        byte[] tableNameBytes = Bytes.toBytes((String)tableName);
        SkipScanAfterManualSplitIT.initTable(tableName);
        Connection conn = SkipScanAfterManualSplitIT.getConnection();
        ConnectionQueryServices services = conn.unwrap(PhoenixConnection.class).getQueryServices();
        int queryTimeout = services.getProps().getInt("phoenix.query.timeoutMs", 600000);
        int nInitialRegions = nRegions = services.getAllTableRegions(tableNameBytes, queryTimeout).size();
        try (Admin admin = services.getAdmin();){
            admin.split(TableName.valueOf((String)tableName));
            for (int nTries = 0; nRegions == nInitialRegions && nTries < 10; ++nTries) {
                Thread.sleep(1000L);
                nRegions = services.getAllTableRegions(tableNameBytes, queryTimeout).size();
            }
            Assert.assertEquals((long)nRegions, (long)nInitialRegions);
            int nRows = 2;
            String query = "SELECT count(*) FROM " + tableName + " WHERE a IN ('tl','jt',' a',' b',' c',' d')";
            ResultSet rs1 = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs1.next());
            nRegions = services.getAllTableRegions(tableNameBytes, queryTimeout).size();
            Assert.assertNotEquals((long)nRegions, (long)nInitialRegions);
            Assert.assertEquals((long)nRows, (long)rs1.getInt(1));
        }
    }

    private static byte[] bytesToRowKey(byte[] ... byteArrays) {
        ByteBuffer buffer = ByteBuffer.allocate(54);
        for (byte[] byteArray : byteArrays) {
            buffer.put(byteArray);
        }
        return buffer.array();
    }

    private static byte[] getRegionBoundary(int salt, String orgId, String parentId, long invertedDate, String entityId) {
        return SkipScanAfterManualSplitIT.bytesToRowKey({(byte)salt}, Bytes.toBytes((String)orgId), Bytes.toBytes((String)parentId), Bytes.toBytes((long)invertedDate), Bytes.toBytes((String)entityId));
    }

    private static byte[] getSaltBoundary(int salt) {
        return SkipScanAfterManualSplitIT.bytesToRowKey(new byte[][]{{(byte)salt}});
    }

    @Test
    public void testSkipScanInListOfRVCAfterManualSplit() throws SQLException {
        String[] expectedParentIds;
        Connection conn = SkipScanAfterManualSplitIT.getConnection();
        String tableName = SkipScanAfterManualSplitIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + " ( organization_id CHAR(15) NOT NULL, parent_id CHAR(15) NOT NULL, created_date DATE NOT NULL, entity_history_id CHAR(15) NOT NULL, created_by_id VARCHAR CONSTRAINT pk PRIMARY KEY (organization_id, parent_id, created_date DESC, entity_history_id)) SALT_BUCKETS = 16 SPLIT ON (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement ddlStmt = conn.prepareStatement(ddl);
        for (int i = 0; i < REGION_BOUNDS.length; ++i) {
            ddlStmt.setBytes(i + 1, REGION_BOUNDS[i]);
        }
        ddlStmt.execute();
        conn.commit();
        String upsertPrefix = "UPSERT INTO " + tableName + " VALUES ( '00Dxx0000001gER', ";
        conn.createStatement().executeUpdate(upsertPrefix + "'001xx000003DGr4', TO_DATE('2014-07-11 20:53:01'), '017xx0000022MmH', '005xx000001Sv21' )");
        conn.createStatement().executeUpdate(upsertPrefix + "'001xx000003DGr5', TO_DATE('2014-07-11 20:53:01'), '017xx0000022Mln', '005xx000001Sv21' )");
        conn.createStatement().executeUpdate(upsertPrefix + "'001xx000003DGsy', TO_DATE('2014-07-11 20:53:01'), '017xx0000022MsO', '005xx000001Sv21' )");
        conn.createStatement().executeUpdate(upsertPrefix + "'001xx000003DGsy', TO_DATE('2014-07-11 20:53:01'), '017xx0000022MsS', '005xx000001Sv21' )");
        conn.createStatement().executeUpdate(upsertPrefix + "'001xx000003DGtE', TO_DATE('2014-07-11 20:53:01'), '017xx0000022Mnx', '005xx000001Sv21' )");
        conn.createStatement().executeUpdate(upsertPrefix + "'001xx000003DGtn', TO_DATE('2014-07-11 20:53:02'), '017xx0000022Nmv', '005xx000001Sv21' )");
        conn.commit();
        String sql = "SELECT CREATED_BY_ID, PARENT_ID FROM " + tableName + " WHERE ORGANIZATION_ID='00Dxx0000001gER' AND (PARENT_ID,CREATED_DATE,ENTITY_HISTORY_ID)  IN  (('001xx000003DGr4',TO_DATE('2014-07-11 20:53:01'),'017xx0000022MmH'),('001xx000003DGr5',TO_DATE('2014-07-11 20:53:01'),'017xx0000022Mln'),('001xx000003DGsy',TO_DATE('2014-07-11 20:53:01'),'017xx0000022MsO'),('001xx000003DGsy',TO_DATE('2014-07-11 20:53:01'),'017xx0000022MsS'),('001xx000003DGtE',TO_DATE('2014-07-11 20:53:01'),'017xx0000022Mnx'),('001xx000003DGtn',TO_DATE('2014-07-11 20:53:02'),'017xx0000022Nmv')) ORDER BY PARENT_ID";
        ResultSet rs = conn.createStatement().executeQuery(sql);
        String expectedCreatedById = "005xx000001Sv21";
        for (String expectedParentId : expectedParentIds = new String[]{"001xx000003DGr4", "001xx000003DGr5", "001xx000003DGsy", "001xx000003DGsy", "001xx000003DGtE", "001xx000003DGtn"}) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"005xx000001Sv21", (Object)rs.getString(1));
            Assert.assertEquals((Object)expectedParentId, (Object)rs.getString(2));
        }
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testMinMaxRangeIntersection() throws Exception {
        Connection conn = SkipScanAfterManualSplitIT.getConnection();
        String tableName = SkipScanAfterManualSplitIT.generateUniqueName();
        PreparedStatement stmt = conn.prepareStatement("create table " + tableName + "(pk1 UNSIGNED_TINYINT NOT NULL, pk2 UNSIGNED_TINYINT NOT NULL, kv VARCHAR CONSTRAINT pk PRIMARY KEY (pk1, pk2)) SALT_BUCKETS=4 SPLIT ON (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        stmt.setBytes(1, new byte[]{0, 1, 1});
        stmt.setBytes(2, new byte[]{0, 2, 1});
        stmt.setBytes(3, new byte[]{0, 3, 1});
        stmt.setBytes(4, new byte[]{1, 1, 1});
        stmt.setBytes(5, new byte[]{1, 2, 1});
        stmt.setBytes(6, new byte[]{1, 3, 1});
        stmt.setBytes(7, new byte[]{2, 1, 1});
        stmt.setBytes(8, new byte[]{2, 2, 1});
        stmt.setBytes(9, new byte[]{2, 3, 1});
        stmt.setBytes(10, new byte[]{3, 1, 1});
        stmt.setBytes(11, new byte[]{3, 2, 1});
        stmt.setBytes(12, new byte[]{3, 3, 1});
        stmt.execute();
        ResultSet rs = conn.createStatement().executeQuery("select count(kv) from " + tableName + " where pk1 <= 3 and (pk1,PK2) >= (3, 1)");
        Assert.assertTrue((boolean)rs.next());
    }

    static {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < 1024; ++i) {
            buf.append('a');
        }
        PAYLOAD = buf.toString();
        REGION_BOUNDS = new byte[][]{SkipScanAfterManualSplitIT.getRegionBoundary(0, "00Dxx0000001gER", "001xx000003DGz2", 9223370631742791807L, "017xx0000022OGX"), SkipScanAfterManualSplitIT.getRegionBoundary(0, "00Dxx0000001gER", "001xx000003DHlF", 9223370631742760807L, "017xx0000022WMz"), SkipScanAfterManualSplitIT.getRegionBoundary(0, "00Dxx0000001gER", "001xx000003DINU", 9223370631742737807L, "017xx0000022dPO"), SkipScanAfterManualSplitIT.getSaltBoundary(1), SkipScanAfterManualSplitIT.getRegionBoundary(1, "00Dxx0000001gER", "001xx000003DGu0", 9223370631742793807L, "017xx0000022Nes"), SkipScanAfterManualSplitIT.getRegionBoundary(1, "00Dxx0000001gER", "001xx000003DHfN", 9223370631742900807L, "017xx0000022GtM"), SkipScanAfterManualSplitIT.getRegionBoundary(1, "00Dxx0000001gER", "001xx000003DIMd", 9223370631742737807L, "017xx0000022cw6"), SkipScanAfterManualSplitIT.getSaltBoundary(2), SkipScanAfterManualSplitIT.getRegionBoundary(2, "00Dxx0000001gER", "001xx000003DGyV", 9223370631742791807L, "017xx0000022OJn"), SkipScanAfterManualSplitIT.getRegionBoundary(2, "00Dxx0000001gER", "001xx000003DHk4", 9223370631742760807L, "017xx0000022Wb0"), SkipScanAfterManualSplitIT.getRegionBoundary(2, "00Dxx0000001gER", "001xx000003DIRW", 9223370631742736807L, "017xx0000022dVq"), SkipScanAfterManualSplitIT.getSaltBoundary(3), SkipScanAfterManualSplitIT.getRegionBoundary(3, "00Dxx0000001gER", "001xx000003DGul", 9223370631742793807L, "017xx0000022NMC"), SkipScanAfterManualSplitIT.getRegionBoundary(3, "00Dxx0000001gER", "001xx000003DHgC", 9223370631742762807L, "017xx0000022WAK"), SkipScanAfterManualSplitIT.getRegionBoundary(3, "00Dxx0000001gER", "001xx000003DIMV", 9223370631742737807L, "017xx0000022d2P"), SkipScanAfterManualSplitIT.getSaltBoundary(4), SkipScanAfterManualSplitIT.getRegionBoundary(4, "00Dxx0000001gER", "001xx000003DGye", 9223370631742791807L, "017xx0000022NyS"), SkipScanAfterManualSplitIT.getRegionBoundary(4, "00Dxx0000001gER", "001xx000003DHiz", 9223370631742762807L, "017xx0000022Vz3"), SkipScanAfterManualSplitIT.getRegionBoundary(4, "00Dxx0000001gER", "001xx000003DILw", 9223370631742887807L, "017xx0000022HZv"), SkipScanAfterManualSplitIT.getSaltBoundary(5), SkipScanAfterManualSplitIT.getRegionBoundary(5, "00Dxx0000001gER", "001xx000003DGy7", 9223370631742791807L, "017xx0000022O8t"), SkipScanAfterManualSplitIT.getRegionBoundary(5, "00Dxx0000001gER", "001xx000003DHip", 9223370631742762807L, "017xx0000022W5R"), SkipScanAfterManualSplitIT.getRegionBoundary(5, "00Dxx0000001gER", "001xx000003DIMP", 9223370631742737807L, "017xx0000022d8h"), SkipScanAfterManualSplitIT.getSaltBoundary(6), SkipScanAfterManualSplitIT.getRegionBoundary(6, "00Dxx0000001gER", "001xx000003DGzO", 9223370631742791807L, "017xx0000022Nti"), SkipScanAfterManualSplitIT.getRegionBoundary(6, "00Dxx0000001gER", "001xx000003DHmV", 9223370631742759807L, "017xx0000022XH9"), SkipScanAfterManualSplitIT.getRegionBoundary(6, "00Dxx0000001gER", "001xx000003DISr", 9223370631742733807L, "017xx0000022e5A"), SkipScanAfterManualSplitIT.getSaltBoundary(7), SkipScanAfterManualSplitIT.getRegionBoundary(7, "00Dxx0000001gER", "001xx000003DGtW", 9223370631742916807L, "017xx0000022G7V"), SkipScanAfterManualSplitIT.getRegionBoundary(7, "00Dxx0000001gER", "001xx000003DHhw", 9223370631742762807L, "017xx0000022W2c"), SkipScanAfterManualSplitIT.getRegionBoundary(7, "00Dxx0000001gER", "001xx000003DIKn", 9223370631742740807L, "017xx0000022ceD"), SkipScanAfterManualSplitIT.getSaltBoundary(8), SkipScanAfterManualSplitIT.getRegionBoundary(8, "00Dxx0000001gER", "001xx000003DH0j", 9223370631742790807L, "017xx0000022OvN"), SkipScanAfterManualSplitIT.getRegionBoundary(8, "00Dxx0000001gER", "001xx000003DHmR", 9223370631742759807L, "017xx0000022WyU"), SkipScanAfterManualSplitIT.getRegionBoundary(8, "00Dxx0000001gER", "001xx000003DIMl", 9223370631742737807L, "017xx0000022czJ"), SkipScanAfterManualSplitIT.getSaltBoundary(9), SkipScanAfterManualSplitIT.getRegionBoundary(9, "00Dxx0000001gER", "001xx000003DGtF", 9223370631742916807L, "017xx0000022G7E"), SkipScanAfterManualSplitIT.getRegionBoundary(9, "00Dxx0000001gER", "001xx000003DHhi", 9223370631742762807L, "017xx0000022Vk1"), SkipScanAfterManualSplitIT.getRegionBoundary(9, "00Dxx0000001gER", "001xx000003DIKP", 9223370631742740807L, "017xx0000022cpA"), SkipScanAfterManualSplitIT.getSaltBoundary(10), SkipScanAfterManualSplitIT.getRegionBoundary(10, "00Dxx0000001gER", "001xx000003DGzU", 9223370631742791807L, "017xx0000022Nsb"), SkipScanAfterManualSplitIT.getRegionBoundary(10, "00Dxx0000001gER", "001xx000003DHmO", 9223370631742760807L, "017xx0000022WFU"), SkipScanAfterManualSplitIT.getRegionBoundary(10, "00Dxx0000001gER", "001xx000003DISr", 9223370631742733807L, "017xx0000022e55"), SkipScanAfterManualSplitIT.getSaltBoundary(11), SkipScanAfterManualSplitIT.getRegionBoundary(11, "00Dxx0000001gER", "001xx000003DGzB", 9223370631742791807L, "017xx0000022OLb"), SkipScanAfterManualSplitIT.getRegionBoundary(11, "00Dxx0000001gER", "001xx000003DHki", 9223370631742760807L, "017xx0000022WOU"), SkipScanAfterManualSplitIT.getRegionBoundary(11, "00Dxx0000001gER", "001xx000003DIOF", 9223370631742737807L, "017xx0000022dIS"), SkipScanAfterManualSplitIT.getSaltBoundary(12), SkipScanAfterManualSplitIT.getRegionBoundary(12, "00Dxx0000001gER", "001xx000003DH0X", 9223370631742790807L, "017xx0000022OoI"), SkipScanAfterManualSplitIT.getRegionBoundary(12, "00Dxx0000001gER", "001xx000003DHkT", 9223370631742760807L, "017xx0000022WSs"), SkipScanAfterManualSplitIT.getRegionBoundary(12, "00Dxx0000001gER", "001xx000003DILp", 9223370631742740807L, "017xx0000022cOL"), SkipScanAfterManualSplitIT.getSaltBoundary(13), SkipScanAfterManualSplitIT.getRegionBoundary(13, "00Dxx0000001gER", "001xx000003DGvw", 9223370631742793807L, "017xx0000022Ncy"), SkipScanAfterManualSplitIT.getRegionBoundary(13, "00Dxx0000001gER", "001xx000003DHi8", 9223370631742762807L, "017xx0000022VjH"), SkipScanAfterManualSplitIT.getRegionBoundary(13, "00Dxx0000001gER", "001xx000003DINt", 9223370631742737807L, "017xx0000022dLm"), SkipScanAfterManualSplitIT.getSaltBoundary(14), SkipScanAfterManualSplitIT.getRegionBoundary(14, "00Dxx0000001gER", "001xx000003DGzJ", 9223370631742791807L, "017xx0000022Nwo"), SkipScanAfterManualSplitIT.getRegionBoundary(14, "00Dxx0000001gER", "001xx000003DHls", 9223370631742760807L, "017xx0000022WH4"), SkipScanAfterManualSplitIT.getRegionBoundary(14, "00Dxx0000001gER", "001xx000003DIRy", 9223370631742736807L, "017xx0000022doL"), SkipScanAfterManualSplitIT.getSaltBoundary(15), SkipScanAfterManualSplitIT.getRegionBoundary(15, "00Dxx0000001gER", "001xx000003DGsy", 9223370631742794807L, "017xx0000022MsO"), SkipScanAfterManualSplitIT.getRegionBoundary(15, "00Dxx0000001gER", "001xx000003DHfG", 9223370631742764807L, "017xx0000022Vdz"), SkipScanAfterManualSplitIT.getRegionBoundary(15, "00Dxx0000001gER", "001xx000003DIM9", 9223370631742737807L, "017xx0000022dAT")};
    }
}

