/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class ServerExceptionIT
extends ParallelStatsDisabledIT {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServerExceptionBackToClient() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(false);
        try (Connection conn = DriverManager.getConnection(ServerExceptionIT.getUrl(), props);){
            String t1 = ServerExceptionIT.generateUniqueName();
            String ddl = "CREATE TABLE IF NOT EXISTS " + t1 + "(pk VARCHAR NOT NULL PRIMARY KEY, col1 INTEGER, col2 INTEGER)";
            ServerExceptionIT.createTestTable(ServerExceptionIT.getUrl(), ddl);
            String query = "UPSERT INTO " + t1 + " VALUES(?,?,?)";
            PreparedStatement stmt = conn.prepareStatement(query);
            stmt.setString(1, "1");
            stmt.setInt(2, 1);
            stmt.setInt(3, 0);
            stmt.execute();
            conn.commit();
            query = "SELECT * FROM " + t1 + " where col1/col2 > 0";
            stmt = conn.prepareStatement(query);
            ResultSet rs = stmt.executeQuery();
            rs.next();
            rs.getInt(1);
            Assert.fail((String)"Should have caught exception.");
        }
    }
}

